/*******************************************************************************
 * UDukeBuddyListBox generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeBuddyListBox extends UWindowListBox
    dependson(UDukeRightClickBuddyMenu);

var UDukeRightClickBuddyMenu Menu;

function Created()
{
    super.Created();
    Menu = UDukeRightClickBuddyMenu(Root.CreateWindow(class'UDukeRightClickBuddyMenu', 0, 0, 100, 100, self));
    Menu.HideWindow();
    Menu.ServerFilter = UDukeServerFilterCW(GetParent(class'UDukeServerFilterCW'));
    Menu.BuddyListBox = self;
    return;
}

function DrawItem(Canvas C, UWindowList Item, float X, float Y, float W, float h)
{
    C.Font = C.TallFont;
    C.DrawColor = LookAndFeel.GetTextColor(self);
    // End:0xF6
    if(UDukeBuddyList(Item).bSelected / )
    {        
        C.DrawColor.G = byte(int(3) -= ++ int(C.DrawColor.G));        
        C.DrawColor.B = byte(int(3) -= ++ int(C.DrawColor.B));        
    }
    ClipText(C, X, Y, UDukeBuddyList(Item).PlayerName);
    return;
}

function RMouseDown(float X, float Y)
{
    super(UWindowWindow).RMouseDown(X, Y);
    // End:0x35
    if(__NFUN_340__(SelectedItem, none))
    {
        SelectedItem.bSelected = false;
        SelectedItem = none;
    }
    SetSelected(X, Y);
    RightClickRow(X, Y, UDukeBuddyList(SelectedItem));
    return;
}

function RightClickRow(float X, float Y, UDukeBuddyList Sel)
{
    local float MenuX, MenuY;

    WindowToGlobal(X, Y, MenuX, MenuY);
    Menu.WinLeft = MenuX;
    Menu.WinTop = MenuY;
    Menu.List = Sel;
    Menu.ShowWindow();
    return;
}

function DeleteSelection()
{
    SelectedItem = none;
    return;
}

defaultproperties
{
    ItemHeight=13
    ListClass='UDukeBuddyList'
}