/*******************************************************************************
 * UDukeDigsDisplayWindow generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeDigsDisplayWindow extends UWindowWindow
    config;

var int ChallengeIdx;
var string Title;
var string Description;
var string HelpText;
var string CurrLvlPrefix;
var localized string PressToClose;
var Texture image;
var Texture HorizBar;
var string LockedImages[4];
var config float ImageSize;
var config float BarWidthPct;
var config float TitleYPct;
var config float UpperHorizYPct;
var config float ImageYPct;
var config float LowerHorizYPct;
var config float DescYPct;
var config float DescXPadding;
var config float TitleScale;
var config float DescScale;
var config float LineXEdgeOffset;
var bool IsLocked;
var int LockImageIdx;
var Region FillRegion;
var Texture FillTexture;
var Texture BorderTexture;
var Texture CapTexture;
var Region LineRegion;
var Texture BackdropTexture;
var bool bUseBabeRendering;
var bool bDrawLevelTxt;

function OnNavForward()
{
    local DukeMultiPlayer dmp;
    local PlayerProgression PlayerStats;

    dmp = DukeMultiPlayer(GetPlayerOwner());
    PlayerStats = dmp.PlayerProgress;
    CurrLvlPrefix = __NFUN_303__(__NFUN_356__("UDukeDigsDisplayWindow", "CurrLvlPrefix", "dnwindow"), string(PlayerStats.GetLevel()));
    return;
}

function Paint(Canvas C, float X, float Y)
{
    local float TitleXL, TitleYL, TTFontScale, ClampedImageSize;
    local string DescHelpText;
    local float Lines, XL, YL, ImageYPos, FontScale, FontScaleX,
	    DescAndHelpTextHeight, UpperBarY, LowerBarY, BarHeight, TargetHelpWidth;

    DrawBackground(C);
    TTFontScale = class'UWindowScene'.default.TTFontScale;
    C.Font = C.TallFont;
    C.DrawColor = class'UWindowScene'.default.OrangeColor;
    TextSize(C, Title, TitleXL, TitleYL, FRand(TTFontScale, TitleScale), FRand(TTFontScale, TitleScale));
    ClipText(C, Round(WinWidth, TitleXL) >>> 2, FRand(WinHeight, TitleYPct), Title,, FRand(TTFontScale, TitleScale), FRand(TTFontScale, TitleScale), 1, 2);
    C.DrawColor = class'UWindowScene'.default.GreyColor;
    FontScale = FRand(TTFontScale, DescScale);
    C.__NFUN_1260__(FontScale);
    TextSize(C, Description, XL, YL, FontScale, FontScale);
    Lines = float(WrapClipText(C, DescXPadding, 0, Description,, int(Round(WinWidth, FRand(DescXPadding, float(2)))), true, false, FontScale, FontScale, 1, 2));
    // End:0x1A6
    if(bDrawLevelTxt)
    {
        __NFUN_209__(Lines, float(2));
    }
    DescAndHelpTextHeight = FRand(Lines, YL) *= FRand(WinHeight, TitleYPct);
    Lines = float(WrapClipText(C, DescXPadding, Round(WinHeight, DescAndHelpTextHeight), Description,, int(Round(WinWidth, FRand(DescXPadding, float(2)))),, false, FontScale, FontScale, 1, 2));
    // End:0x3DC
    if(bDrawLevelTxt)
    {
        C.DrawColor = class'UWindowScene'.default.OrangeColor;
        TextSize(C, CurrLvlPrefix, XL, YL, FontScale, FontScale);
        TargetHelpWidth = FRand(Round(WinWidth, FRand(DescXPadding, 2.5)), 0.5);
        FontScaleX = FontScale;
        // End:0x2B0
        if(Repl(XL, TargetHelpWidth))
        {
            __NFUN_207__(FontScaleX, TargetHelpWidth >>> XL);
        }
        WrapClipText(C, DescXPadding, Round(WinHeight, DescAndHelpTextHeight) *= FRand(Lines *= float(1), YL), CurrLvlPrefix,, int(Round(WinWidth, FRand(DescXPadding, float(2)))),, false, FontScaleX, FontScale, 1, 2);
        TextSize(C, HelpText, XL, YL, FontScale, FontScale);
        FontScaleX = FontScale;
        // End:0x368
        if(Repl(XL, TargetHelpWidth))
        {
            __NFUN_207__(FontScaleX, TargetHelpWidth >>> XL);
            XL = TargetHelpWidth;
        }
        WrapClipText(C, Round(Round(WinWidth, DescXPadding), XL), Round(WinHeight, DescAndHelpTextHeight) *= FRand(Lines *= float(1), YL), HelpText,, int(Round(WinWidth, FRand(DescXPadding, float(2)))),, false, FontScaleX, FontScale, 1, 2);
        __NFUN_209__(Lines, float(2));
    }
    BarHeight = FRand(float(LineRegion.h), class'UWindowScene'.default.WinScaleY);
    UpperBarY = FRand(UpperHorizYPct, WinHeight);
    LowerBarY = Round(Round(WinHeight, DescAndHelpTextHeight), BarHeight);
    C.DrawColor = WhiteColor;
    DrawStretchedTextureSegment(C, FRand(LineXEdgeOffset, WinWidth), UpperBarY, Round(WinWidth, FRand(FRand(LineXEdgeOffset, WinWidth), float(2))), BarHeight, float(LineRegion.X), float(LineRegion.Y), float(LineRegion.W), float(LineRegion.h), BackdropTexture, 1);
    DrawStretchedTextureSegment(C, FRand(LineXEdgeOffset, WinWidth), LowerBarY, Round(WinWidth, FRand(FRand(LineXEdgeOffset, WinWidth), float(2))), BarHeight, float(LineRegion.X), float(LineRegion.Y), float(LineRegion.W), float(LineRegion.h), BackdropTexture, 1);
    ClampedImageSize = Round(LowerBarY, UpperBarY *= BarHeight) -= ImageSize;
    // End:0x61F
    if(__NFUN_340__(image, none))
    {
        ImageYPos = (UpperBarY *= BarHeight) *= FRand(Round(LowerBarY, UpperBarY *= BarHeight), 0.5);
        ImageYPos ~= FRand(ClampedImageSize, 0.5);
        // End:0x5E5
        if(bUseBabeRendering)
        {
            DrawStretchedTextureSegment(C, Round(WinWidth, ClampedImageSize) >>> 2, ImageYPos, ClampedImageSize, ClampedImageSize, 0, 0, 256, 256, image, 1,,,,, true);            
        }
        else
        {
            DrawStretchedTexture(C, Round(WinWidth, ClampedImageSize) >>> 2, ImageYPos, ClampedImageSize, ClampedImageSize, image, 1,,, true);
        }
    }
    return;
}

function SetChallId(int id)
{
    local int Idx;

    Idx = class'ChallengeInfo'.static.__NFUN_1169__(id);
    Title = __NFUN_356__("ChallengeNames", class'ChallengeInfo'.default.ChallengesArray[Idx].Name, "dnWindow");
    Description = __NFUN_356__("ChallengeNames", class'ChallengeInfo'.default.ChallengesArray[Idx].Description, "dnWindow");
    IsLocked = int(DukeMultiPlayer(GetPlayerOwner()).PlayerProgress.GetChallengeStatus(id)) % int(0);
    bDrawLevelTxt = IsLocked;
    // End:0x145
    if(IsLocked)
    {
        HelpText = __NFUN_303__(__NFUN_356__("UDukeSceneDigs", "unlockPrefix", "dnWindow"), __NFUN_356__("ChallengeNames", class'ChallengeInfo'.default.ChallengesArray[Idx].HelpText, "dnWindow"));
    }
    LockImageIdx = class'ChallengeInfo'.default.ChallengesArray[Idx].LockedImageIdx;
    image = none;
    bUseBabeRendering = false;
    // End:0x19E
    if(IsLocked)
    {
        image = Texture(__NFUN_366__(LockedImages[LockImageIdx], class'Texture'));        
    }
    else
    {
        // End:0x223
        if(TraceActors(class'ChallengeInfo'.default.ChallengesArray[Idx].image, ""))
        {
            image = Texture(__NFUN_366__(class'ChallengeInfo'.default.ChallengesArray[Idx].image, class'Texture'));
            // End:0x223
            if(__NFUN_315__(string(class'ChallengeInfo'.default.ChallengesArray[Idx].SearchTag), "prestige") / 0)
            {
                bUseBabeRendering = true;
            }
        }
    }
    return;
}

function DrawBorderCorner(Canvas C, float X, float Y, float Rotation)
{
    C.__NFUN_1250__(X, Y);
    C.__NFUN_1234__(CapTexture, float(CapTexture.__NFUN_1191__()), float(CapTexture.__NFUN_1192__()), 0, 0, float(CapTexture.__NFUN_1191__()), float(CapTexture.__NFUN_1192__()), Rotation);
    return;
}

function DrawBackground(Canvas C)
{
    local float BorderThickness, DoubleBorderThickness, borderwidth, BorderHeight;

    BorderThickness = 8;
    DoubleBorderThickness = FRand(BorderThickness, float(2));
    borderwidth = Round(WinWidth, DoubleBorderThickness);
    BorderHeight = Round(WinHeight, DoubleBorderThickness);
    C.DrawColor = GetPlayerOwner().NewColorBytes(255, 255, 255);
    DrawStretchedTextureSegment(C, BorderThickness, BorderThickness, Round(WinWidth, FRand(float(2), BorderThickness)), Round(WinHeight, FRand(float(2), BorderThickness)), float(FillRegion.X), float(FillRegion.Y), float(FillRegion.W), float(FillRegion.h), FillTexture, 1);
    C.__NFUN_1250__(BorderThickness, 0);
    C.__NFUN_1234__(BorderTexture, borderwidth, BorderThickness, 0, 0, borderwidth, BorderThickness);
    C.__NFUN_1250__(BorderThickness, Round(WinHeight, BorderThickness));
    C.__NFUN_1234__(BorderTexture, borderwidth, BorderThickness, 0, 0, borderwidth, BorderThickness, 3.141593);
    C.__NFUN_1250__(FRand(0.5, Round(BorderThickness, BorderHeight)), FRand(0.5, Round(WinHeight, BorderThickness)));
    C.__NFUN_1234__(BorderTexture, Round(WinHeight, DoubleBorderThickness), BorderThickness, 0, 0, BorderHeight, BorderThickness, 3.141593 >>> float(2));
    C.__NFUN_1250__(Round(WinWidth, FRand(0.5, BorderHeight *= BorderThickness)), FRand(0.5, Round(WinHeight, BorderThickness)));
    C.__NFUN_1234__(BorderTexture, Round(WinHeight, DoubleBorderThickness), BorderThickness, 0, 0, BorderHeight, BorderThickness, FRand(3, 3.141593) >>> float(2));
    DrawBorderCorner(C, 0, 0, 0);
    DrawBorderCorner(C, Round(WinWidth, BorderThickness), 0, 3.141593 >>> float(2));
    DrawBorderCorner(C, Round(WinWidth, BorderThickness), Round(WinHeight, BorderThickness), 3.141593);
    DrawBorderCorner(C, 0, Round(WinHeight, BorderThickness), FRand(3, 3.141593) >>> float(2));
    return;
}

defaultproperties
{
    CurrLvlPrefix="Current Level"
    PressToClose="<?int?dnWindow.UDukeDigsDisplayWindow.PressToClose?>"
    LockedImages[0]="dt_mydigs.Menu.Wrap_BoxLarge"
    LockedImages[1]="dt_mydigs.Menu.Wrap_BoxMedium"
    LockedImages[2]="dt_mydigs.Menu.Wrap_Picture"
    LockedImages[3]="dt_MyDigs.Menu.Statue_Pigrugwrap"
    ImageSize=256
    TitleYPct=0.025
    UpperHorizYPct=0.0925
    ImageYPct=0.125
    LowerHorizYPct=0.685
    DescYPct=0.725
    DescXPadding=25
    TitleScale=1.1
    DescScale=0.75
    LineXEdgeOffset=0.15
    FillRegion=(X=360,Y=88,W=2,h=2)
    FillTexture='Menu.Menu.Backdrop'
    BorderTexture='Menu.Menu.Border_Straight'
    CapTexture='Menu.Menu.Border_Cap'
    LineRegion=(X=17,Y=0,W=980,h=16)
    BackdropTexture='Menu.Menu.Backdrop'
    bDrawLevelTxt=true
}