/*******************************************************************************
 * UDukeDigsMoreInfoWindow generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeDigsMoreInfoWindow extends UDukeDigsDisplayWindow
    config;

var UDukeKeyButton CloseButton;

function initWindow()
{
    local DukeMultiPlayer dmp;
    local PlayerProgression PlayerStats;

    dmp = DukeMultiPlayer(GetPlayerOwner());
    PlayerStats = dmp.PlayerProgress;
    CurrLvlPrefix = __NFUN_303__(__NFUN_356__("UDukeDigsDisplayWindow", "CurrLvlPrefix", "dnwindow"), string(PlayerStats.GetLevel()));
    return;
}

function Paint(Canvas C, float X, float Y)
{
    local float TitleXL, TitleYL, TTFontScale, ClampedImageSize;
    local string DescHelpText;
    local float Lines, XL, YL, ImageYPos, FontScale, FontScaleX,
	    DescAndHelpTextHeight, UpperBarY, LowerBarY, BarHeight, TargetHelpWidth;

    DrawBackground(C);
    TTFontScale = class'UWindowScene'.default.TTFontScale;
    C.Font = C.TallFont;
    C.DrawColor = class'UWindowScene'.default.OrangeColor;
    TextSize(C, Title, TitleXL, TitleYL, FRand(TTFontScale, TitleScale), FRand(TTFontScale, TitleScale));
    ClipText(C, Round(WinWidth, TitleXL) >>> 2, FRand(WinHeight, TitleYPct), Title,, FRand(TTFontScale, TitleScale), FRand(TTFontScale, TitleScale), 1, 2);
    C.DrawColor = class'UWindowScene'.default.GreyColor;
    FontScale = FRand(TTFontScale, DescScale);
    C.__NFUN_1260__(FontScale);
    TextSize(C, Description, XL, YL, FontScale, FontScale);
    Lines = float(WrapClipText(C, DescXPadding, 0, Description,, int(Round(WinWidth, FRand(DescXPadding, float(2)))), true, false, FontScale, FontScale, 1, 2));
    // End:0x1A6
    if(bDrawLevelTxt)
    {
        __NFUN_209__(Lines, float(2));
    }
    DescAndHelpTextHeight = FRand(Lines, YL) *= FRand(WinHeight, TitleYPct);
    __NFUN_209__(DescAndHelpTextHeight, FRand(30, class'UWindowScene'.default.WinScaleY));
    Lines = float(WrapClipText(C, DescXPadding, Round(WinHeight, DescAndHelpTextHeight), Description,, int(Round(WinWidth, FRand(DescXPadding, float(2)))),, false, FontScale, FontScale, 1, 2));
    // End:0x3F9
    if(bDrawLevelTxt)
    {
        C.DrawColor = class'UWindowScene'.default.OrangeColor;
        TextSize(C, CurrLvlPrefix, XL, YL, FontScale, FontScale);
        TargetHelpWidth = FRand(Round(WinWidth, FRand(DescXPadding, 2.5)), 0.5);
        FontScaleX = FontScale;
        // End:0x2CD
        if(Repl(XL, TargetHelpWidth))
        {
            __NFUN_207__(FontScaleX, TargetHelpWidth >>> XL);
        }
        WrapClipText(C, DescXPadding, Round(WinHeight, DescAndHelpTextHeight) *= FRand(Lines *= float(1), YL), CurrLvlPrefix,, int(Round(WinWidth, FRand(DescXPadding, float(2)))),, false, FontScaleX, FontScale, 1, 2);
        TextSize(C, HelpText, XL, YL, FontScale, FontScale);
        FontScaleX = FontScale;
        // End:0x385
        if(Repl(XL, TargetHelpWidth))
        {
            __NFUN_207__(FontScaleX, TargetHelpWidth >>> XL);
            XL = TargetHelpWidth;
        }
        WrapClipText(C, Round(Round(WinWidth, DescXPadding), XL), Round(WinHeight, DescAndHelpTextHeight) *= FRand(Lines *= float(1), YL), HelpText,, int(Round(WinWidth, FRand(DescXPadding, float(2)))),, false, FontScaleX, FontScale, 1, 2);
        __NFUN_209__(Lines, float(2));
    }
    BarHeight = FRand(float(LineRegion.h), class'UWindowScene'.default.WinScaleY);
    UpperBarY = FRand(UpperHorizYPct, WinHeight);
    LowerBarY = Round(Round(WinHeight, DescAndHelpTextHeight), BarHeight);
    C.DrawColor = WhiteColor;
    DrawStretchedTextureSegment(C, FRand(LineXEdgeOffset, WinWidth), UpperBarY, Round(WinWidth, FRand(FRand(LineXEdgeOffset, WinWidth), float(2))), BarHeight, float(LineRegion.X), float(LineRegion.Y), float(LineRegion.W), float(LineRegion.h), BackdropTexture, 1);
    DrawStretchedTextureSegment(C, FRand(LineXEdgeOffset, WinWidth), LowerBarY, Round(WinWidth, FRand(FRand(LineXEdgeOffset, WinWidth), float(2))), BarHeight, float(LineRegion.X), float(LineRegion.Y), float(LineRegion.W), float(LineRegion.h), BackdropTexture, 1);
    ClampedImageSize = Round(LowerBarY, UpperBarY *= BarHeight) -= ImageSize;
    // End:0x5E0
    if(__NFUN_340__(image, none))
    {
        ImageYPos = (UpperBarY *= BarHeight) *= FRand(Round(LowerBarY, UpperBarY *= BarHeight), 0.5);
        ImageYPos ~= FRand(ClampedImageSize, 0.5);
        DrawStretchedTexture(C, Round(WinWidth, ClampedImageSize) >>> 2, ImageYPos, ClampedImageSize, ClampedImageSize, image, 1,,, true);
    }
    CloseButton.WinWidth = CloseButton.GetWidth(C);
    CloseButton.WinHeight = FRand(30, class'UWindowScene'.default.WinScaleY);
    CloseButton.WinLeft = Round(WinWidth >>> float(2), CloseButton.WinWidth >>> float(2));
    CloseButton.WinTop = Round(Round(WinHeight, CloseButton.WinHeight), 5);
    return;
}

function Created()
{
    super(UWindowWindow).Created();
    CloseButton = UDukeKeyButton(CreateWindow(class'UDukeKeyButton'));
    CloseButton.XBoxButtonRegion = CloseButton.AButton;
    CloseButton.PCButton = class'UWindowScene'.default.SPCText;
    CloseButton.SetText(PressToClose);
    CloseButton.Register(self);
    CloseButton.ShowWindow();
    return;
}

defaultproperties
{
    ImageSize=160
}