/*******************************************************************************
 * UDukeGBMessageBox generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeGBMessageBox extends UDukeSuperMessageBox;

var UDukeListSlider SortType;
var UDukeListSlider filterMap;
var UDukeListSlider filterMode;
var UDukeListSlider FilterType;
var int ArrowAlignment;
var localized string SortTypeText;
var localized string FilterMapText;
var localized string FilterModeText;
var localized string FilterTypeText;
var float SliderWidth;
var float SliderHeight;
var int NumSliders;
var bool bDisableFilterType;

function Created()
{
    super.Created();
    SortType = UDukeListSlider(CreateWindow(class'UDukeListSlider', 1, 1, 1, 1, self));
    filterMap = UDukeListSlider(CreateWindow(class'UDukeListSlider', 1, 1, 1, 1, self));
    filterMode = UDukeListSlider(CreateWindow(class'UDukeListSlider', 1, 1, 1, 1, self));
    FilterType = UDukeListSlider(CreateWindow(class'UDukeListSlider', 1, 1, 1, 1, self));
    SortType.LookAndFeel = LookAndFeel;
    filterMap.LookAndFeel = LookAndFeel;
    filterMode.LookAndFeel = LookAndFeel;
    FilterType.LookAndFeel = LookAndFeel;
    SortType.SetText(SortTypeText);
    filterMap.SetText(FilterMapText);
    filterMode.SetText(FilterModeText);
    FilterType.SetText(FilterTypeText);
    DialogType = 25;
    SortType.ArrowAnchorPoint = 0;
    filterMap.ArrowAnchorPoint = 0;
    filterMode.ArrowAnchorPoint = 0;
    FilterType.ArrowAnchorPoint = 0;
    SortType.bCyclic = true;
    filterMap.bCyclic = true;
    filterMode.bCyclic = true;
    FilterType.bCyclic = true;
    SortType.NavUp = FilterType;
    filterMap.NavUp = SortType;
    filterMode.NavUp = filterMap;
    FilterType.NavUp = filterMode;
    SortType.NavDown = filterMap;
    filterMap.NavDown = filterMode;
    filterMode.NavDown = FilterType;
    FilterType.NavDown = SortType;
    ChildInFocus = SortType;
    SortType.Register(self);
    filterMap.Register(self);
    filterMode.Register(self);
    FilterType.Register(self);
    SortType.ClearNoKeyboard();
    filterMap.ClearNoKeyboard();
    filterMode.ClearNoKeyboard();
    FilterType.ClearNoKeyboard();
    return;
}

function SetupMessageBox(string Title, optional string Message, optional string Affirm, optional string Cancel, optional int TimeOut)
{
    super.SetupMessageBox(Title, Message, Affirm, Cancel, TimeOut);
    ChildInFocus = SortType;
    return;
}

function AddSortEntry(string Label, coerce string ColumnIdx)
{
    __NFUN_355__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(string(self), "::AddSortEntry("), Label), ", "), ColumnIdx), ")"));
    SortType.AddItem(Label, ColumnIdx);
    return;
}

function AddFilterMapEntry(string Label, coerce string ColumnIdx)
{
    filterMap.AddItem(Label, ColumnIdx);
    return;
}

function AddFilterModeEntry(string Label, coerce string ColumnIdx)
{
    filterMode.AddItem(Label, ColumnIdx);
    return;
}

function AddFilterTypeEntry(string Label, coerce string ColumnIdx)
{
    FilterType.AddItem(Label, ColumnIdx);
    return;
}

function int GetSelectedSortType()
{
    return int(SortType.SelectedItem.Value);
    return;
}

function int GetSelectedFilterMap()
{
    return int(filterMap.SelectedItem.Value);
    return;
}

function int GetSelectedFilterMode()
{
    return int(filterMode.SelectedItem.Value);
    return;
}

function int GetSelectedFilterType()
{
    return int(FilterType.SelectedItem.Value);
    return;
}

function Paint(Canvas C, float X, float Y)
{
    local float XL, YL, YPadding, OrigX, OrigY;

    ClippingRegion.X = 0;
    ClippingRegion.Y = 0;
    ClippingRegion.W = int(WinWidth);
    ClippingRegion.h = int(WinHeight);
    DrawBackground(C);
    C.DrawColor = class'UWindowScene'.default.GreyColor;
    YPadding = EdgeBuffer;
    C.Font = C.BlockFont;
    TextSize(C, TitleText, XL, YL, class'UWindowScene'.default.TTFontScale, class'UWindowScene'.default.TTFontScale);
    ClipText(C, Round(WinWidth, XL) >>> 2, YPadding, TitleText,, class'UWindowScene'.default.TTFontScale, class'UWindowScene'.default.TTFontScale);
    __NFUN_209__(YPadding, YL *= SpacingBuffer);
    __NFUN_209__(YPadding, SetupSlider(SortType, YPadding));
    __NFUN_209__(YPadding, SetupSlider(filterMap, YPadding));
    __NFUN_209__(YPadding, SetupSlider(filterMode, YPadding));
    // End:0x187
    if(bDisableFilterType / )
    {
    }
    return;
}

function float SetupSlider(UDukeListSlider slider, float YPadding)
{
    slider.WinTop = YPadding;
    slider.WinWidth = FRand(SliderWidth, class'UWindowScene'.default.WinScaleY);
    slider.WinHeight = FRand(SliderHeight, class'UWindowScene'.default.WinScaleY);
    slider.WinLeft = Round(WinWidth, slider.WinWidth) >>> 2;
    slider.ArrowLeft = FRand(float(ArrowAlignment), class'UWindowScene'.default.WinScaleY);
    return slider.WinHeight *= SpacingBuffer;
    return;
}

function GetDialogDimensions(Canvas C, out float X, out float Y, out float W, out float h)
{
    local float XL, YL, BXL, BYL, frameWidth, frameHeight,
	    tmpWidth;

    local int Lines;

    frameWidth = 0;
    frameHeight = 0;
    // End:0x185
    if(__NFUN_308__(MessageText, ""))
    {
        C.Font = C.BlockFont;
        TextSize(C, TitleText, XL, YL, class'UWindowScene'.default.TTFontScale, class'UWindowScene'.default.TTFontScale);
        frameWidth = (EdgeBuffer *= XL) *= EdgeBuffer;
        // End:0xE7
        if(__NFUN_200__(frameWidth, FRand(SliderWidth, class'UWindowScene'.default.WinScaleY) *= FRand(EdgeBuffer, float(2))))
        {
            frameWidth = FRand(SliderWidth, class'UWindowScene'.default.WinScaleY) *= FRand(EdgeBuffer, float(2));
        }
        frameHeight = ((EdgeBuffer *= YL) *= FRand(SpacingBuffer *= FRand(SliderHeight, class'UWindowScene'.default.WinScaleY), float(NumSliders))) *= EdgeBuffer;
        X = Round(float(C.SizeX), frameWidth) >>> 2;
        Y = Round(float(C.SizeY), frameHeight) >>> 2;
        W = frameWidth;
        h = frameHeight;
    }
    return;
}

function PerformClose()
{
    iResult = GetSelectedFilterMode();
    GetPlayerOwner().Level.PlaySoundInfo(0, MessageBoxYesSoundInfo);
    Close();
    return;
}

function WindowEvent(UWindow.UWindowWindow.WinMessage msg, Canvas C, float X, float Y, int Key)
{
    super.WindowEvent(msg, C, X, Y, Key);
    // End:0x4D
    if(int(msg) % int(6))
    {
        switch(Key)
        {
            // End:0x3B
            case int(215):
            // End:0x4A
            case int(32):
                PerformClose();
                // End:0x4D
                break;
            // End:0xFFFF
            default:
                break;
        }
    }
    else
    {
        return;
    }
}

function Tick(float Delta)
{
    local Engine.Object.EInputKey RequiredKey;

    super.Tick(Delta);
    // End:0x27
    if(GetPlayerOwner().__NFUN_994__())
    {
        RequiredKey = 215;        
    }
    else
    {
        RequiredKey = 32;
    }
    // End:0x4D
    if(GetPlayerOwner().IsSeatControllerReplicationViewer(RequiredKey) / )
    {
    }
    return;
}

defaultproperties
{
    ArrowAlignment=200
    SliderWidth=500
    SliderHeight=35
    NumSliders=4
}