/*******************************************************************************
 * UDukeGSpyLink generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeGSpyLink extends UBrowserBufferedTCPLink
    transient
    collapsecategories
    dependson(UDukeGSpyFact)
    hidecategories(movement,Collision,Lighting,LightColor);

const FoundSecureRequest = 1;
const FoundSecret = 2;
const NextIP = 3;
const NextAddress = 4;

var UDukeGSpyFact OwnerFactory;
var IpAddr MasterServerIpAddr;
var bool bOpened;
var string MasterServerAddress;
var int MasterServerTCPPort;
var int Region;
var int MasterServerTimeout;
var string GameName;
var localized string ResolveFailedError;
var localized string TimeOutError;
var localized string CouldNotConnectError;

function BeginPlay()
{
    __NFUN_362__('Tick');
    super(Actor).BeginPlay();
    return;
}

function Start()
{
    ResetBuffer();
    MasterServerIpAddr.Port = MasterServerTCPPort;
    // End:0x3F
    if(__NFUN_308__(MasterServerAddress, ""))
    {
        MasterServerAddress = "dukenet.3drealms.com";
    }
    __NFUN_1129__(MasterServerAddress);
    return;
}

function DoBufferQueueIO()
{
    super.DoBufferQueueIO();
    return;
}

function Resolved(IpAddr Addr)
{
    MasterServerIpAddr.Addr = Addr.Addr;
    // End:0x63
    if(MasterServerIpAddr.Addr % 0)
    {
        __NFUN_355__("UDukeGSpyLink: Invalid master server address, aborting.");
        return;
    }
    __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__("UDukeGSpyLink: Master Server is ", MasterServerAddress), ":"), string(MasterServerIpAddr.Port)));
    // End:0xE6
    if(__NFUN_1140__() % 0)
    {
        __NFUN_355__("UDukeGSpyLink: Error binding local port, aborting.");
        return;
    }
    __NFUN_1142__(MasterServerIpAddr);
    __NFUN_605__(float(MasterServerTimeout), false, 'MasterServerTimeoutCallback');
    return;
}

function MasterServerTimeoutCallback()
{
    // End:0x67
    if(bOpened / )
    {
        OwnerFactory.QueryFinished(false, __NFUN_302__(CouldNotConnectError, MasterServerAddress));
        __NFUN_397__('Done');
    }
    return;
}

event Closed()
{
    return;
}

function ResolveFailed()
{
    __NFUN_355__("UDukeGSpyLink: Failed to resolve master server address, aborting.");
    OwnerFactory.QueryFinished(false, __NFUN_302__(ResolveFailedError, MasterServerAddress));
    __NFUN_397__('Done');
    return;
}

event Opened()
{
    bOpened = true;
    __NFUN_361__('Tick');
    WaitFor("\\basic\\\\secure\\", 5, 1);
    return;
}

function Tick(float DeltaTime)
{
    DoBufferQueueIO();
    return;
}

function HandleServer(string Text)
{
    local string address, Port;

    // End:0x19
    if(__NFUN_308__(Text, "NoServers\\"))
    {
        return;
    }
    address = ParseDelimited(Text, ":", 1);
    Port = ParseDelimited(ParseDelimited(Text, ":", 2), "\\", 1);
    OwnerFactory.FoundServer(address, int(Port), "", GameName);
    return;
}

function GotMatch(int MatchData)
{
    switch(MatchData)
    {
        // End:0x26
        case 1:
            __NFUN_361__('Tick');
            WaitForCount(6, 5, 2);
            // End:0x11B
            break;
        // End:0x9B
        case 2:
            __NFUN_361__('Tick');
            SendBufferedData(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("\\gamename\\", GameName), "\\location\\"), string(Region)), "\\validate\\"), __NFUN_1133__(WaitResult, GameName)), "\\final\\"));
            __NFUN_397__('FoundSecretState');
            // End:0x11B
            break;
        // End:0xEA
        case 3:
            __NFUN_361__('Tick');
            // End:0xD7
            if(__NFUN_308__(WaitResult, "final\\"))
            {
                OwnerFactory.QueryFinished(true);
                __NFUN_397__('Done');                
            }
            else
            {
                WaitFor("\\", 10, 4);
            }
            // End:0x11B
            break;
        // End:0x115
        case 4:
            __NFUN_361__('Tick');
            HandleServer(WaitResult);
            WaitFor("\\", 5, 3);
            // End:0x11B
            break;
        // End:0xFFFF
        default:
            // End:0x11B
            break;
            break;
    }
    return;
}

function GotMatchTimeout(int MatchData)
{
    __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__("Timed out in master server protocol.  Waiting for ", WaitingFor), " in state "), string(MatchData)));
    OwnerFactory.QueryFinished(false, TimeOutError);
    __NFUN_397__('Done');
    return;
}

state FoundSecretState
{
    function Tick(float Delta)
    {
        global.Tick(Delta);
        // End:0x42
        if((__NFUN_1144__() / ) << )
        {
            __NFUN_397__('Done');
        }
        return;
    }
Begin:

    __NFUN_361__('Tick');
    SendBufferedData(__NFUN_302__(__NFUN_302__("\\list\\\\gamename\\", GameName), "\\final\\"));
    WaitFor("ip\\", 30, 3);
    stop;    
}

state Done
{Begin:

    __NFUN_362__('Tick');
    stop;            
}

defaultproperties
{
    ResolveFailedError="<?int?dnWindow.UDukeGSpyLink.ResolveFailedError?>"
    TimeOutError="<?int?dnWindow.UDukeGSpyLink.TimeOutError?>"
    CouldNotConnectError="<?int?dnWindow.UDukeGSpyLink.CouldNotConnectError?>"
}