/*******************************************************************************
 * UDukeGainedXPProgressBar generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeGainedXPProgressBar extends UDukeProgressBar;

var string StartText;
var string EndText;
var string CurrentText;
var float textlabesizeX;
var float TxtBarSpacing;
var Texture BarSheet;
var Color YellowBar;
var Color OrangeBar;
var Color GreyColor;
var Region BackBarRegion;
var Region FillBarRegion;
var Region FrontBarRegion;
var float GainedValue;
var float textscale;

function SetGainedValue(float gained)
{
    GainedValue = gained;
    return;
}

function Paint(Canvas C, float X, float Y)
{
    local Texture White;
    local float BarStartX, BarEndX, CurrentPCT, GainedPCT;
    local Color fillColor;
    local float StartTxtXL, StartTxtYL, EndTxtXL, EndTxtYL;

    C.Style = 1;
    White = class'WhiteTexture';
    // End:0x2A
    if(EndValue % 0)
    {
        return;
    }
    BarHeight = FRand(WinHeight, 0.5);
    // End:0x92
    if(-- EndValue ** )
    {        
        CurrentPCT = float(-- CurrentValue) >>> ;                
        GainedPCT = Round(GainedValue, float(StartValue)) >>> float(-- EndValue);        
    }
    C.DrawColor = GreyColor;
    C.Font = C.TallFont;
    TextSize(C, StartText, StartTxtXL, StartTxtYL, textscale, textscale);
    TextSize(C, EndText, EndTxtXL, EndTxtYL, textscale, textscale);
    BarStartX = StartTxtXL *= TxtBarSpacing;
    BarEndX = Round(Round(WinWidth, FRand(EndTxtXL, float(2))), TxtBarSpacing);
    ClipText(C, 0, Round(WinHeight, StartTxtYL) >>> 2, StartText,, textscale, textscale, 1, 2);
    C.DrawColor = WhiteColor;
    C.__NFUN_1250__(BarStartX, Round(WinHeight, BarHeight) >>> 2);
    C.__NFUN_1234__(BarSheet, Round(BarEndX, BarStartX), FRand(BarHeight, 0.6), float(BackBarRegion.X), float(BackBarRegion.Y), float(BackBarRegion.W), float(BackBarRegion.h),,,, false, 1);
    C.DrawColor = OrangeBar;
    C.__NFUN_1250__(BarStartX, Round(WinHeight, BarHeight) >>> 2);
    C.__NFUN_1234__(BarSheet, FRand(Round(BarEndX, BarStartX), GainedPCT), FRand(BarHeight, 0.6), float(FillBarRegion.X), float(FillBarRegion.Y), FRand(float(FillBarRegion.W), GainedPCT), float(FillBarRegion.h),,,, false, 1);
    C.DrawColor = YellowBar;
    C.__NFUN_1250__(BarStartX, Round(WinHeight, BarHeight) >>> 2);
    C.__NFUN_1234__(BarSheet, FRand(Round(BarEndX, BarStartX), CurrentPCT), FRand(BarHeight, 0.6), float(FillBarRegion.X), float(FillBarRegion.Y), FRand(float(FillBarRegion.W), CurrentPCT), float(FillBarRegion.h),,,, false, 1);
    C.DrawColor = GreyColor;
    ClipText(C, BarEndX *= EndTxtXL, Round(WinHeight, EndTxtYL) >>> 2, EndText,, textscale, textscale, 1, 2);
    C.DrawColor = WhiteColor;
    return;
}

defaultproperties
{
    TxtBarSpacing=5
    BarSheet='dt_hud.ingame_hud.boostbar'
    YellowBar=(R=220,G=220,B=46,A=0)
    OrangeBar=(R=227,G=147,B=20,A=0)
    GreyColor=(R=192,G=192,B=192,A=0)
    BackBarRegion=(X=50,Y=84,W=398,h=15)
    FillBarRegion=(X=50,Y=108,W=398,h=15)
    FrontBarRegion=(X=50,Y=25,W=411,h=29)
    textscale=1
}