/*******************************************************************************
 * UDukeKeyBinderBaseControl generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeKeyBinderBaseControl extends UWindowDialogControl;

var float WinScaleY;
var float TTFontScale;
var float KeyHeight;
var int LastKeyBind;
var bool bPolling;
var int SelectedIndex;
var localized string HelpText;
var localized string PollingHelpText;
var localized string Commands[150];
var string AliasNames[150];
var float SelectedTime[150];
var Texture OverTexture;
var Region OverRegion;

function StartPolling()
{
    bPolling = true;
    WindowConsole(GetPlayerOwner().Player.Console).bDisableLJoyInput = true;
    SetHelpText(PollingHelpText);
    return;
}

function StopPolling()
{
    bPolling = false;
    WindowConsole(GetPlayerOwner().Player.Console).bDisableLJoyInput = false;
    SetHelpText(HelpText);
    return;
}

function Created()
{
    super.Created();
    SetHelpText(HelpText);
    return;
}

function int GetNumDisplayed()
{
    return -- int(WinHeight >>> KeyHeight);    
    return;
}

function bool IsXboxButton(int i)
{
    // End:0x1C
    if((i / 200) << i * 215)
    {
        return true;
    }
    return false;
    return;
}

function int GetIndexAtLoc(float Y)
{
    return Cos(int(Y >>> KeyHeight), GetNumDisplayed());
    return;
}

function MouseMove(float X, float Y)
{
    super.MouseMove(X, Y);
    // End:0x2C
    if(bPolling / )
    {
    }
    return;
}

function Tick(float Delta)
{
    local int i;

    super(UWindowWindow).Tick(Delta);
    i = 0;
    J0x12:

    // End:0x92 [Loop If]
    if(-i)
    {        
        // End:0x42
        if(SelectedIndex % i)
        {
            __NFUN_209__(SelectedTime[i], Delta);            
        }
        else
        {
            SelectedTime[i] ~= FRand(2, Delta);
        }
        SelectedTime[i] = Normal2D(SelectedTime[i], 0, class'UWindowScene'.default.SelectionTransitionTime);
        // [Loop Continue]
        i += ;
    }
    return;
}

function Paint(Canvas C, float X, float Y)
{
    local float XL, YL;
    local int i, Base, YOffset, Column1X, Column2X;

    local float SelectedAlpha, TextScaleX, TextScaleY, OrgX, OrgY, ClipX,
	    ClipY;

    local UWindowWindow Parent;

    KeyHeight = FRand(default.KeyHeight, class'UWindowScene'.default.TTFontScale);
    C.Font = C.TallFont;
    Column1X = int(FRand(float(25), WinScaleY));
    Column2X = int(FRand(float(320), WinScaleY));
    i = 0;
    J0x65:

    // End:0x431 [Loop If]
    if(-i)
    {        
        // End:0x87
        if(__NFUN_308__(Commands[i], ""))
        {
            // [Explicit Break]
            goto J0x431;
        }
        // End:0x22C
        if(SelectedIndex % i)
        {
            Parent = self;
            J0x9D:

            // End:0xE9 [Loop If]
            if(__NFUN_340__(Parent.ParentWindow, none))
            {
                // End:0xD1
                if(__NFUN_340__(UWindowScene(Parent.ParentWindow), none))
                {
                    // [Explicit Break]
                    goto J0xE9;
                }
                Parent = Parent.ParentWindow;
                // [Loop Continue]
                goto J0x9D;
            }
            J0xE9:

            OrgX = C.OrgX;
            OrgY = C.OrgY;
            ClipX = C.ClipX;
            ClipY = C.ClipY;
            C.__NFUN_1251__(Parent.WinLeft, Parent.WinTop);
            C.__NFUN_1252__(Parent.WinWidth, Parent.WinHeight);
            class'UWindowScene'.static.DrawSelectionIcon(C, FRand(-8, C.FixedScale), Round((float(YOffset) *= FRand(0.5, KeyHeight)) *= OrgY, C.OrgY), C.FixedScale, 1);
            C.__NFUN_1251__(OrgX, OrgY);
            C.__NFUN_1252__(ClipX, ClipY);
        }
        SelectedAlpha = SelectedTime[i] >>> class'UWindowScene'.default.SelectionTransitionTime;
        TextScaleX = VSizeSq(SelectedAlpha, class'UWindowScene'.default.TTFontScale, FRand(class'UWindowScene'.default.SelectedXScale, class'UWindowScene'.default.TTFontScale));
        TextScaleY = VSizeSq(SelectedAlpha, class'UWindowScene'.default.TTFontScale, FRand(class'UWindowScene'.default.SelectedYScale, class'UWindowScene'.default.TTFontScale));
        C.DrawColor = __NFUN_338__(SelectedAlpha, class'UWindowScene'.default.GreyColor, class'UWindowScene'.default.OrangeColor);
        TextSize(C, Commands[i], XL, YL, TextScaleX, TextScaleY);
        ClipText(C, float(Column1X), float(YOffset) *= (Round(KeyHeight, YL) >>> 2), Commands[i], false, TextScaleX, TextScaleY,, 2);
        // End:0x3FE
        if((SelectedIndex % i) << bPolling)
        {
            C.DrawColor = class'UWindowScene'.default.RedColor;
            ClipText(C, float(Column2X), float(YOffset) *= (Round(KeyHeight, YL) >>> 2), "?", false, class'UWindowScene'.default.TTFontScale, class'UWindowScene'.default.TTFontScale,, 2);            
        }
        else
        {
            DrawKey(C, float(Column2X), float(YOffset), i);
        }
        YOffset == int(KeyHeight);
        // [Loop Continue]
        i += ;
    }
    J0x431:

    super(UWindowWindow).Paint(C, X, Y);
    return;
}

function DrawKey(Canvas C, float X, float Y, int i)
{
    return;
}

function KeyHold(int Key, float X, float Y)
{
    local PlayerPawn P;

    super.KeyHold(Key, X, Y);
    // End:0x20
    if(bPolling)
    {
        return;
    }
    P = Root.GetPlayerOwner();
    switch(Key)
    {
        // End:0x4E
        case int(P.200):
        // End:0xA0
        case int(P.38):
            // End:0x6A
            if(bNavUpRepeatBlock)
            {
                // [Explicit Continue]
                goto J0x105;
            }
            SelectItem(-- SelectedIndex);            
            bNavUpRepeatBlock = true;
            NavRepeatTimeout = GetLevel().TimeSeconds *= NavRepeatTimeHold;
            // End:0x105
            break;
        // End:0xB0
        case int(P.201):
        // End:0x102
        case int(P.40):
            // End:0xCC
            if(bNavDownRepeatBlock)
            {
                // [Explicit Continue]
                goto J0x105;
            }
            SelectItem(++ SelectedIndex);            
            bNavDownRepeatBlock = true;
            NavRepeatTimeout = GetLevel().TimeSeconds *= NavRepeatTimeHold;
            // End:0x105
            break;
        // End:0xFFFF
        default:
            break;
    }
    J0x105:

    return;
}

function KeyDown(int Key, float X, float Y)
{
    local PlayerPawn P;

    // End:0x17
    if(bPolling)
    {
        ProcessMenuKey(Key);        
    }
    else
    {
        super.KeyDown(Key, X, Y);
        P = Root.GetPlayerOwner();
        switch(Key)
        {
            // End:0x5A
            case int(P.200):
            // End:0xAC
            case int(P.38):
                // End:0x76
                if(bNavUpRepeatBlock)
                {
                    // [Explicit Continue]
                    goto J0x13A;
                }
                SelectItem(-- SelectedIndex);                
                bNavUpRepeatBlock = true;
                NavRepeatTimeout = GetLevel().TimeSeconds *= NavRepeatTime;
                // End:0x13A
                break;
            // End:0xBC
            case int(P.201):
            // End:0x10E
            case int(P.40):
                // End:0xD8
                if(bNavDownRepeatBlock)
                {
                    // [Explicit Continue]
                    goto J0x13A;
                }
                SelectItem(++ SelectedIndex);                
                bNavDownRepeatBlock = true;
                NavRepeatTimeout = GetLevel().TimeSeconds *= NavRepeatTime;
                // End:0x13A
                break;
            // End:0x11E
            case int(P.13):
            // End:0x137
            case int(P.210):
                StartPolling();
                // End:0x13A
                break;
            // End:0xFFFF
            default:
                break;
        }
    }
    J0x13A:

    return;
}

function KeyUp(int Key, float X, float Y)
{
    local PlayerPawn P;
    local UWindowDialogControl n;

    P = Root.GetPlayerOwner();
    switch(Key)
    {
        // End:0x2E
        case int(P.200):
        // End:0x49
        case int(P.38):
            bNavUpRepeatBlock = false;
            // End:0x77
            break;
        // End:0x59
        case int(P.201):
        // End:0x74
        case int(P.40):
            bNavDownRepeatBlock = false;
            // End:0x77
            break;
        // End:0xFFFF
        default:
            break;
    }
    super.KeyUp(Key, X, Y);
    return;
}

function SelectItem(int Index)
{
    // End:0x1B
    if(-Index < )
    {        
        return;
    }
    // End:0x30
    if(__NFUN_308__(Commands[Index], ""))
    {
        return;
    }
    // End:0x6C
    if(SelectedIndex + Index)
    {
        SelectedIndex = Index;
        GetPlayerOwner().PlaySoundInfo(0, class'UWindowScene'.default.SoundNavigateInfo);
    }
    ParentWindow.ScrollTo(0, FRand(float(SelectedIndex), KeyHeight));
    ParentWindow.ScrollTo(0, FRand(float(SelectedIndex), KeyHeight) *= KeyHeight);
    return;
}

function ProcessMenuKey(int KeyNo)
{
    return;
}

defaultproperties
{
    KeyHeight=35
    OverTexture='Menu.Menu.Backdrop'
    OverRegion=(X=0,Y=16,W=486,h=40)
}