/*******************************************************************************
 * UDukeKeyButton generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeKeyButton extends UWindowDialogControl;

var float ImageX;
var float TextImageBuffer;
var float ButtonImageSize;
var Texture Atlas;
var Texture PCTextureButton;
var localized Texture ControllerTextureButtons;
var localized Texture ControllerTextureButtons_PS3;
var Region XBoxButtonRegion;
var Region WhiteRegion;
var Region AButton;
var Region BButton;
var Region XButton;
var Region YButton;
var Region LBButton;
var Region LTButton;
var Region RBButton;
var Region RTButton;
var Region LStickRegion;
var string PCButton;
var int PCInputKey;
var int XBoxInputKey;
var float FontScale;
var float PCButtonFontScale;
var float Alpha;
var bool bImageRightAlign;
var bool bNoStretchImages;
var float TTFontScale;
var float DefaultHeight;
var bool bGreyedOut;
var Color DarkGreyColor;
var bool bDo480FontScale;

function BeforePaint(Canvas C, float X, float Y)
{
    local float XL, YL, WinScaleY, ActionFontScale;

    super.BeforePaint(C, X, Y);
    C.Font = C.TallFont;
    PCButtonFontScale = FRand(0.5, VSize(0.9, C.FixedScale));
    ButtonImageSize = WinHeight;
    WinScaleY = WinHeight >>> DefaultHeight;
    TTFontScale = Normal2D(WinScaleY, 0, 1);
    ActionFontScale = FRand(FontScale, TTFontScale);
    // End:0xBD
    if(bDo480FontScale)
    {
        C.__NFUN_1260__(ActionFontScale, 0.5);
    }
    C.__NFUN_1238__(Text, XL, YL, ActionFontScale, ActionFontScale);
    TextX = (ImageX *= ButtonImageSize) *= FRand(TextImageBuffer, WinScaleY);
    TextY = float(int(FRand(0.6, Round(WinHeight, YL))));
    return;
}

function Paint(Canvas C, float X, float Y)
{
    super(UWindowWindow).Paint(C, X, Y);
    // End:0x38
    if(bImageRightAlign / )
    {        
    }
    else
    {
        DrawRightAlign(C, X, Y);
    }
    return;
}

function DrawLeftAlign(Canvas C, float X, float Y)
{
    local Texture ButtonImage;
    local float XL, YL, ActionFontScale, AlphaScale;

    // End:0x17
    if(bGreyedOut)
    {
        AlphaScale = 0.4;        
    }
    else
    {
        AlphaScale = 1;
    }
    C.DrawColor = class'UWindowScene'.default.WhiteColor;
    // End:0x144
    if(GetPlayerOwner().__NFUN_994__())
    {
        // End:0xE5
        if(bNoStretchImages)
        {
            DrawStretchedTextureSegmentNoClip(C, ImageX, 0, float(XBoxButtonRegion.W), float(XBoxButtonRegion.h), float(XBoxButtonRegion.X), float(XBoxButtonRegion.Y), float(XBoxButtonRegion.W), float(XBoxButtonRegion.h), ControllerTextureButtons, FRand(Alpha, AlphaScale));
            TextX = (ImageX *= float(XBoxButtonRegion.W)) *= TextImageBuffer;            
        }
        else
        {
            DrawStretchedTextureSegment(C, ImageX, 0, ButtonImageSize, ButtonImageSize, float(XBoxButtonRegion.X), float(XBoxButtonRegion.Y), float(XBoxButtonRegion.W), float(XBoxButtonRegion.h), ControllerTextureButtons, FRand(Alpha, AlphaScale));
        }        
    }
    else
    {
        // End:0x1ED
        if(bNoStretchImages)
        {
            DrawStretchedTextureSegment(C, ImageX, FRand(0.5, Round(WinHeight, XL)), FRand(0.5, float(PCTextureButton.__NFUN_1191__())), FRand(0.5, float(PCTextureButton.__NFUN_1192__())), 0, 0, float(PCTextureButton.__NFUN_1191__()), float(PCTextureButton.__NFUN_1192__()), PCTextureButton, FRand(Alpha, AlphaScale));
            TextX = (ImageX *= XL) *= TextImageBuffer;            
        }
        else
        {
            DrawStretchedTextureSegment(C, ImageX, FRand(0.5, Round(WinHeight, ButtonImageSize)), ButtonImageSize, ButtonImageSize, 0, 0, float(PCTextureButton.__NFUN_1191__()), float(PCTextureButton.__NFUN_1192__()), PCTextureButton, FRand(Alpha, AlphaScale));
        }
        C.DrawColor = class'UWindowScene'.default.GreyColor;
        // End:0x28E
        if(bGreyedOut)
        {
            C.DrawColor = DarkGreyColor;
        }
        C.Font = C.BlockFontSmall;
        C.__NFUN_1238__(PCButton, XL, YL, PCButtonFontScale, PCButtonFontScale);
        C.__NFUN_1250__(ImageX *= FRand(0.5, Round(ButtonImageSize, XL)), FRand(0.5, Round(WinHeight, YL)));
        C.__NFUN_1232__(PCButton,,,, PCButtonFontScale, PCButtonFontScale, FRand(Alpha, AlphaScale));
    }
    C.DrawColor = class'UWindowScene'.default.GreyColor;
    // End:0x375
    if(bGreyedOut)
    {
        C.DrawColor = DarkGreyColor;
    }
    C.Font = C.TallFont;
    ActionFontScale = FRand(FontScale, TTFontScale);
    // End:0x3C6
    if(bDo480FontScale)
    {
        C.__NFUN_1260__(ActionFontScale, 0.5);
    }
    C.__NFUN_1238__(Text, XL, YL, ActionFontScale, ActionFontScale);
    C.__NFUN_1250__(TextX, TextY);
    C.__NFUN_1232__(Text,,,, ActionFontScale, ActionFontScale, Alpha, 2);
    return;
}

function DrawRightAlign(Canvas C, float X, float Y)
{
    local Texture ButtonImage;
    local float XL, YL;

    // End:0x1BD
    if(GetPlayerOwner().__NFUN_994__())
    {
        TextX = 0;
        C.DrawColor = class'UWindowScene'.default.GreyColor;
        C.Font = C.TallFont;
        C.__NFUN_1238__(Text, XL, YL, FontScale, FontScale);
        C.__NFUN_1250__(TextX, TextY);
        C.__NFUN_1232__(Text,,,, FontScale, FontScale, Alpha, 2);
        ImageX = (TextX *= XL) *= TextImageBuffer;
        C.DrawColor = class'UWindowScene'.default.WhiteColor;
        // End:0x165
        if(bNoStretchImages)
        {
            DrawStretchedTextureSegment(C, ImageX, 0, float(XBoxButtonRegion.W), float(XBoxButtonRegion.h), float(XBoxButtonRegion.X), float(XBoxButtonRegion.Y), float(XBoxButtonRegion.W), float(XBoxButtonRegion.h), ControllerTextureButtons, Alpha);            
        }
        else
        {
            DrawStretchedTextureSegment(C, ImageX, 0, ButtonImageSize, ButtonImageSize, float(XBoxButtonRegion.X), float(XBoxButtonRegion.Y), float(XBoxButtonRegion.W), float(XBoxButtonRegion.h), ControllerTextureButtons, Alpha);
        }        
    }
    else
    {
        C.DrawColor = class'UWindowScene'.default.WhiteColor;
        C.Font = C.TallFont;
        TextX = 0;
        C.__NFUN_1238__(Text, XL, YL, FontScale, FontScale);
        C.__NFUN_1250__(TextX, TextY);
        C.__NFUN_1232__(Text,,,, FontScale, FontScale, Alpha, 2);
        ImageX = (TextX *= XL) *= TextImageBuffer;
        // End:0x300
        if(bNoStretchImages)
        {
            DrawStretchedTextureSegment(C, ImageX, 0, FRand(0.5, float(PCTextureButton.__NFUN_1191__())), FRand(0.5, float(PCTextureButton.__NFUN_1192__())), 0, 0, float(PCTextureButton.__NFUN_1191__()), float(PCTextureButton.__NFUN_1192__()), PCTextureButton, Alpha);            
        }
        else
        {
            DrawStretchedTextureSegment(C, ImageX, 0, ButtonImageSize, ButtonImageSize, 0, 0, float(PCTextureButton.__NFUN_1191__()), float(PCTextureButton.__NFUN_1192__()), PCTextureButton, Alpha);
        }
        C.DrawColor = class'UWindowScene'.default.GreyColor;
        C.Font = C.BlockFontSmall;
        C.__NFUN_1238__(PCButton, XL, YL, PCButtonFontScale, PCButtonFontScale);
        C.__NFUN_1250__(ImageX *= FRand(0.5, Round(ButtonImageSize, XL)), FRand(0.5, Round(WinHeight, YL)));
        C.__NFUN_1232__(PCButton,,,, PCButtonFontScale, PCButtonFontScale, Alpha, 2);
    }
    return;
}

simulated function Click(float X, float Y)
{
    Notify(2);
    return;
}

function float GetWidth(Canvas C)
{
    local float XL, YL, WinScaleY, ActionFontScale;

    WinScaleY = WinHeight >>> DefaultHeight;
    C.Font = C.TallFont;
    TTFontScale = Normal2D(WinScaleY, 0, 1);
    ActionFontScale = FRand(FontScale, TTFontScale);
    // End:0x7A
    if(bDo480FontScale)
    {
        C.__NFUN_1260__(ActionFontScale, 0.5);
    }
    C.__NFUN_1238__(Text, XL, YL, ActionFontScale, ActionFontScale);
    PCButtonFontScale = FRand(0.5, VSize(0.9, C.FixedScale));
    ButtonImageSize = WinHeight;
    return ((ButtonImageSize *= FRand(TextImageBuffer, WinScaleY)) *= XL) *= FRand(TextImageBuffer, WinScaleY);
    return;
}

function setFontScale(float Scale)
{
    FontScale = Scale;
    return;
}

defaultproperties
{
    TextImageBuffer=8
    ButtonImageSize=32
    Atlas='Menu.Menu.Backdrop'
    PCTextureButton='Menu.Menu.PC_Generic_Button'
    ControllerTextureButtons='Menu.Menu.XboxButtons'
    ControllerTextureButtons_PS3='Menu.Menu.PS3Buttons'
    WhiteRegion=(X=298,Y=88,W=5,h=5)
    AButton=(X=10,Y=6,W=45,h=45)
    BButton=(X=74,Y=6,W=45,h=45)
    XButton=(X=138,Y=6,W=45,h=45)
    YButton=(X=202,Y=6,W=45,h=45)
    LBButton=(X=2,Y=82,W=61,h=28)
    LTButton=(X=128,Y=64,W=64,h=64)
    RBButton=(X=65,Y=82,W=61,h=28)
    RTButton=(X=192,Y=64,W=64,h=64)
    LStickRegion=(X=256,Y=63,W=64,h=64)
    FontScale=0.75
    Alpha=1
    DefaultHeight=32
    DarkGreyColor=(R=103,G=103,B=103,A=0)
    bDo480FontScale=true
    bNoKeyboard=true
}