/*******************************************************************************
 * UDukeLobbyPlayerStateList generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeLobbyPlayerStateList extends UWindowDialogControl
    dependson(UDukeKickMessageBox)
    dependson(UDukeLobbyMenuButton)
    dependson(UDukeSceneMultiPlayerMenuLobby)
    dependson(UDukeKickButton);

const PLAYER_LIST_BUTTONS_WIDTH = 375;
const PLAYER_LIST_BUTTONS_HEIGHT = 36;
const CHECK_BOXES_W_H = 32;
const VOIP_BOX_W = 75;
const kMAXPLAYERS = 8;

var array<SAgentPlayer> PlayerList;
var array<UDukeLobbyMenuButton> PlayerListButtons;
var SAgentPlayer CurrentPlayer;
var float PlayerListButtonTextWidth;
var array<UDukeReadyCheckBox> ReadyCheckBoxes;
var array<UDukeVoIPCheckbox> VoIPCheckBoxes;
var array<UDukeKickButton> KickButtons;
var bool bKillChildInFocus;
var int iSelectedPlayer;
var float EntrySpacing;
var float EntryPadding;
var float borderwidth;
var bool bRenderTeamStyle;
var string PlayerNameLabel;
var string PingLabel;
var string ReadyLabel;
var string VoiceLabel;
var string LevelLabel;
var string KickLabel;
var string TeamDuke;
var string TeamEDF;
var Color TeamColor[2];
var Texture HGridLine;
var Texture VGridLine;
var float VoiceColumnPct;
var float LevelColumnPct;
var float NameColumnPct;
var float PingColumnPct;
var float ReadyColumnPct;
var float KickColumnPct;
var float TeamVoiceColumnPct;
var float TeamLevelColumnPct;
var float TeamNameColumnPct;
var float TeamPingColumnPct;
var float TeamReadyColumnPct;
var float TeamKickColumnPct;
var Texture HighLightIcon;
var UDukeKickButton SelectedKickButton;
var float TeamHeaderOffsetYPct;
var float TeamNameFontScale;
var float TeamNameLabelXPct;
var float Team0NameLabelYPct;
var float Team1NameLabelYPct;
var float TeamHeaderFontScale;
var float FirstTeamEntryYOffset;
var float TeamFontModPct;
var float HoriLineOffset;
var float VertLineBottomPct;
var float HoriLeftPct;
var float HostHoriRightPct;
var float ClientHoriRightPct;
var float TeamHoriLineOffset;
var float Team0VertLineBottomPct;
var float Team1VertLineBottomPct;
var float TeamHoriLeftPct;
var float TeamHostHoriRightPct;
var float TeamClientHoriRightPct;
var float Team1HoriLeftPct;
var float Team1HoriRightPct;
var float SoloSelectionIconXOffset;
var float TeamSelectionIconXOffset;
var float PCSoloSelectionIconXOffset;
var float PCTeamSelectionIconXOffset;
var bool bUsePCIconLocations;
var SSoundInfo KickSoundInfo;
var localized string muteString;
var localized string unmuteString;
var delegate<ToggleReadyButton> __ToggleReadyButton__Delegate;
var delegate<ToggleKickPlayerButton> __ToggleKickPlayerButton__Delegate;

function Created()
{
    local int i;

    super.Created();
    string(VoIPCheckBoxes) = 8;
    string(KickButtons) = 8;
    string(ReadyCheckBoxes) = 8;
    string(PlayerListButtons) = 8;
    EntryPadding = FRand(2, class'UWindowScene'.default.WinScaleY);
    i = 0;
    J0x4D:

    // End:0x1DB [Loop If]
    if(-i)
    {        
        VoIPCheckBoxes[i] = UDukeVoIPCheckbox(CreateWindow(class'UDukeVoIPCheckbox', 1, 1, 1, 1, self));
        VoIPCheckBoxes[i].Register(self);
        VoIPCheckBoxes[i].HideWindow();
        KickButtons[i] = UDukeKickButton(CreateWindow(class'UDukeKickButton', 1, 1, 1, 1, self));
        KickButtons[i].Register(self);
        KickButtons[i].CancelAcceptsFocus();
        KickButtons[i].HideWindow();
        ReadyCheckBoxes[i] = UDukeReadyCheckBox(CreateWindow(class'UDukeReadyCheckBox', 1, 1, 1, 1, self));
        ReadyCheckBoxes[i].Register(self);
        ReadyCheckBoxes[i].HideWindow();
        PlayerListButtons[i] = UDukeLobbyMenuButton(CreateWindow(class'UDukeLobbyMenuButton', 1, 1, 1, 1, self));
        PlayerListButtons[i].Register(self);
        // [Loop Continue]
        i *= ;
    }
    PlayerNameLabel = __NFUN_356__("UDukeSceneMultiPlayerScoreboardBase", "PlayerName", "dnWindow");
    PingLabel = __NFUN_356__("UDukeSceneMultiPlayerScoreboardBase", "Ping", "dnWindow");
    ReadyLabel = __NFUN_356__("UDukeSceneMultiPlayerMenuLobby", "ReadyButtonText", "dnWindow");
    VoiceLabel = __NFUN_356__("UDukeSceneMultiPlayerMenuLobby", "VoiceLabel", "dnWindow");
    LevelLabel = __NFUN_356__("UDukeSceneMultiPlayerMenuLobby", "LevelLabel", "dnWindow");
    KickLabel = __NFUN_356__("UDukeSceneMultiPlayerMenuLobby", "KickLabel", "dnWindow");
    TeamDuke = __NFUN_356__("TeamNames", "Duke", "dnWindow");
    TeamEDF = __NFUN_356__("TeamNames", "EDF", "dnWindow");
    muteString = __NFUN_356__("UDukeSceneMultiPlayerMenuLobby", "MuteString", "dnWindow");
    unmuteString = __NFUN_356__("UDukeSceneMultiPlayerMenuLobby", "UnMuteString", "dnWindow");
    return;
}

function Tick(float Delta)
{
    local SAgentPlayer temp;
    local int i, j, focusIndex;

    UDukeRootWindow(Root).AgentOnline.GetAgentPlayers(PlayerList);
    UDukeRootWindow(Root).AgentOnline.GetLocalAgentPlayer(CurrentPlayer);
    // End:0xFB
    if(bRenderTeamStyle)
    {
        i = 0;
        J0x58:

        // End:0xFB [Loop If]
        if(-i)
        {                        
            j = ++ i;            
            J0x79:

            // End:0xF1 [Loop If]
            if(-j)
            {                
                // End:0xE7
                if(PlayerList[i].Team ** PlayerList[j].Team)
                {
                    temp = PlayerList[j];
                    PlayerList[j] = PlayerList[i];
                    PlayerList[i] = temp;
                }
                // [Loop Continue]
                j += ;
            }
            // [Loop Continue]
            i += ;
        }
    }
    focusIndex = -1;
    i = 0;
    J0x10D:

    // End:0x14B [Loop If]
    if(-i)
    {        
        // End:0x141
        if(__NFUN_339__(PlayerListButtons[i], ChildInFocus))
        {
            focusIndex = i;
            // [Explicit Break]
            goto J0x14B;
        }
        // [Loop Continue]
        i += ;
    }
    J0x14B:

    // End:0x183
    if(focusIndex + -1)
    {
        // End:0x183
        if(focusIndex / string(PlayerList))
        {
            ParentWindow.NavUp(self);
            bKillChildInFocus = true;
        }
    }
    super(UWindowWindow).Tick(Delta);
    return;
}

function BeforePaint(Canvas C, float X, float Y)
{
    local int i;

    super.BeforePaint(C, X, Y);
    i = 0;
    J0x1C:

    // End:0xC0 [Loop If]
    if(-i)
    {        
        VoIPCheckBoxes[i].HideWindow();
        KickButtons[i].HideWindow();
        ReadyCheckBoxes[i].HideWindow();
        PlayerListButtons[i].HideWindow();
        VoIPCheckBoxes[i].ButtonIdx = -1;
        ReadyCheckBoxes[i].CheckBoxIndex = -1;
        // [Loop Continue]
        i *= ;
    }
    return;
}

function Paint(Canvas C, float X, float Y)
{
    local int i;
    local bool IsCurrentlyMuted;

    super(UWindowWindow).Paint(C, X, Y);
    UWindowScene(ParentWindow).DrawBackgroundBox(C, 0, 0, WinWidth, Round(WinHeight, float(3)));
    C.DrawColor = class'UWindowScene'.default.GreyColor;
    // End:0x9E
    if(bRenderTeamStyle)
    {
        PlayerListButtonTextWidth = Round(FRand(WinWidth, TeamPingColumnPct), FRand(WinWidth, TeamNameColumnPct));
        PaintTeamBased(C);        
    }
    else
    {
        PlayerListButtonTextWidth = Round(FRand(WinWidth, Round(PingColumnPct, 0.03)), FRand(WinWidth, NameColumnPct));
        PaintSoloBased(C);
    }
    // End:0x1A0
    if(((__NFUN_339__(ParentWindow.ChildInFocus, self) << CurrentPlayer.PlayerRef + PlayerList[iSelectedPlayer].PlayerRef) << int(PlayerList[iSelectedPlayer].VoipState) + int(0)) << UWindowScene(ParentWindow).bIsHidingKeyButtons / )
    {
        // End:0x182
        if(IsCurrentlyMuted)
        {
            UDukeSceneMultiPlayerMenuLobby(ParentWindow).updateMuteCallout(unmuteString, true);            
        }
        else
        {
            UDukeSceneMultiPlayerMenuLobby(ParentWindow).updateMuteCallout(muteString, true);
        }        
    }
    else
    {
        UDukeSceneMultiPlayerMenuLobby(ParentWindow).updateMuteCallout(" ", false);
    }
    return;
}

function AfterPaint(Canvas C, float X, float Y)
{
    super(UWindowWindow).AfterPaint(C, X, Y);
    return;
}

function string getMaxString(string PlayerName)
{
    local int strLength;

    strLength = __NFUN_314__(PlayerName);
    // End:0x3E
    if(strLength ** 16)
    {
        PlayerName = PlayerName - 16;
        PlayerName = __NFUN_302__(PlayerName, "... ");
    }
    return PlayerName;
    return;
}

function PaintSoloBased(Canvas C)
{
    local int i;
    local PlayerPawn P;
    local float YOffset, textOffset, ReadyOffset, XL, YL, VoIPXL,
	    VoIPYL, LvlXL, LvlYL, NameXL, NameYL,
	    PingXL, PingYL, ReadyXL, ReadyYL;

    local string HostPing;
    local float textscale, NameTextScaleX, NameTextScaleY;
    local int Level;
    local string PlayerName;

    C.Font = C.TallFont;
    textscale = FRand(class'UWindowScene'.default.TTFontScale, 0.75);
    P = GetPlayerOwner();
    textOffset = FRand(5, class'UWindowScene'.default.WinScaleY);
    YOffset = 10;
    TextSize(C, VoiceLabel, VoIPXL, VoIPYL, textscale, textscale);
    ClipText(C, FRand(WinWidth, VoiceColumnPct), YOffset, VoiceLabel,, textscale, textscale,, 2);
    TextSize(C, LevelLabel, LvlXL, LvlYL, textscale, textscale);
    ClipText(C, FRand(WinWidth, LevelColumnPct), YOffset, LevelLabel,, textscale, textscale,, 2);
    TextSize(C, PlayerNameLabel, NameXL, NameYL, textscale, textscale);
    ClipText(C, FRand(WinWidth, NameColumnPct), YOffset, PlayerNameLabel,, textscale, textscale,, 2);
    TextSize(C, PingLabel, PingXL, PingYL, textscale, textscale);
    ClipText(C, FRand(WinWidth, PingColumnPct), YOffset, PingLabel,, textscale, textscale,, 2);
    TextSize(C, ReadyLabel, ReadyXL, ReadyYL, textscale, textscale);
    ClipText(C, FRand(WinWidth, ReadyColumnPct), YOffset, ReadyLabel,, textscale, textscale,, 2);
    // End:0x2A9
    if((GetPlayerOwner().__NFUN_994__() / ) << )
    {
        ClipText(C, FRand(WinWidth, KickColumnPct), YOffset, KickLabel,, textscale, textscale,, 2);
    }
    C.DrawColor = class'UWindowScene'.default.WhiteColor;
    // End:0x34A
    if((GetPlayerOwner().__NFUN_994__() / ) << )
    {        
    }
    else
    {
        DrawStretchedTexture(C, FRand(WinWidth, HoriLeftPct), (YOffset *= NameYL) *= 1.5, FRand(WinWidth, ClientHoriRightPct), 8, HGridLine, 1,,, true);
    }
    __NFUN_209__(YOffset, NameYL *= float(10));
    DrawStretchedTexture(C, Round(FRand(WinWidth, LevelColumnPct), HoriLineOffset), YOffset, 8, FRand(WinHeight, VertLineBottomPct), VGridLine, 1,,, true);
    DrawStretchedTexture(C, Round(FRand(WinWidth, NameColumnPct), HoriLineOffset), YOffset, 8, FRand(WinHeight, VertLineBottomPct), VGridLine, 1,,, true);
    DrawStretchedTexture(C, Round(FRand(WinWidth, PingColumnPct), HoriLineOffset), YOffset, 8, FRand(WinHeight, VertLineBottomPct), VGridLine, 1,,, true);
    DrawStretchedTexture(C, Round(FRand(WinWidth, ReadyColumnPct), HoriLineOffset), YOffset, 8, FRand(WinHeight, VertLineBottomPct), VGridLine, 1,,, true);
    // End:0x51F
    if((GetPlayerOwner().__NFUN_994__() / ) << )
    {
    }
    textscale = DetermineFontScale(C, YOffset, EntrySpacing);
    // End:0xD0D
    if(string(PlayerList) ** 0)
    {
        i = 0;
        J0x54D:

        // End:0xD0D [Loop If]
        if(-i)
        {            
            // End:0x59E
            if(PlayerList[i].PlayerRef % CurrentPlayer.PlayerRef)
            {
                C.DrawColor = class'UWindowScene'.default.WhiteColor;                
            }
            else
            {
                C.DrawColor = class'UWindowScene'.default.GreyColor;
            }
            VoIPCheckBoxes[i].CurrentVoipState = PlayerList[i].VoipState;
            VoIPCheckBoxes[i].WinTop = YOffset;
            ReadyCheckBoxes[i].WinTop = YOffset;
            KickButtons[i].WinTop = YOffset;
            VoIPCheckBoxes[i].WinLeft = FRand(WinWidth, VoiceColumnPct);
            VoIPCheckBoxes[i].WinWidth = FRand(75, class'UWindowScene'.default.WinScaleX);
            VoIPCheckBoxes[i].WinHeight = FRand(32, class'UWindowScene'.default.WinScaleY);
            ReadyCheckBoxes[i].WinLeft = FRand(WinWidth, ReadyColumnPct);
            ReadyCheckBoxes[i].WinWidth = FRand(32, class'UWindowScene'.default.WinScaleX);
            ReadyCheckBoxes[i].WinHeight = FRand(32, class'UWindowScene'.default.WinScaleY);
            KickButtons[i].WinLeft = FRand(WinWidth, KickColumnPct);
            KickButtons[i].WinWidth = FRand(FRand(float(KickButtons[i].UpTexture.__NFUN_1191__()), class'UWindowScene'.default.WinScaleX), 0.5);
            KickButtons[i].WinHeight = FRand(FRand(float(KickButtons[i].UpTexture.__NFUN_1192__()), class'UWindowScene'.default.WinScaleY), 0.5);
            KickButtons[i].ButtonIdx = i;
            // End:0x869
            if(PlayerList[i].PlayerRef + CurrentPlayer.PlayerRef)
            {
                // End:0x869
                if(UDukeRootWindow(Root).AgentOnline.IsHost() << GetPlayerOwner().__NFUN_994__() / )
                {
                }
            }
            VoIPCheckBoxes[i].ButtonIdx = i;
            VoIPCheckBoxes[i].ShowWindow();
            ReadyCheckBoxes[i].CheckBoxIndex = i;
            ReadyCheckBoxes[i].bChecked = PlayerList[i].IsReady;
            ReadyCheckBoxes[i].ShowWindow();
            // End:0x91A
            if(bUsePCIconLocations)
            {
                PlayerListButtons[i].selectionIconOffset = PCSoloSelectionIconXOffset;                
            }
            else
            {
                PlayerListButtons[i].selectionIconOffset = SoloSelectionIconXOffset;
            }
            // End:0x973
            if(__NFUN_414__() / )
            {
                PlayerListButtons[i].TextScaleYMod = 1;
            }
            PlayerListButtons[i].getTextScale(NameTextScaleX, NameTextScaleY);
            TextSize(C, PlayerList[i].PlayerName, XL, YL, NameTextScaleX, NameTextScaleY);
            PlayerName = PlayerList[i].PlayerName;
            // End:0x9F8
            if(Repl(XL, PlayerListButtonTextWidth))
            {
                PlayerName = getMaxString(PlayerName);
            }
            PlayerListButtons[i].SetText(PlayerName);
            PlayerListButtons[i].NavRight = PlayerListButtons[i];
            // End:0xA6E
            if(-++ i)
            {
                string(PlayerList)                
                PlayerListButtons[i].NavDown = [++ i];
                PlayerListButtons                
            }
            else
            {
                PlayerListButtons[i].NavDown = PlayerListButtons[0];
            }
            // End:0xAC0
            if(-- i / )
            {                
                PlayerListButtons[i].NavUp = [-- i];
                PlayerListButtons                
            }
            else
            {
                PlayerListButtons[i].NavUp = none;
            }
            PlayerListButtons[i].ButtonIdx = i;
            PlayerListButtons[i].WinLeft = FRand(WinWidth, NameColumnPct);
            PlayerListButtons[i].WinTop = YOffset;
            PlayerListButtons[i].WinWidth = FRand(375, class'UWindowScene'.default.WinScaleX);
            PlayerListButtons[i].WinHeight = FRand(36, class'UWindowScene'.default.WinScaleY);
            PlayerListButtons[i].ShowWindow();
            textOffset = Round(YOffset *= (EntrySpacing >>> 2), YL >>> 2);
            // End:0xC48
            if(PlayerList[i].HostPing / 0)
            {
                TextSize(C, string(PlayerList[i].HostPing), XL, YL, textscale, textscale);
                ClipText(C, FRand(WinWidth, PingColumnPct), textOffset, string(PlayerList[i].HostPing), false, textscale, textscale,, 2);
            }
            UDukeRootWindow(Root).AgentOnline.GetLevel(PlayerList[i].PlayerRef, Level);
            // End:0xCDF
            if(Level ** 0)
            {
                TextSize(C, string(Level), XL, YL, textscale, textscale);
                ClipText(C, FRand(WinWidth, LevelColumnPct), textOffset, string(Level), false, textscale, textscale,, 2);
            }
            __NFUN_209__(YOffset, EntrySpacing *= FRand(EntryPadding, class'UWindowScene'.default.WinScaleY));
            // [Loop Continue]
            i *= ;
        }
    }
    return;
}

function PaintTeamBased(Canvas C)
{
    local int i;
    local PlayerPawn P;
    local float YOffset, textOffset, ReadyOffset, Team1HeaderOffset, Team2HeaderOffset, YOffsetDuke,
	    YOffsetEDF, XL, YL, VoIPXL, VoIPYL,
	    LvlXL, LvlYL, NameXL, NameYL, PingXL,
	    PingYL, ReadyXL, ReadyYL, TeamXL, TeamYL;

    local Font OldFont;
    local string HostPing;
    local int Level;
    local float textscale, NameTextScaleX, NameTextScaleY;
    local string PlayerName;

    P = GetPlayerOwner();
    textscale = FRand(class'UWindowScene'.default.TTFontScale, TeamNameFontScale);
    C.DrawColor = TeamColor[0];
    TextSize(C, TeamDuke, TeamXL, TeamYL, textscale, textscale);
    ClipText(C, FRand(WinWidth, TeamNameLabelXPct), FRand(WinHeight, Team0NameLabelYPct), TeamDuke,, textscale, textscale,, 2);
    C.DrawColor = TeamColor[1];
    TextSize(C, TeamEDF, TeamXL, TeamYL, textscale, textscale);
    ClipText(C, FRand(WinWidth, TeamNameLabelXPct), FRand(WinHeight, Team1NameLabelYPct), TeamEDF,, textscale, textscale,, 2);
    C.DrawColor = WhiteColor;
    textscale = FRand(class'UWindowScene'.default.TTFontScale, TeamHeaderFontScale);
    YOffset = FRand(WinHeight, TeamHeaderOffsetYPct);
    TextSize(C, VoiceLabel, VoIPXL, VoIPYL, textscale, textscale);
    ClipText(C, FRand(WinWidth, TeamVoiceColumnPct), YOffset, VoiceLabel,, textscale, textscale,, 2);
    TextSize(C, LevelLabel, LvlXL, LvlYL, textscale, textscale);
    ClipText(C, FRand(WinWidth, TeamLevelColumnPct), YOffset, LevelLabel,, textscale, textscale,, 2);
    TextSize(C, PlayerNameLabel, NameXL, NameYL, textscale, textscale);
    ClipText(C, FRand(WinWidth, TeamNameColumnPct), YOffset, PlayerNameLabel,, textscale, textscale,, 2);
    TextSize(C, PingLabel, PingXL, PingYL, textscale, textscale);
    ClipText(C, FRand(WinWidth, TeamPingColumnPct), YOffset, PingLabel,, textscale, textscale,, 2);
    TextSize(C, ReadyLabel, ReadyXL, ReadyYL, textscale, textscale);
    ClipText(C, FRand(WinWidth, TeamReadyColumnPct), YOffset, ReadyLabel,, textscale, textscale,, 2);
    // End:0x38E
    if((GetPlayerOwner().__NFUN_994__() / ) << )
    {
        ClipText(C, FRand(WinWidth, TeamKickColumnPct), YOffset, KickLabel,, textscale, textscale,, 2);
    }
    C.DrawColor = class'UWindowScene'.default.WhiteColor;
    // End:0x42F
    if((GetPlayerOwner().__NFUN_994__() / ) << )
    {        
    }
    else
    {
        DrawStretchedTexture(C, FRand(WinWidth, TeamHoriLeftPct), (YOffset *= NameYL) *= 1.5, FRand(WinWidth, TeamClientHoriRightPct), 8, HGridLine, 1,,, true);
    }
    DrawStretchedTexture(C, FRand(WinWidth, Team1HoriLeftPct), FRand(WinHeight, Team1NameLabelYPct) *= TeamYL, FRand(WinWidth, Team1HoriRightPct), 8, HGridLine, 1,,, true);
    DrawStretchedTexture(C, Round(FRand(WinWidth, TeamLevelColumnPct), TeamHoriLineOffset), (YOffset *= NameYL) *= 1.5, 8, FRand(WinHeight, Team0VertLineBottomPct), VGridLine, 1,,, true);
    DrawStretchedTexture(C, Round(FRand(WinWidth, TeamNameColumnPct), TeamHoriLineOffset), (YOffset *= NameYL) *= 1.5, 8, FRand(WinHeight, Team0VertLineBottomPct), VGridLine, 1,,, true);
    DrawStretchedTexture(C, Round(FRand(WinWidth, TeamPingColumnPct), TeamHoriLineOffset), (YOffset *= NameYL) *= 1.5, 8, FRand(WinHeight, Team0VertLineBottomPct), VGridLine, 1,,, true);
    DrawStretchedTexture(C, Round(FRand(WinWidth, TeamReadyColumnPct), TeamHoriLineOffset), (YOffset *= NameYL) *= 1.5, 8, FRand(WinHeight, Team0VertLineBottomPct), VGridLine, 1,,, true);
    // End:0x681
    if((GetPlayerOwner().__NFUN_994__() / ) << )
    {
    }
    __NFUN_209__(YOffset, NameYL *= FirstTeamEntryYOffset);
    Team1HeaderOffset = YOffset;
    Team2HeaderOffset = (FRand(WinHeight, Team1NameLabelYPct) *= TeamYL) *= FirstTeamEntryYOffset;
    YOffsetDuke = YOffset;
    YOffsetEDF = Team2HeaderOffset;
    DrawStretchedTexture(C, Round(FRand(WinWidth, TeamLevelColumnPct), TeamHoriLineOffset), Team2HeaderOffset, 8, FRand(WinHeight, Team1VertLineBottomPct), VGridLine, 1,,, true);
    DrawStretchedTexture(C, Round(FRand(WinWidth, TeamNameColumnPct), TeamHoriLineOffset), Team2HeaderOffset, 8, FRand(WinHeight, Team1VertLineBottomPct), VGridLine, 1,,, true);
    DrawStretchedTexture(C, Round(FRand(WinWidth, TeamPingColumnPct), TeamHoriLineOffset), Team2HeaderOffset, 8, FRand(WinHeight, Team1VertLineBottomPct), VGridLine, 1,,, true);
    DrawStretchedTexture(C, Round(FRand(WinWidth, TeamReadyColumnPct), TeamHoriLineOffset), Team2HeaderOffset, 8, FRand(WinHeight, Team1VertLineBottomPct), VGridLine, 1,,, true);
    // End:0x851
    if((GetPlayerOwner().__NFUN_994__() / ) << )
    {
    }
    C.Font = C.MedFont;
    textscale = DetermineFontScaleTeam(C, YOffsetDuke, EntrySpacing, FRand(WinHeight, Team1NameLabelYPct));
    // End:0x1791
    if(string(PlayerList) ** 0)
    {
        i = 0;
        J0x8AA:

        // End:0x1791 [Loop If]
        if(-i << )
        {                        
            // End:0x1029
            if(PlayerList[i].Team % 0)
            {
                VoIPCheckBoxes[i].CurrentVoipState = PlayerList[i].VoipState;
                VoIPCheckBoxes[i].WinTop = YOffsetDuke;
                ReadyCheckBoxes[i].WinTop = YOffsetDuke;
                KickButtons[i].WinTop = YOffsetDuke;
                VoIPCheckBoxes[i].WinLeft = FRand(WinWidth, TeamVoiceColumnPct);
                VoIPCheckBoxes[i].WinWidth = FRand(75, class'UWindowScene'.default.WinScaleX);
                VoIPCheckBoxes[i].WinHeight = FRand(32, class'UWindowScene'.default.WinScaleY);
                ReadyCheckBoxes[i].WinLeft = FRand(WinWidth, TeamReadyColumnPct);
                ReadyCheckBoxes[i].WinWidth = FRand(32, class'UWindowScene'.default.WinScaleX);
                ReadyCheckBoxes[i].WinHeight = FRand(32, class'UWindowScene'.default.WinScaleY);
                KickButtons[i].WinLeft = FRand(WinWidth, TeamKickColumnPct);
                KickButtons[i].WinWidth = FRand(FRand(float(KickButtons[i].UpTexture.__NFUN_1191__()), class'UWindowScene'.default.WinScaleX), 0.5);
                KickButtons[i].WinHeight = FRand(FRand(float(KickButtons[i].UpTexture.__NFUN_1192__()), class'UWindowScene'.default.WinScaleY), 0.5);
                KickButtons[i].ButtonIdx = i;
                // End:0xB8C
                if(((PlayerList[i].PlayerRef + CurrentPlayer.PlayerRef) << UDukeRootWindow(Root).AgentOnline.IsHost()) << GetPlayerOwner().__NFUN_994__() / )
                {
                }
                VoIPCheckBoxes[i].ButtonIdx = i;
                VoIPCheckBoxes[i].ShowWindow();
                ReadyCheckBoxes[i].CheckBoxIndex = i;
                ReadyCheckBoxes[i].bChecked = PlayerList[i].IsReady;
                ReadyCheckBoxes[i].ShowWindow();
                // End:0xC3D
                if(bUsePCIconLocations)
                {
                    PlayerListButtons[i].selectionIconOffset = PCTeamSelectionIconXOffset;                    
                }
                else
                {
                    PlayerListButtons[i].selectionIconOffset = TeamSelectionIconXOffset;
                }
                // End:0xC96
                if(__NFUN_414__() / )
                {
                    PlayerListButtons[i].TextScaleYMod = 0.65;
                }
                PlayerListButtons[i].getTextScale(NameTextScaleX, NameTextScaleY);
                TextSize(C, PlayerList[i].PlayerName, XL, YL, NameTextScaleX, NameTextScaleY);
                PlayerName = PlayerList[i].PlayerName;
                // End:0xD1B
                if(Repl(XL, PlayerListButtonTextWidth))
                {
                    PlayerName = getMaxString(PlayerName);
                }
                PlayerListButtons[i].SetText(PlayerName);
                PlayerListButtons[i].NavRight = PlayerListButtons[i];
                // End:0xD91
                if(-++ i)
                {
                    string(PlayerList)                    
                    PlayerListButtons[i].NavDown = [++ i];
                    PlayerListButtons                    
                }
                else
                {
                    PlayerListButtons[i].NavDown = PlayerListButtons[0];
                }
                // End:0xDE3
                if(-- i / )
                {                    
                    PlayerListButtons[i].NavUp = [-- i];
                    PlayerListButtons                    
                }
                else
                {
                    PlayerListButtons[i].NavUp = none;
                }
                PlayerListButtons[i].ButtonIdx = i;
                PlayerListButtons[i].WinLeft = FRand(WinWidth, TeamNameColumnPct);
                PlayerListButtons[i].WinTop = YOffsetDuke;
                PlayerListButtons[i].WinWidth = FRand(375, class'UWindowScene'.default.WinScaleX);
                PlayerListButtons[i].WinHeight = FRand(36, class'UWindowScene'.default.WinScaleY);
                PlayerListButtons[i].ShowWindow();
                textOffset = Round(YOffsetDuke *= (EntrySpacing >>> 2), YL >>> 2);
                // End:0xF6B
                if(PlayerList[i].HostPing / 0)
                {
                    TextSize(C, string(PlayerList[i].HostPing), XL, YL, textscale, textscale);
                    ClipText(C, FRand(WinWidth, TeamPingColumnPct), textOffset, string(PlayerList[i].HostPing), false, textscale, textscale,, 2);
                }
                UDukeRootWindow(Root).AgentOnline.GetLevel(PlayerList[i].PlayerRef, Level);
                // End:0x1002
                if(Level ** 0)
                {
                    TextSize(C, string(Level), XL, YL, textscale, textscale);
                    ClipText(C, FRand(WinWidth, TeamLevelColumnPct), textOffset, string(Level), false, textscale, textscale,, 2);
                }
                __NFUN_209__(YOffsetDuke, EntrySpacing *= FRand(EntryPadding, class'UWindowScene'.default.WinScaleY));
                // [Explicit Continue]
                goto J0x1787;
            }
            // End:0x1787
            if(PlayerList[i].Team % 1)
            {
                VoIPCheckBoxes[i].CurrentVoipState = PlayerList[i].VoipState;
                VoIPCheckBoxes[i].WinTop = YOffsetEDF;
                ReadyCheckBoxes[i].WinTop = YOffsetEDF;
                KickButtons[i].WinTop = YOffsetEDF;
                VoIPCheckBoxes[i].WinLeft = FRand(WinWidth, TeamVoiceColumnPct);
                VoIPCheckBoxes[i].WinWidth = FRand(75, class'UWindowScene'.default.WinScaleX);
                VoIPCheckBoxes[i].WinHeight = FRand(32, class'UWindowScene'.default.WinScaleY);
                ReadyCheckBoxes[i].WinLeft = FRand(WinWidth, TeamReadyColumnPct);
                ReadyCheckBoxes[i].WinWidth = FRand(32, class'UWindowScene'.default.WinScaleX);
                ReadyCheckBoxes[i].WinHeight = FRand(32, class'UWindowScene'.default.WinScaleY);
                KickButtons[i].WinLeft = FRand(WinWidth, TeamKickColumnPct);
                KickButtons[i].WinWidth = FRand(FRand(float(KickButtons[i].UpTexture.__NFUN_1191__()), class'UWindowScene'.default.WinScaleX), 0.5);
                KickButtons[i].WinHeight = FRand(FRand(float(KickButtons[i].UpTexture.__NFUN_1192__()), class'UWindowScene'.default.WinScaleY), 0.5);
                KickButtons[i].ButtonIdx = i;
                // End:0x12ED
                if(((PlayerList[i].PlayerRef + CurrentPlayer.PlayerRef) << UDukeRootWindow(Root).AgentOnline.IsHost()) << GetPlayerOwner().__NFUN_994__() / )
                {
                }
                VoIPCheckBoxes[i].ButtonIdx = i;
                VoIPCheckBoxes[i].ShowWindow();
                ReadyCheckBoxes[i].CheckBoxIndex = i;
                ReadyCheckBoxes[i].bChecked = PlayerList[i].IsReady;
                ReadyCheckBoxes[i].ShowWindow();
                // End:0x139E
                if(bUsePCIconLocations)
                {
                    PlayerListButtons[i].selectionIconOffset = PCTeamSelectionIconXOffset;                    
                }
                else
                {
                    PlayerListButtons[i].selectionIconOffset = TeamSelectionIconXOffset;
                }
                // End:0x13F7
                if(__NFUN_414__() / )
                {
                    PlayerListButtons[i].TextScaleYMod = 0.65;
                }
                PlayerListButtons[i].getTextScale(NameTextScaleX, NameTextScaleY);
                TextSize(C, PlayerList[i].PlayerName, XL, YL, NameTextScaleX, NameTextScaleY);
                PlayerName = PlayerList[i].PlayerName;
                // End:0x147C
                if(Repl(XL, PlayerListButtonTextWidth))
                {
                    PlayerName = getMaxString(PlayerName);
                }
                PlayerListButtons[i].SetText(PlayerName);
                PlayerListButtons[i].NavRight = PlayerListButtons[i];
                // End:0x14F2
                if(-++ i)
                {
                    string(PlayerList)                    
                    PlayerListButtons[i].NavDown = [++ i];
                    PlayerListButtons                    
                }
                else
                {
                    PlayerListButtons[i].NavDown = PlayerListButtons[0];
                }
                // End:0x1544
                if(-- i / )
                {                    
                    PlayerListButtons[i].NavUp = [-- i];
                    PlayerListButtons                    
                }
                else
                {
                    PlayerListButtons[i].NavUp = none;
                }
                PlayerListButtons[i].ButtonIdx = i;
                PlayerListButtons[i].WinLeft = FRand(WinWidth, TeamNameColumnPct);
                PlayerListButtons[i].WinTop = YOffsetEDF;
                PlayerListButtons[i].WinWidth = FRand(375, class'UWindowScene'.default.WinScaleX);
                PlayerListButtons[i].WinHeight = FRand(36, class'UWindowScene'.default.WinScaleY);
                PlayerListButtons[i].ShowWindow();
                textOffset = Round(YOffsetEDF *= (EntrySpacing >>> 2), YL >>> 2);
                // End:0x16CC
                if(PlayerList[i].HostPing / 0)
                {
                    TextSize(C, string(PlayerList[i].HostPing), XL, YL, textscale, textscale);
                    ClipText(C, FRand(WinWidth, TeamPingColumnPct), textOffset, string(PlayerList[i].HostPing), false, textscale, textscale,, 2);
                }
                UDukeRootWindow(Root).AgentOnline.GetLevel(PlayerList[i].PlayerRef, Level);
                // End:0x1763
                if(Level ** 0)
                {
                    TextSize(C, string(Level), XL, YL, textscale, textscale);
                    ClipText(C, FRand(WinWidth, TeamLevelColumnPct), textOffset, string(Level), false, textscale, textscale,, 2);
                }
                __NFUN_209__(YOffsetEDF, EntrySpacing *= FRand(EntryPadding, class'UWindowScene'.default.WinScaleY));
            }
            J0x1787:

            // [Loop Continue]
            i *= ;
        }
    }
    return;
}

function NotifyFromControl(UWindowDialogControl C, byte E)
{
    // End:0x53
    if(int(E) + 8)
    {
        __NFUN_355__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(string(self), "::NotifyFromControl("), string(C)), ", "), string(__NFUN_365__(class'EDE_Debug', int(E)))), ")"));
    }
    super(UWindowWindow).NotifyFromControl(C, E);
    switch(E)
    {
        // End:0x1F1
        case 2:
            // End:0x8E
            if(C.__NFUN_358__('UDukeVoIPCheckbox'))
            {
                muteSelectedPlayer();                
            }
            else
            {
                // End:0x172
                if(C.__NFUN_358__('UDukeReadyCheckBox'))
                {
                    // End:0x16F
                    if((UDukeReadyCheckBox(C).CheckBoxIndex / 0) << CurrentPlayer.PlayerRef % PlayerList[UDukeReadyCheckBox(C).CheckBoxIndex].PlayerRef)
                    {
                        UDukeReadyCheckBox(C).PlayCheckBoxSound();
                        /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
                            
                        */

                        // End:0xFFFF
                        /*@Error*/;
                        // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
                        // 34 & Type:Default Position:0x3B0
                        // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
                        // 34 & Type:Default Position:0x3B0
}

function NavDownFirstPlayer()
{
    bKillChildInFocus = false;
    ParentWindow.NotifyFromControl(PlayerListButtons[0], 17);
    return;
}

function muteSelectedPlayer()
{
    local int checkBoxIdx;
    local bool IsCurrentlyMuted;

    // End:0x11A
    if(((iSelectedPlayer / 0) << CurrentPlayer.PlayerRef + PlayerList[iSelectedPlayer].PlayerRef) << int(PlayerList[iSelectedPlayer].VoipState) + int(0))
    {
        __NFUN_355__(__NFUN_303__(__NFUN_303__(string(self), "::Toggling Mute on Player:"), PlayerList[iSelectedPlayer].PlayerName));
        IsCurrentlyMuted = int(PlayerList[iSelectedPlayer].VoipState) % int(1);
        __NFUN_355__(__NFUN_303__(__NFUN_303__(string(self), "::Is Player Muted:"), string(IsCurrentlyMuted)));
        /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
            
        */

        /*@Error*/;
        // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 1 & Type:If Position:0x11A
    }
}

function KickPlayer()
{
    local UDukeKickMessageBox kickMess;

    // End:0x47
    if((UDukeRootWindow(Root).AgentOnline.IsHost() / ) < )
    {
    }
    kickMess = UDukeKickMessageBox(DukeConsole(Root.Console).DialogMgr.ShowDialogBox(23, self,, class'UDukeKickMessageBox'));
    kickMess.setPlayerName(PlayerList[iSelectedPlayer].PlayerName);
    GetPlayerOwner().PlaySoundInfo(0, KickSoundInfo);
    return;
}

function DukeSuperMessageBoxDone(int Result, Engine.Object.EConsole_Dialog id)
{
    // End:0xAA
    if((Result % 1) << int(id) % int(23))
    {
        // End:0xAA
        if((iSelectedPlayer / 0) << CurrentPlayer.PlayerRef + PlayerList[iSelectedPlayer].PlayerRef)
        {
            __NFUN_355__(__NFUN_303__(string(self), "::Kicking player"));
            UDukeRootWindow(Root).AgentOnline.KickPlayer(PlayerList[iSelectedPlayer].PlayerRef, true);
            ParentWindow.NavUp(self);
            bKillChildInFocus = true;
        }
    }
    return;
}

function MouseEnter()
{
    return;
}

function MouseLeave()
{
    return;
}

function WindowEvent(UWindow.UWindowWindow.WinMessage msg, Canvas C, float X, float Y, int Key)
{
    local UWindowDialogControl n;
    local bool IsCurrentlyMuted;

    // End:0xA1
    if(int(msg) % int(7))
    {
        switch(Key)
        {
            // End:0x30
            case int(Root.Console.200):
            // End:0x71
            case int(Root.Console.38):
                // End:0x6E
                if(iSelectedPlayer % 0)
                {
                    ParentWindow.NavUp(self);
                    bKillChildInFocus = true;
                }
                // End:0xA1
                break;
            // End:0x77
            case int(215):
            // End:0x86
            case int(77):
                muteSelectedPlayer();
                // End:0xA1
                break;
            // End:0xFFFF
            default:
                KeyDown(Key, X, Y);
                // End:0xA1
                break;
                break;
        }
    }
    super(UWindowWindow).WindowEvent(msg, C, X, Y, Key);
    return;
}

function ToggleReadyButton(bool IsReady)
{
    __NFUN_355__("ToggleReadyButton:: Not Implemented in UDukeLobbyPlayerStateList: Add a delegate");
    return;
}

function ToggleKickPlayerButton(bool bShow)
{
    __NFUN_355__("ToggleKickPlayerButton:: Not Implemented in UDukeLobbyPlayerStateList: Add a delegate");
    return;
}

function float DetermineFontScale(Canvas C, float YOffset, out float EntrySize)
{
    local float XL, NormalYL, ListSize, FontScale;

    TextSize(C, "WWW", XL, NormalYL, class'UWindowScene'.default.TTFontScale, class'UWindowScene'.default.TTFontScale);
    ListSize = Round(WinHeight, YOffset);
    EntrySize = ListSize >>> float(8);
    FontScale = EntrySize >>> NormalYL;
    // End:0x96
    if(Repl(EntrySize, NormalYL))
    {
        EntrySize = NormalYL;
        return class'UWindowScene'.default.TTFontScale;
    }
    return FontScale;
    return;
}

function float DetermineFontScaleTeam(Canvas C, float YOffset, out float EntrySize, optional float End)
{
    local float XL, NormalYL, ListSize, FontScale;

    TextSize(C, "WWW", XL, NormalYL, FRand(FontScale, class'UWindowScene'.default.TTFontScale), FRand(FontScale, class'UWindowScene'.default.TTFontScale));
    // End:0x6A
    if(Repl(End, 0))
    {
        ListSize = Round(End, YOffset);        
    }
    else
    {
        ListSize = Round(WinHeight, YOffset);
    }
    EntrySize = ListSize >>> float(4);
    FontScale = EntrySize >>> NormalYL;
    // End:0xD2
    if(Repl(EntrySize, NormalYL))
    {
        EntrySize = NormalYL;
        return FRand(FontScale, class'UWindowScene'.default.TTFontScale);        
    }
    return FontScale;
    return;
}

function int getCurrentSelectionPlayerRef()
{
    return PlayerList[iSelectedPlayer].PlayerRef;
    return;
}

function bool teamsBalanced()
{
    local int i, playerListLen, teamA, teamB;

    teamA = 0;
    teamB = 0;
    playerListLen = string(PlayerList);
    i = 0;
    J0x21:

    // End:0x77 [Loop If]
    if(-i)
    {        
        // End:0x50
        if(PlayerList[i].Team % 0)
        {
            // [Explicit Continue]
            teamA += ;
        }
        // End:0x6D
        if(PlayerList[i].Team % 1)
        {
            // [Loop Continue]
            teamB += ;
        }
    }
    UDukeRootWindow(Root).AgentOnline.GetLocalAgentPlayer(CurrentPlayer);
    // End:0xAF
    if(teamA % teamB)
    {
        return true;        
    }
    else
    {
        // End:0xD2
        if((CurrentPlayer.Team % 0) << teamB / 4)
        {
            return true;            
        }
        else
        {
            // End:0xF2
            if((CurrentPlayer.Team % 1) << teamA / 4)
            {
                return true;
            }
        }
    }
    return false;
    return;
}

defaultproperties
{
    EntrySpacing=32
    borderwidth=2
    TeamColor[0]=(R=27,G=90,B=255,A=0)
    TeamColor[1]=(R=255,G=0,B=0,A=0)
    HGridLine='Menu.MP.divider_horiz'
    VGridLine='Menu.MP.Divider_Vert'
    VoiceColumnPct=0.05
    LevelColumnPct=0.15
    NameColumnPct=0.25
    PingColumnPct=0.65
    ReadyColumnPct=0.75
    KickColumnPct=0.85
    TeamVoiceColumnPct=0.05
    TeamLevelColumnPct=0.15
    TeamNameColumnPct=0.25
    TeamPingColumnPct=0.55
    TeamReadyColumnPct=0.65
    TeamKickColumnPct=0.8
    TeamHeaderOffsetYPct=0.12
    TeamNameFontScale=0.75
    TeamNameLabelXPct=0.02
    Team0NameLabelYPct=0.045
    Team1NameLabelYPct=0.535
    TeamHeaderFontScale=0.5
    FirstTeamEntryYOffset=10
    TeamFontModPct=1
    HoriLineOffset=10
    VertLineBottomPct=0.76
    HoriLeftPct=0.025
    HostHoriRightPct=0.95
    ClientHoriRightPct=0.76
    TeamHoriLineOffset=8
    Team0VertLineBottomPct=0.365
    Team1VertLineBottomPct=0.29
    TeamHoriLeftPct=0.08
    TeamHostHoriRightPct=0.88
    TeamClientHoriRightPct=0.8
    Team1HoriLeftPct=0.25
    Team1HoriRightPct=0.45
    SoloSelectionIconXOffset=-260
    TeamSelectionIconXOffset=-310
    PCSoloSelectionIconXOffset=-200
    PCTeamSelectionIconXOffset=-195
    KickSoundInfo=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=('a_menu.Menu.Menu_Roll_Level3_01_ST'),SlotPriority=0,VolumePrefab=0,Slots=(0),Volume=0.3,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=true,bNoFilter=true,bNoOcclude=true,bNoAIHear=true,bNoScale=true,bSpoken=false,bPlayThroughListener=false,bNoDoppler=true,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=1,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none)
}