/*******************************************************************************
 * UDukeLookAndFeel generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeLookAndFeel extends UWindowLookAndFeel;

const SIZEBORDER = 3;
const BRSIZEBORDER = 15;

var() Region FrameSBL;
var() Region FrameSB;
var() Region FrameSBR;
var() Region ClientArea;
var() Region CloseBoxUp;
var() Region CloseBoxDown;
var() int CloseBoxOffsetX;
var() int CloseBoxOffsetY;
var() Region CheckBoxEmpty;
var() Region CheckBoxChecked;
var() Region EditBoxFill;
var() Region EditBoxTL;
var() Region EditBoxT;
var() Region EditBoxTR;
var() Region EditBoxL;
var() Region EditBoxR;
var() Region EditBoxBL;
var() Region EditBoxB;
var() Region EditBoxBR;
var() Region EditBoxFocusFill;
var() Region EditBoxFocusTL;
var() Region EditBoxFocusT;
var() Region EditBoxFocusTR;
var() Region EditBoxFocusL;
var() Region EditBoxFocusR;
var() Region EditBoxFocusBL;
var() Region EditBoxFocusB;
var() Region EditBoxFocusBR;
var() Region HSliderL;
var() Region HSlider;
var() Region HSliderR;
var() Region HSliderThumb;
var() Region ButtonDownTL;
var() Region ButtonDownT;
var() Region ButtonDownTR;
var() Region ButtonDownBL;
var() Region ButtonDownB;
var() Region ButtonDownBR;
var() Region ButtonUpTL;
var() Region ButtonUpT;
var() Region ButtonUpTR;
var() Region ButtonUpBL;
var() Region ButtonUpB;
var() Region ButtonUpBR;
var() Region ComboFill;
var() Region ComboUpTL;
var() Region ComboUpT;
var() Region ComboUpTR;
var() Region ComboUpBL;
var() Region ComboUpB;
var() Region ComboUpBR;
var() Region ComboDownTR;
var() Region ComboDownBR;
var() Region ComboDownBL;
var() Region ComboDropL;
var() Region ComboDropR;
var() Region ComboDropBL;
var() Region ComboDropB;
var() Region ComboDropBR;
var() Region VSlideSmallTop;
var() Region VSlideSmallMid;
var() Region VSlideSmallBot;
var() Region SBPosIndicatorSmallT;
var() Region SBPosIndicatorSmallM;
var() Region SBPosIndicatorSmallB;
var() Region VSlideBevelTop;
var() Region VSlideBevelMid;
var() Region VSlideBevelBot;
var() Region SBPosIndicatorBevelT;
var() Region SBPosIndicatorBevelM;
var() Region SBPosIndicatorBevelB;
var() Region SimpleBevelFill;
var() Region SimpleBevelTL;
var() Region SimpleBevelT;
var() Region SimpleBevelTR;
var() Region SimpleBevelL;
var() Region SimpleBevelR;
var() Region SimpleBevelBL;
var() Region SimpleBevelB;
var() Region SimpleBevelBR;
var() Region BevelHeaderTL;
var() Region BevelHeaderT;
var() Region BevelHeaderTR;
var() Region BevelHeaderSplit;
var() Region BevelTL;
var() Region BevelT;
var() Region BevelTR;
var() Region BevelSplit;
var() Region BevelSplitB;
var() Region TabLeft;
var() Region TabMid;
var() Region TabRight;
var() Region TabLeftUp;
var() Region TabMidUp;
var() Region TabRightUp;
var int CurrentSlot;
var() Color colorTextSelected;
var() Color colorTextUnselected;
var Color TeamColor[4];
var Color SelfTeamColor[4];
var Color TeamHighlightColor[4];
var Sound GameStartSound;

function SetTextColors(Color colorNew)
{
    super.SetTextColors(colorNew);
    colorTextSelected.R = 255;
    colorTextSelected.G = 255;
    colorTextSelected.B = 255;
    FrameActiveTitleColor = colorTextSelected;
    HeadingActiveTitleColor = FrameActiveTitleColor;
    colorTextUnselected.R = 250;
    colorTextUnselected.G = 250;
    colorTextUnselected.B = 250;
    FrameInactiveTitleColor = colorTextUnselected;
    HeadingInActiveTitleColor = FrameInactiveTitleColor;
    DefaultTextColor = colorTextSelected;
    return;
}

function Color GetGUIColor(UWindowWindow W)
{
    // End:0x35
    if(UDukeRootWindow(W.Root).Desktop.ThemeColorizable)
    {
        return colorGUIWindows;        
    }
    else
    {
        return W.WhiteColor;
    }
    return;
}

function Color GetTextColor(UWindowWindow W)
{
    // End:0x35
    if(UDukeRootWindow(W.Root).Desktop.ThemeColorizable)
    {
        return DefaultTextColor;        
    }
    else
    {
        return W.WhiteColor;
    }
    return;
}

function FW_DrawWindowFrame(UWindowFramedWindow W, Canvas C)
{
    local Texture t, T3;

    C.Style = W.GetPlayerOwner().1;
    t = W.GetLookAndFeelTexture();
    T3 = W.GetLookAndFeelTexture3();
    C.DrawColor = GetGUIColor(W);
    Real_DrawWindowFrame(W, C, t, T3, false);
    C.Style = W.GetPlayerOwner().3;
    t = W.GetLookAndFeelGlowTexture();
    T3 = W.GetLookAndFeelGlowTexture3();
    C.DrawColor = W.WhiteColor;
    Real_DrawWindowFrame(W, C, t, T3, true);
    DrawTitleAndStatus(W, C);
    return;
}

function Real_DrawWindowFrame(UWindowFramedWindow W, Canvas C, Texture t, Texture T3, bool bGlow)
{
    local Region R;
    local float XL, YL, TitleEnd, TitleOver, RestLength, TrueRestLength;

    local Texture UseT;

    // End:0x21
    if(W.bMessageBoxFrame)
    {
        UseT = T3;        
    }
    else
    {
        UseT = t;
    }
    R = FrameTL;
    W.DrawStretchedTextureSegment(C, 0, 0, float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), UseT, 1);
    // End:0x148
    if(bGlow)
    {
        R = FrameT;
        W.DrawStretchedTextureSegment(C, float(FrameTL.W), 0, Round(Round(W.WinWidth, float(FrameTL.W)), float(FrameTR.W)), float(FrameT.h), float(FrameT.X), float(FrameT.Y), float(FrameT.W), float(FrameT.h), UseT, 1);        
    }
    else
    {
        C.Font = C.TallFont;
        W.TextSize(C, W.WindowTitle, XL, YL);
        TitleEnd = XL *= float(FrameTitleX);
        TitleOver = Round(TitleEnd, float(107));
        // End:0x22C
        if(Repl(TitleOver, float(0)))
        {
            __NFUN_209__(TitleOver, Round(float(5), IsA(TitleOver, float(5))));
            R = FrameT;
            W.DrawHorizTiledPieces(C, float(FrameTL.W), 0, TitleOver, float(FrameT.h), R, UseT, 1);            
        }
        else
        {
            TitleOver = 0;
        }
        TrueRestLength = Round(Round(Round(W.WinWidth, float(FrameTL.W)), float(FrameTR.W)), TitleOver);
        RestLength = TrueRestLength;
        // End:0x389
        if(Repl(RestLength, float(0)))
        {
            RestLength ~= IsA(RestLength, float(5));
            R = FrameT2;
            W.DrawHorizTiledPieces(C, float(FrameTL.W) *= TitleOver, 0, RestLength, float(FrameT2.h), R, UseT, 1);
            // End:0x389
            if(Repl(Round(TrueRestLength, RestLength), float(0)))
            {
                R = FrameT3;
                W.DrawStretchedTextureSegment(C, (float(FrameTL.W) *= TitleOver) *= RestLength, 0, Round(TrueRestLength, RestLength), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), UseT, 1);
            }
        }
    }
    R = FrameTR;
    W.DrawStretchedTextureSegment(C, Round(W.WinWidth, float(R.W)), 0, float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), UseT, 1);
    // End:0x759
    if(W.bStatusBar)
    {
        R = FrameL;
        W.DrawStretchedTextureSegment(C, 0, float(FrameTL.h), float(R.W), Round(Round(W.WinHeight, float(FrameTL.h)), float(FrameSBL.h)), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
        R = FrameR;
        W.DrawStretchedTextureSegment(C, Round(W.WinWidth, float(R.W)), float(FrameTL.h), float(R.W), Round(Round(W.WinHeight, float(FrameTR.h)), float(FrameSBR.h)), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
        R = FrameSBL;
        W.DrawStretchedTextureSegment(C, 0, Round(W.WinHeight, float(R.h)), float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), T3, 1);
        R = FrameSB;
        W.DrawStretchedTextureSegment(C, float(FrameSBL.W), Round(W.WinHeight, float(R.h)), Round(Round(W.WinWidth, float(FrameSBL.W)), float(FrameSBR.W)), float(FrameSB.h), float(FrameSB.X), float(FrameSB.Y), float(FrameSB.W), float(FrameSB.h), T3, 1);
        R = FrameSBR;
        W.DrawStretchedTextureSegment(C, Round(W.WinWidth, float(R.W)), Round(W.WinHeight, float(R.h)), float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), T3, 1);        
    }
    else
    {
        R = FrameL;
        W.DrawStretchedTextureSegment(C, 0, float(FrameTL.h), float(R.W), Round(Round(W.WinHeight, float(FrameTL.h)), float(FrameBL.h)), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
        R = FrameR;
        W.DrawStretchedTextureSegment(C, Round(W.WinWidth, float(R.W)), float(FrameTL.h), float(R.W), Round(Round(W.WinHeight, float(FrameTR.h)), float(FrameBR.h)), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
        R = FrameBL;
        W.DrawStretchedTextureSegment(C, 0, Round(W.WinHeight, float(R.h)), float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
        R = FrameB;
        W.DrawStretchedTextureSegment(C, float(FrameBL.W), Round(W.WinHeight, float(R.h)), Round(Round(W.WinWidth, float(FrameBL.W)), float(FrameBR.W)), float(FrameB.h), float(FrameB.X), float(FrameB.Y), float(FrameB.W), float(FrameB.h), t, 1);
        R = FrameBR;
        W.DrawStretchedTextureSegment(C, Round(W.WinWidth, float(R.W)), Round(W.WinHeight, float(R.h)), float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    }
    return;
}

function DrawClientArea(UWindowWindow W, Canvas C)
{
    C.DrawColor = GetGUIColor(W);
    W.DrawStretchedTextureSegment(C, 0, 0, W.WinWidth, W.WinHeight, float(ClientArea.X), float(ClientArea.Y), float(ClientArea.W), float(ClientArea.h), W.GetLookAndFeelTexture(), W.ClientAreaAlpha,,,,, true);
    return;
}

function DrawTitleAndStatus(UWindowFramedWindow W, Canvas C)
{
    C.DrawColor = GetTextColor(W);
    C.Font = C.TallFont;
    W.ClipText(C, float(FrameTitleX), float(FrameTitleY), W.WindowTitle);
    // End:0xD9
    if(W.bStatusBar)
    {
        C.Font = C.BlockFontSmall;
        W.ClipText(C, 28, Round(W.WinHeight, float(43)), W.StatusBarText);
    }
    return;
}

function Region FW_GetClientArea(UWindowFramedWindow W)
{
    local Region R;

    R.X = FrameL.W;
    R.Y = FrameT.h;
    R.W = int(Round(W.WinWidth, float(++ FrameL.W)));    
    // End:0xA8
    if(W.bStatusBar)
    {
        R.h = int(Round(W.WinHeight, float(++ FrameT.h)));                
    }
    else
    {
        R.h = int(Round(W.WinHeight, float(++ FrameT.h)));        
    }
    return R;
    return;
}

function UWindow.UWindowBase.FrameHitTest FW_HitTest(UWindowFramedWindow W, float X, float Y)
{
    // End:0x4E
    if((((X != float(3)) << __NFUN_202__(X, Round(W.WinWidth, float(3)))) << Y != float(3)) << __NFUN_202__(Y, float(14)))
    {
        return 8;
    }
    // End:0x8B
    if((__NFUN_200__(X, float(15)) << __NFUN_200__(Y, float(3))) < __NFUN_200__(X, float(3)) << __NFUN_200__(Y, float(15)))
    {
        return 0;
    }
    // End:0xEA
    if((Repl(X, Round(W.WinWidth, float(3))) << __NFUN_200__(Y, float(15))) < Repl(X, Round(W.WinWidth, float(15))) << __NFUN_200__(Y, float(3)))
    {
        return 2;
    }
    // End:0x149
    if((__NFUN_200__(X, float(15)) << Repl(Y, Round(W.WinHeight, float(3)))) < __NFUN_200__(X, float(3)) << Repl(Y, Round(W.WinHeight, float(15))))
    {
        return 5;
    }
    // End:0x18A
    if(Repl(X, Round(W.WinWidth, float(15))) << Repl(Y, Round(W.WinHeight, float(15))))
    {
        return 7;
    }
    // End:0x19A
    if(__NFUN_200__(Y, float(3)))
    {
        return 1;
    }
    // End:0x1BB
    if(Repl(Y, Round(W.WinHeight, float(3))))
    {
        return 6;
    }
    // End:0x1CB
    if(__NFUN_200__(X, float(3)))
    {
        return 3;
    }
    // End:0x1EC
    if(Repl(X, Round(W.WinWidth, float(3))))
    {
        return 4;
    }
    return 10;
    return;
}

function ControlFrame_SetupSizes(UWindowControlFrame W, Canvas C)
{
    local int B;

    B = EditBoxBevel;
    W.Framed.WinLeft = float(MiscBevelL[B].W);
    W.Framed.WinTop = float(MiscBevelT[B].h);
    W.Framed.SetSize(Round(Round(W.WinWidth, float(MiscBevelL[B].W)), float(MiscBevelR[B].W)), Round(Round(W.WinHeight, float(MiscBevelT[B].h)), float(MiscBevelB[B].h)));
    return;
}

function ControlFrame_Draw(UWindowControlFrame W, Canvas C)
{
    super.ControlFrame_Draw(W, C);
    W.DrawMiscBevel(C, 0, 0, W.WinWidth, W.WinHeight, Misc, EditBoxBevel);
    return;
}

function Tab_GetTabSize(UWindowTabControlTabArea Tab, Canvas C, string Text, out float W, out float h)
{
    local float tW, tH;

    C.Font = C.TallFont;
    Tab.TextSize(C, Text, tW, tH);
    W = tW *= float(16);
    h = float(TabMid.h);
    return;
}

function Tab_DrawTab(UWindowTabControlTabArea Tab, Canvas C, bool bActiveTab, bool bLeftmostTab, float X, float Y, float W, float h, string Text, bool bShowText)
{
    local Region R;
    local Texture t;
    local float tW, tH;

    C.DrawColor = GetGUIColor(Tab);
    C.Font = C.TallFont;
    t = Tab.GetLookAndFeelTexture();
    // End:0x200
    if(bActiveTab)
    {
        R = TabLeft;
        Tab.DrawStretchedTextureSegment(C, X, Y, float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
        R = TabMid;
        R = TabRight;
        Tab.DrawStretchedTextureSegment(C, Round(X *= W, float(R.W)), Y, float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
        C.DrawColor = GetTextColor(Tab);
        // End:0x1FD
        if(bShowText)
        {
            Tab.TextSize(C, Text, tW, tH);
            Tab.ClipText(C, X *= (Round(W, tW) >>> float(2)), Y *= (Round(float(TabMid.h), tH) >>> float(2)), Text, true);
        }        
    }
    else
    {
        R = TabLeftUp;
        Tab.DrawStretchedTextureSegment(C, X, Y, float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
        R = TabMidUp;
        Tab.DrawStretchedTextureSegment(C, X *= float(TabLeftUp.W), Y, Round(Round(W, float(TabLeftUp.W)), float(TabLeftUp.W)), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
        R = TabRightUp;
        Tab.DrawStretchedTextureSegment(C, Round(X *= W, float(R.W)), Y, float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
        C.DrawColor = GetTextColor(Tab);
        C.DrawColor.R = byte(int(3) -= ++ int(C.DrawColor.R));        
        C.DrawColor.G = byte(int(3) -= ++ int(C.DrawColor.G));        
        C.DrawColor.B = byte(int(3) -= ++ int(C.DrawColor.B));        
        // End:0x4CC
        if(bShowText)
        {
            Tab.TextSize(C, Text, tW, tH);
            Tab.ClipText(C, X *= (Round(W, tW) >>> float(2)), Y *= (Round(float(TabMid.h), tH) >>> float(2)), Text, true);
        }
    }
    return;
}

function Tab_SetupLeftButton(UWindowTabControlLeftButton W)
{
    local Texture t;

    t = W.GetLookAndFeelTexture();
    W.WinWidth = float(SBPosIndicator.W);
    W.WinHeight = float(SBPosIndicator.h);
    W.WinTop = Round(Size_TabAreaHeight, W.WinHeight);
    W.WinLeft = Round(W.ParentWindow.WinWidth, FRand(float(2), W.WinWidth));
    W.bUseRegion = true;
    W.UpTexture = t;
    W.DownTexture = t;
    W.OverTexture = t;
    W.DisabledTexture = t;
    W.UpRegion = SBLeftUp;
    W.DownRegion = SBLeftDown;
    W.OverRegion = SBLeftUp;
    W.DisabledRegion = SBLeftDisabled;
    return;
}

function Tab_SetupRightButton(UWindowTabControlRightButton W)
{
    local Texture t;

    t = W.GetLookAndFeelTexture();
    W.WinWidth = float(SBPosIndicator.W);
    W.WinHeight = float(SBPosIndicator.h);
    W.WinTop = Round(Size_TabAreaHeight, W.WinHeight);
    W.WinLeft = Round(W.ParentWindow.WinWidth, W.WinWidth);
    W.bUseRegion = true;
    W.UpTexture = t;
    W.DownTexture = t;
    W.OverTexture = t;
    W.DisabledTexture = t;
    W.UpRegion = SBRightUp;
    W.DownRegion = SBRightDown;
    W.OverRegion = SBRightUp;
    W.DisabledRegion = SBRightDisabled;
    return;
}

function Tab_SetTabPageSize(UWindowPageControl W, UWindowPageWindow P)
{
    P.WinLeft = 2;
    P.WinTop = Round(W.TabArea.WinHeight, float(-- TabSelectedM.h)) *= ;    
    P.SetSize(Round(W.WinWidth, float(4)), Round(Round(W.WinHeight, Round(W.TabArea.WinHeight, float(TabMid.h))), float(6)));
    return;
}

function Tab_DrawTabPageArea(UWindowPageControl W, Canvas C, UWindowPageWindow P)
{
    return;
}

function Editbox_SetupSizes(UWindowEditControl W, Canvas C)
{
    local float tW, tH;

    C.Font = W.Root.GetFont(W.Font, C);
    // End:0x7E
    if(__NFUN_308__(W.Text, ""))
    {
        W.TextSize(C, "TESTy", tW, tH);        
    }
    else
    {
        W.TextSize(C, W.Text, tW, tH);
    }
    switch(W.Align)
    {
        // End:0x10B
        case 0:
            W.EditAreaDrawX = Round(W.WinWidth, W.EditBoxWidth);
            W.TextX = 0;
            // End:0x1D3
            break;
        // End:0x15B
        case 1:
            W.EditAreaDrawX = 0;
            W.TextX = Round(Round(W.WinWidth, tW), float(EditBoxTR.W));
            // End:0x1D3
            break;
        // End:0x1D0
        case 2:
            W.EditAreaDrawX = Round(W.WinWidth, W.EditBoxWidth) >>> float(2);
            W.TextX = Round(Round(W.WinWidth, tW), float(EditBoxTR.W)) >>> float(2);
            // End:0x1D3
            break;
        // End:0xFFFF
        default:
            break;
    }
    W.WinHeight = float(++ EditBoxTL.h) *= ;    
    W.EditAreaDrawY = Round(W.WinHeight, float(2)) >>> float(2);
    W.TextY = Round(W.WinHeight, tH) >>> float(2);
    W.EditBox.WinLeft = W.EditAreaDrawX *= float(EditBoxTL.W);
    W.EditBox.WinTop = float(-- EditBoxT.h);    
    W.EditBox.WinWidth = Round(Round(W.WinWidth, float(EditBoxTL.W)), float(EditBoxTR.W));
    W.EditBox.WinHeight = Round(Round(W.WinHeight, float(EditBoxT.h)), float(EditBoxB.h));
    W.EditBox.TextY = Round(W.EditBox.WinHeight, tH) >>> float(2);
    W.EditBox.bTextYSet = true;
    return;
}

function Editbox_Draw(UWindowEditControl W, Canvas C)
{
    local Region R;
    local Texture t;

    C.DrawColor = GetGUIColor(W);
    C.Style = W.GetPlayerOwner().1;
    t = W.GetLookAndFeelTexture();
    // End:0x83
    if(W.EditBox.bHasKeyboardFocus)
    {
        R = EditBoxFocusTL;        
    }
    else
    {
        R = EditBoxTL;
    }
    W.DrawStretchedTextureSegment(C, 0, 0, float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    // End:0x124
    if(W.EditBox.bHasKeyboardFocus)
    {
        R = EditBoxFocusT;        
    }
    else
    {
        R = EditBoxT;
    }
    W.DrawStretchedTextureSegment(C, float(EditBoxTL.W), 0, Round(Round(W.WinWidth, float(EditBoxTL.W)), float(EditBoxTR.W)), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    // End:0x1E9
    if(W.EditBox.bHasKeyboardFocus)
    {
        R = EditBoxFocusTR;        
    }
    else
    {
        R = EditBoxTR;
    }
    W.DrawStretchedTextureSegment(C, Round(W.WinWidth, float(R.W)), 0, float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    // End:0x2A1
    if(W.EditBox.bHasKeyboardFocus)
    {
        R = EditBoxFocusL;        
    }
    else
    {
        R = EditBoxL;
    }
    W.DrawStretchedTextureSegment(C, 0, float(EditBoxTL.h), float(R.W), Round(Round(Round(W.WinHeight, float(EditBoxTL.h)), float(EditBoxBL.h)), float(4)), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    // End:0x36B
    if(W.EditBox.bHasKeyboardFocus)
    {
        R = EditBoxFocusR;        
    }
    else
    {
        R = EditBoxR;
    }
    W.DrawStretchedTextureSegment(C, Round(W.WinWidth, float(EditBoxR.W)), float(EditBoxTR.h), float(R.W), Round(Round(Round(W.WinHeight, float(EditBoxTR.h)), float(EditBoxBR.h)), float(4)), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    // End:0x44C
    if(W.EditBox.bHasKeyboardFocus)
    {
        R = EditBoxFocusBL;        
    }
    else
    {
        R = EditBoxBL;
    }
    W.DrawStretchedTextureSegment(C, 0, Round(Round(W.WinHeight, float(R.h)), float(4)), float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    // End:0x509
    if(W.EditBox.bHasKeyboardFocus)
    {
        R = EditBoxFocusB;        
    }
    else
    {
        R = EditBoxB;
    }
    W.DrawStretchedTextureSegment(C, float(EditBoxBL.W), Round(Round(W.WinHeight, float(R.h)), float(4)), Round(Round(W.WinWidth, float(EditBoxBL.W)), float(EditBoxBR.W)), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    // End:0x5EA
    if(W.EditBox.bHasKeyboardFocus)
    {
        R = EditBoxFocusBR;        
    }
    else
    {
        R = EditBoxBR;
    }
    W.DrawStretchedTextureSegment(C, Round(W.WinWidth, float(R.W)), Round(Round(W.WinHeight, float(R.h)), float(4)), float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    R = EditBoxFill;
    W.DrawStretchedTextureSegment(C, float(EditBoxTL.W), float(EditBoxTL.h), Round(Round(W.WinWidth, float(EditBoxTL.W)), float(EditBoxTR.W)), Round(Round(Round(W.WinHeight, float(EditBoxTL.h)), float(EditBoxTL.h)), float(4)), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    C.DrawColor = GetTextColor(W);
    C.Style = W.GetPlayerOwner().3;
    C.Font = C.TallFont;
    W.ClipText(C, W.TextX, W.TextY, W.Text);
    return;
}

function DrawFullBorder(UWindowWindow W, Canvas C, int borderwidth)
{
    local Texture t;

    C.Style = W.GetPlayerOwner().1;
    t = class'WhiteTexture';
    W.DrawStretchedTexture(C, 0, 0, W.WinWidth, float(borderwidth), t, 1);
    W.DrawStretchedTexture(C, 0, 0, float(borderwidth), W.WinHeight, t, 1);
    W.DrawStretchedTexture(C, Round(W.WinWidth, float(borderwidth)), 0, float(borderwidth), W.WinHeight, t, 1);
    W.DrawStretchedTexture(C, 0, Round(W.WinHeight, float(borderwidth)), W.WinWidth, float(borderwidth), t, 1);
    return;
}

function DrawBorder(UWindowWindow W, Canvas C, int X, int Y, int Width, int Height, int borderwidth)
{
    local Texture t;

    C.Style = W.GetPlayerOwner().1;
    t = class'WhiteTexture';
    W.DrawStretchedTexture(C, float(X), float(Y), float(Width), float(borderwidth), t, 1);
    W.DrawStretchedTexture(C, float(X), float(Y), float(borderwidth), float(Height), t, 1);
    W.DrawStretchedTexture(C, float(-- Width));
    0
    float(borderwidth)
    float(Height)
    t
    1    
    W.DrawStretchedTexture(C, 0, float(-- Height));
    float(Width)
    float(borderwidth)
    t
    1    
    return;
}

function Bevel_DrawSimpleBevel(UWindowWindow W, Canvas C, int X, int Y, int Width, int Height, float Alpha)
{
    local Region R;
    local Texture t;

    // End:0x17
    if(__NFUN_204__(Alpha, float(0)))
    {
        Alpha = 1;
    }
    C.DrawColor = GetGUIColor(W);
    // End:0x68
    if(__NFUN_200__(Alpha, float(1)))
    {
        C.Style = W.GetPlayerOwner().5;        
    }
    else
    {
        C.Style = W.GetPlayerOwner().1;
    }
    t = W.GetLookAndFeelTexture();
    R = SimpleBevelTL;
    W.DrawStretchedTextureSegment(C, float(-- X));
    float(-- Y);    
    float(R.W)
    float(R.h)
    float(R.X)
    float(R.Y)
    float(R.W)
    float(R.h)
    t
    Alpha    
    R = SimpleBevelT;
    W.DrawStretchedTextureSegment(C, float(X), float(-- Y));
    float(Width)
    float(R.h)
    float(R.X)
    float(R.Y)
    float(R.W)
    float(R.h)
    t
    Alpha    
    R = SimpleBevelTR;
    W.DrawStretchedTextureSegment(C, float(++ X));
    float(-- Y);    
    float(R.W)
    float(R.h)
    float(R.X)
    float(R.Y)
    float(R.W)
    float(R.h)
    t
    Alpha    
    R = SimpleBevelL;
    W.DrawStretchedTextureSegment(C, float(-- X));
    float(Y)
    float(R.W)
    float(Height)
    float(R.X)
    float(R.Y)
    float(R.W)
    float(R.h)
    t
    Alpha    
    R = SimpleBevelR;
    W.DrawStretchedTextureSegment(C, float(++ X));
    float(Y)
    float(R.W)
    float(Height)
    float(R.X)
    float(R.Y)
    float(R.W)
    float(R.h)
    t
    Alpha    
    R = SimpleBevelBL;
    W.DrawStretchedTextureSegment(C, float(-- X));
    float(++ Y);    
    float(R.W)
    float(R.h)
    float(R.X)
    float(R.Y)
    float(R.W)
    float(R.h)
    t
    Alpha    
    R = SimpleBevelB;
    W.DrawStretchedTextureSegment(C, float(X), float(++ Y));
    float(Width)
    float(R.h)
    float(R.X)
    float(R.Y)
    float(R.W)
    float(R.h)
    t
    Alpha    
    R = SimpleBevelBR;
    W.DrawStretchedTextureSegment(C, float(++ X));
    float(++ Y);    
    float(R.W)
    float(R.h)
    float(R.X)
    float(R.Y)
    float(R.W)
    float(R.h)
    t
    Alpha    
    R = SimpleBevelFill;
    W.DrawStretchedTextureSegment(C, float(X), float(Y), float(Width), float(Height), float(R.X), float(R.Y), float(R.W), float(R.h), t, Alpha);
    return;
}

function Bevel_DrawTabBevel(UWindowWindow W, Canvas C, int X, int Y, int Width, int Height)
{
    local Region R;
    local Texture t;

    C.DrawColor = GetGUIColor(W);
    C.Style = W.GetPlayerOwner().1;
    t = W.GetLookAndFeelTexture();
    R = SimpleBevelTR;
    W.DrawStretchedTextureSegment(C, float(-- X));
    float(-- Y);    
    float(R.W)
    float(R.h)
    float(R.X)
    float(R.Y)
    float(R.W)
    float(R.h)
    t
    1    
    R = SimpleBevelTL;
    W.DrawStretchedTextureSegment(C, float(++ X));
    float(-- Y);    
    float(R.W)
    float(R.h)
    float(R.X)
    float(R.Y)
    float(R.W)
    float(R.h)
    t
    1    
    R = SimpleBevelL;
    W.DrawStretchedTextureSegment(C, float(++ -- X), 5);
    float(Y)
    float(R.W)
    float(Height)
    float(R.X)
    float(R.Y)
    float(R.W)
    float(R.h)
    t
    1    
    R = SimpleBevelR;
    W.DrawStretchedTextureSegment(C, float(-- ++ X), 5);
    float(Y)
    float(R.W)
    float(Height)
    float(R.X)
    float(R.Y)
    float(R.W)
    float(R.h)
    t
    1    
    R = SimpleBevelBL;
    W.DrawStretchedTextureSegment(C, float(++ -- X), 5);
    float(++ Y);    
    float(R.W)
    float(R.h)
    float(R.X)
    float(R.Y)
    float(R.W)
    float(R.h)
    t
    1    
    R = SimpleBevelB;
    W.DrawStretchedTextureSegment(C, float(++ X));
    float(++ Y);    
    float(-- Width);    
    float(R.h)
    float(R.X)
    float(R.Y)
    float(R.W)
    float(R.h)
    t
    1    
    R = SimpleBevelBR;
    W.DrawStretchedTextureSegment(C, float(-- ++ X), 5);
    float(++ Y);    
    float(R.W)
    float(R.h)
    float(R.X)
    float(R.Y)
    float(R.W)
    float(R.h)
    t
    1    
    R = SimpleBevelFill;
    W.DrawStretchedTextureSegment(C, float(X), float(Y), float(Width), float(Height), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    return;
}

function Bevel_DrawSplitHeaderedBevel(UWindowWindow W, Canvas C, int X, int Y, int Width, int Height, string Header1, string Header2)
{
    local Region R;
    local Texture t;
    local float MiddleLen, XL, YL;

    C.DrawColor = GetGUIColor(W);
    C.Style = W.GetPlayerOwner().1;
    t = W.GetLookAndFeelTexture();
    R = BevelHeaderTL;
    W.DrawStretchedTextureSegment(C, float(X), float(Y), float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    MiddleLen = float(-- -- -- Width) >>> ;    
    float(2)    
    R = BevelHeaderT;
    W.DrawStretchedTextureSegment(C, float(++ X));
    float(Y)
    MiddleLen
    float(R.h)
    float(R.X)
    float(R.Y)
    float(R.W)
    float(R.h)
    t
    1    
    R = BevelHeaderSplit;
    W.DrawStretchedTextureSegment(C, float(++ X) *= );
    float(Y)
    float(R.W)
    float(R.h)
    float(R.X)
    float(R.Y)
    float(R.W)
    float(R.h)
    t
    1    
    R = BevelHeaderT;
    W.DrawStretchedTextureSegment(C, float(++ ++ X) *= BevelHeaderSplit.W, MiddleLen);
    float(Y)
    MiddleLen
    float(R.h)
    float(R.X)
    float(R.Y)
    float(R.W)
    float(R.h)
    t
    1    
    R = BevelHeaderTR;
    W.DrawStretchedTextureSegment(C, float(-- ++ X), R.W);
    float(Y)
    float(R.W)
    float(R.h)
    float(R.X)
    float(R.Y)
    float(R.W)
    float(R.h)
    t
    1    
    R = BevelTL;
    W.DrawStretchedTextureSegment(C, float(X), float(++ Y));
    float(R.W)
    float(R.h)
    float(R.X)
    float(R.Y)
    float(R.W)
    float(R.h)
    t
    1    
    R = BevelT;
    W.DrawStretchedTextureSegment(C, float(++ X));
    float(++ Y);    
    float(-- -- Width);
    BevelTR.W    
    float(R.h)
    float(R.X)
    float(R.Y)
    float(R.W)
    float(R.h)
    t
    1    
    R = BevelTL;
    W.DrawStretchedTextureSegment(C, float(-- ++ X), R.W);
    float(++ Y);    
    float(R.W)
    float(R.h)
    float(R.X)
    float(R.Y)
    float(R.W)
    float(R.h)
    t
    1    
    R = SimpleBevelL;
    W.DrawStretchedTextureSegment(C, float(X), float(++ Y));
    float(R.W)
    float(-- -- Height);
    SimpleBevelB.h    
    float(R.X)
    float(R.Y)
    float(R.W)
    float(R.h)
    t
    1    
    R = SimpleBevelR;
    W.DrawStretchedTextureSegment(C, float(-- ++ X), R.W);
    float(++ Y);    
    float(R.W)
    float(-- -- Height);
    SimpleBevelB.h    
    float(R.X)
    float(R.Y)
    float(R.W)
    float(R.h)
    t
    1    
    R = SimpleBevelBL;
    W.DrawStretchedTextureSegment(C, float(X), float(-- -- ++ ++ Y), BevelHeaderT.h);
    SimpleBevelB.h    
    float(R.W)
    float(R.h)
    float(R.X)
    float(R.Y)
    float(R.W)
    float(R.h)
    t
    1    
    R = SimpleBevelB;
    W.DrawStretchedTextureSegment(C, float(++ X));
    float(-- -- ++ ++ Y);
    BevelHeaderT.h    
    SimpleBevelB.h    
    float(-- -- Width);
    SimpleBevelBR.W    
    float(R.h)
    float(R.X)
    float(R.Y)
    float(R.W)
    float(R.h)
    t
    1    
    R = SimpleBevelBR;
    W.DrawStretchedTextureSegment(C, float(-- ++ X), R.W);
    float(-- -- ++ ++ Y);
    BevelHeaderT.h    
    SimpleBevelB.h    
    float(R.W)
    float(R.h)
    float(R.X)
    float(R.Y)
    float(R.W)
    float(R.h)
    t
    1    
    R = SimpleBevelFill;
    W.DrawStretchedTextureSegment(C, float(++ X));
    float(++ Y);    
    float(-- -- Width);
    SimpleBevelR.W    
    float(-- -- Height);
    SimpleBevelB.h    
    float(R.X)
    float(R.Y)
    float(R.W)
    float(R.h)
    t
    1    
    R = BevelSplit;
    W.DrawVertTiledPieces(C, float(++ ++ ++ X));
    ++ -- -- -- Width;
    R.W    
    2        
    float(++ Y);    
    float(R.W)
    float(-- -- Height);
    1    
    R
    t
    1    
    C.DrawColor = GetTextColor(W);
    C.Font = C.BlockFontSmall;
    W.TextSize(C, Header1, XL, YL);
    W.ClipText(C, float(++ X));
    float(Y) *= (Round(float(BevelHeaderTL.h), YL) >>> float(2));
    Header1
    true    
    C.Font = C.BlockFontSmall;
    W.TextSize(C, Header2, XL, YL);
    W.ClipText(C, (float(++ ++ X) *= BevelHeaderSplit.W) *= MiddleLen, float(BevelHeaderT.W));
    float(Y) *= (Round(float(BevelHeaderTL.h), YL) >>> float(2));
    Header2
    true    
    return;
}

function int Bevel_GetSplitLeft()
{
    return BevelHeaderTL.W;
    return;
}

function int Bevel_GetSplitRight(int Width)
{
    local float MiddleLen;

    MiddleLen = float(-- -- -- Width) >>> ;    
    float(2)    
    return int((float(++ BevelHeaderTL.W) *= ) *= );    
    return;
}

function int Bevel_GetHeaderedTop()
{
    return BevelHeaderTL.h;
    return;
}

function Grid_SetGridColumnSize(UWindowGridColumn W)
{
    // End:0x2B
    if(W.bLargeGrid)
    {
        W.ColumnHeadingHeight = 24;        
    }
    else
    {
        W.ColumnHeadingHeight = float(ColumnHeadingHeight);
    }
    return;
}

function Grid_SizeGrid(UWindowGrid W)
{
    local float Offset;
    local UWindowGridColumn colColumn;
    local float TotalWidth;

    TotalWidth = 0;
    colColumn = W.FirstColumn;
    J0x20:

    // End:0x5A [Loop If]
    if(__NFUN_340__(colColumn, none))
    {
        __NFUN_209__(TotalWidth, colColumn.WinWidth);
        colColumn = colColumn.NextColumn;
        // [Loop Continue]
        goto J0x20;
    }
    W.HorizSB.HideWindow();
    W.ClientArea.WinTop = 0;
    W.ClientArea.WinLeft = 0;
    W.ClientArea.WinWidth = Round(W.WinWidth, float(SBPosIndicator.W));
    // End:0x134
    if(W.bShowHorizSB)
    {
        W.ClientArea.WinHeight = Round(W.WinHeight, float(SBPosIndicator.h));        
    }
    else
    {
        W.ClientArea.WinHeight = W.WinHeight;
    }
    W.VertSB.WinTop = 2 *= float(Bevel_GetHeaderedTop());
    W.VertSB.SetSize(float(SBPosIndicatorBevel.W), Round(Round(W.WinHeight, W.VertSB.WinTop), float(4)));
    W.VertSB.WinLeft = Round(Round(W.WinWidth, float(SBPosIndicatorBevel.W)), float(4));
    Offset = 0;
    colColumn = W.FirstColumn;
    J0x234:

    // End:0x2B7 [Loop If]
    if(__NFUN_340__(colColumn, none))
    {
        colColumn.WinLeft = Offset;
        colColumn.WinTop = 0;
        colColumn.WinHeight = W.WinHeight;
        __NFUN_209__(Offset, colColumn.WinWidth);
        colColumn = colColumn.NextColumn;
        // [Loop Continue]
        goto J0x234;
    }
    return;
}

function Grid_DrawGrid(UWindowGrid W, Canvas C)
{
    local Region R;
    local Texture t;
    local float MiddleLen, XL, YL, Offset, DrawWidth;

    local UWindowGridColumn colColumn;

    W.WinHeight = float(int(W.WinHeight));
    W.WinWidth = float(int(W.WinWidth));
    C.DrawColor = GetGUIColor(W);
    C.Style = W.GetPlayerOwner().1;
    t = W.GetLookAndFeelTexture();
    R = BevelHeaderTL;
    W.DrawStretchedTextureSegment(C, 0, 0, float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    Offset = float(BevelHeaderTL.W);
    colColumn = W.FirstColumn;
    DrawWidth = Round(colColumn.WinWidth, float(BevelHeaderSplit.W));
    J0x158:

    // End:0x303 [Loop If]
    if(__NFUN_340__(colColumn, none))
    {
        // End:0x1A3
        if(__NFUN_339__(colColumn.NextColumn, none))
        {
            DrawWidth = Round(Round(W.WinWidth, Offset), float(BevelHeaderTR.W));
        }
        R = BevelHeaderT;
        W.DrawStretchedTextureSegment(C, Offset, 0, DrawWidth, float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
        __NFUN_209__(Offset, DrawWidth);
        // End:0x2BD
        if(__NFUN_340__(colColumn.NextColumn, none))
        {
            R = BevelHeaderSplit;
            W.DrawStretchedTextureSegment(C, Offset, 0, float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
            __NFUN_209__(Offset, float(BevelHeaderSplit.W));
        }
        colColumn = colColumn.NextColumn;
        // End:0x300
        if(__NFUN_340__(colColumn, none))
        {
            DrawWidth = Round(colColumn.WinWidth, float(BevelHeaderSplit.W));
        }
        // [Loop Continue]
        goto J0x158;
    }
    R = BevelHeaderTR;
    W.DrawStretchedTextureSegment(C, Round(W.WinWidth, float(BevelHeaderTR.W)), 0, float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    R = BevelTL;
    W.DrawStretchedTextureSegment(C, 0, float(BevelHeaderTL.h), float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    R = BevelT;
    W.DrawStretchedTextureSegment(C, float(BevelTL.W), float(BevelHeaderTL.h), Round(Round(W.WinWidth, float(BevelTL.W)), float(BevelTR.W)), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    R = BevelTL;
    W.DrawStretchedTextureSegment(C, Round(W.WinWidth, float(R.W)), float(BevelHeaderTR.h), float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    R = SimpleBevelL;
    W.DrawStretchedTextureSegment(C, 0, float(BevelHeaderTL.h), float(R.W), Round(Round(W.WinHeight, float(BevelHeaderT.h)), float(SimpleBevelB.h)), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    R = SimpleBevelR;
    W.DrawStretchedTextureSegment(C, Round(W.WinWidth, float(R.W)), float(BevelHeaderTR.h), float(R.W), Round(Round(W.WinHeight, float(BevelHeaderT.h)), float(SimpleBevelB.h)), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    R = SimpleBevelBL;
    W.DrawStretchedTextureSegment(C, 0, Round(Round(float(BevelHeaderTL.h) *= W.WinHeight, float(BevelHeaderT.h)), float(SimpleBevelB.h)), float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    R = SimpleBevelB;
    W.DrawStretchedTextureSegment(C, float(SimpleBevelBL.W), Round(Round(float(BevelHeaderTL.h) *= W.WinHeight, float(BevelHeaderT.h)), float(SimpleBevelB.h)), Round(Round(W.WinWidth, float(SimpleBevelBL.W)), float(SimpleBevelBR.W)), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    R = SimpleBevelBR;
    W.DrawStretchedTextureSegment(C, Round(W.WinWidth, float(R.W)), Round(Round(float(BevelHeaderTL.h) *= W.WinHeight, float(BevelHeaderT.h)), float(SimpleBevelB.h)), float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    R = SimpleBevelFill;
    W.DrawStretchedTextureSegment(C, float(SimpleBevelL.W), float(BevelHeaderTL.h), Round(Round(W.WinWidth, float(SimpleBevelL.W)), float(SimpleBevelR.W)), Round(Round(W.WinHeight, float(BevelHeaderT.h)), float(SimpleBevelB.h)), float(R.X), float(R.Y), float(R.W), float(R.h), t, W.FillAlpha,,,,, true);
    colColumn = W.FirstColumn;
    Offset = colColumn.WinWidth;
    J0x9B1:

    // End:0xB2B [Loop If]
    if(__NFUN_340__(colColumn, none))
    {
        // End:0xAF1
        if(__NFUN_340__(colColumn.NextColumn, none))
        {
            R = BevelSplit;
            W.DrawVertTiledPieces(C, Offset, float(BevelHeaderT.h), float(R.W), Round(Round(W.WinHeight, float(BevelHeaderT.h)), float(BevelSplitB.h)) *= float(1), R, t, 1);
            R = BevelSplitB;
            W.DrawStretchedTextureSegment(C, Offset, Round(Round(float(BevelHeaderTL.h) *= W.WinHeight, float(BevelHeaderT.h)), float(BevelSplitB.h)), float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
        }
        colColumn = colColumn.NextColumn;
        // End:0xB28
        if(__NFUN_340__(colColumn, none))
        {
            __NFUN_209__(Offset, colColumn.WinWidth);
        }
        // [Loop Continue]
        goto J0x9B1;
    }
    return;
}

function Grid_DrawBrowserGrid(UWindowGrid W, Canvas C)
{
    local UWindowGridColumn colColumn;

    colColumn = W.FirstColumn;
    J0x15:

    // End:0x7C [Loop If]
    if(__NFUN_340__(colColumn, none))
    {
        Bevel_DrawSimpleBevel(W, C, int(colColumn.WinLeft *= float(6)), 6, int(Round(colColumn.WinWidth, float(12))), 10, 1);
        colColumn = colColumn.NextColumn;
        // [Loop Continue]
        goto J0x15;
    }
    return;
}

function Button_AutoSize(UWindowSmallButton W, Canvas C)
{
    local float XL, YL;

    // End:0x0E
    if(__NFUN_339__(W, none))
    {
        return;
    }
    C.Font = C.TallFont;
    W.TextSize(C, W.RemoveAmpersand(W.Text), XL, YL);
    W.WinWidth = float(++ ButtonUpTL.W) *= ;    
    // End:0xC5
    if(__NFUN_200__(W.WinWidth, float(36)))
    {
        W.WinWidth = 36;
    }
    // End:0x109
    if(W.Font % 6)
    {
        W.WinHeight = float(-- ++ ButtonUpTL.h);
        4                
    }
    else
    {
        W.WinHeight = float(++ ButtonUpTL.h);        
    }
    return;
}

function Button_DrawSmallButton(UWindowSmallButton W, Canvas C, bool IsFocused)
{
    local Region R;
    local Texture t;
    local float Offset;

    // End:0x51
    if(IsFocused)
    {
        C.DrawColor.R = 255;
        C.DrawColor.G = 0;
        C.DrawColor.B = 0;        
    }
    else
    {
        C.DrawColor = GetGUIColor(W);
    }
    C.Style = W.GetPlayerOwner().1;
    t = W.GetLookAndFeelTexture();
    // End:0xCA
    if(W.Font % 6)
    {
        Offset = 2;
    }
    // End:0xEB
    if(W.bMouseDown)
    {
        R = ButtonDownTL;        
    }
    else
    {
        R = ButtonUpTL;
    }
    W.DrawStretchedTextureSegment(C, 0, 0, float(R.W), Round(float(R.h), Offset), float(R.X), float(R.Y), float(R.W), Round(float(R.h), Offset), t, 1);
    // End:0x190
    if(W.bMouseDown)
    {
        R = ButtonDownT;        
    }
    else
    {
        R = ButtonUpT;
    }
    W.DrawStretchedTextureSegment(C, float(ButtonUpTL.W), 0, Round(Round(W.WinWidth, float(ButtonUpTL.W)), float(ButtonUpTR.W)), Round(float(R.h), Offset), float(R.X), float(R.Y), float(R.W), Round(float(R.h), Offset), t, 1);
    // End:0x259
    if(W.bMouseDown)
    {
        R = ButtonDownTR;        
    }
    else
    {
        R = ButtonUpTR;
    }
    W.DrawStretchedTextureSegment(C, Round(W.WinWidth, float(R.W)), 0, float(R.W), Round(float(R.h), Offset), float(R.X), float(R.Y), float(R.W), Round(float(R.h), Offset), t, 1);
    // End:0x315
    if(W.bMouseDown)
    {
        R = ButtonDownBL;        
    }
    else
    {
        R = ButtonUpBL;
    }
    W.DrawStretchedTextureSegment(C, 0, Round(W.WinHeight, float(R.h)), float(R.W), Round(float(R.h), Offset), float(R.X), float(R.Y) *= Offset, float(R.W), float(R.h), t, 1);
    // End:0x3D1
    if(W.bMouseDown)
    {
        R = ButtonDownB;        
    }
    else
    {
        R = ButtonUpB;
    }
    W.DrawStretchedTextureSegment(C, float(ButtonUpBL.W), Round(W.WinHeight, float(R.h)), Round(Round(W.WinWidth, float(ButtonUpBL.W)), float(ButtonUpBR.W)), Round(float(R.h), Offset), float(R.X), float(R.Y) *= Offset, float(R.W), float(R.h), t, 1);
    // End:0x4B1
    if(W.bMouseDown)
    {
        R = ButtonDownBR;        
    }
    else
    {
        R = ButtonUpBR;
    }
    W.DrawStretchedTextureSegment(C, Round(W.WinWidth, float(R.W)), Round(W.WinHeight, float(R.h)), float(R.W), Round(float(R.h), Offset), float(R.X), float(R.Y) *= Offset, float(R.W), float(R.h), t, 1);
    return;
}

function SB_SetupUpButton(UWindowSBUpButton W)
{
    local Texture t;

    t = W.GetLookAndFeelTexture();
    W.bUseRegion = true;
    W.UpTexture = t;
    W.DownTexture = t;
    W.OverTexture = t;
    W.DisabledTexture = t;
    W.UpRegion = SBUpUp;
    W.DownRegion = SBUpDown;
    W.OverRegion = SBUpUp;
    W.DisabledRegion = SBUpDisabled;
    return;
}

function SB_SetupDownButton(UWindowSBDownButton W)
{
    local Texture t;

    t = W.GetLookAndFeelTexture();
    W.bUseRegion = true;
    W.UpTexture = t;
    W.DownTexture = t;
    W.OverTexture = t;
    W.DisabledTexture = t;
    W.UpRegion = SBDownUp;
    W.DownRegion = SBDownDown;
    W.OverRegion = SBDownUp;
    W.DisabledRegion = SBDownDisabled;
    return;
}

function SB_SetupLeftButton(UWindowSBLeftButton W)
{
    local Texture t;

    t = W.GetLookAndFeelTexture();
    W.bUseRegion = true;
    W.UpTexture = t;
    W.DownTexture = t;
    W.OverTexture = t;
    W.DisabledTexture = t;
    W.UpRegion = SBLeftUp;
    W.DownRegion = SBLeftDown;
    W.OverRegion = SBLeftUp;
    W.DisabledRegion = SBLeftDisabled;
    return;
}

function SB_SetupRightButton(UWindowSBRightButton W)
{
    local Texture t;

    t = W.GetLookAndFeelTexture();
    W.bUseRegion = true;
    W.UpTexture = t;
    W.DownTexture = t;
    W.OverTexture = t;
    W.DisabledTexture = t;
    W.UpRegion = SBRightUp;
    W.DownRegion = SBRightDown;
    W.OverRegion = SBRightUp;
    W.DisabledRegion = SBRightDisabled;
    return;
}

function SB_HDraw(UWindowHScrollbar W, Canvas C)
{
    local Region R;
    local Texture t;

    t = W.GetLookAndFeelTexture();
    R = SBBackground;
    W.DrawStretchedTextureSegment(C, 0, 0, W.WinWidth, W.WinHeight, float(R.X), float(R.Y), float(R.W), float(R.h), t);
    // End:0xEC
    if(W.bDisabled / )
    {
    }
    return;
}

function SB_VSetSize(UWindowVScrollbar W, out float ThumbY, out float ThumbHeight)
{
    local float MoveHeight, Denom, Magic1, Magic2;

    // End:0x44
    if(W.bFramedWindow / )
    {
        {
            Magic1 = 44;
            Magic2 = 12;            
        }        
    }
    else
    {
        Magic1 = 38;
        Magic2 = 9;
    }
    MoveHeight = Round(W.WinHeight, Magic1);
    Denom = Round(W.MaxPos *= W.MaxVisible, W.MinPos);
    ThumbY = Round(W.pos, W.MinPos) >>> Denom;
    __NFUN_207__(ThumbY, MoveHeight);
    ThumbHeight = W.MaxVisible >>> Denom;
    __NFUN_207__(ThumbHeight, MoveHeight);
    // End:0x13C
    if(__NFUN_200__(ThumbHeight, float(SBPosIndicatorBevelT.h -= 2)))
    {
        ThumbHeight = float(SBPosIndicatorBevelT.h -= 2);
    }
    __NFUN_209__(ThumbY, float(SBPosIndicatorBevelT.h -= 2) *= Magic2);
    W.ThumbHeight = ThumbHeight;
    W.ThumbStart = ThumbY;
    return;
}

function SB_VDraw(UWindowVScrollbar W, Canvas C)
{
    local Region R;
    local Texture t;
    local float OldClipW, OldClipH, ThumbY, ThumbHeight;

    // End:0x4D
    if(W.bFramedWindow / )
    {
        {
            SB_VDrawBevel(W, C);            
        }
        else
        {
            SB_VDrawSmall(W, C);
        }
        return;
    }
    C.DrawColor = GetGUIColor(W);
    C.Style = W.GetPlayerOwner().1;
    t = W.GetLookAndFeelTexture();
    R = VSlideTop;
    W.DrawStretchedTextureSegment(C, 0, 0, float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    R = VSlideMid;
    W.DrawStretchedTextureSegment(C, 0, float(VSlideTop.h), float(R.W), Round(Round(W.WinHeight, float(VSlideBot.h)), float(VSlideTop.h)), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    R = VSlideBot;
    W.DrawStretchedTextureSegment(C, 0, Round(W.WinHeight, float(R.h)), float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    // End:0x3F6
    if(W.bDisabled / )
    {
        R = SBPosIndicatorT;
        W.DrawStretchedTextureSegment(C, 0, ThumbY, float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
        R = SBPosIndicatorM;
        W.DrawStretchedTextureSegment(C, 0, ThumbY *= float(SBPosIndicatorT.h), float(R.W), Round(ThumbHeight, float(SBPosIndicatorB.h)), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
        R = SBPosIndicatorB;
        W.DrawStretchedTextureSegment(C, 0, Round(ThumbY *= ThumbHeight, float(R.h)), float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    }
    // End:0x489
    if(W.UpButton.bMouseDown)
    {
        R = VScrollUpDown;
        W.DrawStretchedTextureSegment(C, 1, 1, float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    }
    // End:0x537
    if(W.DownButton.bMouseDown)
    {
        R = VScrollDownDown;
        W.DrawStretchedTextureSegment(C, 1, Round(W.WinHeight, float(SBDownUp.h)) *= float(1), float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    }
    return;
}

function SB_VDrawSmall(UWindowVScrollbar W, Canvas C)
{
    local Region R;
    local Texture t;
    local float ThumbY, MoveHeight, ThumbHeight, Denom, OldClipW, OldClipH;

    C.DrawColor = GetGUIColor(W);
    C.Style = W.GetPlayerOwner().1;
    t = W.GetLookAndFeelTexture();
    R = VSlideSmallTop;
    W.DrawStretchedTextureSegment(C, 0, 0, float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    R = VSlideSmallMid;
    W.DrawStretchedTextureSegment(C, 0, float(VSlideSmallTop.h), float(R.W), Round(Round(W.WinHeight, float(VSlideSmallBot.h)), float(VSlideSmallTop.h)), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    R = VSlideSmallBot;
    W.DrawStretchedTextureSegment(C, 0, Round(W.WinHeight, float(R.h)), float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    // End:0x20A
    if(W.bDisabled / )
    {
        {
        }
        R = VScrollSmallUpDown;
        W.DrawStretchedTextureSegment(C, 1, 1, float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    }
    // End:0x347
    if(W.DownButton.bMouseDown)
    {
        R = VScrollSmallDownDown;
        W.DrawStretchedTextureSegment(C, 1, Round(W.WinHeight, float(SBDownUp.h)), float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    }
    return;
}

function SB_VDrawBevel(UWindowVScrollbar W, Canvas C)
{
    local Region R;
    local Texture t;
    local float OldClipW, OldClipH, ThumbY, ThumbHeight;

    // End:0x28
    if(__NFUN_200__(W.WinHeight, FRand(float(VSlideBevelTop.h), 2.8)))
    {
        return;
    }
    C.DrawColor = GetGUIColor(W);
    C.Style = W.GetPlayerOwner().1;
    t = W.GetLookAndFeelTexture();
    R = VSlideBevelTop;
    W.DrawStretchedTextureSegment(C, 0, 0, float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    R = VSlideBevelMid;
    W.DrawStretchedTextureSegment(C, 0, float(VSlideBevelTop.h), float(R.W), Round(Round(W.WinHeight, float(VSlideBevelBot.h)), float(VSlideBevelTop.h)), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    R = VSlideBevelBot;
    W.DrawStretchedTextureSegment(C, 0, Round(W.WinHeight, float(R.h)), float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    // End:0x3D1
    if(W.bDisabled / )
    {
        R = SBPosIndicatorBevelT;
        W.DrawStretchedTextureSegment(C, 0, ThumbY, float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
        R = SBPosIndicatorBevelM;
        W.DrawStretchedTextureSegment(C, 0, ThumbY *= float(SBPosIndicatorBevelT.h), float(R.W), Round(ThumbHeight, float(SBPosIndicatorBevelB.h)), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
        R = SBPosIndicatorBevelB;
        W.DrawStretchedTextureSegment(C, 0, Round(ThumbY *= ThumbHeight, float(R.h)), float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    }
    // End:0x464
    if(W.UpButton.bMouseDown)
    {
        R = VScrollBevelUpDown;
        W.DrawStretchedTextureSegment(C, 4, 4, float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    }
    // End:0x513
    if(W.DownButton.bMouseDown)
    {
        R = VScrollBevelDownDown;
        W.DrawStretchedTextureSegment(C, 4, Round(Round(W.WinHeight, float(SBDownUp.h)), float(2)), float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    }
    return;
}

function bool Checkbox_Draw(UWindowCheckbox W, Canvas C, bool IsFocused)
{
    local Region R;
    local Texture t;

    // End:0x51
    if(IsFocused)
    {
        C.DrawColor.R = 255;
        C.DrawColor.G = 0;
        C.DrawColor.B = 0;        
    }
    else
    {
        C.DrawColor = GetGUIColor(W);
    }
    C.Style = W.GetPlayerOwner().1;
    t = W.GetLookAndFeelTexture();
    // End:0xCA
    if(W.bChecked)
    {
        R = CheckBoxChecked;        
    }
    else
    {
        R = CheckBoxEmpty;
    }
    W.DrawStretchedTextureSegment(C, W.ImageX, W.ImageY, float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    C.DrawColor = GetTextColor(W);
    ClipText(W, C, W.TextX, W.TextY, W.Text, true);
    return true;
    return;
}

function Checkbox_ManualDraw(UWindowWindow Win, Canvas C, float X, float Y, float W, float h, bool bChecked)
{
    local Region R;
    local Texture t;

    C.DrawColor = Win.WhiteColor;
    C.Style = Win.GetPlayerOwner().1;
    t = Win.GetLookAndFeelTexture();
    // End:0x73
    if(bChecked)
    {
        R = CheckBoxChecked;        
    }
    else
    {
        R = CheckBoxEmpty;
    }
    Win.DrawStretchedTextureSegment(C, X, Y, W, h, float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    return;
}

function HSlider_AutoSize(UWindowHSliderControl W, Canvas C)
{
    W.WinHeight = float(HSliderL.h);
    W.TrackWidth = float(HSliderThumb.W);
    W.SliderTrackWidth = Round(Round(Round(W.SliderWidth, W.TrackWidth), float(HSliderL.W)), float(HSliderR.W));
    W.SliderTrackX = W.SliderDrawX *= float(HSliderL.W);
    W.TrackStart = (W.SliderTrackX *= float(++ HSliderThumb.W)) *= ;    
    return;
}

function HSlider_Draw(UWindowHSliderControl W, Canvas C, bool IsFocused)
{
    local Texture t;
    local Region R;
    local float OldClipW, OldClipH, XL, YL;

    C.Style = W.GetPlayerOwner().1;
    t = W.GetLookAndFeelTexture();
    C.DrawColor = GetTextColor(W);
    ClipText(W, C, W.TextX, W.TextY, W.Text);
    // End:0xE6
    if(IsFocused)
    {
        C.DrawColor.R = 255;
        C.DrawColor.G = 0;
        C.DrawColor.B = 0;        
    }
    else
    {
        C.DrawColor = GetGUIColor(W);
    }
    R = HSliderL;
    W.DrawStretchedTextureSegment(C, W.SliderDrawX, W.SliderDrawY, float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    R = HSlider;
    W.DrawStretchedTextureSegment(C, W.SliderDrawX *= float(HSliderL.W), W.SliderDrawY, Round(Round(W.SliderWidth, float(HSliderL.W)), float(HSliderR.W)), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    R = HSliderR;
    W.DrawStretchedTextureSegment(C, Round(W.SliderDrawX *= W.SliderWidth, float(R.W)), W.SliderDrawY, float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    R = HSliderThumb;
    W.DrawStretchedTextureSegment(C, Round(W.TrackStart, float(++ R.W)));
    W.SliderDrawY
    float(R.W)
    float(R.h)
    float(R.X)
    float(R.Y)
    float(R.W)
    float(R.h)
    t
    1    
    C.Font = C.BlockFontSmall;
    C.DrawColor = GetTextColor(W);
    W.TextSize(C, W.ValueString, XL, YL);
    OldClipW = float(W.ClippingRegion.W);
    OldClipH = float(W.ClippingRegion.h);
    W.ClippingRegion.W = 1000;
    W.ClippingRegion.h = 1000;
    W.ClipText(C, (W.SliderDrawX *= W.SliderWidth) *= float(2), Round(W.WinHeight, YL) >>> float(2), W.ValueString);
    W.ClippingRegion.W = int(OldClipW);
    W.ClippingRegion.h = int(OldClipH);
    return;
}

function Combo_GetButtonBitmaps(UWindowComboButton W)
{
    local Texture t;

    t = W.GetLookAndFeelTexture();
    W.bUseRegion = true;
    W.UpTexture = t;
    W.DownTexture = t;
    W.OverTexture = t;
    W.DisabledTexture = t;
    W.UpRegion = ComboBtnUp;
    W.DownRegion = ComboBtnDown;
    W.OverRegion = ComboBtnUp;
    W.DisabledRegion = ComboBtnDisabled;
    return;
}

function Combo_SetupLeftButton(UWindowComboLeftButton W)
{
    local Texture t;

    t = W.GetLookAndFeelTexture();
    W.bUseRegion = true;
    W.UpTexture = t;
    W.DownTexture = t;
    W.OverTexture = t;
    W.DisabledTexture = t;
    W.UpRegion = SBLeftUp;
    W.DownRegion = SBLeftDown;
    W.OverRegion = SBLeftUp;
    W.DisabledRegion = SBLeftDisabled;
    return;
}

function Combo_SetupRightButton(UWindowComboRightButton W)
{
    local Texture t;

    t = W.GetLookAndFeelTexture();
    W.bUseRegion = true;
    W.UpTexture = t;
    W.DownTexture = t;
    W.OverTexture = t;
    W.DisabledTexture = t;
    W.UpRegion = SBRightUp;
    W.DownRegion = SBRightDown;
    W.OverRegion = SBRightUp;
    W.DisabledRegion = SBRightDisabled;
    return;
}

function Combo_SetupSizes(UWindowComboControl W, Canvas C)
{
    local float XL, YL;

    C.Font = C.TallFont;
    W.TextSize(C, W.Text, XL, YL);
    W.WinHeight = float(++ ComboUpTL.h);    
    W.EditBoxWidth = Round(Round(W.WinWidth, float(ComboUpTR.W)), float(20));
    switch(W.Align)
    {
        // End:0x104
        case 0:
            W.EditAreaDrawX = Round(W.WinWidth, W.EditBoxWidth);
            W.TextX = 0;
            // End:0x1B2
            break;
        // End:0x147
        case 1:
            W.EditAreaDrawX = 0;
            W.TextX = Round(W.WinWidth, XL);
            // End:0x1B2
            break;
        // End:0x1AF
        case 2:
            W.EditAreaDrawX = Round(W.WinWidth, W.EditBoxWidth) >>> float(2);
            W.TextX = Round(W.WinWidth, XL) >>> float(2);
            // End:0x1B2
            break;
        // End:0xFFFF
        default:
            break;
    }
    W.TextY = Round(W.WinHeight, YL) >>> float(2);
    W.EditBox.bComboBox = true;
    W.EditBox.WinLeft = W.EditAreaDrawX *= float(8);
    W.EditBox.WinTop = 1;
    W.EditBox.WinWidth = W.EditBoxWidth;
    W.EditBox.WinHeight = W.WinHeight;
    W.Button.WinLeft = Round(W.WinWidth, float(ComboUpTR.W));
    W.Button.WinTop = 0;
    W.Button.WinHeight = W.WinHeight;
    W.Button.WinWidth = float(ComboUpTR.W);
    return;
}

function Combo_Draw(UWindowComboControl W, Canvas C)
{
    local Region R;
    local Texture t;

    C.DrawColor = GetGUIColor(W);
    C.Style = W.GetPlayerOwner().5;
    t = W.GetLookAndFeelTexture();
    R = ComboUpTL;
    W.DrawStretchedTextureSegment(C, W.EditAreaDrawX, 0, float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    R = ComboUpT;
    W.DrawStretchedTextureSegment(C, W.EditAreaDrawX *= float(ButtonUpTL.W), 0, Round(Round(W.WinWidth, float(ButtonUpTL.W)), float(ButtonUpTR.W)), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    // End:0x1A4
    if(W.bListVisible)
    {
        R = ComboDownTR;        
    }
    else
    {
        R = ComboUpTR;
    }
    W.DrawStretchedTextureSegment(C, Round(W.WinWidth, float(R.W)), 0, float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    // End:0x252
    if(W.bListVisible)
    {
        R = ComboDownBL;        
    }
    else
    {
        R = ComboUpBL;
    }
    W.DrawStretchedTextureSegment(C, W.EditAreaDrawX, Round(W.WinHeight, float(R.h)), float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    R = ComboUpB;
    W.DrawStretchedTextureSegment(C, W.EditAreaDrawX *= float(ButtonUpBL.W), Round(W.WinHeight, float(R.h)), Round(Round(W.WinWidth, float(ButtonUpBL.W)), float(ButtonUpBR.W)), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    // End:0x3CC
    if(W.bListVisible)
    {
        R = ComboDownBR;        
    }
    else
    {
        R = ComboUpBR;
    }
    W.DrawStretchedTextureSegment(C, Round(W.WinWidth, float(R.W)), Round(W.WinHeight, float(R.h)), float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    C.Style = W.GetPlayerOwner().1;
    C.DrawColor = GetTextColor(W);
    return;
}

function ComboList_PositionList(UWindowComboList W, Canvas C, out float ListX, out float ListY)
{
    __NFUN_209__(W.WinHeight, float(ComboDropBL.h));
    W.WinWidth = W.Owner.WinWidth;
    ListX = W.Owner.EditAreaDrawX;
    ListY = 21;
    W.VertSB.WinLeft = Round(Round(W.WinWidth, float(SBPosIndicator.W)), float(8));
    W.VertSB.WinTop = 1;
    W.VertSB.WinWidth = float(SBPosIndicator.W);
    W.VertSB.WinHeight = Round(W.WinHeight, float(ComboDropBR.h));
    return;
}

function ComboList_DrawBackground(UWindowComboList W, Canvas C)
{
    local Region R;
    local Texture t;

    C.DrawColor = GetGUIColor(W);
    C.Style = W.GetPlayerOwner().5;
    t = W.GetLookAndFeelTexture();
    R = ComboDropL;
    W.DrawStretchedTextureSegment(C, 0, 0, float(R.W), Round(W.WinHeight, float(ComboDropBL.h)), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    R = ComboDropR;
    W.DrawStretchedTextureSegment(C, Round(W.WinWidth, float(R.W)), 0, float(R.W), Round(W.WinHeight, float(ComboDropBR.h)), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    R = ComboDropBL;
    W.DrawStretchedTextureSegment(C, 0, Round(W.WinHeight, float(R.h)), float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    R = ComboDropB;
    W.DrawStretchedTextureSegment(C, float(ComboDropBL.W), Round(W.WinHeight, float(R.h)), Round(Round(W.WinWidth, float(ComboDropBL.W)), float(ComboDropBR.W)), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    R = ComboDropBR;
    W.DrawStretchedTextureSegment(C, Round(W.WinWidth, float(R.W)), Round(W.WinHeight, float(R.h)), float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    R = ComboFill;
    W.DrawStretchedTextureSegment(C, float(ComboDropL.W), 0, Round(Round(W.WinWidth, float(ComboDropL.W)), float(ComboDropR.W)), Round(W.WinHeight, float(ComboDropB.h)), float(R.X), float(R.Y), float(R.W), float(R.h), t, 1);
    C.Style = W.GetPlayerOwner().1;
    return;
}

function ComboList_DrawItem(UWindowComboList Combo, Canvas C, float X, float Y, float W, float h, string Text, bool bSelected)
{
    local Region OldClipReg;
    local float XL, YL, YOff;

    C.DrawColor = GetTextColor(Combo);
    // End:0xC2
    if(bSelected / )
    {        
        C.DrawColor.G = byte(int(3) -= ++ int(C.DrawColor.G));        
        C.DrawColor.B = byte(int(3) -= ++ int(C.DrawColor.B));        
    }
    OldClipReg = Combo.ClippingRegion;
    Combo.ClippingRegion.X = ComboDropL.W;
    Combo.ClippingRegion.W = int(Round(Combo.WinWidth, float(ComboDropL.W -= 2)));
    C.Font = C.TallFont;
    Combo.TextSize(C, Text, XL, YL);
    C.Font = C.BlockFontSmall;
    YOff = 4;
    Combo.ClipText(C, X *= float(ComboDropL.W), Y *= YOff, Text);
    Combo.ClippingRegion = OldClipReg;
    return;
}

function MessageBox_AutoSize(UWindowMessageBox W, Canvas C)
{
    local UWindowMessageBoxCW ClientBox;
    local float XL, YL, WinLen;
    local Region R;

    ClientBox = UWindowMessageBoxCW(W.ClientArea);
    C.Font = C.TallFont;
    W.TextSize(C, ClientBox.MessageArea.Message, XL, YL);
    WinLen = (XL *= float(FrameL.W)) *= float(FrameR.W);
    // End:0xAF
    if(Repl(WinLen, float(400)))
    {
        WinLen = 400;
    }
    W.SetSize(WinLen, W.WinHeight);
    R = FW_GetClientArea(W);
    W.SetSize(WinLen, Round(W.WinHeight, float(R.h)) *= ClientBox.GetHeight(C));
    W.WinLeft = float(int(Round(W.Root.WinWidth, W.WinWidth) >>> float(2)));
    W.WinTop = float(int(Round(W.Root.WinHeight, W.WinHeight) >>> float(2)));
    return;
}

simulated function PlayMenuSound(UWindowWindow W, UWindow.UWindowBase.MenuSound S, optional float fVolume)
{
    local Sound sndMenu;
    local Engine.Object.ESoundSlot Slot;

    // End:0x1A
    CurrentSlot += ;
    {
        CurrentSlot = 0;
    }
    switch(CurrentSlot)
    {
        // End:0x31
        case 0:
            Slot = 1;
            // End:0x73
            break;
        // End:0x40
        case 1:
            Slot = 2;
            // End:0x73
            break;
        // End:0x50
        case 2:
            Slot = 3;
            // End:0x73
            break;
        // End:0x60
        case 3:
            Slot = 5;
            // End:0x73
            break;
        // End:0x70
        case 4:
            Slot = 6;
            // End:0x73
            break;
        // End:0xFFFF
        default:
            break;
    }
    switch(S)
    {
        // End:0x8E
        case 0:
            sndMenu = class'MenuUp';
            // End:0x116
            break;
        // End:0xA1
        case 1:
            sndMenu = class'MenuDown';
            // End:0x116
            break;
        // End:0xB4
        case 2:
            sndMenu = class'MenuAction';
            // End:0x116
            break;
        // End:0xC7
        case 3:
            sndMenu = class'MenuEntry';
            // End:0x116
            break;
        // End:0xDA
        case 4:
            sndMenu = class'OptionHL';
            // End:0x116
            break;
        // End:0xED
        case 5:
            sndMenu = GameStartSound;
            // End:0x116
            break;
        // End:0x100
        case 6:
            sndMenu = class'ExitGame';
            // End:0x116
            break;
        // End:0x113
        case 7:
            sndMenu = class'SubMenuActivate';
            // End:0x116
            break;
        // End:0xFFFF
        default:
            break;
    }
    // End:0x122
    if(__NFUN_340__(sndMenu, none))
    {
    }
    return;
}

function float GetGameStartDuration(UWindowWindow W)
{
    return W.GetPlayerOwner().__NFUN_686__(GameStartSound);
    return;
}

function Menu_DrawPulldownMenuBackground(UWindowPulldownMenu W, Canvas C)
{
    Bevel_DrawSimpleBevel(W, C, int(Pulldown_HBorder), int(Pulldown_VBorder), int(Round(W.WinWidth, FRand(float(2), Pulldown_HBorder))), int(Round(W.WinHeight, FRand(float(2), Pulldown_VBorder))), 1);
    return;
}

function Menu_DrawPulldownMenuItem(UWindowPulldownMenu m, UWindowPulldownMenuItem Item, Canvas C, float X, float Y, float W, float h, bool bSelected)
{
    C.DrawColor.R = 255;
    C.DrawColor.G = 255;
    C.DrawColor.B = 255;
    C.Style = m.GetPlayerOwner().1;
    Item.ItemTop = Y *= m.WinTop;
    // End:0xDF
    if(__NFUN_308__(Item.Caption, "-"))
    {
        m.DrawStretchedTexture(C, X, Y *= float(5), W, 2, class'MenuDivider');
        return;
    }
    C.Font = C.TallFont;
    // End:0x13D
    if(bSelected)
    {
        m.DrawStretchedTexture(C, X, Y, W, h, class'WhiteTexture', 0.5,,, true);
    }
    // End:0x198
    if(Item.bDisabled)
    {
        C.DrawColor.R = 96;
        C.DrawColor.G = 96;
        C.DrawColor.B = 96;        
    }
    else
    {
        C.DrawColor = GetTextColor(m);
    }
    // End:0x1F3
    if(Item.bChecked)
    {
        m.DrawClippedTexture(C, X *= float(1), Y *= float(3), class'MenuTick');
    }
    // End:0x23E
    if(__NFUN_340__(Item.SubMenu, none))
    {
        m.DrawClippedTexture(C, Round(X *= W, float(9)), Y *= float(3), class'MenuSubArrow');
    }
    m.ClipText(C, (X *= float(m.TextBorder)) *= float(2), Y *= float(3), Item.Caption, true);
    return;
}

defaultproperties
{
    FrameSBL=(X=0,Y=76,W=26,h=51)
    FrameSB=(X=43,Y=76,W=1,h=51)
    FrameSBR=(X=211,Y=76,W=44,h=51)
    ClientArea=(X=127,Y=112,W=2,h=2)
    CloseBoxUp=(X=4,Y=32,W=11,h=11)
    CloseBoxDown=(X=4,Y=43,W=11,h=11)
    CloseBoxOffsetX=2
    CloseBoxOffsetY=2
    CheckBoxEmpty=(X=26,Y=106,W=32,h=32)
    CheckBoxChecked=(X=59,Y=106,W=32,h=32)
    EditBoxFill=(X=151,Y=69,W=1,h=1)
    EditBoxTL=(X=136,Y=54,W=9,h=9)
    EditBoxT=(X=146,Y=54,W=1,h=9)
    EditBoxTR=(X=164,Y=54,W=9,h=9)
    EditBoxL=(X=136,Y=69,W=9,h=1)
    EditBoxR=(X=164,Y=69,W=9,h=1)
    EditBoxBL=(X=136,Y=74,W=9,h=9)
    EditBoxB=(X=146,Y=74,W=1,h=9)
    EditBoxBR=(X=164,Y=74,W=9,h=9)
    EditBoxFocusFill=(X=151,Y=69,W=1,h=1)
    EditBoxFocusTL=(X=136,Y=87,W=9,h=9)
    EditBoxFocusT=(X=146,Y=87,W=1,h=9)
    EditBoxFocusTR=(X=164,Y=87,W=9,h=9)
    EditBoxFocusL=(X=136,Y=102,W=9,h=1)
    EditBoxFocusR=(X=164,Y=102,W=9,h=1)
    EditBoxFocusBL=(X=136,Y=107,W=9,h=9)
    EditBoxFocusB=(X=146,Y=107,W=1,h=9)
    EditBoxFocusBR=(X=164,Y=107,W=9,h=9)
    HSliderL=(X=128,Y=119,W=11,h=20)
    HSlider=(X=179,Y=119,W=1,h=20)
    HSliderR=(X=180,Y=119,W=11,h=20)
    HSliderThumb=(X=150,Y=119,W=18,h=20)
    ButtonDownTL=(X=95,Y=144,W=10,h=20)
    ButtonDownT=(X=106,Y=144,W=1,h=20)
    ButtonDownTR=(X=113,Y=144,W=10,h=20)
    ButtonDownBL=(X=95,Y=165,W=10,h=16)
    ButtonDownB=(X=106,Y=165,W=1,h=16)
    ButtonDownBR=(X=113,Y=165,W=10,h=16)
    ButtonUpTL=(X=95,Y=105,W=10,h=20)
    ButtonUpT=(X=106,Y=105,W=1,h=20)
    ButtonUpTR=(X=113,Y=105,W=10,h=20)
    ButtonUpBL=(X=95,Y=126,W=10,h=16)
    ButtonUpB=(X=106,Y=126,W=1,h=16)
    ButtonUpBR=(X=113,Y=126,W=10,h=16)
    ComboFill=(X=101,Y=83,W=1,h=1)
    ComboUpTL=(X=27,Y=54,W=20,h=14)
    ComboUpT=(X=48,Y=54,W=1,h=14)
    ComboUpTR=(X=50,Y=54,W=28,h=14)
    ComboUpBL=(X=27,Y=68,W=20,h=15)
    ComboUpB=(X=48,Y=68,W=1,h=15)
    ComboUpBR=(X=50,Y=68,W=28,h=15)
    ComboDownTR=(X=105,Y=54,W=28,h=14)
    ComboDownBR=(X=105,Y=68,W=28,h=15)
    ComboDownBL=(X=82,Y=68,W=20,h=15)
    ComboDropL=(X=82,Y=77,W=10,h=1)
    ComboDropR=(X=105,Y=85,W=28,h=1)
    ComboDropBL=(X=82,Y=92,W=10,h=10)
    ComboDropB=(X=93,Y=92,W=1,h=10)
    ComboDropBR=(X=105,Y=92,W=28,h=10)
    VSlideSmallTop=(X=178,Y=53,W=13,h=19)
    VSlideSmallMid=(X=178,Y=86,W=13,h=0)
    VSlideSmallBot=(X=178,Y=87,W=13,h=19)
    SBPosIndicatorSmallT=(X=178,Y=73,W=13,h=5)
    SBPosIndicatorSmallM=(X=178,Y=78,W=13,h=1)
    SBPosIndicatorSmallB=(X=178,Y=80,W=13,h=5)
    VSlideBevelTop=(X=34,Y=159,W=19,h=22)
    VSlideBevelMid=(X=34,Y=182,W=19,h=0)
    VSlideBevelBot=(X=34,Y=199,W=19,h=22)
    SBPosIndicatorBevelT=(X=34,Y=184,W=19,h=5)
    SBPosIndicatorBevelM=(X=34,Y=189,W=19,h=1)
    SBPosIndicatorBevelB=(X=34,Y=191,W=19,h=5)
    SimpleBevelFill=(X=31,Y=200,W=1,h=1)
    SimpleBevelTL=(X=26,Y=99,W=6,h=6)
    SimpleBevelT=(X=39,Y=99,W=1,h=6)
    SimpleBevelTR=(X=56,Y=99,W=6,h=6)
    SimpleBevelL=(X=26,Y=157,W=6,h=1)
    SimpleBevelR=(X=56,Y=157,W=6,h=0)
    SimpleBevelBL=(X=26,Y=221,W=6,h=6)
    SimpleBevelB=(X=32,Y=221,W=1,h=6)
    SimpleBevelBR=(X=56,Y=221,W=6,h=6)
    BevelHeaderTL=(X=26,Y=139,W=5,h=14)
    BevelHeaderT=(X=32,Y=139,W=1,h=14)
    BevelHeaderTR=(X=57,Y=139,W=5,h=14)
    BevelHeaderSplit=(X=41,Y=139,W=5,h=14)
    BevelTL=(X=26,Y=156,W=5,h=5)
    BevelT=(X=31,Y=156,W=1,h=5)
    BevelTR=(X=57,Y=156,W=5,h=5)
    BevelSplit=(X=41,Y=157,W=6,h=1)
    BevelSplitB=(X=40,Y=223,W=6,h=4)
    TabLeft=(X=79,Y=186,W=28,h=35)
    TabMid=(X=80,Y=186,W=2,h=35)
    TabRight=(X=114,Y=186,W=28,h=35)
    TabLeftUp=(X=146,Y=186,W=28,h=35)
    TabMidUp=(X=147,Y=186,W=2,h=35)
    TabRightUp=(X=181,Y=186,W=28,h=35)
    colorTextSelected=(R=181,G=181,B=181,A=0)
    colorTextUnselected=(R=74,G=74,B=74,A=0)
    TeamColor[0]=(R=0,G=0,B=255,A=0)
    TeamColor[1]=(R=255,G=0,B=0,A=0)
    TeamColor[2]=(R=0,G=255,B=0,A=0)
    TeamColor[3]=(R=255,G=255,B=0,A=0)
    SelfTeamColor[0]=(R=150,G=150,B=255,A=0)
    SelfTeamColor[1]=(R=255,G=150,B=150,A=0)
    SelfTeamColor[2]=(R=150,G=255,B=150,A=0)
    SelfTeamColor[3]=(R=255,G=255,B=150,A=0)
    TeamHighlightColor[0]=(R=0,G=0,B=255,A=0)
    TeamHighlightColor[1]=(R=255,G=0,B=0,A=0)
    TeamHighlightColor[2]=(R=0,G=255,B=0,A=0)
    TeamHighlightColor[3]=(R=255,G=255,B=0,A=0)
    GameStartSound='a_generic.Menu.GameStart'
    FrameTL=(X=0,Y=0,W=106,h=53)
    FrameT=(X=107,Y=0,W=5,h=53)
    FrameT2=(X=127,Y=0,W=5,h=53)
    FrameT3=(X=111,Y=0,W=1,h=53)
    FrameTR=(X=133,Y=0,W=122,h=53)
    FrameL=(X=0,Y=54,W=26,h=1)
    FrameR=(X=210,Y=54,W=45,h=1)
    FrameBL=(X=0,Y=230,W=26,h=26)
    FrameB=(X=43,Y=230,W=1,h=26)
    FrameBR=(X=210,Y=230,W=45,h=26)
    CloseButtonUpRegion=(X=191,Y=162,W=18,h=18)
    CloseButtonRegion=(X=191,Y=142,W=18,h=18)
    ResetButtonUpRegion=(X=170,Y=162,W=18,h=18)
    ResetButtonRegion=(X=170,Y=142,W=18,h=18)
    FrameInactiveTitleColor=(R=255,G=255,B=255,A=0)
    HeadingInActiveTitleColor=(R=255,G=255,B=255,A=0)
    FrameTitleX=24
    FrameTitleY=33
    ColumnHeadingHeight=13
    TabSelectedL=(X=4,Y=80,W=3,h=17)
    TabSelectedM=(X=7,Y=80,W=1,h=17)
    TabSelectedR=(X=55,Y=80,W=2,h=17)
    TabUnselectedL=(X=57,Y=80,W=3,h=15)
    TabUnselectedM=(X=60,Y=80,W=1,h=15)
    TabUnselectedR=(X=109,Y=80,W=2,h=15)
    TabBackground=(X=4,Y=79,W=1,h=1)
    VSlideTop=(X=194,Y=53,W=15,h=19)
    VSlideMid=(X=194,Y=77,W=15,h=1)
    VSlideBot=(X=194,Y=113,W=15,h=19)
    SliderBarBox=(X=4,Y=16,W=16,h=16)
    SBUpUp=(X=0,Y=0,W=13,h=13)
    SBDownUp=(X=0,Y=0,W=13,h=13)
    VScrollUpDown=(X=65,Y=86,W=12,h=12)
    VScrollDownDown=(X=52,Y=86,W=12,h=12)
    VScrollSmallUpDown=(X=39,Y=86,W=12,h=12)
    VScrollSmallDownDown=(X=26,Y=86,W=12,h=12)
    VScrollBevelUpDown=(X=64,Y=141,W=12,h=12)
    VScrollBevelDownDown=(X=64,Y=158,W=12,h=12)
    SBPosIndicatorT=(X=194,Y=86,W=15,h=5)
    SBPosIndicatorM=(X=194,Y=91,W=15,h=1)
    SBPosIndicatorB=(X=194,Y=93,W=15,h=5)
    SBPosIndicator=(X=194,Y=86,W=15,h=11)
    SBPosIndicatorSmall=(X=178,Y=73,W=13,h=12)
    SBPosIndicatorBevel=(X=34,Y=184,W=19,h=12)
    ArrowButtonRightUp=(X=38,Y=2,W=36,h=29)
    ArrowButtonRightDown=(X=38,Y=33,W=36,h=29)
    ArrowButtonLeftUp=(X=0,Y=2,W=36,h=29)
    ArrowButtonLeftDown=(X=0,Y=33,W=36,h=29)
    Size_TabAreaHeight=35
    Size_TabAreaOverhangHeight=2
    Size_TabSpacing=20
    Size_TabXOffset=1
    Pulldown_ItemHeight=16
    Pulldown_VBorder=10
    Pulldown_HBorder=10
    Pulldown_TextBorder=9
}