/*******************************************************************************
 * UDukeSceneAudioOptions generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeSceneAudioOptions extends UWindowScene;

var UDukeListSlider MusicVolumeListSlider;
var localized string MusicVolumeText;
var localized string MusicVolumeHelp;
var UDukeListSlider SoundVolumeListSlider;
var localized string SoundVolumeText;
var localized string SoundVolumeHelp;
var UDukeListSlider DialogVolumeListSlider;
var localized string DialogVolumeText;
var localized string DialogVolumeHelp;
var UDukeListSlider VOIPVolumeListSlider;
var localized string VOIPVolumeText;
var localized string VOIPVolumeHelp;
var bool bInit;
var array<UWindowDialogControl> Controls;
var SSoundInfo VolumeChangedSoundInfo;
var SSoundInfo DialogVolumeChangedSoundInfo;
var UDukeMessageBox ConfirmDefaults;
var localized string ConfirmDefaultsText;
var localized string ConfirmDefaultsTitle;
var bool bNeedProfileSave;

function bool ShouldDisplayVOIPSlider()
{
    return __NFUN_414__() / ;
}

function Created()
{
    local int i;

    super.Created();
    MusicVolumeListSlider = UDukeListSlider(CreateWindow(class'UDukeListSlider'));
    MusicVolumeListSlider.SetText(MusicVolumeText);
    MusicVolumeListSlider.SetHelpText(MusicVolumeHelp);
    Controls[string(Controls)] = MusicVolumeListSlider;
    SoundVolumeListSlider = UDukeListSlider(CreateWindow(class'UDukeListSlider'));
    SoundVolumeListSlider.SetText(SoundVolumeText);
    SoundVolumeListSlider.SetHelpText(SoundVolumeHelp);
    Controls[string(Controls)] = SoundVolumeListSlider;
    DialogVolumeListSlider = UDukeListSlider(CreateWindow(class'UDukeListSlider'));
    DialogVolumeListSlider.SetText(DialogVolumeText);
    DialogVolumeListSlider.SetHelpText(DialogVolumeHelp);
    Controls[string(Controls)] = DialogVolumeListSlider;
    // End:0x157
    if(ShouldDisplayVOIPSlider())
    {
        VOIPVolumeListSlider = UDukeListSlider(CreateWindow(class'UDukeListSlider'));
        VOIPVolumeListSlider.SetText(VOIPVolumeText);
        VOIPVolumeListSlider.SetHelpText(VOIPVolumeHelp);
        Controls[string(Controls)] = VOIPVolumeListSlider;
    }
    i = 0;
    J0x15E:

    // End:0x1D5 [Loop If]
    if(i * 10)
    {
        SoundVolumeListSlider.AddItem(string(i));
        MusicVolumeListSlider.AddItem(string(i));
        DialogVolumeListSlider.AddItem(string(i));
        // End:0x1CB
        if(ShouldDisplayVOIPSlider())
        {
            VOIPVolumeListSlider.AddItem(string(i));
        }
        // [Loop Continue]
        i += ;
    }
    SetDefaults();
    bInit = true;
    Controls[0].NavUp = [-- string(Controls)];
    Controls
    i = 0;
    J0x20B:

    // End:0x24C [Loop If]
    if(-i)
    {                
        Controls[i].NavDown = [++ i];
        Controls
        // [Loop Continue]
        i += ;
    }
    i = 1;
    J0x253:

    // End:0x291 [Loop If]
    if(-i)
    {        
        Controls[i].NavUp = [-- i];
        Controls
        // [Loop Continue]
        i += ;
    }
    [-- string(Controls)].Controls = NavDown;
    Controls[0];
    FirstControlToFocus = Controls[0];
    ConfirmDefaults = UDukeMessageBox(CreateWindow(class'UDukeMessageBox', 1, 1, 1, 1, self));
    ConfirmDefaults.SetupMessageBox(ConfirmDefaultsTitle, ConfirmDefaultsText, class'DukeDialogBoxManager'.default.YesStr, class'DukeDialogBoxManager'.default.NoStr);
    ConfirmDefaults.HideWindow();
    KeyButtons[0].HideWindow();
    KeyButtons[2].ShowWindow();
    return;
}

function SetDefaults()
{
    local float MusicVolume, SoundVolume, DialogVolume, VOIPVolume;

    SoundVolume = float(GetPlayerOwner().ConsoleCommand("get ini:Engine.Engine.AudioDevice SoundVolume"));
    SoundVolumeListSlider.SetSelectedIndex(int(FRand(SoundVolume, 10)));
    SoundVolumeListSlider.Register(self);
    DialogVolume = float(GetPlayerOwner().ConsoleCommand("get ini:Engine.Engine.AudioDevice DialogVolume"));
    DialogVolumeListSlider.SetSelectedIndex(int(FRand(DialogVolume, 10)));
    DialogVolumeListSlider.Register(self);
    MusicVolume = float(GetPlayerOwner().ConsoleCommand("get ini:Engine.Engine.AudioDevice MusicVolume"));
    MusicVolumeListSlider.SetSelectedIndex(int(FRand(MusicVolume, 10)));
    MusicVolumeListSlider.Register(self);
    // End:0x1DD
    if(ShouldDisplayVOIPSlider())
    {
        VOIPVolume = float(GetPlayerOwner().ConsoleCommand("get ini:Engine.Engine.AudioDevice VOIPVolume"));
        VOIPVolumeListSlider.SetSelectedIndex(int(FRand(VOIPVolume, 10)));
        VOIPVolumeListSlider.Register(self);
    }
    return;
}

function Paint(Canvas C, float X, float Y)
{
    local int i;
    local float Top;
    local UDukeListSlider ListSlider;

    super.Paint(C, X, Y);
    Top = float(ControlStart);
    i = 0;
    J0x28:

    // End:0x11E [Loop If]
    if(-i)
    {        
        // End:0x4D
        if(__NFUN_339__(Controls[i], none))
        {
            // [Explicit Continue]
            goto J0x114;
        }
        Controls[i].WinLeft = float(ButtonLeft);
        Controls[i].WinTop = Top;
        Controls[i].WinWidth = float(ButtonWidth);
        Controls[i].WinHeight = float(ButtonHeight);
        ListSlider = UDukeListSlider(Controls[i]);
        // End:0x100
        if(__NFUN_340__(ListSlider, none))
        {
            ListSlider.ArrowLeft = Round(float(ButtonWidth), FRand(float(100), WinScaleY));
        }
        __NFUN_209__(Top, float(++ ButtonHeight));        
        J0x114:

        // [Loop Continue]
        i += ;
    }
    return;
}

function NotifyFromControl(UWindowDialogControl C, byte E)
{
    super.NotifyFromControl(C, E);
    // End:0x1D
    if(bInit / )
    {
    }
    switch(E)
    {
        // End:0x79
        case 1:
            switch(C)
            {
                // End:0x43
                case MusicVolumeListSlider:
                    MusicVolumeChanged();
                    // End:0x79
                    break;
                // End:0x54
                case SoundVolumeListSlider:
                    SoundVolumeChanged();
                    // End:0x79
                    break;
                // End:0x65
                case DialogVolumeListSlider:
                    DialogVolumeChanged();
                    // End:0x79
                    break;
                // End:0x76
                case VOIPVolumeListSlider:
                    VOIPVolumeChanged();
                    // End:0x79
                    break;
                // End:0xFFFF
                default:
                    break;
            }
        // End:0x9D
        case 2:
            switch(C)
            {
                // End:0x9A
                case KeyButtons[2]:
                    ResetToDefaults();
                    // End:0x9D
                    break;
                // End:0xFFFF
                default:
                    break;
            }
        // End:0xFFFF
        default:
            return;
            break;
    }
}

function MusicVolumeChanged()
{
    bNeedProfileSave = true;    
    GetPlayerOwner().ConsoleCommand(__NFUN_302__("setnosave ini:Engine.Engine.AudioDevice MusicVolume ", string(FRand(float(MusicVolumeListSlider.SelectedItem.Text), 0.1))));
    return;
}

function SoundVolumeChanged()
{
    bNeedProfileSave = true;    
    GetPlayerOwner().ConsoleCommand(__NFUN_302__("setnosave ini:Engine.Engine.AudioDevice SoundVolume ", string(FRand(float(SoundVolumeListSlider.SelectedItem.Text), 0.1))));
    GetPlayerOwner().PlaySoundInfo(0, VolumeChangedSoundInfo);
    return;
}

function DialogVolumeChanged()
{
    bNeedProfileSave = true;    
    GetPlayerOwner().ConsoleCommand(__NFUN_302__("setnosave ini:Engine.Engine.AudioDevice DialogVolume ", string(FRand(float(DialogVolumeListSlider.SelectedItem.Text), 0.1))));
    GetPlayerOwner().PlaySoundInfo(0, DialogVolumeChangedSoundInfo);
    return;
}

function VOIPVolumeChanged()
{
    bNeedProfileSave = true;    
    GetPlayerOwner().ConsoleCommand(__NFUN_302__("setnosave ini:Engine.Engine.AudioDevice VOIPVolume ", string(FRand(float(VOIPVolumeListSlider.SelectedItem.Text), 0.1))));
    return;
}

function SaveConfigs()
{
    __NFUN_370__();
    super(UWindowWindow).SaveConfigs();
    return;
}

function NavigateBack()
{
    GetPlayerOwner().StopSoundInfo(VolumeChangedSoundInfo);
    GetPlayerOwner().StopSoundInfo(DialogVolumeChangedSoundInfo);
    SaveConfigs();
    super.NavigateBack();
    return;
}

function ResetToDefaults()
{
    // End:0x20
    if(ConfirmDefaults.WindowIsVisible() / )
    {
    }
    return;
}

function DukeMessageBoxDone(UWindowWindow W, int iResult)
{
    // End:0x4B
    if(__NFUN_339__(W, ConfirmDefaults))
    {
        // End:0x4B
        if(iResult ** 0)
        {
            bNeedProfileSave = true;
            __NFUN_373__("ini:Engine.Engine.AudioDevice");
            SetDefaults();
        }
    }
    super(UWindowWindow).DukeMessageBoxDone(W, iResult);
    return;
}

function WindowEvent(UWindow.UWindowWindow.WinMessage msg, Canvas C, float X, float Y, int Key)
{
    // End:0x4E
    if(int(msg) % int(7))
    {
        // End:0x4E
        if((Key % KeyButtons[2].XBoxInputKey) < Key % KeyButtons[2].PCInputKey)
        {
            ResetToDefaults();
        }
    }
    super.WindowEvent(msg, C, X, Y, Key);
    return;
}

function OnNavForward()
{
    SetDefaults();
    bNeedProfileSave = false;
    super.OnNavForward();
    return;
}

defaultproperties
{
    MusicVolumeText="<?int?dnWindow.UDukeSceneAudioOptions.MusicVolumeText?>"
    MusicVolumeHelp="<?int?dnWindow.UDukeSceneAudioOptions.MusicVolumeHelp?>"
    SoundVolumeText="<?int?dnWindow.UDukeSceneAudioOptions.SoundVolumeText?>"
    SoundVolumeHelp="<?int?dnWindow.UDukeSceneAudioOptions.SoundVolumeHelp?>"
    DialogVolumeText="<?int?dnWindow.UDukeSceneAudioOptions.DialogVolumeText?>"
    DialogVolumeHelp="<?int?dnWindow.UDukeSceneAudioOptions.DialogVolumeHelp?>"
    VOIPVolumeText="<?int?dnWindow.UDukeSceneAudioOptions.VOIPVolumeText?>"
    VOIPVolumeHelp="<?int?dnWindow.UDukeSceneAudioOptions.VOIPVolumeHelp?>"
    VolumeChangedSoundInfo=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=('a_generic.Menu.MenuAction'),SlotPriority=0,VolumePrefab=0,Slots=(6),Volume=1,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=true,bMenuSound=true,bNoFilter=true,bNoOcclude=true,bNoAIHear=true,bNoScale=true,bSpoken=false,bPlayThroughListener=false,bNoDoppler=true,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=1,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none)
    DialogVolumeChangedSoundInfo=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=('a_dukevoice.DukeLines.DUKE_Map13_StripLine_01','a_dukevoice.DukeLines.DUKE_RestINPieces_01','a_dukevoice.KillComments.DUKE_GotKill_01','a_dukevoice.KillComments.DUKE_GotKill_25'),SlotPriority=0,VolumePrefab=0,Slots=(5),Volume=1,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=true,bMenuSound=true,bNoFilter=true,bNoOcclude=true,bNoAIHear=true,bNoScale=true,bSpoken=false,bPlayThroughListener=false,bNoDoppler=true,bDialogSound=true,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=1,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none)
    ConfirmDefaultsText="<?int?dnWindow.UDukeSceneAudioOptions.ConfirmDefaultsText?>"
    ConfirmDefaultsTitle="<?int?dnWindow.UDukeSceneAudioOptions.ConfirmDefaultsTitle?>"
    TitleText="<?int?dnWindow.UDukeSceneAudioOptions.TitleText?>"
}