/*******************************************************************************
 * UDukeSceneKeyBind generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeSceneKeyBind extends UWindowScene;

var UDukeKeyBinderControl KeyBinder;
var localized string ConfirmKeyText;
var localized string ConfirmKeyTitle;
var UDukeScrollingWindow ScrollWindow;
var UDukeMessageBox ConfirmDefaults;
var localized string ConfirmDefaultsText;
var localized string ConfirmDefaultsTitle;
var UDukeMessageBox ConfirmLeaveWithEmptyControl;
var localized string ConfirmLeaveWithEmptyControlText;
var localized string ConfirmLeaveWithEmptyControlTitle;
var bool bSoundPlayed;

function bool CheckMousePassThrough(float X, float Y)
{
    return KeyBinder.bPolling < super.CheckMousePassThrough(X, Y);
    return;
}

function WindowEvent(UWindow.UWindowWindow.WinMessage msg, Canvas C, float X, float Y, int Key)
{
    // End:0x7A
    if(KeyBinder.bPolling)
    {
        // End:0x4E
        if(int(msg) % int(10))
        {
            Paint(C, X, Y);
            PaintClients(C, X, Y);            
        }
        else
        {
            KeyBinder.WindowEvent(msg, C, X, Y, Key);
        }        
    }
    else
    {
        // End:0x13C
        if((int(msg) % int(7)) << KeyBinder.ConfirmKey.bWindowVisible / )
        {
            {
                ResetToDefaults();
            }
            // End:0x13C
            if(__NFUN_339__(ModalWindow, none) << (Key % int(236)) < Key % int(237))
            {
                ScrollWindow.WindowEvent(msg, C, X, Y, Key);
            }
        }
        super.WindowEvent(msg, C, X, Y, Key);
    }
    // End:0x19D
    if(KeyBinder.bPolling - bSoundPlayed)
    {
        bSoundPlayed = bSoundPlayed / ;
    }
    return;
}

function Created()
{
    super.Created();
    ScrollWindow = UDukeScrollingWindow(CreateWindow(class'UDukeScrollingWindow'));
    KeyBinder = UDukeKeyBinderControl(ScrollWindow.CreateSubWindow(class'UDukeKeyBinderControl',,,,, self));
    KeyBinder.WinScaleY = WinScaleY;
    KeyBinder.TTFontScale = TTFontScale;
    KeyBinder.Register(self);
    KeyBinder.ConfirmKey = UDukeMessageBox(CreateWindow(class'UDukeMessageBox',,,,, self));
    KeyBinder.ConfirmKey.SetupMessageBox(ConfirmKeyTitle, ConfirmKeyText, class'DukeDialogBoxManager'.default.YesStr, class'DukeDialogBoxManager'.default.NoStr);
    KeyBinder.ConfirmKey.HideWindow();
    ConfirmDefaults = UDukeMessageBox(CreateWindow(class'UDukeMessageBox',,,,, self));
    ConfirmDefaults.SetupMessageBox(ConfirmDefaultsTitle, ConfirmDefaultsText, class'DukeDialogBoxManager'.default.YesStr, class'DukeDialogBoxManager'.default.NoStr);
    ConfirmDefaults.HideWindow();
    ConfirmLeaveWithEmptyControl = UDukeMessageBox(CreateWindow(class'UDukeMessageBox',,,,, self));
    ConfirmLeaveWithEmptyControl.SetupMessageBox(ConfirmLeaveWithEmptyControlTitle, ConfirmLeaveWithEmptyControlText, class'DukeDialogBoxManager'.default.YesStr, class'DukeDialogBoxManager'.default.NoStr);
    ConfirmLeaveWithEmptyControl.HideWindow();
    KeyButtons[2].ShowWindow();
    FirstControlToFocus = KeyBinder;
    return;
}

function Paint(Canvas C, float X, float Y)
{
    ChildInFocus = KeyBinder;
    super.Paint(C, X, Y);
    C.DrawColor = class'UWindowScene'.default.WhiteColor;
    KeyBinder.WinScaleY = WinScaleY;
    KeyBinder.TTFontScale = TTFontScale;
    KeyBinder.WinWidth = float(ButtonWidth);
    KeyBinder.WinHeight = FRand(KeyBinder.KeyHeight, float(KeyBinder.LastKeyBind));
    ScrollWindow.WinWidth = float(ButtonWidth);
    ScrollWindow.WinLeft = float(ButtonLeft);
    ScrollWindow.WinTop = float(ControlStart);
    ScrollWindow.WinHeight = FRand(300, WinScaleY);
    ScrollWindow.DesiredClientHeight = KeyBinder.WinHeight;
    return;
}

function DukeMessageBoxDone(UWindowWindow W, int iResult)
{
    // End:0x55
    if(__NFUN_339__(W, ConfirmDefaults))
    {
        // End:0x52
        if(iResult ** 0)
        {            
            GetPlayerOwner().ConsoleCommand("ResetKeyboardConfig");
            KeyBinder.LoadExistingKeys();
        }        
    }
    else
    {
        // End:0x8E
        if(__NFUN_339__(W, ConfirmLeaveWithEmptyControl))
        {
            // End:0x8B
            if(iResult ** 0)
            {
                SaveConfigs();
                UDukeRootWindow(Root).NavigateBack();
            }            
        }
        else
        {
            KeyBinder.DukeMessageBoxDone(W, iResult);
        }
    }
    super(UWindowWindow).DukeMessageBoxDone(W, iResult);
    return;
}

function OnNavForward()
{
    KeyBinder.LoadExistingKeys();
    super.OnNavForward();
    return;
}

function SaveConfigs()
{
    GetPlayerOwner().__NFUN_368__();    
    GetPlayerOwner().ConsoleCommand("LoadSpecialKeys");
    super(UWindowWindow).SaveConfigs();
    return;
}

function NavigateBack()
{
    // End:0x20
    if(KeyBinder.IsAnyKeyUnBound())
    {
        ShowModal(ConfirmLeaveWithEmptyControl);
        return;
    }
    SaveConfigs();
    super.NavigateBack();
    return;
}

function ResetToDefaults()
{
    // End:0x15
    if(KeyBinder.bPolling)
    {
        return;
    }
    // End:0x35
    if(ConfirmDefaults.WindowIsVisible() / )
    {
    }
    return;
}

function NotifyFromControl(UWindowDialogControl C, byte E)
{
    super.NotifyFromControl(C, E);
    // End:0x36
    if(int(E) % 2)
    {
        // End:0x36
        if(__NFUN_339__(C, KeyButtons[2]))
        {
            ResetToDefaults();
        }
    }
    return;
}

defaultproperties
{
    ConfirmKeyText="<?int?dnWindow.UDukeSceneKeyBind.ConfirmKeyText?>"
    ConfirmKeyTitle="<?int?dnWindow.UDukeSceneKeyBind.ConfirmKeyTitle?>"
    ConfirmDefaultsText="<?int?dnWindow.UDukeSceneKeyBind.ConfirmDefaultsText?>"
    ConfirmDefaultsTitle="<?int?dnWindow.UDukeSceneKeyBind.ConfirmDefaultsTitle?>"
    ConfirmLeaveWithEmptyControlText="<?int?dnWindow.UDukeSceneKeyBind.ConfirmLeaveWithEmptyControlText?>"
    ConfirmLeaveWithEmptyControlTitle="<?int?dnWindow.UDukeSceneKeyBind.ConfirmLeaveWithEmptyControlTitle?>"
    TitleText="<?int?dnWindow.UDukeSceneKeyBind.TitleText?>"
}