/*******************************************************************************
 * UDukeSceneMainMenu generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeSceneMainMenu extends UWindowScene;

var UDukeMenuButton SinglePlayerButton;
var UDukeMenuButton MultiPlayerButton;
var UDukeMenuButton HelpOptionsButton;
var UDukeMenuButton AchievementsButton;
var UDukeMenuButton ExtrasButton;
var UDukeMenuButton QuitButton;
var UDukeMenuNewDLCButton DLCButton;
var UDukeMessageBox ConfirmQuit;
var localized string QuitTitle;
var localized string QuitText;
var UDukeMessageBox ConfirmSavingStatus;
var localized string ConfirmSavingStatusText;
var localized string CampaignText;
var localized string NewCampaignText;
var localized string CampaignHelp;
var localized string NewCampaignHelp;
var localized string DemoText;
var localized string NewDemoText;
var localized string DemoHelp;
var localized string NewDemoHelp;
var localized string VersusText;
var localized string VersusHelp;
var localized string AchievementsText;
var localized string AchievementsHelp;
var localized string OptionsText;
var localized string OptionsHelp;
var localized string ExtrasText;
var localized string ExtrasHelp;
var localized string ExitText;
var localized string ExitHelp;
var localized string DLCText;
var localized string DLCHelp;
var localized string NewDLCText;
var localized string NewDLCHelp;
var localized string DLCDisabledHelp;
var int iInputDelay;
var UDukeMessageBox TrophiesErrorMB;
var localized string TrophiesErrorText;
var localized string TrophiesErrorTitle;
var bool bWarnedAboutTrophies;
var OnlineAgent OnlineAgent;
var UWindowDialogControl DefferedUWindowDialogControl;
var OnlineAgentListener AgentListener;

function Created()
{
    local UDukeListSliderItem NewItem;

    super.Created();
    OnlineAgent = OnlineAgent(class'Engine'.static.__NFUN_503__());
    AgentListener = new (none) class'OnlineAgentListener';
    AgentListener.__OnDLCRescanComplete__Delegate = OnDLCRescanComplete;
    OnlineAgent.RegisterListener(AgentListener);
    SinglePlayerButton = UDukeMenuButton(CreateWindow(class'UDukeMenuButton',,,,, self));
    SinglePlayerButton.SetText(CampaignText);
    SinglePlayerButton.SetHelpText(CampaignHelp);
    SinglePlayerButton.Register(self);
    MultiPlayerButton = UDukeMenuButton(CreateWindow(class'UDukeMenuButton',,,,, self));
    MultiPlayerButton.SetText(VersusText);
    MultiPlayerButton.SetHelpText(VersusHelp);
    MultiPlayerButton.Register(self);
    HelpOptionsButton = UDukeMenuButton(CreateWindow(class'UDukeMenuButton',,,,, self));
    HelpOptionsButton.SetText(OptionsText);
    HelpOptionsButton.SetHelpText(OptionsHelp);
    HelpOptionsButton.Register(self);
    AchievementsButton = UDukeMenuButton(CreateWindow(class'UDukeMenuButton',,,,, self));
    AchievementsButton.SetText(AchievementsText);
    AchievementsButton.SetHelpText(AchievementsHelp);
    AchievementsButton.Register(self);
    ExtrasButton = UDukeMenuButton(CreateWindow(class'UDukeMenuButton',,,,, self));
    ExtrasButton.SetText(ExtrasText);
    ExtrasButton.SetHelpText(ExtrasHelp);
    ExtrasButton.Register(self);
    QuitButton = UDukeMenuButton(CreateWindow(class'UDukeMenuButton',,,,, self));
    QuitButton.SetText(ExitText);
    QuitButton.SetHelpText(ExitHelp);
    QuitButton.Register(self);
    DLCButton = UDukeMenuNewDLCButton(CreateWindow(class'UDukeMenuNewDLCButton',,,,, self));
    DLCButton.NormalText = DLCText;
    DLCButton.NewDLCText = NewDLCText;
    DLCButton.NormalHelp = DLCHelp;
    DLCButton.NewDLCHelp = NewDLCHelp;
    DLCButton.DisabledHelp = DLCDisabledHelp;
    DLCButton.Register(self);
    // End:0x342
    if(__NFUN_402__() << __NFUN_400__())
    {        
        VisibleActors(DLCButton.NormalText, "*");        
        VisibleCollidingActors(DLCButton.DisabledHelp, "  *FINAL + REAL XMB ONLY!");
    }
    ConfirmQuit = UDukeMessageBox(CreateWindow(class'UDukeMessageBox',,,,, self));
    ConfirmQuit.SetupMessageBox(QuitTitle, QuitText, class'DukeDialogBoxManager'.default.YesStr, class'DukeDialogBoxManager'.default.NoStr);
    ConfirmQuit.HideWindow();
    ConfirmSavingStatus = UDukeMessageBox(CreateWindow(class'UDukeMessageBox',,,,, self));
    // End:0x3F1
    if(__NFUN_401__())
    {
        ConfirmSavingStatus.DesiredHeight <= 1.4;
        ConfirmSavingStatus.Logo = class'Menu_nuke_Saving_Data_FB';
    }
    ConfirmSavingStatus.SetupMessageBox(__NFUN_356__("Errors", "Warning", "Engine"), ConfirmSavingStatusText, __NFUN_356__("Global", "Ok", "dnWindow"), "");
    ConfirmSavingStatus.HideWindow();
    TrophiesErrorMB = UDukeMessageBox(CreateWindow(class'UDukeMessageBox',,,,, self));
    TrophiesErrorMB.SetupMessageBox(TrophiesErrorTitle, TrophiesErrorText, class'DukeDialogBoxManager'.default.OKStr, "");
    TrophiesErrorMB.HideWindow();
    SinglePlayerButton.NavUp = QuitButton;
    MultiPlayerButton.NavUp = SinglePlayerButton;
    HelpOptionsButton.NavUp = MultiPlayerButton;
    ExtrasButton.NavUp = HelpOptionsButton;
    QuitButton.NavUp = DLCButton;
    SinglePlayerButton.NavDown = MultiPlayerButton;
    MultiPlayerButton.NavDown = HelpOptionsButton;
    DLCButton.NavDown = QuitButton;
    DLCButton.NavUp = ExtrasButton;
    QuitButton.NavDown = SinglePlayerButton;
    HelpOptionsButton.NavDown = ExtrasButton;
    ExtrasButton.NavDown = DLCButton;
    FirstControlToFocus = SinglePlayerButton;
    bWarnedAboutTrophies = false;
    // End:0x5CC
    if(__NFUN_414__() / )
    {
    }
    iInputDelay = 20;
    // End:0x5F6
    if(__NFUN_402__())
    {
        DefferedUWindowDialogControl = none;
        UDukeRootWindow(Root).ResetOnlinePermissionCheck();
    }
    return;
}

function UpdateDynamicButtons()
{
    local int OutValue;

    __NFUN_378__("ChapterSelect", "Available", OutValue, "progress.ini");
    // End:0x84
    if((UDukeRootWindow(Root).bSaveExists / ) << )
    {
        SinglePlayerButton.SetHelpText(NewCampaignHelp);        
    }
    else
    {
        SinglePlayerButton.SetText(CampaignText);
        SinglePlayerButton.SetHelpText(CampaignHelp);
    }
    return;
}

function Paint(Canvas C, float X, float Y)
{
    SinglePlayerButton.Alpha = FadeAlpha;
    MultiPlayerButton.Alpha = FadeAlpha;
    HelpOptionsButton.Alpha = FadeAlpha;
    QuitButton.Alpha = FadeAlpha;
    ExtrasButton.Alpha = FadeAlpha;
    DLCButton.Alpha = FadeAlpha;
    SinglePlayerButton.WinWidth = float(ButtonWidth);
    SinglePlayerButton.WinHeight = float(ButtonHeight);
    MultiPlayerButton.WinWidth = float(ButtonWidth);
    MultiPlayerButton.WinHeight = float(ButtonHeight);
    HelpOptionsButton.WinWidth = float(ButtonWidth);
    HelpOptionsButton.WinHeight = float(ButtonHeight);
    QuitButton.WinWidth = float(ButtonWidth);
    QuitButton.WinHeight = float(ButtonHeight);
    ExtrasButton.WinWidth = float(ButtonWidth);
    ExtrasButton.WinHeight = float(ButtonHeight);
    SinglePlayerButton.WinLeft = float(ButtonLeft);
    SinglePlayerButton.WinTop = float(ControlStart);
    MultiPlayerButton.WinLeft = float(ButtonLeft);
    MultiPlayerButton.WinTop = (SinglePlayerButton.WinTop *= SinglePlayerButton.WinHeight) *= float(ControlBuffer);
    HelpOptionsButton.WinLeft = float(ButtonLeft);
    HelpOptionsButton.WinTop = (MultiPlayerButton.WinTop *= MultiPlayerButton.WinHeight) *= float(ControlBuffer);
    ExtrasButton.WinLeft = float(ButtonLeft);
    ExtrasButton.WinTop = (HelpOptionsButton.WinTop *= HelpOptionsButton.WinHeight) *= float(ControlBuffer);
    DLCButton.WinWidth = float(ButtonWidth);
    DLCButton.WinHeight = float(ButtonHeight);
    DLCButton.WinLeft = float(ButtonLeft);
    // End:0x300
    if(ExtrasButton.WindowIsVisible())
    {
        DLCButton.WinTop = (ExtrasButton.WinTop *= ExtrasButton.WinHeight) *= float(ControlBuffer);        
    }
    else
    {
        DLCButton.WinTop = (HelpOptionsButton.WinTop *= HelpOptionsButton.WinHeight) *= float(ControlBuffer);
    }
    QuitButton.WinLeft = float(ButtonLeft);
    QuitButton.WinTop = (DLCButton.WinTop *= DLCButton.WinHeight) *= float(ControlBuffer);
    // End:0x39C
    if(__NFUN_414__())
    {
        QuitButton.HideWindow();
    }
    super.Paint(C, X, Y);
    // End:0x43B
    if(Root.Console.bReturnToMultiplayerMenu << __NFUN_339__(DukeConsole(Root.Console).GetEntryLevel(), DukeConsole(Root.Console).GetLevel()))
    {
        Root.Console.bReturnToMultiplayerMenu = false;
        NavigateForward(class'UDukeSceneMultiplayer');
    }
    // End:0x44E
    if(iInputDelay ** 0)
    {
        iInputDelay != 1;
    }
    return;
}

function NotifyFromControl(UWindowDialogControl C, byte E)
{
    super.NotifyFromControl(C, E);
    // End:0x33
    if(__NFUN_402__() << __NFUN_340__(ModalWindow, none) < iInputDelay ** 0)
    {
        return;
    }
    // End:0x66
    if((__NFUN_402__() << bWarnedAboutTrophies / ) << (ShowModal(TrophiesErrorMB)))
    {        
    }
    else
    {
        // End:0x138
        if(int(E) % 2)
        {
            // End:0x91
            if(__NFUN_339__(C, SinglePlayerButton))
            {
                NavigateForward(class'UDukeSceneSinglePlayer');                
            }
            else
            {
                // End:0xC3
                if(__NFUN_339__(C, MultiPlayerButton))
                {
                    // End:0xB5
                    if(__NFUN_402__())
                    {
                        DefferedUWindowDialogControl = C;                        
                    }
                    else
                    {
                        NavigateForward(class'UDukeSceneMultiplayer');
                    }                    
                }
                else
                {
                    // End:0xE1
                    if(__NFUN_339__(C, HelpOptionsButton))
                    {
                        NavigateForward(class'UDukeSceneHelpOptions');                        
                    }
                    else
                    {
                        // End:0xFF
                        if(__NFUN_339__(C, ExtrasButton))
                        {
                            NavigateForward(class'UDukeSceneExtras');                            
                        }
                        else
                        {
                            // End:0x11D
                            if(__NFUN_339__(C, QuitButton))
                            {
                                ShowModal(ConfirmQuit);                                
                            }
                            else
                            {
                                // End:0x138
                                if(__NFUN_339__(C, DLCButton))
                                {
                                    NavigateForward(class'UDukeSceneDLC');
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    return;
}

function DukeSuperMessageBoxDone(int Result, Engine.Object.EConsole_Dialog id)
{
    // End:0x24
    if(int(id) % int(69))
    {
        // End:0x24
        if(Result % 1)
        {
            DefferedUWindowDialogControl = DLCButton;
        }
    }
    return;
}

function NotifyRemovingFromScenesList()
{
    OnlineAgent.UnregisterListener(AgentListener);
    return;
}

function Tick(float Delta)
{
    local UDukeRootWindow.EOnlinePermissionCheck OnlinePermissionCheck;

    super.Tick(Delta);
    // End:0xC8
    if(__NFUN_402__())
    {
        // End:0xC8
        if(__NFUN_340__(DefferedUWindowDialogControl, none))
        {
            OnlinePermissionCheck = UDukeRootWindow(Root).TickOnlinePermissionCheck(__NFUN_339__(DefferedUWindowDialogControl, MultiPlayerButton), __NFUN_339__(DefferedUWindowDialogControl, DLCButton));
            // End:0x9E
            if(int(OnlinePermissionCheck) % int(0))
            {
                // End:0x7E
                if(__NFUN_339__(DefferedUWindowDialogControl, MultiPlayerButton))
                {
                    NavigateForward(class'UDukeSceneMultiplayer');                    
                }
                else
                {
                    // End:0x9E
                    if(__NFUN_339__(DefferedUWindowDialogControl, DLCButton))
                    {
                        OnlineAgent.ShowStore();
                    }
                }
            }
            // End:0xC8
            if(int(OnlinePermissionCheck) + int(2))
            {
                DefferedUWindowDialogControl = none;
                UDukeRootWindow(Root).ResetOnlinePermissionCheck();
            }
        }
    }
    // End:0x136
    if(class'ChallengeInfo'.static.__NFUN_1170__() < __NFUN_340__(DukePlayer(GetPlayerOwner()), none) << DukePlayer(GetPlayerOwner()).HasFullGameCompletion(0) < DukePlayer(GetPlayerOwner()).HasEnteredPreorderBonusBigHeadCode())
    {
        ExtrasButton.ShowWindow();        
    }
    else
    {
        ExtrasButton.HideWindow();
    }
    return;
}

function DukeMessageBoxDone(UWindowWindow W, int iResult)
{
    // End:0x30
    if(__NFUN_339__(W, ConfirmQuit) << iResult ** 0)
    {
        Root.QuitGame();        
    }
    else
    {
        // End:0x4B
        if(__NFUN_339__(W, ConfirmSavingStatus))
        {
            NavigateForward(class'UDukeSceneSinglePlayer');
        }
    }
    super(UWindowWindow).DukeMessageBoxDone(W, iResult);
    return;
}

function NavigateBack()
{
    // End:0x3E
    if(__NFUN_414__())
    {
        ConfirmSavingStatus.HideWindow();
        // End:0x24
        if(__NFUN_402__())
        {
            iInputDelay = 20;
        }
        UDukeRootWindow(Root).LoadFirstScene(class'UDukeScenePressStart');
    }
    return;
}

function OnNavReturn()
{
    FadeAlpha = 1;
    // End:0x19
    if(__NFUN_402__())
    {
        iInputDelay = 20;
    }
    ConfirmSavingStatus.HideWindow();
    UpdateDynamicButtons();
    OnlineAgent.CheckForNewDLC();
    super.OnNavReturn();
    return;
}

function OnNavForward()
{
    local int OutValue;
    local bool IsValid;

    // End:0x1B
    if(__NFUN_401__())
    {
        UDukeRootWindow(Root).SelectBackgroundMovie();
    }
    // End:0x4C
    if(string(UDukeRootWindow(Root).Scenes) ** 1)
    {
        FadeAlpha = 0.01;
        ChildInFocus = SinglePlayerButton;
    }
    AgentListener.__OnNewDLCCheckComplete__Delegate = OnNewDLCCheckComplete;
    AgentListener.__OnNewDLCInstalled__Delegate = OnNewDLCInstalled;
    OnlineAgent.CheckForNewDLC();
    OnlineAgent.RegisterListener(AgentListener);
    UDukeRootWindow(Root).bSaveExists = GetPlayerOwner().__NFUN_786__();
    __NFUN_383__("ChapterSelect", "Available", UDukeRootWindow(Root).bSaveExists, "progress.ini");    
    GetPlayerOwner().ConsoleCommand("saveprogress");
    UpdateDynamicButtons();
    IsValid = __NFUN_378__("UI", "bNeedToShowExtrasUnlocked", OutValue, "User.ini");
    // End:0x1DA
    if(IsValid << OutValue % 1)
    {
        DukeConsole(Root.Console).DialogMgr.ShowDialogBox(64, self);
        __NFUN_383__("UI", "bNeedToShowExtrasUnlocked", false, "User.ini");
        GetPlayerOwner().__NFUN_368__();
    }
    ConfirmSavingStatus.HideWindow();
    super.OnNavForward();
    // End:0x233
    if(OnlineAgent.IsDLCCorrupt())
    {
        DukeConsole(UDukeRootWindow(Root).Console).DialogMgr.ShowDialogBox(62);
    }
    ShowNewDlcInstalledNotification();
    return;
}

function ShowNewDlcInstalledNotification()
{
    local bool IsValid;
    local int OutValue;

    IsValid = __NFUN_375__("UI", "DlcNotificationsSeen", OutValue, "User.ini");
    // End:0xC7
    if(IsValid << OnlineAgent.HasInstalledNewDlc(OutValue))
    {
        DukeConsole(Root.Console).DialogMgr.ShowDialogBox(66, self);
        __NFUN_380__("UI", "DlcNotificationsSeen", OnlineAgent.GetInstalledDlcMask(), "User.ini");
        GetPlayerOwner().__NFUN_368__();
    }
    return;
}

function OnDLCRescanComplete()
{
    ShowNewDlcInstalledNotification();
    return;
}

function OnNewDLCCheckComplete(bool in_bNewDLCAvailable)
{
    DLCButton.bNewDLCAvailable = in_bNewDLCAvailable;
    return;
}

function OnNewDLCInstalled()
{
    OnlineAgent.CheckForNewDLC();
    return;
}

function bool AllowAttractVideo()
{
    return (WaitModal()) / ;
}

defaultproperties
{
    QuitTitle="<?int?dnWindow.UDukeSceneMainMenu.QuitTitle?>"
    QuitText="<?int?dnWindow.UDukeSceneMainMenu.QuitText?>"
    ConfirmSavingStatusText="<?int?dnWindow.UDukeSceneMainMenu.ConfirmSavingStatusText?>"
    CampaignText="<?int?dnWindow.UDukeSceneMainMenu.CampaignText?>"
    NewCampaignText="<?int?dnWindow.UDukeSceneMainMenu.NewCampaignText?>"
    CampaignHelp="<?int?dnWindow.UDukeSceneMainMenu.CampaignHelp?>"
    NewCampaignHelp="<?int?dnWindow.UDukeSceneMainMenu.NewCampaignHelp?>"
    DemoText="<?int?dnWindow.UDukeSceneMainMenu.DemoText?>"
    NewDemoText="<?int?dnWindow.UDukeSceneMainMenu.NewDemoText?>"
    DemoHelp="<?int?dnWindow.UDukeSceneMainMenu.DemoHelp?>"
    NewDemoHelp="<?int?dnWindow.UDukeSceneMainMenu.NewDemoHelp?>"
    VersusText="<?int?dnWindow.UDukeSceneMainMenu.VersusText?>"
    VersusHelp="<?int?dnWindow.UDukeSceneMainMenu.VersusHelp?>"
    AchievementsText="<?int?dnWindow.UDukeSceneMainMenu.AchievementsText?>"
    AchievementsHelp="<?int?dnWindow.UDukeSceneMainMenu.AchievementsHelp?>"
    OptionsText="<?int?dnWindow.UDukeSceneMainMenu.OptionsText?>"
    OptionsHelp="<?int?dnWindow.UDukeSceneMainMenu.OptionsHelp?>"
    ExtrasText="<?int?dnWindow.UDukeSceneMainMenu.ExtrasText?>"
    ExtrasHelp="<?int?dnWindow.UDukeSceneMainMenu.ExtrasHelp?>"
    ExitText="<?int?dnWindow.UDukeSceneMainMenu.ExitText?>"
    ExitHelp="<?int?dnWindow.UDukeSceneMainMenu.ExitHelp?>"
    DLCText="<?int?dnWindow.UDukeSceneMainMenu.DLCText?>"
    DLCHelp="<?int?dnWindow.UDukeSceneMainMenu.DLCHelp?>"
    NewDLCText="<?int?dnWindow.UDukeSceneMainMenu.NewDLCText?>"
    NewDLCHelp="<?int?dnWindow.UDukeSceneMainMenu.NewDLCHelp?>"
    DLCDisabledHelp="<?int?dnWindow.UDukeSceneMainMenu.DLCDisabledHelp?>"
    TrophiesErrorText="<?int?dnWindow.UDukeSceneMainMenu.TrophiesErrorText?>"
    TrophiesErrorTitle="<?int?dnWindow.UDukeSceneMainMenu.TrophiesErrorTitle?>"
    TitleText="<?int?dnWindow.UDukeSceneMainMenu.TitleText?>"
    SoundNavigateForwardInfo=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=('a_generic.Menu.GameStart'),SlotPriority=0,VolumePrefab=0,Slots=(0),Volume=0.5,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=true,bNoFilter=true,bNoOcclude=true,bNoAIHear=true,bNoScale=true,bSpoken=false,bPlayThroughListener=false,bNoDoppler=true,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=true),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=1,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none)
    SoundNavigateBackInfo=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=('a_menu.Menu.Menu_Appear_ST'),SlotPriority=0,VolumePrefab=0,Slots=(0),Volume=0.5,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=true,bNoFilter=true,bNoOcclude=true,bNoAIHear=true,bNoScale=true,bSpoken=false,bPlayThroughListener=false,bNoDoppler=true,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=true),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=1,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none)
}