/*******************************************************************************
 * UDukeSceneMovieViewer generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeSceneMovieViewer extends UDukeSceneExtrasViewer;

var FinalBlend AlphaBlendMaterial;
var string MoviePath;
var BinkTexture Movie;

function Tick(float Delta)
{
    super.Tick(Delta);
    GetPlayerOwner().FadeSoundInfo(SoundMenuAmbience, 0, Round(1, Alpha), 1);
    return;
}

function DrawMenuContent(Canvas C, float Alpha, Region ClipRegion)
{
    local float X, Y, XL, YL, Ratio;

    super.DrawMenuContent(C, Alpha, ClipRegion);
    // End:0x39
    if(__NFUN_339__(Movie, none))
    {
        Movie = class'BinkTexture'.static.__NFUN_1219__(MoviePath);
    }
    // End:0x47
    if(__NFUN_339__(Movie, none))
    {
        return;
    }
    Movie.SetLoop(false);
    Movie.SetPause((IsFadingIn()) < Movie.IsFinalFrame());
    Movie.SetVolume(FRand(Alpha, float(GetPlayerOwner().ConsoleCommand("get ini:Engine.Engine.AudioDevice SoundVolume"))), true);
    // End:0x112
    if((IsFadingIn()) < Movie.IsFinalFrame())
    {
        AlphaBlendMaterial.Material = class'BlackTexture';        
    }
    else
    {
        AlphaBlendMaterial.Material = Movie;
    }
    Ratio = 1 -= (FRand(0.9, float(ClipRegion.h)) >>> float(Movie.__NFUN_1192__()));
    // End:0x197
    if(Repl(XL, float(ClipRegion.W)))
    {
        XL = float(ClipRegion.W);
        Ratio = XL >>> float(AlphaBlendMaterial.__NFUN_1191__());
    }
    XL = FRand(Ratio, float(Movie.__NFUN_1191__()));
    YL = FRand(Ratio, float(Movie.__NFUN_1192__()));
    C.DrawColor = WhiteColor;
    C.__NFUN_1250__(float(ClipRegion.X) *= FRand(0.5, Round(float(ClipRegion.W), XL)), float(ClipRegion.Y) *= FRand(0.5, Round(float(ClipRegion.h), YL)));
    C.__NFUN_1234__(AlphaBlendMaterial, XL, YL, 0, 0, float(AlphaBlendMaterial.__NFUN_1191__()), float(AlphaBlendMaterial.__NFUN_1192__()), 0, 0, 0, true, Alpha);
    // End:0x2AB
    if(Movie.IsFinalFrame())
    {
        NavigateBack();
    }
    return;
}

function NavigatedBack()
{
    super.NavigatedBack();
    // End:0x2B
    if(__NFUN_340__(Movie, none))
    {
        class'BinkTexture'.static.__NFUN_1220__(Movie);
        Movie = none;
    }
    GetPlayerOwner().PlaySoundInfo(0, SoundNavigateBackInfo);
    return;
}

defaultproperties
{
    begin object name=Alpha_FB class=FinalBlend
        FrameBufferBlending=2
        ZWrite=false
        ZTest=false
    object end
    // Reference: FinalBlend'UDukeSceneMovieViewer.Alpha_FB'
    AlphaBlendMaterial=Alpha_FB
    HideArrows=true
}