/*******************************************************************************
 * UDukeScenePictureViewer generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeScenePictureViewer extends UDukeSceneExtrasViewer;

struct SPictureEntry
{
    var string Path;
    var string Title;
    var string UnlockTag;
};

var FinalBlend AlphaBlendMaterial;
var array<SPictureEntry> Pictures;
var int PictureIndex;

function Created()
{
    local int i;

    super.Created();
    i = 0;
    J0x0D:

    // End:0x3A [Loop If]
    if(-i)
    {        
        ListSlider.AddItem(" ");
        // [Loop Continue]
        i += ;
    }
    ListSlider.SetSelectedIndex(0);
    ListSlider.Register(self);
    return;
}

function UpdatePicture()
{
    local int Unlocked;

    AlphaBlendMaterial.Material = Texture(__NFUN_366__(Pictures[ListSlider.GetSelectedIndex()].Path, class'Texture'));
    Pictures[ListSlider.GetSelectedIndex()].Title = __NFUN_356__(string(Class.Name), __NFUN_302__(__NFUN_302__("PictureTitles[", string(ListSlider.GetSelectedIndex())), "]"), "dnWindow");
    return;
}

function OnNavForward()
{
    super.OnNavForward();
    // End:0x2F
    if(string(Pictures) ** 0)
    {
        PictureIndex = Exp(PictureIndex, 0, -- string(Pictures));        
        UpdatePicture();
    }
    return;
}

function PrevPicture()
{
    // End:0x30
    if(PictureIndex ** 0)
    {
        PictureIndex -= ;
        GetPlayerOwner().PlaySoundInfo(0, SoundNavigateInfo);
    }
    return;
}

function NextPicture()
{
    // End:0x38
    if(-PictureIndex)
    {                
        PictureIndex += ;
        GetPlayerOwner().PlaySoundInfo(0, SoundNavigateInfo);
    }
    return;
}

function NotifyFromControl(UWindowDialogControl C, byte E)
{
    super(UWindowScene).NotifyFromControl(C, E);
    UpdatePicture();
    return;
}

function DrawMenuContent(Canvas C, float Alpha, Region ClipRegion)
{
    local string PictureTitle;
    local float TTFontScale, Padding, Ratio, XL, YL, AlignTop,
	    MaxHeight;

    super.DrawMenuContent(C, Alpha, ClipRegion);
    // End:0x40
    if(__NFUN_339__(AlphaBlendMaterial.Material, none))
    {
        AlphaBlendMaterial.Material = class'BlackTexture';
    }
    TTFontScale = class'UWindowScene'.default.TTFontScale;
    Padding = FRand(12, C.FixedScale);
    PictureTitle = __NFUN_303__(__NFUN_303__(__NFUN_303__("(", string(++ ListSlider.GetSelectedIndex()))), ") ");
    Pictures[ListSlider.GetSelectedIndex()].Title;    
    C.DrawColor = GreyColor;
    C.Font = C.TallFont;
    C.__NFUN_1238__(PictureTitle, XL, YL, TTFontScale, TTFontScale);
    C.__NFUN_1250__(FRand(0.5, Round(float(C.SizeX), XL)), float(ClipRegion.Y) *= Padding);
    C.__NFUN_1232__(PictureTitle, false, false, false, TTFontScale, TTFontScale, Alpha);
    MaxHeight = Round(float(ClipRegion.h), YL *= FRand(3, Padding));
    AlignTop = (float(ClipRegion.Y) *= YL) *= FRand(2, Padding);
    Ratio = 1 -= (MaxHeight >>> float(AlphaBlendMaterial.__NFUN_1192__()));
    XL = FRand(Ratio, float(AlphaBlendMaterial.__NFUN_1191__()));
    // End:0x23B
    if(Repl(XL, float(ClipRegion.W)))
    {
        XL = float(ClipRegion.W);
        Ratio = XL >>> float(AlphaBlendMaterial.__NFUN_1191__());
    }
    YL = FRand(Ratio, float(AlphaBlendMaterial.__NFUN_1192__()));
    C.DrawColor = WhiteColor;
    C.__NFUN_1250__(float(ClipRegion.X) *= FRand(0.5, Round(float(ClipRegion.W), XL)), AlignTop *= FRand(0.5, Round(MaxHeight, YL)));
    C.__NFUN_1234__(AlphaBlendMaterial, XL, YL, 0, 0, float(AlphaBlendMaterial.__NFUN_1191__()), float(AlphaBlendMaterial.__NFUN_1192__()), 0, 0, 0, true, Alpha);
    return;
}

defaultproperties
{
    begin object name=PictureAlpha_FB class=FinalBlend
        FrameBufferBlending=2
        ZWrite=false
        ZTest=false
    object end
    // Reference: FinalBlend'UDukeScenePictureViewer.PictureAlpha_FB'
    AlphaBlendMaterial=PictureAlpha_FB
}