/*******************************************************************************
 * UDukeSceneSinglePlayerPauseMenu generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeSceneSinglePlayerPauseMenu extends UWindowScene;

var UDukeMenuButton InviteButton;
var string InviteText;
var string InviteHelp;
var UDukeMenuButton ResumeButton;
var localized string ResumeText;
var localized string ResumeHelp;
var UDukeMenuButton LoadLastCheckpointButton;
var localized string LoadLastCheckpointText;
var localized string LoadLastCheckpointHelp;
var localized string RestartLevelText;
var localized string RestartLevelHelp;
var UDukeMenuButton HelpOptionsButton;
var localized string HelpOptionsText;
var localized string HelpOptionsHelp;
var UDukeMenuButton ExtrasButton;
var localized string ExtrasText;
var localized string ExtrasHelp;
var UDukeMenuButton QuitButton;
var localized string QuitText;
var localized string QuitHelp;
var UDukeMessageBox ConfirmQuit;
var localized string ConfirmQuitTitle;
var localized string ConfirmQuitText;
var UDukeMessageBox ConfirmLoad;
var localized string ConfirmLoadTitle;
var localized string ConfirmLoadText;
var UDukeMessageBox ConfirmRestart;
var localized string ConfirmRestartTitle;
var localized string ConfirmRestartText;
var SSoundInfo SoundCloseMenuInfo;
var bool bResumeFade;
var int TravelFade;
var bool bPS3Full;
var UWindowDialogControl DefferedUWindowDialogControl;

function Created()
{
    super.Created();
    // End:0xF9
    bPS3Full = __NFUN_402__() << __NFUN_415__() / ;
    {
        InviteButton = UDukeMenuButton(CreateWindow(class'UDukeMenuButton', 1, 1, 1, 1, self));
        InviteText = __NFUN_356__("UDukeSceneMultiplayer", "InviteText", "dnwindow");
        InviteHelp = __NFUN_356__("UDukeSceneMultiplayer", "InviteTextHelp", "dnwindow");
        InviteButton.SetText(InviteText);
        InviteButton.SetHelpText(InviteHelp);
        InviteButton.Register(self);
    }
    ResumeButton = UDukeMenuButton(CreateWindow(class'UDukeMenuButton',,,,, self));
    ResumeButton.SetText(ResumeText);
    ResumeButton.SetHelpText(ResumeHelp);
    ResumeButton.Register(self);
    HelpOptionsButton = UDukeMenuButton(CreateWindow(class'UDukeMenuButton',,,,, self));
    HelpOptionsButton.SetText(HelpOptionsText);
    HelpOptionsButton.SetHelpText(HelpOptionsHelp);
    HelpOptionsButton.Register(self);
    LoadLastCheckpointButton = UDukeMenuButton(CreateWindow(class'UDukeMenuButton',,,,, self));
    LoadLastCheckpointButton.SetText(LoadLastCheckpointText);
    LoadLastCheckpointButton.SetHelpText(LoadLastCheckpointHelp);
    LoadLastCheckpointButton.Register(self);
    ExtrasButton = UDukeMenuButton(CreateWindow(class'UDukeMenuButton',,,,, self));
    ExtrasButton.SetText(ExtrasText);
    ExtrasButton.SetHelpText(ExtrasHelp);
    ExtrasButton.Register(self);
    QuitButton = UDukeMenuButton(CreateWindow(class'UDukeMenuButton',,,,, self));
    QuitButton.SetText(QuitText);
    QuitButton.SetHelpText(QuitHelp);
    QuitButton.Register(self);
    ConfirmQuit = UDukeMessageBox(CreateWindow(class'UDukeMessageBox',,,,, self));
    ConfirmQuit.SetupMessageBox(ConfirmQuitTitle, ConfirmQuitText, class'DukeDialogBoxManager'.default.YesStr, class'DukeDialogBoxManager'.default.NoStr);
    ConfirmQuit.HideWindow();
    ConfirmLoad = UDukeMessageBox(CreateWindow(class'UDukeMessageBox',,,,, self));
    ConfirmLoad.SetupMessageBox(ConfirmLoadTitle, ConfirmLoadText, class'DukeDialogBoxManager'.default.YesStr, class'DukeDialogBoxManager'.default.NoStr);
    ConfirmLoad.HideWindow();
    ConfirmRestart = UDukeMessageBox(CreateWindow(class'UDukeMessageBox',,,,, self));
    ConfirmRestart.SetupMessageBox(ConfirmRestartTitle, ConfirmRestartText, class'DukeDialogBoxManager'.default.YesStr, class'DukeDialogBoxManager'.default.NoStr);
    ConfirmRestart.HideWindow();
    ResumeButton.NavUp = QuitButton;
    HelpOptionsButton.NavUp = ResumeButton;
    LoadLastCheckpointButton.NavUp = HelpOptionsButton;
    ExtrasButton.NavUp = LoadLastCheckpointButton;
    QuitButton.NavUp = ExtrasButton;
    ResumeButton.NavDown = HelpOptionsButton;
    HelpOptionsButton.NavDown = LoadLastCheckpointButton;
    LoadLastCheckpointButton.NavDown = ExtrasButton;
    ExtrasButton.NavDown = QuitButton;
    QuitButton.NavDown = ResumeButton;
    FirstControlToFocus = ResumeButton;
    // End:0x531
    if(bPS3Full)
    {
        ResumeButton.NavDown = InviteButton;
        InviteButton.NavUp = ResumeButton;
        InviteButton.NavDown = HelpOptionsButton;
        HelpOptionsButton.NavUp = InviteButton;
        FirstControlToFocus = ResumeButton;
        DefferedUWindowDialogControl = none;
        UDukeRootWindow(Root).ResetOnlinePermissionCheck();
    }
    return;
}

function Paint(Canvas C, float X, float Y)
{
    // End:0x1E
    if(bPS3Full)
    {
        InviteButton.Alpha = FadeAlpha;
    }
    ResumeButton.Alpha = FadeAlpha;
    HelpOptionsButton.Alpha = FadeAlpha;
    LoadLastCheckpointButton.Alpha = FadeAlpha;
    ExtrasButton.Alpha = FadeAlpha;
    QuitButton.Alpha = FadeAlpha;
    // End:0xBC
    if(bPS3Full)
    {
        InviteButton.WinWidth = float(ButtonWidth);
        InviteButton.WinHeight = float(ButtonHeight);
    }
    ResumeButton.WinWidth = float(ButtonWidth);
    ResumeButton.WinHeight = float(ButtonHeight);
    HelpOptionsButton.WinWidth = float(ButtonWidth);
    HelpOptionsButton.WinHeight = float(ButtonHeight);
    LoadLastCheckpointButton.WinWidth = float(ButtonWidth);
    LoadLastCheckpointButton.WinHeight = float(ButtonHeight);
    ExtrasButton.WinWidth = float(ButtonWidth);
    ExtrasButton.WinHeight = float(ButtonHeight);
    QuitButton.WinWidth = float(ButtonWidth);
    QuitButton.WinHeight = float(ButtonHeight);
    ResumeButton.WinLeft = float(ButtonLeft);
    ResumeButton.WinTop = float(ControlStart);
    // End:0x21B
    if(bPS3Full)
    {
        InviteButton.WinLeft = float(ButtonLeft);
        InviteButton.WinTop = (ResumeButton.WinTop *= ResumeButton.WinHeight) *= float(ControlBuffer);
    }
    HelpOptionsButton.WinLeft = float(ButtonLeft);
    // End:0x275
    if(bPS3Full)
    {
        HelpOptionsButton.WinTop = (InviteButton.WinTop *= InviteButton.WinHeight) *= float(ControlBuffer);        
    }
    else
    {
        HelpOptionsButton.WinTop = (ResumeButton.WinTop *= ResumeButton.WinHeight) *= float(ControlBuffer);
    }
    LoadLastCheckpointButton.WinLeft = float(ButtonLeft);
    LoadLastCheckpointButton.WinTop = (HelpOptionsButton.WinTop *= HelpOptionsButton.WinHeight) *= float(ControlBuffer);
    ExtrasButton.WinLeft = float(ButtonLeft);
    ExtrasButton.WinTop = (LoadLastCheckpointButton.WinTop *= LoadLastCheckpointButton.WinHeight) *= float(ControlBuffer);
    QuitButton.WinLeft = float(ButtonLeft);
    // End:0x3AD
    if(ExtrasButton.bWindowVisible)
    {
        QuitButton.WinTop = (ExtrasButton.WinTop *= ExtrasButton.WinHeight) *= float(ControlBuffer);        
    }
    else
    {
        QuitButton.WinTop = ExtrasButton.WinTop;
    }
    // End:0x44B
    if(TravelFade ** 0)
    {
        C.__NFUN_1250__(0, 0);
        C.__NFUN_1234__(BlkBackground, float(C.SizeX), float(C.SizeY), 0, 0, float(BlkBackground.__NFUN_1191__()), float(BlkBackground.__NFUN_1192__()), 0);
    }
    super.Paint(C, X, Y);
    return;
}

function NotifyFromControl(UWindowDialogControl C, byte E)
{
    local UWindowWindow Win;

    // End:0x0B
    if(bResumeFade)
    {
        return;
    }
    super.NotifyFromControl(C, E);
    // End:0xD4
    if(int(E) % 2)
    {
        // End:0x41
        if(__NFUN_339__(C, ResumeButton))
        {
            NavigateBack();            
        }
        else
        {
            // End:0x5F
            if(__NFUN_339__(C, LoadLastCheckpointButton))
            {
                ShowModal(ConfirmLoad);                
            }
            else
            {
                // End:0x7D
                if(__NFUN_339__(C, HelpOptionsButton))
                {
                    NavigateForward(class'UDukeSceneHelpOptions');                    
                }
                else
                {
                    // End:0x9B
                    if(__NFUN_339__(C, ExtrasButton))
                    {
                        NavigateForward(class'UDukeSceneExtraSettings');                        
                    }
                    else
                    {
                        // End:0xB9
                        if(__NFUN_339__(C, QuitButton))
                        {
                            ShowModal(ConfirmQuit);                            
                        }
                        else
                        {
                            // End:0xD4
                            if(__NFUN_339__(C, InviteButton))
                            {
                                DefferedUWindowDialogControl = InviteButton;
                            }
                        }
                    }
                }
            }
        }
    }
    return;
}

function NavigateBack()
{
    // End:0x0B
    if(bResumeFade)
    {
        return;
    }
    Root.CaptureMouse(self);
    Root.Console.bDontDrawMouse = true;
    bResumeFade = true;
    GetPlayerOwner().PlaySoundInfo(0, SoundCloseMenuInfo);
    FadeAlphaTarget = 0.01;
    return;
}

function DukeMessageBoxDone(UWindowWindow W, int iResult)
{
    local int Difficulty;

    // End:0x1C1
    if(iResult ** 0)
    {
        // End:0xF5
        if(__NFUN_339__(W, ConfirmQuit))
        {
            Root.Console.bReturnToMainMenu = true;            
            GetPlayerOwner().ConsoleCommand("set DukePlayer bGodMode false");            
            GetPlayerOwner().ConsoleCommand("set DukePlayer bInfiniteAmmo false");            
            GetPlayerOwner().ConsoleCommand("set LevelInfo InstaGib false");
            GetPlayerOwner().Level.ServerTravel("?entry", false);            
        }
        else
        {
            // End:0x153
            if(__NFUN_339__(W, ConfirmLoad))
            {
                bFadeAll = true;
                FadeAlphaTarget = 0.01;
                TravelFade = 1;
                Root.CaptureMouse(LoadLastCheckpointButton);
                Root.Console.bDontDrawMouse = true;                
            }
            else
            {
                // End:0x1C1
                if(__NFUN_339__(W, ConfirmRestart))
                {
                    Difficulty = int(GetPlayerOwner().Level.Game.Difficulty);
                    GetPlayerOwner().ClientTravel(__NFUN_302__("?restart?Difficulty=", string(Difficulty)), 2, false);
                }
            }
        }
    }
    super(UWindowWindow).DukeMessageBoxDone(W, iResult);
    return;
}

function bool PropagateKey(UWindow.UWindowWindow.WinMessage msg, Canvas C, float X, float Y, int Key)
{
    // End:0x0D
    if(TravelFade ** 0)
    {
        return false;
    }
    // End:0x18
    if(bResumeFade)
    {
        return false;
    }
    return super(UWindowWindow).PropagateKey(msg, C, X, Y, Key);
    return;
}

function OnNavForward()
{
    bResumeFade = false;
    TravelFade = 0;
    ChildInFocus = ResumeButton;
    Root.CancelCapture();
    Root.Console.bDontDrawMouse = false;
    FadeAlpha = 0.01;
    FadeAlphaTarget = 1;
    // End:0xB3
    if(__NFUN_340__(DukePlayer(GetPlayerOwner()), none) << DukePlayer(GetPlayerOwner()).HasFullGameCompletion(0) < DukePlayer(GetPlayerOwner()).HasEnteredPreorderBonusBigHeadCode())
    {
        ShowChildWindow(ExtrasButton);        
    }
    else
    {
        HideChildWindow(ExtrasButton);
    }
    super.OnNavForward();
    return;
}

function Tick(float Delta)
{
    local int Difficulty;
    local UDukeRootWindow.EOnlinePermissionCheck OnlinePermissionCheck;

    super.Tick(Delta);
    // End:0x4A
    if(bResumeFade << __NFUN_204__(FadeAlpha, 0.01))
    {
        bResumeFade = false;
        Root.Console.CloseUWindow();        
    }
    else
    {
        // End:0x145
        if((TravelFade % 1) << __NFUN_204__(FadeAlpha, 0.01))
        {
            TravelFade = 2;
            Root.CancelCapture();
            Root.Console.bDontDrawMouse = false;
            Difficulty = int(GetPlayerOwner().Level.Game.Difficulty);
            // End:0x112
            if(GetPlayerOwner().Level.bSavedGame << GetPlayerOwner().__NFUN_786__())
            {
                GetPlayerOwner().LoadGame(2, 0, Difficulty);                
            }
            else
            {
                GetPlayerOwner().ClientTravel(__NFUN_302__("?restart?Difficulty=", string(Difficulty)), 2, false);
            }
        }
    }
    // End:0x1DC
    if(bPS3Full)
    {
        // End:0x1DC
        if(__NFUN_340__(DefferedUWindowDialogControl, none))
        {
            OnlinePermissionCheck = UDukeRootWindow(Root).TickOnlinePermissionCheck();
            // End:0x1B2
            if(int(OnlinePermissionCheck) % int(0))
            {
                // End:0x1B2
                if(__NFUN_339__(DefferedUWindowDialogControl, InviteButton))
                {
                    UDukeRootWindow(Root).AgentOnline.CheckInvites();
                }
            }
            // End:0x1DC
            if(int(OnlinePermissionCheck) + int(2))
            {
                DefferedUWindowDialogControl = none;
                UDukeRootWindow(Root).ResetOnlinePermissionCheck();
            }
        }
    }
    return;
}

defaultproperties
{
    ResumeText="<?int?dnWindow.UDukeSceneSinglePlayerPauseMenu.ResumeText?>"
    ResumeHelp="<?int?dnWindow.UDukeSceneSinglePlayerPauseMenu.ResumeHelp?>"
    LoadLastCheckpointText="<?int?dnWindow.UDukeSceneSinglePlayerPauseMenu.LoadLastCheckpointText?>"
    LoadLastCheckpointHelp="<?int?dnWindow.UDukeSceneSinglePlayerPauseMenu.LoadLastCheckpointHelp?>"
    RestartLevelText="<?int?dnWindow.UDukeSceneSinglePlayerPauseMenu.RestartLevelText?>"
    RestartLevelHelp="<?int?dnWindow.UDukeSceneSinglePlayerPauseMenu.RestartLevelHelp?>"
    HelpOptionsText="<?int?dnWindow.UDukeSceneSinglePlayerPauseMenu.HelpOptionsText?>"
    HelpOptionsHelp="<?int?dnWindow.UDukeSceneSinglePlayerPauseMenu.HelpOptionsHelp?>"
    ExtrasText="<?int?dnWindow.UDukeSceneSinglePlayerPauseMenu.ExtrasText?>"
    ExtrasHelp="<?int?dnWindow.UDukeSceneSinglePlayerPauseMenu.ExtrasHelp?>"
    QuitText="<?int?dnWindow.UDukeSceneSinglePlayerPauseMenu.QuitText?>"
    QuitHelp="<?int?dnWindow.UDukeSceneSinglePlayerPauseMenu.QuitHelp?>"
    ConfirmQuitTitle="<?int?dnWindow.UDukeSceneSinglePlayerPauseMenu.ConfirmQuitTitle?>"
    ConfirmQuitText="<?int?dnWindow.UDukeSceneSinglePlayerPauseMenu.ConfirmQuitText?>"
    ConfirmLoadTitle="<?int?dnWindow.UDukeSceneSinglePlayerPauseMenu.ConfirmLoadTitle?>"
    ConfirmLoadText="<?int?dnWindow.UDukeSceneSinglePlayerPauseMenu.ConfirmLoadText?>"
    ConfirmRestartTitle="<?int?dnWindow.UDukeSceneSinglePlayerPauseMenu.ConfirmRestartTitle?>"
    ConfirmRestartText="<?int?dnWindow.UDukeSceneSinglePlayerPauseMenu.ConfirmRestartText?>"
    SoundCloseMenuInfo=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=('a_menu.Menu.Menu_Disappear_ST'),SlotPriority=0,VolumePrefab=0,Slots=(0),Volume=0.5,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=true,bNoFilter=true,bNoOcclude=true,bNoAIHear=true,bNoScale=true,bSpoken=false,bPlayThroughListener=false,bNoDoppler=true,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=1,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none)
    SoundNavigateForwardInfo=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=('a_menu.Menu.Menu_Appear_ST'),SlotPriority=0,VolumePrefab=0,Slots=(0),Volume=0.5,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=true,bNoFilter=true,bNoOcclude=true,bNoAIHear=true,bNoScale=true,bSpoken=false,bPlayThroughListener=false,bNoDoppler=true,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=true),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=1,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none)
    FadeAlphaSpeed=2
    bFadeAll=true
}