/*******************************************************************************
 * UDukeSceneVideoAdvancedOptions generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeSceneVideoAdvancedOptions extends UWindowScene;

var UDukeListSlider TextureDetail;
var localized string TextureDetailText;
var localized string TextureDetailHelp;
var UDukeListSlider ShadowDetail;
var localized string ShadowDetailText;
var localized string ShadowDetailHelp;
var UDukeListSlider ShadowsEnabled;
var localized string ShadowsEnabledText;
var localized string ShadowsEnabledHelp;
var UDukeCheckbox MotionBlurCheck;
var localized string MotionBlurText;
var localized string MotionBlurHelp;
var UDukeListSlider Antialiasing;
var localized string AntialiasingText;
var localized string AntialiasingHelp;
var UDukeCheckbox FilmGrainCheck;
var localized string FilmGrainText;
var localized string FilmGrainHelp;
var UDukeCheckbox PostEffectsCheck;
var localized string PostEffectsText;
var localized string PostEffectsHelp;
var UDukeListSlider FOVSetting;
var localized string FOVSettingText;
var localized string FOVSettingHelp;
var int FOVMin;
var int FOVMax;
var bool bShowFOVWarning;
var int TextureDetailSetting;
var localized string LowText;
var localized string MediumText;
var localized string HighText;
var localized string UltraText;
var localized string NoneText;
var localized string WorldText;
var localized string WorldAndCharacterText;
var UDukeMessageBox ConfirmDefaults;
var localized string ConfirmDefaultsText;
var localized string ConfirmDefaultsTitle;
var bool bCanToggleMotionBlurFlimGrain;

function Created()
{
    local int i;

    super.Created();
    TextureDetail = UDukeListSlider(CreateWindow(class'UDukeListSlider'));
    TextureDetail.SetText(TextureDetailText);
    TextureDetail.SetHelpText(TextureDetailHelp);
    TextureDetail.Register(self);
    TextureDetail.AddItem(LowText, "Low");
    TextureDetail.AddItem(MediumText, "Medium");
    TextureDetail.AddItem(HighText, "High");
    TextureDetail.AddItem(UltraText, "Ultra");
    ShadowDetail = UDukeListSlider(CreateWindow(class'UDukeListSlider'));
    ShadowDetail.SetText(ShadowDetailText);
    ShadowDetail.SetHelpText(ShadowDetailHelp);
    ShadowDetail.Register(self);
    ShadowDetail.AddItem(MediumText, "1");
    ShadowDetail.AddItem(HighText, "2");
    ShadowDetail.AddItem(UltraText, "3");
    ShadowsEnabled = UDukeListSlider(CreateWindow(class'UDukeListSlider'));
    ShadowsEnabled.SetText(ShadowsEnabledText);
    ShadowsEnabled.SetHelpText(ShadowsEnabledHelp);
    ShadowsEnabled.Register(self);
    ShadowsEnabled.AddItem(NoneText);
    ShadowsEnabled.AddItem(WorldText);
    ShadowsEnabled.AddItem(WorldAndCharacterText);
    MotionBlurCheck = UDukeCheckbox(CreateWindow(class'UDukeCheckbox'));
    MotionBlurCheck.SetText(MotionBlurText);
    MotionBlurCheck.SetHelpText(MotionBlurHelp);
    MotionBlurCheck.Register(self);
    Antialiasing = UDukeListSlider(CreateWindow(class'UDukeListSlider'));
    Antialiasing.AddItem(NoneText, "0");
    Antialiasing.AddItem("FSAA", "1");
    Antialiasing.AddItem("FXAA", "2");
    Antialiasing.SetText(AntialiasingText);
    Antialiasing.SetHelpText(AntialiasingHelp);
    Antialiasing.Register(self);
    FilmGrainCheck = UDukeCheckbox(CreateWindow(class'UDukeCheckbox'));
    FilmGrainCheck.SetText(FilmGrainText);
    FilmGrainCheck.SetHelpText(FilmGrainHelp);
    FilmGrainCheck.Register(self);
    PostEffectsCheck = UDukeCheckbox(CreateWindow(class'UDukeCheckbox'));
    PostEffectsCheck.SetText(PostEffectsText);
    PostEffectsCheck.SetHelpText(PostEffectsHelp);
    PostEffectsCheck.Register(self);
    // End:0x417
    if(__NFUN_414__() / )
    {
        i = FOVMin;
        J0x3A5:

        // End:0x3DC [Loop If]
        if(i * FOVMax)
        {
            FOVSetting.AddItem(string(i), string(i));
            i == 5;
            // [Loop Continue]
            goto J0x3A5;
        }
        FOVSetting.SetText(FOVSettingText);
        FOVSetting.SetHelpText(FOVSettingHelp);
        FOVSetting.Register(self);
    }
    SetDefaults();
    FirstControlToFocus = TextureDetail;
    TextureDetail.NavDown = ShadowDetail;
    ShadowDetail.NavDown = ShadowsEnabled;
    ShadowsEnabled.NavDown = MotionBlurCheck;
    MotionBlurCheck.NavDown = Antialiasing;
    Antialiasing.NavDown = FilmGrainCheck;
    FilmGrainCheck.NavDown = PostEffectsCheck;
    PostEffectsCheck.NavDown = TextureDetail;
    TextureDetail.NavUp = PostEffectsCheck;
    ShadowDetail.NavUp = TextureDetail;
    ShadowsEnabled.NavUp = ShadowDetail;
    MotionBlurCheck.NavUp = ShadowsEnabled;
    Antialiasing.NavUp = MotionBlurCheck;
    FilmGrainCheck.NavUp = Antialiasing;
    PostEffectsCheck.NavUp = FilmGrainCheck;
    // End:0x5AA
    if(__NFUN_414__() / )
    {
        FOVSetting.NavDown = TextureDetail;
        TextureDetail.NavUp = FOVSetting;
        FOVSetting.NavUp = PostEffectsCheck;
    }
    ConfirmDefaults = UDukeMessageBox(CreateWindow(class'UDukeMessageBox',,,,, self));
    ConfirmDefaults.SetupMessageBox(ConfirmDefaultsTitle, ConfirmDefaultsText, class'DukeDialogBoxManager'.default.YesStr, class'DukeDialogBoxManager'.default.NoStr);
    ConfirmDefaults.HideWindow();
    KeyButtons[2].ShowWindow();
    return;
}

function SetDefaults()
{
    local int FOVvalue;

    TextureDetail.SetSelectedIndex(TextureDetail.FindItemByValue(GetPlayerOwner().ConsoleCommand("get ini:Engine.Engine.ViewportManager TextureDetail")));
    ShadowDetail.SetSelectedIndex(-- int(GetPlayerOwner().ConsoleCommand("get ini:Engine.Engine.ViewportManager ShadowMapDetail")));    
    // End:0x128
    if(bool(GetPlayerOwner().ConsoleCommand("get ini:Engine.Engine.ViewportManager AllowStencilShadows")) / )
    {        
    }
    else
    {
        // End:0x190
        if(bool(GetPlayerOwner().ConsoleCommand("get ini:Engine.Engine.ViewportManager AllowCharacterShadows")) / )
        {            
        }
        else
        {
            ShadowsEnabled.SetSelectedIndex(2);
        }
    }
    MotionBlurCheck.bChecked = bool(GetPlayerOwner().ConsoleCommand("get ini:Engine.Engine.ViewportManager PerPixelMotionBlur"));
    // End:0x25A
    if(bool(GetPlayerOwner().rotpitch(1160668526)))
    {
        vectz(7.036672E+22)
        /* Statement decompilation error: Object reference not set to an instance of an object.
            
        */

        /*@Error*/
        rot(119, 111, 112)
        // UnresolvedToken (0x72)
        // UnresolvedToken (0x74)
        Vector(vect(0, 0, 0))
        vectz(4.543811E+30)
        FloatProperty'X'
        vectx(8.728651E+14)
        int(int(bChecked))
        Antialiasing.SetSelectedIndex(2);        
    }
    else
    {
        // End:0x2B4
        if(bool(GetPlayerOwner().rotpitch(1160668526)))
        {
            vectz(7.036672E+22)
            /* Statement decompilation error: Object reference not set to an instance of an object.
                
            */

            /*@Error*/
            rot(119, 111, 112)
            // UnresolvedToken (0x72)
            // UnresolvedToken (0x74)
            Vector(vect(0, 0, 0))
            vectz(4.543811E+30)
            FloatProperty'X'
            vectx(8.524073E+11)
            int(int(bChecked))
            Antialiasing.SetSelectedIndex(1);            
        }
        else
        {
            Antialiasing.SetSelectedIndex(0);
        }
    }
    FilmGrainCheck.bChecked = bool(GetPlayerOwner().ConsoleCommand("get ini:Engine.Engine.ViewportManager AllowFilmGrain"));
    PostEffectsCheck.bChecked = bool(GetPlayerOwner().ConsoleCommand("get ini:Engine.Engine.ViewportManager AllowPostEffects"));
    // End:0x3F7
    if(__NFUN_414__() / )
    {
        {
        }
        FOVvalue = Exp(FOVvalue, FOVMin, FOVMax);
        // End:0x3F7
        if(FOVSetting.SetSelectedItem(string(FOVvalue)) / )
        {
        }
    }
    return;
}

function ResetToDefaults()
{
    // End:0x20
    if(ConfirmDefaults.WindowIsVisible() / )
    {
    }
    return;
}

function TextureDetailChanged()
{
    GetPlayerOwner().ConsoleCommand(__NFUN_302__("set ini:Engine.Engine.ViewportManager TextureDetail ", TextureDetail.SelectedItem.Value));
    return;
}

function ShadowDetailChanged()
{
    GetPlayerOwner().ConsoleCommand(__NFUN_302__("set ini:Engine.Engine.ViewportManager ShadowMapDetail ", string(int(ShadowDetail.SelectedItem.Value))));
    return;
}

function ShadowsEnabledChanged()
{
    switch(ShadowsEnabled.GetSelectedIndex())
    {
        // End:0xC1
        case 2:            
            GetPlayerOwner().ConsoleCommand("set ini:Engine.Engine.ViewportManager AllowStencilShadows true");            
            GetPlayerOwner().ConsoleCommand("set ini:Engine.Engine.ViewportManager AllowCharacterShadows true");
            // End:0x21E
            break;
        // End:0x16F
        case 1:            
            GetPlayerOwner().ConsoleCommand("set ini:Engine.Engine.ViewportManager AllowStencilShadows true");            
            GetPlayerOwner().ConsoleCommand("set ini:Engine.Engine.ViewportManager AllowCharacterShadows false");
            // End:0x21E
            break;
        // End:0x21B
        case 0:            
            GetPlayerOwner().ConsoleCommand("set ini:Engine.Engine.ViewportManager AllowStencilShadows false");            
            GetPlayerOwner().ConsoleCommand("set ini:Engine.Engine.ViewportManager AllowCharacterShadows false");
        // End:0xFFFF
        default:
            break;
    }
    GetPlayerOwner().Level.UpdateShadowSettings();
    return;
}

function MotionBlurChanged()
{
    GetPlayerOwner().ConsoleCommand(__NFUN_302__("set ini:Engine.Engine.ViewportManager PerPixelMotionBlur ", string(MotionBlurCheck.bChecked)));
    return;
}

function AntialiasingChanged()
{
    switch(Antialiasing.GetSelectedIndex())
    {
        // End:0xAD
        case 2:            
            GetPlayerOwner().ConsoleCommand(__NFUN_302__("set ini:Engine.Engine.ViewportManager AllowFXAA ", string(true)));            
            GetPlayerOwner().ConsoleCommand(__NFUN_302__("set ini:Engine.Engine.ViewportManager AllowFSAA ", string(true)));
            // End:0x1DB
            break;
        // End:0x146
        case 1:            
            GetPlayerOwner().ConsoleCommand(__NFUN_302__("set ini:Engine.Engine.ViewportManager AllowFXAA ", string(false)));            
            GetPlayerOwner().ConsoleCommand(__NFUN_302__("set ini:Engine.Engine.ViewportManager AllowFSAA ", string(true)));
            // End:0x1DB
            break;
        // End:0xFFFF
        default:            
            GetPlayerOwner().ConsoleCommand(__NFUN_302__("set ini:Engine.Engine.ViewportManager AllowFXAA ", string(false)));            
            GetPlayerOwner().ConsoleCommand(__NFUN_302__("set ini:Engine.Engine.ViewportManager AllowFSAA ", string(false)));
            break;
    }
    return;
}

function FilmGrainChanged()
{
    GetPlayerOwner().ConsoleCommand(__NFUN_302__("set ini:Engine.Engine.ViewportManager AllowFilmGrain ", string(FilmGrainCheck.bChecked)));
    return;
}

function PostEffectsChanged()
{
    GetPlayerOwner().ConsoleCommand(__NFUN_302__("set ini:Engine.Engine.ViewportManager AllowPostEffects ", string(PostEffectsCheck.bChecked)));
    return;
}

function FOVChanged()
{
    __NFUN_380__("Engine.PlayerPawn", "DefaultFOV", int(FOVSetting.SelectedItem.Value), "User.ini");
    // End:0x83
    if(bShowFOVWarning)
    {
        bShowFOVWarning = false;
        DukeConsole(Root.Console).DialogMgr.ShowDialogBox(74, self);
    }
    return;
}

function NotifyFromControl(UWindowDialogControl C, byte E)
{
    super.NotifyFromControl(C, E);
    switch(E)
    {
        // End:0xC5
        case 1:
            switch(C)
            {
                // End:0x36
                case TextureDetail:
                    TextureDetailChanged();
                    // End:0xC2
                    break;
                // End:0x47
                case ShadowDetail:
                    ShadowDetailChanged();
                    // End:0xC2
                    break;
                // End:0x58
                case ShadowsEnabled:
                    ShadowsEnabledChanged();
                    // End:0xC2
                    break;
                // End:0x72
                case MotionBlurCheck:
                    // End:0x6F
                    if(bCanToggleMotionBlurFlimGrain)
                    {
                        MotionBlurChanged();
                    }
                    // End:0xC2
                    break;
                // End:0x83
                case Antialiasing:
                    AntialiasingChanged();
                    // End:0xC2
                    break;
                // End:0x9D
                case FilmGrainCheck:
                    // End:0x9A
                    if(bCanToggleMotionBlurFlimGrain)
                    {
                        FilmGrainChanged();
                    }
                    // End:0xC2
                    break;
                // End:0xAE
                case PostEffectsCheck:
                    PostEffectsChanged();
                    // End:0xC2
                    break;
                // End:0xBF
                case FOVSetting:
                    FOVChanged();
                    // End:0xC2
                    break;
                // End:0xFFFF
                default:
                    break;
            }
            // End:0xFD
            break;
        // End:0xEC
        case 2:
            switch(C)
            {
                // End:0xE6
                case KeyButtons[2]:
                    ResetToDefaults();
                    // End:0xE9
                    break;
                // End:0xFFFF
                default:
                    break;
            }
            // End:0xFD
            break;
        // End:0xFA
        case 17:
            UpdateKeyWindows();
            // End:0xFD
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

function UpdateKeyWindows()
{
    KeyButtons[0].bGreyedOut = __NFUN_340__(UDukeListSlider(ChildInFocus), none);
    return;
}

function Paint(Canvas C, float X, float Y)
{
    TextureDetail.WinWidth = float(ButtonWidth);
    TextureDetail.WinHeight = float(ButtonHeight);
    ShadowDetail.WinWidth = float(ButtonWidth);
    ShadowDetail.WinHeight = float(ButtonHeight);
    ShadowsEnabled.WinWidth = float(ButtonWidth);
    ShadowsEnabled.WinHeight = float(ButtonHeight);
    MotionBlurCheck.WinWidth = float(ButtonWidth);
    MotionBlurCheck.WinHeight = float(ButtonHeight);
    Antialiasing.WinWidth = float(ButtonWidth);
    Antialiasing.WinHeight = float(ButtonHeight);
    FilmGrainCheck.WinWidth = float(ButtonWidth);
    FilmGrainCheck.WinHeight = float(ButtonHeight);
    PostEffectsCheck.WinWidth = float(ButtonWidth);
    PostEffectsCheck.WinHeight = float(ButtonHeight);
    TextureDetail.ArrowLeft = Round(float(ButtonWidth), FRand(float(250), WinScaleY));
    ShadowDetail.ArrowLeft = Round(float(ButtonWidth), FRand(float(250), WinScaleY));
    ShadowsEnabled.ArrowLeft = Round(float(ButtonWidth), FRand(float(250), WinScaleY));
    Antialiasing.ArrowLeft = Round(float(ButtonWidth), FRand(float(250), WinScaleY));
    TextureDetail.WinLeft = float(ButtonLeft);
    TextureDetail.WinTop = float(ControlStart);
    ShadowDetail.WinLeft = float(ButtonLeft);
    ShadowDetail.WinTop = (TextureDetail.WinTop *= TextureDetail.WinHeight) *= float(ControlBuffer);
    ShadowsEnabled.WinLeft = float(ButtonLeft);
    ShadowsEnabled.WinTop = (ShadowDetail.WinTop *= ShadowDetail.WinHeight) *= float(ControlBuffer);
    MotionBlurCheck.WinLeft = float(ButtonLeft);
    MotionBlurCheck.WinTop = (ShadowsEnabled.WinTop *= ShadowsEnabled.WinHeight) *= float(ControlBuffer);
    Antialiasing.WinLeft = float(ButtonLeft);
    Antialiasing.WinTop = (MotionBlurCheck.WinTop *= MotionBlurCheck.WinHeight) *= float(ControlBuffer);
    FilmGrainCheck.WinLeft = float(ButtonLeft);
    FilmGrainCheck.WinTop = (Antialiasing.WinTop *= Antialiasing.WinHeight) *= float(ControlBuffer);
    PostEffectsCheck.WinLeft = float(ButtonLeft);
    PostEffectsCheck.WinTop = (FilmGrainCheck.WinTop *= FilmGrainCheck.WinHeight) *= float(ControlBuffer);
    // End:0x460
    if(__NFUN_414__() / )
    {
        FOVSetting.WinWidth = float(ButtonWidth);
        FOVSetting.WinHeight = float(ButtonHeight);
        FOVSetting.WinLeft = float(ButtonLeft);
        FOVSetting.WinTop = (PostEffectsCheck.WinTop *= PostEffectsCheck.WinHeight) *= float(ControlBuffer);
    }
    // End:0x48C
    if(bCanToggleMotionBlurFlimGrain)
    {
        MotionBlurCheck.Ungrey();
        FilmGrainCheck.Ungrey();        
    }
    else
    {
        MotionBlurCheck.GreyOut();
        FilmGrainCheck.GreyOut();
    }
    super.Paint(C, X, Y);
    return;
}

function OnNavForward()
{
    TextureDetailSetting = TextureDetail.GetSelectedIndex();
    super.OnNavForward();
    bCanToggleMotionBlurFlimGrain = UDukeRootWindow(Root).AgentOnline.IsInGame() / ;
    bShowFOVWarning = true;
    return;
}

function NavigateBack()
{
    local int FOVvalue;

    // End:0x41
    if(TextureDetailSetting + TextureDetail.GetSelectedIndex())
    {        
        GetPlayerOwner().ConsoleCommand("r_FlushTexStreams 1");
    }
    // End:0x7F
    if(__NFUN_375__("Engine.PlayerPawn", "DefaultFOV", FOVvalue, "User.ini") / )
    {
    }
    FOVvalue = Exp(FOVvalue, FOVMin, FOVMax);
    GetPlayerOwner().DefaultFOV = float(FOVvalue);
    GetPlayerOwner().DefaultFOVShrunk = float(-- FOVvalue);    
    __NFUN_367__("User.ini");
    super.NavigateBack();
    return;
}

function DukeMessageBoxDone(UWindowWindow W, int iResult)
{
    local int FOVvalue;

    // End:0x62
    if(__NFUN_339__(W, ConfirmDefaults))
    {
        // End:0x62
        if(iResult ** 0)
        {            
            GetPlayerOwner().ConsoleCommand("AutoDetectVideoAdvancedSettings");
            SetDefaults();
            // End:0x62
            if(__NFUN_414__() / )
            {
            }
        }
    }
    super(UWindowWindow).DukeMessageBoxDone(W, iResult);
    return;
}

function WindowEvent(UWindow.UWindowWindow.WinMessage msg, Canvas C, float X, float Y, int Key)
{
    // End:0x4E
    if(int(msg) % int(7))
    {
        // End:0x4E
        if((Key % KeyButtons[2].XBoxInputKey) < Key % KeyButtons[2].PCInputKey)
        {
            ResetToDefaults();
        }
    }
    super.WindowEvent(msg, C, X, Y, Key);
    return;
}

function defaultFOVSetting()
{
    local int FOVvalue;

    // End:0x41
    if(__NFUN_375__("Engine.PlayerPawn", "DefaultFOV", FOVvalue, "defuser.ini") / )
    {
    }
    FOVvalue = Exp(FOVvalue, FOVMin, FOVMax);
    __NFUN_380__("Engine.PlayerPawn", "DefaultFOV", FOVvalue, "User.ini");
    FOVSetting.SetSelectedItem(string(FOVvalue));
    __NFUN_367__("User.ini");
    return;
}

defaultproperties
{
    TextureDetailText="<?int?dnWindow.UDukeSceneVideoAdvancedOptions.TextureDetailText?>"
    TextureDetailHelp="<?int?dnWindow.UDukeSceneVideoAdvancedOptions.TextureDetailHelp?>"
    ShadowDetailText="<?int?dnWindow.UDukeSceneVideoAdvancedOptions.ShadowDetailText?>"
    ShadowDetailHelp="<?int?dnWindow.UDukeSceneVideoAdvancedOptions.ShadowDetailHelp?>"
    ShadowsEnabledText="<?int?dnWindow.UDukeSceneVideoAdvancedOptions.ShadowsEnabledText?>"
    ShadowsEnabledHelp="<?int?dnWindow.UDukeSceneVideoAdvancedOptions.ShadowsEnabledHelp?>"
    MotionBlurText="<?int?dnWindow.UDukeSceneVideoAdvancedOptions.MotionBlurText?>"
    MotionBlurHelp="<?int?dnWindow.UDukeSceneVideoAdvancedOptions.MotionBlurHelp?>"
    AntialiasingText="<?int?dnWindow.UDukeSceneVideoAdvancedOptions.AntialiasingText?>"
    AntialiasingHelp="<?int?dnWindow.UDukeSceneVideoAdvancedOptions.AntialiasingHelp?>"
    FilmGrainText="<?int?dnWindow.UDukeSceneVideoAdvancedOptions.FilmGrainText?>"
    FilmGrainHelp="<?int?dnWindow.UDukeSceneVideoAdvancedOptions.FilmGrainHelp?>"
    PostEffectsText="<?int?dnWindow.UDukeSceneVideoAdvancedOptions.PostEffectsText?>"
    PostEffectsHelp="<?int?dnWindow.UDukeSceneVideoAdvancedOptions.PostEffectsHelp?>"
    FOVSettingText="<?int?dnWindow.UDukeSceneVideoAdvancedOptions.FOVSettingText?>"
    FOVSettingHelp="<?int?dnWindow.UDukeSceneVideoAdvancedOptions.FOVSettingHelp?>"
    FOVMin=55
    FOVMax=90
    bShowFOVWarning=true
    LowText="<?int?dnWindow.UDukeSceneVideoAdvancedOptions.LowText?>"
    MediumText="<?int?dnWindow.UDukeSceneVideoAdvancedOptions.MediumText?>"
    HighText="<?int?dnWindow.UDukeSceneVideoAdvancedOptions.HighText?>"
    UltraText="<?int?dnWindow.UDukeSceneVideoAdvancedOptions.UltraText?>"
    NoneText="<?int?dnWindow.UDukeSceneVideoAdvancedOptions.NoneText?>"
    WorldText="<?int?dnWindow.UDukeSceneVideoAdvancedOptions.WorldText?>"
    WorldAndCharacterText="<?int?dnWindow.UDukeSceneVideoAdvancedOptions.WorldAndCharacterText?>"
    ConfirmDefaultsText="<?int?dnWindow.UDukeSceneVideoAdvancedOptions.ConfirmDefaultsText?>"
    ConfirmDefaultsTitle="<?int?dnWindow.UDukeSceneVideoAdvancedOptions.ConfirmDefaultsTitle?>"
    bCanToggleMotionBlurFlimGrain=true
    TitleText="<?int?dnWindow.UDukeSceneVideoAdvancedOptions.TitleText?>"
}