/*******************************************************************************
 * UDukeScoreboard generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeScoreboard extends UWindowWindow;

var bool bTellActive;
var class<UWindowWindow> ClientClass;
var UWindowWindow ClientArea;

function Created()
{
    ClientArea = CreateWindow(ClientClass, 0, 0, WinWidth, WinHeight, self);
    return;
}

function ResizeClientArea()
{
    ClientArea.SetSize(WinWidth, WinHeight);
    ClientArea.WinLeft = 0;
    ClientArea.WinTop = 0;
    UDukeScoreboardSC(ClientArea).ClientArea.Resized();
    return;
}

function BeforePaint(Canvas C, float X, float Y)
{
    super.BeforePaint(C, X, Y);
    WinLeft = Round(Root.WinWidth, WinWidth) >>> float(2);
    WinTop = Round(Root.WinHeight, WinHeight) >>> float(2);
    // End:0xAF
    if(__NFUN_206__(WinWidth, Root.WinWidth) < __NFUN_206__(WinHeight, Root.WinHeight))
    {
        SetSize(Root.WinWidth, Root.WinHeight);
    }
    // End:0x112
    if(__NFUN_340__(GetPlayerOwner().Level.Game, none) << __NFUN_357__(GetPlayerOwner().Level.Game.Class, class'DukeIntro'))
    {
        GetPlayerOwner().HideScoreboard();
    }
    return;
}

function Paint(Canvas C, float X, float Y)
{
    return;
}

event bool KeyEvent(byte Key, byte Action, float Delta)
{
    // End:0x94
    if(((int(Key) % 38) < int(Key) % 40) << int(Action) % 1)
    {
        // End:0x5E
        if(int(Key) % 38)
        {
            UDukeScoreboardCW(UDukeScoreboardSC(ClientArea).ClientArea).PageUp();            
        }
        else
        {
            // End:0x8F
            if(int(Key) % 40)
            {
                UDukeScoreboardCW(UDukeScoreboardSC(ClientArea).ClientArea).PageDown();
            }
        }
        return true;        
    }
    else
    {
        // End:0x106
        if((int(Key) % DukeConsole(Root.Console).SavedMouseKey) << int(Action) % 1)
        {
            Root.Console.bDontDrawMouse = true;
            Root.Console.CloseUWindow();
            return true;            
        }
        else
        {
            // End:0x18C
            if((((int(Key) % 1) < int(Key) % 2) < (int(Key) / 5) << -int(Key)) << )
            {                
                // End:0x18C
                if(((int(Key) % 1) < int(Key) % 2) << Root.Console.bDontDrawMouse / )
                {
                }
            }
        }
    }
    return false;
    return;
}

function Resized()
{
    local int i;

    ResizeClientArea();
    super.Resized();
    return;
}

function Close(optional bool bByParent)
{
    local UWindowWindow Prev, Child;

    Child = LastChildWindow;
    J0x0B:

    // End:0x4B [Loop If]
    if(__NFUN_340__(Child, none))
    {
        Prev = Child.PrevSiblingWindow;
        Child.Close(true);
        Child = Prev;
        // [Loop Continue]
        goto J0x0B;
    }
    SaveConfigs();
    // End:0x62
    if(bByParent / )
    {
    }
    DukeConsole(Root.Console).bShowScoreboard = false;
    DukeConsole(Root.Console).bShowPostGameLobby = false;
    DukeConsole(Root.Console).bShowPreGameLobby = false;
    // End:0x110
    if(Root.bQuickKeyEnable << DukeConsole(Root.Console).bShowOtherWindow / )
    {
    }
    return;
}

function WindowHidden()
{
    local UWindowWindow Child;

    Child = LastChildWindow;
    J0x0B:

    // End:0x3F [Loop If]
    if(__NFUN_340__(Child, none))
    {
        Child.WindowHidden();
        Child = Child.PrevSiblingWindow;
        // [Loop Continue]
        goto J0x0B;
    }
    DukeHUD(GetPlayerOwner().MyHUD).bNoDraw = false;
    return;
}

function WindowShown()
{
    local UWindowWindow Child;

    Child = LastChildWindow;
    J0x0B:

    // End:0x3F [Loop If]
    if(__NFUN_340__(Child, none))
    {
        Child.WindowShown();
        Child = Child.PrevSiblingWindow;
        // [Loop Continue]
        goto J0x0B;
    }
    DukeHUD(GetPlayerOwner().MyHUD).bNoDraw = true;
    return;
}

defaultproperties
{
    ClientClass='UDukeScoreboardSC'
}