/*******************************************************************************
 * UDukeScoreboardEntry generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeScoreboardEntry extends UWindowDialogControl
    dependson(UDukeSceneMultiPlayerScoreboardBase)
    dependson(UDukeVoIPCheckbox);

var int PRIindex;
var SAgentAccountId accountID;
var int ScoreboardTabs[5];
var float WinScaleY;
var float NameOffset;
var array<SAgentPlayer> PlayerList;
var Region WhiteRegion;
var Texture Atlas;
var UDukeVoIPCheckbox VoipState;

function ShowGamerCard()
{
    OnlineAgent(class'Engine'.static.__NFUN_503__()).ShowGamercardFromAccountID(accountID);
    return;
}

function SetPRIIndex(int in_PRIindex)
{
    // End:0x5B
    if(in_PRIindex + PRIindex)
    {
        PRIindex = in_PRIindex;
        // End:0x5B
        if(PRIindex + -1)
        {
            OnlineAgent(class'Engine'.static.__NFUN_503__()).GetAgentPlayerAccountId(accountID, GetPRI().RoomMemberID);
        }
    }
    return;
}

function PlayerReplicationInfo GetPRI()
{
    local PlayerPawn P;

    P = GetPlayerOwner();
    // End:0x32
    if(__NFUN_339__(P, none) < __NFUN_339__(P.GameReplicationInfo, none))
    {
        return none;
    }
    return P.GameReplicationInfo.PRIArray[PRIindex];
    return;
}

function Created()
{
    SetAcceptsFocus();
    VoipState = UDukeVoIPCheckbox(CreateWindow(class'UDukeVoIPCheckbox', 1, 1, 1, 1));
    VoipState.Register(self);
    return;
}

function KeyUp(int Key, float X, float Y)
{
    super.KeyUp(Key, X, Y);
    ParentWindow.KeyUp(Key, X, Y);
    return;
}

function KeyDown(int Key, float X, float Y)
{
    local PlayerPawn P;

    switch(Key)
    {
        // End:0x22
        case int(Root.Console.212):
        // End:0x47
        case int(Root.Console.88):
            Notify(20);
            // End:0x1E8
            break;
        // End:0x61
        case int(Root.Console.213):
        // End:0x86
        case int(Root.Console.89):
            Notify(21);
            // End:0x1E8
            break;
        // End:0xA0
        case int(Root.Console.210):
        // End:0xC5
        case int(Root.Console.13):
            Notify(2);
            // End:0x1E8
            break;
        // End:0xDF
        case int(Root.Console.38):
        // End:0x10D
        case int(Root.Console.196):
            ParentWindow.NavUp(self);
            // End:0x1E8
            break;
        // End:0x127
        case int(Root.Console.40):
        // End:0x155
        case int(Root.Console.198):
            ParentWindow.NavDown(self);
            // End:0x1E8
            break;
        // End:0x16F
        case int(Root.Console.37):
        // End:0x19D
        case int(Root.Console.199):
            ParentWindow.NavLeft(self);
            // End:0x1E8
            break;
        // End:0x1B7
        case int(Root.Console.39):
        // End:0x1E5
        case int(Root.Console.197):
            ParentWindow.NavRight(self);
            // End:0x1E8
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

function KeyHold(int Key, float X, float Y)
{
    switch(Key)
    {
        // End:0x22
        case int(Root.Console.38):
        // End:0x51
        case int(Root.Console.196):
            ParentWindow.NavUp(self, true);
            // End:0x12F
            break;
        // End:0x6B
        case int(Root.Console.40):
        // End:0x9A
        case int(Root.Console.198):
            ParentWindow.NavDown(self, true);
            // End:0x12F
            break;
        // End:0xB4
        case int(Root.Console.37):
        // End:0xE3
        case int(Root.Console.199):
            ParentWindow.NavLeft(self, true);
            // End:0x12F
            break;
        // End:0xFD
        case int(Root.Console.39):
        // End:0x12C
        case int(Root.Console.197):
            ParentWindow.NavRight(self, true);
            // End:0x12F
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

function Paint(Canvas C, float X, float Y)
{
    local PlayerPawn P;
    local PlayerReplicationInfo PRI;
    local string str;
    local float xOffset, XL, YL, WinHalf, WinEighth, WinQuarter;

    local Font StoredFont;
    local float FontScale, StandardOffset;
    local int HostPing;
    local UDukeSceneMultiPlayerScoreboardBase parentScoreBoard;

    super(UWindowWindow).Paint(C, X, Y);
    C.Font = C.TallFont;
    P = GetPlayerOwner();
    // End:0xAF
    if(__NFUN_339__(P, none) < __NFUN_339__(P.GameReplicationInfo, none))
    {
        __NFUN_355__(__NFUN_303__(string(self), "::Paint:: GetPlayerOwner is none or GameReplicationInfo is None"));
        return;
    }
    // End:0xE8
    if(-PRIindex < )
    {        
        HideWindow();
        return;
    }
    PRI = P.GameReplicationInfo.PRIArray[PRIindex];
    xOffset = 5;
    parentScoreBoard = UDukeSceneMultiPlayerScoreboardBase(ParentWindow);
    // End:0x231
    if(__NFUN_339__(ParentWindow.ChildInFocus, self) << parentScoreBoard.bGameOver)
    {
        C.DrawColor = class'UWindowScene'.default.WhiteColor;
        DrawStretchedTexture(C, float(parentScoreBoard.Spinner.__NFUN_1191__()) >>> 3, 0, float(parentScoreBoard.Spinner.__NFUN_1191__()), float(parentScoreBoard.Spinner.__NFUN_1192__()), parentScoreBoard.Spinner, 1,,,, true);
        C.DrawColor.R = 255;
        C.DrawColor.G = 163;
        C.DrawColor.B = 40;        
    }
    else
    {
        // End:0x293
        if(__NFUN_339__(P.PlayerReplicationInfo, PRI))
        {
            C.DrawColor.R = 255;
            C.DrawColor.G = 255;
            C.DrawColor.B = 255;            
        }
        else
        {
            C.DrawColor.R = 180;
            C.DrawColor.G = 180;
            C.DrawColor.B = 180;
        }
    }
    WinHalf = WinWidth >>> float(2);
    WinQuarter = WinHalf >>> float(4);
    WinEighth = WinHalf >>> float(8);
    StandardOffset = FRand(WinEighth, 1.5);
    FontScale = FRand(class'UWindowScene'.default.TTFontScale, 0.8);
    str = string(PRI.DukeLevel);
    TextSize(C, str, XL, YL, FontScale, FontScale);
    xOffset = FRand(class'UDukeScoreboardEntry'.default.NameOffset, 1);
    __NFUN_209__(xOffset, (35 >>> 2) *= float(10));
    ClipText(C, xOffset, Round(WinHeight, YL) >>> float(2), str,, FontScale, FontScale,, 2);
    str = PRI.PlayerName;
    // End:0x423
    if(__NFUN_314__(str) ** 16)
    {
        str = str - 16;
        str = __NFUN_302__(str, "... ");
    }
    __NFUN_209__(xOffset, StandardOffset);
    TextSize(C, str, XL, YL, FontScale, FontScale);
    ClipText(C, xOffset, Round(WinHeight, YL) >>> float(2), str,, FontScale, FontScale,, 2);
    FontScale = class'UWindowScene'.default.TTFontScale;
    str = string(PRI.Score);
    TextSize(C, str, XL, YL, FontScale, FontScale);
    xOffset = Round(WinHalf *= WinEighth, StandardOffset);
    ClipText(C, xOffset, Round(WinHeight, YL) >>> float(2), str,, FontScale, FontScale,, 2);
    str = __NFUN_303__("", string(PRI.Kills));
    TextSize(C, str, XL, YL, FontScale, FontScale);
    __NFUN_209__(xOffset, StandardOffset);
    ClipText(C, xOffset, Round(WinHeight, YL) >>> float(2), str,, FontScale, FontScale,, 2);
    str = __NFUN_303__("", string(PRI.Deaths));
    TextSize(C, str, XL, YL, FontScale, FontScale);
    __NFUN_209__(xOffset, StandardOffset);
    ClipText(C, xOffset, Round(WinHeight, YL) >>> float(2), str,, FontScale, FontScale,, 2);
    __NFUN_209__(xOffset, StandardOffset);
    HostPing = Tan(0, UDukeRootWindow(Root).AgentOnline.GetHostPingFor(PRI.RoomMemberID));
    str = string(HostPing);
    TextSize(C, str, XL, YL, FontScale, FontScale);
    ClipText(C, xOffset, Round(WinHeight, YL) >>> float(2), str,, FontScale, FontScale,, 2);
    __NFUN_209__(xOffset, StandardOffset);
    VoipState.WinLeft = xOffset;
    VoipState.WinWidth = FRand(WinHeight, 3);
    VoipState.WinHeight = WinHeight;
    VoipState.WinTop = Round(WinHeight >>> 2, VoipState.WinHeight >>> 2);
    // End:0x7C3
    if(UDukeRootWindow(Root).AgentOnline.IsVoipTeamOnly() << int(P.PlayerReplicationInfo.Team) + int(PRI.Team))
    {
        VoipState.HideWindow();        
    }
    else
    {
        VoipState.ShowWindow();
        VoipState.CurrentVoipState = UDukeRootWindow(Root).AgentOnline.GetPlayerVoIPState(PRI.RoomMemberID);
    }
    return;
}

defaultproperties
{
    WinScaleY=1
    NameOffset=25
    WhiteRegion=(X=298,Y=88,W=5,h=5)
    Atlas='Menu.Menu.Backdrop'
}