/*******************************************************************************
 * UDukeScoreboardMenu generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeScoreboardMenu extends UWindowRightClickMenu;

var UWindowPulldownMenuItem Tell;
var UWindowPulldownMenuItem Taunts[4];
var UWindowPulldownMenuItem Mute;
var UWindowPulldownMenuItem Kick;
var localized string TellName;
var localized string TauntNames[4];
var localized string MuteName;
var localized string KickName;
var UDukeScoreboardPlate Plate;

function Created()
{
    local int i;

    super.Created();
    Tell = AddMenuItem(TellName, none);
    Mute = AddMenuItem(MuteName, none);
    Taunts[0] = AddMenuItem(TauntNames[0], none);
    Taunts[1] = AddMenuItem(TauntNames[1], none);
    Taunts[2] = AddMenuItem(TauntNames[2], none);
    Taunts[3] = AddMenuItem(TauntNames[3], none);
    Kick = AddMenuItem(KickName, none);
    return;
}

function ShowWindow()
{
    local int i;

    super(UWindowPulldownMenu).ShowWindow();
    Selected = none;
    // End:0x26
    if(__NFUN_339__(GetPlayerOwner().PlayerReplicationInfo, none))
    {
        return;
    }
    return;
}

function RefreshTaunts()
{
    local int i;

    i = 0;
    J0x07:

    // End:0x155 [Loop If]
    if(-i)
    {        
        // End:0x4A
        if(__NFUN_339__(Taunts[i].SubMenu, none))
        {
            Taunts[i].CreateSubMenu(class'UDukeScoreboardTauntMenu');
        }
        UDukeScoreboardTauntMenu(Taunts[i].SubMenu).AddTaunts(i -= 8, ++ i -= 8);        
        Taunts[i].SubMenu.bLeaveOnscreen = true;
        Taunts[i].SubMenu.Font = 6;
        Taunts[i].SubMenu.bCloseOnExecute = true;
        Taunts[i].bDisabled = false;
        // End:0x14B
        if(Taunts[i].SubMenu.Items.Count() % 0)
        {
            Taunts[i].bDisabled = true;
        }
        // [Loop Continue]
        i += ;
    }
    return;
}

function ExecuteItem(UWindowPulldownMenuItem i)
{
    switch(i)
    {
        // End:0x23
        case Tell:
            Plate.DoTell();
            // End:0x3C
            break;
        // End:0x2E
        case Mute:
            // End:0x3C
            break;
        // End:0x39
        case Kick:
            // End:0x3C
            break;
        // End:0xFFFF
        default:
            break;
    }
    super(UWindowPulldownMenu).ExecuteItem(i);
    return;
}

function SetPlate(UDukeScoreboardPlate P)
{
    local int i;

    Plate = P;
    i = 0;
    J0x12:

    // End:0x52 [Loop If]
    if(-i)
    {        
        UDukeScoreboardTauntMenu(Taunts[i].SubMenu).Plate = P;
        // [Loop Continue]
        i += ;
    }
    return;
}

defaultproperties
{
    TellName="<?int?dnWindow.UDukeScoreboardMenu.TellName?>"
    TauntNames[0]="<?int?dnWindow.UDukeScoreboardMenu.TauntNames?>"
    TauntNames[1]="<?int?dnWindow.UDukeScoreboardMenu.TauntNames?>"
    TauntNames[2]="<?int?dnWindow.UDukeScoreboardMenu.TauntNames?>"
    TauntNames[3]="<?int?dnWindow.UDukeScoreboardMenu.TauntNames?>"
    MuteName="<?int?dnWindow.UDukeScoreboardMenu.MuteName?>"
    KickName="<?int?dnWindow.UDukeScoreboardMenu.KickName?>"
}