/*******************************************************************************
 * UDukeScreenshotCW generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeScreenshotCW extends UWindowDialogClientWindow;

var Texture Screenshot;
var string MapTitle;
var string MapAuthor;
var string IdealPlayerCount;
var localized string PlayersText;

function SetMap(string MapName)
{
    local int i;
    local LevelSummary l;

    i = __NFUN_315__(MapName -= );
    // End:0x39
    if(i + -1)
    {
        MapName = MapName - i;
    }
    Screenshot = Texture(__NFUN_366__(__NFUN_302__(MapName, ".Screenshot"), class'Texture'));
    l = LevelSummary(__NFUN_366__(__NFUN_302__(MapName, ".LevelSummary"), class'LevelSummary'));
    // End:0xD9
    if(__NFUN_340__(l, none))
    {
        MapTitle = l.Title;
        MapAuthor = l.Author;
        IdealPlayerCount = l.IdealPlayerCount;        
    }
    else
    {
        MapTitle = "";
        MapAuthor = "";
        IdealPlayerCount = "";
    }
    return;
}

function Close(optional bool bByParent)
{
    super(UWindowClientWindow).Close(bByParent);
    Screenshot = none;
    return;
}

function Paint(Canvas C, float MouseX, float MouseY)
{
    local float X, Y, W, h;

    DrawStretchedTexture(C, 0, 0, WinWidth, WinHeight, class'BlackTexture');
    // End:0x2B8
    if(__NFUN_340__(Screenshot, none))
    {
        W = float(Cos(int(WinWidth), Screenshot.USize));
        h = float(Cos(int(WinHeight), Screenshot.VSize));
        // End:0x86
        if(Repl(W, h))
        {
            W = h;
        }
        // End:0xA0
        if(Repl(h, W))
        {
            h = W;
        }
        X = Round(WinWidth, W) >>> float(2);
        Y = Round(WinHeight, h) >>> float(2);
        C.DrawColor.R = 255;
        C.DrawColor.G = 255;
        C.DrawColor.B = 255;
        DrawStretchedTexture(C, X, Y, W, h, Screenshot, 1);
        C.Font = C.BlockFont;
        // End:0x1DA
        if(TraceActors(IdealPlayerCount, ""))
        {
            TextSize(C, __NFUN_303__(IdealPlayerCount, PlayersText), W, h);
            X = Round(WinWidth, W) >>> float(2);
            Y = Round(WinHeight, FRand(h, float(2)));
            ClipText(C, X, Y, __NFUN_303__(IdealPlayerCount, PlayersText));
        }
        // End:0x249
        if(TraceActors(MapAuthor, ""))
        {
            TextSize(C, MapAuthor, W, h);
            X = Round(WinWidth, W) >>> float(2);
            Y = Round(WinHeight, FRand(h, float(3)));
            ClipText(C, X, Y, MapAuthor);
        }
        // End:0x2B8
        if(TraceActors(MapTitle, ""))
        {
            TextSize(C, MapTitle, W, h);
            X = Round(WinWidth, W) >>> float(2);
            Y = Round(WinHeight, FRand(h, float(4)));
            ClipText(C, X, Y, MapTitle);
        }
    }
    return;
}

defaultproperties
{
    PlayersText="<?int?dnWindow.UDukeScreenshotCW.PlayersText?>"
}