/*******************************************************************************
 * UDukeServerList generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeServerList extends UWindowList
    config
    dependson(UDukeServerBrowserCW)
    dependson(UDukeServerGrid)
    dependson(UDukeServerPing)
    dependson(UDukeRulesList)
    dependson(UDukePlayerList);

var UDukeServerBrowserCW Owner;
var int TotalServers;
var int TotalPlayers;
var int TotalMaxPlayers;
var bool bNeedUpdateCount;
var config int MaxSimultaneousPing;
var string IP;
var int QueryPort;
var string Category;
var string GameName;
var UDukeServerPing ServerPing;
var bool bPinging;
var bool bPingFailed;
var bool bPinged;
var bool bNoInitalPing;
var bool bOldServer;
var bool bHidden;
var UDukeRulesList RulesList;
var UDukePlayerList PlayerList;
var bool bKeepDescription;
var bool bLocalServer;
var float Ping;
var string HostName;
var int GamePort;
var string MapName;
var string MapTitle;
var string MapDisplayName;
var string GameType;
var string GameMode;
var int NumPlayers;
var int MaxPlayers;
var int NumBots;
var int GameVer;
var int MinNetVer;
var int ShownCount;

function DestroyListItem()
{
    Owner = none;
    // End:0x27
    if(__NFUN_340__(ServerPing, none))
    {
        ServerPing.__NFUN_614__();
        ServerPing = none;
    }
    super.DestroyListItem();
    return;
}

function QueryFinished(UDukeServerListFactory Fact, bool bSuccess, optional string ErrorMsg)
{
    Owner.QueryFinished(Fact, bSuccess, ErrorMsg);
    return;
}

function PingServer(bool bInitial, bool bJustThisServer, bool bNoSort)
{
    ServerPing = GetPlayerOwner().__NFUN_560__().__NFUN_615__(class'UDukeServerPing');
    ServerPing.Server = self;
    ServerPing.StartQuery('GetInfo', 2);
    ServerPing.bInitial = bInitial;
    ServerPing.bJustThisServer = bJustThisServer;
    ServerPing.bNoSort = bNoSort;
    bPinging = true;
    return;
}

function ServerStatus()
{
    ServerPing = GetPlayerOwner().__NFUN_560__().__NFUN_615__(class'UDukeServerPing');
    ServerPing.Server = self;
    ServerPing.StartQuery('GetStatus', 2);
    bPinging = true;
    return;
}

function StatusDone(bool bSuccess)
{
    ServerPing.__NFUN_614__();
    ServerPing = none;
    bPinging = false;
    RulesList.SortByColumn(RulesList.SortColumn);
    PlayerList.SortByColumn(PlayerList.SortColumn);
    return;
}

function CancelPing()
{
    // End:0x36
    if((bPinging << __NFUN_340__(ServerPing, none)) << ServerPing.bJustThisServer)
    {
        PingDone(false, true, false, true);
    }
    return;
}

function PingDone(bool bInitial, bool bJustThisServer, bool bSuccess, bool bNoSort)
{
    local UDukeServerBrowserCW W;
    local UDukeServerList OldSentinel;

    // End:0x20
    if(__NFUN_340__(ServerPing, none))
    {
        ServerPing.__NFUN_614__();
        ServerPing = none;
    }
    bPinging = false;
    bPingFailed = bSuccess / ;
    OldSentinel = UDukeServerList(Sentinel);
    // End:0x113
    if(bNoSort / )
    {
        // End:0x110
        if((bPingFailed / ) < )
        {
            {
                OldSentinel.Owner.PingedList.AppendItem(self);
                OldSentinel.Owner.UpdateFilters(self);
            }
        }        
    }
    else
    {
        // End:0x192
        if((__NFUN_340__(OldSentinel, none) << __NFUN_340__(OldSentinel.Owner, none)) << __NFUN_340__(OldSentinel, OldSentinel.Owner.PingedList))
        {
            __NFUN_355__("Unsorted PingDone lost as it's not in ping list!");
        }
    }
    // End:0x1B5
    if(__NFUN_340__(Sentinel, none))
    {
        UDukeServerList(Sentinel).bNeedUpdateCount = true;
    }
    // End:0x23C
    if(bJustThisServer / )
    {
        {
            W = OldSentinel.Owner;
            // End:0x220
            if(W.bPingSuspend)
            {
                W.bPingResume = true;
                W.bPingResumeIntial = bInitial;                
            }
            else
            {
                OldSentinel.PingNext(bInitial, bNoSort);
            }
        }
    }
    return;
}

function InvalidatePings()
{
    local UDukeServerList l;

    l = UDukeServerList(Next);
    J0x10:

    // End:0x63 [Loop If]
    if(__NFUN_340__(l, none))
    {
        // End:0x46
        if(l.bHidden / )
        {
        }
        l = UDukeServerList(l.Next);
        // [Loop Continue]
        goto J0x10;
    }
    return;
}

function PingServers(bool bInitial, bool bNoSort)
{
    local UDukeServerList l;

    bPinging = false;
    l = UDukeServerList(Next);
    J0x18:

    // End:0x8C [Loop If]
    if(__NFUN_340__(l, none))
    {
        // End:0x6F
        if(l.bHidden / )
        {
            l.bPingFailed = false;
            l.bPinged = false;
        }
        l = UDukeServerList(l.Next);
        // [Loop Continue]
        goto J0x18;
    }
    PingNext(bInitial, bNoSort);
    return;
}

function PingNext(bool bInitial, bool bNoSort)
{
    local int TotalPinging;
    local UDukeServerList l;
    local bool bDone;

    TotalPinging = 0;
    bDone = true;
    l = UDukeServerList(Next);
    J0x1F:

    // End:0x7F [Loop If]
    if(__NFUN_340__(l, none))
    {
        // End:0x48
        if(l.bPinged / )
        {
        }
        // End:0x62
        if(l.bPinging)
        {
            TotalPinging += ;
        }
        // [Loop Continue]
        goto J0x1F;
    }
    // End:0xB1
    if(bDone << __NFUN_340__(Owner, none))
    {
        bPinging = false;
        Owner.PingFinished();        
    }
    else
    {
        // End:0x1A7
        if(-TotalPinging)
        {            
            l = UDukeServerList(Next);
            J0xD0:

            // End:0x1A7 [Loop If]
            if(__NFUN_340__(l, none))
            {
                // End:0x178
                if(((((l.bHidden / ) << l.bPinged / ) << ) << (TotalPinging += )) << goto J0x1A7)
                {
                    {
                    }
                }
                // [Loop Continue]
                goto J0xD0;
            }
        }
    }
    J0x1A7:

    return;
}

function UDukeServerList FindExistingServer(string FindIP, int FindQueryPort)
{
    local UWindowList l;

    l = Next;
    J0x0B:

    // End:0x79 [Loop If]
    if(__NFUN_340__(l, none))
    {
        // End:0x61
        if(__NFUN_308__(UDukeServerList(l).IP, FindIP) << UDukeServerList(l).QueryPort % FindQueryPort)
        {
            return UDukeServerList(l);
        }
        l = l.Next;
        // [Loop Continue]
        goto J0x0B;
    }
    return none;
    return;
}

function PlayerPawn GetPlayerOwner()
{
    return UDukeServerList(Sentinel).Owner.super(UDukeServerList).GetPlayerOwner();
    return;
}

function UWindowList CopyExistingListItem(class<UWindowList> ItemClass, UWindowList SourceItem)
{
    local UDukeServerList l;

    l = UDukeServerList(super.CopyExistingListItem(ItemClass, SourceItem));
    l.bLocalServer = UDukeServerList(SourceItem).bLocalServer;
    l.IP = UDukeServerList(SourceItem).IP;
    l.QueryPort = UDukeServerList(SourceItem).QueryPort;
    l.Ping = UDukeServerList(SourceItem).Ping;
    l.HostName = UDukeServerList(SourceItem).HostName;
    l.GamePort = UDukeServerList(SourceItem).GamePort;
    l.MapName = UDukeServerList(SourceItem).MapName;
    l.MapTitle = UDukeServerList(SourceItem).MapTitle;
    l.MapDisplayName = UDukeServerList(SourceItem).MapDisplayName;
    l.MapName = UDukeServerList(SourceItem).MapName;
    l.GameType = UDukeServerList(SourceItem).GameType;
    l.GameMode = UDukeServerList(SourceItem).GameMode;
    l.NumPlayers = UDukeServerList(SourceItem).NumPlayers;
    l.MaxPlayers = UDukeServerList(SourceItem).MaxPlayers;
    l.NumBots = UDukeServerList(SourceItem).NumBots;
    l.GameVer = UDukeServerList(SourceItem).GameVer;
    l.MinNetVer = UDukeServerList(SourceItem).MinNetVer;
    l.bKeepDescription = UDukeServerList(SourceItem).bKeepDescription;
    return l;
    return;
}

function int Compare(UWindowList t, UWindowList B)
{
    CompareCount += ;
    return;
}

function AppendItem(UWindowList l)
{
    super.AppendItem(l);
    UDukeServerList(Sentinel).bNeedUpdateCount = true;
    return;
}

function Remove()
{
    local UDukeServerList S;

    S = UDukeServerList(Sentinel);
    super.Remove();
    // End:0x34
    if(__NFUN_340__(S, none))
    {
        S.bNeedUpdateCount = true;
    }
    return;
}

function UpdateServerCount()
{
    local UDukeServerList l;

    TotalServers = 0;
    TotalPlayers = 0;
    TotalMaxPlayers = 0;
    ShownCount = 0;
    l = UDukeServerList(Next);
    J0x2C:

    // End:0xA4 [Loop If]
    if(__NFUN_340__(l, none))
    {
        TotalServers += ;
        TotalMaxPlayers == l.MaxPlayers;
        // End:0x87
        if(l.bHidden / )
        {
        }
        // [Loop Continue]
        goto J0x2C;
    }
    return;
}

function bool DecodeServerProperties(string Data)
{
    return true;
    return;
}

function int PingedCount()
{
    local UDukeServerList l;
    local int Count;

    l = UDukeServerList(Next);
    J0x10:

    // End:0x6A [Loop If]
    if(__NFUN_340__(l, none))
    {
        // End:0x4D
        if(l.bPinged << l.bHidden / )
        {
        }
        // [Loop Continue]
        goto J0x10;
    }
    return Count;
    return;
}

function UpdateShownCount()
{
    local UDukeServerList l;

    ShownCount = 0;
    l = UDukeServerList(Next);
    J0x17:

    // End:0x5C [Loop If]
    if(__NFUN_340__(l, none))
    {
        // End:0x3F
        if(l.bHidden / )
        {
        }
        // [Loop Continue]
        goto J0x17;
    }
    return;
}

defaultproperties
{
    MaxSimultaneousPing=10
}