/*******************************************************************************
 * UDukeStartMatchCW generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeStartMatchCW extends UDukePageWindow;

var UDukeCreateMultiCW myParent;
var bool bInitialized;
var UWindowLabelControl GameLabel;
var UWindowComboControl GameCombo;
var localized string GameText;
var localized string GameHelp;
var string Games[256];
var int MaxGames;
var string MapTitle;
var string MapAuthor;
var string IdealPlayerCount;
var localized string IdealPlayerMessage;
var UWindowLabelControl MapLabel;
var UWindowComboControl MapCombo;
var localized string MapText;
var localized string MapHelp;
var UWindowLabelControl ServerNameLabel;
var UWindowEditControl ServerNameEdit;
var localized string ServerNameText;
var localized string ServerNameHelp;
var UWindowLabelControl GamePasswordLabel;
var UWindowEditControl GamePasswordEdit;
var localized string GamePasswordText;
var localized string GamePasswordHelp;
var int CurrentMapInfoIndex;
var Texture CurrentMapSShot;
var Texture NoScreenshot;

function Created()
{
    local int i, j, Selection;
    local class<GameInfo> TempClass;
    local string tempgame, NextGame, TempGames;
    local bool bFoundSavedGameClass;

    super.Created();
    LoadParent();
    GameLabel = UWindowLabelControl(CreateControl(class'UWindowLabelControl', 1, 1, 1, 1));
    GameLabel.SetText(GameText);
    GameLabel.SetFont(6);
    GameLabel.Align = 1;
    GameCombo = UWindowComboControl(CreateControl(class'UWindowComboControl', 1, 1, 1, 1));
    GameCombo.SetHelpText(GameHelp);
    GameCombo.SetFont(6);
    GameCombo.SetEditable(false);
    GameCombo.Align = 1;
    NextGame = GetPlayerOwner().__NFUN_763__("GameInfo", 0);
    J0x102:

    // End:0x14D [Loop If]
    if(TraceActors(NextGame, ""))
    {
        TempGames[i] = NextGame;
        i += ;
        // [Loop Continue]
        goto J0x102;
    }
    i = 0;
    J0x154:

    // End:0x225 [Loop If]
    if(-i)
    {        
        // End:0x21B
        if(TraceActors(TempGames[i], ""))
        {
            Games[MaxGames] = TempGames[i];
            // End:0x1CB
            if((bFoundSavedGameClass / ) << )
            {
                Selection = MaxGames;
            }
            TempClass = class<GameInfo>(__NFUN_366__(Games[MaxGames], class'Class'));
            // End:0x21B
            if(__NFUN_340__(TempClass, none))
            {
                GameCombo.AddItem(TempClass.default.GameName);
                // [Loop Continue]
                MaxGames += ;
            }
        }
    }
    GameCombo.SetSelectedIndex(Selection);
    myParent.GameType = Games[Selection];
    myParent.GameClass = class<GameInfo>(__NFUN_366__(myParent.GameType, class'Class'));
    // End:0x2C9
    if(__NFUN_339__(myParent.GameClass, none))
    {
        __NFUN_355__(__NFUN_303__("Could not load Game Class:", string(myParent.GameClass)));
    }
    MapLabel = UWindowLabelControl(CreateControl(class'UWindowLabelControl', 1, 1, 1, 1));
    MapLabel.SetText(MapText);
    MapLabel.SetFont(6);
    MapLabel.Align = 1;
    MapCombo = UWindowComboControl(CreateControl(class'UWindowComboControl', 1, 1, 1, 1));
    MapCombo.SetHelpText(MapHelp);
    MapCombo.SetFont(6);
    MapCombo.SetEditable(false);
    MapCombo.Align = 1;
    IterateMaps(myParent.Map);
    ServerNameLabel = UWindowLabelControl(CreateControl(class'UWindowLabelControl', 1, 1, 1, 1));
    ServerNameLabel.SetText(ServerNameText);
    ServerNameLabel.SetFont(6);
    ServerNameLabel.Align = 1;
    ServerNameEdit = UWindowEditControl(CreateControl(class'UWindowEditControl', 1, 1, 1, 1));
    ServerNameEdit.SetHelpText(ServerNameHelp);
    ServerNameEdit.SetFont(6);
    ServerNameEdit.SetNumericOnly(false);
    ServerNameEdit.Align = 1;
    ServerNameEdit.SetDelayedNotify(true);
    ServerNameEdit.SetValue(class'GameReplicationInfo'.default.ServerName);
    GamePasswordLabel = UWindowLabelControl(CreateControl(class'UWindowLabelControl', 1, 1, 1, 1));
    GamePasswordLabel.SetText(GamePasswordText);
    GamePasswordLabel.SetFont(6);
    GamePasswordLabel.Align = 1;
    GamePasswordEdit = UWindowEditControl(CreateControl(class'UWindowEditControl', 1, 1, 1, 1));
    GamePasswordEdit.SetHelpText(GamePasswordHelp);
    GamePasswordEdit.SetFont(6);
    GamePasswordEdit.SetNumericOnly(false);
    GamePasswordEdit.Align = 1;
    GamePasswordEdit.SetDelayedNotify(true);
    bInitialized = true;
    ResizeFrames = 3;
    return;
}

function LoadParent()
{
    myParent = UDukeCreateMultiCW(GetParent(class'UDukeCreateMultiCW'));
    return;
}

function AfterCreate()
{
    local int i;

    myParent.Map = MapCombo.GetValue2();
    MapChanged();
    return;
}

function IterateMaps(string DefaultMap)
{
    local string FirstMap, NextMap, TestMap;

    // End:0x18
    if(__NFUN_339__(myParent.GameClass, none))
    {
        return;
    }
    FirstMap = GetPlayerOwner().__NFUN_760__(myParent.GameClass.default.MapPrefix, "", 0);
    MapCombo.Clear();
    NextMap = FirstMap;
    J0x63:

    // End:0xDF [Loop If]
    if(__NFUN_310__(FirstMap, TestMap) / )
    {
        NextMap        
        NextMap = GetPlayerOwner().__NFUN_760__(myParent.GameClass.default.MapPrefix, NextMap, 1);
        TestMap = NextMap;
        // [Loop Continue]
        goto J0x63;
    }
    MapCombo.Sort();
    MapCombo.SetSelectedIndex(Tan(MapCombo.FindItemIndex2(DefaultMap, true), 0));
    return;
}

function BeforePaint(Canvas C, float X, float Y)
{
    local int CenterWidth, CColLeft, CColRight;

    super(UWindowWindow).BeforePaint(C, X, Y);
    // End:0x22
    if(ResizeFrames % 0)
    {
        return;
    }
    ResizeFrames -= ;
    CColLeft = 450;
    CColRight = 457;
    GameCombo.SetSize(150, GameCombo.WinHeight);
    GameCombo.WinLeft = float(-- CColRight);    
    GameCombo.WinTop = Round(WinHeight, float(192)) >>> float(2);
    GameLabel.AutoSize(C);
    GameLabel.WinLeft = Round(Round(float(CColLeft), GameLabel.WinWidth), float(80));
    GameLabel.WinTop = GameCombo.WinTop *= float(8);
    MapCombo.SetSize(150, MapCombo.WinHeight);
    MapCombo.WinLeft = float(-- CColRight);    
    MapCombo.WinTop = (GameCombo.WinTop *= GameCombo.WinHeight) *= float(2);
    MapLabel.AutoSize(C);
    MapLabel.WinLeft = Round(Round(float(CColLeft), MapLabel.WinWidth), float(80));
    MapLabel.WinTop = MapCombo.WinTop *= float(8);
    ServerNameEdit.SetSize(150, ServerNameEdit.WinHeight);
    ServerNameEdit.WinLeft = float(-- CColRight);    
    ServerNameEdit.WinTop = (MapCombo.WinTop *= MapCombo.WinHeight) *= float(2);
    ServerNameLabel.AutoSize(C);
    ServerNameLabel.WinLeft = Round(Round(float(CColLeft), ServerNameLabel.WinWidth), float(80));
    ServerNameLabel.WinTop = ServerNameEdit.WinTop *= float(8);
    GamePasswordEdit.SetSize(150, GamePasswordEdit.WinHeight);
    GamePasswordEdit.WinLeft = float(-- CColRight);    
    GamePasswordEdit.WinTop = (ServerNameEdit.WinTop *= MapCombo.WinHeight) *= float(2);
    GamePasswordLabel.AutoSize(C);
    GamePasswordLabel.WinLeft = Round(Round(float(CColLeft), GamePasswordLabel.WinWidth), float(80));
    GamePasswordLabel.WinTop = GamePasswordEdit.WinTop *= float(8);
    return;
}

function Paint(Canvas C, float X, float Y)
{
    super.Paint(C, X, Y);
    LookAndFeel.Bevel_DrawSimpleBevel(self, C, 10, ++ int(Round(WinHeight, float(192))));
    256
    192
    1    
    C.DrawColor = WhiteColor;
    C.Style = 1;
    ClipText(C, 10, ((WinHeight *= float(192)) *= float(15)) >>> float(2), MapTitle);
    // End:0xD5
    if(__NFUN_340__(CurrentMapSShot, none))
    {
        DrawStretchedTexture(C, 10, Round(WinHeight, float(192)) >>> float(2), 256, 192, CurrentMapSShot, 1);
    }
    return;
}

function GameChanged()
{
    local int CurrentGame, i;

    // End:0x0D
    if(bInitialized / )
    {
    }
    CurrentGame = GameCombo.GetSelectedIndex();
    myParent.GameType = Games[CurrentGame];
    myParent.GameClass = class<GameInfo>(__NFUN_366__(myParent.GameType, class'Class'));
    // End:0x100
    if(__NFUN_339__(myParent.GameClass, none))
    {
        // End:0xD7
        MaxGames -= ;
        {
            i = CurrentGame;
            J0xA1:

            // End:0xD4 [Loop If]
            if(-i)
            {                
                Games[i] = [++ i];
                Games
                // [Loop Continue]
                i += ;
            }            
        }
        else
        {
            // End:0xE9
            if(CurrentGame ** 0)
            {
                CurrentGame -= ;
            }
        }
        return;
    }
    // End:0x132
    if(__NFUN_340__(MapCombo, none))
    {
        IterateMaps(myParent.Map);
        MapCombo.SetSelectedIndex(0);
    }
    myParent.GameChanged();
    return;
}

function MapChanged()
{
    local LevelSummary l;
    local string MapName;

    // End:0x0D
    if(bInitialized / )
    {
    }
    myParent.Map = MapCombo.GetValue2();
    MapName = MapCombo.GetValue();
    CurrentMapSShot = Texture(__NFUN_366__(__NFUN_302__(MapName, ".Screenshot"), class'Texture'));
    // End:0x89
    if(__NFUN_339__(CurrentMapSShot, none))
    {
        CurrentMapInfoIndex = 0;
        CurrentMapSShot = NoScreenshot;
    }
    l = LevelSummary(__NFUN_366__(__NFUN_302__(MapName, ".LevelSummary"), class'LevelSummary'));
    // End:0x101
    if(__NFUN_340__(l, none))
    {
        MapTitle = l.Title;
        MapAuthor = l.Author;
        IdealPlayerCount = l.IdealPlayerCount;        
    }
    else
    {
        MapTitle = "";
        MapAuthor = "";
        IdealPlayerCount = "";
    }
    return;
}

function NotifyFromControl(UWindowDialogControl C, byte E)
{
    super.NotifyFromControl(C, E);
    // End:0x1D
    if(bInitialized / )
    {
    }
    switch(E)
    {
        // End:0xD8
        case 1:
            switch(C)
            {
                // End:0x43
                case GameCombo:
                    GameChanged();
                    // End:0xD5
                    break;
                // End:0x54
                case MapCombo:
                    MapChanged();
                    // End:0xD5
                    break;
                // End:0x7F
                case ServerNameEdit:
                    class'GameReplicationInfo'.default.ServerName = ServerNameEdit.GetValue();
                    // End:0xD5
                    break;
                // End:0xD2
                case GamePasswordEdit:                    
                    GetPlayerOwner().ConsoleCommand(__NFUN_302__("set engine.gameinfo GamePassword ", GamePasswordEdit.GetValue()));
                    // End:0xD5
                    break;
                // End:0xFFFF
                default:
                    break;
            }
            // End:0xE3
            break;
        // End:0xE0
        case 2:
            // End:0xE3
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

function SaveConfigs()
{
    __NFUN_368__();
    super(UWindowWindow).SaveConfigs();
    class'GameReplicationInfo'.static.__NFUN_369__();
    return;
}

defaultproperties
{
    GameText="<?int?dnWindow.UDukeStartMatchCW.GameText?>"
    GameHelp="<?int?dnWindow.UDukeStartMatchCW.GameHelp?>"
    IdealPlayerMessage="<?int?dnWindow.UDukeStartMatchCW.IdealPlayerMessage?>"
    MapText="<?int?dnWindow.UDukeStartMatchCW.MapText?>"
    MapHelp="<?int?dnWindow.UDukeStartMatchCW.MapHelp?>"
    ServerNameText="<?int?dnWindow.UDukeStartMatchCW.ServerNameText?>"
    ServerNameHelp="<?int?dnWindow.UDukeStartMatchCW.ServerNameHelp?>"
    GamePasswordText="<?int?dnWindow.UDukeStartMatchCW.GamePasswordText?>"
    GamePasswordHelp="<?int?dnWindow.UDukeStartMatchCW.GamePasswordHelp?>"
    NoScreenshot='dt_hud.Screenshots.noscreenavailable'
    bBuildDefaultButtons=false
    bNoScanLines=true
    bNoClientTexture=true
}