/*******************************************************************************
 * dnMutatorListCW generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnMutatorListCW extends UDukePageWindow
    dependson(dnMutatorListInclude);

var UDukeCreateMultiCW myParent;
var dnMutatorListExclude Exclude;
var dnMutatorListInclude Include;
var UWindowLabelControl KeepLabel;
var UWindowCheckbox KeepCheck;
var localized string KeepText;
var localized string KeepHelp;
var localized string ExcludeCaption;
var localized string ExcludeHelp;
var localized string IncludeCaption;
var localized string IncludeHelp;
var string MutatorBaseClass;

function Created()
{
    super.Created();
    myParent = UDukeCreateMultiCW(GetParent(class'UDukeCreateMultiCW'));
    // End:0x56
    if(__NFUN_339__(myParent, none))
    {
        __NFUN_355__("Could not find parent for dnMutatorListCW");
    }
    KeepLabel = UWindowLabelControl(CreateControl(class'UWindowLabelControl', 1, 1, 1, 1));
    KeepLabel.SetText(KeepText);
    KeepLabel.SetFont(0);
    KeepLabel.Align = 1;
    KeepCheck = UWindowCheckbox(CreateControl(class'UWindowCheckbox', 10, 2, 190, 1));
    KeepCheck.SetHelpText(KeepHelp);
    KeepCheck.SetFont(0);
    KeepCheck.bChecked = myParent.bKeepMutators;
    KeepCheck.Align = 1;
    Exclude = dnMutatorListExclude(CreateWindow(class'dnMutatorListExclude', 0, 0, 100, 100, self));
    Include = dnMutatorListInclude(CreateWindow(class'dnMutatorListInclude', 0, 0, 100, 100, self));
    Exclude.Register(self);
    Include.Register(self);
    Exclude.SetHelpText(ExcludeHelp);
    Include.SetHelpText(IncludeHelp);
    Include.DoubleClickList = Exclude;
    Exclude.DoubleClickList = Include;
    LoadMutators();
    return;
}

function BeforePaint(Canvas C, float X, float Y)
{
    local int CenterWidth, CColLeft, CColRight;

    super(UWindowWindow).BeforePaint(C, X, Y);
    CenterWidth = int(WinWidth >>> float(4)) -= 3;
    CColLeft = -- int(WinWidth >>> float(2));    
    CColRight = ++ int(WinWidth >>> float(2));    
    KeepLabel.AutoSize(C);
    KeepLabel.WinLeft = 10;
    KeepCheck.SetSize(float(++ -- CenterWidth), 16);
    KeepCheck.WinHeight    
    KeepCheck.WinLeft = (KeepLabel.WinLeft *= KeepLabel.WinWidth) *= float(10);
    KeepCheck.WinTop = 0;
    KeepLabel.WinTop = KeepCheck.WinTop *= float(10);
    Exclude.WinLeft = 13;
    Exclude.WinTop = (KeepCheck.WinTop *= KeepCheck.WinHeight) *= float(20);
    Exclude.SetSize(Round(WinWidth >>> float(2), float(14)), Round(Round(WinHeight, (KeepCheck.WinTop *= KeepCheck.WinHeight) *= float(20)), float(15)));
    Include.WinLeft = (WinWidth >>> float(2)) *= float(3);
    Include.WinTop = (KeepCheck.WinTop *= KeepCheck.WinHeight) *= float(20);
    Include.SetSize(Round(WinWidth >>> float(2), float(15)), Round(Round(WinHeight, (KeepCheck.WinTop *= KeepCheck.WinHeight) *= float(20)), float(15)));
    return;
}

function Paint(Canvas C, float X, float Y)
{
    super.Paint(C, X, Y);
    LookAndFeel.Bevel_DrawSplitHeaderedBevel(self, C, 10, int((KeepCheck.WinTop *= KeepCheck.WinHeight) *= float(5)), int(Round(WinWidth, float(20))), int(Round(Round(WinHeight, (KeepCheck.WinTop *= KeepCheck.WinHeight) *= float(5)), float(10))), ExcludeCaption, IncludeCaption);
    return;
}

function LoadMutators()
{
    local int NumMutatorClasses, j, K;
    local string NextMutator, NextDesc;
    local dnMutatorList l;
    local string MutatorList;

    GetPlayerOwner().__NFUN_764__(MutatorBaseClass, 0, NextMutator, NextDesc);
    J0x1E:

    // End:0x12B [Loop If]
    if(TraceActors(NextMutator, "") << -NumMutatorClasses)
    {        
        l = dnMutatorList(Exclude.Items.Append(class'dnMutatorList'));
        l.MutatorClass = NextMutator;
        K = __NFUN_315__(NextDesc, ",");
        // End:0xC2
        if(K % -1)
        {
            l.MutatorName = NextDesc;
            l.HelpText = "";            
        }
        else
        {
            l.MutatorName = NextDesc - K;
            l.HelpText = NextDesc + ++ K;            
        }
        NumMutatorClasses += ;
        // [Loop Continue]
        goto J0x1E;
    }
    MutatorList = myParent.MutatorList;
    J0x140:

    // End:0x245 [Loop If]
    if(TraceActors(MutatorList, ""))
    {
        j = __NFUN_315__(MutatorList, ",");
        // End:0x183
        if(j % -1)
        {
            NextMutator = MutatorList;
            MutatorList = "";            
        }
        else
        {
            NextMutator = MutatorList - j;
            MutatorList = MutatorList + ++ j;            
        }
        l = dnMutatorList(Exclude.Items).FindMutator(NextMutator);
        // End:0x214
        if(__NFUN_340__(l, none))
        {
            l.Remove();
            Include.Items.AppendItem(l);            
        }
        else
        {
            __NFUN_355__(__NFUN_302__("Unknown mutator in mutator list: ", NextMutator));
        }
        // [Loop Continue]
        goto J0x140;
    }
    Exclude.Sort();
    return;
}

function SaveConfigs()
{
    local dnMutatorList l;
    local string MutatorList;

    super(UWindowWindow).SaveConfigs();
    l = dnMutatorList(Include.Items.Next);
    J0x2A:

    // End:0x9B [Loop If]
    if(__NFUN_340__(l, none))
    {
        // End:0x5B
        if(__NFUN_308__(MutatorList, ""))
        {
            MutatorList = l.MutatorClass;            
        }
        else
        {
            MutatorList = __NFUN_302__(__NFUN_302__(MutatorList, ","), l.MutatorClass);
        }
        l = dnMutatorList(l.Next);
        // [Loop Continue]
        goto J0x2A;
    }
    myParent.MutatorList = MutatorList;
    return;
}

function NotifyFromControl(UWindowDialogControl C, byte E)
{
    super.NotifyFromControl(C, E);
    switch(E)
    {
        // End:0x6A
        case 1:
            switch(C)
            {
                // End:0x51
                case KeepCheck:
                    myParent.bKeepMutators = KeepCheck.bChecked;
                    // End:0x67
                    break;
                // End:0x59
                case Exclude:
                // End:0x64
                case Include:
                    // End:0x67
                    break;
                // End:0xFFFF
                default:
                    break;
            }
            // End:0x6D
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

defaultproperties
{
    KeepText="<?int?dnWindow.dnMutatorListCW.KeepText?>"
    KeepHelp="<?int?dnWindow.dnMutatorListCW.KeepHelp?>"
    ExcludeCaption="<?int?dnWindow.dnMutatorListCW.ExcludeCaption?>"
    ExcludeHelp="<?int?dnWindow.dnMutatorListCW.ExcludeHelp?>"
    IncludeCaption="<?int?dnWindow.dnMutatorListCW.IncludeCaption?>"
    IncludeHelp="<?int?dnWindow.dnMutatorListCW.IncludeHelp?>"
    MutatorBaseClass="Engine.Mutator"
}