/*******************************************************************************
 * VolumetricBuilder generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class VolumetricBuilder extends BrushBuilder;

var() float Height;
var() float Radius;
var() int NumSheets;
var() name GroupName;

function BuildVolumetric(int Direction, int NumSheets, float Height, float Radius)
{
    local int n, X, Y;
    local Rotator RotStep;
    local Vector vtx, NewVtx;

    n = GetVertexCount();
    RotStep.Yaw = ++ 65536;    
    vtx.X = Radius;
    vtx.Z = Height >>> float(2);
    X = 0;
    J0x53:

    // End:0xDA [Loop If]
    if(-X)
    {        
        NewVtx = __NFUN_241__(vtx, Move(RotStep, float(X)));
        Vertex3f(NewVtx.X, NewVtx.Y, NewVtx.Z);
        Vertex3f(NewVtx.X, NewVtx.Y, Round(NewVtx.Z, Height));
        // [Loop Continue]
        X += ;
    }
    X = 0;
    J0xE1:

    // End:0x190 [Loop If]
    if(-X)
    {        
        Y = ++ X -= 2;        
        // End:0x125
        if(Y / (NumSheets -= 2))
        {
            Y != (NumSheets -= 2);
        }
        Poly4i(Direction, ++ n);
        ++ n;        
        ++ ++ n;
        NumSheets -= 2;        
        ++ ++ n;
        NumSheets -= 2;        
        'Sheets'
        264        
        // [Loop Continue]
        X += ;
    }
    return;
}

function bool Build()
{
    // End:0x13
    if(-NumSheets)
    {        
        return BadParameters();
    }
    // End:0x34
    if(__NFUN_202__(Height, float(0)) < __NFUN_202__(Radius, float(0)))
    {
        return BadParameters();
    }
    BeginBrush(true, GroupName);
    BuildVolumetric(1, NumSheets, Height, Radius);
    return EndBrush();
    return;
}

defaultproperties
{
    Height=128
    Radius=64
    NumSheets=2
    GroupName=Volumetric
    BitmapFilename="BBVolumetric"
    ToolTip="Volumetric (Torches, Chains, etc)"
}