/*******************************************************************************
 * BaseAI generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class BaseAI extends Pawn
    native
    config
    collapsecategories
    notplaceable;

const AI_InvalidRefID = -1;
const AI_NoMaxLifeTime = -1.0f;
const AI_DefaultClipTolerance = 60.0f;
const AI_DefaultSetAimTime = 0.2f;
const AI_DefaultHeadBlendTime = 0.5f;
const AI_DefaultEyeBlendTime = 0.25f;
const AI_DefaultBlendOffTime = 0.5f;
const AI_DefaultNoThreshold = -1.0f;
const AI_NoExitTime = -1.0f;
const AI_Infinite = 2147483646;
const ATWGHT_InfiniteLove = 1000;
const ATWGHT_Idolize = 3;
const ATWGHT_Love = 2;
const ATWGHT_Like = 1;
const ATWGHT_Neutral = 0;
const ATWGHT_Dislike = -1;
const ATWGHT_Hate = -2;
const ATWGHT_Despise = -3;
const ATWGHT_InfiniteHate = -1000;

enum EAIArcSector
{
    AIARCSECTOR_Forward,
    AIARCSECTOR_Backward,
    AIARCSECTOR_Left,
    AIARCSECTOR_Right
};

enum EAIMoveToResult
{
    AIMOVETORESULT_Succeeded,
    AIMOVETORESULT_Failed,
    AIMOVETORESULT_Turn,
    AIMOVETORESULT_Move
};

enum EAIPathResult
{
    AIPATH_Succeeded,
    AIPATH_Failed,
    AIPATH_OpenDoor
};

enum EAIPathFailMode
{
    AIPATHFAIL_FailAndQuit,
    AIPATHFAIL_WaitForever
};

enum EAIDynamicPathPriority
{
    AIDPATH_AlwaysDynamicPath,
    AIDPATH_Default,
    AIDPATH_NPC,
    AIDPATH_Rat,
    AIDPATH_Medium,
    AIDPATH_Large,
    AIDPATH_Player,
    AIDPATH_Scripted
};

enum EAIWeapManMode
{
    WEAPMAN_Mode_None,
    WEAPMAN_Mode_AimOff,
    WEAPMAN_Mode_Wait,
    WEAPMAN_Mode_StartAimAtTarget,
    WEAPMAN_Mode_StartAimAtScanTarget,
    WEAPMAN_Mode_StopAim,
    WEAPMAN_Mode_StopAimFast,
    WEAPMAN_Mode_AimerStopAim,
    WEAPMAN_Mode_Scan,
    WEAPMAN_Mode_PreFire,
    WEAPMAN_Mode_Charge,
    WEAPMAN_Mode_Fire,
    WEAPMAN_Mode_PostFire
};

enum EAIOp
{
    AIOP_None,
    AIOP_FUBAR,
    AIOP_AggressiveIdle,
    AIOP_AimOn,
    AIOP_AimOff,
    AIOP_AlignWithGuardedActor,
    AIOP_AnimPreset,
    AIOP_BallModeStart,
    AIOP_BallModeEnd,
    AIOP_Bezerk,
    AIOP_BladeSpinStart,
    AIOP_BladeSpinStop,
    AIOP_Bound,
    AIOP_CatchTKObj,
    AIOP_Charge,
    AIOP_ChargeStart,
    AIOP_Cloak,
    AIOP_CombatTurn,
    AIOP_Contract,
    AIOP_Cower,
    AIOP_Crouch,
    AIOP_DeCloak,
    AIOP_Destroy,
    AIOP_Die,
    AIOP_Disable,
    AIOP_DodgeLeft,
    AIOP_DodgeRight,
    AIOP_Extend,
    AIOP_Fall,
    AIOP_Fidget,
    AIOP_Fire,
    AIOP_FireBoth,
    AIOP_FireLeft,
    AIOP_FireRight,
    AIOP_FireDelay,
    AIOP_FireWeapon,
    AIOP_FreeMoveCircleStrafe,
    AIOP_FreeMoveFlank,
    AIOP_FreeMoveFloat,
    AIOP_FreeMoveRest,
    AIOP_FreeMoveSpreadOut,
    AIOP_GotoActorClosestNavPos,
    AIOP_GotoActorClosestNavPosSlow,
    AIOP_GotoGoalClippedMoveFocusTarget,
    AIOP_GotoGoalFocusGuardedActor,
    AIOP_GotoGoalFocusGuardedActorFullBody,
    AIOP_GotoGoalFocusGuardedActorSlow,
    AIOP_GotoGoalFocusPos,
    AIOP_GotoGoalFocusPosOneStep,
    AIOP_GotoGoalFocusPosSlow,
    AIOP_GotoGoalFocusReciprocalPos,
    AIOP_GotoGoalFocusReciprocalPosSlow,
    AIOP_GotoGoalFocusTarget,
    AIOP_GotoGoalFocusTargetFullBody,
    AIOP_GotoGoalFocusTargetFullBodySlow,
    AIOP_GotoGoalFocusTargetSlow,
    AIOP_GotoJumpAttackRangeFocusActor,
    AIOP_GotoJumpAttackRangeFocusPos,
    AIOP_GotoJumpAttackRangeSlowFocusActor,
    AIOP_GotoJumpAttackRangeSlowFocusPos,
    AIOP_GotoLandPos,
    AIOP_GotoMeleeRangeFocusActor,
    AIOP_GotoMeleeRangeFocusFullBody,
    AIOP_GotoMeleeRangeFocusPos,
    AIOP_GotoMeleeRangePhysics,
    AIOP_GotoMeleeRangeSlowFocusActor,
    AIOP_GotoMeleeRangeSlowFocusFullBody,
    AIOP_GotoPreset,
    AIOP_GotoPresetSlow,
    AIOP_GotoRnd3DFocusPos,
    AIOP_GotoRnd3DFocusActorFullBody,
    AIOP_GotoSearchPos,
    AIOP_GotoSearchPosSlow,
    AIOP_GotoWeaponRangeFocusActor,
    AIOP_GotoWeaponRangeFocusFullBody,
    AIOP_GotoWeaponRangeFocusPos,
    AIOP_GotoWeaponRangeSlowFocusActor,
    AIOP_GotoWeaponRangeSlowFocusFullBody,
    AIOP_GotoWanderGoalFocusPos,
    AIOP_HaltFireMelee,
    AIOP_Haywire,
    AIOP_Hide,
    AIOP_HoldFire,
    AIOP_Hover,
    AIOP_HurlProp,
    AIOP_Idle,
    AIOP_IdleEX,
    AIOP_Jump,
    AIOP_JumpPreset,
    AIOP_JumpAttack,
    AIOP_Land,
    AIOP_LookAround,
    AIOP_MeleeAttack,
    AIOP_MoveStart,
    AIOP_MoveStop,
    AIOP_MultiAnim,
    AIOP_Pain,
    AIOP_Pause,
    AIOP_PickupProp,
    AIOP_PlaceTripMinePreset,
    AIOP_PopUp,
    AIOP_Prone,
    AIOP_Rappel,
    AIOP_ReleaseTKObj,
    AIOP_Reload,
    AIOP_ResumeFire,
    AIOP_Retract,
    AIOP_RoarFocusActor,
    AIOP_RollForward,
    AIOP_RollForwardToCrouch,
    AIOP_RollLeft,
    AIOP_RollLeftToCrouch,
    AIOP_RollRight,
    AIOP_RollRightToCrouch,
    AIOP_SelectBestWeapon,
    AIOP_SelectPresetWeapon,
    AIOP_SelectPresetWeaponQuick,
    AIOP_ShootProjectile,
    AIOP_ShootProjectileEnd,
    AIOP_StandCombat,
    AIOP_StandPassive,
    AIOP_StandScared,
    AIOP_StandWounded,
    AIOP_StrafeMeleeFocusPos,
    AIOP_StrafeMeleeFocusActor,
    AIOP_StrafeMeleeFocusActorFullBody,
    AIOP_StrafeMeleeSlowFocusPos,
    AIOP_StrafeMeleeSlowFocusActor,
    AIOP_StrafeMeleeSlowFocusActorFullBody,
    AIOP_StrafeWeaponFocusPos,
    AIOP_StrafeWeaponFocusActor,
    AIOP_StrafeWeaponFocusActorFullBody,
    AIOP_StrafeWeaponSlowFocusPos,
    AIOP_StrafeWeaponSlowFocusActor,
    AIOP_StrafeWeaponSlowFocusActorFullBody,
    AIOP_Stomp,
    AIOP_Stun,
    AIOP_TakeOff,
    AIOP_Teleport,
    AIOP_ThrowPipeBomb,
    AIOP_ThrowProp,
    AIOP_ThrowTKObj,
    AIOP_TriggerScriptTag,
    AIOP_TurnToGuardedActor,
    AIOP_TurnToPreset,
    AIOP_TurnToPrimaryTarget,
    AIOP_UsePreset,
    AIOP_ScriptBase,
    AIOP_ScriptExample,
    AIOP_MoveToPodProtectorBase,
    AIOP_Dummy
};

enum EAIOpStatus
{
    AIOPSTATUS_None,
    AIOPSTATUS_Working,
    AIOPSTATUS_Succeeded,
    AIOPSTATUS_Failed
};

enum EAINodeStatus
{
    AINODESTATUS_Invalid,
    AINODESTATUS_Ready,
    AINODESTATUS_Working,
    AINODESTATUS_Succeeded,
    AINODESTATUS_Failed
};

enum EAIStateStatus
{
    AISTATESTATUS_None,
    AISTATESTATUS_Working,
    AISTATESTATUS_Succeeded,
    AISTATESTATUS_Failed
};

enum EAIWindow
{
    WIN_Always,
    WIN_OnIdle,
    WIN_OnSuccess,
    WIN_OnFailure
};

enum EAICode
{
    AICODE_Ok,
    AICODE_Unspecified,
    AICODE_WindowClosed,
    AICODE_ValidTarget,
    AICODE_NoTarget,
    AICODE_TargetLost,
    AICODE_NoFocus,
    AICODE_FacingActor,
    AICODE_FacingPos,
    AICODE_InRange,
    AICODE_PathFailed,
    AICODE_TargetOutsidePath,
    AICODE_AlreadySelected,
    AICODE_NotInInventory,
    AICODE_NoAmmo,
    AICODE_AlreadyOn,
    AICODE_AlreadyOff,
    AICODE_AnimNotFound,
    AICODE_TargetTooClose,
    AICODE_TargetTooFar,
    AICODE_TargetTooHigh,
    AICODE_TargetTooLow,
    AICODE_NotDirectlyReachable,
    AICODE_TargetFalling,
    AICODE_AimNotUsed,
    AICODE_RndFailed,
    AICODE_ScriptEventNotFound,
    AICODE_NoLOS,
    AICODE_WeaponFullyLoaded,
    AICODE_NoWeapon,
    AICODE_WeaponNotActive,
    AICODE_WeaponNeedsReload,
    AICODE_WeaponLoaded,
    AICODE_Crouching,
    AICODE_Prone,
    AICODE_StandingCombat,
    AICODE_StandingPassive,
    AICODE_StandingScared,
    AICODE_StandingWounded,
    AICODE_NotStanding,
    AICODE_NotStandingCombat,
    AICODE_CurrentOpMustFinish,
    AICODE_CurrentOpShouldFinish,
    AICODE_NoDamageInfo,
    AICODE_ShowPainIsDisabled,
    AICODE_NoHealth,
    AICODE_NoValidInfoNode,
    AICODE_AlreadyAtInfoNode,
    AICODE_NotFacingTarget,
    AICODE_AlreadyCloaked,
    AICODE_NotCloaking,
    AICODE_JetPacking,
    AICODE_NotJetPacking,
    AICODE_FailedToFindAGoal,
    AICODE_NewGoalTooClose,
    AICODE_TargetNotVisible,
    AICODE_TargetNotAimingAtMe,
    AICODE_TooLongSinceDamaged,
    AICODE_InCrouchingCover,
    AICODE_InStandingCover,
    AICODE_TooLittleTimeElapsed,
    AICODE_LOSToTarget,
    AICODE_HealthTooHigh,
    AICODE_NotGuarding,
    AICODE_NotGuardingPawn,
    AICODE_NotInTheWay,
    AICODE_CannotJump,
    AICODE_NoPipeBombs,
    AICODE_TargetNotInRequiredPhysicsMode,
    AICODE_NotInDanger,
    AICODE_ValidTKObj,
    AICODE_NoTKObj,
    AICODE_ConstrainedToRangedAttacks,
    AICODE_ConstrainedToMeleeAttacks,
    AICODE_ClearPathToTarget,
    AICODE_NoClearPathToTarget,
    AICODE_IncorrectWeapon,
    AICODE_WeaponAimerOn,
    AICODE_IncorrectPhysics,
    AICODE_NoProp,
    AICODE_ConstrainedToLocation,
    AICODE_NoContracts,
    AICODE_CannotPerformContract,
    AICODE_PartyCannotPerformContract,
    AICODE_PartyIsNotAI,
    AICODE_NotAgreed,
    AICODE_WrongClass,
    AICode_NegotiationGateClosed,
    AICode_NotInContract,
    AICODE_InvalidClass,
    AICODE_WrongAnimController,
    AICODE_PartiesNotLevel,
    AICODE_EMPGateClosed,
    AICODE_NotShrunk,
    AICODE_TargetShrunk,
    AICODE_PopUpDisabled,
    AICODE_NotUsingActionPoints,
    AICODE_NoActionPoint,
    AICODE_AtActionPoint,
    AICODE_NotAtActionPoint,
    AICODE_ActionPointNotUseable,
    AICODE_ActionPointOutsideParms,
    AICODE_ActionPointOK,
    AICODE_TargetMounted,
    AICODE_FinishingMoveNotAllowed,
    AICODE_GlobalGateCheckFailed
};

enum EAICondition
{
    COND_Always,
    COND_Never,
    COND_HasTarget,
    COND_ValidTarget,
    COND_ValidTarget1,
    COND_ValidTarget3,
    COND_ValidTarget10,
    COND_NoTarget,
    COND_TargetValidNoContact,
    COND_TargetLost3,
    COND_TargetLost10,
    COND_Rnd10,
    COND_Rnd20,
    COND_Rnd30,
    COND_Rnd40,
    COND_Rnd50,
    COND_Rnd60,
    COND_Rnd70,
    COND_Rnd80,
    COND_Rnd90,
    COND_InMeleeZone,
    COND_NotInMeleeZone,
    COND_InMeleeRange,
    COND_NotInMeleeRange,
    COND_InWeaponRange,
    COND_NotInWeaponRange,
    COND_InJumpAttackRange,
    COND_NotInJumpAttackRange,
    COND_NeedReload,
    COND_DontNeedReload,
    COND_NoAmmoLoaded,
    COND_StandingCombat,
    COND_NotStandingCombat,
    COND_StandingPassive,
    COND_NotStandingPassive,
    COND_StandingScared,
    COND_NotStandingScared,
    COND_Crouched,
    COND_NotCrouched,
    COND_Prone,
    COND_NotProne,
    COND_FacingTarget,
    COND_FacingTarget5,
    COND_FacingTarget10,
    COND_FacingTarget15,
    COND_FacingTarget30,
    COND_FacingTarget45,
    COND_FacingTarget90,
    COND_NotFacingTarget,
    COND_NotFacingTarget5,
    COND_NotFacingTarget10,
    COND_NotFacingTarget15,
    COND_NotFacingTarget30,
    COND_NotFacingTarget45,
    COND_NotFacingTarget90,
    COND_DeCloaking,
    COND_JetPacking,
    COND_NotJetPacking,
    COND_NewAvoidGoal,
    COND_TargetVisible,
    COND_TargetNotVisible,
    COND_InRangeLOS,
    COND_CrouchingLOSToTarget,
    COND_NoCrouchingLOSToTarget,
    COND_StandingLOSToTarget,
    COND_NoStandingLOSToTarget,
    COND_ProneLOSToTarget,
    COND_NoProneLOSToTarget,
    COND_CrouchingCover,
    COND_NoCrouchingCover,
    COND_StandingCover,
    COND_NoStandingCover,
    COND_RollForwardClear,
    COND_RollLeftClear,
    COND_RollRightClear,
    COND_Guarding,
    COND_NotGuarding,
    COND_GuardingActor,
    COND_GuardingPos,
    COND_InGuardRange,
    COND_NotInGuardRange,
    COND_InGuardMaxPursuitRange,
    COND_NotInGuardMaxPursuitRange,
    COND_ShouldDrawWeapon,
    COND_ShouldStepAside,
    COND_TargetInGuardMaxPursuitRange,
    COND_TargetNotInGuardMaxPursuitRange,
    COND_ValidTKObj,
    COND_NoTKObj,
    COND_TKFailed,
    COND_InChargeRange,
    COND_ClearPathToTarget,
    COND_NoClearPathToTarget,
    COND_Swimming,
    COND_TargetShrunk,
    COND_NoShrunkTarget,
    COND_NotInStompVertRange,
    COND_TargetIsTargetingMe,
    COND_ClearChargePath,
    COND_SemiClearShot,
    COND_OnValidNAV,
    COND_InStompRange,
    COND_TargetInStrTap,
    COND_ClearShotFromWeapon,
    COND_SemiClearShotFromWeapon,
    COND_ClearProjectileShot,
    COND_FrozenTarget,
    COND_NoFrozenTarget
};

enum EAIFocus
{
    AIFOCUS_None,
    AIFOCUS_Pos,
    AIFOCUS_ReciprocalPos,
    AIFOCUS_Actor,
    AIFOCUS_ActorFullBody
};

enum EAITargetStackOp
{
    AITARGETSTACKOP_Set,
    AITARGETSTACKOP_ClearAllAndSet,
    AITARGETSTACKOP_Clear,
    AITARGETSTACKOP_ClearAll
};

enum EAIOffsetType
{
    AIOFFSETTTYPE_None,
    AIOFFSETTTYPE_Horiz,
    AIOFFSETTTYPE_3D,
    AIOFFSETTTYPE_Targets_Horiz,
    AIOFFSETTTYPE_Targets_3D,
    AIOFFSETTTYPE_RelTargetsDir_Horiz,
    AIOFFSETTTYPE_RelTargetsDir_3D,
    AIOFFSETTTYPE_RelDirToTarget_Horiz,
    AIOFFSETTTYPE_RelDirToTarget_3D,
    AIOFFSETTTYPE_RelDirToPrimaryTarget_Horiz
};

enum EAIMoveSpeed
{
    AIMOVESPEED_Stop,
    AIMOVESPEED_Walk,
    AIMOVESPEED_Run
};

enum EAIGotoXMode
{
    GOTOX_Mode_None,
    GOTOX_Mode_Move,
    GOTOX_Mode_MoveBackwards,
    GOTOX_Mode_Turn,
    GOTOX_Mode_StepLeft,
    GOTOX_Mode_StepRight,
    GOTOX_Mode_WaitDoor,
    GOTOX_Mode_OpenDoor,
    GOTOX_Mode_Jump,
    GOTOX_Mode_Fall,
    GOTOX_Mode_Land,
    GOTOX_Mode_Hurl,
    GOTOX_Mode_WaitPath,
    GOTOX_Mode_Done
};

enum EAIJumpType
{
    JUMP_Default,
    JUMP_Physics
};

enum EAIJumpAttackType
{
    JUMPATTACK_NoAnim,
    JUMPATTACK_SingleAnim,
    JUMPATTACK_MultiAnim
};

enum EAIDodgeType
{
    DODGETYPE_Physics,
    DODGETYPE_SingleAnim
};

enum EAIFlyToXMode
{
    FLYTOX_Mode_None,
    FLYTOX_Mode_Takeoff,
    FLYTOX_Mode_Fly,
    FLYTOX_Mode_LandStart,
    FLYTOX_Mode_LandLoop,
    FLYTOX_Mode_LandEnd
};

enum EAIFreeMoveMode
{
    FREEMOVE_CircleStrafe,
    FREEMOVE_Flank,
    FREEMOVE_Float,
    FREEMOVE_Charge,
    FREEMOVE_Hover,
    FREEMOVE_Goto,
    FREEMOVE_Stop
};

enum EAIChargeState
{
    CHARGESTATE_Charging,
    CHARGESTATE_FollowThrough,
    CHARGESTATE_Cooldown
};

enum EAIAim
{
    AIAIM_Off,
    AIAIM_On
};

enum EAITargetEval
{
    AITARGETEVAL_None,
    AITARGETEVAL_WeaponStandard,
    AITARGETEVAL_LookStandard,
    AITARGETEVAL_Rat,
    AITARGETEVAL_ScriptBase
};

enum EAIInstigatorType
{
    AIINSTIGATORTYPE_None,
    AIINSTIGATORTYPE_Any,
    AIINSTIGATORTYPE_Player,
    AIINSTIGATORTYPE_Enemy,
    AIINSTIGATORTYPE_Friend,
    AIINSTIGATORTYPE_ExplicitTag
};

enum EAIAnimXType
{
    AIANIMXTYPE_Default,
    AIANIMXTYPE_Full,
    AIANIMXTYPE_FaceActor,
    AIANIMXTYPE_FacePos
};

enum EAICloaking
{
    AICLOAKING_NotCloaked,
    AICLOAKING_Cloaking,
    AICLOAKING_Cloaked,
    AICLOAKING_DeCloaking
};

enum EAIAccuracy
{
    AIACCURACY_VeryPoor,
    AIACCURACY_Poor,
    AIACCURACY_Average,
    AIACCURACY_Good,
    AIACCURACY_VeryGood,
    AIACCURACY_Excellent
};

enum EAILogType
{
    AILOG_Error,
    AILOG_Decision
};

enum EAIScriptState
{
    AISCR_Finished,
    AISCR_Latent
};

enum EScriptState
{
    SCRIPTSTATE_Transient,
    SCRIPTSTATE_Latent,
    SCRIPTSTATE_End
};

enum EAIGroup
{
    AIGROUP_All,
    AIGROUP_Good,
    AIGROUP_Evil
};

enum EAIMessageType
{
    AIMSG_Help,
    AIMSG_WitnessAttack
};

enum EAIInventory
{
    AIINVEN_None,
    AIINVEN_Flashlight,
    AIINVEN_BookSigning,
    AIINVEN_Jetpack
};

enum EAIMount
{
    AIMOUNT_Default,
    AIMOUNT_Yes,
    AIMOUNT_No
};

enum EAIInputAction
{
    AIINPUTACTION_Press,
    AIINPUTACTION_Release,
    AIINPUTACTION_Hold,
    AIINPUTACTION_Tap
};

enum EAIExecutive
{
    AIEXECUTIVE_None,
    AIEXECUTIVE_ScriptExec,
    AIEXECUTIVE_DecisionTree,
    AIEXECUTIVE_AIDebugger
};

enum EAITargetType
{
    AITARGETTYPE_None,
    AITARGETTYPE_Pos,
    AITARGETTYPE_Actor,
    AITARGETTYPE_Primary
};

enum EAITarget
{
    AITARGET_Primary,
    AITARGET_Follow
};

enum EAIAnimController
{
    AIANIMCON_None,
    AIANIMCON_Normal,
    AIANIMCON_Crouch,
    AIANIMCON_Prone,
    AIANIMCON_Search,
    AIANIMCON_Combat,
    AIANIMCON_Wounded,
    AIANIMCON_Swim,
    AIANIMCON_Jetpack,
    AIANIMCON_Scared,
    AIANIMCON_Blind
};

enum EAIGoalType
{
    AIGOALTYPE_Cover,
    AIGOALTYPE_StandingCover,
    AIGOALTYPE_ActionPoint,
    AIGOALTYPE_ActionPointClosestFlyer,
    AIGOALTYPE_ActionPointClosestUsable,
    AIGOALTYPE_ActionPointClosestJumpable,
    AIGOALTYPE_ActionPointReload,
    AIGOALTYPE_ActionPointTeleport,
    AIGOALTYPE_WeaponRange,
    AIGOALTYPE_WeaponRangeAir,
    AIGOALTYPE_WeaponRangeAir_AssaultCommander,
    AIGOALTYPE_WeaponRangeRear,
    AIGOALTYPE_Land,
    AIGOALTYPE_Avoid,
    AIGOALTYPE_AvoidDanger,
    AIGOALTYPE_MoveAround,
    AIGOALTYPE_BackOff,
    AIGOALTYPE_MoveSide,
    AIGOALTYPE_AssaultCommander_Advance,
    AIGOALTYPE_GuardPos,
    AIGOALTYPE_StepAside,
    AIGOALTYPE_Vehicle,
    AIGOALTYPE_ActionPointClosestTarget
};

enum EAIAttackConstraint
{
    ATTACKCONSTRAINT_None,
    ATTACKCONSTRAINT_Melee,
    ATTACKCONSTRAINT_Ranged,
    ATTACKCONSTRAINT_Bezerk,
    ATTACKCONSTRAINT_PipeBomb
};

enum EAIPopUpType
{
    AIPOPUP_Left,
    AIPOPUP_Right,
    AIPOPUP_Crouch,
    AIPOPUP_CrouchLeft,
    AIPOPUP_CrouchRight,
    AIPOPUP_PeekLeft,
    AIPOPUP_PeekRight,
    AIPOPUP_PeekCrouch,
    AIPOPUP_PeekCrouchLeft,
    AIPOPUP_PeekCrouchRight,
    AIPOPUP_WaitLeft,
    AIPOPUP_WaitRight,
    AIPOPUP_CrouchWaitLeft,
    AIPOPUP_CrouchWaitRight,
    AIPOPUP_StandFire,
    AIPOPUP_CrouchFire,
    AIPOPUP_ProneFire,
    AIPOPUP_Vault
};

enum EAIPopUpSelectionMethod
{
    AIPOPUPSEL_Default,
    AIPOPUPSEL_RoundRobin,
    AIPOPUPSEL_Random,
    AIPOPUPSEL_User
};

struct SInstigatorInfo
{
    var() BaseAI.EAIInstigatorType Type;
    var() name Tag;
};

struct SAbortScriptMotive_SeeActor
{
    var() bool Aborts;
    var() float MaxRangeVisible;
    var() float MaxRangeProximity;
    var() bool bDebug;
    var() SInstigatorInfo InstigatorInfo;
    var float DotVisible;
};

struct SAbortScriptMotive_HearSound
{
    var() bool Aborts;
    var() SInstigatorInfo InstigatorInfo;
};

struct SAbortScriptMotive_Damaged
{
    var() bool Aborts;
    var() SInstigatorInfo InstigatorInfo;
    var int DamageCount;
    var() int Threshold;
};

struct SAbortScriptMotive_Bumped
{
    var() bool Aborts;
    var() SInstigatorInfo InstigatorInfo;
};

struct SAbortScriptMotive_Triggered
{
    var() bool Aborts;
    var() SInstigatorInfo InstigatorInfo;
};

struct SAbortScriptMotive_Shrunk
{
    var() bool Aborts;
};

struct SJumpPreset
{
    var Vector JumpVel;
    var float HeavyLandingThresh;
    var Actor FocusActor;
    var float GravityScale;
    var float JumpTime;
    var bool FlyToTarget;
    var Vector TargetPos;
    var int JumpType;
    var bool bSnapToTarget;
    var bool bUseAccelaration;
    var float DefGravityScale;
    var bool bFaceTarget;
};

var(AIBehavior) float ChanceFly;
var(AIDebug) noexport bool DebugTicking "Enable debugging of ticking?";
var(AIDebug) noexport bool DebugWeaponAimer "Enable debugging of weapon aiming?";
var(AIDebug) noexport bool DebugHeadAimer "Enable debugging of head aiming?";
var(AIDebug) noexport bool DebugEyeAimer "Enable debugging of eye aiming?";
var(AIDebug) noexport bool DebugExecutive "Enable debugging of the Executive? (Force enables DebugDecisionTree and DebugScriptExec)";
var(AIDebug) noexport bool DebugOpChanges "Enable debugging of Op Changes";
var(AIDebug) noexport bool DebugDecisionTree "Enable debugging of the Decition Tree?";
var(AIDebug) noexport bool DebugScriptExec "Enable debugging of the Script Executive?";
var(AIDebug) noexport bool DebugTarget "Enable debugging of the TargetInf?";
var(AIDebug) noexport bool DebugWeaponTargetEval "Enable debugging of Weapon Target Evaluation?";
var(AIDebug) noexport bool DebugLookTargetEval "Enable debugging of Look Target Evaluation?";
var(AIDebug) noexport bool DebugHeardSound "Enable debugging of aural senses.";
var(AIDebug) noexport bool DebugGoalSelection "Enable debugging of Goal Selection?";
var(AIDebug) noexport bool DebugGotoX "Enable debugging of GotoX State?";
var(AIDebug) noexport bool DebugCloaking "Enable debugging of Cloaking?";
var(AIDebug) noexport bool DebugPipeBombs "Enable debugging of Pipebombs?";
var(AIDebug) noexport bool DebugDangerEvaluation "Enable debugging of Danger evaluation?";
var(AIDebug) noexport bool DebugTK "Enable debugging of telekinesis?";
var(AIDebug) noexport bool DebugRolls "Enable debugging of Rolls?";
var(AIDebug) noexport bool DebugProps "Enable debugging of Props (Carry/Throw/Hurl)?";
var(AIDebug) noexport bool DebugLOSChecks "Enable debugging of LOS checks?";
var(AIDebug) noexport bool DebugContracts "Enable debugging of Contracts?";
var(AIDebug) noexport bool DebugGuarding "Enable debugging of Guarding?";
var(AIDebug) noexport bool DebugRange "Enable Range debug drawing? (0 is at edge of collision radius)";
var(AIDebug) noexport bool DebugDist "Enable Distance debug drawing? (0 is at exact location - does not take collision radius into account)";
var(AIDebug) noexport bool DebugTrail "Enable Trails debug drawing?";
var(AIDebug) noexport bool DebugDrawExec "Enable Executive debug drawing?";
var(AIDebug) noexport bool DebugActionPoints "Enable debugging of Action Points?";
var(AIDebug) noexport bool DebugRelations "Enable debugging of Relations?";
var(AIDebug) noexport bool DebugHate "Enable debugging of Hate?";
var(AIDebug) noexport bool DebugLedges "Enable debugging of Ledges";
var(AIDebug) noexport bool DebugHealth "Enable debugging of Health?";
var(AIDebug) noexport bool DebugDrawActionPoints "Enable drawing of action points?";
var(AIDebug) noexport bool DebugDrawCollision "Enable drawing of collision cylinder?";
var(AIDebug) noexport bool DebugDrawFOV "Enable drawing of Field of View?";
var(AIDebug) noexport bool DebugStateGotoX "Enable debugging in the GotoX State?";
var(AIDebug) noexport bool DebugStateTurnToX "Enable debugging of GotoX State?";
var(AIDebug) noexport bool DebugWeaponManager "Enable debugging for weapon manager";
var(AIDebug) noexport bool DebugStateAnimX "Enable debugging for animx state";
var(AIDebug) noexport bool DebugDoors "Enable debugging for door usage";
var(AIDebug) noexport bool DebugPain "Enable DebugPain";
var(AIDebug) int PathingHistoryMaxSize;
var(AIDebug) array<name> DrawDebugBones;
var Vector CurrentMoveDelta;

function ToggleAILog()
{
    return;
}

function JumpToGotoXHistory(int i)
{
    return;
}

function OnInviteAccepted()
{
    return;
}

event bool ShouldOpenDoor(DoorMoverEx Door)
{
    return false;
    return;
}
