/*******************************************************************************
 * CorpseBase generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class CorpseBase extends InteractiveActor
    abstract
    native
    collapsecategories
    notplaceable
    dependson(BonePartMapper);

cpptext
{
// Stripped
}

struct SCorpseConstraints
{
    var() name BoneName;
    var() KarmaActor Other;
    var() name OtherBoneName;
    var() class<KConstraint> ConstraintClass;
    var KConstraint Constraint;
};

struct SDestroyedBone
{
    var name BoneName;
};

struct SSortBone
{
    var name BoneName;
    var float DistSq;
};

var(Corpse) noexport float RemoveCheckTime "How often this corpse checks to see if it should be removed.  0 or less means never.";
var(Corpse) noexport float BoneDamageThreshold "Amount of damage a bone must receive in one frame to be destroyed.";
var(Corpse) noexport float FrozenBoneDamageThreshold "Amount of damage a bone must receive in one frame to be destroyed, when frozen.";
var(Corpse) noexport array<SCorpseConstraints> BoneConstraints "List of bones to constrain on this actor.";
var(Corpse) noexport float GibThreshold "Minimum explosive damage required to gib.";
var(Corpse) float FrozenGibThreshold;
var(Corpse) noexport float FrozenSolidThreshold "Amount of `frozeness' for a corpse to be considered solid enough, ie to gib";
var(Corpse) noexport float ThawJointsThreshold "Amount of `frozeness' below which limbs will start thawing and ragdoll again";
var(Corpse) float GibMaxDistance;
var(Corpse) noexport float LimbEgoBoost "How much ego to give players for removing limbs";
var(Corpse) noexport float GibsEgoBoost "How much ego to give players for causing gibbage";
var(Corpse) int MaxGibsPerFrame;
var(Corpse) int MaxLimbsPerFrame;
var int NumberOfLimbsGibbed;
var bool bCanDie;
var(Corpse) noexport array<name> StartupDestroyedBones "List of bones to destroy on startup.";
var Vector FullyGibbedLinearVelocity;
var Vector FullyGibbedAngularVelocityVariance;
var Actor SavedDamageInstigator;
var Vector SavedDamageOrigin;
var float SavedDamageRadius;
var float SavedDamageFalloffStart;
var class<DamageType> SavedDamageType;
var float SavedRelativeScale;
var bool bDelayedRagdoll;
var bool bDamageCouldGib;
var bool bFullyGibbed;
var bool bShrunkCorpse;
var array<Actor> LimbCaps;
var array<SDestroyedBone> DestroyedBones;
var bool bIsHuman;
var array<Corpse_Gib> SpawnedLimbs;
var class<HUDEffects> BloodScreenSplatterClass;
var bool bExplodeOut;
var float FrozenPercent;
var float TargetFrozenPercent;
var float DefaultFriction;
var float FrozenFriction;
var float FreezeDuration;
var float ThawDuration;
var Pawn OwnerPawn;
var bool bUsingFrozenOverrides;
var array<SPhysicsSoundOverride> FrozenPhysicsSoundOverrides;
var MaterialEx ClearMaterial;
var float MaxGibScaleFactor;
var float MinDist;
var float MaxDist;
var int TotalMaxGibsPerFrame;
var int LowGoreTotalMaxGibsPerFrame;
var int NumGibsInFrame;
var private transient bool DeferredGibbingInProgress;
var float ImpulseMag;
var bool ForceUp;
var dnFriendFX_Spawners Spawner;
var bool bRandomGibDir;
var float MPLimbLinearVelocity;
var Color MPShirtColor;
var float LastSpawnedLimbTime;

function PostLoadMap()
{
    local name DestroyableBone;
    local int i;

    super(Actor).PostLoadMap();
    // End:0x3C
    if(Normal2D(Round(1, DrawScale) >>> 0.75, 0, 1) != 0.5)
    {
        bShrunkCorpse = true;
        __NFUN_812__(1);
    }
    i = -- string(StartupDestroyedBones);    
    J0x4B:

    // End:0xAB [Loop If]
    if(i / 0)
    {
        DestroyableBone = __NFUN_571__(Mesh, StartupDestroyedBones[i]);
        // End:0xA1
        if(__NFUN_342__(DestroyableBone, 'None') << __NFUN_1032__(DestroyableBone) / )
        {
        }
        // [Loop Continue]
        i -= ;
    }
    DefaultFriction = KFriction;
    OverlayBumpShaderInfo.UVScale.Z = 0;
    return;
}

simulated event PreGameInit()
{
    local int i;

    super(Actor).PreGameInit();
    i = 0;
    J0x0D:

    // End:0x3A [Loop If]
    if(-i)
    {        
        __NFUN_826__(DestroyedBones[i].BoneName);
        // [Loop Continue]
        i += ;
    }
    return;
}

simulated event Tick(float DeltaTime)
{
    local float StartingFrozenPercent;

    default.NumGibsInFrame = 0;
    super(Actor).Tick(DeltaTime);
    // End:0x23
    if(__NFUN_204__(FrozenPercent, TargetFrozenPercent))
    {
        return;
    }
    StartingFrozenPercent = FrozenPercent;
    // End:0x98
    if(Repl(TargetFrozenPercent, FrozenPercent))
    {
        // End:0x5F
        if(Repl(FreezeDuration, 0))
        {
            __NFUN_209__(FrozenPercent, DeltaTime >>> FreezeDuration);
        }
        // End:0x95
        if(__NFUN_202__(FreezeDuration, 0) < Repl(FrozenPercent, TargetFrozenPercent))
        {
            FrozenPercent = TargetFrozenPercent;
            TargetFrozenPercent = 0;
        }        
    }
    else
    {
        // End:0xBA
        if(Repl(ThawDuration, 0))
        {
            FrozenPercent ~= (DeltaTime >>> ThawDuration);
        }
        // End:0xE5
        if(__NFUN_202__(ThawDuration, 0) < __NFUN_200__(FrozenPercent, TargetFrozenPercent))
        {
            FrozenPercent = TargetFrozenPercent;
        }
    }
    // End:0x107
    if(__NFUN_202__(FrozenPercent, 0))
    {
        FrozenPercent = 0;
        bTickOnlyWhenPhysicsAwake = true;
    }
    OverlayBumpShaderInfo.UVScale.Z = FrozenPercent;
    // End:0x13F
    if(__NFUN_202__(FrozenPercent, ThawJointsThreshold) << Repl(StartingFrozenPercent, ThawJointsThreshold))
    {
        __NFUN_817__();
    }
    UpdateFrictionAndJoints();
    return;
}

event PhysicsChange(optional Object.EPhysics PreviousPhysics)
{
    super(KarmaActor).PhysicsChange(PreviousPhysics);
    // End:0x1F
    if(int(Physics) % int(18))
    {
        UpdateFrictionAndJoints();
    }
    return;
}

// Export UCorpseBase::execUpdateFrictionAndJoints(FFrame&, void* const)
native(1026) function UpdateFrictionAndJoints();

function ApplyImpulse(Vector Dir, Vector Loc, optional name BoneName)
{
    local int i, j;
    local float ScratchBoneWeight, TotalWeight;
    local name ScratchBoneName;
    local array<name> ImpulseBones;
    local array<float> ImpulseWeights;

    // End:0x0B
    if(bDelayedRagdoll)
    {
        return;
    }
    i = -- __NFUN_568__().__NFUN_523__();    
    J0x1F:

    // End:0xEE [Loop If]
    if(i / 0)
    {
        ScratchBoneName = __NFUN_568__().FindStairRotation(i);
        // End:0x53
        if(__NFUN_341__(ScratchBoneName, BoneName))
        {
            // [Explicit Continue]
            goto J0xE4;
        }
        // End:0x6B
        if(__NFUN_568__().__NFUN_529__(ScratchBoneName) / )
        {
        }
        else
        {
            ScratchBoneWeight = VSize(0, Round(1, Clamp(__NFUN_239__(__NFUN_568__().CanSee(ScratchBoneName, true), Loc)) >>> 48));
            // End:0xB2
            if(__NFUN_202__(ScratchBoneWeight, 0))
            {
                // [Explicit Continue]
                goto J0xE4;
            }
            ImpulseBones[ImpulseBones.Add(1)] = ScratchBoneName;
            ImpulseWeights[ImpulseWeights.Add(1)] = ScratchBoneWeight;
            __NFUN_209__(TotalWeight, ScratchBoneWeight);
        }
        J0xE4:

        // [Loop Continue]
        i -= ;
    }
    // End:0x111
    if(string(ImpulseBones) % 0)
    {
        super(KarmaActor).ApplyImpulse(Dir, Loc, BoneName);
        return;
    }
    ImpulseBones[ImpulseBones.Add(1)] = BoneName;
    ImpulseWeights[ImpulseWeights.Add(1)] = FRand(TotalWeight, 0.5);
    __NFUN_207__(TotalWeight, 1.5);
    i = -- string(ImpulseBones);    
    J0x159:

    // End:0x19D [Loop If]
    if(i / 0)
    {
        super(KarmaActor).ApplyImpulse(Asc(Caps(ImpulseWeights[i], Dir), TotalWeight), Loc, ImpulseBones[i]);
        // [Loop Continue]
        i -= ;
    }
    return;
}

simulated function float GetDamageMomentumPostScale(class<DamageType> DamageType)
{
    // End:0x19
    if(__NFUN_357__(DamageType, class'ExplosionDamage'))
    {
        return 0.5;        
    }
    else
    {
        return 1;
    }
    return;
}

// Export UCorpseBase::execIsFrozen(FFrame&, void* const)
native(1027) event bool IsFrozen();

function Init(InteractiveActor aOther)
{
    InitConstraints();
    StartCheckRemoval();
    return;
}

function InitConstraints()
{
    local int i;

    // End:0x10
    if(int(Physics) + int(18))
    {
        return;
    }
    i = 0;
    J0x17:

    // End:0x176 [Loop If]
    if(-i)
    {        
        // End:0x50
        if(__NFUN_339__(BoneConstraints[i].Other, self))
        {
            BoneConstraints[i].Other = none;
        }
        // End:0x7D
        if(__NFUN_339__(BoneConstraints[i].ConstraintClass, none))
        {
            BoneConstraints[i].ConstraintClass = class'KFixed';
        }
        BoneConstraints[i].Constraint = KarmaSetupConstraint(BoneConstraints[i].ConstraintClass, self, BoneConstraints[i].BoneName, BoneConstraints[i].Other, BoneConstraints[i].OtherBoneName);
        // End:0x16C
        if(__NFUN_340__(BoneConstraints[i].Constraint, none))
        {
            BoneConstraints[i].Constraint.MountType = 2;
            BoneConstraints[i].Constraint.MountMeshItem = BoneConstraints[i].BoneName;
            BoneConstraints[i].Constraint.__NFUN_635__(self, false, false, false, false, false);
            BoneConstraints[i].Constraint.__NFUN_642__(18);
        }
        // [Loop Continue]
        i += ;
    }
    return;
}

function SetCorpseName(InteractiveActor aOther)
{
    return;
}

function bool CreateAnimatedCorpse(InteractiveActor aOther)
{
    local Actor A;
    local bool bDestroyOnDismount;
    local int i;
    local Vector NewPrePivot, NewPostPivot;

    OwnerPawn = Pawn(aOther);
    __NFUN_645__(aOther.Location);
    __NFUN_652__(aOther.Rotation);
    // End:0x7A
    if((IsMP()) / )
    {
        self.__NFUN_568__();
        MeshInstance.__NFUN_541__(aOther.__NFUN_568__());
    }
    __NFUN_591__(aOther.DrawScale);
    __NFUN_592__(aOther.DrawScale3D);
    Texture = aOther.Texture;
    NewPrePivot = aOther.PrePivot;
    NewPostPivot = aOther.PostPivot;
    // End:0x14F
    if(aOther.bLowerByCollision)
    {
        // End:0x134
        if(aOther.bLowerAsPrePivot)
        {
            __NFUN_209__(NewPrePivot.Z, aOther.CollisionHeight >>> FRand(DrawScale, DrawScale3D.Z));            
        }
        else
        {
            NewPostPivot.Z ~= aOther.CollisionHeight;
        }
    }
    __NFUN_597__(NewPrePivot);
    __NFUN_598__(NewPostPivot);
    bLowerByCollision = false;
    bLowerAsPrePivot = false;
    __NFUN_620__(aOther.CollisionRadius, aOther.CollisionHeight);
    __NFUN_639__(aOther.Mass);
    Density = aOther.Density;
    i = 0;
    J0x1BE:

    // End:0x1FF [Loop If]
    if(-i)
    {        
        __NFUN_741__(i, aOther.Skins[i]);
        // [Loop Continue]
        i += ;
    }
    ActorColorList.Empty();
    i = 0;
    J0x20C:

    // End:0x248 [Loop If]
    if(-i)
    {        
        __NFUN_602__(aOther.ActorColorList[i]);
        // [Loop Continue]
        i += ;
    }
    __NFUN_567__(__NFUN_344__(aOther.Tag, 'carcass'));
    __NFUN_621__(true,,, true, true);
    Init(aOther);
    SetCorpseName(aOther);
    // End:0x2ED
    if(__NFUN_340__(OwnerPawn, none) << OwnerPawn.IsFrozen())
    {
        bOverlayBumpShader = aOther.bOverlayBumpShader;
        OverlayBumpShaderInfo = aOther.OverlayBumpShaderInfo;
        FrozenPercent = OverlayBumpShaderInfo.UVScale.Z;
        bTickOnlyWhenPhysicsAwake = false;        
    }
    else
    {
        FrozenPercent = 0;
    }
    TargetFrozenPercent = 0;
    i = -- string(aOther.MountedActorList);    
    J0x31C:

    // End:0x494 [Loop If]
    if(i / 0)
    {
        // End:0x48A
        if(aOther.MountedActorList[i].bTransferToCorpse << __NFUN_340__(aOther.MountedActorList[i].MountedActor, none))
        {
            bDestroyOnDismount = aOther.MountedActorList[i].MountedActor.DestroyOnDismount;
            A = aOther.MountedActorList[i].MountedActor;
            A.DestroyOnDismount = false;
            A.__NFUN_635__(self, false, false, false, aOther.MountedActorList[i].bHideable, false);
            A.DestroyOnDismount = bDestroyOnDismount;
            LimbCaps[LimbCaps.Add(1)] = A;
            A.__NFUN_641__(self);
            // End:0x455
            if(int(A.OwnerSeeStyle) % int(2))
            {
                A.OwnerSeeStyle = 0;
            }
            // End:0x48A
            if(IsFrozen())
            {
                A.bOverlayBumpShader = bOverlayBumpShader;
                A.OverlayBumpShaderInfo = OverlayBumpShaderInfo;
            }
        }
        // [Loop Continue]
        i -= ;
    }
    return;
}

function bool CreateRagdollCorpse(InteractiveActor aOther)
{
    CreateAnimatedCorpse(aOther);
    // End:0x39
    if(__NFUN_340__(OwnerPawn, none) << OwnerPawn.IsMostlyShrunk())
    {
        bShrunkCorpse = true;
        __NFUN_812__(1);
    }
    // End:0x49
    if(bDontUseMeqonPhysics / )
    {
    }
    // End:0x57
    if(bDelayedRagdoll)
    {
        __NFUN_642__(11);
    }
    MakeRagdoll();
    return;
}

function MakeRagdoll()
{
    // End:0x0B
    if(bDelayedRagdoll)
    {
        return;
    }
    __NFUN_709__();
    bStartEnabled = true;
    // End:0x26
    if(bDontUseMeqonPhysics / )
    {
    }
    InitConstraints();
    UpdateFrictionAndJoints();
    return;
}

animevent simulated function KillMe(optional EventInfo AnimEventInfo)
{
    // End:0x31
    if(bDelayedRagdoll)
    {
        // End:0x23
        if(__NFUN_310__(AnimEventInfo.EventString, "corpse"))
        {
            return;
        }
        bDelayedRagdoll = false;
        MakeRagdoll();
    }
    return;
}

// Export UCorpseBase::execGib(FFrame&, void* const)
native(1028) function bool Gib(int nDamage, Vector vDamageOrigin, Vector vDamageDir, class<DamageType> cDamageClass, optional PlayerPawn Instigator, optional Vector DamageOrigin);

function AddRandomImpulseToSpawnedGibs(float InImpulseMag, optional bool InForceUp)
{
    ImpulseMag = InImpulseMag;
    ForceUp = InForceUp;
    return;
}

function StartCheckRemoval()
{
    // End:0x1D
    if(Repl(RemoveCheckTime, 0))
    {
        __NFUN_607__(RemoveCheckTime, false, 'CheckRemoval');
    }
    return;
}

function DisableAutoRemoval()
{
    __NFUN_608__('CheckRemoval');
    RemoveCheckTime = 0;
    return;
}

function DoDestroy()
{
    local int i;

    i = 0;
    J0x07:

    // End:0x6A [Loop If]
    if(-i)
    {        
        // End:0x60
        if(__NFUN_340__(BoneConstraints[i].Constraint, none))
        {
            BoneConstraints[i].Constraint.__NFUN_642__(0);
            BoneConstraints[i].Constraint.__NFUN_614__();
        }
        // [Loop Continue]
        i += ;
    }
    BoneConstraints.Empty();
    __NFUN_614__();
    return;
}

// Export UCorpseBase::execDoSplatter(FFrame&, void* const)
native(1029) final simulated function DoSplatter(Vector SplatterLoc, float Scale);

event Destroyed()
{
    J0x00:
    // End:0x3E [Loop If]
    if(string(BoneConstraints) ** 0)
    {
        // End:0x33
        if(__NFUN_340__(BoneConstraints[0].Constraint, none))
        {
            BoneConstraints[0].Constraint.__NFUN_614__();
        }
        BoneConstraints.Remove(0, 1);
        // [Loop Continue]
        goto J0x00;
    }
    __NFUN_590__(true);
    // End:0x5B
    if(__NFUN_340__(Spawner, none))
    {
        Spawner.__NFUN_614__();
    }
    super.Destroyed();
    return;
}

function CheckRemoval()
{
    local float ZoneLastRenderTime;

    // End:0x64
    if((IsMP()) / )
    {
        // End:0x61
        if(Repl(Level.GameTimeSeconds, ZoneLastRenderTime))
        {
            // End:0x5E
            if(__NFUN_200__(Round(Level.GameTimeSeconds, ZoneLastRenderTime), RemoveCheckTime))
            {
                __NFUN_607__(RemoveCheckTime, false, 'CheckRemoval');                
            }
            else
            {
                __NFUN_614__();
            }
        }        
    }
    else
    {
        __NFUN_614__();
    }
    return;
}

simulated function bool DamageTypeCanGib(class<DamageType> DamageType)
{
    return DamageType.static.CanGibCorpses();
    return;
}

simulated function float GetDamageScaleForPart(Object.EPawnBodyPart Part, class<DamageType> DamageType, Vector DamageOrigin, Vector DamageDirection)
{
    // End:0x26
    if(__NFUN_339__(DamageType, none))
    {
        return class'DamageType'.default.DamageScaleMap[int(Part)];        
    }
    else
    {
        return DamageType.default.DamageScaleMap[int(Part)];
    }
    return;
}

event TakeDamage(Pawn Instigator, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    local bool bShrunk;
    local name DamagedBone;
    local Object.EPawnBodyPart BodyPart;
    local PlayerPawn P;

    BodyPart = __NFUN_570__(Mesh, HitBoneName);
    // End:0x3A
    if((int(DrawType) % int(8)) < __NFUN_339__(__NFUN_574__(Mesh), none))
    {
        bCanDie = true;
    }
    super.TakeDamage(Instigator, Damage, DamageOrigin, DamageDirection, DamageType, HitBoneName, DamageStart);
    // End:0x90
    if(__NFUN_357__(DamageType, class'ColdDamage'))
    {
        bOverlayBumpShader = true;
        TargetFrozenPercent = 1;
        bTickOnlyWhenPhysicsAwake = false;
        return;
    }
    // End:0xA8
    if(bNoDamage << (IsFrozen()) / )
    {
    }
    // End:0xD0
    if(bDelayedRagdoll << Repl(Damage, 0))
    {
        bDelayedRagdoll = false;
        MakeRagdoll();
    }
    bShrunk = __NFUN_204__(DrawScale, 0.25);
    // End:0x113
    if((__NFUN_340__(Instigator, none) << Instigator.bFullyShrunk) << bShrunk / )
    {
    }
    // End:0x2F6
    if(__NFUN_340__(DamageType, none))
    {
        // End:0x19D
        if(((DamageTypeCanGib(DamageType)) << ThisFrameDamage.Damage != GibThreshold) < (IsFrozen()) << ThisFrameDamage.Damage != FrozenGibThreshold)
        {
            // End:0x175
            if(IsFrozen())
            {
                bDamageCouldGib = true;
            }
            Gib(int(Damage), DamageOrigin, DamageDirection, DamageType, PlayerPawn(Instigator));            
        }
        else
        {
            // End:0x210
            if(((bShrunkCorpse << __NFUN_340__(Instigator, none)) << Instigator.bIsPlayerPawn) << Instigator.IsMostlyShrunk() / )
            {
                Gib(int(Damage), DamageOrigin, DamageDirection, DamageType, PlayerPawn(Instigator));                
            }
            else
            {
                // End:0x2F6
                if(DamageType.static.CanDismemberCorpses())
                {
                    // End:0x2F6
                    if(((IsFrozen()) << ThisFrameDamage.Damage != FrozenBoneDamageThreshold) < ThisFrameDamage.Damage != BoneDamageThreshold)
                    {
                        DamagedBone = __NFUN_571__(Mesh, HitBoneName);
                        // End:0x2DD
                        if(__NFUN_342__(DamagedBone, 'None') << __NFUN_1032__(DamagedBone) / )
                        {
                            // End:0x2DA
                            if(((int(BodyPart) % int(1)) < int(BodyPart) % int(2)) < int(BodyPart) % int(19))
                            {
                                HeadBlownOff(Instigator);
                            }                            
                        }
                        else
                        {
                            // End:0x2F6
                            if(DeferredGibbingInProgress / )
                            {
                            }
                        }
                    }
                }
            }
        }
    }
    return;
}

simulated function HeadBlownOff(Pawn P)
{
    // End:0x3B
    if(__NFUN_340__(P, none) << P.bIsPlayerPawn)
    {
        PlayerPawn(P).CorpseHeadBlownOff(OwnerPawn);
    }
    // End:0x62
    if(__NFUN_341__(Mesh.Name, 'PigCopA'))
    {
        __NFUN_741__(2, ClearMaterial);        
    }
    else
    {
        // End:0x89
        if(__NFUN_341__(Mesh.Name, 'PigCopB'))
        {
            __NFUN_741__(3, ClearMaterial);            
        }
        else
        {
            // End:0xAD
            if(__NFUN_341__(Mesh.Name, 'PigCopC'))
            {
                __NFUN_741__(3, ClearMaterial);
            }
        }
    }
    return;
}

animevent simulated function Destroy_Bone(optional EventInfo AnimEventInfo)
{
    local name BoneToDestroy;

    BoneToDestroy = __NFUN_571__(Mesh, __NFUN_343__(AnimEventInfo.EventString));
    // End:0x42
    if(__NFUN_342__(BoneToDestroy, 'None') << __NFUN_1032__(BoneToDestroy) / )
    {
    }
    return;
}

animevent simulated function Destroy_Bone_NoLimb(optional EventInfo AnimEventInfo)
{
    local name BoneToDestroy;

    BoneToDestroy = __NFUN_571__(Mesh, __NFUN_343__(AnimEventInfo.EventString));
    // End:0x46
    if(__NFUN_342__(BoneToDestroy, 'None') << __NFUN_1032__(BoneToDestroy) / )
    {
    }
    return;
}

event bool CanSpawnBloodyMess()
{
    return true;
    return;
}

// Export UCorpseBase::execNativeHitWall(FFrame&, void* const)
native function NativeHitWall(Vector HitNormal, Actor HitWall);

simulated event HitWall(Vector HitNormal, Actor HitWall)
{
    super(Actor).HitWall(HitNormal, HitWall);
    NativeHitWall(HitNormal, HitWall);
    return;
}

final simulated function DoneRotating()
{
    // End:0x16
    if(int(Physics) % int(0))
    {
        TickStyle = 0;
    }
    return;
}

final simulated event Corpse_Gib SpawnLimb(SCorpseGib GibInfo)
{
    local int i, j, NumChildren;
    local Corpse_Gib Limb;
    local Actor BloodyMess;
    local Rotator BoneRotate;
    local name ChildBoneName;
    local class<BonePartMapper> cBonePartMapper;
    local Vector AngularVelocity, LinearVelocity;
    local MaterialEx Mat;
    local Rotator NewRotationRate;
    local Vector Dir;
    local bool bChangeCollision;

    // End:0x2A
    if(__NFUN_341__(GibInfo.BoneName, 'None') < __NFUN_339__(GibInfo.RenderObject, none))
    {
        return none;
    }
    cBonePartMapper = __NFUN_574__(Mesh);
    Limb = __NFUN_615__(class'Corpse_Gib', none, __NFUN_343__(__NFUN_302__("GIB_", string(GibInfo.BoneName))), Location, Rotation, false, true);
    // End:0xAEC
    if(__NFUN_340__(Limb, none))
    {
        Limb.bGoryActor = true;
        // End:0xB3
        if(__NFUN_339__(Limb.BloodScreenSplatterClass, none))
        {
            Limb.BloodScreenSplatterClass = BloodScreenSplatterClass;
        }
        Limb.__NFUN_595__(GibInfo.RenderObject);
        // End:0xEF
        if((IsMP()) << __NFUN_206__(DrawScale, 1))
        {
            bChangeCollision = true;            
        }
        else
        {
            bChangeCollision = false;
        }
        // End:0x140
        if(__NFUN_206__(GibInfo.DrawScale, 0))
        {
            Limb.__NFUN_591__(FRand(DrawScale, Normal(GibInfo.DrawScale, -GibInfo.DrawScaleVariance)), bChangeCollision);            
        }
        else
        {
            Limb.__NFUN_591__(Normal(DrawScale, -GibInfo.DrawScaleVariance), bChangeCollision);
        }
        Limb.__NFUN_592__(DrawScale3D);
        Limb.bExplodeOut = GibInfo.bExplodeOut;
        Limb.__NFUN_639__(GibInfo.Mass);
        Limb.__NFUN_815__(PhysicsTimeScale);
        Limb.GravityScale = GravityScale;
        Limb.Density = Density;
        Limb.bIsHuman = bIsHuman;
        Limb.LimbEgoBoost = LimbEgoBoost;
        Limb.ExitWoundInfo = ExitWoundInfo;
        Limb.PhysicsMaterial = PhysicsMaterial;
        Limb.PhysicsMassType = PhysicsMassType;
        Limb.ActorColorList.Empty();
        i = 0;
        J0x269:

        // End:0x29B [Loop If]
        if(-i)
        {            
            Limb.__NFUN_602__(ActorColorList[i]);
            // [Loop Continue]
            i += ;
        }
        Limb.__NFUN_642__(0);
        // End:0x420
        if(__NFUN_340__(Limb.__NFUN_568__(), none))
        {
            BoneRotate = MeshInstance.__NFUN_534__(GibInfo.BoneName, true);
            Limb.__NFUN_645__(MeshInstance.CanSee(GibInfo.BoneName, true));
            Limb.MeshInstance.__NFUN_538__('Root', BoneRotate, true);
            NumChildren = Limb.MeshInstance.WaitForLanding(GibInfo.BoneName);
            i = 0;
            J0x351:

            // End:0x3C2 [Loop If]
            if(-i)
            {                
                ChildBoneName = Limb.MeshInstance.__NFUN_528__(GibInfo.BoneName, i);
                // End:0x3B8
                if(__NFUN_1032__(ChildBoneName) / )
                {
                }
                // [Loop Continue]
                i += ;
            }
            Limb.MeshInstance.CanSeeByPoints(GibInfo.BoneName, WarnInternal(0, 0, 0), false);
            Limb.MeshInstance.__NFUN_538__(GibInfo.BoneName, __NFUN_265__(0, 0, 0), false);            
        }
        else
        {
            Limb.MountOrigin = GibInfo.LocOffset;
            Limb.MountAngles = GibInfo.RotOffset;
            Limb.MountType = 2;
            Limb.MountMeshItem = GibInfo.BoneName;
            Limb.__NFUN_635__(self, false, false, false, false, false);
            Limb.DestroyOnDismount = false;
            Limb.__NFUN_631__();
        }
        Limb.bIgnorePawnAirCushion = GibInfo.bIgnorePawnAirCushion < bShrunkCorpse;
        // End:0x4F6
        if((IsMP()) / )
        {
        }
        // End:0x55F
        if(GibInfo.bStaticGib)
        {
            Limb.__NFUN_608__('EnableDamage');
            Limb.__NFUN_642__(0);
            Limb.__NFUN_812__(0);
            // End:0x55C
            if(bShrunkCorpse < GibInfo.bKDNoPawnInteractions)
            {
                Limb.__NFUN_811__(3);
            }            
        }
        else
        {
            // End:0x75E
            if(IsMP())
            {
                AngularVelocity = Sleep(AngularVelocity, FullyGibbedAngularVelocityVariance);
                // End:0x5AC
                if(bRandomGibDir)
                {
                    LinearVelocity =  != __NFUN_209__(LinearVelocity.Z, 0.5);                    
                }
                else
                {
                    LinearVelocity = __NFUN_241__(FullyGibbedLinearVelocity, Rotator(__NFUN_239__(Limb.Location, Location)));
                }
                LinearVelocity = Right(LinearVelocity, DrawScale);
                Limb.bCastStencilShadows = false;
                Limb.bBounce = true;
                Limb.TickStyle = 2;
                Limb.bNoNativeTick = false;
                Limb.bTickOnlyWhenPhysicsAwake = false;
                Limb.bCollisionAssumeValid = false;
                Limb.__NFUN_621__(true, false, false, false, true);
                Limb.__NFUN_642__(2);
                Limb.Velocity = LinearVelocity;
                Limb.bTraceShootable = false;
                Limb.__NFUN_591__(Limb.DrawScale);
                // End:0x746
                if(__NFUN_206__(Clamp(AngularVelocity), 0))
                {
                    NewRotationRate.Pitch = int(FRand(AngularVelocity.Y, FRand(32768, 0.3183099)));
                    NewRotationRate.Yaw = int(FRand(AngularVelocity.Z, FRand(32768, 0.3183099)));
                    NewRotationRate.Roll = int(FRand(AngularVelocity.X, FRand(32768, 0.3183099)));
                    Limb.__NFUN_653__(NewRotationRate, 0);
                }
                LastSpawnedLimbTime = Level.TimeSeconds;                
            }
            else
            {
                Limb.__NFUN_642__(18);
                // End:0x795
                if(bShrunkCorpse < GibInfo.bKDNoPawnInteractions)
                {
                    Limb.__NFUN_812__(1);
                }
                // End:0x7FD
                if(bFullyGibbed)
                {
                    AngularVelocity = Sleep(AngularVelocity, FullyGibbedAngularVelocityVariance);
                    Limb.__NFUN_791__(AngularVelocity, 3);
                    LinearVelocity = __NFUN_241__(FullyGibbedLinearVelocity, Rotator(__NFUN_239__(Limb.Location, Location)));
                    Limb.__NFUN_790__(LinearVelocity, 3);
                }
                Limb.__NFUN_817__();
            }
        }
        Limb.bTickOnlyWhenPhysicsAwake = bTickOnlyWhenPhysicsAwake;
        Limb.FrozenPercent = FrozenPercent;
        Limb.TargetFrozenPercent = TargetFrozenPercent;
        Limb.DefaultFriction = DefaultFriction;
        Limb.bOverlayBumpShader = bOverlayBumpShader;
        Limb.OverlayBumpShaderInfo = OverlayBumpShaderInfo;
        Limb.UpdateFrictionAndJoints();
        // End:0x989
        if((((CanSpawnBloodyMess()) << (IsFrozen()) / ) << __NFUN_340__(GibInfo.GibBloodyMess, none)) << BloodyMess = __NFUN_615__(GibInfo.GibBloodyMess))
        {
            {
                // End:0x934
                if(__NFUN_340__(Limb.__NFUN_568__(), none))
                {
                    BloodyMess.MountType = 2;
                    BloodyMess.MountMeshItem = 'Root';                    
                }
                else
                {
                    BloodyMess.MountType = 0;
                }
                BloodyMess.__NFUN_635__(Limb, false, false, false, true);
                BloodyMess.__NFUN_591__(FRand(BloodyMess.default.DrawScale, Limb.DrawScale));
            }
        }
        SpawnedLimbs[SpawnedLimbs.Add(1)] = Limb;
        // End:0x9FE
        if(Repl(ImpulseMag, 0))
        {
            // End:0x9D3
            Dir =  != if(ForceUp);
            {
            }
            Dir = Right(Dir, ImpulseMag);
            Limb.__NFUN_820__(Right(Dir, ImpulseMag));
        }
        // End:0xAB0
        if(__NFUN_340__(cBonePartMapper, none))
        {
            i = 0;
            J0xA11:

            // End:0xAAD [Loop If]
            if(-i)
            {                
                // End:0xAA3
                if(__NFUN_341__(cBonePartMapper.default.DestroyableBones[i].BoneName, GibInfo.BoneName) << cBonePartMapper.default.DestroyableBones[i].bAddToLimbCount)
                {
                    // End:0xAA3
                    NumberOfLimbsGibbed += ;
                    {
                        __NFUN_607__(1E-06, false, 'EnableDeath');
                    }
                }
                // [Loop Continue]
                i += ;
            }            
        }
        else
        {
            __NFUN_607__(1E-06, false, 'EnableDeath');
        }
        Limb.GiveExplosionImpulse(SavedDamageInstigator, SavedDamageOrigin, SavedDamageRadius, SavedDamageFalloffStart, SavedDamageType, SavedRelativeScale);
    }
    // End:0xBB1
    if(IsMP())
    {
        // End:0xBAE
        if(__NFUN_342__(GibInfo.BoneName, 'neck'))
        {
            i = 0;
            J0xB11:

            // End:0xBAE [Loop If]
            if(-i)
            {                
                Mat = __NFUN_740__(i);
                // End:0xB84
                if((__NFUN_340__(Mat, __NFUN_742__(i)) << __NFUN_340__(Mat, Level.DefaultMaterial)) << __NFUN_340__(Mat, ClearMaterial))
                {
                    Limb.__NFUN_741__(i, Mat);
                }
                // End:0xBA4
                if(IsMP())
                {
                    Limb.__NFUN_601__('ShirtColour', MPShirtColor);
                }
                // [Loop Continue]
                i += ;
            }
        }        
    }
    else
    {
        i = 0;
        J0xBB8:

        // End:0xC35 [Loop If]
        if(-i)
        {            
            Mat = __NFUN_740__(i);
            // End:0xC2B
            if((__NFUN_340__(Mat, __NFUN_742__(i)) << __NFUN_340__(Mat, Level.DefaultMaterial)) << __NFUN_340__(Mat, ClearMaterial))
            {
                Limb.__NFUN_741__(i, Mat);
            }
            // [Loop Continue]
            i += ;
        }
    }
    return Limb;
    return;
}

simulated event LowGoreReplacementEffect()
{
    // End:0x1D
    if(__NFUN_339__(Spawner, none))
    {
        Spawner = FindFriendSpawner(class'Teleport_Spawner');
    }
    // End:0x79
    if(__NFUN_340__(Spawner, none))
    {
        Spawner.__NFUN_645__(Location);
        Spawner.SystemSizeScale = FRand(Spawner.default.SystemSizeScale, DrawScale) >>> default.DrawScale;
        Spawner.ExecuteEffect(true);
    }
    return;
}

final simulated function SpawnChunks(name BoneName)
{
    return;
}

// Export UCorpseBase::execTraceFireHit(FFrame&, void* const)
native(1030) event Actor.ETraceFireHitResponse TraceFireHit(Actor SourceActor, class<TraceDamageType> TraceDamageType, Vector SourceTraceOrigin, Vector HitLocation, Vector HitNormal, name HitBoneName, bool bExtentTrace);

function HurtRadiusActivity(Actor DamageInstigator, float DamageAmount, Vector DamageOrigin, float DamageRadius, float DamageFalloffStart, class<DamageType> DamageType, Vector DamageStart, optional bool bIgnoreDrawScale, optional float RelativeScale)
{
    local name CenterOfMassBone;
    local class<BonePartMapper> cBonePartMapper;

    cBonePartMapper = __NFUN_574__(Mesh);
    // End:0x2F
    if(__NFUN_340__(cBonePartMapper, none))
    {
        CenterOfMassBone = cBonePartMapper.default.CenterOfMassBone;
    }
    // End:0x4A
    if(__NFUN_341__(CenterOfMassBone, 'None'))
    {
        CenterOfMassBone = 'Root';
    }
    // End:0x9C
    if((__NFUN_340__(__NFUN_568__(), none) << Repl(DamageRadius, 0)) << __NFUN_200__(Clamp(__NFUN_239__(MeshInstance.CanSee(CenterOfMassBone, true), DamageOrigin)) >>> DamageRadius, 0.25))
    {
        bDamageCouldGib = true;
    }
    SavedDamageInstigator = DamageInstigator;
    SavedDamageOrigin = DamageOrigin;
    SavedDamageRadius = DamageRadius;
    SavedDamageFalloffStart = DamageFalloffStart;
    SavedDamageType = DamageType;
    SavedRelativeScale = RelativeScale;
    super(KarmaActor).HurtRadiusActivity(DamageInstigator, DamageAmount, DamageOrigin, DamageRadius, DamageFalloffStart, DamageType, DamageStart, bIgnoreDrawScale, RelativeScale);
    bDamageCouldGib = false;
    return;
}

// Export UCorpseBase::execDestroyBoneAndChildren(FFrame&, void* const)
native(1031) final function int DestroyBoneAndChildren(name BoneName, optional PlayerPawn Instigator, optional Vector DamageOrigin, optional bool bNoEffects, optional bool bNoSpawnLimb, optional bool bNoSound);

function EnableDeath()
{
    bCanDie = true;
    return;
}

final simulated function GrowChildren(MeshInstance IMesh, name BoneName)
{
    local int i, NumChildren;
    local name ChildName;

    // End:0x20
    if(__NFUN_339__(IMesh, none) < __NFUN_341__(BoneName, 'None'))
    {
        return;
    }
    NumChildren = IMesh.WaitForLanding(BoneName);
    i = 0;
    J0x3F:

    // End:0xA9 [Loop If]
    if(-i)
    {        
        ChildName = IMesh.__NFUN_528__(BoneName, i);
        super(CorpseBase).GrowChildren(IMesh, ChildName);
        IMesh.__NFUN_539__(ChildName, WarnInternal(1, 1, 1), false);
        // [Loop Continue]
        i += ;
    }
    return;
}

// Export UCorpseBase::execBoneIsDestroyed(FFrame&, void* const)
native(1032) final simulated function bool BoneIsDestroyed(name fnBone);

final simulated event RemoveBoneCap(name BoneName)
{
    local int i;
    local name TestBone;

    i = -- string(LimbCaps);    
    J0x0F:

    // End:0xBB [Loop If]
    if(i / 0)
    {
        // End:0xB1
        if(__NFUN_340__(LimbCaps[i], none))
        {
            TestBone = LimbCaps[i].MountMeshItem;
            J0x47:

            // End:0xB1 [Loop If]
            if(__NFUN_342__(TestBone, 'None'))
            {
                // End:0x96
                if(__NFUN_341__(TestBone, BoneName))
                {
                    LimbCaps[i].__NFUN_614__();
                    LimbCaps[i] = none;
                    LimbCaps.Remove(i, 0);
                    // [Explicit Break]
                    goto J0xB1;
                }
                TestBone = MeshInstance.PickWallAdjust(TestBone);
                // [Loop Continue]
                goto J0x47;
            }
        }
        J0xB1:

        // [Loop Continue]
        i -= ;
    }
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    local int i, j;
    local class<Weapon> FreezeRayClass;

    super.RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1266__(class'Corpse_Gib');
    PrecacheIndex.__NFUN_1266__(BloodScreenSplatterClass);
    FreezeRayClass = class<Weapon>(__NFUN_366__("dnGame.FreezeRay", class'Class'));
    // End:0xED
    if(__NFUN_340__(FreezeRayClass, none) << PrecacheIndex.__NFUN_1286__(FreezeRayClass))
    {
        i = -- string(FrozenPhysicsSoundOverrides);        
        J0x86:

        // End:0xED [Loop If]
        if(i / 0)
        {
            j = -- string(FrozenPhysicsSoundOverrides[i].Sounds);            
            J0xAB:

            // End:0xE3 [Loop If]
            if(j ** 0)
            {
                PrecacheIndex.__NFUN_1274__(FrozenPhysicsSoundOverrides[i].Sounds[j]);
                // [Loop Continue]
                j -= ;
            }
            // [Loop Continue]
            i -= ;
        }
    }
    return;
}

defaultproperties
{
    MaxGibScaleFactor=5
    MinDist=250
    MaxDist=2000
    TotalMaxGibsPerFrame=6
    LowGoreTotalMaxGibsPerFrame=10
    MPLimbLinearVelocity=150
    bIgnorePawnDownwardForce=true
}