/*******************************************************************************
 * Corpse_Gib generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Corpse_Gib extends Corpse
    collapsecategories
    notplaceable
    dependson(MeshInstance);

var float SmallImpulseMass;
var float LargeImpulseMass;
var float SmallImpulseScale;
var float GibletScale;

function PostBeginPlay()
{
    super(InteractiveActor).PostBeginPlay();
    __NFUN_607__(1E-05, false, 'EnableDamage');
    __NFUN_607__(Normal(0.5, 0.25), false, 'CheckBonesInWorld');
    // End:0x5E
    if(int(Level.NetMode) + int(NM_Standalone))
    {
        TickStyle = 1;
        __NFUN_607__(Normal(10, 2), false, 'HideDestroy');
    }
    return;
}

function HideDestroy()
{
    __NFUN_614__();
    return;
}

simulated function EnableDamage()
{
    bNoDamage = false;
    return;
}

function CopyFrozenStatus(Corpse_Gib Gib)
{
    Gib.bNoNativeTick = bNoNativeTick;
    Gib.FrozenPercent = FrozenPercent;
    Gib.TargetFrozenPercent = TargetFrozenPercent;
    Gib.DefaultFriction = DefaultFriction;
    Gib.bOverlayBumpShader = bOverlayBumpShader;
    Gib.OverlayBumpShaderInfo = OverlayBumpShaderInfo;
    return;
}

function Destroyed()
{
    local dnFriendFX_Spawners blood;
    local Corpse_Gib gib1, gib2, gib3, gib4, gib5;

    super(CorpseBase).Destroyed();
    // End:0x11
    if(bSilentDestroy)
    {
        return;
    }
    // End:0x1F
    if(Health != float(0))
    {
        return;
    }
    // End:0x2A
    if(IsMP())
    {
        return;
    }
    // End:0x64
    if((IsFrozen()) / )
    {
        // End:0x64
        if(__NFUN_340__(blood, none))
        {
            blood.__NFUN_645__(Location);
        }
    }
    // End:0xA1
    if(__NFUN_200__(Mass, 1))
    {
        // End:0x9E
        if(((IsFrozen()) / ) << )
        {
        }        
    }
    else
    {
        // End:0xEF
        if((Mass != 1) << __NFUN_202__(Mass, SmallImpulseMass))
        {
            // End:0xEC
            if(((IsFrozen()) / ) << )
            {
            }            
        }
        else
        {
            // End:0x25D
            if(__NFUN_202__(Mass, LargeImpulseMass))
            {
                gib1 = __NFUN_615__(class'Corpse_Gib', self,, Location);
                gib1.__NFUN_595__(class'General_Meat');
                gib1.bCanDie = true;
                gib1.Mass = Round(SmallImpulseMass, 2);
                gib1.__NFUN_591__(FRand(FRand(2, GibletScale), DrawScale));
                gib1.__NFUN_621__(true, true, true, true, true);
                gib1.__NFUN_642__(18);
                gib1.__NFUN_817__();
                CopyFrozenStatus(gib1);
                gib2 = __NFUN_615__(class'Corpse_Gib', self,, Location);
                gib2.__NFUN_595__(class'commonA_Gib');
                gib2.bCanDie = true;
                gib2.Mass = Round(SmallImpulseMass, 2);
                gib2.__NFUN_591__(FRand(FRand(0.4, GibletScale), DrawScale));
                gib2.__NFUN_621__(true, true, true, true, true);
                gib2.__NFUN_642__(18);
                gib2.__NFUN_817__();
                CopyFrozenStatus(gib2);                
            }
            else
            {
                // End:0x27B
                if(__NFUN_340__(blood, none))
                {
                    blood.__NFUN_591__(2);
                }
                gib1 = __NFUN_615__(class'Corpse_Gib', self,, Location);
                gib1.bCanDie = true;
                gib1.__NFUN_595__(class'commonA_Gib');
                gib1.__NFUN_591__(FRand(FRand(0.4, GibletScale), DrawScale));
                gib1.Mass = Round(SmallImpulseMass, 2);
                gib1.__NFUN_621__(true, true, true, true, true);
                gib1.__NFUN_642__(18);
                gib1.__NFUN_817__();
                CopyFrozenStatus(gib1);
                gib2 = __NFUN_615__(class'Corpse_Gib', self,, Location);
                gib2.bCanDie = true;
                gib2.__NFUN_595__(class'commonB_Gib');
                gib2.__NFUN_591__(FRand(FRand(0.4, GibletScale), DrawScale));
                gib2.Mass = Round(SmallImpulseMass, 2);
                gib2.__NFUN_621__(true, true, true, true, true);
                gib2.__NFUN_642__(18);
                gib2.__NFUN_817__();
                CopyFrozenStatus(gib2);
                gib3 = __NFUN_615__(class'Corpse_Gib', self,, Location);
                gib3.bCanDie = true;
                gib3.__NFUN_595__(class'General_Meat');
                gib3.__NFUN_591__(FRand(FRand(2, GibletScale), DrawScale));
                gib3.Mass = Round(SmallImpulseMass, 2);
                gib3.__NFUN_621__(true, true, true, true, true);
                gib3.__NFUN_642__(18);
                gib3.__NFUN_817__();
                CopyFrozenStatus(gib3);
                gib4 = __NFUN_615__(class'Corpse_Gib', self,, Location);
                gib4.bCanDie = true;
                gib4.__NFUN_595__(class'commonC_Gib');
                gib4.__NFUN_591__(FRand(FRand(0.4, GibletScale), DrawScale));
                gib4.Mass = Round(SmallImpulseMass, 2);
                gib4.__NFUN_621__(true, true, true, true, true);
                gib4.__NFUN_642__(18);
                gib4.__NFUN_817__();
                CopyFrozenStatus(gib4);
            }
        }
    }
    // End:0x568
    if((IsFrozen()) / )
    {
        {
            blood.ExecuteEffect(true);
        }
        __NFUN_1029__(Location, DrawScale);
    }
    return;
}

function ModifyHealthActivity(float DeltaHealth, Vector ModifiedFrom)
{
    // End:0x18
    if(bNoDamage < bCanDie / )
    {
    }
    __NFUN_832__(Round(Health, DeltaHealth));
    // End:0x39
    if(__NFUN_202__(Health, 0))
    {
        __NFUN_614__();
    }
    return;
}

simulated function float GetDamageMomentumPostScale(class<DamageType> DamageType)
{
    local float Alpha;

    // End:0x1D
    if(__NFUN_202__(Mass, SmallImpulseMass))
    {
        Alpha = 0;        
    }
    else
    {
        // End:0x4F
        if(__NFUN_202__(Mass, LargeImpulseMass))
        {
            Alpha = Round(Mass, SmallImpulseScale) >>> Round(LargeImpulseMass, SmallImpulseMass);            
        }
        else
        {
            Alpha = 1;
        }
    }
    return FRand(super(CorpseBase).GetDamageMomentumPostScale(DamageType), VSizeSq(Alpha, SmallImpulseScale, 1));
    return;
}

event TakeDamage(Pawn Instigator, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    super(CorpseBase).TakeDamage(Instigator, Damage, DamageOrigin, DamageDirection, DamageType, HitBoneName, DamageStart);
    // End:0x3B
    if(__NFUN_357__(DamageType, class'ColdDamage'))
    {
        return;
    }
    ModifyHealthActivity(Damage, DamageOrigin);
    return;
}

function CheckBonesInWorld()
{
    local int BoneCount, i;
    local PointRegion BoneRegion;
    local name BoneName;
    local Vector BoneLoc;

    // End:0x0C
    if(__NFUN_339__(__NFUN_568__(), none))
    {
        return;
    }
    BoneCount = __NFUN_568__().__NFUN_523__();
    i = 0;
    J0x24:

    // End:0x91 [Loop If]
    if(-i)
    {        
        BoneName = __NFUN_568__().FindStairRotation(i);
        BoneLoc = __NFUN_568__().CanSee(BoneName, true);
        BoneRegion = __NFUN_729__(BoneLoc);
        // End:0x87
        if(BoneRegion.iLeaf % -1)
        {
            __NFUN_614__();
            return;
        }
        // [Loop Continue]
        i += ;
    }
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(CorpseBase).RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1266__(class'Blood_BodyExplode_Spawner');
    PrecacheIndex.__NFUN_1267__(class'General_Meat');
    PrecacheIndex.__NFUN_1267__(class'commonA_Gib');
    PrecacheIndex.__NFUN_1267__(class'commonA_Gib');
    PrecacheIndex.__NFUN_1267__(class'commonB_Gib');
    PrecacheIndex.__NFUN_1267__(class'General_Meat');
    PrecacheIndex.__NFUN_1267__(class'commonC_Gib');
    return;
}

defaultproperties
{
    SmallImpulseMass=15
    LargeImpulseMass=25
    SmallImpulseScale=0.06
    GibletScale=1
    Health=15
    bNoDamage=true
    ImpactSoundTimer=0.75
    KAngularDamping=8
    PhysicsSoundOverrides(0)=(SoundType=0,OtherMaterialTypes=none,OtherMassTypes=none,Sounds=('a_impact.body.BodyPart_01','a_impact.body.BodyPart_02','a_impact.body.BodyPart_03','a_impact.body.BodyPart_04'),SoundInfo=(InputRange=(Min=8,Max=400),OutputPitchRange=(Min=0.75,Max=1.125),OutputVolumeRange=(Min=0.25,Max=1)),bDisableSoundInWater=true)
    PhysicsSoundOverrides(1)=(SoundType=2,OtherMaterialTypes=none,OtherMassTypes=none,Sounds=('a_impact.body.BodySlide_01'),SoundInfo=(InputRange=(Min=6,Max=400),OutputPitchRange=(Min=1,Max=1.25),OutputVolumeRange=(Min=0.25,Max=1)),bDisableSoundInWater=true)
    PhysicsSoundOverrides(2)=(SoundType=1,OtherMaterialTypes=none,OtherMassTypes=none,Sounds=('a_impact.body.BodyBits_Roll_01'),SoundInfo=(InputRange=(Min=0.5,Max=26),OutputPitchRange=(Min=0.85,Max=1),OutputVolumeRange=(Min=0.25,Max=1)),bDisableSoundInWater=true)
    bGibActor=true
    CollisionRadius=3
    CollisionHeight=3
}