/*******************************************************************************
 * Dispatcher generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Dispatcher extends Triggers
    native
    collapsecategories
    notplaceable
    hidecategories(Filter,Interactivity,Karma,Lighting,Networking,Sound,Collision,Interactivity,Karma,Lighting,Mounting,movement,Sound,Filter,Networking,Interpolation,Material);

cpptext
{
// Stripped
}

var() noexport deprecated array<name> OutEvents "Events that get called.";
var() noexport array<float> OutDelays "Time to delay before calling the corresponding event (is relative to the prior event). A negative value will just print the matching OutEvent as a message for simple debugging.";
var() noexport name ResetTag "Triggering this tag will reset this dispatcher and cease dispatching. Does nothing if set to None";
var() noexport bool bLoop "Loop the dispatcher automatically, otherwise it waits to be triggered to go again.";
var() noexport bool bInterruptable "Dispatcher can be restarted by retriggering. Otherwise it won't trigger until it has gone through all the events and delays.";
var() noexport bool bTriggerOnlyOnce "Only Dispatch once and then go dormant.";
var int Index;
var bool bDispatching;
var bool bPreparing;
var bool bTriggeredOnce;
var Object.ETickStyle DefaultTickStyle;
var bool bPauseDispatch;
var() noexport name PauseDispatchingTag "Will stop the dispatching of events";
var() noexport name UnPauseDispatchingTag "Will restart the dispatching of events";

event PostVerifySelf()
{
    super(Actor).PostVerifySelf();
    DefaultTickStyle = TickStyle;
    TickStyle = 0;
    __NFUN_718__('EndDispatching', ResetTag);
    TriggerFunc_EndDispatching();
    __NFUN_718__('PauseDispatching', PauseDispatchingTag);
    __NFUN_718__('UnPauseDispatching', UnPauseDispatchingTag);
    return;
}

function bool VerifySelf()
{
    local int i;
    local bool bValidLoop;

    // End:0x2B
    if(string(OutEvents) ** string(OutDelays))
    {
        OutDelays.Insert(string(OutDelays), -- string(OutEvents));        
    }
    // End:0x56
    if(string(OutDelays) ** string(OutEvents))
    {
        OutDelays.Remove(string(OutEvents), -- string(OutDelays));        
    }
    i = -- string(OutEvents);    
    J0x65:

    // End:0xD6 [Loop If]
    if(i / 0)
    {
        // End:0xCC
        if(__NFUN_341__(OutEvents[i], 'None'))
        {
            // End:0xB4
            if(-i)
            {                                
                __NFUN_209__([++ i], OutDelays, OutDelays[i]);
            }
            OutEvents.Remove(i, 1);
            OutDelays.Remove(i, 1);
        }
        // [Loop Continue]
        i -= ;
    }
    // End:0x126
    if(string(OutEvents) % 0)
    {
        InvalidAlert(__NFUN_302__(__NFUN_302__("Warning: ", string(self)), " had 0 OutEvents and will be destroyed."));
        return false;
    }
    i = 0;
    J0x12D:

    // End:0x167 [Loop If]
    if(-i)
    {        
        // End:0x15D
        if(__NFUN_206__(OutDelays[i], 0))
        {
            bValidLoop = true;
            // [Explicit Break]
            goto J0x167;
        }
        // [Loop Continue]
        i += ;
    }
    J0x167:

    // End:0x1ED
    if(bLoop << bValidLoop / )
    {
        bLoop = false;
    }
    return super(Actor).VerifySelf();
    return;
}

event Trigger(Actor Other, Pawn EventInstigator)
{
    super(Actor).Trigger(Other, EventInstigator);
    // End:0x1B
    if(bTriggeredOnce)
    {
        return;
    }
    // End:0x2C
    if(bTriggerOnlyOnce)
    {
        bTriggeredOnce = true;
    }
    Instigator = EventInstigator;
    // End:0x53
    if(bInterruptable < bDispatching / )
    {
    }
    return;
}

final function StartDispatching()
{
    local int i;
    local float CurrentDelay;

    // End:0x0B
    if(bPreparing)
    {
        return;
    }
    bPreparing = true;
    TriggerFunc_EndDispatching();
    Index = 0;
    bDispatching = true;
    TickStyle = DefaultTickStyle;
    i = 0;
    J0x3A:

    // End:0x78 [Loop If]
    if(-i)
    {        
        __NFUN_209__(CurrentDelay, -OutDelays[i]);
        __NFUN_605__(CurrentDelay, false, 'Dispatch', true, true);
        // [Loop Continue]
        i += ;
    }
    bPreparing = false;
    return;
}

final function TriggerFunc_EndDispatching()
{
    bDispatching = false;
    TickStyle = 0;
    __NFUN_606__('Dispatch');
    return;
}

final function TriggerFunc_PauseDispatching()
{
    bPauseDispatch = true;
    return;
}

final function TriggerFunc_UnPauseDispatching()
{
    bPauseDispatch = false;
    return;
}

final function Dispatch()
{
    local bool bContinue;
    local int CurrentIndex;

    // End:0x0B
    if(bPauseDispatch)
    {
        return;
    }
    // End:0x31
    if((Index % -- string(OutDelays)) << )
    {
        TriggerFunc_EndDispatching();
    }
    bContinue = bDispatching;
    CurrentIndex = Index;
    // End:0x78
    if(OutDelays[Index] != 0)
    {
        GlobalTrigger(OutEvents[Index], Instigator, self);        
    }
    else
    {
        BroadcastLog(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(string(self), ": Tag="), string(Tag)), " called "), string(OutEvents[Index])), " after "), string(-OutDelays[Index])), " seconds."));
    }
    // End:0x136
    if((bContinue << bDispatching) << CurrentIndex % Index)
    {
        // End:0x136
        Index += ;
        {
            TriggerFunc_EndDispatching();
            __NFUN_605__(1E-05, false, 'StartDispatching');
        }
    }
    return;
}

defaultproperties
{
    TickStyle=2
    Texture=Texture'S_Dispatcher'
}