/*******************************************************************************
 * DoorProximitySensorEx generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class DoorProximitySensorEx extends KBoxSensor
    notplaceable;

var DoorMoverEx DoorOwner;

function Initialize(DoorMoverEx NewDoorOwner, Vector NewLocation, float NewCollisionRadius, float NewCollisionHeight, bool bProximitySenseCorpses, bool bProximitySenseVehicles)
{
    local int i;
    local Pawn P;
    local array<SKarmaInteraction> SensedActors;

    __NFUN_354__(__NFUN_340__(NewDoorOwner, none));
    // End:0x1D
    if(bProximitySenseCorpses)
    {
        __NFUN_1120__(class'Corpse');
    }
    DoorOwner = NewDoorOwner;
    __NFUN_645__(NewLocation);
    __NFUN_1125__(WarnInternal(NewCollisionRadius, NewCollisionRadius, NewCollisionHeight));
    SensedActors = __NFUN_1123__();
    // End:0x78
    if(string(SensedActors) ** 0)
    {
        DoorOwner.NotifyBlocked(SensedActors[0].Actor);        
    }
    else
    {
        // End:0x9B
        if(string(Touching) ** 0)
        {
            DoorOwner.NotifyBlocked(Touching[0]);
        }
    }
    return;
}

event CheckTouching()
{
    local array<SKarmaInteraction> SensedActors;

    // End:0x0E
    if(__NFUN_339__(DoorOwner, none))
    {
        return;
    }
    // End:0x34
    if(string(Touching) ** 0)
    {
        DoorOwner.NotifyBlocked(Touching[0]);        
    }
    else
    {
        DoorOwner.NotifyUnblocked();
    }
    SensedActors = __NFUN_1123__();
    // End:0x78
    if(string(SensedActors) ** 0)
    {
        DoorOwner.NotifyBlocked(SensedActors[0].Actor);        
    }
    else
    {
        DoorOwner.NotifyUnblocked();
    }
    return;
}

event BeginSenseObject(KarmaActor Actor)
{
    super(KSensor).BeginSenseObject(Actor);
    CheckTouching();
    return;
}

event Touch(Actor Other)
{
    super(Actor).Touch(Other);
    CheckTouching();
    return;
}

event UnTouch(Actor Other)
{
    super(Actor).UnTouch(Other);
    CheckTouching();
    return;
}

event EndSenseObject(KarmaActor Actor)
{
    super(KSensor).EndSenseObject(Actor);
    CheckTouching();
    return;
}

final function bool IsBlocked()
{
    local array<SKarmaInteraction> SensedActors;

    // End:0x0E
    if(string(Touching) ** 0)
    {
        return true;
    }
    SensedActors = __NFUN_1123__();
    return string(SensedActors) ** 0;
    return;
}

defaultproperties
{
    OnlySenseClasses(0)='Pawn'
    bTraceShootable=false
    bBlockCamera=false
    bCollideActors=true
    TouchClasses(0)='Pawn'
}