/*******************************************************************************
 * FogMorphDispatcher generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class FogMorphDispatcher extends Dispatchers
    collapsecategories
    notplaceable;

enum EMorphStyle
{
    MORPH_None,
    MORPH_Radius,
    MORPH_Time
};

var() noexport bool bRadiusIsSphere "If true, then the Dispatcher will check in a sphere around itself instead of using the CollisionHeight and CollisionRadius of the actor itself (otherwise directly above and below the dispatcher is fully fogged).";
var() noexport bool bUseCurrentFog "If true, the fog will start with the level's current fog values.";
var() noexport bool bMorphOnTouch "If this is true, then the dispatcher will start morphing when touched by a player.";
var() noexport bool bMorphOnTrigger "If this is true, then the dispatcher will start morphing when triggered.";
var() noexport bool bNotInterruptable "If this is true, then if the system is currently morphing it won't allow anything to interrupt it until it's done.";
var() noexport float TriggeredMorphTime "Number of seconds the fog will take to morph when triggered.";
var() noexport float InnerRadius "Inner radius of morph area. This is the region that the fog will have reached it's final level when using radius morphing. CollisionRadius defines the outer radius where morphing starts.";
var() noexport Color StartFogColor "Initial FogColor. Ignored when bUseCurrentFog is true.";
var() noexport float StartFogBegin "Initial FogBegin. Ignored when bUseCurrentFog is true.";
var() noexport float StartFogEnd "Initial FogEnd. Ignored when bUseCurrentFog is true.";
var() noexport Color FinalFogColor "Value for FogColor at the center of the radius when using bMorphOnRadius or when the timer expires when using bMorphOnTrigger.";
var() noexport float FinalFogBegin "Value for FogBegin at the center of the radius when using bMorphOnRadius or when the timer expires when using bMorphOnTrigger.";
var() noexport float FinalFogEnd "Value for FogEnd at the center of the radius when using bMorphOnRadius or when the timer expires when using bMorphOnTrigger.";
var() noexport bool FinalbDistanceFog "State that bDistanceFog variable in the LevelInfo will be set to when finished morphing. Only used for Timed morphs.";
var bool StartbDistanceFog;
var PlayerPawn ThePlayer;
var FogMorphDispatcher.EMorphStyle MorphStyle;
var float CurMorphTime;

defaultproperties
{
    bRadiusIsSphere=true
    bUseCurrentFog=true
    bNotInterruptable=true
    InnerRadius=128
    bHidden=true
    bNoNativeTick=false
    bDirectional=true
    CollisionRadius=256
}