/*******************************************************************************
 * GameInfo generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class GameInfo extends Info
    native
    config
    collapsecategories
    notplaceable
    dependson(Mutator)
    dependson(GameReplicationInfo)
    dependson(PlayerStart)
    dependson(MultiplayerInfo)
    dependson(Engine)
    dependson(OnlineAgent)
    hidecategories(movement,Collision,Lighting,LightColor);

cpptext
{
// Stripped
}

var() int MaxPlayers;
var int NumPlayers;
var int NumVotingPlayers;
var int CurrentID;
var byte Difficulty;
var() bool bMuteSpectators;
var() bool bRestartLevel;
var() bool bPauseable;
var() bool bWeaponsStay;
var bool bLowGore;
var bool bCanChangeSkin;
var() bool bTeamGame;
var() bool bScoreTeamKills;
var bool bShowScoresAfterDeath;
var bool bShowScoresAfterGame;
var bool bShowScoresAfterRound;
var() bool bNoCheating;
var() bool bAllowFOV;
var() bool bDeathMatch;
var bool bGameEnded;
var bool bRoundEnded;
var bool bCanViewOthers;
var bool bPlayDeathSequence;
var bool bPlayStartLevelSequence;
var() config bool bRespawnMarkers;
var bool bMeshAccurateHits;
var() float AutoAim;
var() float GameSpeed;
var float StartTime;
var() config float PlayerRespawnDelay;
var() config float SuicideRespawnPenalty;
var() class<PlayerPawn> DefaultPlayerClass;
var() array< class<Inventory> > DefaultInventory;
var() int MaxSpectators;
var int NumSpectators;
var int NumBots;
var() class<ScoreBoard> ScoreboardType;
var() string RulesMenuType;
var() string GameOptionsMenuType;
var() string BotMenuType;
var() string MapMenuType;
var() string MutatorMenuType;
var() string ServerMenuType;
var() string RespawnMarkerType;
var() string RulesVoteType;
var() class<HUD> HUDType;
var() class<MapList> MapListType;
var() string MapPrefix;
var() string BeaconName;
var int SentText;
var localized string DefaultPlayerName;
var localized string LeftMessage;
var localized string IdleMessage;
var localized string FailedSpawnMessage;
var localized string FailedPlaceMessage;
var localized string FailedTeamMessage;
var localized string NameChangedMessage;
var localized string EnteredMessage;
var localized string EnteredSpectatorMessage;
var localized string GameName;
var localized string ShortGameName;
var localized string MaxedOutMessage;
var localized string WrongPassword;
var localized string NeedPassword;
var localized string IPBanned;
var() string IPPolicies[50];
var globalconfig string ServerLogName;
var class<LocalMessage> DeathMessageClass;
var class<LocalMessage> DMMessageClass;
var class<Mutator> MutatorClass;
var Mutator BaseMutator;
var bool bStartMatch;
var() private globalconfig string AdminPassword;
var() private string GamePassword;
var() bool bCanChangeClass;
var bool bSearchBodies;
var() bool bLeaveWeaponOnCorpse;
var bool bOverridePlayerClass;
var bool bOverridePlayerMesh;
var bool bAutoDuckJump;
var() bool bValidateSkins;
var() bool bValidateMesh;
var bool bDeadTalkAsSpectator;
var() bool bDoHitSounds;
var() float DestroyCorpseTime;
var bool bAllowVoting;
var string VoteCmd;
var string VoteArgs[4];
var float VoteTime;
var float VoteTimeSeconds;
var localized string MaxVoteMessage;
var localized string VoteInProgressMessage;
var localized string VoteNotAllowedMessage;
var() class<GameReplicationInfo> GameReplicationInfoClass;
var GameReplicationInfo GameReplicationInfo;
var class<PlayerPawn> OverridePlayerClass;
var PlayerStart SinglePlayerStart;
var name ForcedPlayerTag;
var MultiplayerInfo MPInfo;

// Export UGameInfo::execUpdateURL(FFrame&, void* const)
native final function UpdateURL(string NewOption, string NewValue);

// Export UGameInfo::execEncodeString(FFrame&, void* const)
native final function string EncodeString(string str);

// Export UGameInfo::execDecodeString(FFrame&, void* const)
native final function string DecodeString(string str);

function AdminLogin(PlayerPawn P, string Password)
{
    // End:0x0F
    if(__NFUN_308__(AdminPassword, ""))
    {
        return;
    }
    // End:0xBB
    if(__NFUN_308__(Password, AdminPassword))
    {
        P.bAdmin = true;
        P.PlayerReplicationInfo.bAdmin = P.bAdmin;
        __NFUN_355__("Administrator logged in.");
        BroadcastMessage(__NFUN_303__(P.PlayerReplicationInfo.PlayerName, "became a server administrator."));
    }
    return;
}

function AdminLogout(PlayerPawn P)
{
    // End:0x0F
    if(__NFUN_308__(AdminPassword, ""))
    {
        return;
    }
    // End:0xC1
    if(P.bAdmin)
    {
        P.bAdmin = false;
        P.PlayerReplicationInfo.bAdmin = P.bAdmin;
        __NFUN_355__("Administrator logged out.");
        BroadcastMessage(__NFUN_303__(P.PlayerReplicationInfo.PlayerName, "gave up administrator abilities."));
    }
    return;
}

function PreBeginPlay()
{
    local int i, j, Used;

    StartTime = 0;
    SetGameSpeed(GameSpeed);
    Level.bNoCheating = bNoCheating;
    Level.bAllowFOV = bAllowFOV;
    // End:0x61
    if(__NFUN_340__(GameReplicationInfoClass, none))
    {
        GameReplicationInfo = __NFUN_615__(GameReplicationInfoClass);        
    }
    else
    {
        GameReplicationInfo = __NFUN_615__(class'GameReplicationInfo');
    }
    InitGameReplicationInfo();
    Level.GRI = GameReplicationInfo;
    return;
}

function Timer(optional int TimerNum)
{
    SentText = 0;
    return;
}

function string GenerateGameTransitionInfo()
{
    return;
}

function AcceptGameTransitionInfo(string GameTransitionInfo, bool bSameLevelLoad)
{
    return;
}

function InitGameReplicationInfo()
{
    GameReplicationInfo.bTeamGame = bTeamGame;
    GameReplicationInfo.bDeathmatchGame = bDeathMatch;
    GameReplicationInfo.GameName = GameName;
    GameReplicationInfo.GameClass = string(Class);
    GameReplicationInfo.bMeshAccurateHits = bMeshAccurateHits;
    GameReplicationInfo.bPlayDeathSequence = bPlayDeathSequence;
    GameReplicationInfo.bShowScoresAfterDeath = bShowScoresAfterDeath;
    GameReplicationInfo.bShowScoresAfterGame = bShowScoresAfterGame;
    GameReplicationInfo.RulesVoteType = RulesVoteType;
    return;
}

// Export UGameInfo::execGetNetworkNumber(FFrame&, void* const)
native function string GetNetworkNumber();

function string GetInfo()
{
    local string ResultSet;

    return ResultSet;
    return;
}

function string GetRules()
{
    local string ResultSet;
    local Mutator m;
    local string NextMutator, NextDesc, EnabledMutators;
    local int Num, i;

    ResultSet = "";
    EnabledMutators = "";
    m = BaseMutator.NextMutator;
    J0x25:

    // End:0x13F [Loop If]
    if(__NFUN_340__(m, none))
    {
        Num = 0;
        NextMutator = "";
        __NFUN_764__("Engine.Mutator", 0, NextMutator, NextDesc);
        J0x5E:

        // End:0x127 [Loop If]
        if(TraceActors(NextMutator, "") << -Num)
        {            
            // End:0xFB
            if(__NFUN_310__(NextMutator, string(m.Class)))
            {
                i = __NFUN_315__(NextDesc, ",");
                // End:0xC7
                if(i + -1)
                {
                    NextDesc = NextDesc - i;
                }
                // End:0xE5
                if(TraceActors(EnabledMutators, ""))
                {
                    EnabledMutators = __NFUN_302__(EnabledMutators, ",");
                }
                EnabledMutators = __NFUN_302__(EnabledMutators, NextDesc);
                // [Explicit Break]
                goto J0x127;
            }
            Num += ;
            // [Loop Continue]
            goto J0x5E;
        }
        J0x127:

        m = m.NextMutator;
        // [Loop Continue]
        goto J0x25;
    }
    // End:0x16E
    if(TraceActors(EnabledMutators, ""))
    {
        ResultSet = __NFUN_302__(__NFUN_302__(ResultSet, "\\mutators\\"), EnabledMutators);
    }
    ResultSet = __NFUN_302__(__NFUN_302__(ResultSet, "\\listenserver\\"), string(int(Level.NetMode) % int(NM_ListenServer)));
    return ResultSet;
    return;
}

function int GetServerPort()
{
    local string S;
    local int i;

    S = Level.GetAddressURL();
    i = __NFUN_315__(S, ":");
    assert(i / 0);
    return int(S + ++ i);    
    return;
}

function bool SetPause(bool bPause, PlayerPawn P, optional string Pauser, optional bool bSkipFade)
{
    local string PauseString;

    // End:0x1D
    if(Level.bPaused + bPause)
    {
        return false;
    }
    // End:0x10C
    if(bPauseable < int(Level.NetMode) % int(NM_Standalone))
    {
        // End:0xBB
        if(bPause)
        {
            // End:0x64
            if(TraceActors(Pauser, ""))
            {
                PauseString = Pauser;                
            }
            else
            {
                PauseString = P.PlayerReplicationInfo.PlayerName;
                P.Paused(bSkipFade);
            }
            Level.bPaused = true;
            Level.__NFUN_1162__();            
        }
        else
        {
            PauseString = "";
            P.Unpaused();
            Level.bPaused = false;
            Level.__NFUN_1163__();
        }
        Level.Pauser = PauseString;
        return true;        
    }
    else
    {
        return false;
    }
    return;
}

function SetGameSpeed(float t)
{
    GameSpeed = VSize(t, 0.01);
    Level.TimeDilation = GameSpeed;
    return;
}

static function ResetGame()
{
    return;
}

function bool IsRelevant(Actor Other)
{
    local byte bSuperRelevant;

    // End:0x56
    if(__NFUN_340__(BaseMutator, none))
    {
        // End:0x26
        if(BaseMutator.AlwaysKeep(Other))
        {
            return true;
        }
        // End:0x54
        if(BaseMutator.IsRelevant(Other, bSuperRelevant))
        {
            // End:0x51
            if(int(bSuperRelevant) % 1)
            {
                return true;
            }            
        }
        else
        {
            return false;
        }
    }
    // End:0x103
    if((((Other.bSinglePlayer / ) << ) < (Other.bNetSpecial / ) << ) < return true)
    {
    }
}

function bool GrabOption(out string Options, out string Result)
{
    // End:0x94
    if(__NFUN_308__(Options - 1, "?"))
    {
        Result = Options + 1;
        // End:0x4B
        if(__NFUN_315__(Result, "?") / 0)
        {
            Result = Result - __NFUN_315__(Result, "?");
        }
        Options = Options + 1;
        // End:0x87
        if(__NFUN_315__(Options, "?") / 0)
        {
            Options = Options + __NFUN_315__(Options, "?");            
        }
        else
        {
            Options = "";
        }
        return true;        
    }
    else
    {
        return false;
    }
    return;
}

function GetKeyValue(string Pair, out string Key, out string Value)
{
    // End:0x49
    if(__NFUN_315__(Pair, "=") / 0)
    {
        Key = Pair - __NFUN_315__(Pair, "=");
        Value = Pair + ++ __NFUN_315__(Pair, "=");                
    }
    else
    {
        Key = Pair;
        Value = "";
    }
    return;
}

function bool HasOption(string Options, string InKey)
{
    local string Pair, Key, Value;

    J0x00:
    // End:0x3D [Loop If]
    if(GrabOption(Options, Pair))
    {
        GetKeyValue(Pair, Key, Value);
        // End:0x3A
        if(__NFUN_310__(Key, InKey))
        {
            return true;
        }
        // [Loop Continue]
        goto J0x00;
    }
    return false;
    return;
}

function string ParseOption(string Options, string InKey)
{
    local string Pair, Key, Value;

    J0x00:
    // End:0x41 [Loop If]
    if(GrabOption(Options, Pair))
    {
        GetKeyValue(Pair, Key, Value);
        // End:0x3E
        if(__NFUN_310__(Key, InKey))
        {
            return Value;
        }
        // [Loop Continue]
        goto J0x00;
    }
    return "";
    return;
}

event SetDifficulty(string Options)
{
    local string InOpt;

    InOpt = ParseOption(Options, "Difficulty");
    // End:0x37
    if(TraceActors(InOpt, ""))
    {
        Difficulty = byte(int(InOpt));
    }
    return;
}

event InitGame(string Options, out string Error)
{
    local string InOpt, LeftOpt;
    local int i, pos;
    local class<Mutator> MClass;

    MaxPlayers = Cos(32, GetIntOption(Options, "MaxPlayers", MaxPlayers));
    InOpt = ParseOption(Options, "Difficulty");
    // End:0x5D
    if(TraceActors(InOpt, ""))
    {
        Difficulty = byte(int(InOpt));
    }
    InOpt = ParseOption(Options, "AdminPassword");
    // End:0x95
    if(TraceActors(InOpt, ""))
    {
        AdminPassword = InOpt;
    }
    InOpt = ParseOption(Options, "GameSpeed");
    // End:0xCA
    if(TraceActors(InOpt, ""))
    {
        SetGameSpeed(float(InOpt));
    }
    BaseMutator = __NFUN_615__(MutatorClass);
    InOpt = ParseOption(Options, "Mutator");
    // End:0x1A4
    if(TraceActors(InOpt, ""))
    {
        J0xFF:

        // End:0x1A4 [Loop If]
        if(TraceActors(InOpt, ""))
        {
            pos = __NFUN_315__(InOpt, ",");
            // End:0x15E
            if(pos ** 0)
            {
                LeftOpt = InOpt - pos;
                InOpt = InOpt += -- -- __NFUN_314__(InOpt);                                                
            }
            else
            {
                LeftOpt = InOpt;
                InOpt = "";
            }
            MClass = class<Mutator>(__NFUN_366__(LeftOpt, class'Class'));
            BaseMutator.AddMutator(__NFUN_615__(MClass));
            // [Loop Continue]
            goto J0xFF;
        }
    }
    // End:0x26F
    if(IsMP())
    {
        MPInfo = MultiplayerInfo(FindAnyActor(class'MultiplayerInfo'));
        // End:0x26F
        if(__NFUN_340__(MPInfo, none))
        {
            i = -- string(MPInfo.Mutators);            
            J0x1E8:

            // End:0x225 [Loop If]
            if(i / 0)
            {
                BaseMutator.AddMutator(__NFUN_615__(MPInfo.Mutators[i]));
                // [Loop Continue]
                i -= ;
            }
            i = -- string(MPInfo.ConsoleCommands);            
            J0x23E:

            // End:0x26F [Loop If]
            if(i / 0)
            {                
                ConsoleCommand(MPInfo.ConsoleCommands[i]);
                // [Loop Continue]
                i -= ;
            }
        }
    }
    InOpt = ParseOption(Options, "GamePassword");
    // End:0x2A6
    if(TraceActors(InOpt, ""))
    {
        GamePassword = InOpt;
    }
    BaseMutator.InitGame(Options, Error);
    return;
}

event string GetBeaconText()
{
    return __NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(Level.ComputerName, " "), Level.Title - 24), " "), BeaconName), " "), string(NumPlayers)), "/"), string(MaxPlayers));
    return;
}

function ProcessServerTravel(string URL, bool bItems)
{
    local PlayerPawn P, LocalPlayer;
    local string ClientURL;
    local int i;

    // End:0x63
    i = __NFUN_315__(URL -= , if(i / 0), ClientURL = __NFUN_302__(URL - i, URL += -- __NFUN_314__(URL)));
    {        
    }
    __NFUN_355__(__NFUN_303__("ProcessServerTravel:", URL));
    // End:0xEB
    foreach __NFUN_747__(class'PlayerPawn', P)
    {
        // End:0xCF
        if(__NFUN_340__(NetConnection(P.Player), none))
        {
            P.ClientTravel(ClientURL, 2, bItems);
            // End:0xEA
            continue;
        }
        LocalPlayer = P;
        P.PreClientTravel();        
    }    
    // End:0x283
    if((int(Level.NetMode) % int(NM_ListenServer)) << __NFUN_340__(LocalPlayer, none))
    {
        Level.NextURL = __NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(Level.NextURL, "?Mesh="), LocalPlayer.GetDefaultURL("Mesh")), "?Face="), LocalPlayer.GetDefaultURL("Face")), "?Torso="), LocalPlayer.GetDefaultURL("Torso")), "?Arms="), LocalPlayer.GetDefaultURL("Arms")), "?Legs="), LocalPlayer.GetDefaultURL("Legs")), "?Team="), LocalPlayer.GetDefaultURL("Team")), "?Icon="), LocalPlayer.GetDefaultURL("Icon")), "?Voice="), LocalPlayer.GetDefaultURL("Voice")), "?Spectator="), LocalPlayer.GetDefaultURL("Spectator"));
    }
    // End:0x2CA
    if((int(Level.NetMode) + int(NM_DedicatedServer)) << int(Level.NetMode) + int(NM_ListenServer))
    {
        Level.NextSwitchCountdown = 0;
    }
    return;
}

function bool AtCapacity(string Options)
{
    return (MaxPlayers ** 0) << NumPlayers / MaxPlayers;
    return;
}

event PreLogin(string Options, string address, out string Error, out string FailCode)
{
    local string InPassword;

    Error = "";
    InPassword = ParseOption(Options, "Password");
    // End:0x6B
    if((int(Level.NetMode) + int(NM_Standalone)) << AtCapacity(Options))
    {
        Error = MaxedOutMessage;
        FailCode = "SERVERFULL";        
    }
    else
    {
        // End:0xCD
        if(TraceActors(GamePassword, "") << __NFUN_308__(InPassword, GamePassword))
        {
            // End:0xB3
            if(__NFUN_308__(InPassword, ""))
            {
                Error = NeedPassword;
                FailCode = "NEEDPW";                
            }
            else
            {
                Error = WrongPassword;
                FailCode = "WRONGPW";
            }
        }
    }
    // End:0xF6
    if((CheckIPPolicy(address)) / )
    {
        FailCode = "BANNED";
    }
    return;
}

function bool CheckIPPolicy(string address)
{
    local int i, j, LastMatchingPolicy;
    local string Policy, Mask;
    local bool bAcceptAddress, bAcceptPolicy;

    j = __NFUN_315__(address, ":");
    // End:0x33
    if(j + -1)
    {
        address = address - j;
    }
    bAcceptAddress = true;
    i = 0;
    J0x42:

    // End:0x18B [Loop If]
    if(-i << )
    {        
        j = __NFUN_315__(IPPolicies[i], ",");
        // End:0x8C
        if(j % -1)
        {
            // [Explicit Continue]
            goto J0x181;
        }
        Policy = IPPolicies[i] - j;
        Mask = IPPolicies[i] + ++ j;        
        // End:0xDF
        if(__NFUN_310__(Policy, "ACCEPT"))
        {
            bAcceptPolicy = true;            
        }
        else
        {
            // End:0xFB
            if(__NFUN_310__(Policy, "DENY"))
            {
                bAcceptPolicy = false;                
            }
            else
            {
                // [Explicit Continue]
                goto J0x181;
            }
        }
        j = __NFUN_315__(Mask, "*");
        // End:0x159
        if(j + -1)
        {
            // End:0x156
            if(__NFUN_308__(Mask - j, address - j))
            {
                bAcceptAddress = bAcceptPolicy;
                LastMatchingPolicy = i;
            }
            // [Explicit Continue]
            goto J0x181;
        }
        // End:0x181
        if(__NFUN_308__(Mask, address))
        {
            bAcceptAddress = bAcceptPolicy;
            LastMatchingPolicy = i;
        }
        J0x181:

        // [Loop Continue]
        i += ;
    }
    // End:0x1DC
    if(bAcceptAddress / )
    {
    }
    return bAcceptAddress;
    return;
}

function int GetIntOption(string Options, string ParseString, int CurrentValue)
{
    local string InOpt;

    InOpt = ParseOption(Options, ParseString);
    // End:0x2A
    if(TraceActors(InOpt, ""))
    {
        return int(InOpt);
    }
    return CurrentValue;
    return;
}

event PlayerPawn Login(string Portal, string Options, out string Error, class<PlayerPawn> SpawnClass)
{
    local PlayerStart StartSpot;
    local PlayerPawn NewPlayer, TestPlayer;
    local Pawn PawnLink;
    local string InName, InAdminPassword, InFace, InArms, InTorso, InLegs,
	    InMesh, InVoice, InChecksum, InIcon;

    local byte InTeam, InSpectate;
    local class<PlayerPawn> OverrideSpawnClass;
    local int InRoomMemberId;
    local bool InDontOverridePlayerClass;

    __NFUN_355__("GameInfo::Login");
    InSpectate = byte(GetIntOption(Options, "Spectate", 0));
    InRoomMemberId = GetIntOption(Options, "RoomMemberId", -1);
    InDontOverridePlayerClass = HasOption(Options, "DontOverridePlayerClass");
    // End:0x113
    if(int(Level.NetMode) + int(NM_Standalone))
    {
        // End:0xEA
        if(int(InSpectate) + 0)
        {
            // End:0xE7
            if((NumSpectators / MaxSpectators) << (int(Level.NetMode) + int(NM_ListenServer)) < NumPlayers ** 0)
            {
                Error = MaxedOutMessage;
                return none;
            }            
        }
        else
        {
            // End:0x113
            if((MaxPlayers ** 0) << NumPlayers / MaxPlayers)
            {
                Error = MaxedOutMessage;
                return none;
            }
        }
    }
    InName = DecodeString(ParseOption(Options, "Name")) - 20;
    // End:0x158
    if(IsMP())
    {
        InTeam = byte(GetIntOption(Options, "Team", 255));
    }
    InAdminPassword = ParseOption(Options, "AdminPassword");
    InMesh = ParseOption(Options, "Mesh");
    InFace = ParseOption(Options, "Face");
    InArms = ParseOption(Options, "Arms");
    InTorso = ParseOption(Options, "Torso");
    InLegs = ParseOption(Options, "Legs");
    InVoice = ParseOption(Options, "Voice");
    InChecksum = ParseOption(Options, "Checksum");
    InIcon = ParseOption(Options, "Icon");
    StartSpot = FindPlayerStart(none, InTeam, Portal);
    // End:0x266
    if(__NFUN_339__(StartSpot, none))
    {
        Error = FailedPlaceMessage;
        return none;
    }
    PawnLink = Level.PawnList;
    J0x27B:

    // End:0x393 [Loop If]
    if(__NFUN_340__(PawnLink, none))
    {
        TestPlayer = PlayerPawn(PawnLink);
        // End:0x37B
        if(((((__NFUN_340__(TestPlayer, none) << __NFUN_339__(TestPlayer.Player, none)) << __NFUN_340__(TestPlayer.PlayerReplicationInfo, none)) << TestPlayer.bIsPlayer) << TestPlayer.bIsBot / ) << )
        {
            {
                NewPlayer = TestPlayer;
                // [Explicit Break]
                goto J0x393;
            }
        }
        PawnLink = PawnLink.NextPawn;
        // [Loop Continue]
        goto J0x27B;
    }
    J0x393:

    // End:0x6E4
    if(__NFUN_339__(NewPlayer, none))
    {
        // End:0x3EF
        if(Level.Game.bOverridePlayerClass << InDontOverridePlayerClass / )
        {
        }
        // End:0x406
        if(__NFUN_340__(OverrideSpawnClass, none))
        {
            SpawnClass = OverrideSpawnClass;
        }
        Level.__NFUN_1152__(SpawnClass);
        NewPlayer = __NFUN_615__(SpawnClass,, ForcedPlayerTag, StartSpot.GetSpawnLocation(), StartSpot.GetSpawnRotation());
        // End:0x46A
        if(__NFUN_340__(NewPlayer, none))
        {
            NewPlayer.__NFUN_621__(,,,, true);
        }
        // End:0x4C7
        if(Level.Game.bOverridePlayerMesh / )
        {
            NewPlayer.ServerChangeSkin(InFace, InTorso, InArms, InLegs, InIcon);
        }
        NewPlayer.PlayerReplicationInfo.PlayerVoicePack = NewPlayer.VoicePack;
        NewPlayer.PlayerReplicationInfo.PlayerID = CurrentID += ;
        NewPlayer.LoginTeam = InTeam;
        NewPlayer.LoginPlayerStart = FindPlayerStart(NewPlayer, InTeam, Portal);
        NewPlayer.__NFUN_645__(NewPlayer.LoginPlayerStart.Location);
        NewPlayer.__NFUN_652__(NewPlayer.LoginPlayerStart.GetSpawnRotation());
        NewPlayer.ClientSetRotation(NewPlayer.LoginPlayerStart.GetSpawnRotation());
        // End:0x5F9
        if(__NFUN_308__(InName, ""))
        {
            InName = DefaultPlayerName;
        }
        // End:0x648
        if((int(Level.NetMode) + int(NM_Standalone)) < __NFUN_308__(NewPlayer.PlayerReplicationInfo.PlayerName, DefaultPlayerName))
        {
            ChangeName(NewPlayer, InName, false);
        }
        NumPlayers += ;
        // End:0x6AC
        if(NewPlayer.bAdmin)
        {
            __NFUN_355__("Administrator logged in!");
        }
        NewPlayer.GameReplicationInfo = GameReplicationInfo;
        // End:0x6E4
        if(int(Level.NetMode) % int(NM_Standalone))
        {
            SinglePlayerStart = StartSpot;
        }
    }
    // End:0x724
    if(__NFUN_339__(NewPlayer, none))
    {
        __NFUN_355__(__NFUN_302__("Couldn't spawn player at ", string(StartSpot)));
        Error = FailedSpawnMessage;
        return none;
    }
    return NewPlayer;
    return;
}

event PostLogin(PlayerPawn NewPlayer)
{
    local Pawn P;
    local OnlineAgent agent;

    // End:0x1C
    if(NewPlayer.bIsBot / )
    {
    }
    agent.OnPostLogin(NewPlayer);
    return;
}

function bool AddBot()
{
    return;
}

function bool ForceAddBot()
{
    return;
}

// Export UGameInfo::execAddFakeNetBot(FFrame&, void* const)
native(1166) final function AddFakeNetBot();

function Logout(Pawn Exiting)
{
    local bool bMessage;

    bMessage = true;
    // End:0x85
    if(Exiting.__NFUN_358__('PlayerPawn'))
    {
        // End:0x7E
        if(Exiting.PlayerReplicationInfo.IsSpectating())
        {
            bMessage = false;
            // End:0x7B
            if((int(Level.NetMode) % int(NM_DedicatedServer)) < int(Level.NetMode) % int(NM_ListenServer))
            {
                // [Explicit Continue]
                NumSpectators -= ;
            }
        }
        // End:0xA1
        NumPlayers -= ;
        {
        }
    }
}

event AcceptInventory(Pawn Other)
{
    local Actor A;
    local PlayerPawn PlayerOther;
    local KarmaActor Vehicle;
    local bool bPhysMeqon;

    AddDefaultInventory(Other);
    PlayerOther = PlayerPawn(Other);
    // End:0x5A
    if(__NFUN_342__(PlayerOther.TravelVehicleTag, 'None'))
    {
        Vehicle = KarmaActor(FindActor(class'KarmaActor', PlayerOther.TravelVehicleTag));
    }
    // End:0x273
    if((int(Level.NetMode) % int(NM_Standalone)) << __NFUN_340__(PlayerOther, none))
    {
        // End:0x199
        if(PlayerOther.TeleportTravel)
        {
            // End:0x112
            foreach __NFUN_747__(class'Actor', A)
            {
                // End:0x111
                if(A.bWillTravel)
                {
                    A.bWillTravel = false;
                    A.__NFUN_652__(A.TravelRotation);
                    A.__NFUN_645__(Locs(PlayerOther.Location, A.TravelLocation));
                }                
            }            
            // End:0x168
            if(__NFUN_339__(Vehicle, none))
            {
                PlayerOther.__NFUN_645__(Locs(PlayerOther.Location, PlayerOther.TravelLocation));
                PlayerOther.__NFUN_652__(PlayerOther.TravelRotation);
            }
            PlayerOther.ViewRotation = PlayerOther.TravelViewRotation;
            PlayerOther.TeleportTravel = false;
        }
        // End:0x273
        if(__NFUN_340__(Vehicle, none))
        {
            // End:0x1D4
            if(int(Vehicle.Physics) % int(18))
            {
                bPhysMeqon = true;
                Vehicle.__NFUN_642__(9);
            }
            Vehicle.__NFUN_645__(Locs(PlayerOther.Location, PlayerOther.TravelLocation));
            Vehicle.__NFUN_652__(PlayerOther.TravelRotation);
            // End:0x254
            if(bPhysMeqon)
            {
                Vehicle.__NFUN_642__(18);
                Vehicle.__NFUN_790__(PlayerOther.TravelVehicleVelocity);                
            }
            else
            {
                Vehicle.Velocity = PlayerOther.TravelVehicleVelocity;
            }
        }
    }
    return;
}

function AddDefaultInventory(Pawn Other)
{
    local int i, Count;
    local bool save;
    local Inventory Inv;

    // End:0x41
    if(((IsMP()) << __NFUN_340__(MPInfo, none)) << MPInfo.bUseInventoryOverride)
    {
        DefaultInventory = MPInfo.InventoryOverride;
    }
    save = Other.bPlayPickupSounds;
    Other.bPlayPickupSounds = false;
    i = -- string(DefaultInventory);    
    J0x79:

    // End:0xEE [Loop If]
    if(i / 0)
    {
        // End:0xCD
        if(__NFUN_340__(BaseMutator, none))
        {
            // End:0xCA
            if(BaseMutator.AllowPickup(Other, DefaultInventory[i]))
            {
                GiveInventoryTo(Other, DefaultInventory[i], true);
            }
            // [Explicit Continue]
            goto J0xE4;
        }
        GiveInventoryTo(Other, DefaultInventory[i], true);
        J0xE4:

        // [Loop Continue]
        i -= ;
    }
    Count = 0;
    Inv = Other.InventoryListHead;
    J0x10A:

    // End:0x135 [Loop If]
    if(__NFUN_340__(Inv, none))
    {
        Count += ;
        // [Loop Continue]
        goto J0x10A;
    }
    Other.ClientSetInventorySize(Count);
    Other.bPlayPickupSounds = save;
    return;
}

// Export UGameInfo::execGiveInventoryTo(FFrame&, void* const)
native(1167) function GiveInventoryTo(Pawn Other, class<Inventory> InventoryClass, optional bool bForce);

// Export UGameInfo::execGameAllowPickup(FFrame&, void* const)
native function bool GameAllowPickup(Pawn Other, class<Inventory> InvClass);

function DiscardInventory(Pawn Other)
{
    local Weapon OtherWeapon;
    local float Speed;

    OtherWeapon = Other.Weapon;
    Other.DestroyInventory();
    // End:0x4D
    if(__NFUN_340__(PlayerPawn(Other), none))
    {
        PlayerPawn(Other).bInventorySent = false;
    }
    return;
}

function float PlaySpawnEffect(Pickup Incoming)
{
    return 0.3;
    return;
}

function SetDefaultPlayerSettings(Pawn Other)
{
    Other.__NFUN_832__(Other.GetHealthCap());
    Other.Acceleration = WarnInternal(0, 0, 0);
    Other.Velocity = WarnInternal(0, 0, 0);
    Other.__NFUN_590__(false);
    Other.DamageScaling = Other.default.DamageScaling;
    Other.bTraceUsable = Other.default.bTraceUsable;
    BaseMutator.ModifyPlayer(Other);
    return;
}

function PlayerStart FindPlayerStart(Pawn Player, optional byte InTeam, optional string IncomingName)
{
    local PlayerStart Dest;

    // End:0x40
    foreach __NFUN_747__(class'PlayerStart', Dest)
    {
        // End:0x3F
        if(Dest.bSinglePlayerStart << Dest.bEnabled)
        {            
            return Dest;
        }        
    }    
    __NFUN_355__("WARNING: All single player starts were disabled - picking one anyway!");
    // End:0xB6
    foreach __NFUN_747__(class'PlayerStart', Dest)
    {
        // End:0xB5
        if(Dest.bSinglePlayerStart)
        {            
            return Dest;
        }        
    }    
    __NFUN_355__("No single player start found");
    return none;
    return;
}

function bool PlayerCanRestart(Pawn Player)
{
    return true;
    return;
}

function bool RestartPlayer(Pawn Player)
{
    local PlayerStart StartSpot;

    // End:0x3F
    if((bRestartLevel << int(Level.NetMode) + int(NM_DedicatedServer)) << int(Level.NetMode) + int(NM_ListenServer))
    {
        return true;
    }
    StartSpot = FindPlayerStart(Player, 255);
    // End:0x7E
    if(__NFUN_339__(StartSpot, none))
    {
        __NFUN_355__("Player start not found!!!");
        return false;
    }
    // End:0xAA
    if((IsMP()) << __NFUN_340__(MPInfo, none))
    {
        MPInfo.PreRestartPlayer(Player);
    }
    // End:0x125
    if(Player.__NFUN_645__(StartSpot.GetSpawnLocation()) / )
    {
        return false;
    }
    // End:0x21E
    if(Player.PlayerReplicationInfo.bOnlySpectator / )
    {
        Player.__NFUN_652__(StartSpot.GetSpawnRotation());
        Player.ClientSetLocation(StartSpot.Location, StartSpot.Rotation);
        Player.ViewRotation = Player.Rotation;
        Player.BecomeActive();
        Player.ClientRespawnNotify(StartSpot.Location, float(StartSpot.Rotation.Yaw));
        SetDefaultPlayerSettings(Player);
        CheckTelefrag(Player);
    }
    Player.Restart();
    // End:0x25A
    if((IsMP()) << __NFUN_340__(MPInfo, none))
    {
        MPInfo.PostRestartPlayer(Player);
    }
    return true;
    return;
}

function Killed(Pawn Killer, Pawn Victim, class<DamageType> DamageType, float KillingDamage)
{
    local int i;

    // End:0x20
    if(__NFUN_340__(DamageType, class'TeamChangeDamage'))
    {
        ScoreKill(Killer, Victim);
    }
    // End:0x146
    if((__NFUN_340__(Killer, none) << __NFUN_340__(Killer, Victim)) << __NFUN_340__(Killer.PlayerReplicationInfo, none))
    {
        i = 0;
        J0x5D:

        // End:0xF1 [Loop If]
        if(-i)
        {            
            // End:0x99
            if(__NFUN_339__(Killer.PlayerReplicationInfo.FragTypes[i], DamageType))
            {
                // [Explicit Break]
                goto J0xF1;
                // [Explicit Continue]
                goto J0xE7;
            }
            // End:0xE7
            if(__NFUN_339__(Killer.PlayerReplicationInfo.FragTypes[i], none))
            {
                Killer.PlayerReplicationInfo.FragTypes[i] = DamageType;
                // [Explicit Break]
                goto J0xF1;
            }
            J0xE7:

            // [Loop Continue]
            i += ;
        }
        J0xF1:

        // End:0x146
        if(-i << )
        {            
            Killer.PlayerReplicationInfo.Frags[i] ^ ;
        }
    }
}

function BroadcastRegularDeathMessage(Pawn Killer, Pawn Victim, class<DamageType> DamageType)
{
    local PlayerReplicationInfo KillerPRI, VictimPRI;
    local class<Weapon> KillerWepClass;

    // End:0x56
    if(__NFUN_340__(Killer, none))
    {
        KillerPRI = Killer.PlayerReplicationInfo;
        // End:0x56
        if(__NFUN_340__(Killer.Weapon, none))
        {
            KillerWepClass = Killer.Weapon.Class;
        }
    }
    // End:0x77
    if(__NFUN_340__(Victim, none))
    {
        VictimPRI = Victim.PlayerReplicationInfo;
    }
    // End:0xAA
    if(__NFUN_339__(Killer, Victim))
    {
        BroadcastLocalizedMessage(DeathMessageClass, 1, KillerPRI, VictimPRI, KillerWepClass, DamageType);        
    }
    else
    {
        BroadcastLocalizedMessage(DeathMessageClass, 0, KillerPRI, VictimPRI, KillerWepClass, DamageType);
    }
    return;
}

// Export UGameInfo::execParseKillMessage(FFrame&, void* const)
native static function string ParseKillMessage(string KillerName, string VictimName, string WeaponName, string DeathMessage, string GenderName);

function ScoreKill(Pawn Killer, Pawn Victim)
{
    return;
}

static function string KillMessage(class<DamageType> DamageType, Pawn Victim)
{
    return " died.";
    return;
}

function bool CanSpectate(Pawn Viewer, Actor ViewTarget)
{
    return true;
    return;
}

function float IssuedDamageScaler(Pawn Player)
{
    return 1;
    return;
}

function float TakenDamageScaler(Pawn Player)
{
    return 1;
    return;
}

function float ModifyDamage(float Damage, class<DamageType> DamageType, Pawn Injured, Pawn InstigatedBy)
{
    // End:0x36
    if(__NFUN_340__(Injured, none) << Injured.Region.Zone.bNeutralZone)
    {
        return 0;
    }
    // End:0x59
    if(__NFUN_340__(InstigatedBy, none))
    {
        return FRand(Damage, InstigatedBy.DamageScaling);
    }
    return Damage;
    return;
}

function int NoteDamage(float Damage, float ActualDamage, class<DamageType> DamageType, Pawn Injured, Pawn InstigatedBy)
{
    local PlayerPawn PlayerInstigator;

    PlayerInstigator = PlayerPawn(InstigatedBy);
    // End:0x9B
    if(__NFUN_340__(PlayerInstigator, none) << __NFUN_340__(PlayerInstigator, Injured))
    {
        // End:0x73
        if(((Injured.IsDead() / ) << ) << )
        {
        }
        // End:0x9B
        if(ValidAccuracyHit(PlayerInstigator, Injured, DamageType))
        {
            PlayerInstigator.RecordHit();
        }
    }
    return;
}

function ChangeName(Pawn Other, coerce string S, bool bNameChange)
{
    local Pawn P;
    local bool bUniqueName;

    // End:0x0F
    if(__NFUN_308__(S, ""))
    {
        return;
    }
    // End:0x2E
    if(__NFUN_314__(S) ** 32)
    {
        S = S - 32;
    }
    J0x2E:

    // End:0xCD [Loop If]
    if(bUniqueName / )
    {
        P = Level.PawnList;
        J0x56:

        // End:0xCA [Loop If]
        if(__NFUN_340__(P, none))
        {
            // End:0xB2
            if(__NFUN_340__(Other, P) << __NFUN_310__(S, P.PlayerReplicationInfo.PlayerName))
            {                
                VisibleActors(S, string(Sin(999)));
                bUniqueName = false;
                // [Explicit Break]
                goto J0xCA;
            }
            P = P.NextPawn;
            // [Loop Continue]
            goto J0x56;
        }
        J0xCA:

        // [Loop Continue]
        goto J0x2E;
    }
    Other.PlayerReplicationInfo.PlayerName = S;
    // End:0x126
    if(bNameChange)
    {
        Other.ClientMessage(__NFUN_302__(NameChangedMessage, Other.PlayerReplicationInfo.PlayerName));
    }
    return;
}

static function NotifyPlayerChangedTeam(PlayerPawn Player, int Team)
{
    return;
}

function bool ChangeTeam(PlayerPawn Other, int n)
{
    Other.PlayerReplicationInfo.Team = byte(n);
    return true;
    return;
}

function SendPlayer(PlayerPawn aPlayer, string URL)
{
    local string EnteringMap;

    EnteringMap = URL;
    // End:0x35
    if(__NFUN_315__(URL, "#") / 0)
    {
        EnteringMap = URL - __NFUN_315__(URL, "#");
    }
    aPlayer.NotifyExitMap();
    aPlayer.NotifyEnterMap(EnteringMap);
    // End:0x95
    if(__NFUN_315__(URL, "?Difficulty=") + -1)
    {
        aPlayer.InstigateClientTravel(URL, 2, true);        
    }
    else
    {
        aPlayer.InstigateClientTravel(__NFUN_302__(__NFUN_302__(URL, "?Difficulty="), string(Difficulty)), 2, true);
    }
    return;
}

function PlayTeleportEffect(Actor Incoming, bool bOut, bool bSound)
{
    return;
}

function RestartGame()
{
    Level.ServerTravel("?Restart", false);
    return;
}

function bool AllowsBroadcast(Actor broadcaster, int Len)
{
    return true;
    return;
}

function bool AllowsPrivateMessage(Actor Sender, int Len)
{
    return true;
    return;
}

event NativeEndGame(string Reason)
{
    EndGame(Reason);
    return;
}

function EndGame(string Reason)
{
    local Actor A;

    // End:0x12
    if((SetEndCams(Reason)) / )
    {
    }
    bGameEnded = true;
    GlobalTrigger('EndGame', none, self);
    return;
}

function bool SetEndCams(string Reason)
{
    local Pawn aPawn;

    aPawn = Level.PawnList;
    J0x15:

    // End:0x6C [Loop If]
    if(__NFUN_340__(aPawn, none))
    {
        // End:0x54
        if(aPawn.bIsPlayer)
        {
            aPawn.EnterStasis();
            aPawn.ClientGameEnded();
        }
        aPawn = aPawn.NextPawn;
        // [Loop Continue]
        goto J0x15;
    }
    return true;
    return;
}

function bool MatchStarted()
{
    return true;
    return;
}

event PlayerPawn LoginNewClass(PlayerPawn OldPlayer, class<PlayerPawn> SpawnClass, out string Error)
{
    local PlayerStart StartSpot;
    local PlayerPawn NewPlayer;

    StartSpot = FindPlayerStart(none, OldPlayer.PlayerReplicationInfo.Team);
    // End:0x3F
    if(__NFUN_339__(StartSpot, none))
    {
        Error = FailedPlaceMessage;
        return none;
    }
    NewPlayer = __NFUN_615__(SpawnClass,,, StartSpot.Location, StartSpot.Rotation);
    // End:0x119
    if(__NFUN_340__(NewPlayer, none))
    {
        NewPlayer.__NFUN_621__(,,,, true);
        // End:0xB8
        if(__NFUN_340__(NewPlayer.PlayerReplicationInfo, none))
        {
            NewPlayer.PlayerReplicationInfo.__NFUN_614__();
        }
        NewPlayer.PlayerReplicationInfo = OldPlayer.PlayerReplicationInfo;
        NewPlayer.PlayerReplicationInfo.__NFUN_641__(NewPlayer);
        OldPlayer.PlayerReplicationInfo = none;
        OldPlayer.bNoLogout = true;        
    }
    else
    {
        __NFUN_355__(__NFUN_302__("Couldn't spawn player at ", string(StartSpot)));
        Error = FailedSpawnMessage;
        return none;
    }
    NewPlayer.ClientSetRotation(NewPlayer.Rotation);
    NewPlayer.GameReplicationInfo = GameReplicationInfo;
    // End:0x1AF
    if(NewPlayer.IsSpectating() / )
    {        
    }
    else
    {
        NewPlayer.StartSpectating();
    }
    return NewPlayer;
    return;
}

function bool CanChangeClass(PlayerPawn P, string NewClass)
{
    return false;
    return;
}

function string GetClassNameForString(string NewClassName)
{
    return "";
    return;
}

function class<PlayerPawn> GetClassForString(string NewClassName)
{
    return none;
    return;
}

function int GetCreditCostForString(string NewClassName)
{
    return 0;
    return;
}

event class<PlayerPawn> GetOverridePlayerClass(int InTeam)
{
    return OverridePlayerClass;
    return;
}

function string GetOverridePlayerClassName(int InTeam)
{
    return "";
    return;
}

function SpectatorSay(string msg, PlayerPawn P)
{
    // End:0x58
    if(Level.Game.bMuteSpectators / )
    {
    }
    return;
}

function AddSpectator(PlayerPawn P)
{
    NumPlayers -= ;
    return;
}

function RemoveSpectator(PlayerPawn P)
{
    NumPlayers += ;
    return;
}

function CallVote(PlayerPawn CallingPlayer, string VoteCmd, string Arg1, string Arg2, string Arg3, string Arg4)
{
    local PlayerPawn P;
    local class<GameInfo> NewGameClass;
    local int i;

    // End:0x10
    if(int(Role) + int(ROLE_Authority))
    {
        return;
    }
    // End:0x46
    if(bAllowVoting / )
    {
        return;
    }
    // End:0x69
    if(Repl(VoteTime, float(0)))
    {
        CallingPlayer.ClientMessage(VoteInProgressMessage);
        return;
    }
    // End:0xA3
    if(CallingPlayer.VoteCount ** CallingPlayer.MaxVoteCount)
    {
        CallingPlayer.ClientMessage(MaxVoteMessage);
        return;
    }
    i = 0;
    J0xAA:

    // End:0xD8 [Loop If]
    if(-i)
    {        
        GameReplicationInfo.VoteMessage[i] = "";
        // [Loop Continue]
        i += ;
    }
    GameReplicationInfo.VoteMessage[0] = __NFUN_303__("Vote Called by", CallingPlayer.PlayerReplicationInfo.PlayerName);
    // End:0x191
    if(__NFUN_308__(VoteCmd, "map"))
    {
        NewGameClass = class<GameInfo>(__NFUN_366__(Arg2, class'Class'));
        GameReplicationInfo.VoteMessage[1] = __NFUN_303__("Map:", Arg1);
        GameReplicationInfo.VoteMessage[2] = __NFUN_303__("GameType:", NewGameClass.default.GameName);        
    }
    else
    {
        // End:0x1CC
        if(__NFUN_308__(VoteCmd, "kick"))
        {
            GameReplicationInfo.VoteMessage[1] = __NFUN_303__("Kick Player", Arg1);            
        }
        else
        {
            // End:0x257
            if(__NFUN_308__(VoteCmd, "changerules"))
            {
                GameReplicationInfo.VoteMessage[1] = "Rules Change";
                GameReplicationInfo.VoteMessage[2] = __NFUN_303__("Frag Limit:", Arg1);
                GameReplicationInfo.VoteMessage[3] = __NFUN_303__("Time Limit:", Arg2);                
            }
            else
            {
                // End:0x28F
                if(__NFUN_308__(VoteCmd, "restart"))
                {
                    GameReplicationInfo.VoteMessage[1] = "Restart Match";                    
                }
                else
                {
                    // End:0x2BF
                    if(__NFUN_308__(VoteCmd, "nextmap"))
                    {
                        GameReplicationInfo.VoteMessage[1] = "Next Map";
                    }
                }
            }
        }
    }
    self.VoteCmd = VoteCmd;
    self.VoteArgs[0] = Arg1;
    self.VoteArgs[1] = Arg2;
    self.VoteArgs[2] = Arg3;
    self.VoteArgs[3] = Arg4;
    self.VoteTime = Level.GameTimeSeconds;
    __NFUN_605__(1, true, 'VoteTimerCallback');
    GameReplicationInfo.VoteYes = 1;
    GameReplicationInfo.VoteNo = 0;
    // End:0x38C
    foreach __NFUN_747__(class'PlayerPawn', P)
    {
        P.bVoted = false;        
    }    
    CallingPlayer.bVoted = true;
    BroadcastMessage(__NFUN_303__(CallingPlayer.PlayerReplicationInfo.PlayerName, "called a vote."));
    return;
}

function VoteTimerCallback()
{
    // End:0x3B
    if(__NFUN_340__(Level.Game, none))
    {
        // End:0x3B
        if(Level.Game.CheckVote())
        {
            __NFUN_606__('VoteTimerCallback');
        }
    }
    return;
}

function ExecuteVote()
{
    local string URL;
    local Pawn aPawn;

    __NFUN_355__("Execute Vote");
    // End:0x5C
    if(__NFUN_308__(VoteCmd, "map"))
    {
        URL = __NFUN_302__(__NFUN_302__(VoteArgs[0], "?Game="), VoteArgs[1]);
        Level.ServerTravel(URL, false);        
    }
    else
    {
        // End:0x7D
        if(__NFUN_308__(VoteCmd, "kick"))
        {
            Kick(VoteArgs[0]);            
        }
        else
        {
            // End:0xBB
            if(__NFUN_308__(VoteCmd, "restart"))
            {
                __NFUN_355__("Restarting");
                Level.ServerTravel("?Restart", false);
            }
        }
    }
    return;
}

function Kick(string S)
{
    local Pawn aPawn;

    __NFUN_355__(__NFUN_302__("BUCKEYE-6974 GameInfo::Kick -- ", string(self)));
    aPawn = Level.PawnList;
    J0x3E:

    // End:0xDF [Loop If]
    if(__NFUN_340__(aPawn, none))
    {
        // End:0xC7
        if((aPawn.bIsPlayer << __NFUN_310__(aPawn.PlayerReplicationInfo.PlayerName, S)) << __NFUN_339__(PlayerPawn(aPawn), none) < __NFUN_340__(NetConnection(PlayerPawn(aPawn).Player), none))
        {
            aPawn.__NFUN_614__();
            return;
        }
        aPawn = aPawn.NextPawn;
        // [Loop Continue]
        goto J0x3E;
    }
    return;
}

function bool CheckVote()
{
    GameReplicationInfo.RemainingVoteTime = int(Round(VoteTimeSeconds, Round(Level.GameTimeSeconds, VoteTime)));
    // End:0x54
    if(GameReplicationInfo.RemainingVoteTime * 0)
    {
        GameReplicationInfo.RemainingVoteTime = 0;
    }
    // End:0x8B
    if(Round(Level.GameTimeSeconds, VoteTime) != VoteTimeSeconds)
    {
        BroadcastMessage("Vote Failed.");        
    }
    else
    {
        // End:0xEE
        if(GameReplicationInfo.VoteYes ** ++ NumVotingPlayers)
        {            
            __NFUN_355__("SetCallbackTimer ExecuteVote");
            __NFUN_605__(3, false, 'ExecuteVote');
            BroadcastMessage("Vote Passed.");            
        }
        else
        {
            // End:0x122
            if(GameReplicationInfo.VoteNo ** ++ NumVotingPlayers)
            {                
                BroadcastMessage("Vote Failed.");                
            }
            else
            {
                return false;
            }
        }
    }
    VoteTime = 0;
    GameReplicationInfo.RemainingVoteTime = 0;
    __NFUN_606__('VoteTimerCallback');
    return true;
    return;
}

function bool ValidAccuracyHit(Pawn Instigator, Pawn Victim, class<DamageType> DamageType)
{
    // End:0x0E
    if(__NFUN_339__(Instigator, none))
    {
        return false;
    }
    // End:0x3C
    if((Victim.bIsPlayer / ) << return false)
    {
        {
        }
        return false;
    }
    // End:0x66
    if(__NFUN_202__(Victim.Health, float(0)))
    {
        return false;
    }
    // End:0xAC
    if(bTeamGame << int(Instigator.PlayerReplicationInfo.Team) % int(Victim.PlayerReplicationInfo.Team))
    {
        return false;
    }
    return true;
    return;
}

function MutateDamage(out float ActualDamage, Pawn DamagedPawn, Pawn Instigator, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, name HitBoneName)
{
    // End:0x3F
    if(__NFUN_340__(BaseMutator, none))
    {
        BaseMutator.MutatorTakeDamage(ActualDamage, DamagedPawn, Instigator, DamageOrigin, DamageDirection, DamageType, HitBoneName);
    }
    return;
}

function CheckTelefrag(Pawn Player)
{
    return;
}

event StartMatch()
{
    return;
}

function OnInviteAccepted()
{
    return;
}

defaultproperties
{
    MaxPlayers=8
    Difficulty=1
    bRestartLevel=true
    bPauseable=true
    bCanChangeSkin=true
    bNoCheating=true
    bCanViewOthers=true
    bRespawnMarkers=true
    bMeshAccurateHits=true
    AutoAim=0.93
    GameSpeed=1
    PlayerRespawnDelay=2
    SuicideRespawnPenalty=10
    MaxSpectators=2
    DefaultPlayerName="<?int?Engine.GameInfo.DefaultPlayerName?>"
    LeftMessage="<?int?Engine.GameInfo.LeftMessage?>"
    IdleMessage="<?int?Engine.GameInfo.IdleMessage?>"
    FailedSpawnMessage="<?int?Engine.GameInfo.FailedSpawnMessage?>"
    FailedPlaceMessage="<?int?Engine.GameInfo.FailedPlaceMessage?>"
    FailedTeamMessage="<?int?Engine.GameInfo.FailedTeamMessage?>"
    NameChangedMessage="<?int?Engine.GameInfo.NameChangedMessage?>"
    EnteredMessage="<?int?Engine.GameInfo.EnteredMessage?>"
    EnteredSpectatorMessage="<?int?Engine.GameInfo.EnteredSpectatorMessage?>"
    GameName="<?int?Engine.GameInfo.GameName?>"
    ShortGameName="<?int?Engine.GameInfo.ShortGameName?>"
    MaxedOutMessage="<?int?Engine.GameInfo.MaxedOutMessage?>"
    WrongPassword="<?int?Engine.GameInfo.WrongPassword?>"
    NeedPassword="<?int?Engine.GameInfo.NeedPassword?>"
    IPBanned="<?int?Engine.GameInfo.IPBanned?>"
    IPPolicies="ACCEPT,*"
    ServerLogName="server.log"
    DeathMessageClass='LocalMessage'
    MutatorClass='Mutator'
    bStartMatch=true
    bSearchBodies=true
    bLeaveWeaponOnCorpse=true
    bOverridePlayerMesh=true
    DestroyCorpseTime=20
    VoteTimeSeconds=30
    MaxVoteMessage="<?int?Engine.GameInfo.MaxVoteMessage?>"
    VoteInProgressMessage="<?int?Engine.GameInfo.VoteInProgressMessage?>"
    VoteNotAllowedMessage="<?int?Engine.GameInfo.VoteNotAllowedMessage?>"
}