/*******************************************************************************
 * GearboxEngineGlobals generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class GearboxEngineGlobals extends Object
    native;

cpptext
{
// Stripped
}

struct DeferredPickupStruct
{
    var class<Pickup> PickupClass;
    var int PickupCharge;
    var Vector Location;
    var Rotator Rotation;
    var Vector KImpulse;
    var float DrawScale;
    var int FrameIndex;
};

struct DeferredGibCallbackStruct
{
    var CorpseBase CallbackCorpse;
    var int Index;
    var int FrameIndex;
    var bool ShouldDestroyCorpseAfter;
};

struct DeferredPhysicsStruct
{
    var int Count;
    var Actor TheActor;
};

var(Globals) float TimeBetweenAssaultCaptainRockets;
var(Globals) int MaxAssaultCaptainRocketsPerFrame;
var(Globals) float TimeBetweenExitWounds;
var(Globals) int MaxExitWoundsPerFrame;
var transient int FrameIndex;
var private transient float LastAssaultCaptainRocketTime;
var private transient int AssaultCaptainRocketsThisFrame;
var private transient float LastExitWoundTime;
var private transient int ExitWoundsThisFrame;
var transient array<DeferredPickupStruct> DeferredPickups;
var transient array<KarmaActor> DeferredMeqonSynchronizes;
var transient array<DeferredGibCallbackStruct> DeferredCallbackGibs;
var transient array<DeferredPhysicsStruct> DeferredSetPhysicsActors;

// Export UGearboxEngineGlobals::execAssaultCaptainCanFireRealShotNow(FFrame&, void* const)
native final function bool AssaultCaptainCanFireRealShotNow(Actor TheAssaultCaptain);

// Export UGearboxEngineGlobals::execCanDoExitWoundNow(FFrame&, void* const)
native final function bool CanDoExitWoundNow(Actor Victim);

// Export UGearboxEngineGlobals::execRequestDeferredWeaponPickup(FFrame&, void* const)
native final function RequestDeferredWeaponPickup(class<Pickup> PickupClass, int PickupCharge, Vector Location, Rotator Rotation, optional Vector KImpulse, optional float DrawScale);

// Export UGearboxEngineGlobals::execRequestDeferredGibCallback(FFrame&, void* const)
native final function RequestDeferredGibCallback(CorpseBase CallbackCorpse, int Index, bool ShouldDestroyCorpseAfter);

defaultproperties
{
    TimeBetweenAssaultCaptainRockets=0.1
    MaxAssaultCaptainRocketsPerFrame=1
    TimeBetweenExitWounds=1
    MaxExitWoundsPerFrame=1
}