/*******************************************************************************
 * HUD generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class HUD extends InfoActor
    abstract
    native
    collapsecategories
    notplaceable
    dependson(Player)
    dependson(Console)
    dependson(TriggerHint)
    dependson(WeaponPickup)
    dependson(HUDIconTable);

cpptext
{
// Stripped
}

const kNumHUDMessages = 11;
const HUDMessageHint = 0;
const HUDMessageWeaponPickup = 1;
const HUDMessageCheckpoint = 2;
const HUDMessageLevelAction = 3;
const HUDMessageHintSecondary = 4;
const HUDMessageDialog = 5;
const HUDMessageLeveling = 6;
const HUDMessageRespawn = 7;
const HUDMessageCustomization = 8;
const HUDMessageDigsMoreInfo = 9;
const HUDMessageAutoRespawn = 10;

enum ETextHorizontalAlign
{
    THA_Left,
    THA_Right,
    THA_Center
};

enum ETextVerticalAlign
{
    TVA_Top,
    TVA_Bottom,
    TVA_Center
};

struct HUDLocalizedMessage
{
    var class<LocalMessage> Message;
    var int Switch;
    var PlayerReplicationInfo RelatedPRI;
    var Object OptionalObject;
    var float EndOfLife;
    var float Lifetime;
    var bool bDrawing;
    var bool bIcon;
    var int numLines;
    var string StringMessage;
    var Color DrawColor;
    var float XL;
    var float YL;
    var float YPos;
};

struct HUDScrollingMessage
{
    var string Message;
    var Color DrawColor;
    var float ScreenX;
    var float ScreenY;
    var float VelX;
    var float VelY;
    var float Lifetime;
    var float FadeTime;
    var float Time;
    var bool bVertCenterTextAlign;
    var bool bHoriCenterTextAlign;
    var bool bNotDrawn;
    var bool bChallengeUnlocked;
    var bool bShownEffect;
};

struct HUDDisplayMessage
{
    var noexport bool bUserDisabled "If true, the user has disabled this message through a menu option.";
    var noexport bool bDropShadow "If true, this message will be drawn with a drop shadow.";
    var noexport bool bRenderInPause "If true, this message will be drawn even when the game is paused.";
    var noexport bool bRenderWhileDead "If true, this message will be drawn even when the player is dead.";
    var noexport Font Font "Font to use for this message.";
    var noexport Color DrawColor "Color to use for this message.";
    var noexport float Scale "Scale to apply to this message.";
    var noexport Actor.EHUDAnchor Anchor "Defines where message will be anchored on the HUD.";
    var noexport float XPos "Horizontal adjustment for anchor point.";
    var noexport float YPos "Vertical adjustment for anchor point.";
    var noexport HUD.ETextHorizontalAlign HAlign "Horizontal alignment of message relative to adjusted anchor point.";
    var noexport HUD.ETextVerticalAlign VAlign "Vertical alignment of message relative to adjusted anchor point.";
    var noexport HUD.ETextHorizontalAlign LineHAlign "When wrapping is enabled, this is the horizontal alignment to apply to the individual lines.";
    var noexport float WrapXL "When > 0, this is the max width of a message before it needs to wrap.";
    var noexport float FadeInRate "Rate at which Alpha increases toward TargetAlpha when fading in.";
    var noexport float FadeOutRate "Rate at which Alpha increases toward TargetAlpha when fading out.";
    var noexport float HoldTime "Amount of time to display message after it has completely faded in.";
    var string Message;
    var float Alpha;
    var float TargetAlpha;
    var float HoldTimer;
    var MaterialEx Icon;
    var float IconXL;
    var float IconYL;
};

struct SHUDParsedDisplayMessage
{
    var array<string> Message;
    var float XPos;
    var float YPos;
    var float XL;
    var float YL;
};

struct SHUDDirectionalIndicator
{
    var() noexport bool bNoAutoRotate "Set to true if you don't want to rotate.";
    var() noexport float TotalLifetime "Amount of time left for this damage indicator to be displayed.";
    var() noexport float XScale "Scale to use for X.";
    var() noexport float YScale "Scale to use for Y.";
    var() noexport float CircleRadius "Distance from center of screen where this indicator will be drawn.";
    var() noexport float BaseRot "Base rotation (radians).";
    var() noexport Vector WorldPos "Worldspace location where the damage originated.";
    var() noexport MaterialEx Texture "Material to use for this indicator.";
    var() noexport Color Color "Color to use for colorization of this indicator.";
    var float RemainingLife;
};

struct SHUDDebugTreeItem
{
    var string Text;
    var string ConsoleCommand;
    var name TriggerEvent;
    var name Func;
    var bool Pop;
    var bool Push;
    var bool bHideChildren;
    var int var1;
    var float var2;
    var int MaxVisibleChildren;
    var int ChildrenOffset;
};

var const int DefaultResX;
var const int DefaultResY;
var bool bHideCrosshair;
var() string HUDConfigWindowType;
var PlayerPawn PlayerOwner;
var float HUDScaleX;
var float HUDScaleY;
var float CenterXL;
var float CenterYL;
var float CenterScale;
var float TTFontScale;
var float DefaultDirectionalCircleRadius;
var class<HUDIconTable> IconTable;
var int currentInventoryCategory;
var int currentInventoryItem;
var float InventoryGoAwayDelay;
var float InventoryFadeOutTime;
var bool bIsDrawingUsePhrase;
var Color WhiteColor;
var Color RedColor;
var Color LightGreenColor;
var Color DarkGreenColor;
var Color GreenColor;
var Color CyanColor;
var Color UnitColor;
var Color BlueColor;
var Color GoldColor;
var Color PurpleColor;
var Color TurqColor;
var Color GrayColor;
var Color FaceColor;
var Color LightBlueColor;
var Color DarkBlueColor;
var Color BlackColor;
var Color OrangeColor;
var() Color MainHUDColor;
var() Color DisabledInventoryIconColor;
var() Color ActiveInventoryTextColor;
var int BroadcastLogLineMax;
var string ShortKeyName[259];
var string LongKeyname[259];
var(HUDDisplayMessage) noexport float DisplayMessagePreButtonPadding "Additional padding after text before a button is drawn.";
var(HUDDisplayMessage) noexport float DisplayMessagePostButtonPadding "Additional padding after a button before the next text is drawn.";
var(HUDDisplayMessage) noexport float DisplayMessageGamepadPreButtonPadding "Additional padding after text before a button is drawn.";
var(HUDDisplayMessage) noexport float DisplayMessageGamepadPostButtonPadding "Additional padding after a button before the next text is drawn.";
var(HUDDisplayMessage) noexport float DisplayMessageButtonYAdjust "Adjustment from the standard texture YPos where a button should be drawn.";
var(HUDDisplayMessage) noexport float DisplayMessageGamepadButtonYAdjust "Adjustment from the standard texture YPos where a button should be drawn.";
var(HUDDisplayMessage) noexport float DisplayMessageButtonXL "Width of a display message button.";
var(HUDDisplayMessage) noexport float DisplayMessageButtonYL "Height of a display message button.";
var(HUDDisplayMessage) float DisplayMessageGamepadButtonSize;
var(HUDDisplayMessage) HUDDisplayMessage HUDMessages[11];
var localized string TouchingWeaponMessage;
var localized string TouchingWeaponMessage_MP;
var array<SHUDDebugTreeItem> DebugTreeItems;
var int DebugTreeIndex;
var int DebugTreeUseIndex;
var float DebugTreeBGSizeX;
var float DebugTreeBGSizeY;
var array<SScreenFlash> ScreenFlashes;
var array<HUDScrollingMessage> ScrollingMessages;
var array<SHUDDirectionalIndicator> DirectionalIndicators;
var(HUDHint) noexport MaterialEx HintButtonMaterial "Material to use for the hint button.";
var TriggerHint ActiveHint;
var noexport MaterialEx XboxButtonIcons[26] "Xbox button icons to use with interact key info system.";
var noexport MaterialEx PS3ButtonIcons[26] "PS3 button icons to use with interact key info system.";

function bool OwnerFireDown()
{
    return;
}

function bool OwnerFireUp()
{
    return;
}

function SaveComplete()
{
    return;
}

function CloseInventory()
{
    InventoryGoAwayDelay = 0;
    currentInventoryCategory = 0;
    // End:0x7E
    if((__NFUN_340__(PlayerOwner, none) << __NFUN_340__(PlayerOwner.Player, none)) << __NFUN_340__(PlayerOwner.Player.Console, none))
    {
        PlayerOwner.Player.Console.MouseCapture = false;
    }
    return;
}

function ClearMessage(out HUDLocalizedMessage m)
{
    m.Message = none;
    m.Switch = 0;
    m.RelatedPRI = none;
    m.OptionalObject = none;
    m.EndOfLife = 0;
    m.StringMessage = "";
    m.DrawColor = WhiteColor;
    m.XL = 0;
    m.bDrawing = false;
    m.bIcon = false;
    return;
}

function CopyMessage(out HUDLocalizedMessage M1, HUDLocalizedMessage M2)
{
    M1.Message = M2.Message;
    M1.Switch = M2.Switch;
    M1.RelatedPRI = M2.RelatedPRI;
    M1.OptionalObject = M2.OptionalObject;
    M1.EndOfLife = M2.EndOfLife;
    M1.StringMessage = M2.StringMessage;
    M1.DrawColor = M2.DrawColor;
    M1.XL = M2.XL;
    M1.YL = M2.YL;
    M1.YPos = M2.YPos;
    M1.bDrawing = M2.bDrawing;
    M1.Lifetime = M2.Lifetime;
    M1.numLines = M2.numLines;
    M1.bIcon = M2.bIcon;
    return;
}

function AddScrollingMessageMsg(HUDScrollingMessage Message)
{
    ScrollingMessages[ScrollingMessages.Add(1)] = Message;
    return;
}

function AddScrollingMessage(string Message, float X, float Y, float xv, float yv, Color col, float Lifetime, float FadeTime)
{
    local HUDScrollingMessage msg;

    msg.Message = Message;
    msg.DrawColor = col;
    msg.ScreenX = X;
    msg.ScreenY = Y;
    msg.VelX = xv;
    msg.VelY = yv;
    msg.Lifetime = Lifetime;
    msg.FadeTime = FadeTime;
    AddScrollingMessageMsg(msg);
    return;
}

simulated event PreRender(Canvas Canvas)
{
    CenterXL = float(Canvas.FixedX);
    CenterYL = float(Canvas.FixedY);
    CenterScale = Canvas.FixedScale;
    TTFontScale = CenterScale -= 1;
    HUDScaleX = Canvas.ClipX >>> float(DefaultResX);
    HUDScaleY = Canvas.ClipY >>> float(DefaultResY);
    return;
}

// Export UHUD::execPostRender(FFrame&, void* const)
native simulated function PostRender(Canvas Canvas);

simulated function AddPickupEvent(MaterialEx InvPickupIcon)
{
    return;
}

final simulated function AddMessageToArray(out array<string> ParsedMessage, coerce string Message)
{
    local int i;

    i = ParsedMessage.Add(1);
    ParsedMessage[i] = Message;
    return;
}

// Export UHUD::execFindFirstGamepadBinding(FFrame&, void* const)
native(1180) function int FindFirstGamepadBinding(int SK);

// Export UHUD::execFindFirstPCBinding(FFrame&, void* const)
native(1181) final function int FindFirstPCBinding(int SK);

simulated event string GetLongKeyName(int SK)
{
    local int BindingKey;

    // End:0x24
    if(PlayerOwner.__NFUN_994__())
    {
        BindingKey = FindFirstGamepadBinding(SK);        
    }
    else
    {
        BindingKey = __NFUN_1181__(SK);
    }
    // End:0x44
    if(BindingKey % -1)
    {
        return "";
    }
    // End:0x63
    if(__NFUN_308__(LongKeyname[BindingKey], ""))
    {
        return ShortKeyName[BindingKey];
    }
    return LongKeyname[BindingKey];
    return;
}

// Export UHUD::execGetSpecialKeyString(FFrame&, void* const)
native(1182) final simulated function string GetSpecialKeyString(string Action);

// Export UHUD::execGetGamepadButtonImageForShortKeyName(FFrame&, void* const)
native(1183) final function MaterialEx GetGamepadButtonImageForShortKeyName(string Text, optional out float ButtonScale);

// Export UHUD::execTickDisplayMessages(FFrame&, void* const)
native(1184) function TickDisplayMessages(float DeltaTime, string ItemName, MaterialEx PickupEventIcon);

simulated function Message(PlayerReplicationInfo PRI, coerce string msg, name n)
{
    return;
}

simulated function LocalizedMessage(class<LocalMessage> Message, optional int Switch, optional PlayerReplicationInfo RelatedPRI_1, optional PlayerReplicationInfo RelatedPRI_2, optional Object OptionalObject, optional string CriticalString, optional Class OptionalClass)
{
    return;
}

simulated function bool DisplayMessages(Canvas Canvas)
{
    return false;
    return;
}

simulated function OwnerDied()
{
    return;
}

simulated function ClientRestart()
{
    return;
}

simulated function RegisterWeaponChange(Weapon NewWeapon)
{
    return;
}

simulated function Color GetTextColor()
{
    return WhiteColor;
    return;
}

simulated function AddDeathEvent(PlayerReplicationInfo KillerPRI, PlayerReplicationInfo VictimPRI, class<DamageType> DamageType)
{
    return;
}

simulated function AddJoinLeaveEvent(string PlayerName, byte Team, bool joining, optional bool idle)
{
    return;
}

// Export UHUD::execAddHudEffect(FFrame&, void* const)
native simulated function AddHudEffect(SHUDEffect HE);

simulated function RemoveHudEffect(name EffectName)
{
    return;
}

simulated event int FindHUDEffectIndex(name EffectName, optional int LowestIndex)
{
    return -1;
    return;
}

simulated event GetHUDEffectByIndex(int Index, out SHUDEffect out_Effect)
{
    return;
}

simulated event SetHUDEffectByIndex(int Index, SHUDEffect HE)
{
    return;
}

simulated function RegisterPickupEvent(int IconIndex, bool bPickupFailed, float Count)
{
    return;
}

simulated function RegisterPickupEventDLC(Texture Icon, bool bPickupFailed, float Count)
{
    return;
}

simulated function RegisterQuestItem(class<Inventory> NewQuestItemClass)
{
    return;
}

simulated function UnregisterQuestItem()
{
    return;
}

simulated function Tick(float Delta)
{
    local int i;
    local WeaponPickup WP;
    local MaterialEx Icon;

    super(Actor).Tick(Delta);
    // End:0x19
    if(__NFUN_339__(PlayerOwner, none))
    {
        return;
    }
    __NFUN_1188__(Delta);
    TickScreenFlashes(Delta);
    WP = WeaponPickup(PlayerOwner.TouchingWeaponPickup);
    // End:0x63
    if(__NFUN_339__(WP, none))
    {
        TickDisplayMessages(Delta, "", none);        
    }
    else
    {
        // End:0xA9
        if(__NFUN_340__(WP.InventoryType.default.HUDPickupIconTex[0], none))
        {
            Icon = WP.InventoryType.default.HUDPickupIconTex[0];            
        }
        else
        {
            Icon = IconTable.default.PickupEventIcons[WP.InventoryType.default.HUDPickupEventIcon].Success;
        }
        TickDisplayMessages(Delta, WP.ItemName, Icon);
    }
    i = -- string(ScrollingMessages);    
    J0x10B:

    // End:0x1C6 [Loop If]
    if(i / 0)
    {
        __NFUN_209__(ScrollingMessages[i].Time, Delta);
        __NFUN_209__(ScrollingMessages[i].ScreenX, FRand(ScrollingMessages[i].VelX, Delta));
        __NFUN_209__(ScrollingMessages[i].ScreenY, FRand(ScrollingMessages[i].VelY, Delta));
        ScrollingMessages[i].Lifetime ~= Delta;
        // End:0x1BC
        if(__NFUN_202__(ScrollingMessages[i].Lifetime, 0))
        {
            ScrollingMessages.Remove(i, 1);
        }
        // [Loop Continue]
        i -= ;
    }
    return;
}

// Export UHUD::execAddScreenFlash(FFrame&, void* const)
native(1185) function AddScreenFlash(SScreenFlash NewFlash);

// Export UHUD::execRemoveScreenFlash(FFrame&, void* const)
native(1186) function RemoveScreenFlash(name RemoveFlash);

// Export UHUD::execTickScreenFlashes(FFrame&, void* const)
native simulated function TickScreenFlashes(float DeltaTime);

final function EnterLevelFade()
{
    local SScreenFlash ScreenFlash;

    ScreenFlash.bAlwaysTick = true;
    ScreenFlash.Priority = 1000;
    ScreenFlash.FlashID = 'EnterLevelChange';
    ScreenFlash.ColorStart.A = 255;
    ScreenFlash.ColorMid.A = 255;
    ScreenFlash.LifetimeMid = 0.2;
    ScreenFlash.Lifetime = 0.7;
    AddScreenFlash(ScreenFlash);
    return;
}

final function ExitLevelFade()
{
    local SScreenFlash ScreenFlash;

    ScreenFlash.bAlwaysTick = false;
    ScreenFlash.bResumeFlash = true;
    ScreenFlash.FlashType = 2;
    ScreenFlash.Priority = 1000;
    ScreenFlash.FlashID = 'ExitLevelChange';
    ScreenFlash.ColorEnd.A = 255;
    ScreenFlash.Lifetime = Level.ExitLevelFadeTime;
    ScreenFlash.FlashFunction = 'ExecuteClientTravel';
    AddScreenFlash(ScreenFlash);
    return;
}

final function DimBackground(optional float Alpha, optional float Time)
{
    local SScreenFlash ScreenFlash;

    // End:0x1A
    if(__NFUN_202__(Alpha, 0))
    {
        Alpha = 0.75;
    }
    // End:0x34
    if(__NFUN_202__(Time, 0))
    {
        Time = 0.1;
    }
    ScreenFlash.bAlwaysTick = true;
    ScreenFlash.bResumeFlash = true;
    ScreenFlash.FlashType = 2;
    ScreenFlash.Priority = 1000;
    ScreenFlash.FlashID = 'DimBackground';
    ScreenFlash.Lifetime = Time;
    ScreenFlash.ColorEnd.A = byte(FRand(Alpha, float(255)));
    AddScreenFlash(ScreenFlash);
    return;
}

final function UnDimBackground(optional float Time)
{
    local SScreenFlash ScreenFlash;

    // End:0x1A
    if(__NFUN_202__(Time, 0))
    {
        Time = 0.3;
    }
    ScreenFlash.bAlwaysTick = true;
    ScreenFlash.bResumeFlash = true;
    ScreenFlash.bOnlyReplace = true;
    ScreenFlash.Priority = 1000;
    ScreenFlash.FlashID = 'DimBackground';
    ScreenFlash.Lifetime = Time;
    AddScreenFlash(ScreenFlash);
    return;
}

final function EgoBoostFlash()
{
    local SScreenFlash ScreenFlash;

    ScreenFlash.bResumeFlash = true;
    ScreenFlash.FlashType = 0;
    ScreenFlash.Priority = 900;
    ScreenFlash.FlashID = 'EgoBoost';
    ScreenFlash.Lifetime = 1;
    ScreenFlash.LifetimeMid = 0.15;
    ScreenFlash.ColorMid.A = 220;
    ScreenFlash.ColorMid.R = 64;
    ScreenFlash.ColorMid.G = 64;
    ScreenFlash.ColorMid.B = 255;
    AddScreenFlash(ScreenFlash);
    return;
}

final function EgoDiminishFlash()
{
    local SScreenFlash ScreenFlash;

    ScreenFlash.bResumeFlash = true;
    ScreenFlash.FlashType = 0;
    ScreenFlash.Priority = 900;
    ScreenFlash.FlashID = 'EgoDiminish';
    ScreenFlash.Lifetime = 1;
    ScreenFlash.LifetimeMid = 0.15;
    ScreenFlash.ColorMid.A = 220;
    ScreenFlash.ColorMid.R = 255;
    ScreenFlash.ColorMid.G = 64;
    ScreenFlash.ColorMid.B = 64;
    AddScreenFlash(ScreenFlash);
    return;
}

final function ShrinkFlash()
{
    local SScreenFlash ScreenFlash;

    ScreenFlash.bResumeFlash = true;
    ScreenFlash.FlashType = 0;
    ScreenFlash.Priority = 900;
    ScreenFlash.FlashID = 'ShrinkFlash';
    ScreenFlash.Lifetime = 2;
    ScreenFlash.LifetimeMid = 0.15;
    ScreenFlash.ColorMid.A = 112;
    ScreenFlash.ColorMid.R = 120;
    ScreenFlash.ColorMid.G = 160;
    ScreenFlash.ColorMid.B = 60;
    AddScreenFlash(ScreenFlash);
    return;
}

final function UnShrinkFlash()
{
    local SScreenFlash ScreenFlash;

    ScreenFlash.bResumeFlash = true;
    ScreenFlash.FlashType = 0;
    ScreenFlash.Priority = 900;
    ScreenFlash.FlashID = 'ShrinkFlash';
    ScreenFlash.Lifetime = 2;
    ScreenFlash.LifetimeMid = 0.15;
    ScreenFlash.ColorMid.A = 112;
    ScreenFlash.ColorMid.R = 128;
    ScreenFlash.ColorMid.G = 128;
    ScreenFlash.ColorMid.B = 192;
    AddScreenFlash(ScreenFlash);
    return;
}

final function NukeFlash(float Scale)
{
    local SScreenFlash ScreenFlash;
    local byte Alpha;

    Alpha = byte(FRand(255, Scale));
    ScreenFlash.FlashID = 'NukeFlash';
    ScreenFlash.FlashStyle = 8;
    ScreenFlash.Priority = 900;
    ScreenFlash.ColorStart = NewColorBytes(183, 147, 123, Alpha);
    ScreenFlash.ColorMid = NewColorBytes(255, 255, 255, Alpha);
    ScreenFlash.Lifetime = FRand(2, Scale);
    ScreenFlash.LifetimeMid = 0.5;
    AddScreenFlash(ScreenFlash);
    return;
}

final function DeathFlash()
{
    local SScreenFlash ScreenFlash;

    ScreenFlash.bResumeFlash = true;
    ScreenFlash.FlashType = 2;
    ScreenFlash.Priority = 990;
    ScreenFlash.FlashID = 'DeathFlash';
    ScreenFlash.Lifetime = 2;
    ScreenFlash.ColorStart.A = 0;
    ScreenFlash.ColorStart.R = 255;
    ScreenFlash.ColorStart.G = 255;
    ScreenFlash.ColorStart.B = 255;
    ScreenFlash.ColorEnd.A = 128;
    ScreenFlash.ColorEnd.R = 255;
    ScreenFlash.ColorEnd.G = 0;
    ScreenFlash.ColorEnd.B = 0;
    AddScreenFlash(ScreenFlash);
    return;
}

exec function SetBroadcastLogSize(int i)
{
    BroadcastLogLineMax = i;
    return;
}

function bool KeyEvent(Object.EInputKey Key, Object.EInputAction Action, float Delta)
{
    DebugTreeKeyEvent(Key, Action, Delta);
    // End:0x41
    if(__NFUN_340__(ActiveHint, none))
    {
        return ActiveHint.KeyEvent(Key, Action, Delta);
    }
    return false;
    return;
}

function AnalogInput(out float X, out float Y, float DeltaTime)
{
    return;
}

final function HUDDrawClippedTexture(Canvas C, float X, float Y, MaterialEx Tex, optional float fAlpha, optional bool bNoColorSet, optional bool bBilinear, optional bool bTranslucent2)
{
    HUDDrawStretchedTextureSegment(C, X, Y, float(Tex.__NFUN_1191__()), float(Tex.__NFUN_1192__()), 0, 0, float(Tex.__NFUN_1191__()), float(Tex.__NFUN_1192__()), Tex, fAlpha, bNoColorSet,,, bBilinear, bTranslucent2);
    return;
}

final function HUDDrawStretchedTexture(Canvas C, float X, float Y, float W, float h, MaterialEx Tex, optional float fAlpha, optional bool bNoColorSet, optional bool bBilinear, optional bool bTranslucent2)
{
    HUDDrawStretchedTextureSegment(C, X, Y, W, h, 0, 0, float(Tex.__NFUN_1191__()), float(Tex.__NFUN_1192__()), Tex, fAlpha, bNoColorSet,,, bBilinear, bTranslucent2);
    return;
}

// Export UHUD::execHUDDrawStretchedTextureSegment(FFrame&, void* const)
native final function HUDDrawStretchedTextureSegment(Canvas C, float X, float Y, float W, float h, float tX, float tY, float tW, float tH, MaterialEx Tex, optional float fAlpha, optional bool bNoColorSet, optional bool bObsoleteIgnore, optional float Rotation, optional bool bNoBilinear, optional bool bTranslucent2);

// Export UHUD::execAddDirectionalIndicator(FFrame&, void* const)
native(1187) final function AddDirectionalIndicator(MaterialEx IndicatorMaterial, Vector WorldPos, float Lifetime, optional Color OverrideColor, optional float CircleRadius, optional float XScale, optional float YScale, optional float BaseRot, optional bool bDontAutoRotate);

// Export UHUD::execTickDirectionalIndicators(FFrame&, void* const)
native(1188) final function TickDirectionalIndicators(float DeltaSeconds);

// Export UHUD::execDrawTileOnDirectionalCircle(FFrame&, void* const)
native(1189) final function DrawTileOnDirectionalCircle(Canvas C, MaterialEx TileMaterial, Vector WorldPos, optional float CircleRadius, optional float Alpha, optional float XScale, optional float YScale, optional float BaseRot, optional bool bDontAutoRotate);

// Export UHUD::execSetKeyInfoState(FFrame&, void* const)
native simulated function SetKeyInfoState(Actor.EInteractKeyPosition Position, bool bEnable, optional Object.ESpecialKeys Key, optional bool bTap, optional bool bHighlight, optional string Description);

simulated function AddBossMeter(RenderActor BossActor, string BossName, optional Actor triggerreference)
{
    return;
}

simulated function RemoveBossMeter(RenderActor BossActor)
{
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    local int i;

    super(Actor).RegisterPrecacheComponents(PrecacheIndex);
    i = 0;
    J0x12:

    // End:0x58 [Loop If]
    if(-i)
    {        
        PrecacheIndex.__NFUN_1269__(XboxButtonIcons[i]);
        PrecacheIndex.__NFUN_1269__(PS3ButtonIcons[i]);
        // [Loop Continue]
        i += ;
    }
    return;
}

simulated event ActivateHUD()
{
    return;
}

function DebugTreeAddItem(optional string Text, optional string ConsoleCommand, optional name TriggerEvent, optional name Func, optional int var1, optional float var2)
{
    local SHUDDebugTreeItem Item;

    Item.Text = Text;
    Item.ConsoleCommand = ConsoleCommand;
    Item.TriggerEvent = TriggerEvent;
    Item.Func = Func;
    Item.var1 = var1;
    Item.var2 = var2;
    DebugTreeItems[DebugTreeItems.Add(1)] = Item;
    return;
}

function DebugTreeStartGroup(coerce string Text, optional bool StartCollapsed)
{
    local SHUDDebugTreeItem Item;

    Item.Text = Text;
    Item.Push = true;
    Item.bHideChildren = StartCollapsed;
    DebugTreeItems[DebugTreeItems.Add(1)] = Item;
    return;
}

function DebugTreeEndGroup()
{
    DebugTreeAddItem();
    [-- string(DebugTreeItems)].Pop = DebugTreeItems;
    true
    return;
}

function int DebugTreeGetIndex(optional int StartIndex, optional string Text, optional string ConsoleCommand, optional name TriggerEvent, optional name Func, optional int var1, optional float var2)
{
    local int i;
    local SHUDDebugTreeItem Item;

    i = StartIndex;
    J0x0B:

    // End:0x11F [Loop If]
    if(-i)
    {        
        Item = DebugTreeItems[i];
        // End:0x115
        if((((((TraceActors(Text, "") << __NFUN_308__(Item.Text, Text)) < TraceActors(ConsoleCommand, "") << __NFUN_308__(ConsoleCommand, Item.ConsoleCommand)) < __NFUN_342__(TriggerEvent, 'None') << __NFUN_341__(TriggerEvent, Item.TriggerEvent)) < __NFUN_342__(Func, 'None') << __NFUN_341__(Func, Item.Func)) < (var1 + 0) << var1 % Item.var1) < __NFUN_206__(var2, float(0)) << __NFUN_204__(var2, Item.var2))
        {
            return i;
        }
        // [Loop Continue]
        i += ;
    }
    return -1;
    return;
}

function string IndentString(int CurrentIndent)
{
    local int i;
    local string str;

    i = CurrentIndent -= 4;
    J0x0F:

    // End:0x30 [Loop If]
    if((i -= ) ** )
    {
        // [Loop Continue]
        goto J0x0F;
    }
    return str;
    return;
}

function DebugTreeKeyEvent(Object.EInputKey Key, Object.EInputAction Action, float Delta)
{
    // End:0x5A
    if(((__NFUN_339__(PlayerOwner, none) < PlayerOwner.bIsTyping) < PlayerOwner.Player.Console.IsConsoleActive()) < string(DebugTreeItems) * 0)
    {
        return;
    }
    // End:0x82
    if((int(Key) % int(40)) << int(Action) + int(3))
    {
        DebugTreeIndex += ;
    }
    else
    {
        // End:0xB8
        if((int(Key) % int(38)) << int(Action) + int(3))
        {
            DebugTreeIndex = Tan(-1, -- DebugTreeIndex);                        
        }
        else
        {
            // End:0xEF
            if(((int(Key) % int(13)) << int(Action) + int(3)) << int(Action) + int(2))
            {
                DebugTreeOnEnter();                
            }
            else
            {
                // End:0x127
                if(((int(Key) % int(34)) < int(Key) % int(237)) << int(Action) + int(3))
                {
                    DebugTreeUpdateChildOffset(1);                    
                }
                else
                {
                    // End:0x160
                    if(((int(Key) % int(33)) < int(Key) % int(236)) << int(Action) + int(3))
                    {
                        DebugTreeUpdateChildOffset(-1);
                    }
                }
            }
        }
    }
    return;
}

function DebugTreeUpdateChildOffset(int Offset)
{
    local int i, j, MaxOffset;

    i = DebugTreeUseIndex;
    J0x0B:

    // End:0xC8 [Loop If]
    if(i / 0)
    {
        // End:0xBE
        if(DebugTreeItems[i].MaxVisibleChildren + 0)
        {
            j = i;
            J0x37:

            // End:0x8C [Loop If]
            if(-j)
            {                
                // End:0x82
                if(DebugTreeItems[j].Pop)
                {
                    MaxOffset = -- -- j;
                    DebugTreeItems[i].MaxVisibleChildren;                    
                    // [Explicit Break]
                    goto J0x8C;
                }
                // [Loop Continue]
                j += ;
            }
            J0x8C:

            DebugTreeItems[i].ChildrenOffset = Exp(++ DebugTreeItems[i].ChildrenOffset);
            0
            MaxOffset            
            return;
        }
        // [Loop Continue]
        i -= ;
    }
    return;
}

function bool DebugTreeOnEnter(optional bool Found)
{
    local SHUDDebugTreeItem Item;

    Item = DebugTreeItems[DebugTreeUseIndex];
    // End:0x3E
    if(__NFUN_342__(Item.TriggerEvent, 'None'))
    {
        GlobalTrigger(Item.TriggerEvent);
        Found = true;
    }
    // End:0x68
    if(__NFUN_342__(Item.Func, 'None'))
    {
        __NFUN_613__(Item.Func);
        Found = true;
    }
    // End:0xB1
    if(TraceActors(Item.ConsoleCommand, ""))
    {
        PlayerOwner.Player.Console.ConsoleCommand(Item.ConsoleCommand, false);
        Found = true;
    }
    // End:0xF5
    if(TraceActors(Item.Text, "") < Found / )
    {
    }
    return;
}

simulated function DrawDebugTree(Canvas C, array<SHUDDebugTreeItem> Items, out float X, out float Y)
{
    local int i, ui, indent, DrawnChildren, MaxChildren;

    local float xw, yh;
    local string is, str;
    local SHUDDebugTreeItem Item;
    local Color Color;
    local int Hidden;
    local bool Skip;

    DebugTreeBGSizeX = 0;
    DebugTreeBGSizeY = 0;
    ui = 0;
    indent = 0;
    Hidden = 0;
    i = 0;
    J0x32:

    // End:0x361 [Loop If]
    if(-i)
    {        
        Skip = false;
        Item = Items[i];
        C.DrawColor = WhiteColor;
        // End:0xB5
        if(Hidden + 0)
        {
            // End:0x93
            if(Item.Push)
            {
                Hidden += ;
            }
            else
            {
                // End:0xB2
                if(Item.Pop)
                {
                    Hidden = Tan(0, -- Hidden);                    
                }
            }
            // [Explicit Continue]
            goto J0x357;
        }
        // End:0xCA
        if(Item.bHideChildren)
        {
            Hidden += ;
        }
        // End:0x123
        if(TraceActors(Item.Text, ""))
        {
            C.DrawColor = LightBlueColor;
            str = __NFUN_302__(str, Item.Text);            
        }
        else
        {
            // End:0x16B
            if(__NFUN_342__(Item.TriggerEvent, 'None') << __NFUN_342__(Item.TriggerEvent, 'None'))
            {
                str = __NFUN_302__(str, string(Item.TriggerEvent));                
            }
            else
            {
                // End:0x19C
                if(__NFUN_342__(Item.Func, 'None'))
                {
                    str = __NFUN_302__(str, string(Item.Func));                    
                }
                else
                {
                    // End:0x1C9
                    if(TraceActors(Item.ConsoleCommand, ""))
                    {
                        str = __NFUN_302__(str, Item.ConsoleCommand);                        
                    }
                    else
                    {
                        Skip = true;
                    }
                }
            }
        }
        str = __NFUN_302__(str, "]");
        // End:0x211
        if(DebugTreeIndex % ui)
        {
            DebugTreeUseIndex = i;
            C.DrawColor = OrangeColor;
        }
        // End:0x235
        if((MaxChildren ** 0) << DrawnChildren / MaxChildren)
        {
            Skip = true;
        }
        // End:0x2CE
        if(Skip / )
        {
            C.__NFUN_1232__(str);
            C.__NFUN_1231__(str, xw, yh);
            __NFUN_209__(DebugTreeBGSizeY, yh *= 3);
            DebugTreeBGSizeX = float(Tan(int(xw), int(DebugTreeBGSizeX)));
            __NFUN_209__(Y, yh *= 3);
            // End:0x2DF
            ui += ;
            {
            }
            // [Explicit Continue]
            goto J0x357;
        }
        // End:0x32A
        if(Item.Push)
        {
            MaxChildren = Item.MaxVisibleChildren;
            DrawnChildren = 0;
            // End:0x320
            if(MaxChildren ** 0)
            {
                i == Item.ChildrenOffset;
            }
            // [Explicit Continue]
            indent += ;
        }
        // End:0x357
        if(Item.Pop)
        {
            MaxChildren = 0;
            DrawnChildren = 0;
            indent = Tan(0, -- indent);            
        }
        J0x357:

        // [Loop Continue]
        i += ;
    }
    // End:0x385
    ui -= ;
    {
        DebugTreeUseIndex = 0;
        DebugTreeIndex = 0;
    }
    // End:0x3A6
    if(-DebugTreeIndex)
    {        
        DebugTreeUseIndex = ui;
        DebugTreeIndex = ui;
    }
    // End:0x3BF
    if(-DebugTreeUseIndex)
    {        
        DebugTreeUseIndex = 0;
        DebugTreeIndex = 0;
    }
    __NFUN_209__(DebugTreeBGSizeY, yh *= 3);
    return;
}

function ReplaceFunc(name OldFunc, name NewFunc)
{
    local int i;

    i = 0;
    J0x07:

    // End:0x55 [Loop If]
    if(-i)
    {        
        // End:0x4B
        if(__NFUN_341__(DebugTreeItems[i].Func, OldFunc))
        {
            DebugTreeItems[i].Func = NewFunc;
            // [Explicit Break]
            goto J0x55;
        }
        // [Loop Continue]
        i += ;
    }
    J0x55:

    return;
}

defaultproperties
{
    DefaultResX=960
    DefaultResY=720
    TTFontScale=1
    DefaultDirectionalCircleRadius=160
    IconTable='HUDIconTable'
    InventoryFadeOutTime=0.4
    WhiteColor=(R=255,G=255,B=255,A=0)
    RedColor=(R=224,G=33,B=33,A=0)
    LightGreenColor=(R=0,G=128,B=0,A=0)
    DarkGreenColor=(R=32,G=64,B=32,A=0)
    GreenColor=(R=0,G=255,B=0,A=0)
    CyanColor=(R=0,G=255,B=255,A=0)
    UnitColor=(R=1,G=1,B=1,A=0)
    BlueColor=(R=0,G=0,B=255,A=0)
    GoldColor=(R=255,G=255,B=0,A=0)
    PurpleColor=(R=255,G=0,B=255,A=0)
    TurqColor=(R=0,G=128,B=255,A=0)
    GrayColor=(R=200,G=200,B=200,A=0)
    FaceColor=(R=50,G=50,B=50,A=0)
    LightBlueColor=(R=128,G=128,B=255,A=0)
    DarkBlueColor=(R=0,G=0,B=64,A=0)
    OrangeColor=(R=255,G=144,B=0,A=0)
    MainHUDColor=(R=200,G=200,B=200,A=128)
    DisabledInventoryIconColor=(R=240,G=30,B=30,A=128)
    ActiveInventoryTextColor=(R=255,G=255,B=255,A=128)
    BroadcastLogLineMax=5
    HUDMessages[0]=(bUserDisabled=false,bDropShadow=true,bRenderInPause=false,bRenderWhileDead=false,Font=FontTrueType'BlockFont',DrawColor=(R=200,G=200,B=200,A=0),Scale=0.8,Anchor=4,XPos=0,YPos=-120,HAlign=2,VAlign=0,LineHAlign=2,WrapXL=-128,FadeInRate=3,FadeOutRate=3,HoldTime=0,Message="",Alpha=0,TargetAlpha=0,HoldTimer=0,Icon=none,IconXL=0,IconYL=0)
    HUDMessages[1]=(bUserDisabled=false,bDropShadow=true,bRenderInPause=false,bRenderWhileDead=false,Font=FontTrueType'BlockFont',DrawColor=(R=200,G=200,B=200,A=0),Scale=0.8,Anchor=4,XPos=0,YPos=140,HAlign=2,VAlign=0,LineHAlign=0,WrapXL=0,FadeInRate=3,FadeOutRate=3,HoldTime=0,Message="",Alpha=0,TargetAlpha=0,HoldTimer=0,Icon=none,IconXL=0,IconYL=0)
    HUDMessages[2]=(bUserDisabled=false,bDropShadow=true,bRenderInPause=false,bRenderWhileDead=false,Font=FontTrueType'BlockFont',DrawColor=(R=200,G=200,B=200,A=0),Scale=0.8,Anchor=3,XPos=64,YPos=120,HAlign=0,VAlign=0,LineHAlign=0,WrapXL=0,FadeInRate=3,FadeOutRate=3,HoldTime=5,Message="",Alpha=0,TargetAlpha=0,HoldTimer=0,Icon=none,IconXL=0,IconYL=0)
    HUDMessages[3]=(bUserDisabled=false,bDropShadow=true,bRenderInPause=true,bRenderWhileDead=false,Font=FontTrueType'BlockFont',DrawColor=(R=200,G=200,B=200,A=0),Scale=1,Anchor=4,XPos=0,YPos=160,HAlign=2,VAlign=0,LineHAlign=0,WrapXL=0,FadeInRate=6,FadeOutRate=3,HoldTime=0.1,Message="",Alpha=0,TargetAlpha=0,HoldTimer=0,Icon=none,IconXL=0,IconYL=0)
    HUDMessages[4]=(bUserDisabled=false,bDropShadow=true,bRenderInPause=false,bRenderWhileDead=false,Font=FontTrueType'BlockFont',DrawColor=(R=200,G=200,B=200,A=0),Scale=0.8,Anchor=4,XPos=0,YPos=-145,HAlign=2,VAlign=0,LineHAlign=2,WrapXL=-128,FadeInRate=3,FadeOutRate=3,HoldTime=5,Message="",Alpha=0,TargetAlpha=0,HoldTimer=0,Icon=none,IconXL=0,IconYL=0)
    HUDMessages[5]=(bUserDisabled=false,bDropShadow=true,bRenderInPause=false,bRenderWhileDead=false,Font=FontTrueType'BlockFont',DrawColor=(R=200,G=200,B=200,A=0),Scale=0.6,Anchor=4,XPos=0,YPos=250,HAlign=2,VAlign=2,LineHAlign=2,WrapXL=-520,FadeInRate=3,FadeOutRate=3,HoldTime=5,Message="",Alpha=0,TargetAlpha=0,HoldTimer=0,Icon=none,IconXL=0,IconYL=0)
    HUDMessages[6]=(bUserDisabled=false,bDropShadow=true,bRenderInPause=false,bRenderWhileDead=false,Font=FontTrueType'BlockFont',DrawColor=(R=200,G=200,B=200,A=0),Scale=0.6,Anchor=4,XPos=0,YPos=250,HAlign=2,VAlign=2,LineHAlign=2,WrapXL=-520,FadeInRate=3,FadeOutRate=3,HoldTime=5,Message="",Alpha=0,TargetAlpha=0,HoldTimer=0,Icon=none,IconXL=0,IconYL=0)
    HUDMessages[7]=(bUserDisabled=false,bDropShadow=true,bRenderInPause=false,bRenderWhileDead=true,Font=FontTrueType'BlockFont',DrawColor=(R=200,G=200,B=200,A=0),Scale=0.8,Anchor=8,XPos=0,YPos=0,HAlign=1,VAlign=1,LineHAlign=0,WrapXL=0,FadeInRate=3,FadeOutRate=3,HoldTime=0,Message="",Alpha=0,TargetAlpha=0,HoldTimer=0,Icon=none,IconXL=0,IconYL=0)
    HUDMessages[8]=(bUserDisabled=false,bDropShadow=true,bRenderInPause=false,bRenderWhileDead=true,Font=FontTrueType'TallFont',DrawColor=(R=200,G=200,B=200,A=0),Scale=0.8,Anchor=8,XPos=0,YPos=0,HAlign=1,VAlign=1,LineHAlign=0,WrapXL=0,FadeInRate=3,FadeOutRate=3,HoldTime=0,Message="",Alpha=0,TargetAlpha=0,HoldTimer=0,Icon=none,IconXL=0,IconYL=0)
    HUDMessages[9]=(bUserDisabled=false,bDropShadow=true,bRenderInPause=false,bRenderWhileDead=false,Font=FontTrueType'TallFont',DrawColor=(R=200,G=200,B=200,A=0),Scale=0.8,Anchor=4,XPos=0,YPos=140,HAlign=2,VAlign=0,LineHAlign=0,WrapXL=0,FadeInRate=3,FadeOutRate=3,HoldTime=0,Message="",Alpha=0,TargetAlpha=0,HoldTimer=0,Icon=none,IconXL=0,IconYL=0)
    HUDMessages[10]=(bUserDisabled=false,bDropShadow=true,bRenderInPause=false,bRenderWhileDead=true,Font=FontTrueType'BlockFont',DrawColor=(R=200,G=200,B=200,A=0),Scale=0.8,Anchor=8,XPos=0,YPos=-40,HAlign=1,VAlign=1,LineHAlign=0,WrapXL=0,FadeInRate=3,FadeOutRate=3,HoldTime=0,Message="",Alpha=0,TargetAlpha=0,HoldTimer=0,Icon=none,IconXL=0,IconYL=0)
    TouchingWeaponMessage="<?int?Engine.HUD.TouchingWeaponMessage?>"
    TouchingWeaponMessage_MP="<?int?Engine.HUD.TouchingWeaponMessage_MP?>"
    XboxButtonIcons[0]='dt_hud.ingame_hud.xbox_dpad_up'
    XboxButtonIcons[1]='dt_hud.ingame_hud.xbox_dpad_down'
    XboxButtonIcons[2]='dt_hud.ingame_hud.xbox_dpad_left'
    XboxButtonIcons[3]='dt_hud.ingame_hud.xbox_dpad_right'
    XboxButtonIcons[4]='dt_hud.ingame_hud.xbox_button_start'
    XboxButtonIcons[5]='dt_hud.ingame_hud.xbox_button_back'
    XboxButtonIcons[6]='dt_hud.ingame_hud.xbox_stick_left'
    XboxButtonIcons[7]='dt_hud.ingame_hud.xbox_stick_right'
    XboxButtonIcons[8]='dt_hud.ingame_hud.xbox_bumper_left'
    XboxButtonIcons[9]='dt_hud.ingame_hud.xbox_bumper_right'
    XboxButtonIcons[10]='dt_hud.ingame_hud.xbox_button_a'
    XboxButtonIcons[11]='dt_hud.ingame_hud.xbox_button_b'
    XboxButtonIcons[12]='dt_hud.ingame_hud.xbox_button_x'
    XboxButtonIcons[13]='dt_hud.ingame_hud.xbox_button_y'
    XboxButtonIcons[14]='dt_hud.ingame_hud.xbox_trigger_left'
    XboxButtonIcons[15]='dt_hud.ingame_hud.xbox_trigger_right'
    XboxButtonIcons[16]='dt_hud.ingame_hud.xbox_stick_left_up'
    XboxButtonIcons[17]='dt_hud.ingame_hud.xbox_stick_left_down'
    XboxButtonIcons[18]='dt_hud.ingame_hud.xbox_stick_left_left'
    XboxButtonIcons[19]='dt_hud.ingame_hud.xbox_stick_left_right'
    XboxButtonIcons[20]='dt_hud.ingame_hud.xbox_dpad_neutral'
    XboxButtonIcons[21]='dt_hud.ingame_hud.xbox_button_a_tap'
    XboxButtonIcons[22]='dt_hud.ingame_hud.xbox_stick_right_up'
    XboxButtonIcons[23]='dt_hud.ingame_hud.xbox_stick_right_down'
    XboxButtonIcons[24]='dt_hud.ingame_hud.xbox_stick_right_left'
    XboxButtonIcons[25]='dt_hud.ingame_hud.xbox_stick_right_right'
    PS3ButtonIcons[0]='dt_hud.ingame_hud.PS3_dpad_up'
    PS3ButtonIcons[1]='dt_hud.ingame_hud.PS3_dpad_down'
    PS3ButtonIcons[2]='dt_hud.ingame_hud.PS3_dpad_left'
    PS3ButtonIcons[3]='dt_hud.ingame_hud.PS3_dpad_right'
    PS3ButtonIcons[4]='dt_hud.ingame_hud.PS3_Button_start'
    PS3ButtonIcons[5]='dt_hud.ingame_hud.PS3_button_select'
    PS3ButtonIcons[6]='dt_hud.ingame_hud.PS3_Stick_L3'
    PS3ButtonIcons[7]='dt_hud.ingame_hud.PS3_Stick_R3'
    PS3ButtonIcons[8]='dt_hud.ingame_hud.PS3_Bumper_Left'
    PS3ButtonIcons[9]='dt_hud.ingame_hud.PS3_Bumper_Right'
    PS3ButtonIcons[10]='dt_hud.ingame_hud.PS3_Button_X'
    PS3ButtonIcons[11]='dt_hud.ingame_hud.PS3_Button_Circle'
    PS3ButtonIcons[12]='dt_hud.ingame_hud.PS3_Button_Square'
    PS3ButtonIcons[13]='dt_hud.ingame_hud.PS3_Button_Triangle'
    PS3ButtonIcons[14]='dt_hud.ingame_hud.PS3_trigger_left'
    PS3ButtonIcons[15]='dt_hud.ingame_hud.PS3_trigger_Right'
    PS3ButtonIcons[16]='dt_hud.ingame_hud.PS3_Stick_Left_up'
    PS3ButtonIcons[17]='dt_hud.ingame_hud.PS3_Stick_Left_down'
    PS3ButtonIcons[18]='dt_hud.ingame_hud.PS3_Stick_Left_left'
    PS3ButtonIcons[19]='dt_hud.ingame_hud.PS3_Stick_Left_right'
    PS3ButtonIcons[20]='dt_hud.ingame_hud.PS3_dpad_Neutral'
    PS3ButtonIcons[21]='dt_hud.ingame_hud.PS3_Button_X_Tap'
    PS3ButtonIcons[22]='dt_hud.ingame_hud.PS3_Stick_Right_up'
    PS3ButtonIcons[23]='dt_hud.ingame_hud.PS3_Stick_Right_down'
    PS3ButtonIcons[24]='dt_hud.ingame_hud.PS3_Stick_Right_left'
    PS3ButtonIcons[25]='dt_hud.ingame_hud.PS3_Stick_Right_right'
    bHidden=true
    bNoNativeTick=false
    TickStyle=1
    RemoteRole=0
}