/*******************************************************************************
 * InternetLink generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class InternetLink extends InternetInfo
    transient
    native
    collapsecategories
    notplaceable
    hidecategories(movement,Collision,Lighting,LightColor);

enum ELinkMode
{
    MODE_Text,
    MODE_Line,
    MODE_Binary
};

enum EReceiveMode
{
    RMODE_Manual,
    RMODE_Event
};

struct IpAddr
{
    var int Addr;
    var int Port;
};

var InternetLink.ELinkMode LinkMode;
var InternetLink.EReceiveMode ReceiveMode;
var const int Socket;
var const int Port;
var const int RemoteSocket;
var private native const int PrivateResolveInfo;
var const int DataPending;

// Export UInternetLink::execIsDataPending(FFrame&, void* const)
native(1127) final function bool IsDataPending();

// Export UInternetLink::execParseURL(FFrame&, void* const)
native(1128) final function bool ParseURL(coerce string URL, out string Addr, out int Port, out string LevelName, out string EntryName);

// Export UInternetLink::execResolve(FFrame&, void* const)
native(1129) final function Resolve(coerce string Domain);

// Export UInternetLink::execGetLastError(FFrame&, void* const)
native(1130) final function int GetLastError();

// Export UInternetLink::execIpAddrToString(FFrame&, void* const)
native(1131) final function string IpAddrToString(IpAddr Arg);

// Export UInternetLink::execStringToIpAddr(FFrame&, void* const)
native(1132) final function bool StringToIpAddr(string str, out IpAddr Addr);

// Export UInternetLink::execValidate(FFrame&, void* const)
native(1133) final function string Validate(string ValidationString, string GameName);

// Export UInternetLink::execGetLocalIP(FFrame&, void* const)
native(1134) final function GetLocalIP(out IpAddr Arg);

event Resolved(IpAddr Addr)
{
    return;
}

event ResolveFailed()
{
    return;
}
