/*******************************************************************************
 * InterpolationPoint generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class InterpolationPoint extends Keypoint
    native
    collapsecategories
    notplaceable;

const cArcLengthSamples = 100;

enum EMotionType
{
    MOTION_Linear,
    MOTION_Spline,
    MOTION_Bezier3
};

var() noexport bool bSkipNextPath "I have no idea why this was made.";
var() noexport bool InterpolateRotation "If I should interpolate rotation of an actor on this path.";
var() noexport bool bTriggerImmediately "Trigger TriggerEvent when interpolating actor reaches this point.";
var() noexport bool bRebuildPathEachUse "When this is set to true, the point will look for a new random point from all points that match the Event. Only set this when you have branching paths.";
var() noexport bool bDebugPathing "Display debug info for the path when it is in use.";
var() noexport bool bUseTangentRotation "If true will update rotation with the tangent vector each frame";
var() noexport bool bBlendRateModifier "Should the current RateModifier be interpolated with the next RateModifier? Only works with IRATE_UnitsPerSecond";
var() noexport bool bAllowWinding "If this false, then actors will take the shortest path towards this point. Otherwise, it will simply take the current rotation and travel the entire distance to the literal rotation of the point.";
var() noexport bool bPerformAutoRoll "If true, will adjust roll based on how hard actor is turning";
var bool bInterpVarianceInUse;
var bool bHasInterpVariance;
var() noexport float RateModifier "Modifier value used to affect how fast an object travels along the path.";
var() noexport float GameSpeedModifier "Modify the slomo information for an actor on this path. Same as setting a TimeWarp on the actor.";
var() noexport deprecated name TriggerEvent "The event to call when this point is started.";
var() private noexport Vector LocationVariance "How much the location of this point can vary by each time an actor approaches it. Warning: If this is set, the interpolation point must remain stationary.";
var() private noexport Rotator RotationVariance "How much the rotation of this point can vary by each time an actor approaches it. Warning: If this is set, the interpolation point must remain stationary.";
var() noexport InterpolationPoint.EMotionType MotionType "Style of motion to use on the path. Bezier3 requires and uses 3 points. Linear and Spline allow an unlimited number of points.";
var() noexport Actor.EIRateType RateType "Style of timing to use on the path, which controls how fast it moves along the path.";
var() noexport float RateModifierBlendBegin "Between 0 and 1, the percentage along the interpolation for the blend to begin";
var() noexport float RateModifierBlendEnd "Between 0 and 1, the percentage along the interpolation for the blend to be complete";
var() noexport Color PathColor "Color you want the path to be drawn in. Depending on the order of actors this can affect different amounts of points in the line, so you are safest changing the color of all points in the line..";
var() noexport int AutoRollMaxRoll "Max roll angle that can be achieved.";
var() noexport float AutoRollRate "The rate to roll at. Higher number means you will roll more.";
var() noexport name RebuildPathTag "Trigger this to force a path rebuild.";
var() noexport int Tesselations "Number of segments that make up the curve drawn between each pair of interpolation points(for spline and bezier motion types).";
var Vector InterpLocation;
var Rotator InterpRotation;
var InterpolationPoint Prev;
var InterpolationPoint Next;
var InterpolationPoint CloneParent;
var float ArcLength[100];

// Export UInterpolationPoint::execComputeArcLength(FFrame&, void* const)
native function ComputeArcLength();

event BeginPlay()
{
    super(Actor).BeginPlay();
    BuildPath();
    return;
}

event PostBeginPlay()
{
    super(Actor).PostBeginPlay();
    __NFUN_718__('RebuildPath', RebuildPathTag);
    SetInterpolationVariance(LocationVariance, RotationVariance);
    // End:0x3A
    if(__NFUN_200__(RateModifierBlendBegin, float(0)))
    {
        RateModifierBlendBegin = 0;
    }
    // End:0x51
    if(Repl(RateModifierBlendBegin, float(1)))
    {
        RateModifierBlendBegin = 1;
    }
    // End:0x68
    if(__NFUN_200__(RateModifierBlendEnd, float(0)))
    {
        RateModifierBlendEnd = 0;
    }
    // End:0x7F
    if(Repl(RateModifierBlendEnd, float(1)))
    {
        RateModifierBlendEnd = 1;
    }
    // End:0x99
    if(Repl(RateModifierBlendBegin, RateModifierBlendEnd))
    {
        RateModifierBlendBegin = 0;
    }
    return;
}

final simulated function TriggerFunc_RebuildPath()
{
    BuildPath();
    return;
}

event BuildPath(optional int bWalkTree)
{
    local InterpolationPoint i;

    i = InterpolationPoint(FindActor(class'InterpolationPoint', Event));
    // End:0xB8
    if(__NFUN_340__(i, none))
    {
        Next = i;
        Next.Prev = self;
        // End:0x6C
        if(bDebugPathing)
        {
            BroadcastLog(__NFUN_302__(__NFUN_302__(string(self), ": next -> "), string(Next)));
        }
        // End:0xB2
        if(((bWalkTree + 0) << __NFUN_340__(Next, none)) << __NFUN_339__(Next.Next, none))
        {
            Next.BuildPath(bWalkTree);
        }
        ComputeArcLength();
    }
    // End:0xE1
    if(bDebugPathing << __NFUN_339__(Next, none))
    {
        BroadcastLog(__NFUN_302__(string(self), ": end"));
    }
    return;
}

final function SetInterpolationVariance(Vector NewLocationVariance, Rotator NewRotationVariance)
{
    LocationVariance = NewLocationVariance;
    RotationVariance = NewRotationVariance;
    // End:0x59
    if(((LocationVariance == WarnInternal(0, 0, 0)) / ) < bHasInterpVariance = true)
    {        
    }
    else
    {
        bHasInterpVariance = false;
    }
    return;
}

final function VaryInterpolation()
{
    // End:0x18
    if((bHasInterpVariance / ) < )
    {
    }
    bInterpVarianceInUse = true;
    InterpLocation = Sleep(Location, LocationVariance);
    InterpRotation = GetStateName(Rotation, RotationVariance);
    return;
}

final function UnVaryInterpolation()
{
    // End:0x0D
    if(bHasInterpVariance / )
    {
    }
    bInterpVarianceInUse = false;
    InterpLocation = Location;
    InterpRotation = Rotation;
    return;
}

event InterpolateBegin(Actor Other)
{
    // End:0x2C
    if(bDebugPathing)
    {
        BroadcastLog(__NFUN_302__(string(self), ": Begin Interpolation."));
    }
    VaryInterpolation();
    // End:0x7E
    if(__NFUN_340__(Next, none))
    {
        Next.VaryInterpolation();
        // End:0x7E
        if(__NFUN_340__(Next.Next, none))
        {
            Next.Next.VaryInterpolation();
        }
    }
    super(Actor).InterpolateBegin(Other);
    // End:0xC0
    if(bTriggerImmediately << __NFUN_342__(TriggerEvent, 'None'))
    {
        GlobalTrigger(TriggerEvent, none, Other);
        GlobalUntrigger(TriggerEvent);
    }
    ComputeArcLength();
    return;
}

function Trigger(Actor Other, Pawn EventInstigator)
{
    Next = GetRandomNext();
    // End:0x29
    if(__NFUN_340__(Next, none))
    {
        Next.Prev = self;
    }
    return;
}

event InterpolateEnd(Actor Other)
{
    // End:0x2A
    if(bDebugPathing)
    {
        BroadcastLog(__NFUN_302__(string(self), ": End Interpolation."));
    }
    // End:0x46
    if(__NFUN_340__(Prev, none))
    {
        Prev.UnVaryInterpolation();
    }
    // End:0x86
    if(bRebuildPathEachUse << __NFUN_340__(Next, none))
    {
        Next = GetRandomNext();
        // End:0x86
        if(__NFUN_340__(Next, none))
        {
            Next.Prev = self;
        }
    }
    // End:0xAA
    if(__NFUN_339__(Next, none))
    {
        Other.bInterpolating = false;
        UnVaryInterpolation();
    }
    // End:0x108
    if((bTriggerImmediately / ) << )
    {
        {
            BroadcastLog("Trigger Event Called");
        }
        GlobalTrigger(TriggerEvent, none, Other);
        GlobalUntrigger(TriggerEvent);
    }
    return;
}

final function InterpolationPoint GetRandomNext()
{
    local InterpolationPoint i;
    local array<InterpolationPoint> Destinations;

    // End:0x73
    if(__NFUN_341__(Event, 'None'))
    {
        BroadcastLog(__NFUN_302__(__NFUN_302__("Warning: ", string(self)), " was trying to get the next point in the path, but had an empty Event."));
        return none;
    }
    // End:0x9C
    foreach __NFUN_747__(class'InterpolationPoint', i, Event)
    {
        Destinations[Destinations.Add(1)] = i;        
    }    
    // End:0xC0
    if(string(Destinations) + 0)
    {
        i = Destinations[Sin(string(Destinations))];        
    }
    else
    {
        i = none;
        BroadcastLog(__NFUN_302__(__NFUN_302__("Warning: ", string(self)), " has an Event, but didn't find any InterpolationPoints with matching Tags."));
    }
    return i;
    return;
}

final function InterpolationPoint CloneInterpolationPoint()
{
    local InterpolationPoint P;
    local int i;

    P = __NFUN_615__(class'InterpolationPointDynamic',,, Location, Rotation);
    P.RateType = RateType;
    P.RateModifier = RateModifier;
    P.TriggerEvent = TriggerEvent;
    P.LocationVariance = LocationVariance;
    P.RotationVariance = RotationVariance;
    P.SetInterpolationVariance(LocationVariance, RotationVariance);
    P.GameSpeedModifier = GameSpeedModifier;
    P.bSkipNextPath = bSkipNextPath;
    P.InterpolateRotation = InterpolateRotation;
    P.bTriggerImmediately = bTriggerImmediately;
    P.bRebuildPathEachUse = bRebuildPathEachUse;
    P.bDebugPathing = bDebugPathing;
    P.MotionType = MotionType;
    P.PathColor = PathColor;
    P.Prev = Prev;
    P.Next = Next;
    P.bAllowWinding = bAllowWinding;
    P.bUseTangentRotation = bUseTangentRotation;
    P.bPerformAutoRoll = bPerformAutoRoll;
    P.CloneParent = self;
    P.bBlendRateModifier = bBlendRateModifier;
    P.RateModifierBlendBegin = RateModifierBlendBegin;
    P.RateModifierBlendEnd = RateModifierBlendEnd;
    // End:0x231
    if(__NFUN_340__(MountParent, none))
    {
        P.__NFUN_635__(MountParent,,, true);
    }
    P.__NFUN_567__(P.Name);
    i = 0;
    J0x254:

    // End:0x28B [Loop If]
    if(-i)
    {        
        P.ArcLength[i] = ArcLength[i];
        // [Loop Continue]
        i += ;
    }
    return P;
    return;
}

defaultproperties
{
    InterpolateRotation=true
    RateModifier=1
    GameSpeedModifier=1
    RateModifierBlendEnd=1
    PathColor=(R=112,G=0,B=128,A=0)
    AutoRollMaxRoll=16384
    AutoRollRate=0.325
    Tesselations=15
    bStatic=false
    bIsInterpolationPoint=true
    bDirectional=true
    Texture=Texture'S_Interp'
}