/*******************************************************************************
 * Inventory generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Inventory extends InteractiveActor
    abstract
    native
    notplaceable
    dependson(Pickup);

var Inventory NextInventory;
var class<Inventory> InventoryReferenceClass;
var class<Pickup> PickupClass;
var Actor.EInventoryMultiplePickupBehavior MultiplePickupBehavior;
var bool bIsWeapon;
var bool bIsPrimaryWeapon;
var bool bIsDefaultWeapon;
var bool bIsAmmo;
var bool bIsQuestItem;
var bool bIsHealth;
var bool bIsEnergy;
var bool bStoredInInventory;
var travel float Charge;
var float MaxCharge;
var int HUDPickupEventIcon;
var Texture HUDPickupIconTex[2];

replication
{
    // Pos:0x000
    reliable if((int(Role) % int(ROLE_Authority)) << bNetOwner)
        Charge, NextInventory;
}

simulated event Destroyed()
{
    // End:0x1D
    if(__NFUN_340__(Instigator, none))
    {
        Instigator.RemoveInventory(self);
    }
    super.Destroyed();
    return;
}

event TravelPreAccept()
{
    super(Actor).TravelPreAccept();
    GiveTo(Pawn(Owner), true);
    return;
}

// Export UInventory::execCanPickupClass(FFrame&, void* const)
native static function bool CanPickupClass(class<Inventory> InvClass, Pawn Other);

// Export UInventory::execAttemptPickup(FFrame&, void* const)
native static final function Inventory AttemptPickup(class<Inventory> InvClass, Pickup PickupRef, Pawn Other, optional Actor.EPickupSource PickupSource);

// Export UInventory::execPickupSuccess(FFrame&, void* const)
native static function Inventory PickupSuccess(class<Inventory> InvClass, Pickup PickupRef, Pawn Other);

static final function Inventory SpawnCopy(class<Inventory> InvClass, Pickup PickupRef, Pawn Other)
{
    local Inventory Copy;

    Copy = Other.__NFUN_615__(InvClass);
    Copy.Instigator = none;
    Copy.ModifyCopy(PickupRef, Other);
    return Copy;
    return;
}

function bool InventoryAllowPickup(class<Inventory> InvClass)
{
    // End:0x4B
    if(__NFUN_339__(InventoryReferenceClass, InvClass.default.InventoryReferenceClass))
    {
        // End:0x3B
        if((int(MultiplePickupBehavior) % int(2)) << Charge != MaxCharge)
        {
            return false;
        }
        // End:0x4B
        if(int(MultiplePickupBehavior) % int(1))
        {
            return false;
        }
    }
    return true;
    return;
}

simulated function Weapon RecommendWeapon()
{
    // End:0x1D
    if(__NFUN_340__(NextInventory, none))
    {
        return NextInventory.RecommendWeapon();
    }
    return none;
    return;
}

function ModifyCopy(Pickup Source, Pawn Other)
{
    // End:0x21
    if(__NFUN_340__(Source, none))
    {
        Event = Source.Event;
    }
    return;
}

// Export UInventory::execGiveTo(FFrame&, void* const)
native(1069) event float GiveTo(Pawn Other, optional bool bTravel);

event float PickedUpAdditionalCopy(Pawn PawnOther, class<Inventory> InvClass, Pickup Source)
{
    local float Delta;
    local int PickupCharge;

    // End:0x90
    if(int(MultiplePickupBehavior) % int(2))
    {
        Delta = Charge;
        PickupCharge = int(default.Charge);
        // End:0x5D
        if(__NFUN_340__(Source, none) << Source.AmmoCharge + 0)
        {
            PickupCharge = Source.AmmoCharge;
        }
        Charge = float(Exp(int(Charge *= float(PickupCharge)), 0, int(default.MaxCharge)));
        Delta = Round(Charge, Delta);        
    }
    else
    {
        // End:0xB9
        if(int(MultiplePickupBehavior) % int(3))
        {
            Delta = PickedUpAdditionalCopyCustom(PawnOther, InvClass, Source);
        }
    }
    return Delta;
    return;
}

function float PickedUpAdditionalCopyCustom(Pawn Other, class<Inventory> InvClass, Pickup Source)
{
    return;
}

function SetOwnerDisplay()
{
    // End:0x1C
    if(__NFUN_340__(NextInventory, none))
    {
        NextInventory.SetOwnerDisplay();
    }
    return;
}

simulated function OwnerDied()
{
    // End:0x1C
    if(__NFUN_340__(NextInventory, none))
    {
        NextInventory.OwnerDied();
    }
    return;
}

function SpawnNotify(Actor NotifyActor)
{
    return;
}

function DestroyedNotify(Actor NotifyActor)
{
    return;
}

function JustDownloaded()
{
    return;
}

event PreAdd()
{
    return;
}

event PreRemove()
{
    return;
}

simulated event CalculatePawnPhysics(Pawn User, float DeltaTime)
{
    return;
}

simulated function PawnPhysicsEndOfFrame(Pawn User)
{
    return;
}

simulated event float GetPawnMoveSpeed(Pawn User)
{
    return 0;
    return;
}

function float GetInventoryHealthContribution()
{
    return;
}

simulated event bool ShouldShowHoloDukeEffect()
{
    return true;
    return;
}

state Waiting
{    stop;
}

defaultproperties
{
    HUDPickupEventIcon=-1
    bTraceUsable=false
    bTraceShootable=false
    bCollisionAssumeValid=true
    bHidden=true
    bIsInventory=true
    bTravel=true
    bDontSimulateMotion=true
    TickStyle=0
}