/*******************************************************************************
 * LCDHelper generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class LCDHelper extends Object
    native;

cpptext
{
// Stripped
}

struct SChapterEntry
{
    var string URL;
    var array<Object.EEgoAwardID> Awards;
};

var() array<SChapterEntry> Chapters;
var() array<string> SPMapNames;
var transient string EgoString;
var transient string DigsUnlockString;
var transient string ChangeRoomUnlockString;
var transient string HeadString;
var transient string FaceString;
var transient string ShirtString;
var transient string TitleString;
var transient string PlayersString;
var transient string LevelString;
var transient string ScoreString;
var transient string PingString;
var transient string KillsString;
var transient string DeathsString;
var transient string KDRatioString;
var transient string CachedServerName;
var transient int CachedLevel;
var transient int CachedScore;
var transient int CachedPing;
var transient int CachedKills;
var transient int CachedDeaths;
var transient int CachedNumPlayers;
var transient float CachedXPPercent;
var transient int CachedXPCurrent;
var transient int CachedXPNeeded;
var transient float NextMPTickUpdate;
var float MPTickUpdateRateSeconds;
var localized string PieceOfCakeDifficultyString;
var localized string LetsRockDifficultyString;
var localized string ComeGetSomeDifficultyString;
var localized string DamnImGoodDifficultyString;

// Export ULCDHelper::execAddMPMapName(FFrame&, void* const)
native function AddMPMapName(int id, string MapName);

// Export ULCDHelper::execNotifyLoading(FFrame&, void* const)
native function NotifyLoading(bool bLoading);

// Export ULCDHelper::execSPSetMap(FFrame&, void* const)
native function SPSetMap(string Text);

// Export ULCDHelper::execSPSetEgo(FFrame&, void* const)
native function SPSetEgo(string Text);

// Export ULCDHelper::execSPSetEgoAwardsForLevel(FFrame&, void* const)
native function SPSetEgoAwardsForLevel(string MapName);

// Export ULCDHelper::execSPSetCheat(FFrame&, void* const)
native function SPSetCheat(string Text);

// Export ULCDHelper::execSPSetGodMode(FFrame&, void* const)
native function SPSetGodMode(string Text, bool Enabled);

// Export ULCDHelper::execSPSetInfiniteAmmo(FFrame&, void* const)
native function SPSetInfiniteAmmo(string Text, bool Enabled);

// Export ULCDHelper::execSPSetInstaGib(FFrame&, void* const)
native function SPSetInstaGib(string Text, bool Enabled);

// Export ULCDHelper::execSPMirrorMode(FFrame&, void* const)
native function SPMirrorMode(string Text, bool Enabled);

// Export ULCDHelper::execSPGrayscaleMode(FFrame&, void* const)
native function SPGrayscaleMode(string Text, bool Enabled);

// Export ULCDHelper::execSPGameSpeed(FFrame&, void* const)
native function SPGameSpeed(string Text, bool DefaultValue);

// Export ULCDHelper::execSPHeadScale(FFrame&, void* const)
native function SPHeadScale(string Text, bool DefaultValue);

// Export ULCDHelper::execSPClassicFreezeRay(FFrame&, void* const)
native function SPClassicFreezeRay(string Text, bool Enabled);

// Export ULCDHelper::execSPUse4Weapons(FFrame&, void* const)
native function SPUse4Weapons(string Text, bool Enabled);

// Export ULCDHelper::execMPSetMap(FFrame&, void* const)
native function MPSetMap(string Text);

// Export ULCDHelper::execDigsSetUnlocks(FFrame&, void* const)
native function DigsSetUnlocks(int Unlocked, int Locked);

// Export ULCDHelper::execChangeRoomSetUnlocks(FFrame&, void* const)
native function ChangeRoomSetUnlocks(int NumHatsUnlocked, int NumHatsLocked, int NumSunglassesUnlocked, int NumSunglassesLocked, int NumShirtsUnlocked, int NumShirtsLocked, int NumTitlesUnlocked, int NumTitlesLocked);

event bool HasDiscoveredEgoAward(int AwardID)
{
    local int Found;

    __NFUN_354__((AwardID / 0) << AwardID * 255);
    __NFUN_378__("EgoAwards", string(__NFUN_365__(Enum'EEgoAwardID', AwardID)), Found, "Progress.ini");
    return Found + 0;
    return;
}

defaultproperties
{
    Chapters(0)=(URL="map00",Awards=(21,0,23))
    Chapters(1)=(URL="map01",Awards=(21,0,26,22))
    Chapters(2)=(URL="map02",Awards=(21,10,4,9,19,18,24))
    Chapters(3)=(URL="map03",Awards=none)
    Chapters(4)=(URL="map04",Awards=(2))
    Chapters(5)=(URL="map05",Awards=(27))
    Chapters(6)=(URL="map06",Awards=(7))
    Chapters(7)=(URL="map07",Awards=(20))
    Chapters(8)=(URL="map08",Awards=(10,4,18,20,28))
    Chapters(9)=(URL="map09",Awards=(21,22,9,1,2,0,7,23,24,5,29,8,30,31))
    Chapters(10)=(URL="map10",Awards=(13))
    Chapters(11)=(URL="map11",Awards=(0,21,17,14,24))
    Chapters(12)=(URL="map12",Awards=(25,13,6))
    Chapters(13)=(URL="map13",Awards=(16))
    Chapters(14)=(URL="map14",Awards=none)
    Chapters(15)=(URL="map15",Awards=(12,32))
    Chapters(16)=(URL="map16",Awards=(12,11))
    Chapters(17)=(URL="map17",Awards=(15,11))
    Chapters(18)=(URL="map18",Awards=(0,21,33))
    Chapters(19)=(URL="map19",Awards=(20,12,16,25))
    Chapters(20)=(URL="map20",Awards=(14,17))
    Chapters(21)=(URL="map21",Awards=(15,12,34))
    Chapters(22)=(URL="map22",Awards=none)
    Chapters(23)=(URL="map23",Awards=none)
    MPTickUpdateRateSeconds=1
}