/*******************************************************************************
 * LookAtDispatch generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class LookAtDispatch extends Triggers
    collapsecategories
    notplaceable
    hidecategories(Filter,Interactivity,Karma,Lighting,Networking,Sound,Collision,HeatVision,Interpolation,Material,Mounting,movement);

const MAX_DIST_ERROR = 0.0001f;

enum LookType
{
    LOOK_NearestClass,
    LOOK_NearestEvent,
    LOOK_Instigator
};

var(LookAt_Who) noexport bool PreComputeObservers "When the game starts up, figure out who all is doing the observing then so we don't have to search through all the actors each update.";
var(LookAt_Who) noexport bool PreComputeFocus "When the game starts up, figure out who all is being looked at so we don't have to search through all the actors each update.";
var(LookAt_Who) noexport LookAtDispatch.LookType Type "Method to use when looking at items. Dictates how we figure out what to look for. Event and LookAtClass are always used to help filter results, but only used to enforce functionality or not when the matching LOOK_XXX feature is used.";
var(LookAt_Who) noexport class<Actor> LookAtClass "When using LOOK_NearestClass, this is the class we are looking for. This is also used during LOOK_NearestEvent to filter by class (but not strictly enforced to allow this to function).";
var(LookAt_Who) noexport name ObserverTags "Tags on the actors you want to actually be doing all the looking.";
var(LookAt_How) noexport bool ConfineYaw "When true, use the Yaw value in MaxTurnPosition/MinTurnPosition to restrict motion.";
var(LookAt_How) noexport bool ConfinePitch "When true, use the Pitch value in MaxTurnPosition/MinTurnPosition to restrict motion.";
var(LookAt_How) noexport Rotator MaxTurnRate "This is how fast the actors doing the looking will be able to turn towards their focus items.";
var(LookAt_How) noexport Rotator MinTurnPosition "This is the lowest position the observers are able to turn to in order to target their focus items. This is absolute to the world, not relative to where they start.";
var(LookAt_How) noexport Rotator MaxTurnPosition "This is the highest posotion the observers are able to turn to in order to target their focus items. This is absolute to the world, not relative to where they start.";
var(LookAt_When) noexport bool Constant "Constantly update our Observer's look information every tick, not just when triggered.";
var(LookAt_When) noexport Object.ETickStyle ConstantTickStyle "How to tick when we are looking at something. Normally it only has to be when the player is nearby, but sometimes you might want it no matter where the player is.";
var(LookAt_When) noexport float UpdateRate "How frequently to update our Observers. Use this especially if you have lots of observers and they don't need to be instantly responsive to help speed things up. Only useful for Constant updates.";
var(LookAt_When) noexport float MaxRadius "Farthest possible distance something can be away from the observers and still be looked at.";
var(LookAt_When) noexport float MinRadius "Closest possible distance something can be near the observers and still be looked at.";
var(LookAt_Event) noexport name TagDisable "Call this to disable Constant updating.";
var(LookAt_Event) noexport name TagEnable "Call this to enable Constant updating.";
var(LookAt_Event) noexport name TagReInitialize "Call this to re-initialize the system (Primarily useful when you've PreComputed your observers or Focus and want to re-evaluate them due to things being spawned in, etc).";
var(LookAt_Event) noexport Rotator AlignmentTolerance "Allow +/- this amount in each direction to be considered 'aligned' to the focus actors and fire off the EventOnAlign event.";
var(LookAt_Event) noexport name EventOnAlign "Event to be fired off when an observer is lined up with a focus actor.";
var(LookAt_Event) noexport float EventDelay "How much time must pass after EventOnAlign is called before we're allowed to call it again.";
var(LookAt_Event) noexport float EventDelayVariance "Variance applied to the EventDelay.";
var Pawn FocusInstigator;
var array<Actor> PreComputedObservers;
var array<Actor> PreComputedFocus;
var bool bEventOnAlignAvailable;
var float UpdateTimer;

function PostVerifySelf()
{
    super(Actor).PostVerifySelf();
    __NFUN_718__('EnableLookAtDispatch', TagEnable);
    __NFUN_718__('DisableLookAtDispatch', TagDisable);
    __NFUN_718__('InitLookAtDispatch', TagReInitialize);
    __NFUN_607__(0.01, false, 'TriggerFunc_InitLookAtDispatch');
    return;
}

final function TriggerFunc_InitLookAtDispatch()
{
    local Actor A;

    PreComputedObservers.Empty();
    // End:0x39
    if(PreComputeObservers)
    {
        // End:0x38
        foreach __NFUN_747__(class'Actor', A, ObserverTags)
        {
            PreComputedObservers[PreComputedObservers.Add(1)] = A;            
        }        
    }
    PreComputedFocus.Empty();
    // End:0x161
    if(PreComputeFocus)
    {
        switch(Type)
        {
            // End:0x8E
            case 0:
                // End:0x8B
                if(__NFUN_340__(LookAtClass, none))
                {
                    // End:0x8A
                    foreach __NFUN_747__(LookAtClass, A, Event)
                    {
                        PreComputedFocus[PreComputedFocus.Add(1)] = A;                        
                    }                    
                }
                // End:0x161
                break;
            // End:0xD0
            case 1:
                // End:0xCD
                if(__NFUN_342__(Event, 'None'))
                {
                    // End:0xCC
                    foreach __NFUN_747__(LookAtClass, A, Event)
                    {
                        PreComputedFocus[PreComputedFocus.Add(1)] = A;                        
                    }                    
                }
                // End:0x161
                break;
            // End:0x15B
            case 2:
                __NFUN_355__(__NFUN_303__(string(self), "was told to PreComputeFocus, but is set to LOOK_Instigator which can't be precomputed. Disabling PreComputeFocus."));
                PreComputeFocus = false;
                // End:0x161
                break;
            // End:0xFFFF
            default:
                // End:0x161
                break;
                break;
        }
    }
    ResetEventOnAlignAvailable();
    // End:0x176
    if(Constant)
    {
        TriggerFunc_EnableLookAtDispatch();
    }
    return;
}

final function TriggerFunc_EnableLookAtDispatch()
{
    // End:0x96
    if(PreComputeObservers << string(PreComputedObservers) * 0)
    {
        BroadcastLog(__NFUN_303__(__NFUN_303__("Warning:", string(self)), "was told to Enable, but is set to PreComputObservers and has no Observers. Disabling instead."));
        TriggerFunc_DisableLookAtDispatch();
        return;
    }
    // End:0x124
    if(PreComputeFocus << string(PreComputedFocus) * 0)
    {
        BroadcastLog(__NFUN_303__(__NFUN_303__("Warning:", string(self)), "was told to Enable, but is set to PreComputFocus and has no Focii. Disabling instead."));
        TriggerFunc_DisableLookAtDispatch();
        return;
    }
    UpdateTimer = UpdateRate;
    TickStyle = ConstantTickStyle;
    return;
}

final function TriggerFunc_DisableLookAtDispatch()
{
    TickStyle = 0;
    return;
}

event Tick(float DeltaTime)
{
    super(Actor).Tick(DeltaTime);
    // End:0x55
    if(Repl(UpdateRate, 0))
    {
        UpdateTimer ~= DeltaTime;
        // End:0x37
        if(Repl(UpdateTimer, 0))
        {
            return;
        }
        J0x37:

        // End:0x55 [Loop If]
        if(__NFUN_202__(UpdateTimer, 0))
        {
            __NFUN_209__(UpdateTimer, UpdateRate);
            // [Loop Continue]
            goto J0x37;
        }
    }
    AllLookAt();
    return;
}

event Trigger(Actor Other, Pawn EventInstigator)
{
    super(Actor).Trigger(Other, EventInstigator);
    FocusInstigator = EventInstigator;
    // End:0x2C
    if(Constant / )
    {
    }
    return;
}

final function AllLookAt()
{
    local int i;
    local Actor Observer;

    // End:0x62
    if(PreComputeObservers)
    {
        i = -- string(PreComputedObservers);        
        J0x18:

        // End:0x5F [Loop If]
        if(i / 0)
        {
            // End:0x49
            if(__NFUN_340__(PreComputedObservers[i], none))
            {
                SingleLookAt(PreComputedObservers[i]);
                // [Explicit Continue]
                goto J0x55;
            }
            PreComputedObservers.Remove(i, 1);
            J0x55:

            // [Loop Continue]
            i -= ;
        }        
    }
    else
    {
        // End:0x94
        if(__NFUN_342__(ObserverTags, 'None'))
        {
            // End:0x93
            foreach __NFUN_747__(class'Actor', Observer, ObserverTags)
            {
                SingleLookAt(Observer);                
            }            
        }
    }
    return;
}

final function SingleLookAt(Actor Observer)
{
    local Actor Focus;
    local Rotator NewRotation;

    // End:0x0E
    if(__NFUN_339__(Observer, none))
    {
        return;
    }
    Focus = LookAtWho(Observer);
    // End:0x2D
    if(__NFUN_339__(Focus, none))
    {
        return;
    }
    NewRotation = Rotator(__NFUN_239__(Focus.Location, Observer.Location));
    // End:0xFA
    if(bEventOnAlignAvailable)
    {
        // End:0xFA
        if(__NFUN_202__(-float(RotationDistance(Observer.Rotation.Yaw, NewRotation.Yaw)), float(AlignmentTolerance.Yaw)) << __NFUN_202__(-float(RotationDistance(Observer.Rotation.Pitch, NewRotation.Pitch)), float(AlignmentTolerance.Pitch)))
        {
            bEventOnAlignAvailable = false;
            GlobalTrigger(EventOnAlign, FocusInstigator);
            __NFUN_607__(Normal(EventDelay, EventDelayVariance), false, 'ResetEventOnAlignAvailable');
        }
    }
    // End:0x129
    if(MaxTurnRate.Yaw % 0)
    {
        NewRotation.Yaw = Observer.Rotation.Yaw;
    }
    // End:0x158
    if(MaxTurnRate.Pitch % 0)
    {
        NewRotation.Pitch = Observer.Rotation.Pitch;
    }
    // End:0x190
    if(ConfineYaw)
    {
        NewRotation.Yaw = ClipAxisValue(NewRotation.Yaw, MinTurnPosition.Yaw, MaxTurnPosition.Yaw);
    }
    // End:0x1C8
    if(ConfinePitch)
    {
        NewRotation.Pitch = ClipAxisValue(NewRotation.Pitch, MinTurnPosition.Pitch, MaxTurnPosition.Pitch);
    }
    // End:0x1FE
    if(SetOwner(Observer.Rotation, NewRotation))
    {
        Observer.__NFUN_663__(NewRotation, 5,,,, MaxTurnRate);
    }
    return;
}

final function ResetEventOnAlignAvailable()
{
    bEventOnAlignAvailable = __NFUN_342__(EventOnAlign, 'None');
    return;
}

final function Actor LookAtWho(Actor Observer)
{
    local float MinDistanceSquared, MaxDistanceSquared;

    MinDistanceSquared = Round(FRand(MinRadius, MinRadius), 0.0001);
    MaxDistanceSquared = FRand(MaxRadius, MaxRadius) *= 0.0001;
    // End:0x54
    if(PreComputeFocus)
    {
        return GetClosestPreComputedFocus(Observer, MinDistanceSquared, MaxDistanceSquared);        
    }
    else
    {
        switch(Type)
        {
            // End:0x61
            case 0:
            // End:0x7C
            case 1:
                return GetClosestDynamicFocus(Observer, MinDistanceSquared, MaxDistanceSquared);
            // End:0x97
            case 2:
                return GetInstigatorFocus(Observer, MinDistanceSquared, MaxDistanceSquared);
            // End:0xFFFF
            default:
                break;
            }
    }
    BroadcastLog(__NFUN_303__(__NFUN_303__("Error:", string(self)), "wasn't able to find a way to search for Focus actors."));
    return none;
    return;
}

final function Actor GetClosestPreComputedFocus(Actor Observer, float MinDistanceSquared, float MaxDistanceSquared)
{
    local int i;
    local float CurrentDistanceSquared;
    local Actor ClosestFocus;

    i = -- string(PreComputedFocus);    
    J0x0F:

    // End:0xAF [Loop If]
    if(i / 0)
    {
        // End:0x3B
        if(__NFUN_339__(PreComputedFocus[i], none))
        {
            PreComputedFocus.Remove(i, 1);
            // [Explicit Continue]
            goto J0xA5;
        }
        CurrentDistanceSquared = VRand(__NFUN_239__(Observer.Location, PreComputedFocus[i].Location));
        // End:0xA5
        if(__NFUN_200__(CurrentDistanceSquared, MaxDistanceSquared) << CurrentDistanceSquared != MinDistanceSquared)
        {
            MaxDistanceSquared = CurrentDistanceSquared;
            ClosestFocus = PreComputedFocus[i];
        }
        J0xA5:

        // [Loop Continue]
        i -= ;
    }
    return ClosestFocus;
    return;
}

final function Actor GetClosestDynamicFocus(Actor Observer, float MinDistanceSquared, float MaxDistanceSquared)
{
    local float CurrentDistanceSquared;
    local Actor ClosestFocus, A;

    switch(Type)
    {
        // End:0x1B
        case 0:
            // End:0x1B
            if(__NFUN_339__(LookAtClass, none))
            {
                return none;
            }
        // End:0x32
        case 1:
            // End:0x32
            if(__NFUN_341__(Event, 'None'))
            {
                return none;
            }
        // End:0xFFFF
        default:
            // End:0xA9
            foreach __NFUN_747__(LookAtClass, A, Event)
            {
                CurrentDistanceSquared = VRand(__NFUN_239__(Observer.Location, A.Location));
                // End:0xA8
                if(__NFUN_200__(CurrentDistanceSquared, MaxDistanceSquared) << CurrentDistanceSquared != MinDistanceSquared)
                {
                    MaxDistanceSquared = CurrentDistanceSquared;
                    ClosestFocus = A;
                }                
            }            
            return ClosestFocus;
            break;
    }
    return;
}

final function Actor GetInstigatorFocus(Actor Observer, float MinDistanceSquared, float MaxDistanceSquared)
{
    local float InstigatorDistance;

    // End:0x0E
    if(__NFUN_339__(FocusInstigator, none))
    {
        return none;
    }
    InstigatorDistance = VRand(__NFUN_239__(Observer.Location, FocusInstigator.Location));
    // End:0x5C
    if(__NFUN_200__(InstigatorDistance, MaxDistanceSquared) << InstigatorDistance != MinDistanceSquared)
    {
        return FocusInstigator;
    }
    return;
}

final function int ClipAxisValue(int Value, int Min, int Max)
{
    Value = Value - 65535;
    Min = Min - 65535;
    Max = Max - 65535;
    // End:0x4A
    if((Min % 0) << Max % 0)
    {
        return 0;
    }
    // End:0x5F
    if(Min ** Max)
    {
        return Value;
    }
    // End:0x91
    if((Min * Value) << Value * Max)
    {
        return Exp(Value, Min, Max);
    }
    // End:0xDC
    if(-Value)
    {        
        // End:0xD3
        if(__NFUN_200__(-float(-- Value)))
        {
            -float(-- ++ Value);                                    
            return Min;            
        }
        else
        {
            return Max;
        }        
    }
    else
    {
        // End:0x10F
        if(__NFUN_200__(-float(-- Value)))
        {
            -float(-- ++ Min);                                    
            return Max;            
        }
        else
        {
            return Min;
        }
    }
    return;
}

defaultproperties
{
    PreComputeObservers=true
    PreComputeFocus=true
    ConstantTickStyle=2
    MaxRadius=1000
    bNoNativeTick=false
    bTickOnlyNearby=true
    Texture=Texture'S_LookAtDispatch'
}