/*******************************************************************************
 * MultiplayerInfo generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class MultiplayerInfo extends Info
    native
    collapsecategories
    notplaceable
    hidecategories(movement,Collision,Lighting,LightColor,Actor,Advanced,Display,Editor,Events,Filter,Interpolation,Material,Mounting,Network,Sound,Tick,TickRules,VertexFunction);

var() noexport bool bSpawnShrunk "If true, players will spawn shrunk and remain that way.";
var() noexport netupdate(ApplyEgo) float StartingEgo "Starting ego for each player.  This is the amount of damage it takes to deplete the ego bar.";
var() noexport netupdate(ApplyHealth) float StartingHealth "Starting health for each player.  This is the amount of damage a person can take before dying after the ego bar has been depleted.";
var() noexport float MovementSpeed "Base movement speed for each player.";
var() noexport float SprintSpeed "Base sprint speed for each player.";
var() noexport float JumpSpeed "Base jump speed for each player.";
var() noexport bool bUseInventoryOverride "If true, default inventory will be overriden to use InventoryOverride.";
var() noexport array< class<Inventory> > InventoryOverride "List of inventory to spawn with.";
var() noexport float WeaponStayTime "Time (in seconds) it takes for dropped weapon pickups to go away.  0 means infinite.";
var() noexport array< class<Mutator> > Mutators "List of mutators to add.";
var() noexport array<string> ConsoleCommands "List of console commands to run on the server at map start.";

simulated function ApplyEgo(float in_NewEgo)
{
    StartingEgo = in_NewEgo;
    return;
}

simulated function ApplyHealth(float in_NewHealth)
{
    StartingHealth = in_NewHealth;
    return;
}

function PreRestartPlayer(Pawn Player)
{
    // End:0x21
    if(bSpawnShrunk)
    {
        Player.ShrinkPawn(-1, true, true, false);
    }
    return;
}

function PostLogin(Pawn Player)
{
    // End:0x53
    if(bSpawnShrunk)
    {
        __NFUN_355__(__NFUN_302__("MultiplayerInfo.PostLogin()  Spawn Shrunk ", string(Player)));
        Player.bSpawnShrunk = true;
    }
    return;
}

function PostRestartPlayer(Pawn Player)
{
    // End:0x21
    if(bSpawnShrunk)
    {
        Player.ShrinkPawn(-1, true, true, false);
    }
    Player.EgoCap = StartingEgo;
    Player.Ego = StartingEgo;
    Player.SetHealthCap(StartingHealth);
    Player.RaiseHealthToCap(Player.Location);
    // End:0xF0
    if(Player.bIsPlayerPawn)
    {
        PlayerPawn(Player).TargetWalkSpeedEx = MovementSpeed;
        PlayerPawn(Player).TargetSprintSpeedEx = SprintSpeed;
        PlayerPawn(Player).TargetJumpSpeedEx = JumpSpeed;
        Player.SetShrinkScale();
    }
    return;
}

defaultproperties
{
    StartingEgo=70
    StartingHealth=20
    MovementSpeed=260
    SprintSpeed=320
    JumpSpeed=330
    ConsoleCommands(0)="set Pistol BaseDamagePerShot 40"
    ConsoleCommands(1)="set Shotgun BaseDamagePerShot 15"
    ConsoleCommands(2)="set Shotgun HighBaseDamagePerShot 20"
    ConsoleCommands(3)="set MachineGun BaseDamagePerShot 18"
    ConsoleCommands(4)="set dnRocket_ATLaser Damage 20"
    ConsoleCommands(5)="set dnRocket_ATCaptainLaser Damage 20"
    ConsoleCommands(6)="set dnRocket_RPG_HeatSeek Damage 30"
    ConsoleCommands(7)="set dnRocket_RPG_Homing Damage 90"
    ConsoleCommands(8)="set dnPipeBombProjectile Damage 90"
    ConsoleCommands(9)="set LaserMine Damage 90"
    ConsoleCommands(10)="set dnRocket_Devastator Damage 25"
    bSinglePlayer=false
    RemoteRole=0
}