/*******************************************************************************
 * Pawn generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Pawn extends InteractiveActor
    abstract
    native
    nativereplication
    config
    collapsecategories
    notplaceable
    dependson(LevelInfo)
    dependson(Inventory)
    dependson(KarmaActor)
    dependson(PhysicsVolume)
    dependson(Material)
    dependson(TriggerMaterialOverride)
    dependson(PlayerPawn)
    dependson(MeshInstance)
    dependson(Weapon)
    dependson(Pickup)
    dependson(AnimationControllerEx)
    dependson(DamageType)
    dependson(Corpse)
    dependson(GameInfo)
    dependson(Decoration)
    dependson(WeaponConfig)
    dependson(Ammo)
    dependson(GearboxEngineGlobals)
    dependson(MultiplayerInfo)
    dependson(ActivatableInventory)
    dependson(CharacterVoicePack)
    dependson(PrecacheIndex)
    dependson(SoftParticleSystem)
    dependson(NearMissEffect)
    dependson(PlayerReplicationInfo)
    dependson(GameReplicationInfo)
    dependson(AIFaction)
    dependson(ControlRemapperEx);

const kMinThrowDistance = 64;

enum EConstraintGroundType
{
    CGROUND_Whatever,
    CGROUND_SomethingStatic,
    CGROUND_WorldAnchor
};

enum EConstraintAxis
{
    CAXIS_Forward,
    CAXIS_Strafe,
    CAXIS_Vertical
};

enum ETargetType
{
    TARGET_NoTarget,
    TARGET_Point,
    TARGET_Actor
};

enum EHealthRecoveryState
{
    HEALTHRECOVERY_None,
    HEALTHRECOVERY_WaitingForRecharge,
    HEALTHRECOVERY_Recharge,
    HEALTHRECOVERY_Failed
};

enum ETeam
{
    TEAM_EDF,
    TEAM_PigCop,
    TEAM_Undefined
};

enum ETurnState
{
    TURN_None,
    TURN_Adjusting,
    TURN_Shuffling
};

struct STarget
{
    var() Pawn.ETargetType eType;
    var() Vector TargetPoint;
    var() Actor TargetActor;
};

struct SCPSoundThrottle
{
    var name GroupName;
    var name AffiliationName;
    var float AvailableTime;
};

struct SEgoInfo
{
    var float EgoTime;
    var float EgoGained;
};

struct SPathInfo
{
    var float TotalDist;
    var bool bWait;
    var bool bAvoiding;
    var bool bPushPointOntoNavFail;
    var bool bNavFloodAP;
    var bool bNavFloodAPCacheMiss;
    var bool bPathCacheMiss;
    var bool bPathCacheHit;
    var bool bActorWasInValidArea;
    var bool bIsDynamicPathing;
    var bool bDebugPath;
    var bool bWasClippedMove;
    var bool bFailedInDynamicPathing;
    var int PathCacheID;
    var Vector TargetExtent;
    var int Cycles;
    var float PreStaticPath;
    var float PostStaticPath;
    var float GenerateStaticPath;
    var float FinalizeNextPathPos;
    var float AvoidDynamicObstacles;
    var float CalculateStartAndEndAreas;
    var int PathCacheHitCnt;
    var int PathCacheMissCnt;
};

struct SFootBones
{
    var() noexport bool bRightSide "If this is true, then the foot decal will be flipped to indicate being on the opposite side of the creature. (All decals are created for left feet.)";
    var() noexport name BoneName "Actual name of the bone.";
    var() noexport name BoneID "Identifier the artist uses to force this specified bone to do an effect.";
    var() noexport Rotator BoneRotOffset "This is the rotation offset needed to get the corrected forward rotation for the foot bone.";
};

struct SFinishAnimSequenceEntry
{
    var name SequenceName;
    var name ChannelName;
    var int ChannelRefId;
};

var bool bAttachedToUsableSomething;
var bool bForceDetachOnDamage;
var bool bPissing;
var() const bool bSimplePawnPhysicsCollision;
var const bool bPhysicsControllerActive;
var bool bEnablePhysicsRotation;
var bool bCanHear;
var bool bIsBot;
var(Combat) bool bCanStrafe;
var bool bCanSwim;
var bool bCanFly;
var travel bool bOnSteroids;
var bool bSlomoKill;
var bool bShouldCauseKillSound;
var bool bAllowSpecialKillSounds;
var bool bShouldCauseStompKillSound;
var() noexport bool bUseHealthRecovery "Uses health recovery.";
var bool bUsedHealthRecovery;
var bool bProtectedEgoRecharge;
var bool bIsHuman;
var bool bIsPlayer;
var bool bDying;
var transient bool bGodMode;
var bool bGhostMode;
var bool bAutoActivate;
var bool bHideDeactivatedWeapons;
var bool bWeaponsActive;
var bool bDisplayThrowDropMessage;
var bool DelayCorpseRagdoll;
var bool bInstaGib;
var() bool NoDecorationPain;
var transient bool bDemoMode;
var bool bFinishAnimsEarly;
var bool bAllowShrinkPostProcessEffect;
var bool bFullyShrunk;
var bool bCanUnshrinkWithSteroids;
var(Shrinking) noexport bool bShrinkable "If true, the pawn can be shrunken.";
var(Shrinking) noexport float CurrentShrinkScale "Cached shrink scale value.";
var bool bHackDropshipNoShrink;
var noexport bool bFreezable "If true, the pawn can be frozen.";
var bool bExpanding;
var bool bCanPiss;
var bool Stompable;
var bool bIgnoreAimAssist;
var(Expander) noexport bool bCanBloat "If true, the pawn is affected by expander.";
var netupdate(NU_Bloated) Actor.EBloatState BloatState;
var(Expander) float ExpandAmount;
var float ExpandTimeWarp;
var float BloatStartTime;
var(Expander) noexport float ExpandRate "Time it takes to reach full expansion";
var bool bGrabbing;
var(movement) bool CanStepUp;
var bool bAdjustStepHeight;
var bool bIsWalking;
var bool bWarping;
var transient bool bHasDeferredRotation;
var bool bChoking;
var bool bHoldingBreath;
var bool bWasUsingAirPocket;
var bool bMonitoringBreath;
var float UnderwaterThrowVelocityAdjust;
var bool bRotateToDesiredView;
var bool FootstepSimple;
var bool bPlayPickupSounds;
var class<Pickup> PickupOverride;
var float PickupKImpulseMagnitude;
var bool bBehindView;
var bool bViewPitchRotation;
var bool bViewTarget;
var bool bNoLogout;
var const bool SavedDisplayPropbLowerByCollision;
var bool bExtendedVolumeSupport;
var(LipSync) bool bPerformLipSync;
var netupdate(NU_PostureStateChange) Actor.EPostureStateEx PostureStateEx;
var Pawn.ETeam Team;
var Object.EDialog EnemySpottedDialog;
var Object.EDialog ConfirmKillDialog;
var Pawn.EHealthRecoveryState HealthRecoveryState;
var Pawn.EHealthRecoveryState EgoRecoveryState;
var netupdate(NU_FrozenStateChange) Actor.EFrozenState FrozenState;
var(GrabAndThrow) noexport Object.EMountType CarriedActorMountType "MountType to use when carrying an item.";
var() noexport Object.EFootstepCategory FootstepCategory "Type of footsteps this creature can make.";
var() noexport Object.EFootprintType FootprintType "Dictates what sort of footprint will be spawned when a step is taken.";
var Object.EPawnGender Gender;
var Pawn.ETurnState TurnType;
var const Pawn NextPawn;
var(AIRelationships) class<AIFaction> Faction;
var Inventory InventoryPhysicsItem;
var const editconst transient nontrans pointer PhysicsController;
var const editconst transient nontrans pointer PhysicsAirCloudSensor;
var const editconst transient nontrans pointer PhysicsSimpleCollision;
var float SlopeMinimumDotEx;
var float SteepSlopeStrengthScaleEx;
var Vector GameplayDesiredPhysicsVelocity;
var Inventory InventoryListHead;
var const netupdate(SetBase) Actor Base;
var Actor Enemy;
var() float FieldOfView;
var float BaseTraceHeight;
var Rotator PawnRotationRate;
var float InitialSpeed;
var float FallingTime;
var float FluidFrictionScale;
var SEgoInfo EgoThisFrame;
var FinalBlend SteroidHUDEffectMaterial;
var FinalBlend SteroidHUDEffectMaterial2;
var FinalBlend InvincibilityHUDEffectMaterial;
var() float SteroidsMeleeDamageMultiplier;
var() float SteroidsFakeExplosionMagnitude;
var() float Ego;
var() float EgoCap;
var float SteroidEgoCap;
var const float SteroidEgoCapPct;
var() float SlomoKillRampInTime;
var() float SlomoKillRampOutTime;
var() float SlomoKillLength;
var() float SlomoKillSpeed;
var float SlomoKillStart;
var float SlomoKillEnd;
var name EyeBone;
var name BodyBone;
var name LockOnBone;
var float DialogGate;
var float KillSoundRandomChance;
var name CustomKillSoundName;
var float CustomKillSoundChance;
var float CanRespawnTime;
var netupdate(NU_SetShrinkScale) float ShrinkScale;
var float TargetCollisionRadius;
var float TargetCollisionHeight;
var float TargetMaxStepHeightEx;
var float TargetMass;
var float CrouchTransitionTime;
var float StandingCollisionRadius;
var float StandingCollisionHeight;
var float StandingMaxStepHeightEx;
var float CrouchingCollisionRadius;
var float CrouchingCollisionHeight;
var float CrouchingMaxStepHeightEx;
var float TargetUseDistance;
var float TargetShrunkUseDistance;
var float CollisionInterpolationTimer;
var float CollisionInterpolationDuration;
var float CollisionInterpolationStartRadius;
var float CollisionInterpolationDestinationRadius;
var float CollisionInterpolationStartHeight;
var float CollisionInterpolationDestinationHeight;
var float CollisionInterpolationStartStepHeight;
var float CollisionInterpolationDestinationStepHeight;
var() noexport float HealthRecoveryWaitForRechargeTime "Period of time after getting hit last to start recharge.";
var() noexport float HealthRecoveryRate "Health per second to gain during recovery";
var() noexport float HealthDangerDeafenFactor "Percentage of hearing that the player will have while in danger";
var() noexport float HealthDangerEffectRampTime "Amount of time it takes to ramp up to full danger effects.";
var() noexport float HealthDangerMotionBlurFactor "Amount of motion blur to add when in health recovery.";
var() noexport float HealthDangerBlurFactor "Amount of full screen blur to add when in health recovery.";
var() noexport float HealthDangerBlurBrightnessFactor "Amount to scale blur brightness by when in health recovery.";
var() noexport float HealthDangerBloomFactor "Amount of bloom scaling to apply when in health recovery.";
var() noexport float EgoRecoveryWaitForRechargeTime "Period of time after getting hit last to start recharge.";
var() noexport float EgoRecoveryRate "Health per second to gain during recovery";
var int Spree;
var int WeaponSpree;
var class<DamageType> LastKillDamageType;
var int StartInventorySize;
var travel netupdate(NU_WeaponChange) Weapon Weapon;
var Actor WeaponChangeNotify;
var int NoWeaponCrossHairIndex;
var travel ActivatableInventory SelectedItem;
var float UseDistance;
var float MeleeDamageMultiplier;
var float TraceFireDamageMultiplier;
var Weapon PrimaryWeapon1;
var Weapon PrimaryWeapon2;
var Weapon PrimaryWeapon3;
var Weapon PrimaryWeapon4;
var globalconfig transient bool bUse4Weapons;
var transient float WeaponSelectStartTime;
var transient bool bWeaponSelectPressed;
var transient Weapon WeaponSelectSelectedWeapon;
var float WeaponSelectActivateTime;
var Actor ActiveHoloDuke;
var name PickupMountBone;
var bool bStartingToDrink;
var class<Corpse> CorpseType;
var Corpse MyCorpse;
var travel Weapon PreviousWeapon;
var Weapon PendingWeapon;
var travel Weapon PreviousWeaponForQuickSwitch;
var float LastPainSound;
var float DamageScaling;
var int ExplosiveArea;
var array<Actor> DamageAbsorbers;
var AnimationControllerEx AnimationControllerServer;
var int LastYawMoveDirection;
var float PercentageMoved;
var(Shrinking) noexport float SizeChangeTime "Time it takes to transition from full-size to shrunk-size and vice versa.";
var(Shrinking) noexport SSoundInfo ShrinkSound "Sound to play when shrinking begins.";
var(Shrinking) noexport SSoundInfo ExpandSound "Sound to play when expanding begins.";
var MaterialEx ShrinkingMaterial;
var float SizeChangeRelativeDrawscale;
var float SizeChangeTargetRelativeDrawscale;
var float FrozenStateChangeTime;
var float FreezeTime;
var float UnFreezeTime;
var SSoundInfo FreezingSound;
var SSoundInfo ThawingSound;
var float ExpandingStartTime;
var float ExpandingAlpha;
var() name ExpandingBoneName;
var() noexport class<SoftParticleSystem> PissEffectClass "Class of particle system to spawn for PissEffect.";
var SoftParticleSystem PissEffect;
var name PissEffectBoneName;
var() float DrainedLockoutTime;
var bool bDontModifyHeadSize;
var(MovementEx) const float MaxStepHeightEx;
var(movement) float GroundSpeed;
var(movement) float AirSpeed;
var(movement) float WalkSpeedScale;
var(movement) float DuckSpeedScale;
var(movement) float MaxStepHeight;
var(movement) float AirControl;
var float MoveTimer;
var const STarget DestinationTarget;
var const STarget BodyTarget;
var const STarget LookTarget;
var const STarget AimTarget;
var float DesiredSpeed;
var float MaxDesiredSpeed;
var class<Material> LastWalkMaterial;
var PhysicsVolume HeadVolume;
var PhysicsVolume FootVolume;
var LadderVolume LadderVolume;
var transient Rotator DeferredRotation;
var float ChokingDamage;
var float SwimSoundTime;
var array<Sound> SwimSounds;
var float RemainingAir;
var(movement) float ChokeHurtRate;
var(movement) float HoldBreathTime;
var(movement) float BreathDrainRate;
var(movement) float BreathRechargeRate;
var(movement) float ChokeHurtDamage;
var(movement) float ChokeGaspMinorPercentage;
var(movement) float ChokeGaspMajorPercentage;
var PhysicsVolume BreathPhysicsVolume;
var ZoneInfo BreathZoneInfo;
var SPathInfo PathInfo;
var(GrabAndThrow) noexport STimePath CarriedActorThrowCurve "Controls the ramping of how hard this pawn throws items depending on the item's weight.";
var(GrabAndThrow) noexport int CarriedActorDropResolution "How much to increment each step of the search for a valid angle by when looking for an available location. (1 - 16384 accepted) Lower number = slower";
var(GrabAndThrow) noexport SRange CarriedActorDropAngles "The lowest and highest angle you can be looking (up and down) to drop an actor.";
var(GrabAndThrow) noexport SRange CarriedActorThrowAngles "The lowest and highest angle you can be looking (up and down) to throw an actor.";
var(GrabAndThrow) noexport float CarriedActorPositionBuffer "How many units to use to buffer between ourself and the actor we are dropping. Higher is less likely to hit player when dropping, but also less likely to find a valid drop/throw location.";
var(GrabAndThrow) noexport Rotator CarriedActorRightHandAdjust "Rotation to adjust the right hand mount value by when carrying an actor. This makes it so an object with a MountRotOffset of 0,0,0 faces forward.";
var(GrabAndThrow) noexport Rotator CarriedActorLeftHandAdjust "Rotation to adjust the left hand position value by when carrying an actor. This makes it so the left hand position can be 0,0,0 and face forward by default.";
var(GrabAndThrow) noexport name CarriedActorMountMeshItem "Mesh item to mount to when carrying an item.";
var(GrabAndThrow) noexport float LastThrownActorDelay "Amount of time to store information about the last thrown actor.";
var InteractiveActor CarriedActor;
var name CarriedActorMountPose;
var InteractiveActor LastThrownActor;
var float LastThrownClearTime;
var InteractiveActor HandFocusActor;
var class<InteractiveActor> HandFocusActorClass;
var name LastQuickAction;
var float MinHitWall;
var netupdate(OnReceivePRI) PlayerReplicationInfo PlayerReplicationInfo;
var() class<PlayerReplicationInfo> PlayerReplicationInfoClass;
var() localized string MenuName;
var float OldMessageTime;
var bool bDeferMoved;
var bool bHasDeferMoved;
var bool bIsUsingFakeVelocity;
var Vector LastReplicatedLocation;
var bool bDoOverlayForWeapons;
var() noexport float LandedVelocityThreshold "How fast you need to move moving in order for the Landed effect to be created.";
var() noexport array<SFootBones> FootBones "List of bones that this creature has for feet. Allows the footstep functionality to work for any number of feet.";
var() noexport float FootprintSpecialLength "Amount of time this creature's feet will spawn special footprints before returning to normal.";
var float FootprintSpecialTime;
var TriggerMaterialOverride CurrentMaterialOverride;
var float FootstepTraceLength;
var() string VoiceType;
var(Sounds) noexport name ExitSplashSoundName "VoicePack entry to play on volume when we exit.";
var(Sounds) noexport name BigSplashSoundName "VoicePack entry to play on volume when we enter fast.";
var(Sounds) noexport name LittleSplashSoundName "VoicePack entry to play on volume when we enter slowly.";
var name SwimStrokeSoundName;
var SSoundInfo ExitSplash;
var SSoundInfo BigSplash;
var SSoundInfo LittleSplash;
var float SplashTime;
var() Rotator ViewRotation;
var Rotator PreviousViewRotation;
var int ViewRotationInt;
var() float FovAngle;
var name CameraMount;
var const array<SFinishAnimSequenceEntry> FinishAnimSequences;
var const Vector SavedDisplayPropPrePivot;
var const Vector SavedDisplayPropPostPivot;
var Decoration InteractiveDecoration;
var(LipSync) noexport deprecated Actor LipSyncSoundSource "Optional external sound source to use as our LipSync source data.  If None, just use this Pawn.";
var(LipSync) noexport class<LipSyncInfo> LipSyncInfoClass "Defines how the Pawn will perform lipsync.";
var name LipSyncPrevPose;
var bool bSpawnShrunk;
var bool bCollisionInitialized;

replication
{
    // Pos:0x12B
    unreliable if(-int(Role))
        SendVoiceMessage;

    // Pos:0x000
    reliable if(int(Role) % int(ROLE_Authority))
        BloatState, CarriedActor, 
        CarriedActorMountPose, Ego, 
        EgoCap, EgoRecoveryState, 
        FrozenState, HealthRecoveryState, 
        InteractiveDecoration, InventoryPhysicsItem, 
        PlayerReplicationInfo, ShrinkScale, 
        bCanFly, bCanPiss, 
        bFullyShrunk, bOnSteroids;

    // Pos:0x00B
    reliable if(int(RemoteRole) % int(ROLE_SimulatedProxy))
        Weapon;

    // Pos:0x016
    reliable if(int(Role) % int(ROLE_Authority))
        bSpawnShrunk;

    // Pos:0x021
    reliable if(int(RemoteRole) % int(ROLE_SimulatedProxy))
        Base;

    // Pos:0x02C
    reliable if(bNetOwner << int(Role) % int(ROLE_Authority))
        AirControl, AirSpeed, 
        DuckSpeedScale, InventoryListHead, 
        RemainingAir, WalkSpeedScale, 
        bBehindView, bChoking, 
        bGrabbing, bHoldingBreath, 
        bIsPlayer, bMonitoringBreath;

    // Pos:0x042
    reliable if((int(Role) % int(ROLE_Authority)) << bNetInitial)
        SavedDisplayPropPostPivot, SavedDisplayPropPrePivot, 
        SavedDisplayPropbLowerByCollision;

    // Pos:0x058
    reliable if((bNetOwner / ) << )
        ViewRotationInt;

    // Pos:0x070
    reliable if(int(Role) % int(ROLE_Authority))
        PostureStateEx;

    // Pos:0x07B
    reliable if(int(RemoteRole) % int(ROLE_AutonomousProxy))
        ClientDeafen, ClientEgoDanger_StartEffects, 
        ClientEgoDanger_StopEffects, ClientGameEnded, 
        ClientRestart_Normal, ClientRestart_Spectator, 
        ClientSetInventorySize, ClientSetLocation, 
        ClientSetRotation, ClientSwitchToBestWeapon, 
        HearNearMissEffect, KillSOSPowers;

    // Pos:0x086
    reliable if((((bDemoRecording / ) < ) < ) << )
        ClientMessage, ReceiveAddJoinLeaveEvent, 
        ReceiveLocalizedMessage, TeamMessage;

    // Pos:0x0D9
    reliable if(int(Role) % int(ROLE_Authority))
        ChangeToWeapon, ClientDamageEffects, 
        WeaponDown, WeaponUp, 
        rShakeView;

    // Pos:0x0E4
    reliable if(int(Role) % int(ROLE_Authority))
        ClientRespawnNotify, ServerHandQuickAction;

    // Pos:0x0EF
    reliable if(int(Role) % int(ROLE_Authority))
        BecomeFrozen, BecomeUnfrozen, 
        DisablePiss, DrainedIt, 
        EnablePiss, GrabActor, 
        HandleCorpse, PlayExpandSound, 
        PlayShrinkSound, StartKick, 
        StartShrinkEffects, StopShrinkEffects, 
        TimeToGo, UnGrabActor;

    // Pos:0x0FA
    reliable if((int(Role) % int(ROLE_Authority)) << int(RemoteRole) % int(ROLE_AutonomousProxy))
        BecomeUnfrozenScreenSplatter;

    // Pos:0x115
    reliable if((int(Role) % int(ROLE_Authority)) << bNetOwner)
        PlayPainSound;

    // Pos:0x136
    reliable if(int(Role) % int(ROLE_AutonomousProxy))
        PissDown, PissUp, 
        ServerChangeToWeapon, ServerReceivedInventory;
}

// Export UPawn::execdnPathSystem_FindPathPointTo(FFrame&, void* const)
native(859) final function bool dnPathSystem_FindPathPointTo(Vector Destination, bool bCanFly, out Vector NextPathPos, out int FinalDestination);

// Export UPawn::execSetBase(FFrame&, void* const)
native(860) final function SetBase(Actor NewBase);

// Export UPawn::execSetSimplePawnPhysicsCollision(FFrame&, void* const)
native(861) final function SetSimplePawnPhysicsCollision(bool NewValue);

// Export UPawn::execSetPhysicsControllerActive(FFrame&, void* const)
native(862) final function SetPhysicsControllerActive(bool bNewPhysicsControllerActive);

// Export UPawn::execSetMaxStepHeightEx(FFrame&, void* const)
native(863) final function SetMaxStepHeightEx(float NewMaxStepHeightEx);

// Export UPawn::execPawnSetLocation(FFrame&, void* const)
native(864) final function bool PawnSetLocation(Vector NewLocation, optional bool bNoFail);

event bool PawnUsesSphereCollision()
{
    return false;
    return;
}

event bool PawnNeedsSpecialStepHeightCollision()
{
    return false;
    return;
}

simulated function OnReceivePRI(PlayerReplicationInfo newPRI)
{
    return;
}

simulated event DrawscaleChanged(float DefaultDrawscaleRatio, Vector DefaultDrawscale3DRatio)
{
    local Inventory i;

    SetShrinkScale();
    super(Actor).DrawscaleChanged(DefaultDrawscaleRatio, DefaultDrawscale3DRatio);
    i = InventoryListHead;
    J0x21:

    // End:0x7E [Loop If]
    if(__NFUN_340__(i, none))
    {
        i.__NFUN_593__(FRand(DefaultDrawscaleRatio, i.default.DrawScale), Chr(DefaultDrawscale3DRatio, i.default.DrawScale3D));
        i = i.NextInventory;
        // [Loop Continue]
        goto J0x21;
    }
    return;
}

// Export UPawn::execInterpolateCollisionSize(FFrame&, void* const)
native function InterpolateCollisionSize(float DeltaTime);

function bool SafeSetCollisionSize(float NewRadius, float NewHeight, bool bDontAdjustPosition)
{
    local bool SetLocationFailed;
    local float HeightAdjust;

    // End:0x8C
    if(((bDontAdjustPosition / ) << ) << )
    {
        // End:0x64
        if(bDontUseMeqonPhysics << __NFUN_200__(HeightAdjust, 2))
        {
            __NFUN_207__(HeightAdjust, 2);
        }
        // End:0x8C
        if(__NFUN_645__(Locs(Location, WarnInternal(0, 0, HeightAdjust))) / )
        {
        }
    }
    __NFUN_620__(NewRadius, NewHeight);
    return SetLocationFailed / ;
}

// Export UPawn::execSetCollisionInterpolationTarget(FFrame&, void* const)
native(865) function SetCollisionInterpolationTarget(float TargetRadius, float TargetHeight, float TargetStepHeight, float InterpolationTime);

// Export UPawn::execChangeCollisionHeightToFull(FFrame&, void* const)
native(866) function ChangeCollisionHeightToFull(optional bool bImmediate);

// Export UPawn::execChangeCollisionHeightToStanding(FFrame&, void* const)
native(867) function ChangeCollisionHeightToStanding(optional bool bImmediate);

// Export UPawn::execChangeCollisionHeightToCrouching(FFrame&, void* const)
native(868) function ChangeCollisionHeightToCrouching(optional bool bImmediate);

event Touch(Actor Other)
{
    super(Actor).Touch(Other);
    // End:0x27
    if(__NFUN_339__(LadderVolume, none))
    {
        LadderVolume = LadderVolume(Other);
    }
    return;
}

event UnTouch(Actor Other)
{
    // End:0x2C
    if(__NFUN_339__(LadderVolume, Other))
    {
        LadderVolume = none;
        // End:0x2B
        foreach __NFUN_749__(class'LadderVolume', LadderVolume)
        {
            // End:0x2B
            break;            
        }        
    }
    super(Actor).UnTouch(Other);
    return;
}

event bool CanBaseOn(Actor PotentialBase)
{
    // End:0x10
    if(int(Physics) % int(18))
    {
        return false;
    }
    // End:0x23
    if(__NFUN_340__(Projectile(PotentialBase), none))
    {
        return false;
    }
    // End:0x5A
    if((((bDesiredLocating < bDesiredRotatingPitch) < bDesiredRotatingYaw) < bDesiredRotatingRoll) < bFixedRotationDir)
    {
        return false;
    }
    return true;
    return;
}

event BaseChange()
{
    // End:0x17
    if(__NFUN_340__(Pawn(Base), none))
    {
        JumpOffPawn();
    }
    return;
}

simulated function AttachToUsableSomething(Decoration Something)
{
    __NFUN_839__("IK_Detach_Left");
    __NFUN_839__("IK_Detach_Right");
    InteractiveDecoration = Something;
    Something.Instigator = self;
    // End:0x79
    if(__NFUN_340__(AnimationController, none) << Something.UsableSomethingUsesHomePose())
    {
        AnimationController.EmptyAnimChannels_AllButGroup('NotARealGroup');
    }
    // End:0x90
    if(bIsPlayerPawn)
    {
        PlayerPawn(self).__NFUN_1013__();
    }
    return;
}

simulated function DetachFromUsableSomething()
{
    // End:0x0F
    if(__NFUN_339__(InteractiveDecoration, none))
    {        
    }
    else
    {
        // End:0x36
        if(__NFUN_339__(InteractiveDecoration.Instigator, self))
        {
            InteractiveDecoration.Instigator = none;
        }
        InteractiveDecoration = none;
    }
    // End:0x53
    if(__NFUN_342__(LastQuickAction, 'None'))
    {
        HandQuickAction_AnimEnd();
    }
    return;
}

simulated function ForceDetachCompleteFromUsableSomething()
{
    local ControlRemapperEx CREX;

    // End:0x0D
    if(bAttachedToUsableSomething / )
    {
    }
    CREX = ControlRemapperEx(TickBefore);
    // End:0x62
    if(__NFUN_339__(InteractiveDecoration, none))
    {
        J0x29:

        // End:0x62 [Loop If]
        if(__NFUN_340__(CREX, none) << int(CREX.CurrentRemapperState) + int(2))
        {
            CREX.FinalizeState();
            // [Loop Continue]
            goto J0x29;
        }
    }
    // End:0x7E
    if(__NFUN_340__(InteractiveDecoration, none))
    {
        InteractiveDecoration.TriggerFunc_ForcePlayerDetachComplete();
    }
    return;
}

exec function ShowControls()
{
    // End:0x1C
    if(__NFUN_340__(InteractiveDecoration, none))
    {
        InteractiveDecoration.ShowControls();
    }
    return;
}

simulated function RefreshHelpText(Decoration Something)
{
    return;
}

simulated function bool SetUsableSomethingAnimation(name AnimStateName)
{
    // End:0x0E
    if(__NFUN_339__(AnimationController, none))
    {
        return false;
    }
    return AnimationController.SetAnimState(AnimStateName);
    return;
}

simulated function ControlsStateChanged(name NewStateName)
{
    return;
}

event Spawned()
{
    super(Actor).Spawned();
    ViewRotation = Rotation;
    return;
}

simulated event PreBeginPlay()
{
    TargetMass = Mass;
    __NFUN_869__();
    super(RenderActor).PreBeginPlay();
    // End:0x1F
    if(bDeleteMe)
    {
        return;
    }
    Instigator = self;
    // End:0xC6
    if(int(Level.NetMode) + int(NM_Client))
    {
        // End:0x99
        if(__NFUN_340__(PlayerReplicationInfoClass, none))
        {
            __NFUN_355__(__NFUN_302__("----------CREATING PRI     ", string(self)));
            PlayerReplicationInfo = __NFUN_615__(PlayerReplicationInfoClass, self,, WarnInternal(0, 0, 0), __NFUN_265__(0, 0, 0));            
        }
        else
        {
            PlayerReplicationInfo = __NFUN_615__(class'PlayerReplicationInfo', self,, WarnInternal(0, 0, 0), __NFUN_265__(0, 0, 0));
        }
        InitPlayerReplicationInfo();
    }
    __NFUN_355__(__NFUN_303__(__NFUN_303__(__NFUN_303__("----------PRE BEGIN PLAY ROLE:", string(Role)), "RemoteRole:"), string(RemoteRole)));
    return;
}

simulated function PostBeginPlay()
{
    super.PostBeginPlay();
    TargetUseDistance = UseDistance;
    StandingCollisionRadius = default.CollisionRadius;
    StandingCollisionHeight = default.CollisionHeight;
    StandingMaxStepHeightEx = default.MaxStepHeightEx;
    // End:0x51
    if(int(Level.NetMode) + int(NM_Client))
    {
        ChangeCollisionHeightToStanding(true);
    }
    SplashTime = 0;
    __NFUN_361__('Tick');
    RemainingAir = HoldBreathTime;
    LastReplicatedLocation = Location;
    return;
}

simulated event PostNetInitial()
{
    local Actor.EPostureStateEx NewPostureState;

    super(RenderActor).PostNetInitial();
    // End:0x25
    if(int(Level.NetMode) % int(NM_Client))
    {
        ChangeCollisionHeightToStanding(true);
    }
    NewPostureState = PostureStateEx;
    PostureStateEx = 0;
    SetNewPostureState(NewPostureState);
    return;
}

function bool VerifySelf()
{
    CarriedActorDropResolution = Exp(CarriedActorDropResolution, 1, 16384);
    // End:0x3F
    if(Repl(CarriedActorDropAngles.Min, CarriedActorDropAngles.Max))
    {
        CarriedActorDropAngles.Min = CarriedActorDropAngles.Max;
    }
    // End:0x6D
    if(Repl(CarriedActorThrowAngles.Min, CarriedActorThrowAngles.Max))
    {
        CarriedActorThrowAngles.Min = CarriedActorThrowAngles.Max;
    }
    return super(Actor).VerifySelf();
    return;
}

function InitPlayerReplicationInfo()
{
    // End:0x36
    if(__NFUN_308__(PlayerReplicationInfo.PlayerName, ""))
    {
        PlayerReplicationInfo.PlayerName = class'GameInfo'.default.DefaultPlayerName;
    }
    return;
}

simulated function Destroyed()
{
    local Pawn OtherPawn;
    local int i;

    super.Destroyed();
    __NFUN_870__();
    // End:0x19
    if(-int(Role))
    {        
        return;
    }
    DestroyInventory();
    // End:0x68
    if((bIsPlayer << __NFUN_340__(Level.Game, none)) << bNoLogout / )
    {
    }
    PRICleanup();
    OtherPawn = Level.PawnList;
    J0x83:

    // End:0xC4 [Loop If]
    if(__NFUN_340__(OtherPawn, none))
    {
        OtherPawn.Killed(none, self, class'ExplosionDamage', 0, 'None');
        OtherPawn = OtherPawn.NextPawn;
        // [Loop Continue]
        goto J0x83;
    }
    return;
}

simulated function PRICleanup()
{
    // End:0x20
    if(__NFUN_340__(PlayerReplicationInfo, none))
    {
        PlayerReplicationInfo.__NFUN_614__();
        PlayerReplicationInfo = none;
    }
    return;
}

function StartMatch()
{
    return;
}

// Export UPawn::execAddPawn(FFrame&, void* const)
native(869) final function AddPawn();

// Export UPawn::execRemovePawn(FFrame&, void* const)
native(870) final function RemovePawn();

// Export UPawn::execIsLocallyControlled(FFrame&, void* const)
native simulated function bool IsLocallyControlled();

// Export UPawn::execIsSpectating(FFrame&, void* const)
native simulated function bool IsSpectating();

final event bool IsAlien()
{
    // End:0x0E
    if(__NFUN_339__(Faction, none))
    {
        return false;
    }
    return Faction.static.IsAlien();
    return;
}

final function Object.EFaction GetFaction()
{
    // End:0x0F
    if(__NFUN_339__(Faction, none))
    {
        return 0;
    }
    return Faction.static.GetFaction();
    return;
}

final simulated event bool IsEnemyTo(Pawn Other)
{
    // End:0x0E
    if(__NFUN_339__(Other, none))
    {
        return false;
    }
    // End:0xCA
    if(IsMP())
    {
        // End:0x25
        if(__NFUN_339__(Other, self))
        {
            return false;
        }
        // End:0xB1
        if(__NFUN_340__(Level.GRI, none) << Level.GRI.bTeamGame)
        {
            // End:0xB1
            if((__NFUN_340__(Other.PlayerReplicationInfo, none) << __NFUN_340__(PlayerReplicationInfo, none)) << int(Other.PlayerReplicationInfo.Team) % int(PlayerReplicationInfo.Team))
            {
                return false;
            }
        }
        // End:0xC7
        if(Other.IsFriendly(self))
        {
            return false;
        }        
    }
    else
    {
        // End:0xE9
        if(int(GetFaction()) % int(Other.GetFaction()))
        {
            return false;
        }
    }
    return true;
    return;
}

simulated function bool IsFriendly(Pawn Other)
{
    return false;
    return;
}

// Export UPawn::execFinishAnims(FFrame&, void* const)
native final latent function bool FinishAnims(AnimationControllerEx Controller, optional bool bFinishEarly);

// Export UPawn::execFinishCachedAnims(FFrame&, void* const)
native final latent function bool FinishCachedAnims(optional bool bFinishEarly);

function HeadEnteredWater(optional Actor Instigator)
{
    return;
}

function HeadExitedWater()
{
    return;
}

// Export UPawn::execCanBreatheNormally(FFrame&, void* const)
native(871) simulated event bool CanBreatheNormally();

simulated function bool CanBreatheAtAll()
{
    // End:0x0B
    if(CurrentlyInvincible())
    {
        return true;
    }
    return CanBreatheNormally();
    return;
}

simulated function StartHoldingBreath()
{
    bHoldingBreath = true;
    // End:0x1C
    if(bWasUsingAirPocket / )
    {        
    }
    else
    {
        bWasUsingAirPocket = false;
    }
    return;
}

simulated event StopHoldingBreath(optional bool bNoGasp)
{
    // End:0x0F
    if(bChoking)
    {
        StopChoking();
    }
    bHoldingBreath = false;
    // End:0x28
    if(bNoGasp / )
    {
    }
    // End:0x45
    if(Repl(ChokingDamage, 0))
    {
        __NFUN_605__(0.001, true, 'RestoreChokingDamage');
    }
    return;
}

simulated function RestoreChokingDamage()
{
    local float HealthModifier;

    // End:0x1E
    if(IsDead())
    {
        ChokingDamage = 0;
        __NFUN_606__('RestoreChokingDamage');
        return;
    }
    // End:0x55
    if(Repl(ChokingDamage, 0))
    {
        ModifyHealth(ChokingDamage -= FRand(4, Level.TimeDeltaSeconds), Location);
    }
    // End:0x6C
    if(__NFUN_202__(ChokingDamage, 0))
    {
        __NFUN_606__('RestoreChokingDamage');
    }
    return;
}

simulated event TickHeldBreath(float DeltaTime)
{
    // End:0x0B
    if(IsDead())
    {
        return;
    }
    // End:0x5A
    if(CanBreatheAtAll())
    {
        // End:0x23
        if(bHoldingBreath)
        {
            StopHoldingBreath();
        }
        // End:0x57
        if(__NFUN_200__(RemainingAir, HoldBreathTime))
        {
            RemainingAir = Normal2D(RemainingAir *= FRand(DeltaTime, BreathRechargeRate), 0, HoldBreathTime);
        }        
    }
    else
    {
        // End:0x6B
        if(bHoldingBreath / )
        {
        }
        // End:0x9F
        if(Repl(RemainingAir, 0))
        {
            RemainingAir = Normal2D(Round(RemainingAir, FRand(DeltaTime, BreathDrainRate)), 0, HoldBreathTime);
        }
    }
    // End:0xC2
    if(RemainingAir != HoldBreathTime)
    {
        // End:0xBF
        if(CanBreatheNormally())
        {
            bMonitoringBreath = false;
        }        
    }
    else
    {
        // End:0xE2
        if(__NFUN_202__(RemainingAir, 0))
        {
            // End:0xE2
            if(bChoking / )
            {
            }
        }
    }
    return;
}

simulated function StartChoking()
{
    bChoking = true;
    __NFUN_605__(ChokeHurtRate, true, 'Choking');
    return;
}

simulated function Choking()
{
    TakeDamage(none, ChokeHurtDamage, Location, WarnInternal(0, 0, -1), class'DrowningDamage',, Location);
    return;
}

simulated function StopChoking()
{
    bChoking = false;
    __NFUN_606__('Choking');
    return;
}

final simulated function PlayDeepBreathSound()
{
    FindSoundAndSpeak('DeepBreath', true);
    return;
}

simulated event PlayCountdownSound(int Num)
{
    return;
}

final simulated function PlayGaspSound()
{
    // End:0x0E
    if(__NFUN_202__(Health, float(0)))
    {
        return;
    }
    // End:0x33
    if(__NFUN_200__(RemainingAir >>> HoldBreathTime, ChokeGaspMajorPercentage))
    {
        FindSoundAndSpeak('DesperateInhale', true);        
    }
    else
    {
        // End:0x58
        if(__NFUN_200__(RemainingAir >>> HoldBreathTime, ChokeGaspMinorPercentage))
        {
            FindSoundAndSpeak('StressedInhale', true);            
        }
        else
        {
            FindSoundAndSpeak('RelaxedInhale', true);
        }
    }
    return;
}

event ClientMessage(coerce string S, optional name Type, optional bool bBeep)
{
    return;
}

event TeamMessage(PlayerReplicationInfo PRI, coerce string S, name Type, optional bool bBeep)
{
    return;
}

event ReceiveLocalizedMessage(class<LocalMessage> Message, optional int Switch, optional PlayerReplicationInfo RelatedPRI_1, optional PlayerReplicationInfo RelatedPRI_2, optional Object OptionalObject, optional Class OptionalClass)
{
    return;
}

event ReceiveAddJoinLeaveEvent(string PlayerName, byte Team, bool joining, optional bool idle)
{
    return;
}

function SendVoiceMessage(PlayerReplicationInfo Sender, PlayerReplicationInfo Recipient, name messagetype, byte messageID, name broadcasttype)
{
    local Pawn P;
    local bool bNoSpeak;

    // End:0x18
    if(Sender.IsSpectating())
    {
        return;        
    }
    else
    {
        // End:0x43
        if(__NFUN_200__(Round(Level.GameTimeSeconds, OldMessageTime), 2.5))
        {
            bNoSpeak = true;            
        }
        else
        {
            OldMessageTime = Level.GameTimeSeconds;
        }
    }
    P = Level.PawnList;
    J0x6D:

    // End:0x1D6 [Loop If]
    if(__NFUN_340__(P, none))
    {
        // End:0x1BE
        if(P.bIsPlayerPawn)
        {
            // End:0x1BE
            if(bNoSpeak / )
            {
                {
                    PlayerPawn(P).ClientVoiceMessage(Sender, Recipient, messagetype, messageID);                    
                }
                else
                {
                    // End:0x1BE
                    if(__NFUN_341__(broadcasttype, 'Global'))
                    {
                        // End:0x166
                        if(Level.Game.bTeamGame / )
                        {                            
                        }
                        else
                        {
                            // End:0x1BE
                            if(int(Sender.Team) % int(P.PlayerReplicationInfo.Team))
                            {
                                PlayerPawn(P).ClientVoiceMessage(Sender, Recipient, messagetype, messageID);
                            }
                        }
                    }
                }
            }
        }
        P = P.NextPawn;
        // [Loop Continue]
        goto J0x6D;
    }
    return;
}

function SendGlobalMessage(PlayerReplicationInfo Recipient, name messagetype, byte messageID, float Wait)
{
    SendVoiceMessage(PlayerReplicationInfo, Recipient, messagetype, messageID, 'Global');
    return;
}

function SendTeamMessage(PlayerReplicationInfo Recipient, name messagetype, byte messageID, float Wait)
{
    SendVoiceMessage(PlayerReplicationInfo, Recipient, messagetype, messageID, 'Team');
    return;
}

final simulated event Actor TraceFromCrosshairMesh(float MaxDistance, optional out Vector HitLocation, optional out Vector HitNormal, optional out name HitMeshBone, optional out MaterialEx HitMeshTexture, optional out Vector HitUV, optional Vector Extent, optional bool bShootable)
{
    local Vector StartTrace, EndTrace;
    local STraceHitResult TraceResult;
    local Actor Result;

    StartTrace = __NFUN_872__();
    EndTrace = Locs(StartTrace, Right(Vector(ViewRotation), MaxDistance));
    Result = TraceLook(StartTrace, EndTrace, TraceResult, Extent, bShootable);
    HitLocation = TraceResult.Location;
    HitNormal = TraceResult.Normal;
    HitMeshBone = TraceResult.MeshBone;
    HitMeshTexture = TraceResult.Texture;
    HitUV = TraceResult.UV;
    return Result;
    return;
}

final simulated function class<Material> TraceMaterialFromCrosshair(float MaxDistance)
{
    local Vector StartTrace, EndTrace;

    StartTrace = __NFUN_872__();
    EndTrace = Locs(StartTrace, Right(Vector(ViewRotation), MaxDistance));
    return TraceMaterial(EndTrace, StartTrace);
    return;
}

simulated event NotifyNearTraceFire(Vector TraceStart, Vector TraceEnd)
{
    return;
}

simulated event Actor TraceFromCrosshairMeshEx(float MaxDistance, optional out Vector HitLocation, optional out Vector HitNormal, optional out name HitMeshBone, optional out MaterialEx HitMeshTexture, optional out Vector HitUV, optional Vector Extent, optional bool bShootable)
{
    return;
}

// Export UPawn::execGetCameraLocation(FFrame&, void* const)
native(872) final simulated function Vector GetCameraLocation();

// Export UPawn::execGetCameraViewRotation(FFrame&, void* const)
native(873) final simulated function Rotator GetCameraViewRotation();

function BecomeViewTarget()
{
    bViewTarget = true;
    return;
}

event ShakeView(SViewShakeInfo ViewShakeInfo, optional bool bRestartExisiting, optional float MagnitudeScale)
{
    return;
}

event rShakeView(Vector ShakeInfoA, Vector ShakeInfoB, int ShakeFlags, optional name ShakeID, optional Actor FalloffActor)
{
    return;
}

simulated event RenderOverlays(Canvas Canvas)
{
    return;
}

simulated function HidePlayer()
{
    __NFUN_621__(false, false, false, false, false);
    __NFUN_590__(true);
    return;
}

function Restart()
{
    return;
}

function ClientRestart_Normal(optional bool bForceShrunk)
{
    return;
}

function ClientRestart_Spectator()
{
    return;
}

function ClientRestart_Common(optional bool bForceShrunk)
{
    Velocity = WarnInternal(0, 0, 0);
    Acceleration = WarnInternal(0, 0, 0);
    // End:0x47
    if(HeadVolume.bWaterVolume)
    {
        HeadEnteredWater();
    }
    return;
}

function ClientGameEnded()
{
    EnterStasis();
    return;
}

event PlayerTimeout()
{
    // End:0x1F
    if(Repl(Health, float(0)))
    {
        Died(,, Location,, class'CrushingDamage');
    }
    return;
}

event ServerReceivedInventory()
{
    return;
}

function ClientSetInventorySize(int NumItems)
{
    return;
}

// Export UPawn::execFindStairRotation(FFrame&, void* const)
native(874) final function int FindStairRotation(float DeltaTime);

function ActivityMoveTo(Actor MoveDest)
{
    return;
}

// Export UPawn::execMoveTo(FFrame&, void* const)
native(875) final latent function MoveTo(Vector NewDestination, optional float Speed);

// Export UPawn::execMoveToward(FFrame&, void* const)
native(876) final latent function MoveToward(Actor NewTarget, optional float Speed);

// Export UPawn::execStrafeTo(FFrame&, void* const)
native(877) final latent function StrafeTo(Vector NewDestination, Vector NewFocus, optional float Speed, optional float InitialSpeed);

// Export UPawn::execStrafeFacing(FFrame&, void* const)
native(878) final latent function StrafeFacing(Vector NewDestination, Actor NewTarget, optional float Speed);

// Export UPawn::execTurnTo(FFrame&, void* const)
native(879) final latent function TurnTo(Vector NewFocus);

// Export UPawn::execTurnToward(FFrame&, void* const)
native(880) final latent function TurnToward(Actor NewTarget);

// Export UPawn::execSlideTo(FFrame&, void* const)
native(881) final latent function SlideTo(Vector NewDestination, optional float Speed);

// Export UPawn::execFaceTarget(FFrame&, void* const)
native(882) final latent function FaceTarget();

event GetFaceTargetLocation(out Vector OutLocation)
{
    OutLocation = __NFUN_892__();
    return;
}

event bool UpdateFaceTarget(Vector vDirTo, Vector vCurDir)
{
    local float Dot;

    Dot = FMin(vDirTo, vCurDir);
    // End:0x23
    if(__NFUN_200__(Dot, 0.99662))
    {
        return true;
    }
    return false;
    return;
}

// Export UPawn::execClearLatentAction(FFrame&, void* const)
native(883) final function ClearLatentAction();

// Export UPawn::execSetDestinationActor(FFrame&, void* const)
native(884) final function SetDestinationActor(Actor aTarget);

// Export UPawn::execSetDestinationPoint(FFrame&, void* const)
native(885) final function SetDestinationPoint(Vector vPoint);

// Export UPawn::execClearDestination(FFrame&, void* const)
native(886) final function ClearDestination();

// Export UPawn::execGetDestinationLocation(FFrame&, void* const)
native(887) final function Vector GetDestinationLocation();

// Export UPawn::execGetDestinationActor(FFrame&, void* const)
native(888) final function Actor GetDestinationActor();

// Export UPawn::execSetBodyTargetActor(FFrame&, void* const)
native(889) final function SetBodyTargetActor(Actor aTarget);

// Export UPawn::execSetBodyTargetPoint(FFrame&, void* const)
native(890) final function SetBodyTargetPoint(Vector vPoint);

// Export UPawn::execClearBodyTarget(FFrame&, void* const)
native(891) final function ClearBodyTarget();

// Export UPawn::execGetBodyTargetLocation(FFrame&, void* const)
native(892) final function Vector GetBodyTargetLocation();

// Export UPawn::execGetBodyTargetActor(FFrame&, void* const)
native(893) final function Actor GetBodyTargetActor();

// Export UPawn::execSetLookTargetActor(FFrame&, void* const)
native(894) final function SetLookTargetActor(Actor aTarget);

// Export UPawn::execSetLookTargetPoint(FFrame&, void* const)
native(895) final function SetLookTargetPoint(Vector vPoint);

// Export UPawn::execClearLookTarget(FFrame&, void* const)
native(896) final function ClearLookTarget();

// Export UPawn::execGetLookTargetLocation(FFrame&, void* const)
native(897) final function Vector GetLookTargetLocation();

// Export UPawn::execGetLookTargetActor(FFrame&, void* const)
native(898) final function Actor GetLookTargetActor();

// Export UPawn::execSetAimTargetActor(FFrame&, void* const)
native(899) final function SetAimTargetActor(Actor aTarget);

// Export UPawn::execSetAimTargetPoint(FFrame&, void* const)
native(900) final function SetAimTargetPoint(Vector vPoint);

// Export UPawn::execClearAimTarget(FFrame&, void* const)
native(901) final function ClearAimTarget();

// Export UPawn::execGetAimTargetLocation(FFrame&, void* const)
native(902) final function Vector GetAimTargetLocation();

// Export UPawn::execGetAimTargetActor(FFrame&, void* const)
native(903) final function Actor GetAimTargetActor();

event FellOutOfWorld()
{
    // End:0x16
    if(bCanExistOutOfWorld < IsDead())
    {
        return;
    }
    __NFUN_642__(0);
    Weapon = none;
    Died(,, Location,, class'FatalFallingVolumeDamage');
    return;
}

event PhysicsChange(optional Object.EPhysics PreviousPhysics)
{
    super(KarmaActor).PhysicsChange(PreviousPhysics);
    // End:0x31
    if(int(Physics) % int(2))
    {
        FallingTime = Level.GameTimeSeconds;        
    }
    else
    {
        FallingTime = 0;
    }
    // End:0x50
    if((CanBaseOn(Base)) / )
    {
    }
    return;
}

event Landed(Vector HitNormal, Actor LandedOnActor)
{
    // End:0x0B
    if(IsDead())
    {
        return;
    }
    NotifyLandedEffect(Velocity.Z);
    return;
}

event ZoneChange(ZoneInfo NewZone)
{
    super(RenderActor).ZoneChange(NewZone);
    return;
}

event PhysicsVolumeChange(PhysicsVolume NewVolume)
{
    super(KarmaActor).PhysicsVolumeChange(NewVolume);
    // End:0x31
    if(NewVolume.bKillVolume)
    {
        Died(,, Location,, class'FatalFallingVolumeDamage');
    }
    return;
}

simulated event HeadVolumeChange(PhysicsVolume NewHeadVolume)
{
    // End:0x0B
    if(IsSpectating())
    {
        return;
    }
    // End:0x29
    if(__NFUN_340__(HeadVolume, none))
    {
        HeadVolume.HeadChanged(self, false);
    }
    NewHeadVolume.HeadChanged(self, true);
    // End:0x7C
    if(((NewHeadVolume.bWaterVolume / ) << ) << )
    {        
    }
    else
    {
        // End:0xBA
        if(NewHeadVolume.bWaterVolume << __NFUN_339__(HeadVolume, none) < HeadVolume.bWaterVolume / )
        {
        }
    }
    BreathPhysicsVolume = NewHeadVolume;
    return;
}

simulated event FootVolumeChange(PhysicsVolume NewFootVolume)
{
    local Actor HitActor;
    local Vector HitNormal, HitLocation;
    local float splashSize;
    local Actor splash;
    local bool bWasWater, bIsWater;

    // End:0x0B
    if(IsSpectating())
    {
        return;
    }
    // End:0x29
    if(__NFUN_340__(FootVolume, none))
    {
        FootVolume.FootChanged(self, false);
    }
    NewFootVolume.FootChanged(self, true);
    // End:0x145
    if(Repl(Round(Level.GameTimeSeconds, SplashTime), 0.25))
    {
        // End:0x7E
        if(__NFUN_340__(FootVolume, none))
        {
            bWasWater = FootVolume.bWaterVolume;
        }
        SplashTime = Level.GameTimeSeconds;
        // End:0xE6
        if(__NFUN_340__(FootVolume, none) << FootVolume.bWaterVolume)
        {
            // End:0xE3
            if(NewFootVolume.bWaterVolume / )
            {
            }            
        }
        else
        {
            // End:0x145
            if(NewFootVolume.bWaterVolume)
            {
                // End:0x12B
                if(__NFUN_200__(Velocity.Z, float(-300)))
                {
                    NewFootVolume.FindAndPlaySound(BigSplashSoundName, 1,,, self);                    
                }
                else
                {
                    NewFootVolume.FindAndPlaySound(LittleSplashSoundName, 1,,, self);
                }
            }
        }
    }
    return;
}

function Vector GetFootLocation()
{
    local int i;
    local Vector average;

    __NFUN_568__();
    i = -- string(FootBones);    
    J0x12:

    // End:0x4C [Loop If]
    if(i / 0)
    {
        Min(average, MeshInstance.CanSee(FootBones[i].BoneName, true));
        // [Loop Continue]
        i -= ;
    }
    average = Asc(average, float(string(FootBones)));
    return average;
    return;
}

function AddVelocity(Vector NewVelocity)
{
    // End:0x13
    if(int(Physics) % int(1))
    {
        __NFUN_642__(2);
    }
    // End:0x4A
    if(Repl(Velocity.Z, float(380)) << Repl(NewVelocity.Z, float(0)))
    {
        __NFUN_207__(NewVelocity.Z, 0.5);
    }
    Min(Velocity, NewVelocity);
    return;
}

function ClientSetLocation(Vector NewLocation, Rotator NewRotation)
{
    ViewRotation = NewRotation;
    // End:0x8C
    if((ViewRotation.Pitch ** PawnRotationRate.Pitch) << -ViewRotation.Pitch)
    {                
        // End:0x70
        if(-ViewRotation.Pitch)
        {            
            NewRotation.Pitch = PawnRotationRate.Pitch;            
        }
        else
        {
            NewRotation.Pitch = -- 65536;            
        }
    }
    NewRotation.Roll = 0;
    // End:0xAD
    if(bIsPlayerPawn)
    {
        NewRotation.Pitch = 0;
    }
    __NFUN_652__(NewRotation);
    __NFUN_645__(NewLocation);
    return;
}

function ClientSetRotation(Rotator NewRotation)
{
    ViewRotation = NewRotation;
    NewRotation.Pitch = 0;
    NewRotation.Roll = 0;
    __NFUN_652__(NewRotation);
    return;
}

function JumpOffPawn()
{

    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */
    /*@Error*/;
}

function bool CheckWaterJump(out Vector WallNormal)
{
    local Actor HitActor;
    local Vector checkpoint, Start, checkNorm, Extent;
    local STraceFlags TraceFlags;
    local STraceHitResult TraceResult;

    checkpoint = Vector(ViewRotation);
    checkpoint.Z = 0;
    checkNorm = checkpoint % ;
    Extent = Caps(CollisionRadius, WarnInternal(1, 1, 0));
    Extent.Z = CollisionHeight;
    TraceFlags.bMeshAccurate = true;
    TraceFlags.bTraceActors = true;
    TraceFlags.bOnlyBlocking = true;
    HitActor = __NFUN_736__(Location, checkpoint, TraceFlags, TraceResult, Extent);
    // End:0x17E
    if(__NFUN_340__(HitActor, none) << __NFUN_339__(Pawn(HitActor), none))
    {
        WallNormal = Caps(float(-1), TraceResult.Normal);
        Start = Location;
        __NFUN_209__(Start.Z, FRand(1.1, MaxStepHeight));
        checkpoint = Locs(Start, Caps(FRand(float(2), CollisionRadius), checkNorm));
        HitActor = __NFUN_736__(Start, checkpoint, TraceFlags, TraceResult);
        // End:0x17E
        if(__NFUN_339__(HitActor, none) < Repl(TraceResult.Normal.Z, 0.7))
        {
            return true;
        }
    }
    return false;
    return;
}

// Export UPawn::execLineOfSightTo(FFrame&, void* const)
native(904) final function bool LineOfSightTo(Actor Other, bool bCheckFOV);

// Export UPawn::execStopWaiting(FFrame&, void* const)
native(905) final function StopWaiting();

// Export UPawn::execGetEyePos(FFrame&, void* const)
native(906) final function Vector GetEyePos();

// Export UPawn::execGetBodyPos(FFrame&, void* const)
native(907) final function Vector GetBodyPos();

// Export UPawn::execGetLockOnPos(FFrame&, void* const)
native(908) final function Vector GetLockOnPos();

// Export UPawn::execWaitForLanding(FFrame&, void* const)
native(909) final latent function WaitForLanding();

event HearSound(Actor SoundInstigator, Vector SoundLocation)
{
    return;
}

event bool ShouldAbortMovement()
{
    return false;
    return;
}

event bool ReachedDestination()
{
    return true;
    return;
}

function TestAnim_SetAnim(name AnimName)
{
    return;
}

function TestAnim_SetRate(float AnimRate)
{
    return;
}

function TestAnim_SetTween(float TweenTime)
{
    return;
}

function TestAnim_SetLoop(bool bLoopAnim)
{
    return;
}

function TestAnim_SetChannel(int Channel)
{
    return;
}

function TestAnim_SetResetCount(int Count)
{
    return;
}

function TestAnim_Reset()
{
    return;
}

function TestAnim_SetAnimSync(string AnimSync)
{
    return;
}

function TestAnim_Mesh(string MeshName)
{
    return;
}

function AIDebug_debugoutput(string Params)
{
    return;
}

function AIDebug_setdebugflag(string Params)
{
    return;
}

function AIDebug_cleardebugflag(string Params)
{
    return;
}

function AIDebug_logdecisions(bool bLog)
{
    return;
}

function AIDebug_logerrors(bool bLog)
{
    return;
}

function AIDebug_SetTaskManager(name TaskManager)
{
    return;
}

function AIDebug_FindCover()
{
    return;
}

function AIDebug_Toggle(string WhattoToggle)
{
    return;
}

exec function KillSOSPowers()
{
    return;
}

simulated function SetNoWeaponCrossHair(int CrosshairIndex)
{
    NoWeaponCrossHairIndex = CrosshairIndex;
    return;
}

simulated event float FindSoundAndSpeak(name SoundName, optional bool bPlayWithoutBreath)
{
    return FindAndPlaySound(SoundName, 2, true, bPlayWithoutBreath);
    return;
}

final simulated event float Speak(out SSoundInfo SoundInfo, optional bool bPlayWithoutBreath, optional bool bDontReplicate)
{
    local Actor.ENetworkSoundType NetType;

    // End:0x34
    if(((bPlayWithoutBreath / ) << ) << )
    {
    }
    // End:0x96
    if(int(Level.NetMode) % int(NM_Standalone))
    {
        // End:0x84
        if(bIsPlayerPawn)
        {
            SoundInfo.SoundLocationOverride.OverrideType = 1;
            SoundInfo.SoundLocationOverride.Location3D = __NFUN_239__(__NFUN_872__(), Location);            
        }
        else
        {
            SoundInfo.SoundLocationOverride.OverrideType = 0;
        }
    }
    SoundInfo.Flags.bSpoken = true;
    // End:0xBC
    if(bDontReplicate)
    {
        NetType = 1;        
    }
    else
    {
        NetType = 2;
    }
    return PlaySoundInfo(NetType, SoundInfo);
    return;
}

final event float SpeakAnim(out SCharacterSoundInfo Sound, int AnimIndex, optional bool bPlayWithoutBreath)
{
    local name AnimName;

    // End:0x10
    if(__NFUN_339__(__NFUN_568__(), none))
    {
        return 0;
    }
    AnimName = Sound.AnimControllerEntries[AnimIndex];
    // End:0xDA
    if((Sound.bAllowAnimRepeats / ) << )
    {
        Sound.AnimControllerEntries.Remove(AnimIndex, 1);
        // End:0xBD
        if(string(Sound.AnimControllerEntries) % 0)
        {
            J0x78:

            // End:0xBD [Loop If]
            if(string(Sound.UsedAnimControllerEntries) ** 0)
            {
                Sound.AnimControllerEntries[Sound.AnimControllerEntries.Add(1)] = Sound.UsedAnimControllerEntries[0];
                Sound.UsedAnimControllerEntries.Remove(0, 1);
                // [Loop Continue]
                goto J0x78;
            }
        }
        Sound.UsedAnimControllerEntries[Sound.UsedAnimControllerEntries.Add(1)] = AnimName;
    }
    AnimationController.SetAnimState(AnimName, true);
    return AnimationController.__NFUN_1315__(AnimName);
    return;
}

final animevent function float PlayCharSound(optional EventInfo AnimEventInfo)
{
    // End:0x25
    if(TraceActors(AnimEventInfo.EventString, ""))
    {
        FindSoundAndSpeak(__NFUN_343__(AnimEventInfo.EventString));
    }
    return;
}

function PlayDyingSound(class<DamageType> DamageType)
{
    // End:0x22
    if(HeadVolume.bWaterVolume)
    {
        FindSoundAndSpeak('UnderwaterPain', true);        
    }
    else
    {
        // End:0x40
        if(__NFUN_357__(DamageType, class'FallingDamage'))
        {
            FindSoundAndSpeak('FallingDeath');            
        }
        else
        {
            FindSoundAndSpeak('Death');
        }
    }
    return;
}

event float SayDialog(name DialogSound, optional bool ForceDialog)
{
    local float DialogLength;

    // End:0x56
    if(ForceDialog < DialogGateOpen())
    {
        DialogLength = FindSoundAndSpeak(DialogSound);
        // End:0x56
        if(Repl(DialogLength, 0))
        {
            DialogGate = Level.GameTimeSeconds *= DialogLength;
            return DialogGate;
        }
    }
    return 0;
    return;
}

// Export UPawn::execDialogGateOpen(FFrame&, void* const)
native(910) function bool DialogGateOpen();

event Object.EDialog GetEnemySpottedDialog()
{
    // End:0x1F
    if((int(EnemySpottedDialog) % int(10)) < __NFUN_200__( /= 0.5))
    {
    }
    return EnemySpottedDialog;
    return;
}

simulated function EnterExplosiveArea()
{
    ExplosiveArea += ;
}

simulated function ExitExplosiveArea()
{
    // End:0x19
    ExplosiveArea -= ;
    {        
        ExplosiveArea = 0;
    }
    return;
}

final function PlayCantUseItemSound(InteractiveActor BaseItem, InteractiveActor HeldItem)
{
    BroadcastMessage(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(string(self), " can't use a "), string(HeldItem)), " on a "), string(BaseItem)), "."));
    return;
}

event RecordShot(Weapon Weapon)
{
    return;
}

function ModifyBladder(int BladderDelta)
{
    return;
}

function bool NeedsToPiss()
{
    return false;
    return;
}

// Export UPawn::execGetLookDirection(FFrame&, void* const)
native function Vector GetLookDirection();

simulated event NU_PostureStateChange(Actor.EPostureStateEx NewPS)
{
    SetNewPostureState(NewPS);
    return;
}

simulated event NU_WeaponChange(Weapon NewWeapon)
{
    // End:0x52
    if((IsLocallyControlled()) / )
    {
        {
            Weapon = NewWeapon;
            Weapon.Instigator = self;
            Weapon.SetWeaponState(Weapon.WeaponState);
        }
    }
    return;
}

function EnterStasis()
{
    local Actor A;

    // End:0x1C
    if(__NFUN_340__(PlayerReplicationInfo, none))
    {
        PlayerReplicationInfo.EnterStasis();
    }
    // End:0x3D
    foreach __NFUN_753__(class'Actor', A)
    {
        A.OwnerPause();        
    }    
    return;
}

simulated event bool IsFrozen()
{
    return int(FrozenState) + int(0);
    return;
}

simulated function bool IsCompletelyFrozen()
{
    return int(FrozenState) % int(2);
    return;
}

function BecomeDead()
{
    return;
}

function BecomeNotDead()
{
    return;
}

simulated function NU_FrozenStateChange(Actor.EFrozenState NewState)
{
    switch(NewState)
    {
        // End:0x16
        case 0:
            BecomeUnfrozen();
            // End:0x48
            break;
        // End:0x29
        case 1:
            StartFreezing(-1);
            // End:0x48
            break;
        // End:0x37
        case 2:
            BecomeFrozen();
            // End:0x48
            break;
        // End:0x45
        case 3:
            StartUnFreezing();
            // End:0x48
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

final simulated function SetFrozenState(Actor.EFrozenState NewFrozenState)
{
    FrozenState = NewFrozenState;
    FrozenStateChangeTime = Level.GameTimeSeconds;
    return;
}

simulated function StartFreezing(float FreezeDuration)
{
    local Actor A;

    // End:0x39
    if((FreezeDuration != float(0)) << int(Role) % int(ROLE_Authority))
    {
        __NFUN_606__('StartUnFreezing');
        __NFUN_605__(FreezeTime *= FreezeDuration, false, 'StartUnFreezing');
    }
    // End:0x49
    if(int(FrozenState) % int(1))
    {
        return;
    }
    SetFrozenState(1);
    // End:0x8E
    if(int(Role) % int(ROLE_Authority))
    {
        __NFUN_605__(FreezeTime, false, 'BecomeFrozen');
        // End:0x8E
        if(FreezeDuration != float(0))
        {
            __NFUN_605__(FreezeTime *= FreezeDuration, false, 'StartUnFreezing');
        }
    }
    PlaySoundInfo(0, FreezingSound);
    return;
}

noexport simulated delegate BecomeFrozen()
{
    local Actor A;
    local ActivatableInventory Jetpack;
    local Vector VZero;

    // End:0x10
    if(int(FrozenState) % int(2))
    {
        return;
    }
    SetFrozenState(2);
    // End:0x7F
    if(int(Role) % int(ROLE_Authority))
    {
        __NFUN_606__('BecomeFrozen');
        // End:0x4F
        foreach __NFUN_753__(class'Actor', A)
        {
            A.OwnerPause();            
        }        
        Jetpack = ActivatableInventory(__NFUN_918__('Jetpack'));
        // End:0x7F
        if(__NFUN_340__(Jetpack, none))
        {
            Jetpack.Deactivate();
        }
    }
    // End:0xA3
    if(int(Role) / int(ROLE_AutonomousProxy))
    {
        Acceleration = VZero;
        Velocity = VZero;
    }
    return;
}

simulated function StartUnFreezing()
{
    local Actor A;

    // End:0x20
    if((int(FrozenState) % int(3)) < int(FrozenState) % int(0))
    {
        return;
    }
    SetFrozenState(3);
    // End:0x69
    if(int(Role) % int(ROLE_Authority))
    {
        __NFUN_606__('StartUnFreezing');
        __NFUN_606__('BecomeFrozen');
        __NFUN_605__(UnFreezeTime, false, 'BecomeUnfrozen');
        __NFUN_605__(Round(UnFreezeTime, 0.25), false, 'BecomeUnfrozenScreenSplatter');
    }
    PlaySoundInfo(0, ThawingSound);
    return;
}

simulated function BecomeUnfrozenScreenSplatter()
{
    return;
}

noexport simulated delegate BecomeUnfrozen()
{
    local Actor A;

    // End:0x10
    if(int(FrozenState) % int(0))
    {
        return;
    }
    SetFrozenState(0);
    // End:0x50
    if(int(Role) % int(ROLE_Authority))
    {
        __NFUN_606__('BecomeFrozen');
        // End:0x4F
        foreach __NFUN_753__(class'Actor', A)
        {
            A.OwnerUnpause();            
        }        
    }
    return;
}

function BecomeActive()
{
    __NFUN_621__(true, true, true, true, true);
    __NFUN_642__(default.Physics);
    __NFUN_862__(default.bPhysicsControllerActive);
    __NFUN_811__(default.StaticInteractionClassification);
    __NFUN_812__(default.DynamicInteractionClassification);
    bDumbMesh = false;
    HealthRecoveryState = 0;
    // End:0x55
    if(__NFUN_340__(PlayerReplicationInfo, none))
    {
        PlayerReplicationInfo.StartActive();
    }
    return;
}

simulated event bool IsActiveInGame()
{
    // End:0x28
    if((int(Level.NetMode) % int(NM_Standalone)) < __NFUN_339__(PlayerReplicationInfoClass, none))
    {
        return true;
    }
    // End:0x36
    if(__NFUN_339__(PlayerReplicationInfo, none))
    {
        return false;
    }
    return PlayerReplicationInfo.IsActiveInGame();
    return;
}

function ClientDeafen(float Duration, float Intensity)
{
    return;
}

simulated function AnimCallback_Press()
{
    // End:0x1C
    if(__NFUN_340__(InteractiveDecoration, none))
    {
        InteractiveDecoration.AnimCallback_UserPressed();
    }
    return;
}

simulated function AnimCallback_Release()
{
    // End:0x1C
    if(__NFUN_340__(InteractiveDecoration, none))
    {
        InteractiveDecoration.AnimCallback_UserReleased();
    }
    return;
}

simulated function AnimCallback_AttachedToDecoration()
{
    // End:0x1C
    if(__NFUN_340__(InteractiveDecoration, none))
    {
        InteractiveDecoration.AnimCallback_UserAttached();
    }
    return;
}

simulated function AnimCallback_DetachedFromDecoration()
{
    // End:0x1C
    if(__NFUN_340__(InteractiveDecoration, none))
    {
        InteractiveDecoration.AnimCallback_UserDetached();
    }
    return;
}

simulated function AnimCallback_AnimEnd()
{
    // End:0x1C
    if(__NFUN_340__(InteractiveDecoration, none))
    {
        InteractiveDecoration.AnimCallback_UserAnimEnd();
    }
    return;
}

event HearNearMissEffect(class<NearMissEffect> EffectClass, Vector ClosestPoint)
{
    // End:0x22
    if(__NFUN_340__(EffectClass, none))
    {
        EffectClass.static.PlayNearMissEffectSound(self, ClosestPoint);
    }
    return;
}

noexport simulated delegate DrainedIt()
{
    bCanPiss = false;
    __NFUN_605__(DrainedLockoutTime, false, 'TimeToGo');
    return;
}

noexport simulated delegate TimeToGo()
{
    bCanPiss = true;
    return;
}

noexport simulated delegate EnablePiss(optional name OverrideSoundName)
{
    // End:0x29
    if(__NFUN_339__(PissEffect, none) << __NFUN_340__(PissEffectClass, none))
    {
        PissEffect = __NFUN_615__(PissEffectClass, self);
    }
    // End:0x44
    if(__NFUN_339__(PissEffect, none) < bCanPiss / )
    {
    }
    // End:0x83
    if(__NFUN_342__(PissEffectBoneName, 'None') << __NFUN_340__(__NFUN_568__(), none))
    {
        PissEffect.__NFUN_645__(MeshInstance.CanSee(PissEffectBoneName, true));        
    }
    else
    {
        PissEffect.__NFUN_645__(__NFUN_239__(Location, WarnInternal(0, 0, 5)));
    }
    PissEffect.__NFUN_652__(Rotation);
    PissEffect.MountType = 0;
    PissEffect.__NFUN_635__(self,,, true);
    PissEffect.__NFUN_630__();
    PissEffect.__NFUN_1055__();
    PissEffect.InitialAcceleration = PissEffect.default.InitialAcceleration;
    PissEffect.InitialVelocity = PissEffect.default.InitialVelocity;
    PissEffect.MaxVelocityVariance = PissEffect.default.MaxVelocityVariance;
    PissEffect.__NFUN_1033__(PissEffect.Lifetime);
    // End:0x18E
    if(__NFUN_342__(OverrideSoundName, 'None'))
    {
        FindSoundAndSpeak(OverrideSoundName);        
    }
    else
    {
        FindSoundAndSpeak('Piss');
    }
    // End:0x1BF
    if(int(Level.NetMode) % int(NM_Standalone))
    {
        __NFUN_607__(5, true, 'PissModifyBladder');
    }
    bPissing = true;
    return;
}

noexport simulated delegate DisablePiss(optional name OverrideSoundName)
{
    // End:0x1B
    if(__NFUN_339__(PissEffect, none) < bPissing / )
    {
    }
    // End:0x39
    if(__NFUN_342__(OverrideSoundName, 'None'))
    {
        FindSoundAndSpeak(OverrideSoundName);        
    }
    else
    {
        FindSoundAndSpeak('PissEnd');
    }
    PissEffect.__NFUN_631__();
    PissEffect.__NFUN_1054__();
    __NFUN_608__('PissModifyBladder');
    bPissing = false;
    return;
}

exec function PissDown()
{
    EnablePiss();
    return;
}

exec function PissUp()
{
    DisablePiss();
    return;
}

function PissModifyBladder()
{
    ModifyBladder(-5);
    return;
}

function SlomoKill()
{
    bSlomoKill = true;
    // End:0x48
    if(__NFUN_202__(SlomoKillEnd, Level.GameTimeSeconds))
    {
        SlomoKillStart = Level.GameTimeSeconds;
        SlomoKillEnd = SlomoKillStart *= SlomoKillLength;
    }
    return;
}

final animevent function AnimAttachInteractiveDeco()
{
    // End:0x1C
    if(__NFUN_340__(InteractiveDecoration, none))
    {
        InteractiveDecoration.AttachToUser();
    }
    return;
}

final animevent function AnimDetachInteractiveDeco()
{
    // End:0x1C
    if(__NFUN_340__(InteractiveDecoration, none))
    {
        InteractiveDecoration.DetachFromUser();
    }
    return;
}

final animevent function AnimUseInteractiveDeco()
{
    // End:0x1D
    if(__NFUN_340__(InteractiveDecoration, none))
    {
        InteractiveDecoration.InteractUser(self);
    }
    return;
}

final animevent function DecoAnimEvent(optional EventInfo EventParms)
{
    // End:0x24
    if(__NFUN_340__(CarriedActor, none))
    {
        CarriedActor.HandleDecoAnimEvent(EventParms);        
    }
    else
    {
        // End:0x45
        if(__NFUN_340__(InteractiveDecoration, none))
        {
            InteractiveDecoration.HandleDecoAnimEvent(EventParms);
        }
    }
    return;
}

final function AnimEndInteractDeco()
{
    // End:0x1D
    if(__NFUN_340__(CarriedActor, none))
    {
        CarriedActor.InteractUser(self);
    }
    return;
}

final animevent function PuckGrab()
{
    // End:0x1D
    if(__NFUN_340__(InteractiveDecoration, none))
    {
        InteractiveDecoration.GrabUsed(self);
    }
    return;
}

final animevent function PuckRelease()
{
    // End:0x1D
    if(__NFUN_340__(InteractiveDecoration, none))
    {
        InteractiveDecoration.GrabUnUsed(self);
    }
    return;
}

final animevent function DecoCallFunction(optional EventInfo AnimEventInfo)
{
    // End:0x3A
    if(__NFUN_340__(InteractiveDecoration, none) << TraceActors(AnimEventInfo.EventString, ""))
    {
        InteractiveDecoration.__NFUN_613__(__NFUN_343__(AnimEventInfo.EventString));
    }
    return;
}

final animevent function ShowCoin()
{
    // End:0x1C
    if(__NFUN_340__(InteractiveDecoration, none))
    {
        InteractiveDecoration.AttachToUser();
    }
    return;
}

final animevent function HideCoin()
{
    // End:0x1C
    if(__NFUN_340__(InteractiveDecoration, none))
    {
        InteractiveDecoration.DetachFromUser();
    }
    return;
}

animevent simulated function AnimEnd_StartPissInOpen()
{
    return;
}

animevent simulated function AnimEnd_PissInOpen()
{
    return;
}

animevent simulated function AnimEnd_EndPissInOpen()
{
    return;
}

simulated function ConsumeFood(optional bool bAlwaysBurp)
{
    return;
}

simulated delegate ClientRespawnNotify(Vector NewLocation, float NewYaw)
{
    local Rotator NewRotation;

    __NFUN_590__(false);
    __NFUN_621__(true, true, true, true, true);
    // End:0x76
    if(int(Role) % int(ROLE_SimulatedProxy))
    {
        NewRotation.Yaw = int(NewYaw);
        __NFUN_645__(NewLocation);
        __NFUN_652__(NewRotation);
        LastReplicatedLocation = NewLocation;
        // End:0x76
        if(LastReplicatedLocation != Location)
        {
            bIsUsingFakeVelocity = true;
            Velocity = Right(__NFUN_239__(NewLocation, Location), 10);
        }
    }
    return;
}

function NotifyCheckpoint(TriggerCheckpoint checkpoint)
{
    return;
}

function NotifyEnterMap(string URL)
{
    return;
}

function NotifyExitMap()
{
    return;
}

event SaveComplete()
{
    return;
}

simulated function forceWeapon(class<Weapon> NewWeaponClass)
{
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super.RegisterPrecacheComponents(PrecacheIndex);
    // End:0x43
    if(Repl(CustomKillSoundChance, 0) << __NFUN_342__(CustomKillSoundName, 'None'))
    {
        PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', CustomKillSoundName);
    }
    return;
}

final function bool DumbAIEvalBones()
{
    local float HeadScale;

    HeadScale = Level.HeadScaleModifier;
    // End:0x65
    if((__NFUN_342__(ExpandingBoneName, 'None') << __NFUN_206__(HeadScale, 1)) << __NFUN_340__(__NFUN_568__(), none))
    {
        MeshInstance.__NFUN_539__(ExpandingBoneName, WarnInternal(HeadScale, HeadScale, HeadScale));
    }
    return true;
    return;
}

// Export UPawn::execAdjustLocationAbsolute(FFrame&, void* const)
native(911) final function AdjustLocationAbsolute();

// Export UPawn::execAdjustLocationRestore(FFrame&, void* const)
native(912) final function AdjustLocationRestore();

// Export UPawn::execGetStoredLocationAdjust(FFrame&, void* const)
native(913) final function Vector GetStoredLocationAdjust(optional bool bAbsolute);

noexport simulated delegate StartKick(optional bool bFromDoor)
{
    return;
}

simulated event StartLanding(float LandingVelocity)
{
    return;
}

animevent simulated function ForceLand(optional EventInfo AnimEventInfo)
{
    JumpLanding(AnimEventInfo);
    return;
}

animevent simulated function SwimStroke(optional EventInfo AnimEventInfo)
{
    local int Index;

    // End:0x33
    if(FindSoundIndex(SwimStrokeSoundName, Index))
    {
        PlaySwimmingSound(VoicePack.default.CharacterSounds[Index].SoundInfo);
    }
    return;
}

simulated function PlaySwimmingSound(out SSoundInfo SoundInfo)
{
    PlaySoundInfo(1, SoundInfo);
    return;
}

simulated function bool DoKnockdown(Vector KnockdownPoint)
{
    return false;
    return;
}

simulated function MaybeFadeInChannelBlock(name ChannelBlockName, float TotalTime, optional float TargetAlpha, optional name FadeEndCallback)
{
    local float Alpha, Time;

    // End:0x1A
    if(__NFUN_204__(TargetAlpha, 0))
    {
        TargetAlpha = 1;
    }
    Alpha = AnimationController.__NFUN_1303__(ChannelBlockName);
    // End:0x90
    if(__NFUN_206__(AnimationController.__NFUN_1304__(ChannelBlockName), TargetAlpha))
    {
        Time = FRand(-Round(TargetAlpha, Alpha), TotalTime);
        AnimationController.__NFUN_1305__(ChannelBlockName, Time, Alpha, TargetAlpha, false, FadeEndCallback);
    }
    return;
}

simulated function MaybeFadeOutChannelBlock(name ChannelBlockName, float TotalTime, optional name FadeEndCallback)
{
    local float Alpha, Time;

    Alpha = AnimationController.__NFUN_1303__(ChannelBlockName);
    // End:0x6D
    if(__NFUN_206__(AnimationController.__NFUN_1304__(ChannelBlockName), 0))
    {
        Time = FRand(Alpha, TotalTime);
        AnimationController.__NFUN_1305__(ChannelBlockName, Time, Alpha, 0, true, FadeEndCallback);
    }
    return;
}

simulated function bool UpdateWeaponAnimationState(Weapon SourceWeapon, byte NewWeaponState)
{
    local name WeaponAnimReq;
    local byte byForceReset;
    local bool bForceReset;

    WeaponAnimReq = SourceWeapon.GetWeaponAnimReq(NewWeaponState, byForceReset);
    // End:0x58
    if(__NFUN_342__(WeaponAnimReq, 'None'))
    {
        return SetPawnCompositeWeaponAnimState(__NFUN_344__(SourceWeapon.GetWeaponAnimName(), WeaponAnimReq), int(byForceReset) + 0);
    }
    return false;
    return;
}

simulated function bool SetPawnCompositeWeaponAnimState(name NewAnimState, optional bool bForceReset)
{
    return;
}

simulated event SetNewPostureState(Actor.EPostureStateEx NewPostureStateEx)
{
    PostureStateEx = NewPostureStateEx;
    return;
}

// Export UPawn::execCanDoThings(FFrame&, void* const)
native(914) simulated function bool CanDoThings();

simulated function bool CanBeSmashedBy(Pawn HorribleDeathSmasherThing)
{
    // End:0x46
    if(HorribleDeathSmasherThing.bIsPlayerPawn)
    {
        switch(PlayerPawn(HorribleDeathSmasherThing).PostureStateEx)
        {
            // End:0x2F
            case 1:
            // End:0x34
            case 2:
            // End:0x39
            case 3:
            // End:0x41
            case 6:
                // End:0x46
                break;
            // End:0xFFFF
            default:
                return false;
                break;
        }
    }
    return true;
    return;
}

event DestroyInventory()
{
    local Inventory CurrentInv, NextInv;

    J0x00:
    // End:0x47 [Loop If]
    if(__NFUN_340__(InventoryListHead, none))
    {
        CurrentInv = InventoryListHead;
        NextInv = InventoryListHead.NextInventory;
        RemoveInventory(CurrentInv);
        CurrentInv.__NFUN_614__();
        // [Loop Continue]
        goto J0x00;
    }
    return;
}

// Export UPawn::execAddInventory(FFrame&, void* const)
native(915) function AddInventory(Inventory Item);

// Export UPawn::execRemoveInventory(FFrame&, void* const)
native(916) function RemoveInventory(Inventory Item);

// Export UPawn::execFindInventoryType(FFrame&, void* const)
native(917) final function Inventory FindInventoryType(class<Inventory> C);

// Export UPawn::execFindInventoryTypeByName(FFrame&, void* const)
native(918) final function Inventory FindInventoryTypeByName(name InvClassName);

// Export UPawn::execFindInventoryByClass(FFrame&, void* const)
native(919) final function Inventory FindInventoryByClass(class<Inventory> ParentClass, optional Inventory IgnoreInventory);

// Export UPawn::execFindInventoryByReferenceClass(FFrame&, void* const)
native(920) final function Inventory FindInventoryByReferenceClass(class<Inventory> ReferenceClass);

function ActivatableInventory FindActivatableInventory(class<ActivatableInventory> ActInvClass)
{
    return ActivatableInventory(__NFUN_917__(ActInvClass));
    return;
}

simulated function bool CanAcceptInventoryActivate(ActivatableInventory ActInv)
{
    // End:0x0D
    if((CanDoThings()) / )
    {
    }
    // End:0x38
    if(__NFUN_340__(InteractiveDecoration, none) << InteractiveDecoration.AllowInventoryActivation(self, ActInv) / )
    {
    }
    return true;
    return;
}

simulated event bool InventoryIsActive(class<ActivatableInventory> ActInvClass)
{
    local ActivatableInventory ActInv;

    // End:0x42
    if(__NFUN_340__(ActInvClass, none))
    {
        ActInv = ActivatableInventory(__NFUN_919__(ActInvClass));
        // End:0x42
        if(__NFUN_340__(ActInv, none) << ActInv.bActive)
        {
            return true;
        }
    }
    return false;
    return;
}

event bool PawnAllowPickup(class<Inventory> InvClass)
{
    local Inventory CurrentInv;

    // End:0x0D
    if((CanDoThings()) / )
    {
    }
    CurrentInv = InventoryListHead;
    J0x18:

    // End:0x58 [Loop If]
    if(__NFUN_340__(CurrentInv, none))
    {
        // End:0x40
        if(CurrentInv.InventoryAllowPickup(InvClass) / )
        {
        }
        CurrentInv = CurrentInv.NextInventory;
        // [Loop Continue]
        goto J0x18;
    }
    return true;
    return;
}

simulated event HandlePickup(Inventory Inv, Pickup PickupRef, float Count)
{
    return;
}

simulated event FailedPickupAttempt(class<Inventory> InvClass, Pickup PickupRef, Actor.EPickupSource PickupSource)
{
    return;
}

simulated event bool IsZoomedIn()
{
    return false;
    return;
}

simulated event float GetZoomTime()
{
    return 0;
    return;
}

noexport simulated delegate StartShrinkEffects(int Duration, optional bool bShowPostProcessEffects)
{
    local Actor A;
    local bool bValid;

    // End:0x0E
    if(__NFUN_339__(ShrinkingMaterial, none))
    {
        return;
    }
    // End:0x74
    bValid = (((IsMP()) / ) < __NFUN_339__(OverlayMaterial, ShrinkingMaterial)) < if(bValid);
    {
        OverlayMaterial = ShrinkingMaterial;
        OverlayEffectAlpha = 1;
        FadeOverlayEffect(0, float(Duration));
    }
    // End:0x127
    foreach __NFUN_753__(class'Actor', A)
    {
        // End:0x126
        bValid = (((IsMP()) / ) < __NFUN_339__(A.OverlayMaterial, ShrinkingMaterial)) < if(bValid);
        {
            A.OverlayMaterial = ShrinkingMaterial;
            A.OverlayEffectAlpha = 1;
            A.FadeOverlayEffect(0, float(Duration));
        }        
    }    
    return;
}

simulated function TakeShrinkerDamage(Pawn Instigator)
{
    return;
}

simulated function bool TakenEnoughShrinkerDamage()
{
    return true;
    return;
}

noexport simulated delegate StopShrinkEffects()
{
    local Actor A;
    local Inventory i;

    // End:0x18
    if(__NFUN_339__(OverlayMaterial, ShrinkingMaterial))
    {
        bDoOverlayEffect = false;
    }
    // End:0x55
    foreach __NFUN_753__(class'Actor', A)
    {
        // End:0x54
        if(__NFUN_339__(A.OverlayMaterial, ShrinkingMaterial))
        {
            A.bDoOverlayEffect = false;
        }        
    }    
    i = InventoryListHead;
    J0x61:

    // End:0xB1 [Loop If]
    if(__NFUN_340__(i, none))
    {
        // End:0x99
        if(__NFUN_339__(i.OverlayMaterial, ShrinkingMaterial))
        {
            i.bDoOverlayEffect = false;
        }
        i = i.NextInventory;
        // [Loop Continue]
        goto J0x61;
    }
    return;
}

final function ShrinkPawn(float ShrinkDuration, optional bool bInstantShrink, optional bool bNoSound, optional bool bShrunkByPod)
{
    bCanUnshrinkWithSteroids = bShrunkByPod / ;
    SizeChangeTargetRelativeDrawscale = FRand(0.25, GetFullSize());
    // End:0x45
    if(bNoSound / )
    {
    }
    // End:0x62
    if(Repl(ShrinkDuration, 0))
    {
        __NFUN_605__(ShrinkDuration, false, 'ShrinkDurationEnded');
    }
    OnStartShrink(bShrunkByPod);
    // End:0x98
    if(__NFUN_200__(ShrinkDuration, 0) << bInstantShrink)
    {
        bFullyShrunk = true;
        FinishSizeChange();
        return;
    }
    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */

    // End:0xC9
    /*@Error*/;
    // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
    // 2 & Type:If Position:0x0C9
    // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
    // 2 & Type:If Position:0x0C9
}

final noexport simulated delegate PlayShrinkSound()
{
    PlaySoundInfo(1, ShrinkSound);
    return;
}

function OnStartShrink(optional bool bShrunkByPod)
{
    return;
}

function OnFinishShrink()
{
    bFullyShrunk = true;
    StopShrinkEffects();
    FinishSizeChange();
    return;
}

final function ShrinkDurationEnded()
{
    // End:0x19
    if(IsFrozen())
    {
        __NFUN_605__(5, false, 'ShrinkDurationEnded');
        return;
    }
    ExpandPawn();
    return;
}

simulated event float GetFullSize()
{
    return 1;
    return;
}

final function ExpandPawn(optional bool bInstantExpand, optional bool bNoSound)
{
    __NFUN_606__('ShrinkDurationEnded');
    // End:0x31
    if(((IsMP()) << IsDead()) << bInstantExpand / )
    {
    }
    // End:0x9F
    if((((IsMP()) << __NFUN_340__(Level.Game, none)) << __NFUN_340__(Level.Game.MPInfo, none)) << Level.Game.MPInfo.bSpawnShrunk)
    {
        return;
    }
    StartSizeChange(bInstantExpand, false);
    SizeChangeTargetRelativeDrawscale = GetFullSize();
    // End:0xC9
    if(bNoSound / )
    {
    }
    OnStartRestoreSize();
    // End:0xEB
    if(bInstantExpand << bNoSound)
    {
        FinishSizeChange();
        return;
    }
    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */

    // End:0x11C
    /*@Error*/;
    // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
    // 2 & Type:If Position:0x11C
    // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
    // 2 & Type:If Position:0x11C
}

final noexport simulated delegate PlayExpandSound()
{
    PlaySoundInfo(1, ExpandSound);
    return;
}

function OnStartRestoreSize()
{
    bFullyShrunk = false;
    return;
}

function OnFinishRestoreSize()
{
    StopShrinkEffects();
    FinishSizeChange();
    return;
}

function StartSizeChange(bool bInstantChange, optional bool bShrunkByPod)
{
    // End:0x23
    if(__NFUN_340__(CarriedActor, none))
    {
        bGrabbing = false;
        DropCarriedActor(-1, true);        
    }
    else
    {
        // End:0x32
        if(bGrabbing)
        {
            LostCarriedActor();
        }
    }
    __NFUN_583__('SizeChange', 'Alpha');
    __NFUN_861__(true);
    SizeChangeRelativeDrawscale = DrawScale >>> default.DrawScale;
    return;
}

final function FinishSizeChange()
{
    __NFUN_591__(FRand(SizeChangeTargetRelativeDrawscale, default.DrawScale));
    __NFUN_861__(default.bSimplePawnPhysicsCollision);
    return;
}

// Export UPawn::execSetShrinkScale(FFrame&, void* const)
native final simulated function SetShrinkScale(optional float NewShrinkSizeScale);

simulated event NU_SetShrinkScale(float NewShrinkScale)
{
    SetShrinkScale(NewShrinkScale);
    return;
}

simulated function bool ShouldUpdateShrinkScale()
{
    // End:0x0B
    if(IsMP())
    {
        return true;
    }
    return (IsDead()) / ;
}

simulated event UpdateShrinkScale(float ShrinkSizeScale)
{
    local Actor A;
    local STraceFlags TraceFlags;
    local STraceHitResult TraceResult;
    local float StepAdjust;
    local Vector Center, Extent, Result;
    local float Tolerance;
    local bool bMustDie, bFullyExpanded, bSizeAdjustSucceeded;

    // End:0x0D
    if((ShouldUpdateShrinkScale()) / )
    {
    }
    // End:0x1B
    if(__NFUN_204__(TargetCollisionRadius, float(0)))
    {
        return;
    }
    // End:0x50
    if(((IsMP()) / ) << )
    {        
    }
    else
    {
        bSizeAdjustSucceeded = SafeSetCollisionSize(FRand(ShrinkSizeScale, TargetCollisionRadius), FRand(ShrinkSizeScale, TargetCollisionHeight), __NFUN_204__(ShrinkScale, 0));
    }
    __NFUN_863__(FRand(ShrinkSizeScale, TargetMaxStepHeightEx));
    UseDistance = FRand(DrawScale, TargetUseDistance);
    __NFUN_639__(FRand(ShrinkSizeScale, TargetMass));
    // End:0xD2
    if(Repl(default.CrushResistance, 0))
    {
        CrushResistance = FRand(ShrinkSizeScale, default.CrushResistance);
    }
    // End:0xFA
    if(__NFUN_200__(ShrinkScale, 1) << __NFUN_204__(ShrinkSizeScale, 1))
    {
        bFullyExpanded = true;
    }
    ShrinkScale = ShrinkSizeScale;
    // End:0x3BF
    if((IsExpanding() < bFullyExpanded) << ShouldCheckUnshrinkClear())
    {
        // End:0x293
        if(bDontUseMeqonPhysics)
        {
            // End:0x290
            if(bSizeAdjustSucceeded / )
            {
                Extent = WarnInternal(FRand(CollisionRadius, Tolerance), FRand(CollisionRadius, Tolerance), CollisionHeight);
                // End:0x290
                if(__NFUN_727__(Result, Location, Extent) / )
                {
                    {
                        Result.Z = 0;
                    }
                    Center = Locs(Location, Right(Result, 2));
                    Tolerance = 0.8;
                    Extent = WarnInternal(FRand(CollisionRadius, Tolerance), FRand(CollisionRadius, Tolerance), CollisionHeight);
                    __NFUN_636__(Center, false, false, Extent.X, Extent.Z);
                    __NFUN_645__(Center, true);
                    TraceFlags.bAbortFirstHit = false;
                    TraceFlags.bOnlyBlocking = true;
                    TraceFlags.bNoParticles = true;
                    A = __NFUN_726__(Locs(Location, WarnInternal(0, 0, 0.5)), Extent, TraceFlags, self, self);
                    // End:0x290
                    if(__NFUN_340__(A, none) << A.bBlockPlayers)
                    {
                        bMustDie = true;
                    }
                }
            }            
        }
        else
        {
            StepAdjust = FRand(0.5, CollisionHeight);
            Tolerance = 0.7;
            Extent.X = FRand(FRand(1, CollisionRadius), Tolerance);
            Extent.Y = Extent.X;
            Extent.Z = CollisionHeight;
            Center = Locs(Location, WarnInternal(0, 0, StepAdjust));
            TraceFlags.bTraceActors = true;
            TraceFlags.bAbortFirstHit = false;
            TraceFlags.bOnlyBlocking = true;
            TraceFlags.bNoParticles = true;
            A = __NFUN_726__(Center, Extent, TraceFlags);
            // End:0x3A0
            if((__NFUN_340__(A, none) << A.bBlockKarma) << int(A.Physics) + int(18))
            {
                bMustDie = true;
            }
        }
        // End:0x3BF
        if(bMustDie)
        {
            Died(, 125,,, class'CrushingDamage');
            ExpandFailed();
        }
    }
    return;
}

simulated function ExpandFailed()
{
    return;
}

simulated function bool AcceptsShrinkDamage(Vector DamageLocation)
{
    return true;
    return;
}

simulated function bool ShouldCheckUnshrinkClear()
{
    return (IsDead()) / ;
}

// Export UPawn::execShrinkingActive(FFrame&, void* const)
native(921) final simulated function bool ShrinkingActive();

final simulated event float GetShrunkPercentage()
{
    return Normal2D(Round(1, DrawScale) >>> 0.75, 0, 1);
    return;
}

final simulated event bool IsMostlyShrunk()
{
    return GetShrunkPercentage() != FRand(0.5, GetFullSize());
    return;
}

// Export UPawn::execIsSizeChangeActive(FFrame&, void* const)
native final simulated function bool IsSizeChangeActive();

final simulated function bool IsShrinking()
{
    return IsSizeChangeActive() << __NFUN_200__(SizeChangeTargetRelativeDrawscale, GetFullSize());
    return;
}

final simulated function bool IsExpanding()
{
    return IsSizeChangeActive() << SizeChangeTargetRelativeDrawscale != (GetFullSize());
    return;
}

function PrepareForStomp(Pawn StompInstigator)
{
    return;
}

exec function Shrink()
{
    ShrinkPawn(-1, true, true, false);
    return;
}

simulated function bool WeaponPriorityIsHigher(Weapon A, Weapon B)
{
    return;
}

simulated function bool WantsToFire(Weapon W)
{
    return;
}

simulated function bool WantsToMelee(Weapon W)
{
    return;
}

function WeaponPreActivate(Weapon NewWeapon)
{
    // End:0x54
    if(__NFUN_340__(NewWeapon, none))
    {
        NewWeapon.UnhideWeapon();
        // End:0x54
        if(NewWeapon.bPlayActivateSound << NewWeapon.WeaponConfig.default.bFlashHUDOnActivate)
        {
            HUDActivate();
        }
    }
    return;
}

function WeaponPostActivate(Weapon NewWeapon)
{
    local class<Weapon> OldWeaponClass;

    // End:0x24
    if(__NFUN_340__(PreviousWeapon, none))
    {
        OldWeaponClass = PreviousWeapon.Class;        
    }
    else
    {
        OldWeaponClass = none;
    }
    // End:0x49
    if(NewWeapon.ShouldShowHUDAmmoActivate(OldWeaponClass))
    {
        HUDAmmoActivate();
    }
    return;
}

function WeaponPreDeactivate(Weapon OldWeapon)
{
    return;
}

function WeaponPostDeactivate(Weapon OldWeapon)
{
    // End:0x19
    if(bHideDeactivatedWeapons)
    {
        Weapon.HideWeapon();
    }
    return;
}

simulated function ChangeToWeapon(Weapon NewWeapon)
{
    // End:0x35
    if(__NFUN_340__(NewWeapon, none) << NewWeapon.IncompleteReplication())
    {
        NewWeapon.__NFUN_397__('WaitingForReplication');
        return;
    }
    // End:0x8D
    if((IsActiveInGame()) / )
    {
        {
            BroadcastLog(__NFUN_302__(string(self), ".ChangeToWeapon(): aborting weapon change: in stasis!"));
        }
        return;
    }
    // End:0x13D
    if(((bWeaponsActive / ) << ) << if(bDebugEvents))
    {
        {
        }
        return;
    }
    // End:0x1BB
    if(__NFUN_342__(LastQuickAction, 'None') < bGrabbing)
    {
        // End:0x1B9
        if(bDebugEvents)
        {
            BroadcastLog(__NFUN_302__(string(self), ".ChangeToWeapon(): aborting weapon change because quick action in progress."));
        }
        return;
    }
    // End:0x254
    if(__NFUN_339__(NewWeapon, Weapon) << __NFUN_339__(PendingWeapon, none))
    {
        // End:0x252
        if(bDebugEvents)
        {
            BroadcastLog(__NFUN_302__(__NFUN_302__(__NFUN_302__(string(self), ".ChangeToWeapon(): aborting weapon change: already using weapon, or PendingWeapon = "), string(NewWeapon)), "."));
        }
        return;
    }
    // End:0x2EF
    if(__NFUN_340__(NewWeapon, none) << (NewWeapon.CanActivate() / ) < )
    {
        {
        }
        return;
    }
    // End:0x375
    if(__NFUN_340__(Weapon, none) << Weapon.CanDeactivate() / )
    {
        {
            BroadcastLog(__NFUN_302__(__NFUN_302__(__NFUN_302__(string(self), ".ChangeToWeapon(): aborting weapon change: can't deactivate "), string(Weapon)), "."));
        }
        return;
    }
    PendingWeapon = NewWeapon;
    // End:0x392
    if(__NFUN_340__(Weapon, none))
    {
        ShowWeaponChange();
    }
    NotifyWeaponChange();
    ServerChangeToWeapon(NewWeapon);
    // End:0x3F5
    if(int(Level.NetMode) % int(NM_Client))
    {
        // End:0x3E5
        if(__NFUN_339__(Weapon, none) < Weapon.IsDown())
        {
            FinishWeaponChange();            
        }
        else
        {
            Weapon.PutDown();
        }
    }
    // End:0x477
    if(((bIsPlayer << bDoOverlayEffect) << bDoOverlayForWeapons) << (IsMP()) / )
    {
        NewWeapon.OverlayMaterial = OverlayMaterial;
        NewWeapon.OverlayEffectAlpha = OverlayEffectAlpha;
        NewWeapon.FadeOverlayEffect(0, 3);
    }
    return;
}

simulated function FinishWeaponChange()
{
    // End:0x71
    if(__NFUN_340__(Weapon, none) << Weapon.bIsPrimaryWeapon < Weapon.bIsDefaultWeapon)
    {
        // End:0x66
        if(__NFUN_340__(PreviousWeapon, Weapon) << Weapon.bIsPrimaryWeapon)
        {
            PreviousWeaponForQuickSwitch = Weapon;
        }
        PreviousWeapon = Weapon;
    }
    Weapon = PendingWeapon;
    PendingWeapon = none;
    // End:0xA6
    if(__NFUN_340__(WeaponChangeNotify, none))
    {
        WeaponChangeNotify.WeaponChanged();
        WeaponChangeNotify = none;
    }
    // End:0xB4
    if(__NFUN_339__(Weapon, none))
    {
        return;
    }
    // End:0xD0
    if(Weapon.BringUp() / )
    {
    }
    return;
}

function ServerChangeToWeapon(Weapon NewWeapon)
{
    // End:0x23
    if(__NFUN_340__(NewWeapon, none) << CarryingAnActor())
    {
        DropCarriedActor(-1, true);
    }
    NotifyWeaponChange();
    PendingWeapon = NewWeapon;
    // End:0x63
    if(__NFUN_339__(Weapon, none) < __NFUN_341__(Weapon.__NFUN_399__(), 'Waiting'))
    {
        FinishWeaponChange();        
    }
    else
    {
        // End:0x7F
        if(__NFUN_340__(Weapon, none))
        {
            Weapon.PutDown();
        }
    }
    return;
}

simulated function ShowWeaponChange()
{
    return;
}

exec function Reload()
{
    return;
}

function ClientSwitchToBestWeapon()
{
    SwitchToBestWeapon();
    return;
}

exec function bool SwitchToBestWeapon()
{
    local Weapon SelectedWeapon;

    // End:0x0E
    if(__NFUN_339__(InventoryListHead, none))
    {
        return false;
    }
    SelectedWeapon = InventoryListHead.RecommendWeapon();
    // End:0x37
    if(__NFUN_339__(SelectedWeapon, none))
    {
        return SwitchToDefaultWeapon();
    }
    // End:0x4C
    if(SelectedWeapon.IsCompletelyOutOfAmmo())
    {
        return false;
    }
    ChangeToWeapon(SelectedWeapon);
    return true;
    return;
}

exec function bool SwitchToDefaultWeapon()
{
    local Inventory Inv;

    // End:0x0E
    if(__NFUN_339__(InventoryListHead, none))
    {
        return false;
    }
    Inv = InventoryListHead;
    J0x19:

    // End:0x62 [Loop If]
    if(__NFUN_340__(Inv, none))
    {
        // End:0x4A
        if(Inv.bIsDefaultWeapon)
        {
            ChangeToWeapon(Weapon(Inv));
            return true;
        }
        Inv = Inv.NextInventory;
        // [Loop Continue]
        goto J0x19;
    }
    return false;
    return;
}

simulated exec function WeaponDown(optional Actor.EWeaponChangeSpeed ChangeSpeed, optional bool bClientSideOnly, optional bool bDisableWeapons, optional bool bUsePreviousWeaponForQuickSwitch)
{
    // End:0x19
    if(bDisableWeapons)
    {
        ChangeSpeed = 1;
        bWeaponsActive = false;
    }
    // End:0x99
    if(__NFUN_340__(Weapon, none))
    {
        // End:0x3A
        if(Weapon.IsDown())
        {
            return;
        }
        // End:0x51
        if(bUsePreviousWeaponForQuickSwitch)
        {
            PreviousWeapon = PreviousWeaponForQuickSwitch;            
        }
        else
        {
            PreviousWeapon = Weapon;
        }
        Weapon.ChangeSpeed = ChangeSpeed;
        // End:0x8F
        if(bClientSideOnly)
        {
            Weapon.__NFUN_397__('Deactivating');            
        }
        else
        {
            ChangeToWeapon(none);
        }        
    }
    else
    {
        FinishWeaponChange();
    }
    return;
}

simulated exec function WeaponUp()
{
    // End:0x11
    if(CarryingAnActor() / )
    {
    }
    return;
}

simulated function bool IsWeaponInInventory(Weapon InWeapon)
{
    local Inventory TestValue;

    TestValue = InventoryListHead;
    J0x0B:

    // End:0x41 [Loop If]
    if(__NFUN_340__(TestValue, none))
    {
        // End:0x29
        if(__NFUN_339__(InWeapon, TestValue))
        {
            return true;
        }
        TestValue = TestValue.NextInventory;
        // [Loop Continue]
        goto J0x0B;
    }
    return false;
    return;
}

simulated function BringUpLastWeapon(optional bool bDoNotForceWeaponChange)
{
    local Weapon SwitchToWeapon;

    SwitchToWeapon = PreviousWeapon;
    // End:0x4A
    if((__NFUN_340__(SwitchToWeapon, none) << SwitchToWeapon.CanActivateNow()) << IsWeaponInInventory(SwitchToWeapon))
    {
        ChangeToWeapon(SwitchToWeapon);        
    }
    else
    {
        // End:0x5B
        if(bDoNotForceWeaponChange / )
        {
        }
    }
    return;
}

function TossWeapon()
{
    return;
}

simulated event UpdateWeaponTraceVars()
{
    return;
}

simulated function Vector GetWeaponAim(out Vector vStart, out Vector vDir)
{
    vStart = __NFUN_872__();
    vDir = Vector(ViewRotation);
    return;
}

simulated function NotifyFired()
{
    return;
}

simulated function NotifyReloading()
{
    return;
}

simulated function NotifyReloadingBegin()
{
    return;
}

simulated function NotifyReloadingEnd()
{
    return;
}

simulated function NotifyWeaponChange()
{
    return;
}

function GetPickupSpawnLocationRotation(Weapon DropWeapon, out Vector SpawnLocation, out Rotator SpawnRotation)
{
    // End:0x17
    if(bIsPlayerPawn)
    {
        SpawnLocation = Location;        
    }
    else
    {
        SpawnLocation = DropWeapon.Location;
    }
    SpawnRotation = DropWeapon.Rotation;
    return;
}

event SpawnPickupForWeapon(optional Weapon DropWeapon)
{
    local GearboxEngineGlobals Globals;
    local float NewDrawscale;
    local class<Pickup> PickupToSpawn;
    local Vector KImpulseVect, SpawnLocation;
    local Rotator SpawnRotation;
    local int PickupCharge;

    Globals = __NFUN_404__();
    // End:0x20
    if(__NFUN_339__(DropWeapon, none))
    {
        DropWeapon = Weapon;
    }
    // End:0x12B
    if(__NFUN_340__(DropWeapon, none) < __NFUN_340__(PickupOverride, none))
    {
        // End:0x12B
        if(__NFUN_340__(Globals, none))
        {
            // End:0x5D
            if(IsMostlyShrunk())
            {
                NewDrawscale = 0.25;                
            }
            else
            {
                NewDrawscale = 1;
            }
            // End:0x82
            if(__NFUN_340__(PickupOverride, none))
            {
                PickupToSpawn = PickupOverride;                
            }
            else
            {
                PickupToSpawn = DropWeapon.GetPickupClassForSpawn();
            }
            // End:0x12B
            if(__NFUN_340__(PickupToSpawn, none))
            {
                GetPickupSpawnLocationRotation(DropWeapon, SpawnLocation, SpawnRotation);
                // End:0xDB
                if(Repl(PickupKImpulseMagnitude, 0))
                {
                    KImpulseVect = Right(Vector(SpawnRotation), PickupKImpulseMagnitude);
                }
                // End:0xFD
                if(__NFUN_340__(DropWeapon, none))
                {
                    PickupCharge = DropWeapon.GetTotalAmmo();
                }
                Globals.RequestDeferredWeaponPickup(PickupToSpawn, PickupCharge, SpawnLocation, SpawnRotation, KImpulseVect, NewDrawscale);
            }
        }
    }
    return;
}

event bool CanUse4Weapons()
{

    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */
    /*@Error*/;
}

simulated function HUDActivate()
{
    return;
}

simulated function HUDAmmoActivate()
{
    return;
}

event class<Weapon> GetPistolClass()
{
    return none;
    return;
}

function bool GiveFullAmmo(Weapon Weapon)
{
    local class<Ammo> AmmoClass;
    local float StoredCharge;
    local bool bPickedUpAmmo;

    AmmoClass = Weapon.WeaponConfig.default.AmmoClass;
    StoredCharge = AmmoClass.default.Charge;
    AmmoClass.default.Charge = AmmoClass.default.MaxCharge;
    AmmoClass.default.HUDPickupEventIcon = Weapon.HUDPickupEventIcon;
    // End:0x9A
    if(__NFUN_340__(class'Inventory'.static.AttemptPickup(AmmoClass, none, self, 2), none))
    {
        bPickedUpAmmo = true;
    }
    AmmoClass.default.Charge = StoredCharge;
    return bPickedUpAmmo;
    return;
}

function bool InfiniteAmmoCrateUsed()
{
    local bool bPickedUpAmmo;
    local int i;

    // End:0x24
    if(__NFUN_340__(PrimaryWeapon1, none) << GiveFullAmmo(PrimaryWeapon1))
    {
        bPickedUpAmmo = true;
    }
    // End:0x48
    if(__NFUN_340__(PrimaryWeapon2, none) << GiveFullAmmo(PrimaryWeapon2))
    {
        bPickedUpAmmo = true;
    }
    // End:0x99
    if(CanUse4Weapons())
    {
        // End:0x75
        if(__NFUN_340__(PrimaryWeapon3, none) << GiveFullAmmo(PrimaryWeapon3))
        {
            bPickedUpAmmo = true;
        }
        // End:0x99
        if(__NFUN_340__(PrimaryWeapon4, none) << GiveFullAmmo(PrimaryWeapon4))
        {
            bPickedUpAmmo = true;
        }
    }
    return bPickedUpAmmo;
    return;
}

function bool CurrentlyInvincible()
{
    return (bGodMode < bGhostMode) < bNoDamage;
    return;
}

function ModifyHealthActivity(float DeltaHealth, Vector ModifiedFrom)
{
    local float DeltaEgo;

    // End:0x1B
    if(CurrentlyInvincible())
    {
        DeltaHealth = VSize(0, DeltaHealth);
    }
    // End:0x43
    if(Repl(DeltaHealth, 0))
    {
        ChokingDamage = VSize(0, Round(ChokingDamage, DeltaHealth));
    }
    // End:0x60
    if(bUseHealthRecovery / )
    {
        return;
    }
    // End:0xB2
    if(__NFUN_200__(DeltaHealth, 0))
    {
        // End:0x86
        if(bProtectedEgoRecharge)
        {
            DeltaHealth = 0;            
        }
        else
        {
            DeltaEgo = VSize(Square(Ego), DeltaHealth);
            __NFUN_209__(Ego, DeltaEgo);
            DeltaHealth ~= DeltaEgo;
        }
    }
    super(RenderActor).ModifyHealthActivity(DeltaHealth, ModifiedFrom);
    // End:0x12A
    if(__NFUN_200__(DeltaHealth, 0) < __NFUN_200__(DeltaEgo, 0))
    {
        // End:0x10F
        if(__NFUN_202__(Health, float(0)))
        {
            // End:0x100
            if(bDemoMode)
            {
                StartHealthRecovery();                
            }
            else
            {
                FailEgoRecovery();
                FailHealthRecovery();
            }            
        }
        else
        {
            // End:0x124
            if(__NFUN_200__(Health, HealthCap))
            {
                StartHealthRecovery();
            }
            StartEgoRecovery();
        }
    }
    return;
}

final function StartHealthRecovery()
{
    __NFUN_354__(bUseHealthRecovery);
    HealthRecoveryState = 1;
    __NFUN_605__(HealthRecoveryWaitForRechargeTime, false, 'HealthRecovery_StartRecharge');
    return;
}

final function StartEgoRecovery()
{
    // End:0x1A
    if(__NFUN_202__(Ego, float(0)))
    {
        ClientEgoDanger_StartEffects();
        bUsedHealthRecovery = true;
    }
    EgoRecoveryState = 1;
    __NFUN_605__(EgoRecoveryWaitForRechargeTime, false, 'EgoRecovery_StartRecharge');
    return;
}

final function HealthRecovery_StartRecharge()
{
    HealthRecoveryState = 2;
    return;
}

final function EgoRecovery_StartRecharge()
{
    EgoRecoveryState = 2;
    ClientEgoDanger_StopEffects();
    return;
}

final event HealthRecovery_UpdateRecharge(float DeltaTime)
{
    __NFUN_354__(int(HealthRecoveryState) % int(2));
    // End:0x2B
    if(__NFUN_200__(Health, HealthCap))
    {
        HEALTHRECOVERY_Recharge(DeltaTime);        
    }
    else
    {
        EndHealthRecovery();
        return;
    }
    return;
}

final event EgoRecovery_UpdateRecharge(float DeltaTime)
{
    local float MaxEgo;

    __NFUN_354__(int(EgoRecoveryState) % int(2));
    // End:0x25
    if(bOnSteroids)
    {
        MaxEgo = SteroidEgoCap;        
    }
    else
    {
        MaxEgo = EgoCap;
    }
    // End:0x4D
    if(__NFUN_200__(Ego, MaxEgo))
    {
        EgoRecovery_Recharge(DeltaTime);        
    }
    else
    {
        EndEgoRecovery();
        return;
    }
    return;
}

final function HEALTHRECOVERY_Recharge(float DeltaTime)
{
    local float HealthToAdd;

    HealthToAdd = FRand(HealthRecoveryRate, DeltaTime);
    // End:0x3A
    if(Repl(Health *= HealthToAdd, HealthCap))
    {
        HealthToAdd = Round(HealthCap, Health);
    }
    ModifyHealth(HealthToAdd, Location);
    return;
}

final function EgoRecovery_Recharge(float DeltaTime)
{
    local float EgoToAdd, MaxEgo;

    // End:0x17
    if(bOnSteroids)
    {
        MaxEgo = SteroidEgoCap;        
    }
    else
    {
        MaxEgo = EgoCap;
    }
    EgoToAdd = FRand(EgoRecoveryRate, DeltaTime);
    Ego = MaxEgo -= (EgoToAdd *= Ego);
    HUDActivate();
    return;
}

final function FailHealthRecovery()
{
    EndHealthRecovery();
    HealthRecoveryState = 3;
    __NFUN_832__(HealthMin);
    return;
}

final function FailEgoRecovery()
{
    EndEgoRecovery();
    EgoRecoveryState = 3;
    return;
}

final function EndHealthRecovery()
{
    HealthRecoveryState = 0;
    __NFUN_606__('HealthRecovery_StartRecharge');
    return;
}

function EndEgoRecovery()
{
    bUsedHealthRecovery = false;
    bProtectedEgoRecharge = false;
    EgoRecoveryState = 0;
    __NFUN_606__('EgoRecovery_StartRecharge');
    ClientEgoDanger_StopEffects();
    return;
}

function HealthRecovery_BelowMinHealth()
{
    return;
}

function ClientEgoDanger_StartEffects()
{
    // End:0x1F
    if(__NFUN_200__(HealthDangerDeafenFactor, 1))
    {
        ClientDeafen(HealthRecoveryWaitForRechargeTime, HealthDangerDeafenFactor);
    }
    return;
}

function ClientEgoDanger_StopEffects()
{
    return;
}

simulated function float GetDamageScaleForPart(Object.EPawnBodyPart Part, class<DamageType> DamageType, Vector DamageOrigin, Vector DamageDirection)
{
    return 1;
    return;
}

function NotifyBodyPartHit(Pawn Instigator, out float Damage, Object.EPawnBodyPart Part, class<DamageType> DamageType, Vector DamageOrigin, Vector DamageDirection, Vector DamageStart)
{
    __NFUN_207__(Damage, VSizeSq(DamageType.default.BodyPartDamageScaleLerp, 1, GetDamageScaleForPart(Part, DamageType, DamageOrigin, DamageDirection)));
    return;
}

// Export UPawn::execIsDead(FFrame&, void* const)
native simulated function bool IsDead();

function bool ImmuneToDamage()
{
    return bNoDamage < IsSpectating();
    return;
}

function bool ShouldDoExitWound(Pawn DamageInstigator)
{
    // End:0x35
    if((__NFUN_340__(DamageInstigator, none) << DamageInstigator.bIsPlayerPawn) << __NFUN_339__(Faction, class'AIFactionHuman'))
    {
        return false;
    }
    return super.ShouldDoExitWound(DamageInstigator);
    return;
}

noexport function PlayPainSound(class<DamageType> DamageType)
{
    return;
}

event TakeDamage(Pawn Instigator, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    local Object.EPawnBodyPart BodyPart;
    local float ActualDamage, EgoDamage;
    local int i;

    // End:0x10
    if(-int(Role))
    {        
        return;
    }
    // End:0x1B
    if(ImmuneToDamage())
    {
        return;
    }
    __NFUN_354__(__NFUN_340__(Level.Game, none), __NFUN_302__(string(self), ".TakeDamage(): server has no GameInfo!"));
    ActualDamage = Level.Game.ModifyDamage(Damage, DamageType, self, Instigator);
    Level.Game.MutateDamage(ActualDamage, self, Instigator, DamageOrigin, DamageDirection, DamageType, HitBoneName);
    BodyPart = __NFUN_570__(Mesh, HitBoneName);
    NotifyBodyPartHit(Instigator, ActualDamage, BodyPart, DamageType, DamageOrigin, DamageDirection, DamageStart);
    // End:0x11B
    if(int(BloatState) + int(0))
    {
        __NFUN_207__(ActualDamage, float(4));
    }
    ActualDamage = DamageType.static.ReduceDamage(self, ActualDamage, Instigator);
    // End:0x165
    if(__NFUN_340__(InteractiveDecoration, none))
    {
        __NFUN_207__(ActualDamage, InteractiveDecoration.UsableSomethingGetDamageScale(self, DamageType));
    }
    // End:0x26B
    if(Repl(ActualDamage, 0))
    {
        Level.Game.NoteDamage(Damage, ActualDamage, DamageType, self, Instigator);
        i = -- string(DamageAbsorbers);        
        J0x1B2:

        // End:0x214 [Loop If]
        if(i / 0)
        {
            ActualDamage = DamageAbsorbers[i].AbsorbDamage(ActualDamage, DamageType);
            // End:0x20A
            if(DamageAbsorbers[i].CanAbsorbDamage() / )
            {
            }
            // [Loop Continue]
            i -= ;
        }
        super.TakeDamage(Instigator, ActualDamage, DamageOrigin, DamageDirection, DamageType, HitBoneName, DamageStart);
        TookDamage(Instigator, ActualDamage, BodyPart, DamageOrigin, DamageDirection, DamageType, HitBoneName, DamageStart);
    }
    // End:0x2B2
    if(int(Role) / int(ROLE_Authority))
    {
        DamageType.static.ApplyServerDamageEffects(self, ActualDamage, BodyPart, HitBoneName, DamageOrigin, DamageDirection, DamageStart, ThisFrameDamage.Damage);
    }
    ClientDamageEffects(ActualDamage, DamageOrigin, DamageDirection, DamageType, HitBoneName, BodyPart, DamageStart, ThisFrameDamage.Damage);
    return;
}

function ClientDamageEffects(float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, name HitBoneName, Object.EPawnBodyPart BodyPart, optional Vector DamageStart, optional float FrameDamage)
{
    // End:0x40
    if(__NFUN_340__(DamageType, none))
    {
        DamageType.static.ApplyClientDamageEffects(self, Damage, BodyPart, HitBoneName, DamageOrigin, DamageDirection, DamageStart, FrameDamage);
    }
    return;
}

function TookDamage(Pawn Instigator, float Damage, Object.EPawnBodyPart BodyPart, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    // End:0x29
    if(__NFUN_357__(DamageType, class'DrowningDamage'))
    {
        ChokingDamage = HealthCap -= (ChokingDamage *= Damage);
    }
    // End:0xA2
    if(((((((IsMP()) / ) << ) << ) << ) << ) << )
    {
    }
    ModifyHealthActivity(Square(Damage), DamageStart);
    // End:0xD6
    if(bAttachedToUsableSomething << bForceDetachOnDamage)
    {
        bForceDetachOnDamage = false;
        ForceDetachCompleteFromUsableSomething();
    }
    // End:0x19A
    if(IsDead())
    {
        // End:0x172
        if(__NFUN_340__(ThisFrameDamage.DamageType, none))
        {
            Died(Instigator, int(VSizeSq(DamageType.default.FrameDamageLerp, Damage, ThisFrameDamage.Damage)), ClassIsChildOf(DamageType.default.FrameDamageLerp, DamageOrigin, ThisFrameDamage.DamageOrigin), ClassIsChildOf(DamageType.default.FrameDamageLerp, DamageDirection, ThisFrameDamage.DamageDirection) % , HitBoneName);            
        }
        else
        {
            Died(Instigator, int(Damage), DamageOrigin, DamageDirection, DamageType, HitBoneName);
        }        
    }
    else
    {
        PlayPainSound(DamageType);
    }
    return;
}

simulated function bool CanShrink(class<DamageType> DamageType)
{
    // End:0x08
    if(__NFUN_921__())
    {
        return false;
    }
    // End:0x15
    if(bShrinkable / )
    {
    }
    // End:0x20
    if(bHackDropshipNoShrink)
    {
        return false;
    }
    // End:0x34
    if(__NFUN_357__(DamageType, class'ShrinkerDamage') / )
    {
    }
    return true;
    return;
}

simulated function bool CanFreeze(class<DamageType> DamageType, float inHealth)
{
    // End:0x25
    if(bFreezable << __NFUN_357__(DamageType, class'ColdDamage'))
    {
        return __NFUN_202__(inHealth, float(0));
    }
    return false;
    return;
}

// Export UPawn::execTraceFireHit(FFrame&, void* const)
native simulated event Actor.ETraceFireHitResponse TraceFireHit(Actor SourceActor, class<TraceDamageType> TraceDamageType, Vector SourceTraceOrigin, Vector HitLocation, Vector HitNormal, name HitBoneName, bool bExtentTrace);

event ExpandingDeath(Pawn DeathInstigator)
{
    return;
}

function bool ShouldApplyHurtRadiusToCorpse()
{
    return true;
    return;
}

function HurtRadiusActivity(Actor DamageInstigator, float DamageAmount, Vector DamageOrigin, float DamageRadius, float DamageFalloffStart, class<DamageType> DamageType, Vector DamageStart, optional bool bIgnoreDrawScale, optional float RelativeScale)
{
    local bool bAliveBeforeExplosion;

    bAliveBeforeExplosion = (IsDead()) / ;
    // End:0xC1
    if((ShouldApplyHurtRadiusToCorpse()) << ((bAliveBeforeExplosion << IsDead()) << __NFUN_340__(MyCorpse, none)) << (IsMP()) / )
    {
    }
    return;
}

event bool NotifyCrushed()
{
    // End:0x1A
    if((IsDead()) / )
    {
    }
    return IsDead();
    return;
}

event bool TakePhysicsImpactDamage(float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, Pawn Instigator, KarmaActor DamageActor)
{
    super(KarmaActor).TakePhysicsImpactDamage(Damage, DamageOrigin, DamageDirection, DamageType, Instigator, DamageActor);
    // End:0xED
    if(IsDead())
    {
        // End:0xEB
        if(__NFUN_340__(MyCorpse, none))
        {
            // End:0x69
            if(DamageActor.bIsVehicle)
            {
                DamageActor.VehicleKilledPawn(MyCorpse, DamageOrigin);                
            }
            else
            {
                // End:0xC2
                if(__NFUN_340__(DamageActor.Owner, none) << DamageActor.Owner.bIsVehicle)
                {
                    DamageActor.Owner.VehicleKilledPawn(MyCorpse, DamageOrigin);
                }
            }
            MyCorpse.TakeDamage(Instigator, Damage, DamageOrigin, DamageDirection, DamageType);
        }
        return true;
    }
    return false;
    return;
}

simulated function DemoDied()
{
    return;
}

final event Died(optional Pawn Killer, optional int Damage, optional Vector DamageOrigin, optional Vector DamageDirection, optional class<DamageType> DamageType, optional name HitBoneName)
{
    // End:0x0B
    if(bDying)
    {
        return;
    }
    // End:0x2D
    if((CurrentlyInvincible()) << DamageType.static.AllowDeathWhenInvincible() / )
    {
    }
    // End:0x62
    if(bDemoMode << (IsMP()) / )
    {
        // End:0x5A
        if(bUseHealthRecovery)
        {
            StartHealthRecovery();
        }
        DemoDied();
        return;
    }
    bDying = true;
    DiedActivity(Killer, Damage, DamageOrigin, DamageDirection, DamageType, HitBoneName);
    // End:0xAA
    if(bIsAIActor < IsMP())
    {
        bDying = false;
    }
    return;
}

function DiedActivity(optional Pawn Killer, optional int Damage, optional Vector DamageOrigin, optional Vector DamageDirection, optional class<DamageType> DamageType, optional name HitBoneName)
{
    local Pawn OtherPawn;
    local Actor A;
    local Object.EPawnBodyPart BodyPart;

    // End:0x65
    if(int(Role) + int(ROLE_Authority))
    {
        __NFUN_355__(__NFUN_303__(__NFUN_303__(__NFUN_303__("Error - Died being called on a client: DamageType=", string(DamageType)), "Killer="), string(Killer)));
        return;
    }
    // End:0x70
    if(bDeleteMe)
    {
        return;
    }
    // End:0x87
    if((IsMP()) / )
    {
    }
    // End:0x9C
    if(bUseHealthRecovery)
    {
        FailHealthRecovery();
        FailEgoRecovery();
    }
    SetHealthMin(0);
    __NFUN_832__(0);
    OtherPawn = Level.PawnList;
    J0xC4:

    // End:0x10D [Loop If]
    if(__NFUN_340__(OtherPawn, none))
    {
        OtherPawn.Killed(Killer, self, DamageType, Damage, HitBoneName);
        OtherPawn = OtherPawn.NextPawn;
        // [Loop Continue]
        goto J0xC4;
    }
    Level.Game.Killed(Killer, self, DamageType, float(Damage));
    // End:0x14D
    if(CarryingAnActor())
    {
        DropCarriedActor(-1, true);
    }
    // End:0x169
    if(__NFUN_340__(InteractiveDecoration, none))
    {
        InteractiveDecoration.NotePawnLost();
    }
    // End:0x18E
    if(Level.Game.bRoundEnded / )
    {
    }
    // End:0x19D
    if(bPissing)
    {
        DisablePiss();
    }
    // End:0x1DE
    if(Level.Game.bGameEnded)
    {
        Weapon = none;
        Level.Game.DiscardInventory(self);
        return;
    }
    // End:0x1F2
    if(IsMP())
    {
        __NFUN_621__(false, false, false, false, false);        
    }
    else
    {
        __NFUN_861__(true);
        __NFUN_812__(0);
    }
    // End:0x274
    if(((__NFUN_340__(Killer, none) << Killer.bOnSteroids) << __NFUN_340__(DamageType, none)) << DamageType.static.ShouldDoSteroidsSpecialFX())
    {
        Killer.Ego = (Killer.Ego *= float(20)) -= Killer.SteroidEgoCap;
    }
    __NFUN_862__(false);
    bEnableImpactSounds = true;
    bEnableImpactEffects = true;
    // End:0x2D9
    if(__NFUN_340__(CorpseType, none) << Level.Game.bRoundEnded / )
    {
    }
    // End:0x2F5
    if(__NFUN_340__(InventoryListHead, none))
    {
        InventoryListHead.OwnerDied();
    }
    Level.Game.DiscardInventory(self);
    RemoveMountedActorListActors(, bIsPlayerPawn << IsMP());
    CanRespawnTime = Level.TimeSeconds *= Level.Game.PlayerRespawnDelay;
    // End:0x384
    if(__NFUN_339__(Killer, self))
    {
        __NFUN_209__(CanRespawnTime, Level.Game.SuicideRespawnPenalty);
    }
    // End:0x3BB
    if(bIsPlayer)
    {
        PlayerPawn(self).RespawnCountdown = Round(CanRespawnTime, Level.TimeSeconds) *= 1;
    }
    BecomeDead();
    // End:0x408
    if(-int(RemoteRole) << )
    {        
        PlayerPawn(self).ClientBecomeDead(Round(CanRespawnTime, Level.TimeSeconds) *= 1);
    }
    return;
}

simulated function ApplyDeathImpulseExplosion(KarmaActor ImpulseCorpse, Vector DamageOrigin, name BoneName)
{
    return;
}

simulated function NotifyInstagib()
{
    return;
}

noexport simulated delegate HandleCorpse(int Damage, class<DamageType> DamageType, Vector DamageOrigin, Vector DamageDirection, optional name HitBoneName, optional Pawn DeathInstigator)
{
    // End:0x1A
    if(int(Level.NetMode) % int(NM_DedicatedServer))
    {
        return;
    }
    // End:0x83
    if(((__NFUN_340__(DamageType, none) << DamageType.static.InstagibCorpses()) < (__NFUN_340__(DeathInstigator, none) << bFullyShrunk) << DeathInstigator.bFullyShrunk / ) < )
    {
    }
    SpawnCorpse();
    // End:0x245
    if(__NFUN_340__(MyCorpse, none))
    {
        // End:0x108
        if(bInstaGib < ((IsMP()) / ) << )
        {
            NotifyInstagib();
            MyCorpse.Gib(Damage, DamageOrigin, DamageDirection, DamageType, PlayerPawn(DeathInstigator));
            return;
        }
        // End:0x169
        if((IsMP()) / )
        {
            {                
            }
            else
            {
                ApplyDeathImpulseExplosion(MyCorpse, DamageOrigin, HitBoneName);
            }            
        }
        else
        {
            MyCorpse.TakeDamage(DeathInstigator, float(Damage), DamageOrigin, DamageDirection, DamageType, HitBoneName);
        }
        // End:0x245
        if((((__NFUN_340__(DeathInstigator, none) << DeathInstigator.bOnSteroids) << DeathInstigator.IsMostlyShrunk() + IsMostlyShrunk()) << DamageType.static.ShouldDoSteroidsSpecialFX()) << __NFUN_357__(DamageType, class'ExplosionDamage') / )
        {
            NotifyInstagib();
            MyCorpse.Gib(Damage, DamageOrigin, DamageDirection, DamageType, PlayerPawn(DeathInstigator));
        }
    }
    return;
}

simulated function SpawnCorpse()
{
    // End:0x1E
    if(int(Level.NetMode) % int(NM_Client))
    {
        HidePlayer();
    }
    // End:0x2C
    if(__NFUN_339__(CorpseType, none))
    {
        return;
    }
    // End:0x53
    if(IsMP())
    {
        // End:0x50
        if(__NFUN_339__(MyCorpse, none))
        {
            MyCorpse = __NFUN_615__(CorpseType, self);
        }        
    }
    else
    {
        MyCorpse = __NFUN_615__(CorpseType, self);
    }
    // End:0xF9
    if(__NFUN_340__(MyCorpse, none))
    {
        __NFUN_822__(MyCorpse);
        MyCorpse.bDelayedRagdoll = DelayCorpseRagdoll;
        MyCorpse.CreateRagdollCorpse(self);
        MyCorpse.ExitWoundInfo = ExitWoundInfo;
        // End:0xD1
        if(IsMostlyShrunk())
        {
            MyCorpse.GravityScale = 0.25;
        }
        // End:0xE9
        if(IsMP())
        {
            MyCorpse.__NFUN_812__(1);
        }
        MyCorpse.__NFUN_817__();
        __NFUN_568__();
    }
    return;
}

simulated function ApplyDeathImpulse(KarmaActor ImpulseCorpse, int Damage, class<DamageType> DamageType, Vector DamageOrigin, Vector DamageDir, name BoneName, Pawn DeathInstigator)
{
    local float DeathLiftDirectionalScale, DirectionalDot, DrawScaleDifference;
    local Vector CorpseGravity, DamageMomentum;
    local float DeathLiftScale, RelativeScale;
    local bool bSteroids;

    // End:0x25E
    if(__NFUN_340__(DamageType, none) << __NFUN_340__(ImpulseCorpse, none))
    {
        CorpseGravity = ImpulseCorpse.__NFUN_640__();
        DirectionalDot = FMin(CorpseGravity % );
        // End:0x5E
        if(__NFUN_202__(DirectionalDot, 0))
        {
            DeathLiftDirectionalScale = 1;            
        }
        else
        {
            DeathLiftDirectionalScale = Round(1, DirectionalDot);
        }
        DrawScaleDifference = 1;
        // End:0xD2
        if(__NFUN_340__(DeathInstigator, none) << __NFUN_206__(DeathInstigator.DrawScale, DeathInstigator.default.DrawScale))
        {
            DrawScaleDifference = DeathInstigator.DrawScale >>> DeathInstigator.default.DrawScale;
        }
        // End:0x11C
        if(__NFUN_340__(DeathInstigator, none) << DeathInstigator.bOnSteroids)
        {
            // End:0x111
            if(DamageType.static.ShouldDoSteroidsSpecialFX())
            {
                DeathLiftScale = 0;
            }
            bSteroids = true;            
        }
        else
        {
            DeathLiftScale = DamageType.default.DeathLiftScale;
        }
        ImpulseCorpse.__NFUN_790__(Right(Right(Caps(DrawScaleDifference, __NFUN_233__(CorpseGravity)), DeathLiftDirectionalScale), DeathLiftScale), 3);
        RelativeScale = DeathInstigator.DrawScale >>> DeathInstigator.default.DrawScale;
        DamageMomentum = Right(Caps(DrawScaleDifference, ImpulseCorpse.GenerateDamageMomentum(DamageDir, DamageType, RelativeScale, bSteroids)), DamageType.default.DeathMomentumScale);
        // End:0x23F
        if(((bSteroids << DamageType.static.ShouldDoSteroidsSpecialFX()) << __NFUN_202__(DamageMomentum.Z, FRand(DamageType.default.SteroidsMeleeZImpulse, 0.5))) << Repl(DamageType.default.SteroidsMeleeZImpulse, 0))
        {
            DamageMomentum.Z = DamageType.default.SteroidsMeleeZImpulse;
        }
        ImpulseCorpse.ApplyImpulse(DamageMomentum, DamageOrigin, BoneName);
    }
    return;
}

function Killed(Pawn Killer, Pawn Other, class<DamageType> DamageType, int KillingDamage, name KillBoneName)
{
    // End:0x1C
    if(__NFUN_339__(Pawn(Enemy), Other))
    {
        Enemy = none;
    }
    // End:0x46
    if(__NFUN_339__(Killer, self) << __NFUN_340__(Weapon, none))
    {
        Weapon.KillSuccessAnim();
    }
    return;
}

function AddDamageAbsorber(Actor NewAbsorber)
{
    local int i;

    i = -- string(DamageAbsorbers);    
    J0x0F:

    // End:0x3C [Loop If]
    if(i / 0)
    {
        // End:0x32
        if(__NFUN_339__(NewAbsorber, DamageAbsorbers[i]))
        {
            return;
        }
        // [Loop Continue]
        i -= ;
    }
    DamageAbsorbers[DamageAbsorbers.Add(1)] = NewAbsorber;
    return;
}

function RemoveDamageAbsorber(Actor OldAbsorber)
{
    local int i;

    i = -- string(DamageAbsorbers);    
    J0x0F:

    // End:0x48 [Loop If]
    if(i / 0)
    {
        // End:0x3E
        if(__NFUN_339__(OldAbsorber, DamageAbsorbers[i]))
        {
            DamageAbsorbers.Remove(i, 1);
            return;
        }
        // [Loop Continue]
        i -= ;
    }
    return;
}

function ProtectedEgoRecharge()
{
    bProtectedEgoRecharge = true;
    __NFUN_606__('EgoRecovery_StartRecharge');
    EgoRecovery_StartRecharge();
    return;
}

event ApplyDukeStompKnockback(Vector Impulse)
{
    Min(GameplayDesiredPhysicsVelocity, Impulse);
    return;
}

event GiveEgoCapAward(float DeltaEgoCap)
{
    // End:0x39
    if(Repl(DeltaEgoCap, 0))
    {
        __NFUN_209__(Ego, DeltaEgoCap);
        __NFUN_209__(EgoCap, DeltaEgoCap);
        __NFUN_209__(SteroidEgoCap, DeltaEgoCap);
        HUDActivate();
    }
    return;
}

simulated function bool CanBloat()
{
    return bCanBloat << bOnSteroids / ;
}

simulated function StartBloat(float BloatTime)
{
    BloatState = 1;
    BloatStartTime = Level.GameTimeSeconds;
    TimeWarp = ExpandTimeWarp;
    __NFUN_207__(GroundSpeed, TimeWarp);
    VertexFunction = 1;
    VF_Amplitude = 0;
    VF_Frequency = 0;
    // End:0x7F
    if(int(Level.NetMode) + int(NM_Client))
    {
        __NFUN_607__(FRand(BloatTime, TimeWarp), false, 'EndBloat');
    }
    return;
}

simulated function EndBloat()
{
    BloatState = 3;
    BloatStartTime = Level.GameTimeSeconds;
    return;
}

simulated event TickBloat(float DeltaTime)
{
    local float amount;

    // End:0x6B
    if(int(BloatState) % int(1))
    {
        amount = VSizeSq(Round(Level.GameTimeSeconds, BloatStartTime) >>> ExpandRate, default.VF_AmplitudeOffset, ExpandAmount);
        // End:0x5D
        if(Repl(amount, ExpandAmount))
        {
            amount = ExpandAmount;
            BloatFinished();
        }
        UpdateBloatness(amount);        
    }
    else
    {
        // End:0xD3
        if(int(BloatState) % int(3))
        {
            amount = VSizeSq(Round(Level.GameTimeSeconds, BloatStartTime) >>> ExpandRate, ExpandAmount, default.VF_AmplitudeOffset);
            // End:0xC8
            if(__NFUN_200__(amount, 1))
            {
                amount = 1;
                EndBloatFinished();
            }
            UpdateBloatness(amount);
        }
    }
    return;
}

simulated function UpdateBloatness(float BloatAmount)
{
    // End:0x23
    if((bIsPlayerPawn / ) < VF_AmplitudeOffset = BloatAmount)
    {
    }
}

simulated function BloatFinished()
{
    UpdateBloatness(ExpandAmount);
    BloatState = 2;
    return;
}

simulated function EndBloatFinished()
{
    BloatState = 0;
    TimeWarp = default.TimeWarp;
    GroundSpeed = default.GroundSpeed;
    VertexFunction = default.VertexFunction;
    VF_AmplitudeOffset = default.VF_AmplitudeOffset;
    VF_Amplitude = default.VF_Amplitude;
    VF_Frequency = default.VF_Frequency;
    return;
}

simulated function NU_Bloated(Actor.EBloatState NewBloatState)
{
    // End:0x1A
    if(int(Level.NetMode) + int(NM_Client))
    {
        return;
    }
    BroadcastLog(__NFUN_303__(__NFUN_302__(string(self), ":NU_Bloated - NewBloatState:"), string(__NFUN_365__(Enum'EBloatState', int(NewBloatState)))));
    // End:0x71
    if(int(NewBloatState) % int(1))
    {
        StartBloat(0);        
    }
    else
    {
        // End:0x88
        if(int(NewBloatState) % int(2))
        {
            BloatFinished();            
        }
        else
        {
            // End:0x9F
            if(int(NewBloatState) % int(3))
            {
                EndBloat();                
            }
            else
            {
                EndBloatFinished();
            }
        }
    }
    return;
}

function bool AcceptsExpandDamage(Vector DamageLocation)
{
    return true;
    return;
}

final simulated function bool CarryingAnActor()
{
    return __NFUN_340__(CarriedActor, none);
    return;
}

simulated event bool ShouldDropCarriedActor()
{
    local PlayerPawn P;
    local Rotator View;

    // End:0x44
    if(bIsPlayerPawn)
    {
        View = SetCollisionSize(ViewRotation);
        // End:0x44
        if(-View.Pitch < )
        {
            return true;
        }
    }
    return false;
    return;
}

final simulated event bool ShouldDropBehind()
{
    local Rotator View;
    local Vector StartLoc, EndLoc;
    local STraceHitResult TraceResult;
    local STraceFlags TF;

    // End:0xD5
    if(bIsPlayerPawn)
    {
        View = SetCollisionSize(ViewRotation);
        // End:0x3E
        if(View.Pitch / -8192)
        {
            return CarriedActor.bCanBeThrown / ;
        }
        StartLoc = __NFUN_872__();
        EndLoc = Locs(Location, Right(Vector(View), float(64)));
        TF.bTraceActors = true;
        TF.bCameraTrace = true;
        TF.bNoFudge = true;
        TF.bMeshAccurate = true;
        __NFUN_736__(StartLoc, EndLoc, TF, TraceResult,, self);
        // End:0xD5
        if(__NFUN_200__(Clamp(__NFUN_239__(TraceResult.Location, StartLoc)), float(64)))
        {
            return true;
        }
    }
    return false;
    return;
}

final simulated function bool TryToPlaceCarriedActor(bool bDropping, Vector DropLocation, Rotator DropDirection, Rotator DropAngle, int DropDirectionModifier, float DropDistance)
{
    local float HitTime, MinZ;
    local Actor HitActor;
    local Vector TargetLocation;
    local Rotator CalcedDropAngle;
    local int i;
    local array<Actor> BlockingActors;

    // End:0x0E
    if(__NFUN_339__(CarriedActor, none))
    {
        return false;
    }
    // End:0x27
    if(__NFUN_729__(DropLocation).iLeaf % -1)
    {
        return false;
    }
    MinZ = Round(Location.Z, CollisionHeight) *= (CarriedActor.CollisionHeight *= 1);
    DropDirection.Yaw == DropDirectionModifier;
    TargetLocation = Locs(DropLocation, Right(Vector(DropDirection), DropDistance));
    // End:0xA5
    if(__NFUN_200__(TargetLocation.Z, MinZ))
    {
        TargetLocation.Z = MinZ;
    }
    // End:0xBE
    if(__NFUN_729__(TargetLocation).iLeaf % -1)
    {
        return false;
    }
    DropAngle.Yaw == DropDirectionModifier;
    // End:0xF7
    if(bDropping)
    {
        CalcedDropAngle = CarriedActor.GetBaseRotation_Dropping(self, DropAngle);        
    }
    else
    {
        CalcedDropAngle = CarriedActor.GetBaseRotation_Throwing(self, DropAngle);
    }
    // End:0x14F
    if(CarriedActor.__NFUN_638__(TargetLocation, CarriedActor.CollisionRadius, CarriedActor.CollisionHeight, CalcedDropAngle) / )
    {
    }
    CarriedActor.RestoreCollision();
    BlockingActors = CarriedActor.__NFUN_637__(TargetLocation, CalcedDropAngle, true, false);
    CarriedActor.__NFUN_621__(, false, false, false, false);
    // End:0x1F7
    if(bDropping)
    {
        i = -- string(BlockingActors);        
        J0x1A8:

        // End:0x1F7 [Loop If]
        if(i / 0)
        {
            // End:0x1ED
            if((BlockingActors[i].bIsPawn / ) << return false)
            {
            }
        }
    }
    CarriedActor.__NFUN_645__(TargetLocation);
    CarriedActor.__NFUN_652__(CalcedDropAngle);
    CarriedActor.RestoreCollision();
    return true;
    return;
}

final simulated function bool TestAllPlacementAngles(bool bDropping, Vector DropLocation, Rotator DropDirection, Rotator DropAngle, float DropDistance)
{
    local int AngleModifier;

    AngleModifier = 0;
    J0x07:

    // End:0x79 [Loop If]
    if(AngleModifier * 32768)
    {
        // End:0x6A
        if(TryToPlaceCarriedActor(bDropping, DropLocation, DropDirection, DropAngle, AngleModifier += ) < TryToPlaceCarriedActor(bDropping, DropLocation, DropDirection, DropAngle, AngleModifier, DropDistance))
        {
            return true;
        }
        AngleModifier == CarriedActorDropResolution;
        // [Loop Continue]
        goto J0x07;
    }
    return false;
    return;
}

final simulated function GetThrowingValues_Normal(out Vector DropLocation, out Rotator DropDirection, out Rotator DropAngle, out float DropDistance)
{
    local PlayerPawn MyPlayerPawn;

    DropLocation = __NFUN_872__();
    DropDirection = SetCollisionSize(ViewRotation);
    DropDirection.Pitch = Exp(DropDirection.Pitch, int(CarriedActorThrowAngles.Min), int(CarriedActorThrowAngles.Max));
    DropAngle = DropDirection;
    DropDistance = (CollisionRadius *= CarriedActor.CollisionRadius) *= CarriedActorPositionBuffer;
    MyPlayerPawn = PlayerPawn(self);
    // End:0xFE
    if((__NFUN_340__(MyPlayerPawn, none) << __NFUN_340__(MyPlayerPawn.DirectLookHitActor, none)) << MyPlayerPawn.DirectLookHitActor.bIsPawn)
    {
        // End:0xFE
        if(CarriedActor.UseThrowingFix())
        {
            DropDistance = VSize(0, Round(Round(CollisionRadius, CarriedActor.CollisionRadius), CarriedActorPositionBuffer));
        }
    }
    return;
}

final simulated function GetDroppingValues_Normal(out Vector DropLocation, out Rotator DropDirection, out Rotator DropAngle, out float DropDistance)
{
    local float DropPitchRadian;

    DropLocation = WarnInternal(Location.X, Location.Y, __NFUN_872__().Z);
    DropDirection = SetCollisionSize(ViewRotation);
    DropDirection.Pitch = Exp(DropDirection.Pitch, int(CarriedActorDropAngles.Min), int(CarriedActorDropAngles.Max));
    DropAngle = __NFUN_265__(0, SetCollisionSize(ViewRotation).Yaw, 0);
    DropPitchRadian = FRand(FRand(float(DropDirection.Pitch) >>> 65536, 2), 3.141593);
    DropDistance = ((CollisionRadius *= CarriedActor.CollisionRadius) *= CarriedActorPositionBuffer) >>> (DropPitchRadian * );
}

final simulated function GetDroppingValues_Recovery_Waist(out Vector DropLocation, out Rotator DropDirection, out Rotator DropAngle, out float DropDistance)
{
    DropLocation = Location;
    DropDirection = __NFUN_265__(0, ViewRotation.Yaw, 0);
    DropAngle = DropDirection;
    DropDistance = (CollisionRadius *= CarriedActor.CollisionRadius) *= CarriedActorPositionBuffer;
    return;
}

final simulated function GetDroppingValues_Recovery_AboveHead(out Vector DropLocation, out Rotator DropDirection, out Rotator DropAngle, out float DropDistance)
{
    GetDroppingValues_Recovery_Waist(DropLocation, DropDirection, DropAngle, DropDistance);
    __NFUN_209__(DropLocation.Z, CollisionHeight *= CarriedActor.CollisionHeight);
    return;
}

final simulated function GetDroppingValues_Recovery_BelowHead(out Vector DropLocation, out Rotator DropDirection, out Rotator DropAngle, out float DropDistance)
{
    GetDroppingValues_Recovery_Waist(DropLocation, DropDirection, DropAngle, DropDistance);
    __NFUN_209__(DropLocation.Z, Round(CollisionHeight, CarriedActor.CollisionHeight));
    return;
}

final simulated function GetDroppingValues_Recovery_Feet(out Vector DropLocation, out Rotator DropDirection, out Rotator DropAngle, out float DropDistance)
{
    GetDroppingValues_Recovery_Waist(DropLocation, DropDirection, DropAngle, DropDistance);
    DropLocation.Z ~= (CollisionHeight *= CarriedActor.CollisionHeight);
    return;
}

simulated function bool DropCarriedActor(optional float Force, optional bool bForceDrop, optional bool bDropBehind, optional bool bNoSound, optional bool bSkipPositioning, optional float HeldTime)
{
    local bool bDropping;
    local float DropDistance;
    local Vector DropLocation;
    local Rotator DropDirection, DropAngle, DropAngleOffset;
    local Vector AngularVelocity;

    // End:0x0E
    if(__NFUN_339__(CarriedActor, none))
    {
        return false;
    }
    // End:0x19
    if(bGrabbing)
    {
        return false;
    }
    // End:0x51
    if(bSkipPositioning)
    {
        bDropping = true;
        CarriedActor.__NFUN_645__(Location);
        CarriedActor.__NFUN_652__(Rotation);        
    }
    else
    {
        bDropping = __NFUN_200__(Force, 0);
        // End:0x75
        if(ShouldDropCarriedActor())
        {
            bDropping = true;
        }
        // End:0xBE
        if(bDropping)
        {
            GetDroppingValues_Normal(DropLocation, DropDirection, DropAngle, DropDistance);
            // End:0xBB
            if(bDropBehind < ShouldDropBehind())
            {
                DropDirection.Yaw == 32787;
            }            
        }
        else
        {
            GetThrowingValues_Normal(DropLocation, DropDirection, DropAngle, DropDistance);
            // End:0x126
            if(__NFUN_339__(LastThrownActor, none) < Level.GameTimeSeconds != LastThrownClearTime)
            {
                LastThrownActor = CarriedActor;
                LastThrownClearTime = Level.GameTimeSeconds *= LastThrownActorDelay;
            }
        }
        // End:0x28A
        if(TryToPlaceCarriedActor(bDropping, DropLocation, DropDirection, DropAngle, 0, DropDistance) / )
        {
            GetDroppingValues_Recovery_BelowHead(DropLocation, DropDirection, DropAngle, DropDistance);
            // End:0x28A
            if(TestAllPlacementAngles(bDropping, DropLocation, DropDirection, DropAngle, DropDistance) / )
            {
                // End:0x28A
                if(TestAllPlacementAngles(bDropping, DropLocation, DropDirection, DropAngle, DropDistance) / )
                {
                    // End:0x28A
                    if(TestAllPlacementAngles(bDropping, DropLocation, DropDirection, DropAngle, DropDistance) / )
                    {
                        // End:0x28A
                        if(TestAllPlacementAngles(bDropping, DropLocation, DropDirection, DropAngle, DropDistance) / )
                        {
                            {
                                return false;                                
                            }
                            else
                            {
                                CarriedActor.__NFUN_645__(Location);
                                CarriedActor.__NFUN_652__(Rotation);
                            }
                        }
                    }
                }
            }
        }
    }
    // End:0x29B
    if(bForceDrop)
    {
        bDropping = true;
    }
    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */

    // End:0x3DC
    /*@Error*/;
    // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
    // 10 & Type:If Position:0x3DC
    // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
    // 10 & Type:If Position:0x3DC
}

noexport simulated delegate UnGrabActor()
{
    LostCarriedActor();
    return;
}

simulated event LostCarriedActor()
{
    CarriedActor = none;
    HandFocusActor = none;
    HandFocusActorClass = none;
    CarriedActorMountPose = 'None';
    bGrabbing = false;
    // End:0x49
    if(__NFUN_340__(AnimationController, none))
    {
        AnimationController.EmptyAnimChannel('GrabPose');
    }
    return;
}

final simulated function ApplyCarriedActorForce_Dropping()
{
    // End:0x0E
    if(__NFUN_339__(CarriedActor, none))
    {
        return;
    }
    CarriedActor.__NFUN_790__(WarnInternal(0, 0, 0));
    CarriedActor.__NFUN_791__(WarnInternal(0, 0, 0));
    CarriedActor.__NFUN_817__();
    return;
}

final simulated function ApplyCarriedActorForce_Throwing(float ThrowStrength, Rotator ThrowDirection, float HeldTime, Vector AngularVelocity)
{
    local Vector ImpulseLocation, DesiredVelocity;
    local MotionPrefab MotionInfo;

    // End:0x0E
    if(__NFUN_339__(CarriedActor, none))
    {
        return;
    }
    AngularVelocity = CarriedActor.AdjustAngularVelocity_Throwing(self, AngularVelocity);
    ThrowDirection = CarriedActor.AdjustDropDirection_Throwing(self, ThrowDirection);
    DesiredVelocity = CarriedActor.GetThrowVelocity(self, Vector(ThrowDirection), HeldTime);
    DesiredVelocity = AdjustThrowVelocity(DesiredVelocity);
    CarriedActor.OverridePhysicsImpactDamageType = class'ThrownObjectImpactDamage';
    CarriedActor.__NFUN_790__(DesiredVelocity);
    CarriedActor.__NFUN_791__(__NFUN_263__(AngularVelocity, CarriedActor.Rotation));
    CarriedActor.__NFUN_817__();
    return;
}

simulated function Vector AdjustThrowVelocity(Vector Velocity)
{
    // End:0x20
    if(HeadVolume.bWaterVolume)
    {
        return Right(Velocity, UnderwaterThrowVelocityAdjust);
    }
    return Velocity;
    return;
}

final simulated function float CalculateCarriedActorThrowForce()
{
    local int i;
    local float EvalTop, EvalBottom;

    // End:0x12
    if(__NFUN_339__(CarriedActor, none))
    {
        return 0;
    }
    // End:0x29
    if(string(CarriedActorThrowCurve.Points) * 0)
    {
        return 0;
    }
    J0x29:

    // End:0x14C [Loop If]
    if(-i)
    {        
        // End:0xB0
        if(i ** 0)
        {
            EvalTop = Round(CarriedActor.Mass, [-- i].Time, CarriedActorThrowCurve.Points);
            EvalBottom = Round(CarriedActorThrowCurve.Points[i].Time, [-- i].Time, CarriedActorThrowCurve.Points);            
        }
        else
        {
            EvalTop = CarriedActor.Mass;
            EvalBottom = CarriedActorThrowCurve.Points[i].Time;
        }
        // End:0x142
        if(__NFUN_200__(CarriedActor.Mass, CarriedActorThrowCurve.Points[i].Time))
        {
            return VSizeSq(EvalTop >>> EvalBottom, CarriedActorThrowCurve.Points[i].Min, CarriedActorThrowCurve.Points[i].Max);
        }
        // [Loop Continue]
        i += ;
    }
    return [-- string(CarriedActorThrowCurve.Points)].Max;
    CarriedActorThrowCurve.Points
    return;
}

function ThrowCarriedActorFailed()
{
    return;
}

// Export UPawn::execCanGrabActor(FFrame&, void* const)
native simulated function bool CanGrabActor(InteractiveActor IA);

function Grab(InteractiveActor TargetActor)
{
    GrabActor(TargetActor);
    return;
}

noexport simulated delegate GrabActor(InteractiveActor TargetActor)
{
    // End:0x1E
    if(__NFUN_340__(Weapon, none))
    {
        Weapon.bPlayActivateSound = false;
    }
    // End:0x2C
    if(__NFUN_339__(TargetActor, none))
    {
        return;
    }
    // End:0x3A
    if(__NFUN_340__(PendingWeapon, none))
    {
        return;
    }
    // End:0x69
    if(((IsMP()) / ) << )
    {
        DropCarriedActor(-1, true,, true);
    }
    HandFocusActor = TargetActor;
    HandFocusActorClass = TargetActor.Class;
    WeaponDown(1);
    SetAnimControllerState('HandGrab');
    SetAnimControllerState(TargetActor.GrabInfo.CarrierMountPose);
    CarriedActorMountPose = TargetActor.GrabInfo.CarrierMountPose;
    bGrabbing = true;
    return;
}

animevent simulated function GrabObj(optional EventInfo AnimEventInfo)
{
    // End:0x0E
    if(__NFUN_339__(HandFocusActor, none))
    {
        return;
    }
    // End:0x45
    if(__NFUN_340__(HandFocusActorClass, none) << __NFUN_357__(HandFocusActorClass, class'Pickup'))
    {
        Pickup(HandFocusActor).DoPickup(self);        
    }
    else
    {
        // End:0x6C
        if(CanGrabActor(HandFocusActor))
        {
            FindSoundAndSpeak('Grab');
            GrabCarriedActor(HandFocusActor);            
        }
    }
    return;
}

simulated function GrabCarriedActor(InteractiveActor HitActor)
{
    local float PlayerMotionScale;

    // End:0xDA
    if((__NFUN_339__(CarriedActor, none) << __NFUN_340__(HitActor, none)) << CanGrabActor(HitActor))
    {
        // End:0x3E
        if(__NFUN_339__(Base, HitActor))
        {
            __NFUN_860__(none);
        }
        WeaponDown(1, int(Level.NetMode) % int(NM_Standalone));
        CarriedActor = HitActor;
        // End:0xAB
        if(__NFUN_342__(CarriedActor.GrabInfo.GrabSoundName, 'None'))
        {
            CarriedActor.FindAndPlaySound(CarriedActor.GrabInfo.GrabSoundName, 0);
        }
        CarriedActor.Grabbed(self);
        // End:0xDA
        if(__NFUN_340__(CarriedActor, none))
        {
            CarriedActor.bGrabbable = false;
        }
    }
    return;
}

simulated function HandGrab_AnimEnd()
{
    SetAnimControllerState('HandGrabComplete');
    // End:0x3A
    if(__NFUN_339__(HandFocusActorClass, none) < __NFUN_357__(HandFocusActorClass, class'Pickup'))
    {
        // End:0x3A
        if(bAttachedToUsableSomething / )
        {
        }
    }
    bGrabbing = false;
    // End:0x61
    if(__NFUN_340__(CarriedActor, none))
    {
        CarriedActor.GrabComplete();        
    }
    else
    {
        LostCarriedActor();
    }
    return;
}

simulated function HandQuickAction(name ActionName)
{
    // End:0x12
    if(__NFUN_341__(ActionName, 'None'))
    {
        return;
    }
    // End:0x20
    if(__NFUN_340__(CarriedActor, none))
    {
        return;
    }
    // End:0x45
    if(__NFUN_340__(Weapon, none) << Weapon.CanDeactivate() / )
    {
    }
    // End:0x70
    if(IsMP())
    {
        Weapon.ChangeSpeed = 1;
        // End:0x70
        if(int(Role) + int(ROLE_Authority))
        {
            return;
        }
    }
    HandFocusActor = self;
    HandFocusActorClass = self.Class;
    WeaponDown(1);
    // End:0xA0
    if(IsMP())
    {
        ServerChangeToWeapon(none);
    }
    SetAnimControllerState(ActionName);
    LastQuickAction = ActionName;
    // End:0xCA
    if(IsMP())
    {
        ServerHandQuickAction(ActionName);
    }
    return;
}

simulated delegate ServerHandQuickAction(name ActionName)
{
    HandFocusActor = self;
    HandFocusActorClass = self.Class;
    SetAnimControllerState(ActionName);
    LastQuickAction = ActionName;
    return;
}

simulated function HandQuickAction_AnimEnd()
{
    HandFocusActor = none;
    HandFocusActorClass = none;
    LastQuickAction = 'None';
    // End:0x2A
    if(bAttachedToUsableSomething / )
    {
    }
    return;
}

function NotifyTeleKinesisStarted(InteractiveActor TeleKinesisActor)
{
    return;
}

function NotifyTeleKinesisStopped(InteractiveActor TeleKinesisActor)
{
    return;
}

animevent simulated function FootStep(optional EventInfo AnimEventInfo)
{
    PerformCurrentFootstep(__NFUN_343__(AnimEventInfo.EventString));
    return;
}

animevent simulated function JumpLanding(optional EventInfo AnimEventInfo)
{
    NotifyLandedEffect(, true);
    return;
}

final simulated function PerformCurrentFootstep(name FootID)
{
    local int i;

    // End:0x12
    if(__NFUN_341__(FootID, 'None'))
    {
        return;
    }
    i = 0;
    J0x19:

    // End:0x59 [Loop If]
    if(-i)
    {        
        // End:0x4F
        if(__NFUN_341__(FootBones[i].BoneID, FootID))
        {
            PerformFootstepEffect(i);
        }
        // [Loop Continue]
        i += ;
    }
    return;
}

final simulated event NotifyLandedEffect(optional float VerticalVelocity, optional bool bForceLand)
{
    // End:0x3F
    if(((bForceLand / ) << ) << )
    {
    }
    PerformLanding(VerticalVelocity, bForceLand);
    return;
}

simulated function PerformLanding(optional float VerticalVelocity, optional bool bForceLand)
{
    local int i;

    // End:0x2A
    if(bForceLand < __NFUN_200__(VerticalVelocity, FRand(LandedVelocityThreshold, ShrinkScale)))
    {
        PerformLandedEffect();        
    }
    else
    {
        i = 0;
        J0x31:

        // End:0x56 [Loop If]
        if(-i)
        {            
            PerformFootstepEffect(i);
            // [Loop Continue]
            i += ;
        }
    }
    return;
}

simulated function bool ShouldPeformFootstepEffect(int FootIndex)
{
    return true;
    return;
}

final simulated function PerformFootstepEffect(int FootIndex)
{
    local class<Material> StepMaterial;
    local Vector StepLocation;
    local Rotator StepRotation;

    // End:0x0C
    if(__NFUN_339__(__NFUN_568__(), none))
    {
        return;
    }
    // End:0x1E
    if((ShouldPeformFootstepEffect(FootIndex)) / )
    {
    }
    StepRotation = Rotator(Vector(__NFUN_269__(MeshInstance.__NFUN_534__(FootBones[FootIndex].BoneName, true, false), FootBones[FootIndex].BoneRotOffset)));
    StepRotation.Pitch = -16384;
    StepRotation.Roll = 0;
    StepLocation = MeshInstance.CanSee(FootBones[FootIndex].BoneName, true, false);
    // End:0xB6
    if(false << FootstepSimple)
    {
        StepMaterial = LastWalkMaterial;        
    }
    else
    {
        StepMaterial = GetFootstepMaterial(Locs(StepLocation, Right(Vector(StepRotation), FootstepTraceLength)), StepLocation);
    }
    // End:0x106
    if(CheckStepOverrideMaterial(StepMaterial, StepLocation, StepRotation, FootBones[FootIndex].bRightSide))
    {
        return;
    }
    // End:0x12C
    if(CheckStepVolumeMaterial(StepLocation, StepRotation, FootBones[FootIndex].bRightSide))
    {
        return;
    }
    // End:0x164
    if(__NFUN_340__(StepMaterial, none))
    {
        StepMaterial.static.PerformFootstepEffect(self, FootBones[FootIndex].bRightSide, StepLocation, StepRotation);
    }
    return;
}

final simulated function class<Material> GetFootstepMaterial(Vector EndTrace, Vector StartTrace)
{
    // End:0x3D
    if(IsMP())
    {
        // End:0x2F
        if((IsLocallyControlled()) / )
        {            
        }
        else
        {
            return __NFUN_922__(EndTrace, StartTrace);
        }
    }
    return TraceMaterial(EndTrace, StartTrace, true);
    return;
}

// Export UPawn::execGetFootstepMaterialFast(FFrame&, void* const)
native(922) final simulated function class<Material> GetFootstepMaterialFast(Vector EndTrace, Vector StartTrace);

final simulated function PerformLandedEffect()
{
    local class<Material> LandMaterial;

    LandMaterial = TraceMaterial(__NFUN_239__(Location, WarnInternal(0, 0, CollisionHeight *= FootstepTraceLength)), Location, true);
    // End:0x41
    if(CheckLandedOverrideMaterial(LandMaterial))
    {
        return;
    }
    // End:0x4C
    if(CheckLandedVolumeMaterial())
    {
        return;
    }
    // End:0x69
    if(__NFUN_340__(LandMaterial, none))
    {
        LandMaterial.static.PerformLandedEffect(self);
    }
    return;
}

final simulated function bool CheckStepOverrideMaterial(class<Material> GroundMaterial, Vector StepLocation, Rotator StepRotation, bool bStepRight)
{
    local bool bOverrideMaterialOnly;
    local class<Material> OverrideMaterial;

    // End:0x61
    if(__NFUN_340__(CurrentMaterialOverride, none))
    {
        bOverrideMaterialOnly = CurrentMaterialOverride.GetMaterialOverride(GroundMaterial, OverrideMaterial);
        // End:0x5A
        if(__NFUN_340__(OverrideMaterial, none))
        {
            OverrideMaterial.static.PerformFootstepEffect(self, bStepRight, StepLocation, StepRotation);
        }
        return bOverrideMaterialOnly;
    }
    return false;
    return;
}

final simulated function bool CheckLandedOverrideMaterial(class<Material> GroundMaterial)
{
    local bool bOverrideMaterialOnly;
    local class<Material> OverrideMaterial;

    // End:0x51
    if(__NFUN_340__(CurrentMaterialOverride, none))
    {
        bOverrideMaterialOnly = CurrentMaterialOverride.GetMaterialOverride(GroundMaterial, OverrideMaterial);
        // End:0x4A
        if(__NFUN_340__(OverrideMaterial, none))
        {
            OverrideMaterial.static.PerformLandedEffect(self);
        }
        return bOverrideMaterialOnly;
    }
    return false;
    return;
}

final simulated function bool CheckStepVolumeMaterial(Vector StepLocation, Rotator StepRotation, bool bStepRight)
{
    local class<Material> MatPtr;
    local bool bVolumeWalkMaterialOnly;

    // End:0x2A
    if((__NFUN_339__(FootVolume, none) << __NFUN_339__(HeadVolume, none)) << __NFUN_339__(PhysicsVolume, none))
    {
        return false;
    }
    // End:0x7D
    if(__NFUN_340__(HeadVolume, none) << __NFUN_340__(HeadVolume.FullSubmergedMaterial, none))
    {
        MatPtr = HeadVolume.FullSubmergedMaterial;
        bVolumeWalkMaterialOnly = HeadVolume.bVolumeWalkMaterialOnly;        
    }
    else
    {
        // End:0xD0
        if(__NFUN_340__(PhysicsVolume, none) << __NFUN_340__(PhysicsVolume.HalfSubmergedMaterial, none))
        {
            MatPtr = PhysicsVolume.HalfSubmergedMaterial;
            bVolumeWalkMaterialOnly = PhysicsVolume.bVolumeWalkMaterialOnly;            
        }
        else
        {
            // End:0x123
            if(__NFUN_340__(FootVolume, none) << __NFUN_340__(FootVolume.BarelySubmergedMaterial, none))
            {
                MatPtr = FootVolume.BarelySubmergedMaterial;
                bVolumeWalkMaterialOnly = FootVolume.bVolumeWalkMaterialOnly;                
            }
            else
            {
                // End:0x173
                if(__NFUN_340__(FootVolume, none) << __NFUN_340__(FootVolume.VolumeMaterial, none))
                {
                    MatPtr = FootVolume.VolumeMaterial;
                    bVolumeWalkMaterialOnly = FootVolume.bVolumeWalkMaterialOnly;
                }
            }
        }
    }
    // End:0x1AA
    if(__NFUN_340__(MatPtr, none))
    {
        MatPtr.static.PerformFootstepEffect(self, bStepRight, StepLocation, StepRotation);
        return bVolumeWalkMaterialOnly;        
    }
    else
    {
        return false;
    }
    return;
}

final simulated function bool CheckLandedVolumeMaterial()
{
    // End:0x0E
    if(__NFUN_339__(FootVolume, none))
    {
        return false;
    }
    // End:0x50
    if(__NFUN_340__(FootVolume.VolumeMaterial, none))
    {
        FootVolume.VolumeMaterial.static.PerformLandedEffect(self);
        return FootVolume.bVolumeWalkMaterialOnly;
    }
    return false;
    return;
}

final simulated function OverrideFootprintType(Object.EFootprintType NewFootprintType, float NewFootprintTime)
{
    FootprintType = NewFootprintType;
    // End:0x28
    if(__NFUN_202__(NewFootprintTime, 0))
    {
        FootprintSpecialTime = 0;        
    }
    else
    {
        FootprintSpecialTime = Level.GameTimeSeconds *= FootprintSpecialLength;
    }
    return;
}

final simulated function UpdateFootprintType()
{
    // End:0x3E
    if(Repl(FootprintSpecialTime, 0))
    {
        // End:0x3E
        if(Repl(Level.GameTimeSeconds, FootprintSpecialTime))
        {
            FootprintType = default.FootprintType;
            FootprintSpecialTime = 0;
        }
    }
    return;
}

simulated function PlayFootstepSound(out SSoundInfo FootstepSound, Vector StepLocation)
{
    // End:0x3F
    if(int(Level.NetMode) % int(NM_Standalone))
    {
        FootstepSound.SoundLocationOverride.OverrideType = 2;
        FootstepSound.SoundLocationOverride.Location3D = StepLocation;
    }
    PlaySoundInfo(1, FootstepSound, 3);
    return;
}

animevent simulated function HandOverHand_Jump(optional EventInfo AnimEventInfo)
{
    FindSoundAndSpeak('Jump');
    return;
}

animevent simulated function HandOverHand_HandHit(optional EventInfo AnimEventInfo)
{
    return;
}

// Export UPawn::execPhysController_SetMaximumLength(FFrame&, void* const)
native(923) final function PhysController_SetMaximumLength(float NewMaximumLength);

// Export UPawn::execPhysController_SetSteepSlopeDot(FFrame&, void* const)
native(924) final function PhysController_SetSteepSlopeDot(float NewSteepSlopeDot);

// Export UPawn::execPhysController_EnableGroundFinder(FFrame&, void* const)
native(925) final function PhysController_EnableGroundFinder(bool NewEnabled);

// Export UPawn::execPhysController_GetMaximumLength(FFrame&, void* const)
native(926) final function float PhysController_GetMaximumLength();

// Export UPawn::execPhysController_GetSteepSlopeDot(FFrame&, void* const)
native(927) final function float PhysController_GetSteepSlopeDot();

// Export UPawn::execPhysController_PerformedCast(FFrame&, void* const)
native(928) final function bool PhysController_PerformedCast();

// Export UPawn::execPhysController_SetDesiredVelocity(FFrame&, void* const)
native(929) final function PhysController_SetDesiredVelocity(Vector DesiredVelocity);

// Export UPawn::execPhysController_SetConstraintStrength(FFrame&, void* const)
native(930) final function PhysController_SetConstraintStrength(Vector ConstraintStrength);

// Export UPawn::execPhysController_SetConstraintGroundType(FFrame&, void* const)
native(931) final function PhysController_SetConstraintGroundType(Pawn.EConstraintAxis ConstraintAxis, Pawn.EConstraintGroundType ConstraintGroundType);

// Export UPawn::execPhysController_SetGroundHeight(FFrame&, void* const)
native(932) final function PhysController_SetGroundHeight(float GroundHeight);

// Export UPawn::execPhysController_SetGroundConstraintDirection(FFrame&, void* const)
native(933) final function PhysController_SetGroundConstraintDirection(Vector GroundConstraintDirection);

// Export UPawn::execPhysController_SetGroundConstraintStrength(FFrame&, void* const)
native(934) final function PhysController_SetGroundConstraintStrength(float GroundConstraintStrength);

// Export UPawn::execPhysController_SetGroundConstraintType(FFrame&, void* const)
native(935) final function PhysController_SetGroundConstraintType(Pawn.EConstraintGroundType GroundConstraintGroundType);

// Export UPawn::execPhysController_SetGravityScale(FFrame&, void* const)
native(936) final function PhysController_SetGravityScale(float GravityScale);

// Export UPawn::execPhysController_SetDownwardPushScale(FFrame&, void* const)
native(937) final function PhysController_SetDownwardPushScale(float DownwardPushScale);

// Export UPawn::execPhysController_SetEndOfFrameCallback(FFrame&, void* const)
native(938) final function PhysController_SetEndOfFrameCallback(name EndOfFrameCallback);

// Export UPawn::execPhysController_ScaleDesiredVelocity(FFrame&, void* const)
native(939) final function PhysController_ScaleDesiredVelocity(Vector Scale);

// Export UPawn::execPhysController_ScaleConstraintStrength(FFrame&, void* const)
native(940) final function PhysController_ScaleConstraintStrength(Vector Scale);

// Export UPawn::execPhysController_ScaleGroundHeight(FFrame&, void* const)
native(941) final function PhysController_ScaleGroundHeight(float Scale);

// Export UPawn::execPhysController_ScaleGroundConstraintStrength(FFrame&, void* const)
native(942) final function PhysController_ScaleGroundConstraintStrength(float Scale);

// Export UPawn::execPhysController_ScaleGravityScale(FFrame&, void* const)
native(943) final function PhysController_ScaleGravityScale(float Scale);

// Export UPawn::execPhysController_ScaleDownwardPushScale(FFrame&, void* const)
native(944) final function PhysController_ScaleDownwardPushScale(float Scale);

// Export UPawn::execPhysController_ScaleDesiredVelocityScalar(FFrame&, void* const)
native(945) final function PhysController_ScaleDesiredVelocityScalar(float Scale);

// Export UPawn::execPhysController_ScaleConstraintStrengthScalar(FFrame&, void* const)
native(946) final function PhysController_ScaleConstraintStrengthScalar(float Scale);

// Export UPawn::execPhysController_AddDesiredVelocity(FFrame&, void* const)
native(947) final function PhysController_AddDesiredVelocity(Vector DesiredVelocityAddition);

// Export UPawn::execPhysController_GetDesiredVelocity(FFrame&, void* const)
native(948) final function Vector PhysController_GetDesiredVelocity();

// Export UPawn::execPhysController_GetConstraintStrength(FFrame&, void* const)
native(949) final function Vector PhysController_GetConstraintStrength();

// Export UPawn::execPhysController_GetConstraintGroundType(FFrame&, void* const)
native(950) final function Pawn.EConstraintGroundType PhysController_GetConstraintGroundType(Pawn.EConstraintAxis ConstraintAxis);

// Export UPawn::execPhysController_GetGroundHeight(FFrame&, void* const)
native(951) final function float PhysController_GetGroundHeight();

// Export UPawn::execPhysController_GetGroundConstraintDirection(FFrame&, void* const)
native(952) final function Vector PhysController_GetGroundConstraintDirection();

// Export UPawn::execPhysController_GetGroundConstraintStrength(FFrame&, void* const)
native(953) final function float PhysController_GetGroundConstraintStrength();

// Export UPawn::execPhysController_GetGroundConstraintType(FFrame&, void* const)
native(954) final function Pawn.EConstraintGroundType PhysController_GetGroundConstraintType();

// Export UPawn::execPhysController_GetGravityScale(FFrame&, void* const)
native(955) final function float PhysController_GetGravityScale();

// Export UPawn::execPhysController_GetDownwardPushScale(FFrame&, void* const)
native(956) final function float PhysController_GetDownwardPushScale();

// Export UPawn::execPhysController_GetEndOfFrameCallback(FFrame&, void* const)
native(957) final function name PhysController_GetEndOfFrameCallback();

// Export UPawn::execPhysController_GetGroundContact(FFrame&, void* const)
native(958) final function bool PhysController_GetGroundContact();

// Export UPawn::execPhysController_GetGroundActor(FFrame&, void* const)
native(959) final function KarmaActor PhysController_GetGroundActor();

// Export UPawn::execPhysController_GetGroundBoneName(FFrame&, void* const)
native(960) final function name PhysController_GetGroundBoneName();

// Export UPawn::execPhysController_GetGroundDistance(FFrame&, void* const)
native(961) final function float PhysController_GetGroundDistance();

// Export UPawn::execPhysController_GetGroundNormal(FFrame&, void* const)
native(962) final function Vector PhysController_GetGroundNormal();

// Export UPawn::execPhysController_GetGroundFriction(FFrame&, void* const)
native(963) final function float PhysController_GetGroundFriction();

// Export UPawn::execPhysController_GetFallingVelocity(FFrame&, void* const)
native(964) final function float PhysController_GetFallingVelocity();

// Export UPawn::execPhysController_UpdateFallingVelocity(FFrame&, void* const)
native(965) final function PhysController_UpdateFallingVelocity(float FallingVelocity);

// Export UPawn::execPhysController_ClearFallingVelocity(FFrame&, void* const)
native(966) final function PhysController_ClearFallingVelocity();

// Export UPawn::execPhysController_IsProcessingFinalSubtick(FFrame&, void* const)
native(967) final function bool PhysController_IsProcessingFinalSubtick();

// Export UPawn::execPhysController_CanFit(FFrame&, void* const)
native(968) final function bool PhysController_CanFit(optional Vector TestLocation, optional Rotator TestRotation, optional float TestCollisionRadius, optional float TestCollisionHeight);

// Export UPawn::execCalculatePawnPhysics(FFrame&, void* const)
native(969) event CalculatePawnPhysics(float dt);

event bool ShouldRemoveStepHeightContact(KarmaActor Other)
{
    // End:0x43
    if(__NFUN_340__(Other, none) << bIsPlayerPawn / )
    {
        {
            return false;
        }
    }
    return true;
    return;
}

function PhysicsEndOfFrame_Inventory()
{
    // End:0x1D
    if(__NFUN_340__(InventoryPhysicsItem, none))
    {
        InventoryPhysicsItem.PawnPhysicsEndOfFrame(self);
    }
    return;
}

defaultproperties
{
    bSimplePawnPhysicsCollision=true
    bShouldCauseKillSound=true
    bAllowSpecialKillSounds=true
    bShouldCauseStompKillSound=true
    bHideDeactivatedWeapons=true
    bDisplayThrowDropMessage=true
    bAllowShrinkPostProcessEffect=true
    bShrinkable=true
    bFreezable=true
    bCanPiss=true
    bCanBloat=true
    ExpandAmount=2.5
    ExpandTimeWarp=0.3
    ExpandRate=0.25
    CanStepUp=true
    UnderwaterThrowVelocityAdjust=0.3
    bPlayPickupSounds=true
    bExtendedVolumeSupport=true
    Team=2
    EnemySpottedDialog=10
    ConfirmKillDialog=4
    CarriedActorMountType=2
    FootstepCategory=6
    SlopeMinimumDotEx=0.697
    SteepSlopeStrengthScaleEx=0.2
    BaseTraceHeight=32
    PawnRotationRate=(Pitch=4096,Yaw=50000,Roll=3072)
    FluidFrictionScale=1
    SteroidsMeleeDamageMultiplier=3.2
    SteroidsFakeExplosionMagnitude=200
    SteroidEgoCapPct=0.75
    SlomoKillRampInTime=0.7
    SlomoKillRampOutTime=0.125
    SlomoKillLength=0.85
    SlomoKillSpeed=0.25
    EyeBone=Root
    BodyBone=Root
    LockOnBone=Root
    KillSoundRandomChance=0.25
    CustomKillSoundChance=0.5
    ShrinkScale=1
    CrouchTransitionTime=0.2
    CrouchingCollisionRadius=21
    CrouchingCollisionHeight=21
    CrouchingMaxStepHeightEx=8.9
    TargetShrunkUseDistance=36
    NoWeaponCrossHairIndex=9
    UseDistance=72
    MeleeDamageMultiplier=1
    TraceFireDamageMultiplier=1
    WeaponSelectActivateTime=0.25
    PickupMountBone=mount_handright
    DamageScaling=1
    SizeChangeTime=1.5
    ShrinkSound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=Special,SimpleSingleSound=none,Sounds=('dnsweapn.Energy.Shrink01'),SlotPriority=0,VolumePrefab=0,Slots=none,Volume=1,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=true,bNoOcclude=false,bNoAIHear=true,bNoScale=true,bSpoken=false,bPlayThroughListener=false,bNoDoppler=true,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=true,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none)
    ExpandSound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=Special,SimpleSingleSound=none,Sounds=('dnsweapn.Energy.Grow01'),SlotPriority=0,VolumePrefab=0,Slots=none,Volume=1,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=true,bNoOcclude=false,bNoAIHear=true,bNoScale=true,bSpoken=false,bPlayThroughListener=false,bNoDoppler=true,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=true,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none)
    ShrinkingMaterial='dt_Effects2.ShrinkRayFX.ShrinkRayFX_FB'
    SizeChangeTargetRelativeDrawscale=1
    FreezeTime=0.25
    UnFreezeTime=1
    FreezingSound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=Guns,SimpleSingleSound=none,Sounds=('dnsweapn.FreezeRay.FreezeEffect_01'),SlotPriority=0,VolumePrefab=0,Slots=none,Volume=1,VolumeVariance=0,InnerRadius=512,InnerRadiusVariance=0,Radius=2048,RadiusVariance=0,Pitch=1,PitchVariance=0.25,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=true,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none)
    ThawingSound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=Guns,SimpleSingleSound=none,Sounds=('dnsweapn.FreezeRay.ThawEffect_01'),SlotPriority=0,VolumePrefab=0,Slots=none,Volume=1,VolumeVariance=0,InnerRadius=512,InnerRadiusVariance=0,Radius=2048,RadiusVariance=0,Pitch=1,PitchVariance=0.25,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=true,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none)
    PissEffectBoneName=pelvis
    DrainedLockoutTime=30
    MaxStepHeightEx=27.08
    GroundSpeed=320
    WalkSpeedScale=0.5
    DuckSpeedScale=0.3
    MaxStepHeight=25
    AirControl=0.05
    MaxDesiredSpeed=1
    SwimSoundTime=1
    ChokeHurtRate=1
    HoldBreathTime=15
    BreathDrainRate=1
    BreathRechargeRate=6
    ChokeHurtDamage=10
    ChokeGaspMinorPercentage=0.5
    ChokeGaspMajorPercentage=0.33
    CarriedActorThrowCurve=(Points=((Time=5,Min=100,Max=1000),(Time=150,Min=5000,Max=32000)))
    CarriedActorDropResolution=2048
    CarriedActorDropAngles=(Min=-12288,Max=8192)
    CarriedActorThrowAngles=(Min=-12288,Max=16384)
    CarriedActorPositionBuffer=4
    CarriedActorRightHandAdjust=(Pitch=0,Yaw=16384,Roll=16384)
    CarriedActorLeftHandAdjust=(Pitch=0,Yaw=32768,Roll=0)
    CarriedActorMountMeshItem=hand_right
    LastThrownActorDelay=5
    PlayerReplicationInfoClass='PlayerReplicationInfo'
    bDoOverlayForWeapons=true
    LandedVelocityThreshold=-400
    FootprintSpecialLength=10
    FootstepTraceLength=24
    ExitSplashSoundName=Generic_ExitSplash
    BigSplashSoundName=Generic_BigEnterSplash
    LittleSplashSoundName=Generic_LittleEnterSplash
    SwimStrokeSoundName=Swim
    ExitSplash=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=8,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none)
    BigSplash=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=8,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none)
    LittleSplash=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=8,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none)
    FovAngle=90
    LipSyncInfoClass='LipSyncInfo_Default'
    bDrawHUDInfo=true
    bCanShowSelf=true
    Health=100
    HealthCap=100
    bEnableImpactSounds=false
    bIgnoresPhysicsDamage=false
    StaticInteractionClassification=6
    DynamicInteractionClassification=3
    KFriction=0
    KRestitution=0.01
    KImpactThreshold=100
    CrushResistance=200000
    Physics=1
    bBlockActors=true
    bBlockPlayers=true
    bBlockKarma=true
    bBlockAI=true
    bBlockPath=true
    bIsPawn=true
    bDumbMesh=false
    bCanTeleport=true
    bDisturbWaterSurface=true
    bAcceptsDecalProjectors=false
    bDirectional=true
    bStepUpAble=false
    bCollideActors=true
    bCollideWorld=true
    bAIMoveable=false
    CollisionRadius=21
    CollisionHeight=39
    AccelRate=500
    Texture=Texture'S_Pawn'
    OverlayBumpShaderInfo=(Shader='dt_Effects3.FrozenShader.Frozen_BS',Cube='dt_cubemaps.World.genchromeenv1bc_cubemap',UVScale=(X=1,Y=1,Z=0))
    NetPriority=2
    SoundVolume=240
    SoundRadius=225
    SoundInnerRadius=112
    TransientSoundRadius=1024
    TransientSoundInnerRadius=512
    ScaleModifierGroupList(0)=(Modifiers=none,Identifier=SizeChange,DefaultModValue=0,LastValue=0,NoUpdate=false)
}