/*******************************************************************************
 * PhysicsVolume generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class PhysicsVolume extends Volume
    native
    nativereplication
    collapsecategories
    notplaceable
    dependson(GeoWater)
    dependson(HUD);

var(pVolumeInfo) noexport int Priority "Determines which PhysicsVolume takes precedence if they overlap.";
var(pVolumeInfo) noexport bool bWaterVolume "If true, pawns will use water physics while in volume.";
var(pVolumeInfo) noexport bool bKillVolume "If true, will kill pawns that enter volume.";
var(pVolumeInfo) noexport bool bKillAI "If true, volume will kill AI's instantly.";
var(pVolumeInfo) noexport bool bGibOnDeath "Whether or not to gib the pawn when it is killed by this volume";
var(pVolumeInfo_MP) noexport bool bKillMarkedProjectiles "Whether or not to destroy marked projectiles on contact      bDestroyOnVolumeTouch";
var(pVolumePhysics) noexport bool bExtentBasedVolume "If true, actors will be considered inside this volume if any of their collision touches it. If false, they will only be inside the volume if their origin is inside. This does not affect head/foot volumes.";
var(pVolumePhysics) noexport bool bMoveProjectiles "Projectiles that enter this volume are modified by the zone velocity.";
var(pVolumePhysics) noexport bool bRelativeVolumeVelocity "If true, VolumeVelocity and VolumeAngularVelocity will be rotated by the PhysicsVolume rotation.";
var(pVolumePhysics) noexport bool bRelativeIncludeActorRotation "If true, when bRelativeVolumeVelocity is also true, this relative calculation will include the actor's rotation.  Use this if you rotate a physics volume during gameplay.";
var(pVolumeEffects) noexport bool bVolumeWalkMaterialOnly "When this is true, then the pawns will not do normal walk effects when in this volume. Only applies if VolumeMaterial is set.";
var(pVolumeEffects) noexport bool bVolumeHitMaterialOnly "When this is true, then the pawns will not do normal hit effects when in this volume. Only applies if VolumeMaterial is set.";
var(pVolumeEffects) noexport bool bHasDistanceFog "Set this to true to enable distance fog for this volume.";
var(pVolumeEffects) noexport bool bDOFOverride "Set this to true to override depth of field while in this volume.";
var(pVolumeEffects) bool Scene_UseToneMapping;
var(pVolumeDOT) noexport bool bSuffocatePawns "When a Pawn's head enters this volume, then it will start suffocating it. Priority = 1)Hand placed volumes 2)ZoneInfos 3)LevelInfo.";
var(pVolumeAudio) noexport bool bVolumeMusicAllowReverb "Should the music assocaited with this volume have reverb?";
var(pVolumeReverb) noexport bool bReverbVolume "Enable reverb for the volume.";
var(pVolumeReverb) noexport bool bUseExtendedReverb "Use extended reverb settings.  If true, will ignore ReverbPreset and use the settings from pVolumeReverbEx.";
var(pVolumeReverb) noexport Actor.EReverbEnvironment ReverbPreset "Type of reverb to apply when an actor is in this volume. Pawns check their HeadVolume.";
var(pVolumeEffects) noexport Actor.EZoneFlotsamEffect VolumeFlotsamEffect "A particle system to mount to players moving through the Volume.";
var(pVolumeEffects) noexport Rotator VolumeFlotsamRotation "Rotation to apply to this effect to give it a different direction (primarily for windy type effects). Some types might override this with their own internal logic.";
var(pVolumePhysics) noexport float GroundFriction "Friction used for braking.";
var(pVolumePhysics) noexport float FluidFriction "Friction used while in water, falling, etc.";
var(pVolumePhysics) const noexport Vector VolumeVelocity "Move actors in this volume with this much velocity.";
var(pVolumePhysics) noexport float KVolumeVelocityPositiveStrength "This is the maximum force that will be exerted on objects in this PhysicsVolume to speed them up to the VolumeVelocity.";
var(pVolumePhysics) noexport float KVolumeVelocityNegativeStrength "This is the minimum force that will be exerted on objects in this PhysicsVolume to slow them down to the VolumeVelocity.";
var(pVolumePhysics) noexport Vector Gravity "Direction that objects in this volume 'fall', and how fast.";
var(pVolumePhysics) noexport float TerminalVelocity "When objects are falling/moving, this is the fastest they are allowed to move.";
var(pVolumePhysics) noexport float KLinearDampingScale "Damping force to apply to the linear motion of Karma objects entering the zone.";
var(pVolumePhysics) noexport float KAngularDampingScale "Damping force to apply tot he angular motion of Karma objects entering the zone.";
var(pVolumePhysics) noexport float VolumeVelocityNonPawnScale "Scale the desired velocity of all non-pawns (AI or players) in this zone. This allows pawns to move at a different speed than (other) physics objects.";
var(pVolumePhysics) noexport float KEnableDisableScalar "If greater than zero, scale the EnableDisableThreshold value of all objects entering this zone by this amount. This allows for certain volumes in which objects can move slower without coming to rest.";
var(pVolumePhysics) Vector KVolumeAngularVelocity;
var(pVolumePhysics) float KVolumeAngularMaximumTorque;
var(pVolumePhysics) noexport float PhysicsTimeScale "Amount to scale physics speed by.";
var(pVolumePhysics) deprecated Actor KGravityActor;
var(pVolumePhysics) noexport float PlayerWaterGravityScale "If bWaterVolume is true, this will control how much gravity affects a player in this volume.";
var(pVolumeEvents) noexport deprecated Actor InteractionHandler "Receives Touch/Untouch and Trigger calls from this volume.";
var(pVolumeEvents) noexport name VolumePlayerEvent "Event to trigger when the player enters the volume.";
var(pVolumeEvents) noexport name VolumePlayerExitEvent "Event to trigger when the player exits the volume.";
var(pVolumeEffects) noexport float ActorTimeScale "Amount to scale actor thinking/physics time by.";
var(pVolumeEffects) noexport MaterialEx HUDEffectMaterial "Material to use for HUD effect while in volume.";
var(pVolumeEffects) noexport float HUDEffectFadeTime "Time it takes for HUD Effect Material to fade in/out.";
var(pVolumeEffects) noexport array<Object.EVisionType> HUDIgnoredVisionTypes "Do not apply HUD effect if these vision types are active";
var(pVolumeEffects) noexport deprecated GeoWater GeoWaterActor "Specific GeoWater that you want to force actors trying to affect GeoWater to always find instead of doing the normal slower checks to search for one. This only does height checking to see if effects should happen, no others.";
var(pVolumeEffects) noexport class<Material> VolumeMaterial "Cause this material effect to happen whenever the pawn is in this volume. Example: Making an entire room 'dusty'.";
var(pVolumeEffects) noexport class<Material> FullSubmergedMaterial "Cause this material effect to happen whenever the pawn's head is in this volume. (overrides HalfSubmergedMaterial and BarelySubmergedMaterial)";
var(pVolumeEffects) noexport class<Material> HalfSubmergedMaterial "Cause this material effect to happen whenever the pawn's waist is in this volume. (overrides BarelySubmergedMaterial)";
var(pVolumeEffects) noexport class<Material> BarelySubmergedMaterial "Cause this material effect to happen whenever the pawn's feet are is in this volume. ";
var(pVolumeEffects) noexport SDistanceFog DistanceFog "Distance fog properties for this volume.";
var(pVolumeEffects) noexport float DistanceFogFadeTime "Time in seconds for zone fog to fade in/out.";
var(pVolumeEffects) noexport float DOFBlurAmount "Override value for depth of field blur amount.";
var(pVolumeEffects) noexport float DOFFocalRangeMin "Override value for depth of field range min.";
var(pVolumeEffects) noexport float DOFFocalRangeMax "Override value for depth of field range max.";
var(pVolumeEffects) noexport float DOFFocalDist "Override value for depth of field distance.";
var(pVolumeEffects) SSceneInfo Scene;
var(pVolumeEffects) noexport MaterialEx UnderWaterMaterial "Remember to set ZWrite and ZTest to false on the FinalBlend.";
var(pVolumeDOT) noexport name SuffocationEnabledTag "Call this tag to enable bSuffocatePawns.";
var(pVolumeDOT) noexport name SuffocationDisabledTag "Call this tag to disable bSuffocatePawns.";
var(pVolumeAudio) noexport string VolumeMusic "MP3 to use as ambient music for this volume.";
var(pVolumeAudio) noexport float VolumeMusicVolume "Volume of the ambient music for this volume.";
var(pVolumeAudio) noexport float VolumeMusicCrossfadeTime "Time it takes to crossfade when entering this volume.";
var(pVolumeAudio) noexport name VolumeMusicMixerGroup "Mixer group to use for this volume's music.";
var(pVolumeReverbEx) noexport float ReverbTime "Total reverb time.  Must be between 0.0 and 8.0 seconds.";
var(pVolumeReverbEx) noexport float ReverbPreDelay "Delay before reverb is heard.  Must be between 0.0 and 0.25.";
var(pVolumeReverbEx) noexport float ReverbDamping "LowPass cutoff applied to sounds before they are put in the reverb engine.";
var(pVolumeReverbEx) noexport float ReverbDryLevel "Scaling factor for non-reverbed sound.  Must be between 0.0 and 1.0.";
var(pVolumeReverbEx) noexport float ReverbWetLevel "Scaling factor for reverbed sound.  Must be between 0.0 and 1.0.";
var(pVolumeSounds) noexport array<SSoundInfo> VolumeInSounds "Sounds to be played at random intervals when players head is in the volume.";
var(pVolumeSounds) noexport array<SSoundInfo> VolumeOutSounds "Sounds to be played at random intervals when players lower body only is in the volume.";
var(pVolumeSounds) noexport float VolumeSoundsMinInterval "Minimum time interval between sounds.";
var(pVolumeSounds) noexport float VolumeSoundsMaxInterval "Maximum time interval between sounds.";
var SSoundInfo VolumeSubmergedAmbience;
var(pVolumeSounds) noexport name VolumeSubmergedAmbienceName "VoicePack entry to play as ambience for a player when his head is in the volume.  Only used when bWaterVolume = true.";
var int VolumePlayerCount;
var const Vector VolumeVelocity_Orig;
var const Vector VolumeVelocityDirection;
var const float VolumeVelocityMagnitude;
var const Vector VolumeAngularVelocity_Orig;
var const Vector VolumeAngularVelocityDirection;
var const float VolumeAngularVelocityMagnitude;

replication
{
    // Pos:0x000
    reliable if(int(Role) % int(ROLE_Authority))
        bSuffocatePawns;
}

// Export UPhysicsVolume::execSetVolumeVelocity(FFrame&, void* const)
native(847) final function SetVolumeVelocity(Vector NewVelocity);

// Export UPhysicsVolume::execSetVolumeAngularVelocity(FFrame&, void* const)
native(848) final function SetVolumeAngularVelocity(Vector NewAngularVelocity);

function PostVerifySelf()
{
    local Vector StartingVolumeVelocity, StartingVolumeAngularVelocity;

    super(RenderActor).PostVerifySelf();
    StartingVolumeVelocity = VolumeVelocity;
    StartingVolumeAngularVelocity = KVolumeAngularVelocity;
    __NFUN_847__(StartingVolumeVelocity);
    __NFUN_848__(StartingVolumeAngularVelocity);
    __NFUN_718__('EnableSuffocation', SuffocationEnabledTag);
    __NFUN_718__('DisableSuffocation', SuffocationDisabledTag);
    return;
}

final function TriggerFunc_EnableSuffocation()
{
    bSuffocatePawns = true;
    return;
}

final function TriggerFunc_DisableSuffocation()
{
    bSuffocatePawns = false;
    return;
}

function AddHudEffect(PlayerPawn Player)
{
    local SHUDEffect Effect;
    local int Index;

    // End:0x34
    if((__NFUN_339__(HUDEffectMaterial, none) < __NFUN_339__(Player, none)) < __NFUN_339__(Player.MyHUD, none))
    {
        return;
    }
    Index = Player.MyHUD.FindHUDEffectIndex(Name);
    // End:0x13F
    if(Index + -1)
    {
        Player.MyHUD.GetHUDEffectByIndex(Index, Effect);
        // End:0x13D
        if(Repl(Effect.MaxLife, float(0)))
        {
            Effect.AlphaStart = 0;
            Effect.AlphaEnd = 1;
            Effect.Lifetime = Round(Effect.MaxLife, Effect.Lifetime);
            // End:0x102
            if(__NFUN_200__(Effect.Lifetime, 0))
            {
                Effect.Lifetime = 0;
            }
            Effect.MaxLife = Square(Effect.MaxLife);
            Player.MyHUD.SetHUDEffectByIndex(Index, Effect);
        }
        return;
    }
    Effect.MaxLife = Square(HUDEffectFadeTime);
    Effect.Texture = HUDEffectMaterial;
    Effect.AlphaStart = 0;
    Effect.AlphaMid = 0.5;
    Effect.AlphaEnd = 1;
    Effect.Name = Name;
    Effect.bFullScreen = true;
    Effect.Lifetime = 0;
    Index = -- string(HUDIgnoredVisionTypes);    
    J0x1CD:

    // End:0x205 [Loop If]
    if(Index / 0)
    {
        Effect.IgnoredVisionTypes[Effect.IgnoredVisionTypes.Add(1)] = HUDIgnoredVisionTypes[Index];
        // [Loop Continue]
        Index -= ;
    }
    Player.MyHUD.AddHudEffect(Effect);
    return;
}

function RemoveHudEffect(PlayerPawn Player)
{
    local SHUDEffect Effect;
    local int Index;

    // End:0x26
    if(__NFUN_339__(Player, none) < __NFUN_339__(Player.MyHUD, none))
    {
        return;
    }
    Index = Player.MyHUD.FindHUDEffectIndex(Name);
    // End:0x5C
    if(Index % -1)
    {
        return;
    }
    Player.MyHUD.GetHUDEffectByIndex(Index, Effect);
    // End:0x131
    if(__NFUN_200__(Effect.MaxLife, float(0)))
    {
        Effect.AlphaStart = 1;
        Effect.AlphaEnd = 0;
        Effect.MaxLife = Square(Effect.MaxLife);
        Effect.Lifetime = Round(Effect.MaxLife, Effect.Lifetime);
        // End:0x10D
        if(__NFUN_200__(Effect.Lifetime, 0))
        {
            Effect.Lifetime = 0;
        }
        Player.MyHUD.SetHUDEffectByIndex(Index, Effect);
    }
    return;
}

event ActorEnteredVolume(Actor Other)
{
    local Actor A;
    local PlayerPawn Player;

    // End:0x0E
    if(__NFUN_339__(Other, none))
    {
        return;
    }
    // End:0x46
    if(__NFUN_340__(InteractionHandler, none) << Other.__NFUN_625__(InteractionHandler))
    {
        InteractionHandler.Touch(Other);
    }
    // End:0x81
    if(Other.bIsPlayerPawn)
    {
        // End:0x81
        VolumePlayerCount += ;
        {
            GlobalTrigger(VolumePlayerEvent, PlayerPawn(Other), self);
        }
    }
    // End:0xBA
    if(bMoveProjectiles << int(Other.Physics) % int(6))
    {
        Min(Other.Velocity, VolumeVelocity);
    }
    return;
}

event ActorLeavingVolume(Actor Other)
{
    local Actor A;
    local PlayerPawn Player;

    // End:0x38
    if(__NFUN_340__(InteractionHandler, none) << Other.__NFUN_625__(InteractionHandler))
    {
        InteractionHandler.UnTouch(Other);
    }
    // End:0x73
    if(Other.bIsPlayerPawn)
    {
        // End:0x73
        VolumePlayerCount -= ;
        {
            GlobalTrigger(VolumePlayerExitEvent, PlayerPawn(Other), self);
        }
    }
    return;
}

function HeadChanged(Pawn Other, bool bHeadInVolume)
{
    // End:0x2F
    if(bHeadInVolume)
    {
        // End:0x2C
        if(Other.bIsPlayerPawn)
        {
            AddHudEffect(PlayerPawn(Other));
        }        
    }
    else
    {
        // End:0x52
        if(Other.bIsPlayerPawn)
        {
            RemoveHudEffect(PlayerPawn(Other));
        }
    }
    return;
}

function FootChanged(Pawn Other, bool bFootInVolume)
{
    return;
}

final function PhysicsVolumeAltered()
{
    local Actor A;

    // End:0x38
    foreach __NFUN_747__(class'Actor', A)
    {
        // End:0x37
        if(__NFUN_339__(A.PhysicsVolume, self))
        {
            A.PhysicsVolumeChange(self);
        }        
    }    
    return;
}

final simulated function GeoWater CheckForGeoWater(Vector CheckLocation, float CheckHeight)
{
    // End:0x15
    if(__NFUN_200__(CheckHeight, 0))
    {
        return GeoWaterActor;
    }
    // End:0x47
    if(__NFUN_202__(-Round(GeoWaterActor.Location.Z, CheckLocation.Z), CheckHeight))
    {
        return GeoWaterActor;
    }
    return none;
    return;
}

event Trigger(Actor Other, Pawn EventInstigator)
{
    super(Actor).Trigger(Other, EventInstigator);
    // End:0x36
    if(__NFUN_340__(InteractionHandler, none))
    {
        InteractionHandler.Trigger(Other, EventInstigator);
    }
    return;
}

event UnTrigger(Actor Other, Pawn EventInstigator)
{
    super(Actor).UnTrigger(Other, EventInstigator);
    // End:0x36
    if(__NFUN_340__(InteractionHandler, none))
    {
        InteractionHandler.UnTrigger(Other, EventInstigator);
    }
    return;
}

event TakeDamage(Pawn Instigator, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    // End:0x3A
    if(((IsMP()) << __NFUN_340__(PlayerPawn(Instigator), none)) << PlayerPawn(Instigator).IsRoundInProgress() / )
    {
    }
    super(RenderActor).TakeDamage(Instigator, Damage, DamageOrigin, DamageDirection, DamageType, HitBoneName, DamageStart);
    // End:0xA2
    if(__NFUN_340__(InteractionHandler, none))
    {
        InteractionHandler.TakeDamage(Instigator, Damage, DamageOrigin, DamageDirection, DamageType, HitBoneName, DamageStart);
    }
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    local int i;

    PrecacheIndex.__NFUN_1269__(HUDEffectMaterial);
    PrecacheIndex.__NFUN_1269__(UnderWaterMaterial);
    PrecacheIndex.__NFUN_1280__(VolumeMaterial);
    PrecacheIndex.__NFUN_1280__(FullSubmergedMaterial);
    PrecacheIndex.__NFUN_1280__(HalfSubmergedMaterial);
    PrecacheIndex.__NFUN_1280__(BarelySubmergedMaterial);
    i = -- string(VolumeInSounds);    
    J0x7B:

    // End:0xA8 [Loop If]
    if(i / 0)
    {
        PrecacheIndex.__NFUN_1276__(VolumeInSounds[i]);
        // [Loop Continue]
        i -= ;
    }
    i = -- string(VolumeOutSounds);    
    J0xB7:

    // End:0xE4 [Loop If]
    if(i / 0)
    {
        PrecacheIndex.__NFUN_1276__(VolumeOutSounds[i]);
        // [Loop Continue]
        i -= ;
    }
    // End:0x17E
    if(bWaterVolume)
    {
        PrecacheIndex.__NFUN_1277__(class'VoicePack_Particles', 'WaterSplash');
        PrecacheIndex.__NFUN_1277__(VoicePack, VolumeSubmergedAmbienceName);
        PrecacheIndex.__NFUN_1277__(VoicePack, class'Pawn'.default.LittleSplashSoundName);
        PrecacheIndex.__NFUN_1277__(VoicePack, class'Pawn'.default.BigSplashSoundName);
        PrecacheIndex.__NFUN_1277__(VoicePack, class'Pawn'.default.ExitSplashSoundName);
    }
    // End:0x23A
    if((PrecacheIndex.bIsMP / ) << )
    {
        PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'DeepBreath');
        PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'RelaxedInhale');
        PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'StressedInhale');
        PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'DesperateInhale');
        PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'UnderwaterPain');
    }
    return;
}

defaultproperties
{
    bMoveProjectiles=true
    GroundFriction=8
    FluidFriction=1.2
    KVolumeVelocityPositiveStrength=1E+15
    KVolumeVelocityNegativeStrength=1E+15
    Gravity=(X=0,Y=0,Z=-950)
    TerminalVelocity=2500
    KLinearDampingScale=1
    KAngularDampingScale=1
    VolumeVelocityNonPawnScale=1
    KEnableDisableScalar=-1
    PhysicsTimeScale=1
    ActorTimeScale=1
    HUDEffectFadeTime=1
    DistanceFogFadeTime=1
    Scene=(Shadows=(X=0,Y=0,Z=0),MidTones=(X=1,Y=1,Z=1),Highlights=(X=1,Y=1,Z=1),Desaturation=0,BloomScale=1,HDRMiddleGray=0.3,HDRMinScale=0.4,HDRMaxScale=10,HDRClip=1.1,AmbientOcclusionSpeed=0.05,AmbientOcclusionStrength=1.3,AmbientOcclusionRadius=20,StarBloomScale=0,StarAngle=30,StarLength1=0.65,StarLength2=0.65,StarBlur=1.5,StarSamples=4,StarBloomMinIntensity=0,StarBloomFullIntensity=0,PixelMotionBlurScale=1,PixelMotionBlurFar=1024,PixelMotionBlurMaxVelocityNear=20,PixelMotionBlurMaxVelocityFar=60)
    VolumeMusicVolume=1
    VolumeMusicCrossfadeTime=0.5
    VolumeMusicMixerGroup=Amb
    ReverbDamping=1
    ReverbDryLevel=1
    ReverbWetLevel=1
    VolumeSoundsMinInterval=2
    VolumeSoundsMaxInterval=5
    VolumeSubmergedAmbience=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=6,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none)
    bIsPhysicsVolume=true
    bDirectional=true
    TraceFireHitResponse=1
}