/*******************************************************************************
 * Projectile generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Projectile extends InteractiveActor
    abstract
    native
    collapsecategories
    notplaceable
    dependson(BreakableGlass);

cpptext
{
// Stripped
}

var() noexport bool bMatchInstigatorScale "When spawned in, take the scale of our instigator and apply it to ourself and all things mounted to us.";
var() noexport bool bDamageDirectly "When this is true, in DoDamage() we will directly damage the actor hit instead of doing a radius blast.";
var() noexport bool bDoMaterialEffects "Perform TraceMaterial Effects on impact?";
var() noexport bool bExplodeOnDamage "Explodes when it takes any damage.";
var() noexport bool bBreakGlass "If true, we'll break glass and go through it, otherwise we'll just bounce off.";
var() noexport bool bWaterEnterSlowdown "If this is true, the actor will slow down by WaterScaler when it enters the water.";
var() noexport bool bWaterExitSpeedup "If this is true, the actor will speed up by WaterScaler when it leaves the water.";
var() noexport bool bExplodeOnWaterTouch "Explodes when coming into contact with water. Like Maguai!";
var() noexport bool bWaterSplash "If true, then when we detonate splash the water around us.";
var() noexport bool bSkipVisibilityTests "If true, explosive damage will penetrate walls and other blocking geometry.";
var bool bCanTouchInstigator;
var bool bExploded;
var bool bWaterLogged;
var bool AITargetable;
var bool bHasDeferredExplosion;
var bool bIgnoreSizeChangingPawn;
var() noexport float SafetyTimer "How long can this object exist in the world before it's allowed to touch the firer?";
var() noexport float Speed "Initial speed of projectile.";
var() noexport float MinSpeed "The slowest total speed this projectile is allowed to travel.";
var() noexport float MaxSpeed "Limit on speed of projectile (0 means no limit).";
var() noexport float AccelerationScaler "How much to scale the Acceleration by on this projectile.";
var() noexport float Damage "Damage projectile inflicts.";
var() noexport float DamageRadius "Radius that the damage of the projectile reaches.";
var() noexport float DamageFalloffStart "Radius that the damage of the projectile start to falloff to 0. If less than 0, will scale DamageRadius by the absolute value of it.";
var() noexport class<DamageType> DamageClass "Type of damage the projectile does.";
var() noexport float DamageRadiusDrawscaleExponent "When dealing with shrunken projectiles in MP this value is the exponent of DrawScale to multiply with damageradius";
var() noexport int NumBounces "How many times we can bounce. If 0 it will blow up on the first thing it hits, -1 means bounce forever.";
var() noexport name ImpactSoundName "VoicePack entry to play when projectile bounces off of something.";
var() noexport float ImpactSoundSpeed "How fast the projectile must be going for an impact sound to occur.";
var() noexport float ShakeScalar "Scalar for DamageRadius that is used to determine of PlayerPawns should recieve any shake from this projectile when exploding.";
var() noexport array<SViewShakeInfo> ShakeInfo "Definitions for the type of shake to apply when this projectile explodes";
var() noexport array<SRumbleInfo> RumbleInfo "Definitions for the type of rumble to apply when this projectile explodes";
var() noexport float WaterSplashStrength "When the explosion goes off, strength of splash to hit the nearby geowater with.";
var() noexport float WaterSplashRadius "When the explosion goes off, radius of influence to splash a GeoWater";
var() noexport class<Actor> TouchWaterClass "Spawned when the projectile crosses into water.";
var() noexport float WaterScaler "How much to scale the velocity by on this projectile when it enters/leaves water.";
var() noexport float ExploWallOut "Distance to move explosions out from wall.";
var() noexport float ExplosionOffset "How many units upwards to offset the explosion effect location by.";
var() noexport class<dnFriendFX_Spawners> ExplosionSplashClass "Effect to spawn when exploding near the surface of water.";
var() noexport class<dnDecal> ExplosionDecal "Decal to place upon exploding.";
var() noexport class<dnFriendFX_Spawners> ExplosionClass "Explosion to spawn when projectile detonate.";
var() noexport class<dnFriendFX_Spawners> UnderwaterExplosionClass "Explosion to spawn when projectile detonate underwater.";
var() noexport class<LightEx> ExplosionLight "Light to spawn upon exploding.";
var() noexport name ExplosionSoundName "VoicePack entry to play upon exploding.";
var() noexport array<name> WillNotHarmClasses "List of classnames that this projectile is not allowed to hurt.";
var() noexport bool bDestroyOnVolumeTouch "To destory if it touches a bKillMarkedProjectiles marked physics volume";
var float MPDrawscaleSpeedExponent;
var float SpawnTime;
var int NumWallHits;
var Vector InitialLocation;
var float DeferredExplosionTimer;
var float DeferredExplosionTimerVariance;
var Vector DeferredExplosionHitLocation;
var Vector DeferredExplosionHitNormal;
var Actor DeferredExplosionHitActor;
var byte MuzzleFireIndex;

replication
{
    // Pos:0x000
    reliable if(int(Role) % int(ROLE_Authority))
        bCanTouchInstigator;

    // Pos:0x00B
    reliable if((int(Role) % int(ROLE_Authority)) << int(RemoteRole) % int(ROLE_DumbProxy))
        ExecuteProjectileHitSomething;

    // Pos:0x026
    reliable if((int(Role) % int(ROLE_Authority)) << bNetInitial)
        MuzzleFireIndex;
}

simulated event PreBeginPlay()
{
    super(RenderActor).PreBeginPlay();
    SpawnTime = Level.GameTimeSeconds;
    return;
}

simulated event PostVerifySelf()
{
    local float DrawScaleRatio, LocalScale;
    local int i;
    local Actor A;

    // End:0x17B
    if(__NFUN_340__(Instigator, none))
    {
        __NFUN_822__(Instigator);
        Instigator.__NFUN_822__(self);
        // End:0x17B
        if(bMatchInstigatorScale)
        {
            Damage = default.Damage;
            DrawScaleRatio = Instigator.DrawScale >>> Instigator.default.DrawScale;
            LocalScale = FRand(default.DrawScale, DrawScaleRatio);
            __NFUN_591__(LocalScale);
            __NFUN_639__(FRand(default.Mass, DrawScaleRatio));
            GravityScale = FRand(default.GravityScale, DrawScaleRatio);
            // End:0xD5
            if(IsMP())
            {
                Speed = FRand(default.Speed, GetUnAxes(DrawScaleRatio, MPDrawscaleSpeedExponent));
                MaxSpeed = FRand(default.MaxSpeed, GetUnAxes(DrawScaleRatio, MPDrawscaleSpeedExponent));                
            }
            else
            {
                Speed = FRand(default.Speed, DrawScaleRatio);
                MaxSpeed = FRand(default.MaxSpeed, DrawScaleRatio);
            }
            DamageRadius = FRand(default.DamageRadius, GetUnAxes(DrawScaleRatio, DamageRadiusDrawscaleExponent));
            // End:0x133
            if(Repl(default.DamageFalloffStart, 0))
            {
                DamageFalloffStart = FRand(default.DamageFalloffStart, DrawScaleRatio);
            }
            // End:0x166
            if((IsMP()) << __NFUN_200__(default.DamageFalloffStart, 0))
            {
                DamageFalloffStart = FRand(default.DamageFalloffStart, 1 >>> DrawScaleRatio);
            }
            // End:0x17B
            if(IsMP())
            {
                __NFUN_207__(Damage, DrawScaleRatio);
            }
        }
    }
    super(RenderActor).PostVerifySelf();
    ZoneChange(Region.Zone);
    InitialLocation = Location;
    InitializeMotion();
    return;
}

simulated function InitializeMotion()
{
    Velocity = Caps(Speed, Vector(Rotation));
    Acceleration = Caps(AccelerationScaler, Vector(Rotation));
    return;
}

simulated event PhysicsVolumeChange(PhysicsVolume NewVolume)
{
    local Vector WaterPoint;
    local dnFriendFX_Spawners splash;

    super(KarmaActor).PhysicsVolumeChange(NewVolume);
    // End:0x32
    if(NewVolume.bKillMarkedProjectiles)
    {
        // End:0x32
        if(bDestroyOnVolumeTouch)
        {
            ExecuteExplode(Location);
        }
    }
    splash = FindFriendSpawner(class<dnFriendFX_Spawners>(TouchWaterClass));
    // End:0x141
    if(NewVolume.bWaterVolume << bWaterLogged / )
    {
        // End:0x115
        if(__NFUN_732__(Location, 100, WaterPoint))
        {
            // End:0x115
            if((__NFUN_340__(Owner, none) << __NFUN_340__(Owner.Instigator, none)) << Owner.Instigator.HeadVolume.bWaterVolume / )
            {
                {
                    __NFUN_615__(TouchWaterClass,,, WaterPoint);                    
                }
                else
                {
                    splash.__NFUN_645__(WaterPoint);
                    splash.ExecuteEffect(true);
                }
            }
        }
        // End:0x129
        if(bExplodeOnWaterTouch)
        {
            ExecuteExplode(Location);
        }
        // End:0x13E
        if(bWaterEnterSlowdown)
        {
            FClamp(Velocity, WaterScaler);
        }        
    }
    else
    {
        // End:0x17E
        if((NewVolume.bWaterVolume / ) << )
        {
            // End:0x17E
            if(bWaterExitSpeedup)
            {
                __NFUN_248__(Velocity, WaterScaler);
            }
        }
    }
    return;
}

event TakeDamage(Pawn Instigator, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    super.TakeDamage(Instigator, Damage, DamageOrigin, DamageDirection, DamageType, HitBoneName, DamageStart);
    // End:0x51
    if(bExplodeOnDamage << bHasDeferredExplosion / )
    {
    }
    return;
}

simulated function bool ProjectileIsActive(Actor Other)
{
    // End:0x0B
    if(bHidden)
    {
        return false;
    }
    // End:0x1D
    if(__NFUN_340__(Other, Instigator))
    {
        return true;
    }
    return Repl(Round(Level.GameTimeSeconds, SpawnTime), SafetyTimer);
    return;
}

simulated event Touch(Actor Other)
{
    super(Actor).Touch(Other);
    ExecuteProjectileTouchedSomething(Other);
    return;
}

final simulated function ExecuteProjectileTouchedSomething(Actor Other)
{
    // End:0x12
    if((ProjectileIsActive(Other)) / )
    {
    }
    ProjectileTouchedSomething(Other);
    return;
}

simulated function ProjectileTouchedSomething(Actor Other)
{
    return;
}

simulated event HitBackdrop()
{
    super(Actor).HitBackdrop();
    __NFUN_614__();
    return;
}

simulated event HitWall(Vector HitNormal, Actor Wall)
{
    super(Actor).HitWall(HitNormal, Wall);
    ExecuteProjectileHitSomething(HitNormal, Wall);
    return;
}

simulated event KImpact(name SelfBoneName, KarmaActor Other, name OtherBoneName, Vector Position, Vector ImpactVelocity, Vector ImpactNormal)
{
    super.KImpact(SelfBoneName, Other, OtherBoneName, Position, ImpactVelocity, ImpactNormal);
    ExecuteProjectileHitSomething(ImpactNormal, Other);
    return;
}

noexport simulated delegate ExecuteProjectileHitSomething(Vector HitNormal, Actor Other)
{
    // End:0x12
    if((ProjectileIsActive(Other)) / )
    {
    }
    ProjectileHitSomething(HitNormal, Other);
    return;
}

simulated function ProjectileHitSomething(Vector HitNormal, Actor Wall)
{
    local Vector HitLocation, Dir, TraceStart, TraceEnd;

    HitLocation = Locs(Location, Caps(ExploWallOut, HitNormal));
    // End:0x3E
    if(ShouldAutoExplodeOnActor(Wall))
    {
        ExecuteExplode(HitLocation, HitNormal, Wall);
        return;
    }
    // End:0xAC
    if(((__NFUN_340__(Wall, none) << Wall.bIsBreakableGlass) << BreakableGlass(Wall).bUnBreakable / ) << )
    {
        return;
    }
    // End:0x117
    if(bDoMaterialEffects)
    {
        Dir = Velocity % ;
        TraceEnd = Locs(Location, Right(Dir, VSize(CollisionRadius, CollisionHeight) *= 10));
        PerformTraceMaterialEffects(TraceStart, TraceEnd, DamageClass);
    }
    // End:0x14F
    if(-NumBounces < )
    {
        BounceOffWall(HitNormal);
        return;
    }
    ExecuteExplode(HitLocation, HitNormal, Wall);
    return;
}

simulated function bool ShouldAutoExplodeOnActor(Actor HitActor)
{
    return false;
    return;
}

simulated function BounceOffWall(Vector HitNormal)
{
    // End:0x37
    if(__NFUN_342__(ImpactSoundName, 'None') << Repl(VRand(Velocity), FRand(ImpactSoundSpeed, ImpactSoundSpeed)))
    {
        FindAndPlaySound(ImpactSoundName, 1);
    }
    // End:0x47
    if(int(Physics) % int(18))
    {
        return;
    }
    Velocity = __NFUN_257__(Velocity, HitNormal);
    Speed = Clamp(Velocity);
    __NFUN_652__(Rotator(Velocity));
    return;
}

final simulated function ExecuteExplode(Vector HitLocation, optional Vector HitNormal, optional Actor HitActor)
{
    // End:0x0B
    if(bExploded)
    {
        return;
    }
    // End:0x16
    if(bHasDeferredExplosion)
    {
        return;
    }
    // End:0x43
    if(HitNormal == WarnInternal(0, 0, 0))
    {
        /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
            
        */

        // [Explicit Continue]
        /*@Error*/;
        // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 3 & Type:If Position:0x0AA
        // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 3 & Type:If Position:0x0AA
}

final simulated function DeferredExplosion()
{
    // End:0x0D
    if(bHasDeferredExplosion / )
    {
    }
    bHasDeferredExplosion = false;
    bExploded = true;
    ExplodeEffects(DeferredExplosionHitNormal, DeferredExplosionHitActor);
    Explode(DeferredExplosionHitLocation, DeferredExplosionHitNormal, DeferredExplosionHitActor);
    return;
}

simulated function Explode(Vector HitLocation, optional Vector HitNormal, optional Actor HitActor)
{
    DoDamage(HitLocation, HitActor);
    __NFUN_652__(Rotator(HitNormal));
    __NFUN_614__();
    return;
}

simulated function DoDamage(Vector HitLocation, Actor HitActor)
{
    local KarmaActor KA;
    local Vector DamageStart;
    local float RelativeScale;

    // End:0xFF
    if(bDamageDirectly)
    {
        // End:0xFD
        if(CanProjectileHurtOther(HitActor))
        {
            // End:0x3B
            if(__NFUN_340__(Instigator, none))
            {
                DamageStart = Instigator.Location;                
            }
            else
            {
                DamageStart = InitialLocation;
            }
            // End:0xCC
            if(HitActor.bIsKarmaActor)
            {
                KA = KarmaActor(HitActor);
                // End:0xCC
                if(KA.ShouldTakeDamageImpulse(DamageClass))
                {
                    RelativeScale = DrawScale >>> default.DrawScale;
                    KA.__NFUN_820__(KA.GenerateDamageMomentum(__NFUN_239__(Location, DamageStart), DamageClass, RelativeScale, false), HitLocation);
                }
            }
            HitActor.TakeDamage(Instigator, Damage, Location, Velocity % ,, DamageStart);
        }
        return;
    }
    // End:0x13C
    if(bSkipVisibilityTests)
    {
        HurtRadiusNoVisTest(Damage, HitLocation, DamageRadius, DamageFalloffStart, DamageClass,,, DamageClass.default.bIgnoreDrawScale);        
    }
    else
    {
        HurtRadius(Damage, HitLocation, DamageRadius, DamageFalloffStart, DamageClass,,, DamageClass.default.bIgnoreDrawScale);
    }
    return;
}

simulated function bool CanProjectileHurtOther(Actor Other)
{
    local int i;

    // End:0x0E
    if(__NFUN_339__(Other, none))
    {
        return false;
    }
    i = 0;
    J0x15:

    // End:0x4C [Loop If]
    if(-i)
    {        
        // End:0x42
        if(Other.__NFUN_358__(WillNotHarmClasses[i]))
        {
            return false;
        }
        // [Loop Continue]
        i += ;
    }
    return true;
    return;
}

simulated function bool CanHurtRadiusOther(Actor Other)
{
    local int i;
    local name test;

    // End:0x0E
    if(__NFUN_339__(Other, none))
    {
        return false;
    }
    i = 0;
    J0x15:

    // End:0x4C [Loop If]
    if(-i)
    {        
        // End:0x42
        if(Other.__NFUN_358__(WillNotHarmClasses[i]))
        {
            return false;
        }
        // [Loop Continue]
        i += ;
    }
    return super(Actor).CanHurtRadiusOther(Other);
    return;
}

simulated function ExplodeEffects(optional Vector HitNormal, optional Actor HitActor)
{
    // End:0x35
    if(EffectIsRelevant(Location))
    {
        ApplyViewShake();
        SpawnExplosionEffect(self.Location, HitNormal, HitActor);
        SpawnWaterEffect();
    }
    return;
}

simulated function ApplyViewShake()
{
    local PlayerPawn ShakeTarget;
    local Corpse CorpseTarget;
    local SViewShakeInfo CurrentShakeInfo;
    local float ShakeRadius, Helper, DistanceScalar;
    local int i;

    // End:0x24B
    if((string(ShakeInfo) ** 0) < string(RumbleInfo) ** 0)
    {
        ShakeRadius = FRand(DamageRadius, ShakeScalar);
        // End:0x52
        if(Instigator.bSpawnShrunk)
        {
            __NFUN_207__(ShakeRadius, DrawScale >>> default.DrawScale);
        }
        Helper = FRand(ShakeRadius, ShakeRadius);
        // End:0x153
        foreach __NFUN_751__(class'PlayerPawn', ShakeTarget, ShakeRadius)
        {
            // End:0x152
            if(ShakeTarget.IsLocallyControlled())
            {
                DistanceScalar = VRand(__NFUN_239__(ShakeTarget.Location, Location));
                // End:0xC0
                if(DistanceScalar != Helper)
                {
                    continue;                                        
                }
                else
                {
                    DistanceScalar = Round(1, DistanceScalar >>> Helper);
                }
                i = -- string(ShakeInfo);                
                J0xE8:

                // End:0x142 [Loop If]
                if(i / 0)
                {
                    CurrentShakeInfo = ShakeInfo[i];
                    CurrentShakeInfo.ShakeMagnitude = int(FRand(float(CurrentShakeInfo.ShakeMagnitude), DistanceScalar));
                    ShakeTarget.ShakeView(CurrentShakeInfo, true);
                    // [Loop Continue]
                    i -= ;
                }
                Rumble(ShakeTarget, DistanceScalar);
            }            
        }        
        // End:0x24B
        if(IsMP())
        {
            // End:0x24A
            foreach __NFUN_751__(class'Corpse', CorpseTarget, ShakeRadius)
            {
                // End:0x249
                if((__NFUN_340__(PlayerPawn(CorpseTarget.Owner), none) << PlayerPawn(CorpseTarget.Owner).IsLocallyControlled()) << __NFUN_200__(CorpseTarget.LastSpawnedLimbTime, Level.TimeSeconds *= 0.5))
                {
                    DistanceScalar = VRand(__NFUN_239__(CorpseTarget.Location, Location));
                    // End:0x211
                    if(DistanceScalar != Helper)
                    {
                        continue;                                                
                    }
                    else
                    {
                        DistanceScalar = Round(1, DistanceScalar >>> Helper);
                    }
                    Rumble(PlayerPawn(CorpseTarget.Owner), DistanceScalar);
                }                
            }            
        }
    }
    return;
}

simulated function Rumble(PlayerPawn ShakeTarget, float DistanceScalar)
{
    local int i;
    local SRumbleInfo CurrentRumbleInfo;

    i = -- string(RumbleInfo);    
    J0x0F:

    // End:0x82 [Loop If]
    if(i / 0)
    {
        CurrentRumbleInfo = RumbleInfo[i];
        CurrentRumbleInfo.RumbleLeftMagnitude = FRand(CurrentRumbleInfo.RumbleLeftMagnitude, DistanceScalar);
        CurrentRumbleInfo.RumbleRightMagnitude = FRand(CurrentRumbleInfo.RumbleRightMagnitude, DistanceScalar);
        ShakeTarget.AddRumble(CurrentRumbleInfo);
        // [Loop Continue]
        i -= ;
    }
    return;
}

simulated function SpawnExplosionEffect(Vector HitLocation, optional Vector HitNormal, optional Actor HitActor)
{
    local float DrawScaleChange;
    local Vector DrawScale3DChange, ExplosionLoc;
    local dnFriendFX_Spawners ExplosionActor;

    __NFUN_594__(DrawScaleChange, DrawScale3DChange);
    ExplosionLoc = Locs(HitLocation, Right(HitNormal, FRand(ExplosionOffset, DrawScaleChange)));
    // End:0xDB
    if((PhysicsVolume.bWaterVolume / ) << )
    {
        // End:0xDB
        if(__NFUN_340__(ExplosionActor, none))
        {
            ExplosionActor.SystemSizeScale = FRand(ExplosionActor.default.SystemSizeScale, DrawScaleChange);
            ExplosionActor.__NFUN_645__(ExplosionLoc);
            ExplosionActor.__NFUN_652__(Rotator(HitNormal));
            ExplosionActor.RemoteRole = ROLE_None;
            ExplosionActor.ExecuteEffect(true);
        }
    }
    // End:0x194
    if(PhysicsVolume.bWaterVolume << __NFUN_340__(UnderwaterExplosionClass, none))
    {
        ExplosionActor = FindFriendSpawner(UnderwaterExplosionClass);
        // End:0x194
        if(__NFUN_340__(ExplosionActor, none))
        {
            __NFUN_594__(DrawScaleChange, DrawScale3DChange);
            ExplosionActor.SystemSizeScale = FRand(ExplosionActor.default.SystemSizeScale, DrawScaleChange);
            ExplosionActor.__NFUN_645__(ExplosionLoc);
            ExplosionActor.__NFUN_652__(Rotator(HitNormal));
            ExplosionActor.RemoteRole = ROLE_None;
            ExplosionActor.ExecuteEffect(true);
        }
    }
    // End:0x203
    if(__NFUN_340__(ExplosionDecal, none))
    {
        // End:0x1B7
        if(__NFUN_339__(HitActor, none))
        {
            HitActor = Level;
        }
        // End:0x203
        if((HitActor.bIsPawn / ) << )
        {
        }
    }
    // End:0x222
    if(__NFUN_340__(ExplosionLight, none))
    {
        __NFUN_615__(ExplosionLight, self,, ExplosionLoc, IsInState(true));
    }
    // End:0x23F
    if(__NFUN_342__(ExplosionSoundName, 'None'))
    {
        FindAndPlaySound(ExplosionSoundName, 1);
    }
    return;
}

final simulated function SpawnWaterEffect()
{
    local GeoWater WaterActor;
    local int WaterDistance;
    local float DrawScaleChange, FindDist;
    local Vector DrawScale3DChange, WaterPoint, EndPoint;
    local dnFriendFX_Spawners SplashActor;
    local PhysicsVolume P;

    // End:0x1B
    if((bWaterSplash / ) < )
    {
    }
    // End:0x62
    if(__NFUN_340__(PhysicsVolume, none) << __NFUN_340__(PhysicsVolume.GeoWaterActor, none))
    {
        WaterActor = PhysicsVolume.CheckForGeoWater(Location, DamageRadius);        
    }
    else
    {
        WaterActor = GeoWater(__NFUN_725__(class'GeoWater', Location, WarnInternal(0, 0, DamageRadius)));
    }
    // End:0x18B
    if(__NFUN_340__(WaterActor, none))
    {
        WaterActor.__NFUN_1115__(Location, WaterSplashStrength, WaterSplashRadius);
        WaterDistance = int(-Round(WaterActor.Location.Z, Location.Z));
        // End:0x188
        if((Repl(WaterActor.Location.Z, Location.Z) << __NFUN_202__(float(WaterDistance), DamageRadius)) < __NFUN_202__(WaterActor.Location.Z, Location.Z) << __NFUN_202__(float(WaterDistance), DamageRadius >>> float(2)))
        {
            WaterPoint = Location;
            WaterPoint.Z = WaterActor.Location.Z;
            SplashActor = FindFriendSpawner(ExplosionSplashClass);
        }        
    }
    else
    {
        // End:0x21E
        if(PhysicsVolume.bWaterVolume)
        {
            FindDist = DamageRadius >>> 2;
            EndPoint = Locs(Location, WarnInternal(0, 0, FindDist));
            P = __NFUN_728__(EndPoint);
            // End:0x21B
            if((P.bWaterVolume / ) << )
            {
            }            
        }
        else
        {
            // End:0x246
            if(__NFUN_732__(Location, Square(DamageRadius), WaterPoint))
            {
                SplashActor = FindFriendSpawner(ExplosionSplashClass);
            }
        }
    }
    // End:0x2CD
    if(__NFUN_340__(SplashActor, none))
    {
        __NFUN_594__(DrawScaleChange, DrawScale3DChange);
        SplashActor.SystemSizeScale = FRand(SplashActor.default.SystemSizeScale, DrawScaleChange);
        SplashActor.__NFUN_645__(WaterPoint);
        SplashActor.__NFUN_652__(__NFUN_265__(0, 0, 0));
        SplashActor.RemoteRole = ROLE_None;
        SplashActor.ExecuteEffect(true);
    }
    return;
}

defaultproperties
{
    bMatchInstigatorScale=true
    bCanTouchInstigator=true
    SafetyTimer=0.01
    MaxSpeed=2000
    DamageFalloffStart=-0.25
    DamageRadiusDrawscaleExponent=1
    ImpactSoundSpeed=32
    WaterSplashStrength=-300
    WaterSplashRadius=64
    ExploWallOut=16
    ExplosionOffset=16
    MPDrawscaleSpeedExponent=0.75
    DeferredExplosionTimer=0.1
    DeferredExplosionTimerVariance=0.1
    bTelekineticable=true
    bCanShowSelf=true
    Physics=6
    bTraceShootable=false
    bRequestMeshAccurateMoveActorTrace=true
    bBlockActors=true
    bBlockPlayers=true
    bBlockCamera=false
    bIsProjectile=true
    bGameRelevant=true
    bBounce=true
    bAcceptsProjectors=false
    bAcceptsDecalProjectors=false
    bNetTemporary=true
    bNetInitialRotation=true
    bReplicateInstigator=true
    bDirectional=true
    bCollideActors=true
    bCollideWorld=true
    CollisionRadius=0
    CollisionHeight=0
    DrawType=2
    Texture=Texture'S_Camera'
    LifeSpan=140
    NetPriority=2.5
    SoundVolume=0
}