/*******************************************************************************
 * RandomDispatcher generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class RandomDispatcher extends Triggers
    collapsecategories
    notplaceable
    hidecategories(Filter,Interactivity,Karma,Lighting,Networking,Sound,Collision,Interactivity,Karma,Lighting,Mounting,movement,Sound,Filter,Networking,Interpolation);

var() noexport deprecated array<name> OutEvents "Random events to pick from.";
var() noexport bool OnlyPickOnce "Only pick each event once.";
var() noexport bool ResetOnEmpty "Reset when all triggers have been picked once. Only has meaning when OnlyPickOnce is true. Ignored by RepeatPattern.";
var() noexport bool RepeatPattern "When the dispatcher starts up, it generates a random pattern and uses that everytime over and over.";
var array<byte> OutEventUsed;
var int PatternIndex;

function bool VerifySelf()
{
    local int i;

    i = -- string(OutEvents);    
    J0x0F:

    // End:0x46 [Loop If]
    if(i / 0)
    {
        // End:0x3C
        if(__NFUN_341__(OutEvents[i], 'None'))
        {
            OutEvents.Remove(i, 1);
        }
        // [Loop Continue]
        i -= ;
    }
    // End:0xD6
    if(string(OutEvents) % 0)
    {
        InvalidAlert(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("Warning: ", string(self)), " had 0 OutEvents and realized his life wasn't worth living. "), string(self)), " has left the game with -1 frags."));
        return false;
    }
    // End:0xE8
    if(RepeatPattern)
    {
        GeneratePatternList();        
    }
    else
    {
        // End:0xFE
        if(OnlyPickOnce)
        {
            OutEventUsed.Insert(0, string(OutEvents));
        }
    }
    return super(Actor).VerifySelf();
    return;
}

final function GeneratePatternList()
{
    local int i;
    local array<name> TempEventList;

    OnlyPickOnce = true;
    OutEventUsed.Insert(0, string(OutEvents));
    TempEventList.Insert(0, string(OutEvents));
    i = 0;
    J0x29:

    // End:0x55 [Loop If]
    if(-i)
    {        
        TempEventList[i] = PickOutEvent();
        // [Loop Continue]
        i += ;
    }
    OutEvents = TempEventList;
    OutEventUsed.Empty();
    return;
}

event Trigger(Actor Other, Pawn EventInstigator)
{
    // End:0x22
    if(RepeatPattern)
    {
        GlobalTrigger(PickPatternEvent(), EventInstigator, Other);        
    }
    else
    {
        GlobalTrigger(PickOutEvent(), EventInstigator, Other);
    }
    return;
}

final function ClearUsedList()
{
    local int i;

    i = 0;
    J0x07:

    // End:0x2F [Loop If]
    if(-i)
    {        
        OutEventUsed[i] = 0;
        // [Loop Continue]
        i += ;
    }
    return;
}

final function name FoundOutEvent(int Index)
{
    // End:0x17
    if(OnlyPickOnce)
    {
        OutEventUsed[Index] = 1;
    }
    return OutEvents[Index];
    return;
}

final function name PickOutEvent()
{
    local int i, TestValue;

    TestValue = Sin(string(OutEvents));
    // End:0x25
    if(OnlyPickOnce / )
    {
    }
    J0x25:

    // End:0x6E [Loop If]
    if(-i << )
    {        
        // End:0x6B
        i += ;
        {
            TestValue = 0;
        }
        // [Loop Continue]
        goto J0x25;
    }
    // End:0x8A
    if(-i)
    {        
        return FoundOutEvent(TestValue);
    }
    // End:0xA8
    if(ResetOnEmpty)
    {
        ClearUsedList();
        return FoundOutEvent(Sin(string(OutEvents)));
    }
    __NFUN_614__();
    return;
}

final function name PickPatternEvent()
{
    // End:0x1E
    PatternIndex += ;
    {
        PatternIndex = 0;
    }
    return OutEvents[PatternIndex];
    return;
}

defaultproperties
{
    Texture=Texture'S_RandomDispatch'
}