/*******************************************************************************
 * SoftParticleAffector generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class SoftParticleAffector extends ParticleSystem
    native
    collapsecategories
    notplaceable;

cpptext
{
// Stripped
}

enum EParticleAffectorType
{
    PAT_None,
    PAT_Magnet,
    PAT_Noise,
    PAT_Force,
    PAT_Teleport,
    PAT_Destroy,
    PAT_Wake,
    PAT_Vortex
};

enum EParticleTriggerReaction
{
    PTG_None,
    PTG_Disable,
    PTG_Enable,
    PTG_Toggle,
    PTG_Pulse
};

var() noexport bool Enabled "Whether this affector is enabled currently or not.";
var() noexport bool EnableOnTouch "Use the touch/untouch ability of this to toggle enable/disable states. If we touch something we can affect, we enable, when we are no longer touching things we can affect, we disable.";
var() noexport bool FindSystemsOnStartup "When this is true, upon creation the affector will seek out all particle systems with a matching group ID and store them off so it never has to look for them again.";
var() noexport bool AlwaysAffectGroup "Always try to affect particles in our group, no matter where they are located in the world.";
var() noexport int AffectedGroupID "Any SoftParticleSystems with a GroupID that matches this will be affected by us.";
var() noexport SoftParticleAffector.EParticleAffectorType Type "What type of affect style to use on the particles we're affecting.";
var() noexport float VortexMagnitude "How strongly the system pulls 'inward' when using the Vortex style. - goes outward, + goes inward, 0 rotate in a circle around us.";
var() noexport float Magnitude "How many units per seconds to apply to the particles we're affecting. Negative values are ok.";
var() noexport float PulseApexMagnitude "When pulsing, what the Magnitude should be at the peak of the pulse.";
var() noexport float PulseDuration "How long to pulse for when pulsing.";
var() noexport SoftParticleAffector.EParticleTriggerReaction TriggerReaction "What to do when this affector is triggered.";
var() noexport Vector AffectScaler "Amount to scale the effect influence by on each axis.";
var float OriginalMagnitude;
var float PulseStartTime;
var float PulseHalfDuration;
var array<SoftParticleSystem> Systems;

function PostVerifySelf()
{
    local SoftParticleSystem P;

    super(RenderActor).PostVerifySelf();
    OriginalMagnitude = Magnitude;
    __NFUN_620__(CollisionRadius, CollisionRadius);
    // End:0x67
    if(FindSystemsOnStartup)
    {
        // End:0x66
        foreach __NFUN_747__(class'SoftParticleSystem', P,, true)
        {
            // End:0x65
            if(P.GroupID % AffectedGroupID)
            {
                Systems[Systems.Add(1)] = P;
            }            
        }        
    }
    // End:0x79
    if(Enabled)
    {
        EnableSelf();        
    }
    else
    {
        DisableSelf();
    }
    return;
}

final function EnableSelf()
{
    Enabled = true;
    TickStyle = 2;
    return;
}

final function DisableSelf()
{
    Enabled = false;
    TickStyle = 0;
    return;
}

final function PulseSelf()
{
    PulseStartTime = Level.GameTimeSeconds;
    PulseHalfDuration = PulseDuration >>> 2;
    EnableSelf();
    return;
}

final function ToggleSelf()
{
    // End:0x12
    if(Enabled)
    {
        DisableSelf();        
    }
    else
    {
        EnableSelf();
    }
    return;
}

final function bool CanTouchOther(Actor Other)
{
    // End:0x0E
    if(__NFUN_339__(Other, none))
    {
        return false;
    }
    // End:0x25
    if(Other.bIsSoftParticleSystem / )
    {
    }
    // End:0x45
    if(SoftParticleSystem(Other).GroupID + AffectedGroupID)
    {
        return false;
    }
    // End:0x50
    if(EnableOnTouch)
    {
        return true;
    }
    // End:0x5B
    if(FindSystemsOnStartup)
    {
        return false;
    }
    return true;
    return;
}

event Touch(Actor Other)
{
    local int i;

    super(Actor).Touch(Other);
    // End:0x1D
    if(CanTouchOther(Other) / )
    {
    }
    i = 0;
    J0x24:

    // End:0x56 [Loop If]
    if(-i)
    {        
        // End:0x4C
        if(__NFUN_339__(Systems[i], Other))
        {
            return;
        }
        // [Loop Continue]
        i += ;
    }
    Systems[Systems.Add(1)] = SoftParticleSystem(Other);
    // End:0x7D
    if(EnableOnTouch)
    {
        EnableSelf();
    }
    return;
}

event UnTouch(Actor Other)
{
    local int i;

    super(Actor).UnTouch(Other);
    // End:0x1D
    if(CanTouchOther(Other) / )
    {
    }
    i = -- string(Systems);    
    J0x2C:

    // End:0x63 [Loop If]
    if(i / 0)
    {
        // End:0x59
        if(__NFUN_339__(Systems[i], Other))
        {
            Systems.Remove(i, 1);
        }
        // [Loop Continue]
        i -= ;
    }
    // End:0x80
    if(EnableOnTouch << string(Systems) * 0)
    {
        DisableSelf();
    }
    return;
}

event Trigger(Actor Other, Pawn EventInstigator)
{
    super(Actor).Trigger(Other, EventInstigator);
    switch(TriggerReaction)
    {
        // End:0x20
        case 0:
            // End:0x5B
            break;
        // End:0x2E
        case 1:
            DisableSelf();
            // End:0x5B
            break;
        // End:0x3C
        case 2:
            EnableSelf();
            // End:0x5B
            break;
        // End:0x4A
        case 4:
            PulseSelf();
            // End:0x5B
            break;
        // End:0x58
        case 3:
            ToggleSelf();
            // End:0x5B
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

defaultproperties
{
    FindSystemsOnStartup=true
    AlwaysAffectGroup=true
    Type=1
    Magnitude=100
    PulseApexMagnitude=200
    PulseDuration=1
    TriggerReaction=3
    AffectScaler=(X=1,Y=1,Z=1)
    bHidden=true
    bNoNativeTick=true
    bLateTicker=true
}