/*******************************************************************************
 * TcpLink generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class TcpLink extends InternetLink
    transient
    native
    collapsecategories
    notplaceable
    hidecategories(movement,Collision,Lighting,LightColor);

enum ELinkState
{
    STATE_Initialized,
    STATE_Ready,
    STATE_Listening,
    STATE_Connecting,
    STATE_Connected,
    STATE_ListenClosePending,
    STATE_ConnectClosePending,
    STATE_ListenClosing,
    STATE_ConnectClosing
};

var TcpLink.ELinkState LinkState;
var IpAddr RemoteAddr;
var class<TcpLink> AcceptClass;
var const array<byte> SendFIFO;

// Export UTcpLink::execBindPort(FFrame&, void* const)
native(1140) final function int BindPort(optional int Port, optional bool bUseNextAvailable);

// Export UTcpLink::execListen(FFrame&, void* const)
native(1141) final function bool Listen();

// Export UTcpLink::execOpen(FFrame&, void* const)
native(1142) final function bool Open(IpAddr Addr);

// Export UTcpLink::execClose(FFrame&, void* const)
native(1143) final function bool Close();

// Export UTcpLink::execIsConnected(FFrame&, void* const)
native(1144) final function bool IsConnected();

// Export UTcpLink::execSendText(FFrame&, void* const)
native(1145) final function int SendText(coerce string str);

// Export UTcpLink::execSendBinary(FFrame&, void* const)
native(1146) final function int SendBinary(int Count, byte B[255]);

// Export UTcpLink::execReadText(FFrame&, void* const)
native(1147) final function int ReadText(out string str);

// Export UTcpLink::execReadBinary(FFrame&, void* const)
native(1148) final function int ReadBinary(int Count, out byte B[255]);

event Accepted()
{
    return;
}

event Opened()
{
    return;
}

event Closed()
{
    return;
}

event ReceivedText(string Text)
{
    return;
}

event ReceivedLine(string Line)
{
    return;
}

event ReceivedBinary(int Count, byte B[255])
{
    return;
}

defaultproperties
{
    TickStyle=1
}