/*******************************************************************************
 * TriggerAssignDoorMoverEx generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class TriggerAssignDoorMoverEx extends TriggerAssign
    collapsecategories
    notplaceable
    hidecategories(Filter,Interactivity,Karma,Lighting,Networking,Sound,Collision,Interpolation,movement);

var() noexport Object.EBitModifier NewNeverClose "Value to set for the bNeverClose flag on DoorMover.";
var() noexport Object.EBitModifier NewLocked "Value to set for the bLocked flag on DoorMoverEx.";
var() noexport Object.EBitModifier NewOpeningEventOnlyOnce "Value to set for the bOpeningEventOnlyOnce on DoorMoverEx.";
var() noexport Object.EBitModifier NewFullyOpenedEventOnlyOnce "Value to set for the bFullyOpenedEventOnlyOnce on DoorMoverEx.";
var() noexport Object.EBitModifier NewClosingEventOnlyOnce "Value to set for the bClosingEventOnlyOnce on DoorMoverEx.";
var() noexport Object.EBitModifier NewFullyClosedEventOnlyOnce "Value to set for the bFullyClosedEventOnlyOnce on DoorMoverEx.";
var() noexport bool bAssignOpeningEvent "If true, set OpeningEvent = NewOpeningEvent.";
var() noexport bool bAssignFullyOpenedEvent "If true, set FullyOpenedEvent = NewFullyOpenedEvent.";
var() noexport bool bAssignClosingEvent "If true, set ClosingEvent = NewClosingEvent.";
var() noexport bool bAssignFullyClosedEvent "If true, set FullyClosedEvent = NewFullyClosedEvent.";
var() noexport deprecated name NewOpeningEvent "Value to set for OpeningEvent if bAssignFullyOpenedEvent == true.";
var() noexport deprecated name NewFullyOpenedEvent "Value to set for FullyOpenedEvent if bAssignOpeningEvent == true.";
var() noexport deprecated name NewClosingEvent "Value to set for ClosingEvent if bAssignClosingEvent == true.";
var() noexport deprecated name NewFullyClosedEvent "Value to set for FullyClosedEvent if bAssignFullyClosedEvent == true.";
var() noexport bool bAssignFriend "If True, make NewFriend our Friend.";
var() noexport deprecated name NewFriendDoorTag "Tag of the Door to make our new friend.";
var() noexport bool bAssignAutoCloseTime "If true, assign a new auto close time.";
var() noexport float NewAutoCloseTime "New auto close time if bAssignAutoCloseTime.";

function DoAssign(Actor A)
{
    local int i;
    local DoorMoverEx D, f;

    D = DoorMoverEx(A);
    // End:0x247
    if(__NFUN_340__(D, none))
    {
        D.bNeverClose = __NFUN_346__(NewNeverClose, D.bNeverClose);
        D.bLocked = __NFUN_346__(NewLocked, D.bLocked);
        D.bOpeningEventOnlyOnce = __NFUN_346__(NewOpeningEventOnlyOnce, D.bOpeningEventOnlyOnce);
        D.bFullyOpenedEventOnlyOnce = __NFUN_346__(NewFullyOpenedEventOnlyOnce, D.bFullyOpenedEventOnlyOnce);
        D.bClosingEventOnlyOnce = __NFUN_346__(NewClosingEventOnlyOnce, D.bClosingEventOnlyOnce);
        D.bFullyClosedEventOnlyOnce = __NFUN_346__(NewFullyClosedEventOnlyOnce, D.bFullyClosedEventOnlyOnce);
        // End:0x130
        if(bAssignOpeningEvent)
        {
            D.OpeningEvent = NewOpeningEvent;
        }
        // End:0x14E
        if(bAssignFullyOpenedEvent)
        {
            D.FullyOpenedEvent = NewFullyOpenedEvent;
        }
        // End:0x16C
        if(bAssignClosingEvent)
        {
            D.ClosingEvent = NewClosingEvent;
        }
        // End:0x18A
        if(bAssignFullyClosedEvent)
        {
            D.FullyClosedEvent = NewFullyClosedEvent;
        }
        // End:0x219
        if(bAssignFriend)
        {
            D.RemoveFriends();
            D.FriendDoorTag = NewFriendDoorTag;
            D.FindAndSetupFriends();
            // End:0x216
            if(__NFUN_342__(NewFriendDoorTag, 'None'))
            {
                // End:0x215
                foreach __NFUN_747__(class'DoorMoverEx', f, NewFriendDoorTag)
                {
                    D.FriendDoors[D.FriendDoors.Add(1)] = f;                    
                }                
            }            
        }
        else
        {
            D.SetupFriends();
        }
        // End:0x247
        if(bAssignAutoCloseTime)
        {
            D.AutoCloseTime = NewAutoCloseTime;
        }
    }
    super.DoAssign(A);
    return;
}
