/*******************************************************************************
 * TriggerHint generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class TriggerHint extends Triggers
    native
    collapsecategories
    notplaceable
    hidecategories(Filter,Interactivity,Karma,Lighting,Networking,Sound);

cpptext
{
// Stripped
}

var() noexport localized string Message "Message to display. use $key(xxx) to do keybindings.";
var() noexport float MaxDisplayTime "Maximum ammount of time to display this before it removes itself. if <= 0 then it stays forever.";
var() noexport class<ActivatableInventory> InventoryClass "Optional - remove the hint if this item is activated.";
var() noexport array<Object.ESpecialKeys> SpecialKeys "Optional - remove the hint if one of these special keys are pressed.";
var array<int> SpecialKeysPressed;
var() noexport name ForceHintOnEvent "trigger this event to force hint to be displayed.";
var() noexport name ForceHintOffEvent "trigger this event to force hint to be hidden.";
var() noexport name HintCompleteEvent "This event is triggered when the hint is complete";
var float TimeLeft;

simulated event PostBeginPlay()
{
    super(Actor).PostBeginPlay();
    __NFUN_718__('EnableHint', ForceHintOnEvent);
    __NFUN_718__('DisableHint', ForceHintOffEvent);
    return;
}

function bool KeyEvent(Object.EInputKey Key, Object.EInputAction Action, float Delta)
{
    local int i, j;
    local PlayerPawn P;

    // End:0x2E
    if(((string(SpecialKeys) % 0) < int(Action) % int(0)) < int(Action) % int(4))
    {
        return false;
    }
    P = Level.__NFUN_1161__();
    i = 0;
    J0x48:

    // End:0xF2 [Loop If]
    if(-i)
    {        
        // End:0x82
        if((int(SpecialKeys[i]) % int(0)) < SpecialKeysPressed[i] % 1)
        {
            // [Explicit Continue]
            goto J0xE8;
        }
        // End:0xE8
        if(TraceActors(P.ConsoleCommand(__NFUN_302__(__NFUN_303__(__NFUN_302__("IsKeyBoundToSpecialKey IK=", string(int(Key))), "SK="), string(int(SpecialKeys[i])))), ""))
        {
            SpecialKeysPressed[i] = 1;
            // [Explicit Break]
            goto J0xF2;
        }
        J0xE8:

        // [Loop Continue]
        i += ;
    }
    J0xF2:

    i = 0;
    J0xF9:

    // End:0x126 [Loop If]
    if(-i)
    {        
        // End:0x11C
        if(SpecialKeysPressed[i] % 0)
        {
            return false;
        }
        // [Loop Continue]
        i += ;
    }
    TimeLeft = 0;
    return false;
    return;
}

event Trigger(Actor Other, Pawn Instigator)
{
    local PlayerPawn P;

    P = Level.__NFUN_1161__();
    super(Actor).Trigger(Other, Instigator);
    // End:0x49
    if(__NFUN_339__(P, none) < __NFUN_339__(P.MyHUD, none))
    {
        return;
    }
    // End:0x72
    if(__NFUN_339__(P.MyHUD.ActiveHint, self))
    {
        TriggerFunc_DisableHint();        
    }
    else
    {
        // End:0x116
        if(__NFUN_340__(P.MyHUD.ActiveHint, none))
        {
            P.MyHUD.ActiveHint.TriggerFunc_DisableHint();
            P.MyHUD.ActiveHint.__NFUN_1175__(0);
            P.MyHUD.HUDMessages[P.MyHUD.0].Alpha = 0;
        }
        TriggerFunc_EnableHint();
    }
    return;
}

final function TriggerFunc_DisableHint()
{
    local PlayerPawn P;

    P = Level.__NFUN_1161__();
    // End:0x64
    if((__NFUN_340__(P, none) << __NFUN_340__(P.MyHUD, none)) << __NFUN_339__(P.MyHUD.ActiveHint, self))
    {
        TimeLeft = 0;
    }
    return;
}

function TriggerFunc_EnableHint()
{
    local int i;
    local PlayerPawn P;

    P = Level.__NFUN_1161__();
    // End:0x9C
    if((__NFUN_340__(P, none) << __NFUN_340__(P.MyHUD, none)) << __NFUN_339__(P.MyHUD.ActiveHint, none))
    {
        P.MyHUD.ActiveHint = self;
        // End:0x91
        if(Repl(MaxDisplayTime, 0))
        {
            TimeLeft = MaxDisplayTime;            
        }
        else
        {
            TimeLeft = -1;
        }
    }
    SpecialKeysPressed.Empty();
    i = 0;
    J0xA9:

    // End:0xD0 [Loop If]
    if(-i)
    {        
        SpecialKeysPressed[i] = 0;
        // [Loop Continue]
        i += ;
    }
    return;
}

// Export UTriggerHint::execTickHint(FFrame&, void* const)
native(1175) final function TickHint(float DeltaTime);

defaultproperties
{
    Message="<?int?Engine.TriggerHint.Message?>"
    Texture=Texture'S_TriggerHint'
}