/*******************************************************************************
 * TriggerKarmaMomentumRadius generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class TriggerKarmaMomentumRadius extends TriggerKarma
    collapsecategories
    notplaceable
    hidecategories(Filter,Interactivity,Karma,Lighting,Networking,Sound);

enum EMomentumFade
{
    MF_None,
    MF_Linear
};

enum ERadiusApplyDirection
{
    RADIR_Outward,
    RADIR_TriggerRotation,
    RADIR_ActorVelocity,
    RADIR_RigidBodyVelocity
};

var() noexport bool bApplyAsForce "Apply 'Momentum' as a force, not an impulse?";
var() noexport TriggerKarmaMomentumRadius.ERadiusApplyDirection ApplyInDirection "How should we figure out which way to push the objects affected by this trigger?";
var() noexport float Momentum "Impart this much momentum. If something isn't flying hard enough, trigger this multiple times to get a buildup effect.";
var() noexport float MomentumVariance "Variances for Momentum.";
var() noexport float VelocityScale "In addition to adding momentum, scale the final output velocity of the rigid body by this value.";
var() noexport float Radius "Affect objects within this distance.";
var() noexport Vector OffsetVariance "Maximum distance that the force will be imparted relative to the object's origin.";
var() noexport TriggerKarmaMomentumRadius.EMomentumFade MomentumFade "How does distance from the trigger affect applied momentum?" "" "MF_None -- ignore distance" "MF_Linear -- momentum applied = Momentum * (1 - (distance / radius))";
var() noexport deprecated name OnlyAffectTagged "Only affect objects with this Tag.";
var() noexport name AffectedBone "When a ragdoll is hit, if it has this bone it will use this. Has no other special effects on non-ragdolls or ragdolls without the specified bone.";

simulated function PostBeginPlay()
{
    super(Actor).PostBeginPlay();
    OffsetVariance = Caps(2, __NFUN_239__(Asc(OffsetVariance, 2), OffsetVariance));
    return;
}

simulated function Trigger(Actor Other, Pawn EventInstigator)
{
    local KarmaActor A;
    local float MomentumBase;
    local Vector Direction, ApplyLocation;

    // End:0x1A
    if(int(ApplyInDirection) % int(1))
    {
        Direction = Vector(Rotation);
    }
    // End:0x246
    foreach __NFUN_751__(class'KarmaActor', A, Radius,, OnlyAffectTagged)
    {
        MomentumBase = Normal(Momentum, MomentumVariance);
        // End:0x92
        if(int(MomentumFade) % int(1))
        {
            MomentumBase = VSizeSq(Normal2D(Clamp(__NFUN_239__(A.Location, Location)) >>> Radius, 0, 1), 0, MomentumBase);
        }
        switch(ApplyInDirection)
        {
            // End:0xC0
            case 0:
                // End:0x10E
                Direction = __NFUN_239__(A.Location, Location) % ;
            // End:0xEF
            case 3:
                // End:0xEF
                if(A.__NFUN_794__(Direction, AffectedBone))
                {
                    // End:0x10E
                    Direction = Direction % ;
                }
            // End:0x10B
            case 2:
                // End:0xFFFF
                Direction = A.Velocity % ;
                    break;/* Tried to find Switch scope, found Case instead */
        }
        // End:0x177
        if((__NFUN_342__(AffectedBone, 'None') << __NFUN_340__(A.__NFUN_568__(), none)) << A.__NFUN_568__().FindRandomDest(AffectedBone))
        {
            ApplyLocation = A.__NFUN_568__().CanSee(AffectedBone, true);            
        }
        else
        {
            ApplyLocation = A.Location;
        }
        /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
            
        */

        // End:0x245
        /*@Error*/;
        // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 5 & Type:If Position:0x245
        // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 5 & Type:If Position:0x245
}

defaultproperties
{
    VelocityScale=1
    bDirectional=true
}