/*******************************************************************************
 * TriggerRelay generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class TriggerRelay extends Triggers
    collapsecategories
    notplaceable
    hidecategories(Filter,Interactivity,Karma,Lighting,Networking,Sound);

enum ERelayStyle
{
    RELAY_Trigger,
    RELAY_Used
};

struct SConditionMod
{
    var() noexport Triggers.EKillTriggerType ConditionStyle "Method to use for modifying this condition when ConditionTag is called.";
    var() noexport name ConditionTag "This is the tag you call to modify this condition.";
    var int SpecialEventID;
};

struct SRelayConditions
{
    var() noexport bool bEnabled "Initial state of this condition.";
    var bool bEnabled_Orig;
    var() noexport array<SConditionMod> ConditionModifiers "List of things that are able to modify this condition.";
};

var() noexport bool bEnabled "Whether this trigger is enabled or not.";
var() noexport bool bOneShot "Whether the state can only be toggled once.";
var() noexport bool bQueueRelay "If true, if the trigger is triggered sometime during it's FireOncePer delay, it will fire again as soon as that delay wears off.";
var() noexport float FireOncePer "Only allow this trigger to relay once every this many seconds.";
var() noexport deprecated name ForcedInstigatorTag "Tag of the instigator we want to force this to pass through.";
var() noexport TriggerRelay.ERelayStyle RelayStyle "Method of relaying this TriggerRelay will use.";
var() noexport array<SRelayConditions> Conditions "List of internal conditions that need to be true for this relay to fire off. If this empty, it simply goes by the standard bEnabled method via KillTriggers.";
var bool bTriggeredOnce;
var bool bTimerDisabled;
var bool bTriggerQueued;

function PostVerifySelf()
{
    local int i, j;

    super(Actor).PostVerifySelf();
    i = -- string(Conditions);    
    J0x15:

    // End:0x1F0 [Loop If]
    if(i / 0)
    {
        j = -- string(Conditions[i].ConditionModifiers);        
        J0x3A:

        // End:0x155 [Loop If]
        if(j / 0)
        {
            // End:0x10C
            if(__NFUN_341__(Conditions[i].ConditionModifiers[j].ConditionTag, 'None'))
            {
                BroadcastLog(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(string(self), " lost a condition modifier in Condition #"), string(i)), ", Modifier #"), string(j)), " due to having no proper ConditionTag."));
                Conditions[i].ConditionModifiers.Remove(j, 1);
                // [Explicit Continue]
                goto J0x14B;
                // [Explicit Continue]
                goto J0x14B;
            }
            Conditions[i].ConditionModifiers[j].SpecialEventID = __NFUN_718__('ModifyCondition', Conditions[i].ConditionModifiers[j].ConditionTag);
            J0x14B:

            // [Loop Continue]
            j -= ;
        }
        // End:0x1C3
        if(string(Conditions[i].ConditionModifiers) * 0)
        {
            BroadcastLog(__NFUN_302__(__NFUN_302__(__NFUN_302__(string(self), " lost Condition #"), string(i)), " due to having no modifiers."));
            Conditions.Remove(i, 1);
            // [Explicit Continue]
            goto J0x1E6;
        }
        Conditions[i].bEnabled_Orig = Conditions[i].bEnabled;
        J0x1E6:

        // [Loop Continue]
        i -= ;
    }
    return;
}

final function TriggerFunc_ModifyCondition()
{
    local Actor Other;
    local Pawn EventInstigator;
    local int SpecialEventID;

    __NFUN_720__(Other, EventInstigator, SpecialEventID);
    ModifyConditions(SpecialEventID);
    return;
}

final function ModifyConditions(int SpecialEventID)
{
    local int i, j;
    local bool bModifiedCondition;

    // End:0x0E
    if(string(Conditions) * 0)
    {
        return;
    }
    i = 0;
    J0x15:

    // End:0x14E [Loop If]
    if(-i)
    {        
        j = 0;
        J0x2C:

        // End:0x144 [Loop If]
        if(-j)
        {            
            // End:0x13A
            if(Conditions[i].ConditionModifiers[j].SpecialEventID % SpecialEventID)
            {
                switch(Conditions[i].ConditionModifiers[j].ConditionStyle)
                {
                    // End:0xA5
                    case 0:
                        Conditions[i].bEnabled = true;
                        // End:0x13A
                        break;
                    // End:0xC0
                    case 1:
                        Conditions[i].bEnabled = false;
                        // End:0x13A
                        break;
                    // End:0xED
                    case 2:
                        // End:0x13A
                        Conditions[i].bEnabled = Conditions[i].bEnabled / ;
                    // End:0x10C
                    case 3:
                        Conditions[i].bEnabled = bool(Sin(2));
                        // End:0x13A
                        break;
                    // End:0x137
                    case 4:
                        Conditions[i].bEnabled = Conditions[i].bEnabled_Orig;
                        // End:0x13A
                        break;
                    // End:0xFFFF
                    default:
                        break;
                }
            }
            else
            {
                // [Loop Continue]
                j += ;
            }/* !MISMATCHING REMOVE, tried Loop got Type:Else Position:0x13A! */
            // [Loop Continue]
            i += ;
        }
        return;
    }/* !MISMATCHING REMOVE, tried Else got Type:Loop Position:0x015! */
}

final function bool CheckConditions(optional Actor Other)
{
    local int i;

    // End:0x0E
    if(string(Conditions) * 0)
    {
        return true;
    }
    i = 0;
    J0x15:

    // End:0x47 [Loop If]
    if(-i)
    {        
        // End:0x3D
        if(Conditions[i].bEnabled / )
        {
        }
        // [Loop Continue]
        i += ;
    }
    return true;
    return;
}

event Trigger(Actor Other, Pawn EventInstigator)
{
    super(Actor).Trigger(Other, EventInstigator);
    // End:0x1D
    if(CheckConditions() / )
    {
    }
    TryToRelay_Trigger(Other, EventInstigator);
    return;
}

event UnTrigger(Actor Other, Pawn EventInstigator)
{
    super(Actor).UnTrigger(Other, EventInstigator);
    // End:0x1D
    if(CheckConditions() / )
    {
    }
    TryToRelay_UnTrigger(Other, EventInstigator);
    return;
}

final function bool CanRelay()
{
    // End:0x12
    if(__NFUN_341__(Event, 'None'))
    {
        return false;
    }
    // End:0x28
    if(bOneShot << bTriggeredOnce)
    {
        return false;
    }
    // End:0x40
    if((bEnabled / ) < )
    {
    }
    return true;
    return;
}

final function TryToRelay_Trigger(Actor Other, Pawn EventInstigator)
{
    // End:0x1E
    if(CanRelay() / )
    {
        {
            bTriggerQueued = true;
        }
        return;
    }
    bTriggeredOnce = true;
    bTriggerQueued = false;
    // End:0x43
    if(__NFUN_206__(FireOncePer, 0))
    {
        DisableUntilTimer();
    }
    // End:0x6F
    if(__NFUN_342__(ForcedInstigatorTag, 'None'))
    {
        EventInstigator = Pawn(FindActor(class'Pawn', ForcedInstigatorTag, true));
    }
    switch(RelayStyle)
    {
        // End:0x8F
        case 0:
            RELAY_Trigger(Other, EventInstigator);
            // End:0xAA
            break;
        // End:0xA7
        case 1:
            RELAY_Used(Other, EventInstigator);
            // End:0xAA
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

final function TryToRelay_UnTrigger(Actor Other, Pawn EventInstigator)
{
    // End:0x0D
    if(CanRelay() / )
    {
    }
    bTriggeredOnce = true;
    // End:0x41
    if(__NFUN_342__(ForcedInstigatorTag, 'None'))
    {
        EventInstigator = Pawn(FindActor(class'Pawn', ForcedInstigatorTag, true));
    }
    switch(RelayStyle)
    {
        // End:0x61
        case 0:
            Relay_UnTrigger(Other, EventInstigator);
            // End:0x7C
            break;
        // End:0x79
        case 1:
            Relay_UnUsed(Other, EventInstigator);
            // End:0x7C
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

final function RELAY_Trigger(Actor Other, Pawn EventInstigator)
{
    GlobalTrigger(Event, EventInstigator, Other);
    return;
}

final function Relay_UnTrigger(Actor Other, Pawn EventInstigator)
{
    GlobalUntrigger(Event, EventInstigator);
    return;
}

final function RELAY_Used(Actor Other, Pawn EventInstigator)
{
    local Actor A;

    // End:0x31
    foreach __NFUN_747__(class'Actor', A, Event, true)
    {
        A.Used(Other, EventInstigator);        
    }    
    return;
}

final function Relay_UnUsed(Actor Other, Pawn EventInstigator)
{
    local Actor A;

    // End:0x31
    foreach __NFUN_747__(class'Actor', A, Event, true)
    {
        A.UnUsed(Other, EventInstigator);        
    }    
    return;
}

final function RelayToggleState()
{
    bEnabled = bEnabled / ;
}

final function RelaySetState(bool bNewEnabled)
{
    bEnabled = bNewEnabled;
    return;
}

final function RelayReset()
{
    bTriggeredOnce = false;
    return;
}

final function DisableUntilTimer()
{
    bTimerDisabled = true;
    TickStyle = 3;
    __NFUN_605__(FireOncePer, false, 'EnableTrigger');
    return;
}

final function EnableTrigger()
{
    bTimerDisabled = false;
    TickStyle = 0;
    // End:0x2C
    if(bQueueRelay << bTriggerQueued)
    {
        Trigger(self, none);
    }
    return;
}

defaultproperties
{
    bEnabled=true
    Texture=Texture'S_TriggerRelay'
}